import { cx } from '@emotion/css';
import React__default, { Component } from 'react';
import { withTheme2 } from '../../themes/ThemeContext.js';
import { getSelectStyles } from './getSelectStyles.js';

class UnthemedValueContainer extends Component {
  render() {
    const { children } = this.props;
    const { selectProps } = this.props;
    if (selectProps && Array.isArray(children) && Array.isArray(children[0]) && selectProps.maxVisibleValues !== void 0 && !(selectProps.showAllSelectedWhenOpen && selectProps.menuIsOpen)) {
      const [valueChildren, ...otherChildren] = children;
      const truncatedValues = valueChildren.slice(0, selectProps.maxVisibleValues);
      return this.renderContainer([truncatedValues, ...otherChildren]);
    }
    return this.renderContainer(children);
  }
  renderContainer(children) {
    const { isMulti, theme } = this.props;
    const styles = getSelectStyles(theme);
    const className = cx(styles.valueContainer, isMulti && styles.valueContainerMulti);
    return /* @__PURE__ */ React__default.createElement("div", { className }, children);
  }
}
const ValueContainer = withTheme2(UnthemedValueContainer);

export { ValueContainer };
//# sourceMappingURL=ValueContainer.js.map
