import { css } from '@emotion/css';
import React__default, { PureComponent } from 'react';
import { withTheme2 } from '../../themes/ThemeContext.js';
import '@grafana/data';
import { stylesFactory } from '../../themes/stylesFactory.js';
import '@emotion/react';
import 'tinycolor2';
import { Icon } from '../Icon/Icon.js';

const getSelectOptionGroupStyles = stylesFactory((theme) => {
  return {
    header: css`
      display: flex;
      align-items: center;
      justify-content: flex-start;
      justify-items: center;
      cursor: pointer;
      padding: 7px 10px;
      width: 100%;
      border-bottom: 1px solid ${theme.colors.background.secondary};

      &:hover {
        color: ${theme.colors.text.maxContrast};
      }
    `,
    label: css`
      flex-grow: 1;
    `,
    icon: css`
      padding-right: 2px;
    `
  };
});
class UnthemedSelectOptionGroup extends PureComponent {
  constructor() {
    super(...arguments);
    this.state = {
      expanded: false
    };
    this.onToggleChildren = () => {
      this.setState((prevState) => ({
        expanded: !prevState.expanded
      }));
    };
  }
  componentDidMount() {
    if (this.props.data.expanded) {
      this.setState({ expanded: true });
    } else if (this.props.selectProps && this.props.selectProps.value) {
      const { value } = this.props.selectProps.value;
      if (value && this.props.options.some((option) => option.value === value)) {
        this.setState({ expanded: true });
      }
    }
  }
  componentDidUpdate(nextProps) {
    if (nextProps.selectProps.inputValue !== "") {
      this.setState({ expanded: true });
    }
  }
  render() {
    const { children, label, theme } = this.props;
    const { expanded } = this.state;
    const styles = getSelectOptionGroupStyles(theme);
    return /* @__PURE__ */ React__default.createElement("div", null, /* @__PURE__ */ React__default.createElement("div", { className: styles.header, onClick: this.onToggleChildren }, /* @__PURE__ */ React__default.createElement("span", { className: styles.label }, label), /* @__PURE__ */ React__default.createElement(Icon, { className: styles.icon, name: expanded ? "angle-up" : "angle-down" }), " "), expanded && children);
  }
}
const SelectOptionGroup = withTheme2(UnthemedSelectOptionGroup);

export { SelectOptionGroup };
//# sourceMappingURL=SelectOptionGroup.js.map
