import { cx } from '@emotion/css';
import { max } from 'lodash';
import React__default from 'react';
import { FixedSizeList } from 'react-window';
import { toIconName } from '@grafana/data';
import { useTheme2 } from '../../themes/ThemeContext.js';
import { CustomScrollbar } from '../CustomScrollbar/CustomScrollbar.js';
import { Icon } from '../Icon/Icon.js';
import { getSelectStyles } from './getSelectStyles.js';

var __defProp = Object.defineProperty;
var __defProps = Object.defineProperties;
var __getOwnPropDescs = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols = Object.getOwnPropertySymbols;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __propIsEnum = Object.prototype.propertyIsEnumerable;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp.call(b, prop))
      __defNormalProp(a, prop, b[prop]);
  if (__getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(b)) {
      if (__propIsEnum.call(b, prop))
        __defNormalProp(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps = (a, b) => __defProps(a, __getOwnPropDescs(b));
const SelectMenu = ({ children, maxHeight, innerRef, innerProps }) => {
  const theme = useTheme2();
  const styles = getSelectStyles(theme);
  return /* @__PURE__ */ React__default.createElement("div", __spreadProps(__spreadValues({}, innerProps), { className: styles.menu, style: { maxHeight }, "aria-label": "Select options menu" }), /* @__PURE__ */ React__default.createElement(CustomScrollbar, { scrollRefCallback: innerRef, autoHide: false, autoHeightMax: "inherit", hideHorizontalTrack: true }, children));
};
SelectMenu.displayName = "SelectMenu";
const VIRTUAL_LIST_ITEM_HEIGHT = 37;
const VIRTUAL_LIST_WIDTH_ESTIMATE_MULTIPLIER = 7;
const VirtualizedSelectMenu = ({ children, maxHeight, options, getValue }) => {
  var _a;
  const theme = useTheme2();
  const styles = getSelectStyles(theme);
  const [value] = getValue();
  const valueIndex = value ? options.findIndex((option) => option.value === value.value) : 0;
  const initialOffset = valueIndex * VIRTUAL_LIST_ITEM_HEIGHT;
  if (!Array.isArray(children)) {
    return null;
  }
  const longestOption = (_a = max(options.map((option) => {
    var _a2;
    return (_a2 = option.label) == null ? void 0 : _a2.length;
  }))) != null ? _a : 0;
  const widthEstimate = longestOption * VIRTUAL_LIST_WIDTH_ESTIMATE_MULTIPLIER;
  const heightEstimate = Math.min(options.length * VIRTUAL_LIST_ITEM_HEIGHT, maxHeight);
  return /* @__PURE__ */ React__default.createElement(
    FixedSizeList,
    {
      className: styles.menu,
      height: heightEstimate,
      width: widthEstimate,
      "aria-label": "Select options menu",
      itemCount: children.length,
      itemSize: VIRTUAL_LIST_ITEM_HEIGHT,
      initialScrollOffset: initialOffset
    },
    ({ index, style }) => /* @__PURE__ */ React__default.createElement("div", { style: __spreadProps(__spreadValues({}, style), { overflow: "hidden" }) }, children[index])
  );
};
VirtualizedSelectMenu.displayName = "VirtualizedSelectMenu";
const SelectMenuOptions = ({
  children,
  data,
  innerProps,
  innerRef,
  isFocused,
  isSelected,
  renderOptionLabel
}) => {
  const theme = useTheme2();
  const styles = getSelectStyles(theme);
  const icon = data.icon ? toIconName(data.icon) : void 0;
  return /* @__PURE__ */ React__default.createElement(
    "div",
    __spreadProps(__spreadValues({
      ref: innerRef,
      className: cx(
        styles.option,
        isFocused && styles.optionFocused,
        isSelected && styles.optionSelected,
        data.isDisabled && styles.optionDisabled
      )
    }, innerProps), {
      "aria-label": "Select option",
      title: data.title
    }),
    icon && /* @__PURE__ */ React__default.createElement(Icon, { name: icon, className: styles.optionIcon }),
    data.imgUrl && /* @__PURE__ */ React__default.createElement("img", { className: styles.optionImage, src: data.imgUrl, alt: data.label || data.value }),
    /* @__PURE__ */ React__default.createElement("div", { className: styles.optionBody }, /* @__PURE__ */ React__default.createElement("span", null, renderOptionLabel ? renderOptionLabel(data) : children), data.description && /* @__PURE__ */ React__default.createElement("div", { className: styles.optionDescription }, data.description), data.component && /* @__PURE__ */ React__default.createElement(data.component, null))
  );
};
SelectMenuOptions.displayName = "SelectMenuOptions";

export { SelectMenu, SelectMenuOptions, VirtualizedSelectMenu };
//# sourceMappingURL=SelectMenu.js.map
