import { cx, css } from '@emotion/css';
import React__default from 'react';
import { LoadingState } from '@grafana/data';
import { selectors } from '@grafana/e2e-selectors';
import { useTheme2, useStyles2 } from '../../themes/ThemeContext.js';
import 'memoize-one';
import '@emotion/react';
import 'tinycolor2';
import { DelayRender } from '../../utils/DelayRender.js';
import { Icon } from '../Icon/Icon.js';
import { LoadingBar } from '../LoadingBar/LoadingBar.js';
import { Tooltip } from '../Tooltip/Tooltip.js';
import { HoverWidget } from './HoverWidget.js';
import { PanelDescription } from './PanelDescription.js';
import { PanelMenu } from './PanelMenu.js';
import { PanelStatus } from './PanelStatus.js';
import { TitleItem } from './TitleItem.js';

function PanelChrome({
  width,
  height,
  children,
  padding = "md",
  title = "",
  description = "",
  displayMode = "default",
  titleItems,
  menu,
  dragClass,
  dragClassCancel,
  hoverHeader = false,
  hoverHeaderOffset,
  loadingState,
  statusMessage,
  statusMessageOnClick,
  leftItems,
  actions,
  onCancelQuery,
  onOpenMenu
}) {
  const theme = useTheme2();
  const styles = useStyles2(getStyles);
  const hasHeader = !hoverHeader;
  const showOnHoverClass = "show-on-hover";
  const headerHeight = getHeaderHeight(theme, hasHeader);
  const { contentStyle, innerWidth, innerHeight } = getContentStyle(padding, theme, width, headerHeight, height);
  const headerStyles = {
    height: headerHeight,
    cursor: dragClass ? "move" : "auto"
  };
  const containerStyles = { width, height };
  if (displayMode === "transparent") {
    containerStyles.backgroundColor = "transparent";
    containerStyles.border = "none";
  }
  if (leftItems) {
    actions = leftItems;
  }
  const testid = title ? selectors.components.Panels.Panel.title(title) : "Panel";
  const headerContent = /* @__PURE__ */ React__default.createElement(React__default.Fragment, null, title && /* @__PURE__ */ React__default.createElement("h6", { title, className: styles.title }, title), /* @__PURE__ */ React__default.createElement("div", { className: cx(styles.titleItems, dragClassCancel), "data-testid": "title-items-container" }, /* @__PURE__ */ React__default.createElement(PanelDescription, { description, className: dragClassCancel }), titleItems), loadingState === LoadingState.Streaming && /* @__PURE__ */ React__default.createElement(Tooltip, { content: onCancelQuery ? "Stop streaming" : "Streaming" }, /* @__PURE__ */ React__default.createElement(TitleItem, { className: dragClassCancel, "data-testid": "panel-streaming", onClick: onCancelQuery }, /* @__PURE__ */ React__default.createElement(Icon, { name: "circle-mono", size: "md", className: styles.streaming }))), loadingState === LoadingState.Loading && onCancelQuery && /* @__PURE__ */ React__default.createElement(DelayRender, { delay: 2e3 }, /* @__PURE__ */ React__default.createElement(Tooltip, { content: "Cancel query" }, /* @__PURE__ */ React__default.createElement(
    TitleItem,
    {
      className: cx(dragClassCancel, styles.pointer),
      "data-testid": "panel-cancel-query",
      onClick: onCancelQuery
    },
    /* @__PURE__ */ React__default.createElement(Icon, { name: "sync-slash", size: "md" })
  ))), /* @__PURE__ */ React__default.createElement("div", { className: styles.rightAligned }, actions && /* @__PURE__ */ React__default.createElement("div", { className: styles.rightActions }, itemsRenderer(actions, (item) => item))));
  return /* @__PURE__ */ React__default.createElement("div", { className: styles.container, style: containerStyles, "data-testid": testid }, /* @__PURE__ */ React__default.createElement("div", { className: styles.loadingBarContainer }, loadingState === LoadingState.Loading ? /* @__PURE__ */ React__default.createElement(LoadingBar, { width, ariaLabel: "Panel loading bar" }) : null), hoverHeader && /* @__PURE__ */ React__default.createElement(React__default.Fragment, null, /* @__PURE__ */ React__default.createElement(
    HoverWidget,
    {
      menu,
      title,
      offset: hoverHeaderOffset,
      dragClass,
      onOpenMenu
    },
    headerContent
  ), statusMessage && /* @__PURE__ */ React__default.createElement("div", { className: styles.errorContainerFloating }, /* @__PURE__ */ React__default.createElement(PanelStatus, { message: statusMessage, onClick: statusMessageOnClick, ariaLabel: "Panel status" }))), hasHeader && /* @__PURE__ */ React__default.createElement("div", { className: cx(styles.headerContainer, dragClass), style: headerStyles, "data-testid": "header-container" }, statusMessage && /* @__PURE__ */ React__default.createElement("div", { className: dragClassCancel }, /* @__PURE__ */ React__default.createElement(PanelStatus, { message: statusMessage, onClick: statusMessageOnClick, ariaLabel: "Panel status" })), headerContent, menu && /* @__PURE__ */ React__default.createElement(
    PanelMenu,
    {
      menu,
      title,
      placement: "bottom-end",
      menuButtonClass: cx(styles.menuItem, dragClassCancel, showOnHoverClass),
      onOpenMenu
    }
  )), /* @__PURE__ */ React__default.createElement("div", { className: styles.content, style: contentStyle }, children(innerWidth, innerHeight)));
}
const itemsRenderer = (items, renderer) => {
  const toRender = React__default.Children.toArray(items).filter(Boolean);
  return toRender.length > 0 ? renderer(toRender) : null;
};
const getHeaderHeight = (theme, hasHeader) => {
  if (hasHeader) {
    return theme.spacing.gridSize * theme.components.panel.headerHeight;
  }
  return 0;
};
const getContentStyle = (padding, theme, width, headerHeight, height) => {
  const chromePadding = (padding === "md" ? theme.components.panel.padding : 0) * theme.spacing.gridSize;
  const panelPadding = chromePadding * 2;
  const panelBorder = 1 * 2;
  const innerWidth = width - panelPadding - panelBorder;
  const innerHeight = height - headerHeight - panelPadding - panelBorder;
  const contentStyle = {
    padding: chromePadding
  };
  return { contentStyle, innerWidth, innerHeight };
};
const getStyles = (theme) => {
  const { background, borderColor, padding } = theme.components.panel;
  return {
    container: css({
      label: "panel-container",
      backgroundColor: background,
      border: `1px solid ${borderColor}`,
      position: "relative",
      borderRadius: theme.shape.borderRadius(1),
      height: "100%",
      display: "flex",
      flexDirection: "column",
      flex: "1 1 0",
      ".show-on-hover": {
        visibility: "hidden",
        opacity: "0"
      },
      "&:focus-visible, &:hover": {
        // only show menu icon on hover or focused panel
        ".show-on-hover": {
          visibility: "visible",
          opacity: "1"
        }
      },
      "&:focus-visible": {
        outline: `1px solid ${theme.colors.action.focus}`
      },
      "&:focus-within": {
        ".show-on-hover": {
          visibility: "visible",
          opacity: "1"
        }
      }
    }),
    loadingBarContainer: css({
      label: "panel-loading-bar-container",
      position: "absolute",
      top: 0,
      width: "100%",
      overflow: "hidden"
    }),
    content: css({
      label: "panel-content",
      flexGrow: 1,
      contain: "strict"
    }),
    headerContainer: css({
      label: "panel-header",
      display: "flex",
      alignItems: "center"
    }),
    pointer: css({
      cursor: "pointer"
    }),
    streaming: css({
      label: "panel-streaming",
      marginRight: 0,
      color: theme.colors.success.text,
      "&:hover": {
        color: theme.colors.success.text
      }
    }),
    title: css({
      label: "panel-title",
      marginBottom: 0,
      // override default h6 margin-bottom
      padding: theme.spacing(0, padding),
      textOverflow: "ellipsis",
      overflow: "hidden",
      whiteSpace: "nowrap",
      fontSize: theme.typography.h6.fontSize,
      fontWeight: theme.typography.h6.fontWeight
    }),
    items: css({
      display: "flex"
    }),
    item: css({
      display: "flex",
      justifyContent: "center",
      alignItems: "center"
    }),
    hiddenMenu: css({
      visibility: "hidden"
    }),
    menuItem: css({
      label: "panel-menu",
      border: "none",
      background: theme.colors.secondary.main,
      "&:hover": {
        background: theme.colors.secondary.shade
      }
    }),
    errorContainerFloating: css({
      label: "error-container",
      position: "absolute",
      left: 0,
      top: 0,
      zIndex: theme.zIndex.tooltip
    }),
    rightActions: css({
      display: "flex",
      padding: theme.spacing(0, padding),
      gap: theme.spacing(1)
    }),
    rightAligned: css({
      label: "right-aligned-container",
      marginLeft: "auto",
      display: "flex",
      alignItems: "center"
    }),
    titleItems: css({
      display: "flex",
      height: "100%"
    })
  };
};

export { PanelChrome };
//# sourceMappingURL=PanelChrome.js.map
