import { cx, css } from '@emotion/css';
import React__default, { useRef, useCallback, useState } from 'react';
import { useStyles2 } from '../../themes/ThemeContext.js';
import '@grafana/data';
import 'memoize-one';
import '@emotion/react';
import 'tinycolor2';
import { Icon } from '../Icon/Icon.js';
import { PanelMenu } from './PanelMenu.js';

function HoverWidget({ menu, title, dragClass, children, offset = -32, onOpenMenu }) {
  const styles = useStyles2(getStyles);
  const draggableRef = useRef(null);
  const onPointerDown = useCallback((e) => {
    var _a;
    (_a = draggableRef.current) == null ? void 0 : _a.setPointerCapture(e.pointerId);
  }, []);
  const onPointerUp = useCallback((e) => {
    var _a;
    (_a = draggableRef.current) == null ? void 0 : _a.releasePointerCapture(e.pointerId);
  }, []);
  const [menuOpen, setMenuOpen] = useState(false);
  if (children === void 0 || React__default.Children.count(children) === 0) {
    return null;
  }
  return /* @__PURE__ */ React__default.createElement(
    "div",
    {
      className: cx(styles.container, { "show-on-hover": !menuOpen }),
      style: { top: `${offset}px` },
      "data-testid": "hover-header-container"
    },
    dragClass && /* @__PURE__ */ React__default.createElement(
      "div",
      {
        className: cx(styles.square, styles.draggable, dragClass),
        onPointerDown,
        onPointerUp,
        ref: draggableRef
      },
      /* @__PURE__ */ React__default.createElement(Icon, { name: "expand-arrows", className: styles.draggableIcon })
    ),
    !title && /* @__PURE__ */ React__default.createElement("h6", { className: cx(styles.untitled, styles.draggable, dragClass) }, "Untitled"),
    children,
    menu && /* @__PURE__ */ React__default.createElement(
      PanelMenu,
      {
        menu,
        title,
        placement: "bottom",
        menuButtonClass: styles.menuButton,
        onVisibleChange: setMenuOpen,
        onOpenMenu
      }
    )
  );
}
function getStyles(theme) {
  return {
    hidden: css({
      visibility: "hidden",
      opacity: "0"
    }),
    container: css({
      label: "hover-container-widget",
      transition: `all .1s linear`,
      display: "flex",
      position: "absolute",
      zIndex: 1,
      right: 0,
      boxSizing: "content-box",
      alignItems: "center",
      background: theme.colors.background.secondary,
      color: theme.colors.text.primary,
      border: `1px solid ${theme.colors.border.weak}`,
      borderRadius: theme.shape.radius.default,
      height: theme.spacing(4),
      boxShadow: theme.shadows.z1
    }),
    square: css({
      display: "flex",
      justifyContent: "center",
      alignItems: "center",
      width: theme.spacing(4),
      height: "100%"
    }),
    draggable: css({
      cursor: "move",
      // mobile do not support draggable panels
      [theme.breakpoints.down("md")]: {
        display: "none"
      }
    }),
    menuButton: css({
      // Background and border are overriden when topnav toggle is disabled
      background: "inherit",
      border: "none",
      "&:hover": {
        background: theme.colors.secondary.main
      }
    }),
    untitled: css({
      color: theme.colors.text.disabled,
      fontStyle: "italic",
      padding: theme.spacing(0, 1),
      marginBottom: 0
    }),
    draggableIcon: css({
      transform: "rotate(45deg)",
      color: theme.colors.text.secondary,
      "&:hover": {
        color: theme.colors.text.primary
      }
    })
  };
}

export { HoverWidget };
//# sourceMappingURL=HoverWidget.js.map
