import MonacoEditor, { useMonaco, loader } from '@monaco-editor/react';
import React__default, { useEffect } from 'react';
import { useTheme2 } from '../../themes/ThemeContext.js';
import '@grafana/data';
import 'memoize-one';
import '@emotion/react';
import 'tinycolor2';
import defineThemes from './theme.js';

var __defProp = Object.defineProperty;
var __getOwnPropSymbols = Object.getOwnPropertySymbols;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __propIsEnum = Object.prototype.propertyIsEnumerable;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp.call(b, prop))
      __defNormalProp(a, prop, b[prop]);
  if (__getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(b)) {
      if (__propIsEnum.call(b, prop))
        __defNormalProp(a, prop, b[prop]);
    }
  return a;
};
let initalized = false;
function initMonaco() {
  var _a;
  if (initalized) {
    return;
  }
  loader.config({
    paths: {
      vs: ((_a = window.__grafana_public_path__) != null ? _a : "public/") + "lib/monaco/min/vs"
    }
  });
  initalized = true;
  loader.init().then((monaco) => {
    defineThemes(monaco);
  });
}
const ReactMonacoEditor = (props) => {
  const theme = useTheme2();
  const monaco = useMonaco();
  useEffect(() => {
    if (monaco != null) {
      defineThemes(monaco, theme);
    }
  }, [monaco, theme]);
  initMonaco();
  const monacoTheme = theme.isDark ? "grafana-dark" : "grafana-light";
  return /* @__PURE__ */ React__default.createElement(MonacoEditor, __spreadValues({ theme: monacoTheme }, props));
};

export { ReactMonacoEditor };
//# sourceMappingURL=ReactMonacoEditor.js.map
