import { css } from '@emotion/css';
import React__default, { PureComponent } from 'react';
import { withTheme2 } from '../../themes/ThemeContext.js';
import '@grafana/data';
import 'memoize-one';
import '@emotion/react';
import 'tinycolor2';
import { getAllFields } from './logParser.js';

class UnThemedLogRowMessageDetectedFields extends PureComponent {
  render() {
    const { row, showDetectedFields, getFieldLinks, wrapLogMessage } = this.props;
    const fields = getAllFields(row, getFieldLinks);
    const wrapClassName = wrapLogMessage ? "" : css`
          white-space: nowrap;
        `;
    const line = showDetectedFields.map((parsedKey) => {
      const field = fields.find((field2) => {
        const { key } = field2;
        return key === parsedKey;
      });
      if (field) {
        return `${parsedKey}=${field.value}`;
      }
      return null;
    }).filter((s) => s !== null).join(" ");
    return /* @__PURE__ */ React__default.createElement("td", { className: wrapClassName }, line);
  }
}
const LogRowMessageDetectedFields = withTheme2(UnThemedLogRowMessageDetectedFields);
LogRowMessageDetectedFields.displayName = "LogRowMessageDetectedFields";

export { LogRowMessageDetectedFields };
//# sourceMappingURL=LogRowMessageDetectedFields.js.map
