import { cx, css } from '@emotion/css';
import React__default, { PureComponent } from 'react';
import { withTheme2 } from '../../themes/ThemeContext.js';
import '@grafana/data';
import 'memoize-one';
import '@emotion/react';
import 'tinycolor2';
import { ClipboardButton } from '../ClipboardButton/ClipboardButton.js';
import { DataLinkButton } from '../DataLinks/DataLinkButton.js';
import { IconButton } from '../IconButton/IconButton.js';
import { LogLabelStats } from './LogLabelStats.js';
import { getLogRowStyles } from './getLogRowStyles.js';

const getStyles = (theme) => {
  return {
    noHoverBackground: css`
      label: noHoverBackground;
      :hover {
        background-color: transparent;
      }
    `,
    hoverCursor: css`
      label: hoverCursor;
      cursor: pointer;
    `,
    wordBreakAll: css`
      label: wordBreakAll;
      word-break: break-all;
    `,
    showingField: css`
      color: ${theme.colors.primary.text};
    `,
    hoverValueCopy: css`
      margin: ${theme.spacing(0, 0, 0, 1.2)};
      position: absolute;
      top: 0px;
      justify-content: center;
      border-radius: ${theme.shape.radius.circle};
      width: 26px;
      height: 26px;
    `,
    wrapLine: css`
      label: wrapLine;
      white-space: pre-wrap;
    `
  };
};
class UnThemedLogDetailsRow extends PureComponent {
  constructor() {
    super(...arguments);
    this.state = {
      showFieldsStats: false,
      fieldCount: 0,
      fieldStats: null,
      mouseOver: false
    };
    this.showField = () => {
      const { onClickShowDetectedField, parsedKey } = this.props;
      if (onClickShowDetectedField) {
        onClickShowDetectedField(parsedKey);
      }
    };
    this.hideField = () => {
      const { onClickHideDetectedField, parsedKey } = this.props;
      if (onClickHideDetectedField) {
        onClickHideDetectedField(parsedKey);
      }
    };
    this.filterLabel = () => {
      const { onClickFilterLabel, parsedKey, parsedValue } = this.props;
      if (onClickFilterLabel) {
        onClickFilterLabel(parsedKey, parsedValue);
      }
    };
    this.filterOutLabel = () => {
      const { onClickFilterOutLabel, parsedKey, parsedValue } = this.props;
      if (onClickFilterOutLabel) {
        onClickFilterOutLabel(parsedKey, parsedValue);
      }
    };
    this.showStats = () => {
      const { showFieldsStats } = this.state;
      if (!showFieldsStats) {
        const fieldStats = this.props.getStats();
        const fieldCount = fieldStats ? fieldStats.reduce((sum, stat) => sum + stat.count, 0) : 0;
        this.setState({ fieldStats, fieldCount });
      }
      this.toggleFieldsStats();
    };
  }
  toggleFieldsStats() {
    this.setState((state) => {
      return {
        showFieldsStats: !state.showFieldsStats
      };
    });
  }
  hoverValueCopy() {
    const mouseOver = !this.state.mouseOver;
    this.setState({ mouseOver });
  }
  render() {
    const {
      theme,
      parsedKey,
      parsedValue,
      isLabel,
      links,
      showDetectedFields,
      wrapLogMessage,
      onClickShowDetectedField,
      onClickHideDetectedField,
      onClickFilterLabel,
      onClickFilterOutLabel
    } = this.props;
    const { showFieldsStats, fieldStats, fieldCount, mouseOver } = this.state;
    const styles = getStyles(theme);
    const style = getLogRowStyles(theme);
    const hasDetectedFieldsFunctionality = onClickShowDetectedField && onClickHideDetectedField;
    const hasFilteringFunctionality = onClickFilterLabel && onClickFilterOutLabel;
    const toggleFieldButton = !isLabel && showDetectedFields && showDetectedFields.includes(parsedKey) ? /* @__PURE__ */ React__default.createElement(IconButton, { name: "eye", className: styles.showingField, title: "Hide this field", onClick: this.hideField }) : /* @__PURE__ */ React__default.createElement(IconButton, { name: "eye", title: "Show this field instead of the message", onClick: this.showField });
    return /* @__PURE__ */ React__default.createElement("tr", { className: cx(style.logDetailsValue, { [styles.noHoverBackground]: showFieldsStats }) }, /* @__PURE__ */ React__default.createElement("td", { className: style.logsDetailsIcon }, /* @__PURE__ */ React__default.createElement(IconButton, { name: "signal", title: "Ad-hoc statistics", onClick: this.showStats })), hasFilteringFunctionality && isLabel && /* @__PURE__ */ React__default.createElement(React__default.Fragment, null, /* @__PURE__ */ React__default.createElement("td", { className: style.logsDetailsIcon }, /* @__PURE__ */ React__default.createElement(IconButton, { name: "search-plus", title: "Filter for value", onClick: this.filterLabel })), /* @__PURE__ */ React__default.createElement("td", { className: style.logsDetailsIcon }, /* @__PURE__ */ React__default.createElement(IconButton, { name: "search-minus", title: "Filter out value", onClick: this.filterOutLabel }))), hasDetectedFieldsFunctionality && !isLabel && /* @__PURE__ */ React__default.createElement("td", { className: style.logsDetailsIcon, colSpan: 2 }, toggleFieldButton), /* @__PURE__ */ React__default.createElement("td", { className: style.logDetailsLabel }, parsedKey), /* @__PURE__ */ React__default.createElement(
      "td",
      {
        className: cx(styles.wordBreakAll, wrapLogMessage && styles.wrapLine),
        onMouseEnter: this.hoverValueCopy.bind(this),
        onMouseLeave: this.hoverValueCopy.bind(this)
      },
      parsedValue,
      mouseOver && /* @__PURE__ */ React__default.createElement(
        ClipboardButton,
        {
          getText: () => parsedValue,
          title: "Copy value to clipboard",
          fill: "text",
          variant: "secondary",
          icon: "copy",
          size: "sm",
          className: styles.hoverValueCopy
        }
      ),
      links == null ? void 0 : links.map((link) => /* @__PURE__ */ React__default.createElement("span", { key: link.title }, "\xA0", /* @__PURE__ */ React__default.createElement(DataLinkButton, { link }))),
      showFieldsStats && /* @__PURE__ */ React__default.createElement(
        LogLabelStats,
        {
          stats: fieldStats,
          label: parsedKey,
          value: parsedValue,
          rowCount: fieldCount,
          isLabel
        }
      )
    ));
  }
}
const LogDetailsRow = withTheme2(UnThemedLogDetailsRow);
LogDetailsRow.displayName = "LogDetailsRow";

export { LogDetailsRow };
//# sourceMappingURL=LogDetailsRow.js.map
