import { css, cx } from '@emotion/css';
import React__default, { PureComponent } from 'react';
import '../../themes/ThemeContext.js';
import '@grafana/data';
import { stylesFactory } from '../../themes/stylesFactory.js';
import '@emotion/react';
import 'tinycolor2';

const getStyles = stylesFactory((inlineList = false) => ({
  list: css`
    list-style-type: none;
    margin: 0;
    padding: 0;
  `,
  item: css`
    display: ${inlineList && "inline-block" || "block"};
  `
}));
class AbstractList extends PureComponent {
  constructor(props) {
    super(props);
  }
  render() {
    const { items, renderItem, getItemKey, className, inline } = this.props;
    const styles = getStyles(inline);
    return /* @__PURE__ */ React__default.createElement("ul", { className: cx(styles.list, className) }, items.map((item, i) => {
      return /* @__PURE__ */ React__default.createElement("li", { className: styles.item, key: getItemKey ? getItemKey(item) : i }, renderItem(item, i));
    }));
  }
}

export { AbstractList };
//# sourceMappingURL=AbstractList.js.map
