import { cx, css, keyframes } from '@emotion/css';
import React__default, { useState } from 'react';
import { usePopper } from 'react-popper';
import { useStyles2 } from '../../themes/ThemeContext.js';
import '@grafana/data';
import 'memoize-one';
import '@emotion/react';
import 'tinycolor2';
import { Icon } from '../Icon/Icon.js';
import { Portal } from '../Portal/Portal.js';

var __defProp = Object.defineProperty;
var __defProps = Object.defineProperties;
var __getOwnPropDescs = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols = Object.getOwnPropertySymbols;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __propIsEnum = Object.prototype.propertyIsEnumerable;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp.call(b, prop))
      __defNormalProp(a, prop, b[prop]);
  if (__getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(b)) {
      if (__propIsEnum.call(b, prop))
        __defNormalProp(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps = (a, b) => __defProps(a, __getOwnPropDescs(b));
function InlineToast({ referenceElement, children, suffixIcon, placement }) {
  const [indicatorElement, setIndicatorElement] = useState(null);
  const popper = usePopper(referenceElement, indicatorElement, { placement });
  const styles = useStyles2(getStyles);
  const placementStyles = useStyles2(getPlacementStyles);
  return /* @__PURE__ */ React__default.createElement(Portal, null, /* @__PURE__ */ React__default.createElement(
    "div",
    __spreadProps(__spreadValues({
      style: __spreadValues({ display: "inline-block" }, popper.styles.popper)
    }, popper.attributes.popper), {
      ref: setIndicatorElement
    }),
    /* @__PURE__ */ React__default.createElement("span", { className: cx(styles.root, placementStyles[placement]) }, children && /* @__PURE__ */ React__default.createElement("span", null, children), suffixIcon && /* @__PURE__ */ React__default.createElement(Icon, { name: suffixIcon }))
  ));
}
const getStyles = (theme) => {
  return {
    root: css(__spreadProps(__spreadValues({}, theme.typography.bodySmall), {
      willChange: "transform",
      background: theme.components.tooltip.background,
      color: theme.components.tooltip.text,
      padding: theme.spacing(0.5, 1.5),
      // get's an extra .5 of vertical padding to account for the rounded corners
      borderRadius: 100,
      // just a sufficiently large value to ensure ends are completely rounded
      display: "inline-flex",
      gap: theme.spacing(0.5),
      alignItems: "center"
    }))
  };
};
const createAnimation = (fromX, fromY) => keyframes({
  from: {
    opacity: 0,
    transform: `translate(${fromX}, ${fromY})`
  },
  to: {
    opacity: 1,
    transform: "translate(0, 0px)"
  }
});
const getPlacementStyles = (theme) => {
  const gap = 1;
  const placementTopAnimation = createAnimation(0, theme.spacing(gap));
  const placementBottomAnimation = createAnimation(0, theme.spacing(gap * -1));
  const placementLeftAnimation = createAnimation(theme.spacing(gap), 0);
  const placementRightAnimation = createAnimation(theme.spacing(gap * -1), 0);
  return {
    top: css({
      marginBottom: theme.spacing(gap),
      animation: `${placementTopAnimation} ease-out 100ms`
    }),
    bottom: css({
      marginTop: theme.spacing(gap),
      animation: `${placementBottomAnimation} ease-out 100ms`
    }),
    left: css({
      marginRight: theme.spacing(gap),
      animation: `${placementLeftAnimation} ease-out 100ms`
    }),
    right: css({
      marginLeft: theme.spacing(gap),
      animation: `${placementRightAnimation} ease-out 100ms`
    })
  };
};

export { InlineToast };
//# sourceMappingURL=InlineToast.js.map
