import { css, cx } from '@emotion/css';
import React__default from 'react';
import { useTheme2 } from '../../themes/ThemeContext.js';
import '@grafana/data';
import { stylesFactory } from '../../themes/stylesFactory.js';
import '@emotion/react';
import 'tinycolor2';
import { Icon } from '../Icon/Icon.js';

var __defProp = Object.defineProperty;
var __getOwnPropSymbols = Object.getOwnPropertySymbols;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __propIsEnum = Object.prototype.propertyIsEnumerable;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp.call(b, prop))
      __defNormalProp(a, prop, b[prop]);
  if (__getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(b)) {
      if (__propIsEnum.call(b, prop))
        __defNormalProp(a, prop, b[prop]);
    }
  return a;
};
var __objRest = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
const getLabelStyles = stylesFactory((theme) => {
  return {
    label: css`
      label: Label;
      font-size: ${theme.typography.size.sm};
      font-weight: ${theme.typography.fontWeightMedium};
      line-height: 1.25;
      margin-bottom: ${theme.spacing(0.5)};
      color: ${theme.colors.text.primary};
      max-width: 480px;
    `,
    labelContent: css`
      display: flex;
      align-items: center;
    `,
    description: css`
      label: Label-description;
      color: ${theme.colors.text.secondary};
      font-size: ${theme.typography.size.sm};
      font-weight: ${theme.typography.fontWeightRegular};
      margin-top: ${theme.spacing(0.25)};
      display: block;
    `,
    categories: css`
      label: Label-categories;
      display: inline-flex;
      align-items: center;
    `,
    chevron: css`
      margin: 0 ${theme.spacing(0.25)};
    `
  };
});
const Label = (_a) => {
  var _b = _a, { children, description, className, category } = _b, labelProps = __objRest(_b, ["children", "description", "className", "category"]);
  const theme = useTheme2();
  const styles = getLabelStyles(theme);
  const categories = category == null ? void 0 : category.map((c, i) => {
    return /* @__PURE__ */ React__default.createElement("span", { className: styles.categories, key: `${c}/${i}` }, /* @__PURE__ */ React__default.createElement("span", null, c), /* @__PURE__ */ React__default.createElement(Icon, { name: "angle-right", className: styles.chevron }));
  });
  return /* @__PURE__ */ React__default.createElement("div", { className: cx(styles.label, className) }, /* @__PURE__ */ React__default.createElement("label", __spreadValues({}, labelProps), /* @__PURE__ */ React__default.createElement("div", { className: styles.labelContent }, categories, children), description && /* @__PURE__ */ React__default.createElement("span", { className: styles.description }, description)));
};

export { Label, getLabelStyles };
//# sourceMappingURL=Label.js.map
