import classNames from 'classnames';
import React__default from 'react';
import { Icon } from '../Icon/Icon.js';
import { Tooltip } from '../Tooltip/Tooltip.js';

var __defProp = Object.defineProperty;
var __defProps = Object.defineProperties;
var __getOwnPropDescs = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols = Object.getOwnPropertySymbols;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __propIsEnum = Object.prototype.propertyIsEnumerable;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp.call(b, prop))
      __defNormalProp(a, prop, b[prop]);
  if (__getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(b)) {
      if (__propIsEnum.call(b, prop))
        __defNormalProp(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps = (a, b) => __defProps(a, __getOwnPropDescs(b));
var __objRest = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
const FormLabel = (_a) => {
  var _b = _a, {
    children,
    isFocused,
    isInvalid,
    className,
    htmlFor,
    tooltip,
    width,
    interactive
  } = _b, rest = __objRest(_b, [
    "children",
    "isFocused",
    "isInvalid",
    "className",
    "htmlFor",
    "tooltip",
    "width",
    "interactive"
  ]);
  const classes = classNames(className, `gf-form-label width-${width ? width : "10"}`, {
    "gf-form-label--is-focused": isFocused,
    "gf-form-label--is-invalid": isInvalid
  });
  return /* @__PURE__ */ React__default.createElement("label", __spreadProps(__spreadValues({ className: classes }, rest), { htmlFor }), children, tooltip && /* @__PURE__ */ React__default.createElement(Tooltip, { placement: "top", content: tooltip, theme: "info", interactive }, /* @__PURE__ */ React__default.createElement(Icon, { tabIndex: 0, name: "info-circle", size: "sm", style: { marginLeft: "10px" } })));
};
const InlineFormLabel = FormLabel;

export { FormLabel, InlineFormLabel };
//# sourceMappingURL=FormLabel.js.map
