import { css } from '@emotion/css';
import React__default from 'react';
import { getValueFormat, formattedValueToString } from '@grafana/data';
import { useStyles2 } from '../../themes/ThemeContext.js';
import 'memoize-one';
import '@emotion/react';
import 'tinycolor2';
import { trimFileName } from '../../utils/file.js';
import { Button } from '../Button/Button.js';
import '../Button/ButtonGroup.js';
import { Icon } from '../Icon/Icon.js';
import { IconButton } from '../IconButton/IconButton.js';

const REMOVE_FILE = "Remove file";
function FileListItem({ file: customFile, removeFile }) {
  const styles = useStyles2(getStyles);
  const { file, progress, error, abortUpload, retryUpload } = customFile;
  const renderRightSide = () => {
    if (error) {
      return /* @__PURE__ */ React__default.createElement(React__default.Fragment, null, /* @__PURE__ */ React__default.createElement("span", { className: styles.error }, error.message), retryUpload && /* @__PURE__ */ React__default.createElement(
        IconButton,
        {
          type: "button",
          "aria-label": "Retry",
          name: "sync",
          tooltip: "Retry",
          tooltipPlacement: "top",
          onClick: retryUpload
        }
      ), removeFile && /* @__PURE__ */ React__default.createElement(
        IconButton,
        {
          className: retryUpload ? styles.marginLeft : "",
          type: "button",
          name: "trash-alt",
          onClick: () => removeFile(customFile),
          tooltip: REMOVE_FILE,
          "aria-label": REMOVE_FILE
        }
      ));
    }
    if (progress && file.size > progress) {
      return /* @__PURE__ */ React__default.createElement(React__default.Fragment, null, /* @__PURE__ */ React__default.createElement("progress", { className: styles.progressBar, max: file.size, value: progress }), /* @__PURE__ */ React__default.createElement("span", { className: styles.paddingLeft }, Math.round(progress / file.size * 100), "%"), abortUpload && /* @__PURE__ */ React__default.createElement(Button, { variant: "secondary", type: "button", fill: "text", onClick: abortUpload }, "Cancel upload"));
    }
    return removeFile && /* @__PURE__ */ React__default.createElement(
      IconButton,
      {
        name: "trash-alt",
        onClick: () => removeFile(customFile),
        tooltip: REMOVE_FILE,
        "aria-label": REMOVE_FILE,
        type: "button",
        tooltipPlacement: "top"
      }
    );
  };
  const valueFormat = getValueFormat("decbytes")(file.size);
  return /* @__PURE__ */ React__default.createElement("div", { className: styles.fileListContainer }, /* @__PURE__ */ React__default.createElement("span", { className: styles.fileNameWrapper }, /* @__PURE__ */ React__default.createElement(Icon, { name: "file-blank", size: "lg", "aria-hidden": true }), /* @__PURE__ */ React__default.createElement("span", { className: styles.padding }, trimFileName(file.name)), /* @__PURE__ */ React__default.createElement("span", null, formattedValueToString(valueFormat))), /* @__PURE__ */ React__default.createElement("div", { className: styles.fileNameWrapper }, renderRightSide()));
}
function getStyles(theme) {
  return {
    fileListContainer: css`
      width: 100%;
      display: flex;
      flex-direction: row;
      align-items: center;
      justify-content: space-between;
      padding: ${theme.spacing(2)};
      border: 1px dashed ${theme.colors.border.medium};
      background-color: ${theme.colors.background.secondary};
      margin-top: ${theme.spacing(1)};
    `,
    fileNameWrapper: css`
      display: flex;
      flex-direction: row;
      align-items: center;
    `,
    padding: css`
      padding: ${theme.spacing(0, 1)};
    `,
    paddingLeft: css`
      padding-left: ${theme.spacing(2)};
    `,
    marginLeft: css`
      margin-left: ${theme.spacing(1)};
    `,
    error: css`
      padding-right: ${theme.spacing(2)};
      color: ${theme.colors.error.text};
    `,
    progressBar: css`
      border-radius: ${theme.shape.radius.default};
      height: 4px;
      ::-webkit-progress-bar {
        background-color: ${theme.colors.border.weak};
        border-radius: ${theme.shape.radius.default};
      }
      ::-webkit-progress-value {
        background-color: ${theme.colors.primary.main};
        border-radius: ${theme.shape.radius.default};
      }
    `
  };
}

export { FileListItem, REMOVE_FILE };
//# sourceMappingURL=FileListItem.js.map
