import { css } from '@emotion/css';
import React__default, { useState, useEffect, useCallback } from 'react';
import { rangeUtil, dateTimeParse, isDateTime, dateTimeFormat, dateMath } from '@grafana/data';
import { selectors } from '@grafana/e2e-selectors';
import '../../FormField/FormField.js';
import '../../Forms/Legacy/Input/Input.js';
import 'react-select';
import { Icon } from '../../Icon/Icon.js';
import '../../Forms/Legacy/Select/Select.js';
import 'lodash';
import { Tooltip } from '../../Tooltip/Tooltip.js';
import '../../SecretFormField/SecretFormField.js';
import '../../IconButton/IconButton.js';
import '../../ConfirmButton/ConfirmButton.js';
import { Button } from '../../Button/Button.js';
import '../../Button/ButtonGroup.js';
import 'react-popper';
import 'react-transition-group/Transition';
import '../../Portal/Portal.js';
import '../../Toggletip/Toggletip.js';
import 'react-custom-scrollbars-2';
import { useStyles2 } from '../../../themes/ThemeContext.js';
import 'memoize-one';
import '@emotion/react';
import 'tinycolor2';
import 'classnames';
import '../../TabbedContainer/TabbedContainer.js';
import { t, Trans } from '../../../utils/i18n.js';
import '../../Cascader/Cascader.js';
import '../../ButtonCascader/ButtonCascader.js';
import '../../Spinner/Spinner.js';
import '../../ColorPicker/ColorPicker.js';
import '../../ColorPicker/ColorPickerInput.js';
import '../../ColorPicker/SeriesColorPickerPopover.js';
import '../../StatsPicker/StatsPicker.js';
import '../../RefreshPicker/RefreshPicker.js';
import '../TimeRangePicker.js';
import 'rc-time-picker';
import 'react-select/async';
import 'react-select/async-creatable';
import 'react-select/creatable';
import '../../Select/IndicatorsContainer.js';
import '../../Select/InputControl.js';
import '../../Select/getSelectStyles.js';
import '../../Select/SelectContainer.js';
import '../../Select/SelectMenu.js';
import '../../Select/SelectOptionGroup.js';
import '../../transitions/FadeTransition.js';
import '../../transitions/SlideOutTransition.js';
import '../../Select/ValueContainer.js';
import '../TimeZonePicker/TimeZoneOption.js';
import '../DatePicker/DatePicker.js';
import { Input } from '../../Input/Input.js';
import '../DateTimePicker/DateTimePicker.js';
import '../../List/AbstractList.js';
import 'react-table';
import '../../InteractiveTable/ExpanderCell.js';
import '../../../utils/dom.js';
import '../../../utils/colors.js';
import 'slate';
import 'ansicolor';
import '../../../utils/logger.js';
import '../../Tags/Tag.js';
import '../../Tags/TagList.js';
import '../../Modal/Modal.js';
import '../../QueryField/QueryField.js';
import '../../Monaco/CodeEditor.js';
import 'react-use';
import '../../Modal/getModalStyles.js';
import '../../Tabs/Tab.js';
import '../../Tabs/TabsBar.js';
import '../../Modal/ModalsContext.js';
import '../../PageLayout/PageToolbar.js';
import 'rxjs';
import 'rxjs/operators';
import '../../Table/Table.js';
import '@grafana/schema';
import '../../TableInputCSV/TableInputCSV.js';
import '../../Tabs/VerticalTab.js';
import '../../Tabs/TabContent.js';
import '../../Tabs/Counter.js';
import '../../BigValue/BigValue.js';
import '../../Sparkline/Sparkline.js';
import '../../Gauge/Gauge.js';
import '../../Graph/Graph.js';
import '../../Graph/GraphWithLegend.js';
import '../../ContextMenu/ContextMenu.js';
import '../../FormattedValueDisplay/FormattedValueDisplay.js';
import '../../Menu/MenuGroup.js';
import '../../Menu/MenuItem.js';
import '../../VizLegend/SeriesIcon.js';
import '../../BarGauge/BarGauge.js';
import '../../VizTooltip/VizTooltip.js';
import '../../VizTooltip/VizTooltipContainer.js';
import '../../VizRepeater/VizRepeater.js';
import '../../PanelChrome/index.js';
import '../../VizLayout/VizLayout.js';
import '../../VizLegend/VizLegend.js';
import '../../VizLegend/VizLegendListItem.js';
import '../../Alert/Alert.js';
import '../../Collapse/Collapse.js';
import '../../Logs/LogMessageAnsi.js';
import '../../Logs/LogRows.js';
import '../../Button/FullWidthButtonContainer.js';
import '../../ClickOutsideWrapper/ClickOutsideWrapper.js';
import '../../Menu/Menu.js';
import '../../DataLinks/DataLinksInlineEditor/DataLinksInlineEditor.js';
import '../../DataLinks/DataLinkInput.js';
import '../../InfoBox/InfoBox.js';
import '../../InfoBox/FeatureInfoBox.js';
import '../../JSONFormatter/JSONFormatter.js';
import '../../ErrorBoundary/ErrorBoundary.js';
import '../../ErrorBoundary/ErrorWithStack.js';
import '../../Forms/InlineField.js';
import '../../Switch/Switch.js';
import '../../DataSourceSettings/CustomHeadersSettings.js';
import '../../TextArea/TextArea.js';
import 'react-use/lib/useClickAway';
import '@react-aria/dialog';
import '@react-aria/focus';
import '@react-aria/overlays';
import 'rc-drawer';
import '../../Slider/Slider.js';
import '../../Slider/RangeSlider.js';
import 'react-hook-form';
import '../../ToolbarButton/ToolbarButton.js';
import '../../ToolbarButton/ToolbarButtonRow.js';
import '../../MatchersUI/fieldMatchersUI.js';
import '../../Link/Link.js';
import '../../Forms/Label.js';
import { Field } from '../../Forms/Field.js';
import '../../Forms/FieldSet.js';
import '../../Forms/FieldValidationMessage.js';
import '../../Forms/InlineSegmentGroup.js';
import '../../Badge/Badge.js';
import '../../Forms/RadioButtonGroup/RadioButtonGroup.js';
import '../../Input/AutoSizeInput.js';
import '../../FilterInput/FilterInput.js';
import '../../Forms/Checkbox.js';
import 'uuid';
import 'react-dropzone';
import '../TimeRangeInput.js';
import '../RelativeTimeRangePicker/RelativeTimeRangePicker.js';
import '../../Card/Card.js';
import '../../Card/CardContainer.js';
import '../../Dropdown/ButtonSelect.js';
import '../../Dropdown/Dropdown.js';
import '../../PluginSignatureBadge/PluginSignatureBadge.js';
import '../../uPlot/config.js';
import 'uplot';
import '../../uPlot/utils.js';
import '../../uPlot/PlotLegend.js';
import '../../GraphNG/GraphNG.js';
import '../../TimeSeries/TimeSeries.js';
import '../../GraphNG/hooks.js';
import '../../BrowserLabel/Label.js';
import TimePickerCalendar from './TimePickerCalendar.js';

const ERROR_MESSAGES = {
  default: () => t("time-picker.range-content.default-error", 'Please enter a past date or "now"'),
  range: () => t("time-picker.range-content.range-error", `"From" can't be after "To"`)
};
const TimeRangeContent = (props) => {
  const { value, isFullscreen = false, timeZone, onApply: onApplyFromProps, isReversed, fiscalYearStartMonth } = props;
  const [fromValue, toValue] = valueToState(value.raw.from, value.raw.to, timeZone);
  const style = useStyles2(getStyles);
  const [from, setFrom] = useState(fromValue);
  const [to, setTo] = useState(toValue);
  const [isOpen, setOpen] = useState(false);
  useEffect(() => {
    const [fromValue2, toValue2] = valueToState(value.raw.from, value.raw.to, timeZone);
    setFrom(fromValue2);
    setTo(toValue2);
  }, [value.raw.from, value.raw.to, timeZone]);
  const onOpen = useCallback(
    (event) => {
      event.preventDefault();
      setOpen(true);
    },
    [setOpen]
  );
  const onApply = useCallback(() => {
    if (to.invalid || from.invalid) {
      return;
    }
    const raw = { from: from.value, to: to.value };
    const timeRange = rangeUtil.convertRawToRange(raw, timeZone, fiscalYearStartMonth);
    onApplyFromProps(timeRange);
  }, [from.invalid, from.value, onApplyFromProps, timeZone, to.invalid, to.value, fiscalYearStartMonth]);
  const onChange = useCallback(
    (from2, to2) => {
      const [fromValue2, toValue2] = valueToState(from2, to2, timeZone);
      setFrom(fromValue2);
      setTo(toValue2);
    },
    [timeZone]
  );
  const submitOnEnter = (event) => {
    if (event.key === "Enter") {
      onApply();
    }
  };
  const fiscalYear = rangeUtil.convertRawToRange({ from: "now/fy", to: "now/fy" }, timeZone, fiscalYearStartMonth);
  const fiscalYearMessage = t("time-picker.range-content.fiscal-year", "Fiscal year");
  const fyTooltip = /* @__PURE__ */ React__default.createElement("div", { className: style.tooltip }, rangeUtil.isFiscal(value) ? /* @__PURE__ */ React__default.createElement(
    Tooltip,
    {
      content: `${fiscalYearMessage}: ${fiscalYear.from.format("MMM-DD")} - ${fiscalYear.to.format("MMM-DD")}`
    },
    /* @__PURE__ */ React__default.createElement(Icon, { name: "info-circle" })
  ) : null);
  const icon = /* @__PURE__ */ React__default.createElement(
    Button,
    {
      "aria-label": selectors.components.TimePicker.calendar.openButton,
      icon: "calendar-alt",
      variant: "secondary",
      type: "button",
      onClick: onOpen
    }
  );
  return /* @__PURE__ */ React__default.createElement("div", null, /* @__PURE__ */ React__default.createElement("div", { className: style.fieldContainer }, /* @__PURE__ */ React__default.createElement(
    Field,
    {
      label: t("time-picker.range-content.from-input", "From"),
      invalid: from.invalid,
      error: from.errorMessage
    },
    /* @__PURE__ */ React__default.createElement(
      Input,
      {
        onClick: (event) => event.stopPropagation(),
        onChange: (event) => onChange(event.currentTarget.value, to.value),
        addonAfter: icon,
        onKeyDown: submitOnEnter,
        "aria-label": selectors.components.TimePicker.fromField,
        value: from.value
      }
    )
  ), fyTooltip), /* @__PURE__ */ React__default.createElement("div", { className: style.fieldContainer }, /* @__PURE__ */ React__default.createElement(Field, { label: t("time-picker.range-content.to-input", "To"), invalid: to.invalid, error: to.errorMessage }, /* @__PURE__ */ React__default.createElement(
    Input,
    {
      onClick: (event) => event.stopPropagation(),
      onChange: (event) => onChange(from.value, event.currentTarget.value),
      addonAfter: icon,
      onKeyDown: submitOnEnter,
      "aria-label": selectors.components.TimePicker.toField,
      value: to.value
    }
  )), fyTooltip), /* @__PURE__ */ React__default.createElement(Button, { "data-testid": selectors.components.TimePicker.applyTimeRange, type: "button", onClick: onApply }, /* @__PURE__ */ React__default.createElement(Trans, { i18nKey: "time-picker.range-content.apply-button" }, "Apply time range")), /* @__PURE__ */ React__default.createElement(
    TimePickerCalendar,
    {
      isFullscreen,
      isOpen,
      from: dateTimeParse(from.value),
      to: dateTimeParse(to.value),
      onApply,
      onClose: () => setOpen(false),
      onChange,
      timeZone,
      isReversed
    }
  ));
};
function isRangeInvalid(from, to, timezone) {
  const raw = { from, to };
  const timeRange = rangeUtil.convertRawToRange(raw, timezone);
  const valid = timeRange.from.isSame(timeRange.to) || timeRange.from.isBefore(timeRange.to);
  return !valid;
}
function valueToState(rawFrom, rawTo, timeZone) {
  const fromValue = valueAsString(rawFrom, timeZone);
  const toValue = valueAsString(rawTo, timeZone);
  const fromInvalid = !isValid(fromValue, false, timeZone);
  const toInvalid = !isValid(toValue, true, timeZone);
  const rangeInvalid = isRangeInvalid(fromValue, toValue, timeZone) && !toInvalid;
  return [
    {
      value: fromValue,
      invalid: fromInvalid || rangeInvalid,
      errorMessage: rangeInvalid && !fromInvalid ? ERROR_MESSAGES.range() : ERROR_MESSAGES.default()
    },
    { value: toValue, invalid: toInvalid, errorMessage: ERROR_MESSAGES.default() }
  ];
}
function valueAsString(value, timeZone) {
  if (isDateTime(value)) {
    return dateTimeFormat(value, { timeZone });
  }
  return value;
}
function isValid(value, roundUp, timeZone) {
  if (isDateTime(value)) {
    return value.isValid();
  }
  if (dateMath.isMathString(value)) {
    return dateMath.isValid(value);
  }
  const parsed = dateTimeParse(value, { roundUp, timeZone });
  return parsed.isValid();
}
function getStyles(theme) {
  return {
    fieldContainer: css`
      display: flex;
    `,
    tooltip: css`
      padding-left: ${theme.spacing(1)};
      padding-top: ${theme.spacing(3)};
    `
  };
}

export { TimeRangeContent };
//# sourceMappingURL=TimeRangeContent.js.map
