import { css, cx } from '@emotion/css';
import React__default, { memo, useState, useMemo } from 'react';
import { isDateTime, rangeUtil } from '@grafana/data';
import { selectors } from '@grafana/e2e-selectors';
import '../../FormField/FormField.js';
import '../../Forms/Legacy/Input/Input.js';
import 'react-select';
import { Icon } from '../../Icon/Icon.js';
import '../../Forms/Legacy/Select/Select.js';
import 'lodash';
import '../../Tooltip/Tooltip.js';
import '../../SecretFormField/SecretFormField.js';
import '../../IconButton/IconButton.js';
import '../../ConfirmButton/ConfirmButton.js';
import '../../Button/Button.js';
import '../../Button/ButtonGroup.js';
import 'react-popper';
import 'react-transition-group/Transition';
import '../../Portal/Portal.js';
import '../../Toggletip/Toggletip.js';
import { CustomScrollbar } from '../../CustomScrollbar/CustomScrollbar.js';
import '../../TabbedContainer/TabbedContainer.js';
import { Trans, t } from '../../../utils/i18n.js';
import { useTheme2 } from '../../../themes/ThemeContext.js';
import { stylesFactory } from '../../../themes/stylesFactory.js';
import '@emotion/react';
import { getFocusStyles } from '../../../themes/mixins.js';
import '../../Cascader/Cascader.js';
import '../../ButtonCascader/ButtonCascader.js';
import '../../Spinner/Spinner.js';
import '../../ColorPicker/ColorPicker.js';
import '../../ColorPicker/ColorPickerInput.js';
import '../../ColorPicker/SeriesColorPickerPopover.js';
import '../../StatsPicker/StatsPicker.js';
import '../../RefreshPicker/RefreshPicker.js';
import '../TimeRangePicker.js';
import 'rc-time-picker';
import 'react-select/async';
import 'react-select/async-creatable';
import 'react-select/creatable';
import '../../Select/IndicatorsContainer.js';
import '../../Select/InputControl.js';
import '../../Select/getSelectStyles.js';
import '../../Select/SelectContainer.js';
import '../../Select/SelectMenu.js';
import '../../Select/SelectOptionGroup.js';
import '../../transitions/FadeTransition.js';
import '../../transitions/SlideOutTransition.js';
import '../../Select/ValueContainer.js';
import '../TimeZonePicker/TimeZoneOption.js';
import '../DatePicker/DatePicker.js';
import '../../Input/Input.js';
import '../DateTimePicker/DateTimePicker.js';
import '../../List/AbstractList.js';
import 'react-table';
import '../../InteractiveTable/ExpanderCell.js';
import '../../../utils/dom.js';
import '../../../utils/colors.js';
import 'slate';
import 'ansicolor';
import '../../../utils/logger.js';
import '../../Tags/Tag.js';
import '../../Tags/TagList.js';
import '../../Modal/Modal.js';
import '../../QueryField/QueryField.js';
import '../../Monaco/CodeEditor.js';
import 'react-use';
import '../../Modal/getModalStyles.js';
import '../../Tabs/Tab.js';
import '../../Tabs/TabsBar.js';
import '../../Modal/ModalsContext.js';
import '../../PageLayout/PageToolbar.js';
import 'rxjs';
import 'rxjs/operators';
import '../../Table/Table.js';
import '@grafana/schema';
import '../../TableInputCSV/TableInputCSV.js';
import '../../Tabs/VerticalTab.js';
import '../../Tabs/TabContent.js';
import '../../Tabs/Counter.js';
import '../../BigValue/BigValue.js';
import '../../Sparkline/Sparkline.js';
import '../../Gauge/Gauge.js';
import '../../Graph/Graph.js';
import '../../Graph/GraphWithLegend.js';
import '../../ContextMenu/ContextMenu.js';
import '../../FormattedValueDisplay/FormattedValueDisplay.js';
import '../../Menu/MenuGroup.js';
import '../../Menu/MenuItem.js';
import '../../VizLegend/SeriesIcon.js';
import '../../BarGauge/BarGauge.js';
import '../../VizTooltip/VizTooltip.js';
import '../../VizTooltip/VizTooltipContainer.js';
import '../../VizRepeater/VizRepeater.js';
import '../../PanelChrome/index.js';
import '../../VizLayout/VizLayout.js';
import '../../VizLegend/VizLegend.js';
import '../../VizLegend/VizLegendListItem.js';
import '../../Alert/Alert.js';
import '../../Collapse/Collapse.js';
import '../../Logs/LogMessageAnsi.js';
import '../../Logs/LogRows.js';
import '../../Button/FullWidthButtonContainer.js';
import '../../ClickOutsideWrapper/ClickOutsideWrapper.js';
import '../../Menu/Menu.js';
import '../../DataLinks/DataLinksInlineEditor/DataLinksInlineEditor.js';
import '../../DataLinks/DataLinkInput.js';
import '../../InfoBox/InfoBox.js';
import '../../InfoBox/FeatureInfoBox.js';
import '../../JSONFormatter/JSONFormatter.js';
import '../../ErrorBoundary/ErrorBoundary.js';
import '../../ErrorBoundary/ErrorWithStack.js';
import 'classnames';
import '../../Forms/InlineField.js';
import '../../Switch/Switch.js';
import '../../DataSourceSettings/CustomHeadersSettings.js';
import '../../TextArea/TextArea.js';
import 'react-use/lib/useClickAway';
import '@react-aria/dialog';
import '@react-aria/focus';
import '@react-aria/overlays';
import 'rc-drawer';
import '../../Slider/Slider.js';
import '../../Slider/RangeSlider.js';
import 'react-hook-form';
import '../../ToolbarButton/ToolbarButton.js';
import '../../ToolbarButton/ToolbarButtonRow.js';
import '../../MatchersUI/fieldMatchersUI.js';
import '../../Link/Link.js';
import '../../Forms/Label.js';
import '../../Forms/Field.js';
import '../../Forms/FieldSet.js';
import '../../Forms/FieldValidationMessage.js';
import '../../Forms/InlineSegmentGroup.js';
import '../../Badge/Badge.js';
import '../../Forms/RadioButtonGroup/RadioButtonGroup.js';
import '../../Input/AutoSizeInput.js';
import { FilterInput } from '../../FilterInput/FilterInput.js';
import '../../Forms/Checkbox.js';
import 'uuid';
import 'react-dropzone';
import '../TimeRangeInput.js';
import '../RelativeTimeRangePicker/RelativeTimeRangePicker.js';
import '../../Card/Card.js';
import '../../Card/CardContainer.js';
import '../../Dropdown/ButtonSelect.js';
import '../../Dropdown/Dropdown.js';
import '../../PluginSignatureBadge/PluginSignatureBadge.js';
import '../../uPlot/config.js';
import 'uplot';
import '../../uPlot/utils.js';
import 'tinycolor2';
import '../../uPlot/PlotLegend.js';
import '../../GraphNG/GraphNG.js';
import '../../TimeSeries/TimeSeries.js';
import '../../GraphNG/hooks.js';
import '../../BrowserLabel/Label.js';
import { TimePickerFooter } from './TimePickerFooter.js';
import { TimePickerTitle } from './TimePickerTitle.js';
import { TimeRangeContent } from './TimeRangeContent.js';
import { TimeRangeList } from './TimeRangeList.js';
import { mapRangeToTimeOption, mapOptionToTimeRange } from './mapper.js';

var __defProp = Object.defineProperty;
var __defProps = Object.defineProperties;
var __getOwnPropDescs = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols = Object.getOwnPropertySymbols;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __propIsEnum = Object.prototype.propertyIsEnumerable;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp.call(b, prop))
      __defNormalProp(a, prop, b[prop]);
  if (__getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(b)) {
      if (__propIsEnum.call(b, prop))
        __defNormalProp(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps = (a, b) => __defProps(a, __getOwnPropDescs(b));
const TimePickerContentWithScreenSize = (props) => {
  const {
    quickOptions = [],
    isReversed,
    isFullscreen,
    hideQuickRanges,
    timeZone,
    fiscalYearStartMonth,
    value,
    onChange,
    history,
    showHistory,
    className,
    hideTimeZone,
    onChangeTimeZone,
    onChangeFiscalYearStartMonth
  } = props;
  const isHistoryEmpty = !(history == null ? void 0 : history.length);
  const isContainerTall = isFullscreen && showHistory || !isFullscreen && (showHistory && !isHistoryEmpty || !hideQuickRanges);
  const theme = useTheme2();
  const styles = getStyles(theme, isReversed, hideQuickRanges, isContainerTall, isFullscreen);
  const historyOptions = mapToHistoryOptions(history, timeZone);
  const timeOption = useTimeOption(value.raw, quickOptions);
  const [searchTerm, setSearchQuery] = useState("");
  const filteredQuickOptions = quickOptions.filter((o) => o.display.toLowerCase().includes(searchTerm.toLowerCase()));
  const onChangeTimeOption = (timeOption2) => {
    return onChange(mapOptionToTimeRange(timeOption2));
  };
  return /* @__PURE__ */ React__default.createElement("div", { id: "TimePickerContent", className: cx(styles.container, className) }, /* @__PURE__ */ React__default.createElement("div", { className: styles.body }, (!isFullscreen || !hideQuickRanges) && /* @__PURE__ */ React__default.createElement("div", { className: styles.rightSide }, /* @__PURE__ */ React__default.createElement("div", { className: styles.timeRangeFilter }, /* @__PURE__ */ React__default.createElement(
    FilterInput,
    {
      width: 0,
      autoFocus: true,
      value: searchTerm,
      onChange: setSearchQuery,
      placeholder: t("time-picker.content.filter-placeholder", "Search quick ranges")
    }
  )), /* @__PURE__ */ React__default.createElement(CustomScrollbar, null, !isFullscreen && /* @__PURE__ */ React__default.createElement(NarrowScreenForm, __spreadProps(__spreadValues({}, props), { historyOptions })), !hideQuickRanges && /* @__PURE__ */ React__default.createElement(TimeRangeList, { options: filteredQuickOptions, onChange: onChangeTimeOption, value: timeOption }))), isFullscreen && /* @__PURE__ */ React__default.createElement("div", { className: styles.leftSide }, /* @__PURE__ */ React__default.createElement(FullScreenForm, __spreadProps(__spreadValues({}, props), { historyOptions })))), !hideTimeZone && isFullscreen && /* @__PURE__ */ React__default.createElement(
    TimePickerFooter,
    {
      timeZone,
      fiscalYearStartMonth,
      onChangeTimeZone,
      onChangeFiscalYearStartMonth
    }
  ));
};
const TimePickerContent = (props) => {
  const { widthOverride } = props;
  const theme = useTheme2();
  const isFullscreen = (widthOverride || window.innerWidth) >= theme.breakpoints.values.lg;
  return /* @__PURE__ */ React__default.createElement(TimePickerContentWithScreenSize, __spreadProps(__spreadValues({}, props), { isFullscreen }));
};
const NarrowScreenForm = (props) => {
  const { value, hideQuickRanges, onChange, timeZone, historyOptions = [], showHistory } = props;
  const theme = useTheme2();
  const styles = getNarrowScreenStyles(theme);
  const isAbsolute = isDateTime(value.raw.from) || isDateTime(value.raw.to);
  const [collapsedFlag, setCollapsedFlag] = useState(!isAbsolute);
  const collapsed = hideQuickRanges ? false : collapsedFlag;
  const onChangeTimeOption = (timeOption) => {
    return onChange(mapOptionToTimeRange(timeOption, timeZone));
  };
  return /* @__PURE__ */ React__default.createElement("fieldset", null, /* @__PURE__ */ React__default.createElement("div", { className: styles.header }, /* @__PURE__ */ React__default.createElement(
    "button",
    {
      type: "button",
      className: styles.expandButton,
      onClick: () => {
        if (!hideQuickRanges) {
          setCollapsedFlag(!collapsed);
        }
      },
      "data-testid": selectors.components.TimePicker.absoluteTimeRangeTitle,
      "aria-expanded": !collapsed,
      "aria-controls": "expanded-timerange"
    },
    /* @__PURE__ */ React__default.createElement(TimePickerTitle, null, /* @__PURE__ */ React__default.createElement(Trans, { i18nKey: "time-picker.absolute.title" }, "Absolute time range")),
    !hideQuickRanges && /* @__PURE__ */ React__default.createElement(Icon, { name: !collapsed ? "angle-up" : "angle-down" })
  )), !collapsed && /* @__PURE__ */ React__default.createElement("div", { className: styles.body, id: "expanded-timerange" }, /* @__PURE__ */ React__default.createElement("div", { className: styles.form }, /* @__PURE__ */ React__default.createElement(TimeRangeContent, { value, onApply: onChange, timeZone, isFullscreen: false })), showHistory && /* @__PURE__ */ React__default.createElement(
    TimeRangeList,
    {
      title: t("time-picker.absolute.recent-title", "Recently used absolute ranges"),
      options: historyOptions,
      onChange: onChangeTimeOption,
      placeholderEmpty: null
    }
  )));
};
const FullScreenForm = (props) => {
  const { onChange, value, timeZone, fiscalYearStartMonth, isReversed, historyOptions } = props;
  const theme = useTheme2();
  const styles = getFullScreenStyles(theme, props.hideQuickRanges);
  const onChangeTimeOption = (timeOption) => {
    return onChange(mapOptionToTimeRange(timeOption, timeZone));
  };
  return /* @__PURE__ */ React__default.createElement(React__default.Fragment, null, /* @__PURE__ */ React__default.createElement("div", { className: styles.container }, /* @__PURE__ */ React__default.createElement("div", { className: styles.title, "data-testid": selectors.components.TimePicker.absoluteTimeRangeTitle }, /* @__PURE__ */ React__default.createElement(TimePickerTitle, null, /* @__PURE__ */ React__default.createElement(Trans, { i18nKey: "time-picker.absolute.title" }, "Absolute time range"))), /* @__PURE__ */ React__default.createElement(
    TimeRangeContent,
    {
      value,
      timeZone,
      fiscalYearStartMonth,
      onApply: onChange,
      isFullscreen: true,
      isReversed
    }
  )), props.showHistory && /* @__PURE__ */ React__default.createElement("div", { className: styles.recent }, /* @__PURE__ */ React__default.createElement(
    TimeRangeList,
    {
      title: t("time-picker.absolute.recent-title", "Recently used absolute ranges"),
      options: historyOptions || [],
      onChange: onChangeTimeOption,
      placeholderEmpty: /* @__PURE__ */ React__default.createElement(EmptyRecentList, null)
    }
  )));
};
const EmptyRecentList = memo(() => {
  const theme = useTheme2();
  const styles = getEmptyListStyles(theme);
  return /* @__PURE__ */ React__default.createElement("div", { className: styles.container }, /* @__PURE__ */ React__default.createElement(Trans, { i18nKey: "time-picker.content.empty-recent-list" }, /* @__PURE__ */ React__default.createElement("div", null, /* @__PURE__ */ React__default.createElement("span", null, "It looks like you haven't used this time picker before. As soon as you enter some time intervals, recently used intervals will appear here.")), /* @__PURE__ */ React__default.createElement("div", null, /* @__PURE__ */ React__default.createElement(
    "a",
    {
      className: styles.link,
      href: "https://grafana.com/docs/grafana/latest/dashboards/time-range-controls",
      target: "_new"
    },
    "Read the documentation"
  ), /* @__PURE__ */ React__default.createElement("span", null, " to find out more about how to enter custom time ranges."))));
});
function mapToHistoryOptions(ranges, timeZone) {
  if (!Array.isArray(ranges) || ranges.length === 0) {
    return [];
  }
  return ranges.map((range) => mapRangeToTimeOption(range, timeZone));
}
EmptyRecentList.displayName = "EmptyRecentList";
const useTimeOption = (raw, quickOptions) => {
  return useMemo(() => {
    if (!rangeUtil.isRelativeTimeRange(raw)) {
      return;
    }
    return quickOptions.find((option) => {
      return option.from === raw.from && option.to === raw.to;
    });
  }, [raw, quickOptions]);
};
const getStyles = stylesFactory((theme, isReversed, hideQuickRanges, isContainerTall, isFullscreen) => {
  return {
    container: css`
      background: ${theme.colors.background.primary};
      box-shadow: ${theme.shadows.z3};
      width: ${isFullscreen ? "546px" : "262px"};
      border-radius: 2px;
      border: 1px solid ${theme.colors.border.weak};
      ${isReversed ? "left" : "right"}: 0;
    `,
    body: css`
      display: flex;
      flex-direction: row-reverse;
      height: ${isContainerTall ? "381px" : "217px"};
    `,
    leftSide: css`
      display: flex;
      flex-direction: column;
      border-right: ${isReversed ? "none" : `1px solid ${theme.colors.border.weak}`};
      width: ${!hideQuickRanges ? "60%" : "100%"};
      overflow: hidden;
      order: ${isReversed ? 1 : 0};
    `,
    rightSide: css`
      width: ${isFullscreen ? "40%" : "100%"}; !important;
      border-right: ${isReversed ? `1px solid ${theme.colors.border.weak}` : "none"};
      display: flex;
      flex-direction: column;
    `,
    timeRangeFilter: css`
      padding: ${theme.spacing(1)};
    `,
    spacing: css`
      margin-top: 16px;
    `
  };
});
const getNarrowScreenStyles = stylesFactory((theme) => {
  return {
    header: css`
      display: flex;
      flex-direction: row;
      justify-content: space-between;
      align-items: center;
      border-bottom: 1px solid ${theme.colors.border.weak};
      padding: 7px 9px 7px 9px;
    `,
    expandButton: css`
      background-color: transparent;
      border: none;
      display: flex;
      width: 100%;

      &:focus-visible {
        ${getFocusStyles(theme)}
      }
    `,
    body: css`
      border-bottom: 1px solid ${theme.colors.border.weak};
    `,
    form: css`
      padding: 7px 9px 7px 9px;
    `
  };
});
const getFullScreenStyles = stylesFactory((theme, hideQuickRanges) => {
  return {
    container: css`
      padding-top: 9px;
      padding-left: 11px;
      padding-right: ${!hideQuickRanges ? "20%" : "11px"};
    `,
    title: css`
      margin-bottom: 11px;
    `,
    recent: css`
      flex-grow: 1;
      display: flex;
      flex-direction: column;
      justify-content: flex-end;
      padding-top: ${theme.spacing(1)};
    `
  };
});
const getEmptyListStyles = stylesFactory((theme) => {
  return {
    container: css`
      padding: 12px;
      margin: 12px;

      a,
      span {
        font-size: 13px;
      }\
    `,
    link: css`
      color: ${theme.colors.text.link};
    `
  };
});

export { TimePickerContent, TimePickerContentWithScreenSize };
//# sourceMappingURL=TimePickerContent.js.map
