import { css } from '@emotion/css';
import React__default from 'react';
import { useStyles2 } from '../../../themes/ThemeContext.js';
import '@grafana/data';
import 'memoize-one';
import '@emotion/react';
import 'tinycolor2';
import { Trans } from '../../../utils/i18n.js';
import { Button } from '../../Button/Button.js';
import '../../Button/ButtonGroup.js';

function Footer({ onClose, onApply }) {
  const styles = useStyles2(getFooterStyles);
  return /* @__PURE__ */ React__default.createElement("div", { className: styles.container }, /* @__PURE__ */ React__default.createElement(Button, { className: styles.apply, onClick: onApply }, /* @__PURE__ */ React__default.createElement(Trans, { i18nKey: "time-picker.calendar.apply-button" }, "Apply time range")), /* @__PURE__ */ React__default.createElement(Button, { variant: "secondary", onClick: onClose }, /* @__PURE__ */ React__default.createElement(Trans, { i18nKey: "time-picker.calendar.cancel-button" }, "Cancel")));
}
Footer.displayName = "Footer";
const getFooterStyles = (theme) => {
  return {
    container: css`
      background-color: ${theme.colors.background.primary};
      display: flex;
      justify-content: center;
      padding: 10px;
      align-items: stretch;
    `,
    apply: css`
      margin-right: 4px;
      width: 100%;
      justify-content: center;
    `
  };
};

export { Footer };
//# sourceMappingURL=CalendarFooter.js.map
