import { css } from '@emotion/css';
import { FocusScope } from '@react-aria/focus';
import React__default, { Component } from 'react';
import { colorManipulator } from '@grafana/data';
import { withTheme2 } from '../../themes/ThemeContext.js';
import { stylesFactory } from '../../themes/stylesFactory.js';
import '@emotion/react';
import 'tinycolor2';
import { NamedColorsPalette } from './NamedColorsPalette.js';
import SpectrumPalette from './SpectrumPalette.js';

class UnThemedColorPickerPopover extends Component {
  constructor(props) {
    super(props);
    this.getTabClassName = (tabName) => {
      const { activePicker } = this.state;
      return `ColorPickerPopover__tab ${activePicker === tabName && "ColorPickerPopover__tab--active"}`;
    };
    this.handleChange = (color) => {
      const { onChange, enableNamedColors, theme } = this.props;
      if (enableNamedColors) {
        return onChange(color);
      }
      onChange(colorManipulator.asHexString(theme.visualization.getColorByName(color)));
    };
    this.onTabChange = (tab) => {
      return () => this.setState({ activePicker: tab });
    };
    this.renderPicker = () => {
      const { activePicker } = this.state;
      const { color } = this.props;
      switch (activePicker) {
        case "spectrum":
          return /* @__PURE__ */ React__default.createElement(SpectrumPalette, { color, onChange: this.handleChange });
        case "palette":
          return /* @__PURE__ */ React__default.createElement(NamedColorsPalette, { color, onChange: this.handleChange });
        default:
          return this.renderCustomPicker(activePicker);
      }
    };
    this.renderCustomPicker = (tabKey) => {
      const { customPickers, color, theme } = this.props;
      if (!customPickers) {
        return null;
      }
      return React__default.createElement(customPickers[tabKey].tabComponent, {
        color,
        theme,
        onChange: this.handleChange
      });
    };
    this.renderCustomPickerTabs = () => {
      const { customPickers } = this.props;
      if (!customPickers) {
        return null;
      }
      return /* @__PURE__ */ React__default.createElement(React__default.Fragment, null, Object.keys(customPickers).map((key) => {
        return /* @__PURE__ */ React__default.createElement("button", { className: this.getTabClassName(key), onClick: this.onTabChange(key), key }, customPickers[key].name);
      }));
    };
    this.state = {
      activePicker: "palette"
    };
  }
  render() {
    const { theme } = this.props;
    const styles = getStyles(theme);
    return /* @__PURE__ */ React__default.createElement(FocusScope, { contain: true, restoreFocus: true, autoFocus: true }, /* @__PURE__ */ React__default.createElement("div", { tabIndex: -1, className: styles.colorPickerPopover }, /* @__PURE__ */ React__default.createElement("div", { className: styles.colorPickerPopoverTabs }, /* @__PURE__ */ React__default.createElement("button", { className: this.getTabClassName("palette"), onClick: this.onTabChange("palette") }, "Colors"), /* @__PURE__ */ React__default.createElement("button", { className: this.getTabClassName("spectrum"), onClick: this.onTabChange("spectrum") }, "Custom"), this.renderCustomPickerTabs()), /* @__PURE__ */ React__default.createElement("div", { className: styles.colorPickerPopoverContent }, this.renderPicker())));
  }
}
const ColorPickerPopover = withTheme2(UnThemedColorPickerPopover);
ColorPickerPopover.displayName = "ColorPickerPopover";
const getStyles = stylesFactory((theme) => {
  return {
    colorPickerPopover: css`
      border-radius: ${theme.shape.borderRadius()};
      box-shadow: ${theme.shadows.z3};
      background: ${theme.colors.background.primary};
      border: 1px solid ${theme.colors.border.medium};

      .ColorPickerPopover__tab {
        width: 50%;
        text-align: center;
        padding: ${theme.spacing(1, 0)};
        background: ${theme.colors.background.secondary};
        color: ${theme.colors.text.secondary};
        font-size: ${theme.typography.bodySmall.fontSize};
        cursor: pointer;
        border: none;

        &:focus:not(:focus-visible) {
          outline: none;
          box-shadow: none;
        }

        :focus-visible {
          position: relative;
        }
      }

      .ColorPickerPopover__tab--active {
        color: ${theme.colors.text.primary};
        font-weight: ${theme.typography.fontWeightMedium};
        background: ${theme.colors.background.primary};
      }
    `,
    colorPickerPopoverContent: css`
      width: 246px;
      font-size: ${theme.typography.bodySmall.fontSize};
      min-height: 184px;
      padding: ${theme.spacing(1)};
      display: flex;
      flex-direction: column;
    `,
    colorPickerPopoverTabs: css`
      display: flex;
      width: 100%;
      border-radius: ${theme.shape.borderRadius()} ${theme.shape.borderRadius()} 0 0;
    `
  };
});

export { ColorPickerPopover };
//# sourceMappingURL=ColorPickerPopover.js.map
