import { cx, css } from '@emotion/css';
import React__default from 'react';
import { useStyles2 } from '../../themes/ThemeContext.js';

const CallToActionCard = ({ message, callToActionElement, footer, className }) => {
  const css2 = useStyles2(getStyles);
  return /* @__PURE__ */ React__default.createElement("div", { className: cx([css2.wrapper, className]) }, message && /* @__PURE__ */ React__default.createElement("div", { className: css2.message }, message), callToActionElement, footer && /* @__PURE__ */ React__default.createElement("div", { className: css2.footer }, footer));
};
const getStyles = (theme) => ({
  wrapper: css`
    label: call-to-action-card;
    padding: ${theme.spacing(3)};
    background: ${theme.colors.background.secondary};
    border-radius: ${theme.shape.radius.default};
    display: flex;
    flex-direction: column;
    align-items: center;
    justify-content: center;
    flex-grow: 1;
  `,
  message: css`
    margin-bottom: ${theme.spacing(3)};
    font-style: italic;
  `,
  footer: css`
    margin-top: ${theme.spacing(3)}};
  `
});

export { CallToActionCard };
//# sourceMappingURL=CallToActionCard.js.map
