import { cx, css } from '@emotion/css';
import React__default from 'react';
import '../../themes/ThemeContext.js';
import '@grafana/data';
import { stylesFactory } from '../../themes/stylesFactory.js';
import '@emotion/react';
import 'tinycolor2';

const FullWidthButtonContainer = ({ className, children }) => {
  const styles = getStyles();
  return /* @__PURE__ */ React__default.createElement("div", { className: cx(styles, className) }, children);
};
const getStyles = stylesFactory(() => {
  return css`
    display: flex;

    button {
      flex-grow: 1;
      justify-content: center;
    }

    > * {
      flex-grow: 1;
    }

    label {
      flex-grow: 1;
      text-align: center;
    }
  `;
});

export { FullWidthButtonContainer };
//# sourceMappingURL=FullWidthButtonContainer.js.map
