import { cx, css } from '@emotion/css';
import React__default from 'react';
import { selectors } from '@grafana/e2e-selectors';
import { useTheme2 } from '../../themes/ThemeContext.js';
import '@grafana/data';
import 'memoize-one';
import '@emotion/react';
import 'tinycolor2';
import { Button } from '../Button/Button.js';
import { Icon } from '../Icon/Icon.js';
import { IconButton } from '../IconButton/IconButton.js';

var __defProp = Object.defineProperty;
var __getOwnPropSymbols = Object.getOwnPropertySymbols;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __propIsEnum = Object.prototype.propertyIsEnumerable;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp.call(b, prop))
      __defNormalProp(a, prop, b[prop]);
  if (__getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(b)) {
      if (__propIsEnum.call(b, prop))
        __defNormalProp(a, prop, b[prop]);
    }
  return a;
};
var __objRest = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
const Alert = React__default.forwardRef(
  (_a, ref) => {
    var _b = _a, {
      title,
      onRemove,
      children,
      buttonContent,
      elevated,
      bottomSpacing,
      topSpacing,
      className,
      severity = "error"
    } = _b, restProps = __objRest(_b, [
      "title",
      "onRemove",
      "children",
      "buttonContent",
      "elevated",
      "bottomSpacing",
      "topSpacing",
      "className",
      "severity"
    ]);
    const theme = useTheme2();
    const hasTitle = Boolean(title);
    const styles = getStyles(theme, severity, hasTitle, elevated, bottomSpacing, topSpacing);
    const rolesBySeverity = {
      error: "alert",
      warning: "alert",
      info: "status",
      success: "status"
    };
    const role = restProps["role"] || rolesBySeverity[severity];
    const ariaLabel = restProps["aria-label"] || title;
    return /* @__PURE__ */ React__default.createElement(
      "div",
      __spreadValues({
        ref,
        className: cx(styles.alert, className),
        "data-testid": selectors.components.Alert.alertV2(severity),
        role,
        "aria-label": ariaLabel
      }, restProps),
      /* @__PURE__ */ React__default.createElement("div", { className: styles.icon }, /* @__PURE__ */ React__default.createElement(Icon, { size: "xl", name: getIconFromSeverity(severity) })),
      /* @__PURE__ */ React__default.createElement("div", { className: styles.body }, /* @__PURE__ */ React__default.createElement("div", { className: styles.title }, title), children && /* @__PURE__ */ React__default.createElement("div", { className: styles.content }, children)),
      onRemove && !buttonContent && /* @__PURE__ */ React__default.createElement("div", { className: styles.close }, /* @__PURE__ */ React__default.createElement(IconButton, { "aria-label": "Close alert", name: "times", onClick: onRemove, size: "lg", type: "button" })),
      onRemove && buttonContent && /* @__PURE__ */ React__default.createElement("div", { className: styles.buttonWrapper }, /* @__PURE__ */ React__default.createElement(Button, { "aria-label": "Close alert", variant: "secondary", onClick: onRemove, type: "button" }, buttonContent))
    );
  }
);
Alert.displayName = "Alert";
const getIconFromSeverity = (severity) => {
  switch (severity) {
    case "error":
    case "warning":
      return "exclamation-triangle";
    case "info":
      return "info-circle";
    case "success":
      return "check";
  }
};
const getStyles = (theme, severity, hasTitle, elevated, bottomSpacing, topSpacing) => {
  const color = theme.colors[severity];
  const borderRadius = theme.shape.borderRadius();
  return {
    alert: css`
      flex-grow: 1;
      position: relative;
      border-radius: ${borderRadius};
      display: flex;
      flex-direction: row;
      align-items: stretch;
      background: ${theme.colors.background.secondary};
      box-shadow: ${elevated ? theme.shadows.z3 : theme.shadows.z1};
      margin-bottom: ${theme.spacing(bottomSpacing != null ? bottomSpacing : 2)};
      margin-top: ${theme.spacing(topSpacing != null ? topSpacing : 0)};

      &:before {
        content: '';
        position: absolute;
        top: 0;
        left: 0;
        bottom: 0;
        right: 0;
        background: ${theme.colors.background.primary};
        z-index: -1;
      }
    `,
    icon: css`
      padding: ${theme.spacing(2, 3)};
      background: ${color.main};
      border-radius: ${borderRadius} 0 0 ${borderRadius};
      color: ${color.contrastText};
      display: flex;
      align-items: center;
      justify-content: center;
    `,
    title: css`
      font-weight: ${theme.typography.fontWeightMedium};
      color: ${theme.colors.text.primary};
    `,
    body: css`
      color: ${theme.colors.text.secondary};
      padding: ${theme.spacing(2)};
      flex-grow: 1;
      display: flex;
      flex-direction: column;
      justify-content: center;
      overflow-wrap: break-word;
      word-break: break-word;
    `,
    content: css`
      color: ${theme.colors.text.secondary};
      padding-top: ${hasTitle ? theme.spacing(1) : 0};
      max-height: 50vh;
      overflow-y: auto;
    `,
    buttonWrapper: css`
      padding: ${theme.spacing(1)};
      background: none;
      display: flex;
      align-items: center;
    `,
    close: css`
      padding: ${theme.spacing(2, 1)};
      background: none;
      display: flex;
    `
  };
};

export { Alert, getIconFromSeverity };
//# sourceMappingURL=Alert.js.map
