/*!-----------------------------------------------------------------------------
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * monaco-kusto version: 5.3.6(undefined)
 * Released under the MIT license
 * https://https://github.com/Azure/monaco-kusto/blob/master/README.md
 *-----------------------------------------------------------------------------*/define("vs/language/kusto/languageService/schema",["require","exports"],function(R,a){"use strict";Object.defineProperty(a,"__esModule",{value:!0}),a.getInputParametersAsCslString=a.getExpression=a.getCallName=a.getEntityDataTypeFromCslType=a.getCslTypeNameFromClrType=void 0;var G={"System.SByte":"bool","System.Byte":"uint8","System.Int16":"int16","System.UInt16":"uint16","System.Int32":"int","System.UInt32":"uint","System.Int64":"long","System.UInt64":"ulong","System.String":"string","System.Single":"float","System.Double":"real","System.DateTime":"datetime","System.TimeSpan":"timespan","System.Guid":"guid","System.Boolean":"bool","Newtonsoft.Json.Linq.JArray":"dynamic","Newtonsoft.Json.Linq.JObject":"dynamic","Newtonsoft.Json.Linq.JToken":"dynamic","System.Object":"dynamic","System.Data.SqlTypes.SqlDecimal":"decimal"};a.getCslTypeNameFromClrType=function(_){return G[_]||_};var b={object:"Object",bool:"Boolean",uint8:"Byte",int16:"Int16",uint16:"UInt16",int:"Int32",uint:"UInt32",long:"Int64",ulong:"UInt64",float:"Single",real:"Double",decimal:"Decimal",datetime:"DateTime",string:"String",dynamic:"Dynamic",timespan:"TimeSpan"};a.getEntityDataTypeFromCslType=function(_){return b[_]||_},a.getCallName=function(_){return _.name+"("+_.inputParameters.map(function(c){return"{"+c.name+"}"}).join(",")+")"},a.getExpression=function(_){return"let "+_.name+" = "+a.getInputParametersAsCslString(_.inputParameters)+" "+_.body},a.getInputParametersAsCslString=function(_){return"("+_.map(function(c){return K(c)}).join(",")+")"};var K=function(_){if(_.columns&&_.columns.length>0){var c=_.columns.map(function(x){return x.name+":"+(x.cslType||a.getCslTypeNameFromClrType(x.type))}).join(",");return _.name+":"+(c===""?"*":c)}return _.name+":"+(_.cslType||a.getCslTypeNameFromClrType(_.type))}}),function(R){if(typeof module=="object"&&typeof module.exports=="object"){var a=R(require,exports);a!==void 0&&(module.exports=a)}else typeof define=="function"&&define.amd&&define("vscode-languageserver-types/main",["require","exports"],R)}(function(R,a){"use strict";var G,b,K,_,c,x,s,E,L,j,D,A,N,M,U,F,p;Object.defineProperty(a,"__esModule",{value:!0}),a.TextDocument=a.EOL=a.SelectionRange=a.DocumentLink=a.FormattingOptions=a.CodeLens=a.CodeAction=a.CodeActionContext=a.CodeActionKind=a.DocumentSymbol=a.SymbolInformation=a.SymbolTag=a.SymbolKind=a.DocumentHighlight=a.DocumentHighlightKind=a.SignatureInformation=a.ParameterInformation=a.Hover=a.MarkedString=a.CompletionList=a.CompletionItem=a.InsertTextMode=a.InsertReplaceEdit=a.CompletionItemTag=a.InsertTextFormat=a.CompletionItemKind=a.MarkupContent=a.MarkupKind=a.TextDocumentItem=a.OptionalVersionedTextDocumentIdentifier=a.VersionedTextDocumentIdentifier=a.TextDocumentIdentifier=a.WorkspaceChange=a.WorkspaceEdit=a.DeleteFile=a.RenameFile=a.CreateFile=a.TextDocumentEdit=a.AnnotatedTextEdit=a.ChangeAnnotationIdentifier=a.ChangeAnnotation=a.TextEdit=a.Command=a.Diagnostic=a.CodeDescription=a.DiagnosticTag=a.DiagnosticSeverity=a.DiagnosticRelatedInformation=a.FoldingRange=a.FoldingRangeKind=a.ColorPresentation=a.ColorInformation=a.Color=a.LocationLink=a.Location=a.Range=a.Position=a.uinteger=a.integer=void 0,function(d){d.MIN_VALUE=-2147483648,d.MAX_VALUE=2147483647}(a.integer||(a.integer={})),function(d){d.MIN_VALUE=0,d.MAX_VALUE=2147483647}(G=a.uinteger||(a.uinteger={})),function(d){d.create=function(u,e){return u===Number.MAX_VALUE&&(u=G.MAX_VALUE),e===Number.MAX_VALUE&&(e=G.MAX_VALUE),{line:u,character:e}},d.is=function(u){var e=u;return f.objectLiteral(e)&&f.uinteger(e.line)&&f.uinteger(e.character)}}(b=a.Position||(a.Position={})),function(d){d.create=function(u,e,i,g){if(f.uinteger(u)&&f.uinteger(e)&&f.uinteger(i)&&f.uinteger(g))return{start:b.create(u,e),end:b.create(i,g)};if(b.is(u)&&b.is(e))return{start:u,end:e};throw new Error("Range#create called with invalid arguments["+u+", "+e+", "+i+", "+g+"]")},d.is=function(u){var e=u;return f.objectLiteral(e)&&b.is(e.start)&&b.is(e.end)}}(K=a.Range||(a.Range={})),function(d){d.create=function(u,e){return{uri:u,range:e}},d.is=function(u){var e=u;return f.defined(e)&&K.is(e.range)&&(f.string(e.uri)||f.undefined(e.uri))}}(_=a.Location||(a.Location={})),function(d){d.create=function(u,e,i,g){return{targetUri:u,targetRange:e,targetSelectionRange:i,originSelectionRange:g}},d.is=function(u){var e=u;return f.defined(e)&&K.is(e.targetRange)&&f.string(e.targetUri)&&(K.is(e.targetSelectionRange)||f.undefined(e.targetSelectionRange))&&(K.is(e.originSelectionRange)||f.undefined(e.originSelectionRange))}}(a.LocationLink||(a.LocationLink={})),function(d){d.create=function(u,e,i,g){return{red:u,green:e,blue:i,alpha:g}},d.is=function(u){var e=u;return f.numberRange(e.red,0,1)&&f.numberRange(e.green,0,1)&&f.numberRange(e.blue,0,1)&&f.numberRange(e.alpha,0,1)}}(c=a.Color||(a.Color={})),function(d){d.create=function(u,e){return{range:u,color:e}},d.is=function(u){var e=u;return K.is(e.range)&&c.is(e.color)}}(a.ColorInformation||(a.ColorInformation={})),function(d){d.create=function(u,e,i){return{label:u,textEdit:e,additionalTextEdits:i}},d.is=function(u){var e=u;return f.string(e.label)&&(f.undefined(e.textEdit)||L.is(e))&&(f.undefined(e.additionalTextEdits)||f.typedArray(e.additionalTextEdits,L.is))}}(a.ColorPresentation||(a.ColorPresentation={})),function(d){d.Comment="comment",d.Imports="imports",d.Region="region"}(a.FoldingRangeKind||(a.FoldingRangeKind={})),function(d){d.create=function(u,e,i,g,v){var t={startLine:u,endLine:e};return f.defined(i)&&(t.startCharacter=i),f.defined(g)&&(t.endCharacter=g),f.defined(v)&&(t.kind=v),t},d.is=function(u){var e=u;return f.uinteger(e.startLine)&&f.uinteger(e.startLine)&&(f.undefined(e.startCharacter)||f.uinteger(e.startCharacter))&&(f.undefined(e.endCharacter)||f.uinteger(e.endCharacter))&&(f.undefined(e.kind)||f.string(e.kind))}}(a.FoldingRange||(a.FoldingRange={})),function(d){d.create=function(u,e){return{location:u,message:e}},d.is=function(u){var e=u;return f.defined(e)&&_.is(e.location)&&f.string(e.message)}}(x=a.DiagnosticRelatedInformation||(a.DiagnosticRelatedInformation={})),function(d){d.Error=1,d.Warning=2,d.Information=3,d.Hint=4}(a.DiagnosticSeverity||(a.DiagnosticSeverity={})),function(d){d.Unnecessary=1,d.Deprecated=2}(a.DiagnosticTag||(a.DiagnosticTag={})),function(d){d.is=function(u){var e=u;return e!=null&&f.string(e.href)}}(a.CodeDescription||(a.CodeDescription={})),function(d){d.create=function(u,e,i,g,v,t){var h={range:u,message:e};return f.defined(i)&&(h.severity=i),f.defined(g)&&(h.code=g),f.defined(v)&&(h.source=v),f.defined(t)&&(h.relatedInformation=t),h},d.is=function(u){var e,i=u;return f.defined(i)&&K.is(i.range)&&f.string(i.message)&&(f.number(i.severity)||f.undefined(i.severity))&&(f.integer(i.code)||f.string(i.code)||f.undefined(i.code))&&(f.undefined(i.codeDescription)||f.string((e=i.codeDescription)===null||e===void 0?void 0:e.href))&&(f.string(i.source)||f.undefined(i.source))&&(f.undefined(i.relatedInformation)||f.typedArray(i.relatedInformation,x.is))}}(s=a.Diagnostic||(a.Diagnostic={})),function(d){d.create=function(u,e){for(var i=[],g=2;g<arguments.length;g++)i[g-2]=arguments[g];var v={title:u,command:e};return f.defined(i)&&i.length>0&&(v.arguments=i),v},d.is=function(u){var e=u;return f.defined(e)&&f.string(e.title)&&f.string(e.command)}}(E=a.Command||(a.Command={})),function(d){d.replace=function(u,e){return{range:u,newText:e}},d.insert=function(u,e){return{range:{start:u,end:u},newText:e}},d.del=function(u){return{range:u,newText:""}},d.is=function(u){var e=u;return f.objectLiteral(e)&&f.string(e.newText)&&K.is(e.range)}}(L=a.TextEdit||(a.TextEdit={})),function(d){d.create=function(u,e,i){var g={label:u};return e!==void 0&&(g.needsConfirmation=e),i!==void 0&&(g.description=i),g},d.is=function(u){var e=u;return e!==void 0&&f.objectLiteral(e)&&f.string(e.label)&&(f.boolean(e.needsConfirmation)||e.needsConfirmation===void 0)&&(f.string(e.description)||e.description===void 0)}}(j=a.ChangeAnnotation||(a.ChangeAnnotation={})),function(d){d.is=function(u){return typeof u=="string"}}(D=a.ChangeAnnotationIdentifier||(a.ChangeAnnotationIdentifier={})),function(d){d.replace=function(u,e,i){return{range:u,newText:e,annotationId:i}},d.insert=function(u,e,i){return{range:{start:u,end:u},newText:e,annotationId:i}},d.del=function(u,e){return{range:u,newText:"",annotationId:e}},d.is=function(u){var e=u;return L.is(e)&&(j.is(e.annotationId)||D.is(e.annotationId))}}(A=a.AnnotatedTextEdit||(a.AnnotatedTextEdit={})),function(d){d.create=function(u,e){return{textDocument:u,edits:e}},d.is=function(u){var e=u;return f.defined(e)&&n.is(e.textDocument)&&Array.isArray(e.edits)}}(N=a.TextDocumentEdit||(a.TextDocumentEdit={})),function(d){d.create=function(u,e,i){var g={kind:"create",uri:u};return e===void 0||e.overwrite===void 0&&e.ignoreIfExists===void 0||(g.options=e),i!==void 0&&(g.annotationId=i),g},d.is=function(u){var e=u;return e&&e.kind==="create"&&f.string(e.uri)&&(e.options===void 0||(e.options.overwrite===void 0||f.boolean(e.options.overwrite))&&(e.options.ignoreIfExists===void 0||f.boolean(e.options.ignoreIfExists)))&&(e.annotationId===void 0||D.is(e.annotationId))}}(M=a.CreateFile||(a.CreateFile={})),function(d){d.create=function(u,e,i,g){var v={kind:"rename",oldUri:u,newUri:e};return i===void 0||i.overwrite===void 0&&i.ignoreIfExists===void 0||(v.options=i),g!==void 0&&(v.annotationId=g),v},d.is=function(u){var e=u;return e&&e.kind==="rename"&&f.string(e.oldUri)&&f.string(e.newUri)&&(e.options===void 0||(e.options.overwrite===void 0||f.boolean(e.options.overwrite))&&(e.options.ignoreIfExists===void 0||f.boolean(e.options.ignoreIfExists)))&&(e.annotationId===void 0||D.is(e.annotationId))}}(U=a.RenameFile||(a.RenameFile={})),function(d){d.create=function(u,e,i){var g={kind:"delete",uri:u};return e===void 0||e.recursive===void 0&&e.ignoreIfNotExists===void 0||(g.options=e),i!==void 0&&(g.annotationId=i),g},d.is=function(u){var e=u;return e&&e.kind==="delete"&&f.string(e.uri)&&(e.options===void 0||(e.options.recursive===void 0||f.boolean(e.options.recursive))&&(e.options.ignoreIfNotExists===void 0||f.boolean(e.options.ignoreIfNotExists)))&&(e.annotationId===void 0||D.is(e.annotationId))}}(F=a.DeleteFile||(a.DeleteFile={})),function(d){d.is=function(u){var e=u;return e&&(e.changes!==void 0||e.documentChanges!==void 0)&&(e.documentChanges===void 0||e.documentChanges.every(function(i){return f.string(i.kind)?M.is(i)||U.is(i)||F.is(i):N.is(i)}))}}(p=a.WorkspaceEdit||(a.WorkspaceEdit={}));var n,o,r,l,m=function(){function d(u,e){this.edits=u,this.changeAnnotations=e}return d.prototype.insert=function(u,e,i){var g,v;if(i===void 0?g=L.insert(u,e):D.is(i)?(v=i,g=A.insert(u,e,i)):(this.assertChangeAnnotations(this.changeAnnotations),v=this.changeAnnotations.manage(i),g=A.insert(u,e,v)),this.edits.push(g),v!==void 0)return v},d.prototype.replace=function(u,e,i){var g,v;if(i===void 0?g=L.replace(u,e):D.is(i)?(v=i,g=A.replace(u,e,i)):(this.assertChangeAnnotations(this.changeAnnotations),v=this.changeAnnotations.manage(i),g=A.replace(u,e,v)),this.edits.push(g),v!==void 0)return v},d.prototype.delete=function(u,e){var i,g;if(e===void 0?i=L.del(u):D.is(e)?(g=e,i=A.del(u,e)):(this.assertChangeAnnotations(this.changeAnnotations),g=this.changeAnnotations.manage(e),i=A.del(u,g)),this.edits.push(i),g!==void 0)return g},d.prototype.add=function(u){this.edits.push(u)},d.prototype.all=function(){return this.edits},d.prototype.clear=function(){this.edits.splice(0,this.edits.length)},d.prototype.assertChangeAnnotations=function(u){if(u===void 0)throw new Error("Text edit change is not configured to manage change annotations.")},d}(),y=function(){function d(u){this._annotations=u===void 0?Object.create(null):u,this._counter=0,this._size=0}return d.prototype.all=function(){return this._annotations},Object.defineProperty(d.prototype,"size",{get:function(){return this._size},enumerable:!1,configurable:!0}),d.prototype.manage=function(u,e){var i;if(D.is(u)?i=u:(i=this.nextId(),e=u),this._annotations[i]!==void 0)throw new Error("Id "+i+" is already in use.");if(e===void 0)throw new Error("No annotation provided for id "+i);return this._annotations[i]=e,this._size++,i},d.prototype.nextId=function(){return this._counter++,this._counter.toString()},d}(),C=function(){function d(u){var e=this;this._textEditChanges=Object.create(null),u!==void 0?(this._workspaceEdit=u,u.documentChanges?(this._changeAnnotations=new y(u.changeAnnotations),u.changeAnnotations=this._changeAnnotations.all(),u.documentChanges.forEach(function(i){if(N.is(i)){var g=new m(i.edits,e._changeAnnotations);e._textEditChanges[i.textDocument.uri]=g}})):u.changes&&Object.keys(u.changes).forEach(function(i){var g=new m(u.changes[i]);e._textEditChanges[i]=g})):this._workspaceEdit={}}return Object.defineProperty(d.prototype,"edit",{get:function(){return this.initDocumentChanges(),this._changeAnnotations!==void 0&&(this._changeAnnotations.size===0?this._workspaceEdit.changeAnnotations=void 0:this._workspaceEdit.changeAnnotations=this._changeAnnotations.all()),this._workspaceEdit},enumerable:!1,configurable:!0}),d.prototype.getTextEditChange=function(u){if(n.is(u)){if(this.initDocumentChanges(),this._workspaceEdit.documentChanges===void 0)throw new Error("Workspace edit is not configured for document changes.");var e={uri:u.uri,version:u.version};if(!(g=this._textEditChanges[e.uri])){var i={textDocument:e,edits:v=[]};this._workspaceEdit.documentChanges.push(i),g=new m(v,this._changeAnnotations),this._textEditChanges[e.uri]=g}return g}if(this.initChanges(),this._workspaceEdit.changes===void 0)throw new Error("Workspace edit is not configured for normal text edit changes.");var g;if(!(g=this._textEditChanges[u])){var v=[];this._workspaceEdit.changes[u]=v,g=new m(v),this._textEditChanges[u]=g}return g},d.prototype.initDocumentChanges=function(){this._workspaceEdit.documentChanges===void 0&&this._workspaceEdit.changes===void 0&&(this._changeAnnotations=new y,this._workspaceEdit.documentChanges=[],this._workspaceEdit.changeAnnotations=this._changeAnnotations.all())},d.prototype.initChanges=function(){this._workspaceEdit.documentChanges===void 0&&this._workspaceEdit.changes===void 0&&(this._workspaceEdit.changes=Object.create(null))},d.prototype.createFile=function(u,e,i){if(this.initDocumentChanges(),this._workspaceEdit.documentChanges===void 0)throw new Error("Workspace edit is not configured for document changes.");var g,v,t;if(j.is(e)||D.is(e)?g=e:i=e,g===void 0?v=M.create(u,i):(t=D.is(g)?g:this._changeAnnotations.manage(g),v=M.create(u,i,t)),this._workspaceEdit.documentChanges.push(v),t!==void 0)return t},d.prototype.renameFile=function(u,e,i,g){if(this.initDocumentChanges(),this._workspaceEdit.documentChanges===void 0)throw new Error("Workspace edit is not configured for document changes.");var v,t,h;if(j.is(i)||D.is(i)?v=i:g=i,v===void 0?t=U.create(u,e,g):(h=D.is(v)?v:this._changeAnnotations.manage(v),t=U.create(u,e,g,h)),this._workspaceEdit.documentChanges.push(t),h!==void 0)return h},d.prototype.deleteFile=function(u,e,i){if(this.initDocumentChanges(),this._workspaceEdit.documentChanges===void 0)throw new Error("Workspace edit is not configured for document changes.");var g,v,t;if(j.is(e)||D.is(e)?g=e:i=e,g===void 0?v=F.create(u,i):(t=D.is(g)?g:this._changeAnnotations.manage(g),v=F.create(u,i,t)),this._workspaceEdit.documentChanges.push(v),t!==void 0)return t},d}();a.WorkspaceChange=C,function(d){d.create=function(u){return{uri:u}},d.is=function(u){var e=u;return f.defined(e)&&f.string(e.uri)}}(a.TextDocumentIdentifier||(a.TextDocumentIdentifier={})),function(d){d.create=function(u,e){return{uri:u,version:e}},d.is=function(u){var e=u;return f.defined(e)&&f.string(e.uri)&&f.integer(e.version)}}(a.VersionedTextDocumentIdentifier||(a.VersionedTextDocumentIdentifier={})),function(d){d.create=function(u,e){return{uri:u,version:e}},d.is=function(u){var e=u;return f.defined(e)&&f.string(e.uri)&&(e.version===null||f.integer(e.version))}}(n=a.OptionalVersionedTextDocumentIdentifier||(a.OptionalVersionedTextDocumentIdentifier={})),function(d){d.create=function(u,e,i,g){return{uri:u,languageId:e,version:i,text:g}},d.is=function(u){var e=u;return f.defined(e)&&f.string(e.uri)&&f.string(e.languageId)&&f.integer(e.version)&&f.string(e.text)}}(a.TextDocumentItem||(a.TextDocumentItem={})),function(d){d.PlainText="plaintext",d.Markdown="markdown"}(o=a.MarkupKind||(a.MarkupKind={})),function(d){d.is=function(u){var e=u;return e===d.PlainText||e===d.Markdown}}(o=a.MarkupKind||(a.MarkupKind={})),function(d){d.is=function(u){var e=u;return f.objectLiteral(u)&&o.is(e.kind)&&f.string(e.value)}}(r=a.MarkupContent||(a.MarkupContent={})),function(d){d.Text=1,d.Method=2,d.Function=3,d.Constructor=4,d.Field=5,d.Variable=6,d.Class=7,d.Interface=8,d.Module=9,d.Property=10,d.Unit=11,d.Value=12,d.Enum=13,d.Keyword=14,d.Snippet=15,d.Color=16,d.File=17,d.Reference=18,d.Folder=19,d.EnumMember=20,d.Constant=21,d.Struct=22,d.Event=23,d.Operator=24,d.TypeParameter=25}(a.CompletionItemKind||(a.CompletionItemKind={})),function(d){d.PlainText=1,d.Snippet=2}(a.InsertTextFormat||(a.InsertTextFormat={})),function(d){d.Deprecated=1}(a.CompletionItemTag||(a.CompletionItemTag={})),function(d){d.create=function(u,e,i){return{newText:u,insert:e,replace:i}},d.is=function(u){var e=u;return e&&f.string(e.newText)&&K.is(e.insert)&&K.is(e.replace)}}(a.InsertReplaceEdit||(a.InsertReplaceEdit={})),function(d){d.asIs=1,d.adjustIndentation=2}(a.InsertTextMode||(a.InsertTextMode={})),function(d){d.create=function(u){return{label:u}}}(a.CompletionItem||(a.CompletionItem={})),function(d){d.create=function(u,e){return{items:u||[],isIncomplete:!!e}}}(a.CompletionList||(a.CompletionList={})),function(d){d.fromPlainText=function(u){return u.replace(/[\\`*_{}[\]()#+\-.!]/g,"\\$&")},d.is=function(u){var e=u;return f.string(e)||f.objectLiteral(e)&&f.string(e.language)&&f.string(e.value)}}(l=a.MarkedString||(a.MarkedString={})),function(d){d.is=function(u){var e=u;return!!e&&f.objectLiteral(e)&&(r.is(e.contents)||l.is(e.contents)||f.typedArray(e.contents,l.is))&&(u.range===void 0||K.is(u.range))}}(a.Hover||(a.Hover={})),function(d){d.create=function(u,e){return e?{label:u,documentation:e}:{label:u}}}(a.ParameterInformation||(a.ParameterInformation={})),function(d){d.create=function(u,e){for(var i=[],g=2;g<arguments.length;g++)i[g-2]=arguments[g];var v={label:u};return f.defined(e)&&(v.documentation=e),f.defined(i)?v.parameters=i:v.parameters=[],v}}(a.SignatureInformation||(a.SignatureInformation={})),function(d){d.Text=1,d.Read=2,d.Write=3}(a.DocumentHighlightKind||(a.DocumentHighlightKind={})),function(d){d.create=function(u,e){var i={range:u};return f.number(e)&&(i.kind=e),i}}(a.DocumentHighlight||(a.DocumentHighlight={})),function(d){d.File=1,d.Module=2,d.Namespace=3,d.Package=4,d.Class=5,d.Method=6,d.Property=7,d.Field=8,d.Constructor=9,d.Enum=10,d.Interface=11,d.Function=12,d.Variable=13,d.Constant=14,d.String=15,d.Number=16,d.Boolean=17,d.Array=18,d.Object=19,d.Key=20,d.Null=21,d.EnumMember=22,d.Struct=23,d.Event=24,d.Operator=25,d.TypeParameter=26}(a.SymbolKind||(a.SymbolKind={})),function(d){d.Deprecated=1}(a.SymbolTag||(a.SymbolTag={})),function(d){d.create=function(u,e,i,g,v){var t={name:u,kind:e,location:{uri:g,range:i}};return v&&(t.containerName=v),t}}(a.SymbolInformation||(a.SymbolInformation={})),function(d){d.create=function(u,e,i,g,v,t){var h={name:u,detail:e,kind:i,range:g,selectionRange:v};return t!==void 0&&(h.children=t),h},d.is=function(u){var e=u;return e&&f.string(e.name)&&f.number(e.kind)&&K.is(e.range)&&K.is(e.selectionRange)&&(e.detail===void 0||f.string(e.detail))&&(e.deprecated===void 0||f.boolean(e.deprecated))&&(e.children===void 0||Array.isArray(e.children))&&(e.tags===void 0||Array.isArray(e.tags))}}(a.DocumentSymbol||(a.DocumentSymbol={})),function(d){d.Empty="",d.QuickFix="quickfix",d.Refactor="refactor",d.RefactorExtract="refactor.extract",d.RefactorInline="refactor.inline",d.RefactorRewrite="refactor.rewrite",d.Source="source",d.SourceOrganizeImports="source.organizeImports",d.SourceFixAll="source.fixAll"}(a.CodeActionKind||(a.CodeActionKind={})),function(d){d.create=function(u,e){var i={diagnostics:u};return e!=null&&(i.only=e),i},d.is=function(u){var e=u;return f.defined(e)&&f.typedArray(e.diagnostics,s.is)&&(e.only===void 0||f.typedArray(e.only,f.string))}}(a.CodeActionContext||(a.CodeActionContext={})),function(d){d.create=function(u,e,i){var g={title:u},v=!0;return typeof e=="string"?(v=!1,g.kind=e):E.is(e)?g.command=e:g.edit=e,v&&i!==void 0&&(g.kind=i),g},d.is=function(u){var e=u;return e&&f.string(e.title)&&(e.diagnostics===void 0||f.typedArray(e.diagnostics,s.is))&&(e.kind===void 0||f.string(e.kind))&&(e.edit!==void 0||e.command!==void 0)&&(e.command===void 0||E.is(e.command))&&(e.isPreferred===void 0||f.boolean(e.isPreferred))&&(e.edit===void 0||p.is(e.edit))}}(a.CodeAction||(a.CodeAction={})),function(d){d.create=function(u,e){var i={range:u};return f.defined(e)&&(i.data=e),i},d.is=function(u){var e=u;return f.defined(e)&&K.is(e.range)&&(f.undefined(e.command)||E.is(e.command))}}(a.CodeLens||(a.CodeLens={})),function(d){d.create=function(u,e){return{tabSize:u,insertSpaces:e}},d.is=function(u){var e=u;return f.defined(e)&&f.uinteger(e.tabSize)&&f.boolean(e.insertSpaces)}}(a.FormattingOptions||(a.FormattingOptions={})),function(d){d.create=function(u,e,i){return{range:u,target:e,data:i}},d.is=function(u){var e=u;return f.defined(e)&&K.is(e.range)&&(f.undefined(e.target)||f.string(e.target))}}(a.DocumentLink||(a.DocumentLink={})),function(d){d.create=function(u,e){return{range:u,parent:e}},d.is=function(u){var e=u;return e!==void 0&&K.is(e.range)&&(e.parent===void 0||d.is(e.parent))}}(a.SelectionRange||(a.SelectionRange={})),a.EOL=[`
`,`\r
`,"\r"],function(d){d.create=function(u,e,i,g){return new P(u,e,i,g)},d.is=function(u){var e=u;return!!(f.defined(e)&&f.string(e.uri)&&(f.undefined(e.languageId)||f.string(e.languageId))&&f.uinteger(e.lineCount)&&f.func(e.getText)&&f.func(e.positionAt)&&f.func(e.offsetAt))},d.applyEdits=function(u,e){for(var i=u.getText(),g=function k(w,T){if(w.length<=1)return w;var O=w.length/2|0,V=w.slice(0,O),B=w.slice(O);k(V,T),k(B,T);for(var $=0,J=0,H=0;$<V.length&&J<B.length;){var z=T(V[$],B[J]);w[H++]=z<=0?V[$++]:B[J++]}for(;$<V.length;)w[H++]=V[$++];for(;J<B.length;)w[H++]=B[J++];return w}(e,function(k,w){var T=k.range.start.line-w.range.start.line;return T===0?k.range.start.character-w.range.start.character:T}),v=i.length,t=g.length-1;t>=0;t--){var h=g[t],I=u.offsetAt(h.range.start),S=u.offsetAt(h.range.end);if(!(S<=v))throw new Error("Overlapping edit");i=i.substring(0,I)+h.newText+i.substring(S,i.length),v=I}return i}}(a.TextDocument||(a.TextDocument={}));var f,P=function(){function d(u,e,i,g){this._uri=u,this._languageId=e,this._version=i,this._content=g,this._lineOffsets=void 0}return Object.defineProperty(d.prototype,"uri",{get:function(){return this._uri},enumerable:!1,configurable:!0}),Object.defineProperty(d.prototype,"languageId",{get:function(){return this._languageId},enumerable:!1,configurable:!0}),Object.defineProperty(d.prototype,"version",{get:function(){return this._version},enumerable:!1,configurable:!0}),d.prototype.getText=function(u){if(u){var e=this.offsetAt(u.start),i=this.offsetAt(u.end);return this._content.substring(e,i)}return this._content},d.prototype.update=function(u,e){this._content=u.text,this._version=e,this._lineOffsets=void 0},d.prototype.getLineOffsets=function(){if(this._lineOffsets===void 0){for(var u=[],e=this._content,i=!0,g=0;g<e.length;g++){i&&(u.push(g),i=!1);var v=e.charAt(g);i=v==="\r"||v===`
`,v==="\r"&&g+1<e.length&&e.charAt(g+1)===`
`&&g++}i&&e.length>0&&u.push(e.length),this._lineOffsets=u}return this._lineOffsets},d.prototype.positionAt=function(u){u=Math.max(Math.min(u,this._content.length),0);var e=this.getLineOffsets(),i=0,g=e.length;if(g===0)return b.create(0,u);for(;i<g;){var v=Math.floor((i+g)/2);e[v]>u?g=v:i=v+1}var t=i-1;return b.create(t,u-e[t])},d.prototype.offsetAt=function(u){var e=this.getLineOffsets();if(u.line>=e.length)return this._content.length;if(u.line<0)return 0;var i=e[u.line],g=u.line+1<e.length?e[u.line+1]:this._content.length;return Math.max(Math.min(i+u.character,g),i)},Object.defineProperty(d.prototype,"lineCount",{get:function(){return this.getLineOffsets().length},enumerable:!1,configurable:!0}),d}();(function(d){var u=Object.prototype.toString;d.defined=function(e){return e!==void 0},d.undefined=function(e){return e===void 0},d.boolean=function(e){return e===!0||e===!1},d.string=function(e){return u.call(e)==="[object String]"},d.number=function(e){return u.call(e)==="[object Number]"},d.numberRange=function(e,i,g){return u.call(e)==="[object Number]"&&i<=e&&e<=g},d.integer=function(e){return u.call(e)==="[object Number]"&&-2147483648<=e&&e<=2147483647},d.uinteger=function(e){return u.call(e)==="[object Number]"&&0<=e&&e<=2147483647},d.func=function(e){return u.call(e)==="[object Function]"},d.objectLiteral=function(e){return e!==null&&typeof e=="object"},d.typedArray=function(e,i){return Array.isArray(e)&&e.every(i)}})(f||(f={}))}),define("vscode-languageserver-types",["vscode-languageserver-types/main"],function(R){return R}),function(R){typeof exports=="object"&&typeof module<"u"?module.exports=R():typeof define=="function"&&define.amd?define("xregexp/xregexp-all",[],R):(typeof window<"u"?window:typeof global<"u"?global:typeof self<"u"?self:this).XRegExp=R()}(function(){return function R(a,G,b){function K(x,s){if(!G[x]){if(!a[x]){var E=typeof require=="function"&&require;if(!s&&E)return E(x,!0);if(_)return _(x,!0);var L=new Error("Cannot find module '"+x+"'");throw L.code="MODULE_NOT_FOUND",L}var j=G[x]={exports:{}};a[x][0].call(j.exports,function(D){var A=a[x][1][D];return K(A||D)},j,j.exports,R,a,G,b)}return G[x].exports}for(var _=typeof require=="function"&&require,c=0;c<b.length;c++)K(b[c]);return K}({1:[function(R,a,G){/*!
 * XRegExp.build 3.2.0
 * <xregexp.com>
 * Steven Levithan (c) 2012-2017 MIT License
 * Inspired by Lea Verou's RegExp.create <lea.verou.me>
 */a.exports=function(b){"use strict";var K=/(\()(?!\?)|\\([1-9]\d*)|\\[\s\S]|\[(?:[^\\\]]|\\[\s\S])*\]/g,_=b.union([/\({{([\w$]+)}}\)|{{([\w$]+)}}/,K],"g",{conjunction:"or"});function c(s){var E=/^(?:\(\?:\))*\^/,L=/\$(?:\(\?:\))*$/;return E.test(s)&&L.test(s)&&L.test(s.replace(/\\[\s\S]/g,""))?s.replace(E,"").replace(L,""):s}function x(s,E){var L=E?"x":"";return b.isRegExp(s)?s.xregexp&&s.xregexp.captureNames?s:b(s.source,L):b(s,L)}b.build=function(s,E,L){var j=(L=L||"").indexOf("x")>-1,D=/^\(\?([\w$]+)\)/.exec(s);D&&(L=b._clipDuplicates(L+D[1]));var A={};for(var N in E)if(E.hasOwnProperty(N)){var M=x(E[N],j);A[N]={pattern:c(M.source),names:M.xregexp.captureNames||[]}}var U,F=x(s,j),p=0,n=0,o=[0],r=F.xregexp.captureNames||[],l=F.source.replace(_,function(m,y,C,f,P){var d,u,e,i=y||C;if(i){if(!A.hasOwnProperty(i))throw new ReferenceError("Undefined property "+m);return y?(d=r[n],o[++n]=++p,u="(?<"+(d||i)+">"):u="(?:",U=p,u+A[i].pattern.replace(K,function(g,v,t){if(v){if(d=A[i].names[p-U],++p,d)return"(?<"+d+">"}else if(t)return e=+t-1,A[i].names[e]?"\\k<"+A[i].names[e]+">":"\\"+(+t+U);return g})+")"}if(f){if(d=r[n],o[++n]=++p,d)return"(?<"+d+">"}else if(P)return r[e=+P-1]?"\\k<"+r[e]+">":"\\"+o[+P];return m});return b(l,L)}}},{}],2:[function(R,a,G){/*!
 * XRegExp.matchRecursive 3.2.0
 * <xregexp.com>
 * Steven Levithan (c) 2009-2017 MIT License
 */a.exports=function(b){"use strict";function K(_,c,x,s){return{name:_,value:c,start:x,end:s}}b.matchRecursive=function(_,c,x,s,E){E=E||{};var L,j,D,A,N,M=(s=s||"").indexOf("g")>-1,U=s.indexOf("y")>-1,F=s.replace(/y/g,""),p=E.escapeChar,n=E.valueNames,o=[],r=0,l=0,m=0,y=0;if(c=b(c,F),x=b(x,F),p){if(p.length>1)throw new Error("Cannot use more than one escape character");p=b.escape(p),N=new RegExp("(?:"+p+"[\\S\\s]|(?:(?!"+b.union([c,x],"",{conjunction:"or"}).source+")[^"+p+"])+)+",s.replace(/[^imu]+/g,""))}for(;;){if(p&&(m+=(b.exec(_,N,m,"sticky")||[""])[0].length),D=b.exec(_,c,m),A=b.exec(_,x,m),D&&A&&(D.index<=A.index?A=null:D=null),D||A)m=(l=(D||A).index)+(D||A)[0].length;else if(!r)break;if(U&&!r&&l>y)break;if(D)r||(L=l,j=m),++r;else{if(!A||!r)throw new Error("Unbalanced delimiter found in string");if(!--r&&(n?(n[0]&&L>y&&o.push(K(n[0],_.slice(y,L),y,L)),n[1]&&o.push(K(n[1],_.slice(L,j),L,j)),n[2]&&o.push(K(n[2],_.slice(j,l),j,l)),n[3]&&o.push(K(n[3],_.slice(l,m),l,m))):o.push(_.slice(j,l)),y=m,!M))break}l===m&&++m}return M&&!U&&n&&n[0]&&_.length>y&&o.push(K(n[0],_.slice(y),y,_.length)),o}}},{}],3:[function(R,a,G){/*!
 * XRegExp Unicode Base 3.2.0
 * <xregexp.com>
 * Steven Levithan (c) 2008-2017 MIT License
 */a.exports=function(b){"use strict";var K={},_=b._dec,c=b._hex,x=b._pad4;function s(D){return D.replace(/[- _]+/g,"").toLowerCase()}function E(D){var A=/^\\[xu](.+)/.exec(D);return A?_(A[1]):D.charCodeAt(D.charAt(0)==="\\"?1:0)}function L(D){var A,N,M;return K[D]["b!"]||(K[D]["b!"]=(A=K[D].bmp,N="",M=-1,b.forEach(A,/(\\x..|\\u....|\\?[\s\S])(?:-(\\x..|\\u....|\\?[\s\S]))?/,function(U){var F=E(U[1]);F>M+1&&(N+="\\u"+x(c(M+1)),F>M+2&&(N+="-\\u"+x(c(F-1)))),M=E(U[2]||U[1])}),M<65535&&(N+="\\u"+x(c(M+1)),M<65534&&(N+="-\\uFFFF")),N))}function j(D,A){var N=A?"a!":"a=";return K[D][N]||(K[D][N]=function(M,U){var F=K[M],p="";return F.bmp&&!F.isBmpLast&&(p="["+F.bmp+"]"+(F.astral?"|":"")),F.astral&&(p+=F.astral),F.isBmpLast&&F.bmp&&(p+=(F.astral?"|":"")+"["+F.bmp+"]"),U?"(?:(?!"+p+")(?:[\uD800-\uDBFF][\uDC00-\uDFFF]|[\0-\uFFFF]))":"(?:"+p+")"}(D,A))}b.addToken(/\\([pP])(?:{(\^?)([^}]*)}|([A-Za-z]))/,function(D,A,N){var M=D[1]==="P"||!!D[2],U=N.indexOf("A")>-1,F=s(D[4]||D[3]),p=K[F];if(D[1]==="P"&&D[2])throw new SyntaxError("Invalid double negation "+D[0]);if(!K.hasOwnProperty(F))throw new SyntaxError("Unknown Unicode token "+D[0]);if(p.inverseOf){if(F=s(p.inverseOf),!K.hasOwnProperty(F))throw new ReferenceError("Unicode token missing data "+D[0]+" -> "+p.inverseOf);p=K[F],M=!M}if(!p.bmp&&!U)throw new SyntaxError("Astral mode required for Unicode token "+D[0]);if(U){if(A==="class")throw new SyntaxError("Astral mode does not support Unicode tokens within character classes");return j(F,M)}return A==="class"?M?L(F):p.bmp:(M?"[^":"[")+p.bmp+"]"},{scope:"all",optionalFlags:"A",leadChar:"\\"}),b.addUnicodeData=function(D){for(var A,N=0;N<D.length;++N){if(!(A=D[N]).name)throw new Error("Unicode token requires name");if(!(A.inverseOf||A.bmp||A.astral))throw new Error("Unicode token has no character data "+A.name);K[s(A.name)]=A,A.alias&&(K[s(A.alias)]=A)}b.cache.flush("patterns")},b._getUnicodeProperty=function(D){var A=s(D);return K[A]}}},{}],4:[function(R,a,G){/*!
 * XRegExp Unicode Blocks 3.2.0
 * <xregexp.com>
 * Steven Levithan (c) 2010-2017 MIT License
 * Unicode data by Mathias Bynens <mathiasbynens.be>
 */a.exports=function(b){"use strict";if(!b.addUnicodeData)throw new ReferenceError("Unicode Base must be loaded before Unicode Blocks");b.addUnicodeData([{name:"InAdlam",astral:"\uD83A[\uDD00-\uDD5F]"},{name:"InAegean_Numbers",astral:"\uD800[\uDD00-\uDD3F]"},{name:"InAhom",astral:"\uD805[\uDF00-\uDF3F]"},{name:"InAlchemical_Symbols",astral:"\uD83D[\uDF00-\uDF7F]"},{name:"InAlphabetic_Presentation_Forms",bmp:"\uFB00-\uFB4F"},{name:"InAnatolian_Hieroglyphs",astral:"\uD811[\uDC00-\uDE7F]"},{name:"InAncient_Greek_Musical_Notation",astral:"\uD834[\uDE00-\uDE4F]"},{name:"InAncient_Greek_Numbers",astral:"\uD800[\uDD40-\uDD8F]"},{name:"InAncient_Symbols",astral:"\uD800[\uDD90-\uDDCF]"},{name:"InArabic",bmp:"\u0600-\u06FF"},{name:"InArabic_Extended_A",bmp:"\u08A0-\u08FF"},{name:"InArabic_Mathematical_Alphabetic_Symbols",astral:"\uD83B[\uDE00-\uDEFF]"},{name:"InArabic_Presentation_Forms_A",bmp:"\uFB50-\uFDFF"},{name:"InArabic_Presentation_Forms_B",bmp:"\uFE70-\uFEFF"},{name:"InArabic_Supplement",bmp:"\u0750-\u077F"},{name:"InArmenian",bmp:"\u0530-\u058F"},{name:"InArrows",bmp:"\u2190-\u21FF"},{name:"InAvestan",astral:"\uD802[\uDF00-\uDF3F]"},{name:"InBalinese",bmp:"\u1B00-\u1B7F"},{name:"InBamum",bmp:"\uA6A0-\uA6FF"},{name:"InBamum_Supplement",astral:"\uD81A[\uDC00-\uDE3F]"},{name:"InBasic_Latin",bmp:"\0-\x7F"},{name:"InBassa_Vah",astral:"\uD81A[\uDED0-\uDEFF]"},{name:"InBatak",bmp:"\u1BC0-\u1BFF"},{name:"InBengali",bmp:"\u0980-\u09FF"},{name:"InBhaiksuki",astral:"\uD807[\uDC00-\uDC6F]"},{name:"InBlock_Elements",bmp:"\u2580-\u259F"},{name:"InBopomofo",bmp:"\u3100-\u312F"},{name:"InBopomofo_Extended",bmp:"\u31A0-\u31BF"},{name:"InBox_Drawing",bmp:"\u2500-\u257F"},{name:"InBrahmi",astral:"\uD804[\uDC00-\uDC7F]"},{name:"InBraille_Patterns",bmp:"\u2800-\u28FF"},{name:"InBuginese",bmp:"\u1A00-\u1A1F"},{name:"InBuhid",bmp:"\u1740-\u175F"},{name:"InByzantine_Musical_Symbols",astral:"\uD834[\uDC00-\uDCFF]"},{name:"InCJK_Compatibility",bmp:"\u3300-\u33FF"},{name:"InCJK_Compatibility_Forms",bmp:"\uFE30-\uFE4F"},{name:"InCJK_Compatibility_Ideographs",bmp:"\uF900-\uFAFF"},{name:"InCJK_Compatibility_Ideographs_Supplement",astral:"\uD87E[\uDC00-\uDE1F]"},{name:"InCJK_Radicals_Supplement",bmp:"\u2E80-\u2EFF"},{name:"InCJK_Strokes",bmp:"\u31C0-\u31EF"},{name:"InCJK_Symbols_and_Punctuation",bmp:"\u3000-\u303F"},{name:"InCJK_Unified_Ideographs",bmp:"\u4E00-\u9FFF"},{name:"InCJK_Unified_Ideographs_Extension_A",bmp:"\u3400-\u4DBF"},{name:"InCJK_Unified_Ideographs_Extension_B",astral:"[\uD840-\uD868][\uDC00-\uDFFF]|\uD869[\uDC00-\uDEDF]"},{name:"InCJK_Unified_Ideographs_Extension_C",astral:"\uD869[\uDF00-\uDFFF]|[\uD86A-\uD86C][\uDC00-\uDFFF]|\uD86D[\uDC00-\uDF3F]"},{name:"InCJK_Unified_Ideographs_Extension_D",astral:"\uD86D[\uDF40-\uDFFF]|\uD86E[\uDC00-\uDC1F]"},{name:"InCJK_Unified_Ideographs_Extension_E",astral:"\uD86E[\uDC20-\uDFFF]|[\uD86F-\uD872][\uDC00-\uDFFF]|\uD873[\uDC00-\uDEAF]"},{name:"InCarian",astral:"\uD800[\uDEA0-\uDEDF]"},{name:"InCaucasian_Albanian",astral:"\uD801[\uDD30-\uDD6F]"},{name:"InChakma",astral:"\uD804[\uDD00-\uDD4F]"},{name:"InCham",bmp:"\uAA00-\uAA5F"},{name:"InCherokee",bmp:"\u13A0-\u13FF"},{name:"InCherokee_Supplement",bmp:"\uAB70-\uABBF"},{name:"InCombining_Diacritical_Marks",bmp:"\u0300-\u036F"},{name:"InCombining_Diacritical_Marks_Extended",bmp:"\u1AB0-\u1AFF"},{name:"InCombining_Diacritical_Marks_Supplement",bmp:"\u1DC0-\u1DFF"},{name:"InCombining_Diacritical_Marks_for_Symbols",bmp:"\u20D0-\u20FF"},{name:"InCombining_Half_Marks",bmp:"\uFE20-\uFE2F"},{name:"InCommon_Indic_Number_Forms",bmp:"\uA830-\uA83F"},{name:"InControl_Pictures",bmp:"\u2400-\u243F"},{name:"InCoptic",bmp:"\u2C80-\u2CFF"},{name:"InCoptic_Epact_Numbers",astral:"\uD800[\uDEE0-\uDEFF]"},{name:"InCounting_Rod_Numerals",astral:"\uD834[\uDF60-\uDF7F]"},{name:"InCuneiform",astral:"\uD808[\uDC00-\uDFFF]"},{name:"InCuneiform_Numbers_and_Punctuation",astral:"\uD809[\uDC00-\uDC7F]"},{name:"InCurrency_Symbols",bmp:"\u20A0-\u20CF"},{name:"InCypriot_Syllabary",astral:"\uD802[\uDC00-\uDC3F]"},{name:"InCyrillic",bmp:"\u0400-\u04FF"},{name:"InCyrillic_Extended_A",bmp:"\u2DE0-\u2DFF"},{name:"InCyrillic_Extended_B",bmp:"\uA640-\uA69F"},{name:"InCyrillic_Extended_C",bmp:"\u1C80-\u1C8F"},{name:"InCyrillic_Supplement",bmp:"\u0500-\u052F"},{name:"InDeseret",astral:"\uD801[\uDC00-\uDC4F]"},{name:"InDevanagari",bmp:"\u0900-\u097F"},{name:"InDevanagari_Extended",bmp:"\uA8E0-\uA8FF"},{name:"InDingbats",bmp:"\u2700-\u27BF"},{name:"InDomino_Tiles",astral:"\uD83C[\uDC30-\uDC9F]"},{name:"InDuployan",astral:"\uD82F[\uDC00-\uDC9F]"},{name:"InEarly_Dynastic_Cuneiform",astral:"\uD809[\uDC80-\uDD4F]"},{name:"InEgyptian_Hieroglyphs",astral:"\uD80C[\uDC00-\uDFFF]|\uD80D[\uDC00-\uDC2F]"},{name:"InElbasan",astral:"\uD801[\uDD00-\uDD2F]"},{name:"InEmoticons",astral:"\uD83D[\uDE00-\uDE4F]"},{name:"InEnclosed_Alphanumeric_Supplement",astral:"\uD83C[\uDD00-\uDDFF]"},{name:"InEnclosed_Alphanumerics",bmp:"\u2460-\u24FF"},{name:"InEnclosed_CJK_Letters_and_Months",bmp:"\u3200-\u32FF"},{name:"InEnclosed_Ideographic_Supplement",astral:"\uD83C[\uDE00-\uDEFF]"},{name:"InEthiopic",bmp:"\u1200-\u137F"},{name:"InEthiopic_Extended",bmp:"\u2D80-\u2DDF"},{name:"InEthiopic_Extended_A",bmp:"\uAB00-\uAB2F"},{name:"InEthiopic_Supplement",bmp:"\u1380-\u139F"},{name:"InGeneral_Punctuation",bmp:"\u2000-\u206F"},{name:"InGeometric_Shapes",bmp:"\u25A0-\u25FF"},{name:"InGeometric_Shapes_Extended",astral:"\uD83D[\uDF80-\uDFFF]"},{name:"InGeorgian",bmp:"\u10A0-\u10FF"},{name:"InGeorgian_Supplement",bmp:"\u2D00-\u2D2F"},{name:"InGlagolitic",bmp:"\u2C00-\u2C5F"},{name:"InGlagolitic_Supplement",astral:"\uD838[\uDC00-\uDC2F]"},{name:"InGothic",astral:"\uD800[\uDF30-\uDF4F]"},{name:"InGrantha",astral:"\uD804[\uDF00-\uDF7F]"},{name:"InGreek_Extended",bmp:"\u1F00-\u1FFF"},{name:"InGreek_and_Coptic",bmp:"\u0370-\u03FF"},{name:"InGujarati",bmp:"\u0A80-\u0AFF"},{name:"InGurmukhi",bmp:"\u0A00-\u0A7F"},{name:"InHalfwidth_and_Fullwidth_Forms",bmp:"\uFF00-\uFFEF"},{name:"InHangul_Compatibility_Jamo",bmp:"\u3130-\u318F"},{name:"InHangul_Jamo",bmp:"\u1100-\u11FF"},{name:"InHangul_Jamo_Extended_A",bmp:"\uA960-\uA97F"},{name:"InHangul_Jamo_Extended_B",bmp:"\uD7B0-\uD7FF"},{name:"InHangul_Syllables",bmp:"\uAC00-\uD7AF"},{name:"InHanunoo",bmp:"\u1720-\u173F"},{name:"InHatran",astral:"\uD802[\uDCE0-\uDCFF]"},{name:"InHebrew",bmp:"\u0590-\u05FF"},{name:"InHigh_Private_Use_Surrogates",bmp:"\uDB80-\uDBFF"},{name:"InHigh_Surrogates",bmp:"\uD800-\uDB7F"},{name:"InHiragana",bmp:"\u3040-\u309F"},{name:"InIPA_Extensions",bmp:"\u0250-\u02AF"},{name:"InIdeographic_Description_Characters",bmp:"\u2FF0-\u2FFF"},{name:"InIdeographic_Symbols_and_Punctuation",astral:"\uD81B[\uDFE0-\uDFFF]"},{name:"InImperial_Aramaic",astral:"\uD802[\uDC40-\uDC5F]"},{name:"InInscriptional_Pahlavi",astral:"\uD802[\uDF60-\uDF7F]"},{name:"InInscriptional_Parthian",astral:"\uD802[\uDF40-\uDF5F]"},{name:"InJavanese",bmp:"\uA980-\uA9DF"},{name:"InKaithi",astral:"\uD804[\uDC80-\uDCCF]"},{name:"InKana_Supplement",astral:"\uD82C[\uDC00-\uDCFF]"},{name:"InKanbun",bmp:"\u3190-\u319F"},{name:"InKangxi_Radicals",bmp:"\u2F00-\u2FDF"},{name:"InKannada",bmp:"\u0C80-\u0CFF"},{name:"InKatakana",bmp:"\u30A0-\u30FF"},{name:"InKatakana_Phonetic_Extensions",bmp:"\u31F0-\u31FF"},{name:"InKayah_Li",bmp:"\uA900-\uA92F"},{name:"InKharoshthi",astral:"\uD802[\uDE00-\uDE5F]"},{name:"InKhmer",bmp:"\u1780-\u17FF"},{name:"InKhmer_Symbols",bmp:"\u19E0-\u19FF"},{name:"InKhojki",astral:"\uD804[\uDE00-\uDE4F]"},{name:"InKhudawadi",astral:"\uD804[\uDEB0-\uDEFF]"},{name:"InLao",bmp:"\u0E80-\u0EFF"},{name:"InLatin_Extended_Additional",bmp:"\u1E00-\u1EFF"},{name:"InLatin_Extended_A",bmp:"\u0100-\u017F"},{name:"InLatin_Extended_B",bmp:"\u0180-\u024F"},{name:"InLatin_Extended_C",bmp:"\u2C60-\u2C7F"},{name:"InLatin_Extended_D",bmp:"\uA720-\uA7FF"},{name:"InLatin_Extended_E",bmp:"\uAB30-\uAB6F"},{name:"InLatin_1_Supplement",bmp:"\x80-\xFF"},{name:"InLepcha",bmp:"\u1C00-\u1C4F"},{name:"InLetterlike_Symbols",bmp:"\u2100-\u214F"},{name:"InLimbu",bmp:"\u1900-\u194F"},{name:"InLinear_A",astral:"\uD801[\uDE00-\uDF7F]"},{name:"InLinear_B_Ideograms",astral:"\uD800[\uDC80-\uDCFF]"},{name:"InLinear_B_Syllabary",astral:"\uD800[\uDC00-\uDC7F]"},{name:"InLisu",bmp:"\uA4D0-\uA4FF"},{name:"InLow_Surrogates",bmp:"\uDC00-\uDFFF"},{name:"InLycian",astral:"\uD800[\uDE80-\uDE9F]"},{name:"InLydian",astral:"\uD802[\uDD20-\uDD3F]"},{name:"InMahajani",astral:"\uD804[\uDD50-\uDD7F]"},{name:"InMahjong_Tiles",astral:"\uD83C[\uDC00-\uDC2F]"},{name:"InMalayalam",bmp:"\u0D00-\u0D7F"},{name:"InMandaic",bmp:"\u0840-\u085F"},{name:"InManichaean",astral:"\uD802[\uDEC0-\uDEFF]"},{name:"InMarchen",astral:"\uD807[\uDC70-\uDCBF]"},{name:"InMathematical_Alphanumeric_Symbols",astral:"\uD835[\uDC00-\uDFFF]"},{name:"InMathematical_Operators",bmp:"\u2200-\u22FF"},{name:"InMeetei_Mayek",bmp:"\uABC0-\uABFF"},{name:"InMeetei_Mayek_Extensions",bmp:"\uAAE0-\uAAFF"},{name:"InMende_Kikakui",astral:"\uD83A[\uDC00-\uDCDF]"},{name:"InMeroitic_Cursive",astral:"\uD802[\uDDA0-\uDDFF]"},{name:"InMeroitic_Hieroglyphs",astral:"\uD802[\uDD80-\uDD9F]"},{name:"InMiao",astral:"\uD81B[\uDF00-\uDF9F]"},{name:"InMiscellaneous_Mathematical_Symbols_A",bmp:"\u27C0-\u27EF"},{name:"InMiscellaneous_Mathematical_Symbols_B",bmp:"\u2980-\u29FF"},{name:"InMiscellaneous_Symbols",bmp:"\u2600-\u26FF"},{name:"InMiscellaneous_Symbols_and_Arrows",bmp:"\u2B00-\u2BFF"},{name:"InMiscellaneous_Symbols_and_Pictographs",astral:"\uD83C[\uDF00-\uDFFF]|\uD83D[\uDC00-\uDDFF]"},{name:"InMiscellaneous_Technical",bmp:"\u2300-\u23FF"},{name:"InModi",astral:"\uD805[\uDE00-\uDE5F]"},{name:"InModifier_Tone_Letters",bmp:"\uA700-\uA71F"},{name:"InMongolian",bmp:"\u1800-\u18AF"},{name:"InMongolian_Supplement",astral:"\uD805[\uDE60-\uDE7F]"},{name:"InMro",astral:"\uD81A[\uDE40-\uDE6F]"},{name:"InMultani",astral:"\uD804[\uDE80-\uDEAF]"},{name:"InMusical_Symbols",astral:"\uD834[\uDD00-\uDDFF]"},{name:"InMyanmar",bmp:"\u1000-\u109F"},{name:"InMyanmar_Extended_A",bmp:"\uAA60-\uAA7F"},{name:"InMyanmar_Extended_B",bmp:"\uA9E0-\uA9FF"},{name:"InNKo",bmp:"\u07C0-\u07FF"},{name:"InNabataean",astral:"\uD802[\uDC80-\uDCAF]"},{name:"InNew_Tai_Lue",bmp:"\u1980-\u19DF"},{name:"InNewa",astral:"\uD805[\uDC00-\uDC7F]"},{name:"InNumber_Forms",bmp:"\u2150-\u218F"},{name:"InOgham",bmp:"\u1680-\u169F"},{name:"InOl_Chiki",bmp:"\u1C50-\u1C7F"},{name:"InOld_Hungarian",astral:"\uD803[\uDC80-\uDCFF]"},{name:"InOld_Italic",astral:"\uD800[\uDF00-\uDF2F]"},{name:"InOld_North_Arabian",astral:"\uD802[\uDE80-\uDE9F]"},{name:"InOld_Permic",astral:"\uD800[\uDF50-\uDF7F]"},{name:"InOld_Persian",astral:"\uD800[\uDFA0-\uDFDF]"},{name:"InOld_South_Arabian",astral:"\uD802[\uDE60-\uDE7F]"},{name:"InOld_Turkic",astral:"\uD803[\uDC00-\uDC4F]"},{name:"InOptical_Character_Recognition",bmp:"\u2440-\u245F"},{name:"InOriya",bmp:"\u0B00-\u0B7F"},{name:"InOrnamental_Dingbats",astral:"\uD83D[\uDE50-\uDE7F]"},{name:"InOsage",astral:"\uD801[\uDCB0-\uDCFF]"},{name:"InOsmanya",astral:"\uD801[\uDC80-\uDCAF]"},{name:"InPahawh_Hmong",astral:"\uD81A[\uDF00-\uDF8F]"},{name:"InPalmyrene",astral:"\uD802[\uDC60-\uDC7F]"},{name:"InPau_Cin_Hau",astral:"\uD806[\uDEC0-\uDEFF]"},{name:"InPhags_pa",bmp:"\uA840-\uA87F"},{name:"InPhaistos_Disc",astral:"\uD800[\uDDD0-\uDDFF]"},{name:"InPhoenician",astral:"\uD802[\uDD00-\uDD1F]"},{name:"InPhonetic_Extensions",bmp:"\u1D00-\u1D7F"},{name:"InPhonetic_Extensions_Supplement",bmp:"\u1D80-\u1DBF"},{name:"InPlaying_Cards",astral:"\uD83C[\uDCA0-\uDCFF]"},{name:"InPrivate_Use_Area",bmp:"\uE000-\uF8FF"},{name:"InPsalter_Pahlavi",astral:"\uD802[\uDF80-\uDFAF]"},{name:"InRejang",bmp:"\uA930-\uA95F"},{name:"InRumi_Numeral_Symbols",astral:"\uD803[\uDE60-\uDE7F]"},{name:"InRunic",bmp:"\u16A0-\u16FF"},{name:"InSamaritan",bmp:"\u0800-\u083F"},{name:"InSaurashtra",bmp:"\uA880-\uA8DF"},{name:"InSharada",astral:"\uD804[\uDD80-\uDDDF]"},{name:"InShavian",astral:"\uD801[\uDC50-\uDC7F]"},{name:"InShorthand_Format_Controls",astral:"\uD82F[\uDCA0-\uDCAF]"},{name:"InSiddham",astral:"\uD805[\uDD80-\uDDFF]"},{name:"InSinhala",bmp:"\u0D80-\u0DFF"},{name:"InSinhala_Archaic_Numbers",astral:"\uD804[\uDDE0-\uDDFF]"},{name:"InSmall_Form_Variants",bmp:"\uFE50-\uFE6F"},{name:"InSora_Sompeng",astral:"\uD804[\uDCD0-\uDCFF]"},{name:"InSpacing_Modifier_Letters",bmp:"\u02B0-\u02FF"},{name:"InSpecials",bmp:"\uFFF0-\uFFFF"},{name:"InSundanese",bmp:"\u1B80-\u1BBF"},{name:"InSundanese_Supplement",bmp:"\u1CC0-\u1CCF"},{name:"InSuperscripts_and_Subscripts",bmp:"\u2070-\u209F"},{name:"InSupplemental_Arrows_A",bmp:"\u27F0-\u27FF"},{name:"InSupplemental_Arrows_B",bmp:"\u2900-\u297F"},{name:"InSupplemental_Arrows_C",astral:"\uD83E[\uDC00-\uDCFF]"},{name:"InSupplemental_Mathematical_Operators",bmp:"\u2A00-\u2AFF"},{name:"InSupplemental_Punctuation",bmp:"\u2E00-\u2E7F"},{name:"InSupplemental_Symbols_and_Pictographs",astral:"\uD83E[\uDD00-\uDDFF]"},{name:"InSupplementary_Private_Use_Area_A",astral:"[\uDB80-\uDBBF][\uDC00-\uDFFF]"},{name:"InSupplementary_Private_Use_Area_B",astral:"[\uDBC0-\uDBFF][\uDC00-\uDFFF]"},{name:"InSutton_SignWriting",astral:"\uD836[\uDC00-\uDEAF]"},{name:"InSyloti_Nagri",bmp:"\uA800-\uA82F"},{name:"InSyriac",bmp:"\u0700-\u074F"},{name:"InTagalog",bmp:"\u1700-\u171F"},{name:"InTagbanwa",bmp:"\u1760-\u177F"},{name:"InTags",astral:"\uDB40[\uDC00-\uDC7F]"},{name:"InTai_Le",bmp:"\u1950-\u197F"},{name:"InTai_Tham",bmp:"\u1A20-\u1AAF"},{name:"InTai_Viet",bmp:"\uAA80-\uAADF"},{name:"InTai_Xuan_Jing_Symbols",astral:"\uD834[\uDF00-\uDF5F]"},{name:"InTakri",astral:"\uD805[\uDE80-\uDECF]"},{name:"InTamil",bmp:"\u0B80-\u0BFF"},{name:"InTangut",astral:"[\uD81C-\uD821][\uDC00-\uDFFF]"},{name:"InTangut_Components",astral:"\uD822[\uDC00-\uDEFF]"},{name:"InTelugu",bmp:"\u0C00-\u0C7F"},{name:"InThaana",bmp:"\u0780-\u07BF"},{name:"InThai",bmp:"\u0E00-\u0E7F"},{name:"InTibetan",bmp:"\u0F00-\u0FFF"},{name:"InTifinagh",bmp:"\u2D30-\u2D7F"},{name:"InTirhuta",astral:"\uD805[\uDC80-\uDCDF]"},{name:"InTransport_and_Map_Symbols",astral:"\uD83D[\uDE80-\uDEFF]"},{name:"InUgaritic",astral:"\uD800[\uDF80-\uDF9F]"},{name:"InUnified_Canadian_Aboriginal_Syllabics",bmp:"\u1400-\u167F"},{name:"InUnified_Canadian_Aboriginal_Syllabics_Extended",bmp:"\u18B0-\u18FF"},{name:"InVai",bmp:"\uA500-\uA63F"},{name:"InVariation_Selectors",bmp:"\uFE00-\uFE0F"},{name:"InVariation_Selectors_Supplement",astral:"\uDB40[\uDD00-\uDDEF]"},{name:"InVedic_Extensions",bmp:"\u1CD0-\u1CFF"},{name:"InVertical_Forms",bmp:"\uFE10-\uFE1F"},{name:"InWarang_Citi",astral:"\uD806[\uDCA0-\uDCFF]"},{name:"InYi_Radicals",bmp:"\uA490-\uA4CF"},{name:"InYi_Syllables",bmp:"\uA000-\uA48F"},{name:"InYijing_Hexagram_Symbols",bmp:"\u4DC0-\u4DFF"}])}},{}],5:[function(R,a,G){/*!
 * XRegExp Unicode Categories 3.2.0
 * <xregexp.com>
 * Steven Levithan (c) 2010-2017 MIT License
 * Unicode data by Mathias Bynens <mathiasbynens.be>
 */a.exports=function(b){"use strict";if(!b.addUnicodeData)throw new ReferenceError("Unicode Base must be loaded before Unicode Categories");b.addUnicodeData([{name:"C",alias:"Other",isBmpLast:!0,bmp:"\0-\x7F-\x9F\xAD\u0378\u0379\u0380-\u0383\u038B\u038D\u03A2\u0530\u0557\u0558\u0560\u0588\u058B\u058C\u0590\u05C8-\u05CF\u05EB-\u05EF\u05F5-\u0605\u061C\u061D\u06DD\u070E\u070F\u074B\u074C\u07B2-\u07BF\u07FB-\u07FF\u082E\u082F\u083F\u085C\u085D\u085F-\u089F\u08B5\u08BE-\u08D3\u08E2\u0984\u098D\u098E\u0991\u0992\u09A9\u09B1\u09B3-\u09B5\u09BA\u09BB\u09C5\u09C6\u09C9\u09CA\u09CF-\u09D6\u09D8-\u09DB\u09DE\u09E4\u09E5\u09FC-\u0A00\u0A04\u0A0B-\u0A0E\u0A11\u0A12\u0A29\u0A31\u0A34\u0A37\u0A3A\u0A3B\u0A3D\u0A43-\u0A46\u0A49\u0A4A\u0A4E-\u0A50\u0A52-\u0A58\u0A5D\u0A5F-\u0A65\u0A76-\u0A80\u0A84\u0A8E\u0A92\u0AA9\u0AB1\u0AB4\u0ABA\u0ABB\u0AC6\u0ACA\u0ACE\u0ACF\u0AD1-\u0ADF\u0AE4\u0AE5\u0AF2-\u0AF8\u0AFA-\u0B00\u0B04\u0B0D\u0B0E\u0B11\u0B12\u0B29\u0B31\u0B34\u0B3A\u0B3B\u0B45\u0B46\u0B49\u0B4A\u0B4E-\u0B55\u0B58-\u0B5B\u0B5E\u0B64\u0B65\u0B78-\u0B81\u0B84\u0B8B-\u0B8D\u0B91\u0B96-\u0B98\u0B9B\u0B9D\u0BA0-\u0BA2\u0BA5-\u0BA7\u0BAB-\u0BAD\u0BBA-\u0BBD\u0BC3-\u0BC5\u0BC9\u0BCE\u0BCF\u0BD1-\u0BD6\u0BD8-\u0BE5\u0BFB-\u0BFF\u0C04\u0C0D\u0C11\u0C29\u0C3A-\u0C3C\u0C45\u0C49\u0C4E-\u0C54\u0C57\u0C5B-\u0C5F\u0C64\u0C65\u0C70-\u0C77\u0C84\u0C8D\u0C91\u0CA9\u0CB4\u0CBA\u0CBB\u0CC5\u0CC9\u0CCE-\u0CD4\u0CD7-\u0CDD\u0CDF\u0CE4\u0CE5\u0CF0\u0CF3-\u0D00\u0D04\u0D0D\u0D11\u0D3B\u0D3C\u0D45\u0D49\u0D50-\u0D53\u0D64\u0D65\u0D80\u0D81\u0D84\u0D97-\u0D99\u0DB2\u0DBC\u0DBE\u0DBF\u0DC7-\u0DC9\u0DCB-\u0DCE\u0DD5\u0DD7\u0DE0-\u0DE5\u0DF0\u0DF1\u0DF5-\u0E00\u0E3B-\u0E3E\u0E5C-\u0E80\u0E83\u0E85\u0E86\u0E89\u0E8B\u0E8C\u0E8E-\u0E93\u0E98\u0EA0\u0EA4\u0EA6\u0EA8\u0EA9\u0EAC\u0EBA\u0EBE\u0EBF\u0EC5\u0EC7\u0ECE\u0ECF\u0EDA\u0EDB\u0EE0-\u0EFF\u0F48\u0F6D-\u0F70\u0F98\u0FBD\u0FCD\u0FDB-\u0FFF\u10C6\u10C8-\u10CC\u10CE\u10CF\u1249\u124E\u124F\u1257\u1259\u125E\u125F\u1289\u128E\u128F\u12B1\u12B6\u12B7\u12BF\u12C1\u12C6\u12C7\u12D7\u1311\u1316\u1317\u135B\u135C\u137D-\u137F\u139A-\u139F\u13F6\u13F7\u13FE\u13FF\u169D-\u169F\u16F9-\u16FF\u170D\u1715-\u171F\u1737-\u173F\u1754-\u175F\u176D\u1771\u1774-\u177F\u17DE\u17DF\u17EA-\u17EF\u17FA-\u17FF\u180E\u180F\u181A-\u181F\u1878-\u187F\u18AB-\u18AF\u18F6-\u18FF\u191F\u192C-\u192F\u193C-\u193F\u1941-\u1943\u196E\u196F\u1975-\u197F\u19AC-\u19AF\u19CA-\u19CF\u19DB-\u19DD\u1A1C\u1A1D\u1A5F\u1A7D\u1A7E\u1A8A-\u1A8F\u1A9A-\u1A9F\u1AAE\u1AAF\u1ABF-\u1AFF\u1B4C-\u1B4F\u1B7D-\u1B7F\u1BF4-\u1BFB\u1C38-\u1C3A\u1C4A-\u1C4C\u1C89-\u1CBF\u1CC8-\u1CCF\u1CF7\u1CFA-\u1CFF\u1DF6-\u1DFA\u1F16\u1F17\u1F1E\u1F1F\u1F46\u1F47\u1F4E\u1F4F\u1F58\u1F5A\u1F5C\u1F5E\u1F7E\u1F7F\u1FB5\u1FC5\u1FD4\u1FD5\u1FDC\u1FF0\u1FF1\u1FF5\u1FFF\u200B-\u200F\u202A-\u202E\u2060-\u206F\u2072\u2073\u208F\u209D-\u209F\u20BF-\u20CF\u20F1-\u20FF\u218C-\u218F\u23FF\u2427-\u243F\u244B-\u245F\u2B74\u2B75\u2B96\u2B97\u2BBA-\u2BBC\u2BC9\u2BD2-\u2BEB\u2BF0-\u2BFF\u2C2F\u2C5F\u2CF4-\u2CF8\u2D26\u2D28-\u2D2C\u2D2E\u2D2F\u2D68-\u2D6E\u2D71-\u2D7E\u2D97-\u2D9F\u2DA7\u2DAF\u2DB7\u2DBF\u2DC7\u2DCF\u2DD7\u2DDF\u2E45-\u2E7F\u2E9A\u2EF4-\u2EFF\u2FD6-\u2FEF\u2FFC-\u2FFF\u3040\u3097\u3098\u3100-\u3104\u312E-\u3130\u318F\u31BB-\u31BF\u31E4-\u31EF\u321F\u32FF\u4DB6-\u4DBF\u9FD6-\u9FFF\uA48D-\uA48F\uA4C7-\uA4CF\uA62C-\uA63F\uA6F8-\uA6FF\uA7AF\uA7B8-\uA7F6\uA82C-\uA82F\uA83A-\uA83F\uA878-\uA87F\uA8C6-\uA8CD\uA8DA-\uA8DF\uA8FE\uA8FF\uA954-\uA95E\uA97D-\uA97F\uA9CE\uA9DA-\uA9DD\uA9FF\uAA37-\uAA3F\uAA4E\uAA4F\uAA5A\uAA5B\uAAC3-\uAADA\uAAF7-\uAB00\uAB07\uAB08\uAB0F\uAB10\uAB17-\uAB1F\uAB27\uAB2F\uAB66-\uAB6F\uABEE\uABEF\uABFA-\uABFF\uD7A4-\uD7AF\uD7C7-\uD7CA\uD7FC-\uF8FF\uFA6E\uFA6F\uFADA-\uFAFF\uFB07-\uFB12\uFB18-\uFB1C\uFB37\uFB3D\uFB3F\uFB42\uFB45\uFBC2-\uFBD2\uFD40-\uFD4F\uFD90\uFD91\uFDC8-\uFDEF\uFDFE\uFDFF\uFE1A-\uFE1F\uFE53\uFE67\uFE6C-\uFE6F\uFE75\uFEFD-\uFF00\uFFBF-\uFFC1\uFFC8\uFFC9\uFFD0\uFFD1\uFFD8\uFFD9\uFFDD-\uFFDF\uFFE7\uFFEF-\uFFFB\uFFFE\uFFFF",astral:"\uD800[\uDC0C\uDC27\uDC3B\uDC3E\uDC4E\uDC4F\uDC5E-\uDC7F\uDCFB-\uDCFF\uDD03-\uDD06\uDD34-\uDD36\uDD8F\uDD9C-\uDD9F\uDDA1-\uDDCF\uDDFE-\uDE7F\uDE9D-\uDE9F\uDED1-\uDEDF\uDEFC-\uDEFF\uDF24-\uDF2F\uDF4B-\uDF4F\uDF7B-\uDF7F\uDF9E\uDFC4-\uDFC7\uDFD6-\uDFFF]|\uD801[\uDC9E\uDC9F\uDCAA-\uDCAF\uDCD4-\uDCD7\uDCFC-\uDCFF\uDD28-\uDD2F\uDD64-\uDD6E\uDD70-\uDDFF\uDF37-\uDF3F\uDF56-\uDF5F\uDF68-\uDFFF]|\uD802[\uDC06\uDC07\uDC09\uDC36\uDC39-\uDC3B\uDC3D\uDC3E\uDC56\uDC9F-\uDCA6\uDCB0-\uDCDF\uDCF3\uDCF6-\uDCFA\uDD1C-\uDD1E\uDD3A-\uDD3E\uDD40-\uDD7F\uDDB8-\uDDBB\uDDD0\uDDD1\uDE04\uDE07-\uDE0B\uDE14\uDE18\uDE34-\uDE37\uDE3B-\uDE3E\uDE48-\uDE4F\uDE59-\uDE5F\uDEA0-\uDEBF\uDEE7-\uDEEA\uDEF7-\uDEFF\uDF36-\uDF38\uDF56\uDF57\uDF73-\uDF77\uDF92-\uDF98\uDF9D-\uDFA8\uDFB0-\uDFFF]|\uD803[\uDC49-\uDC7F\uDCB3-\uDCBF\uDCF3-\uDCF9\uDD00-\uDE5F\uDE7F-\uDFFF]|\uD804[\uDC4E-\uDC51\uDC70-\uDC7E\uDCBD\uDCC2-\uDCCF\uDCE9-\uDCEF\uDCFA-\uDCFF\uDD35\uDD44-\uDD4F\uDD77-\uDD7F\uDDCE\uDDCF\uDDE0\uDDF5-\uDDFF\uDE12\uDE3F-\uDE7F\uDE87\uDE89\uDE8E\uDE9E\uDEAA-\uDEAF\uDEEB-\uDEEF\uDEFA-\uDEFF\uDF04\uDF0D\uDF0E\uDF11\uDF12\uDF29\uDF31\uDF34\uDF3A\uDF3B\uDF45\uDF46\uDF49\uDF4A\uDF4E\uDF4F\uDF51-\uDF56\uDF58-\uDF5C\uDF64\uDF65\uDF6D-\uDF6F\uDF75-\uDFFF]|\uD805[\uDC5A\uDC5C\uDC5E-\uDC7F\uDCC8-\uDCCF\uDCDA-\uDD7F\uDDB6\uDDB7\uDDDE-\uDDFF\uDE45-\uDE4F\uDE5A-\uDE5F\uDE6D-\uDE7F\uDEB8-\uDEBF\uDECA-\uDEFF\uDF1A-\uDF1C\uDF2C-\uDF2F\uDF40-\uDFFF]|\uD806[\uDC00-\uDC9F\uDCF3-\uDCFE\uDD00-\uDEBF\uDEF9-\uDFFF]|\uD807[\uDC09\uDC37\uDC46-\uDC4F\uDC6D-\uDC6F\uDC90\uDC91\uDCA8\uDCB7-\uDFFF]|\uD808[\uDF9A-\uDFFF]|\uD809[\uDC6F\uDC75-\uDC7F\uDD44-\uDFFF]|[\uD80A\uD80B\uD80E-\uD810\uD812-\uD819\uD823-\uD82B\uD82D\uD82E\uD830-\uD833\uD837\uD839\uD83F\uD874-\uD87D\uD87F-\uDB3F\uDB41-\uDBFF][\uDC00-\uDFFF]|\uD80D[\uDC2F-\uDFFF]|\uD811[\uDE47-\uDFFF]|\uD81A[\uDE39-\uDE3F\uDE5F\uDE6A-\uDE6D\uDE70-\uDECF\uDEEE\uDEEF\uDEF6-\uDEFF\uDF46-\uDF4F\uDF5A\uDF62\uDF78-\uDF7C\uDF90-\uDFFF]|\uD81B[\uDC00-\uDEFF\uDF45-\uDF4F\uDF7F-\uDF8E\uDFA0-\uDFDF\uDFE1-\uDFFF]|\uD821[\uDFED-\uDFFF]|\uD822[\uDEF3-\uDFFF]|\uD82C[\uDC02-\uDFFF]|\uD82F[\uDC6B-\uDC6F\uDC7D-\uDC7F\uDC89-\uDC8F\uDC9A\uDC9B\uDCA0-\uDFFF]|\uD834[\uDCF6-\uDCFF\uDD27\uDD28\uDD73-\uDD7A\uDDE9-\uDDFF\uDE46-\uDEFF\uDF57-\uDF5F\uDF72-\uDFFF]|\uD835[\uDC55\uDC9D\uDCA0\uDCA1\uDCA3\uDCA4\uDCA7\uDCA8\uDCAD\uDCBA\uDCBC\uDCC4\uDD06\uDD0B\uDD0C\uDD15\uDD1D\uDD3A\uDD3F\uDD45\uDD47-\uDD49\uDD51\uDEA6\uDEA7\uDFCC\uDFCD]|\uD836[\uDE8C-\uDE9A\uDEA0\uDEB0-\uDFFF]|\uD838[\uDC07\uDC19\uDC1A\uDC22\uDC25\uDC2B-\uDFFF]|\uD83A[\uDCC5\uDCC6\uDCD7-\uDCFF\uDD4B-\uDD4F\uDD5A-\uDD5D\uDD60-\uDFFF]|\uD83B[\uDC00-\uDDFF\uDE04\uDE20\uDE23\uDE25\uDE26\uDE28\uDE33\uDE38\uDE3A\uDE3C-\uDE41\uDE43-\uDE46\uDE48\uDE4A\uDE4C\uDE50\uDE53\uDE55\uDE56\uDE58\uDE5A\uDE5C\uDE5E\uDE60\uDE63\uDE65\uDE66\uDE6B\uDE73\uDE78\uDE7D\uDE7F\uDE8A\uDE9C-\uDEA0\uDEA4\uDEAA\uDEBC-\uDEEF\uDEF2-\uDFFF]|\uD83C[\uDC2C-\uDC2F\uDC94-\uDC9F\uDCAF\uDCB0\uDCC0\uDCD0\uDCF6-\uDCFF\uDD0D-\uDD0F\uDD2F\uDD6C-\uDD6F\uDDAD-\uDDE5\uDE03-\uDE0F\uDE3C-\uDE3F\uDE49-\uDE4F\uDE52-\uDEFF]|\uD83D[\uDED3-\uDEDF\uDEED-\uDEEF\uDEF7-\uDEFF\uDF74-\uDF7F\uDFD5-\uDFFF]|\uD83E[\uDC0C-\uDC0F\uDC48-\uDC4F\uDC5A-\uDC5F\uDC88-\uDC8F\uDCAE-\uDD0F\uDD1F\uDD28-\uDD2F\uDD31\uDD32\uDD3F\uDD4C-\uDD4F\uDD5F-\uDD7F\uDD92-\uDDBF\uDDC1-\uDFFF]|\uD869[\uDED7-\uDEFF]|\uD86D[\uDF35-\uDF3F]|\uD86E[\uDC1E\uDC1F]|\uD873[\uDEA2-\uDFFF]|\uD87E[\uDE1E-\uDFFF]|\uDB40[\uDC00-\uDCFF\uDDF0-\uDFFF]"},{name:"Cc",alias:"Control",bmp:"\0-\x7F-\x9F"},{name:"Cf",alias:"Format",bmp:"\xAD\u0600-\u0605\u061C\u06DD\u070F\u08E2\u180E\u200B-\u200F\u202A-\u202E\u2060-\u2064\u2066-\u206F\uFEFF\uFFF9-\uFFFB",astral:"\u{110BD}|\uD82F[\uDCA0-\uDCA3]|\uD834[\uDD73-\uDD7A]|\uDB40[\uDC01\uDC20-\uDC7F]"},{name:"Cn",alias:"Unassigned",bmp:"\u0378\u0379\u0380-\u0383\u038B\u038D\u03A2\u0530\u0557\u0558\u0560\u0588\u058B\u058C\u0590\u05C8-\u05CF\u05EB-\u05EF\u05F5-\u05FF\u061D\u070E\u074B\u074C\u07B2-\u07BF\u07FB-\u07FF\u082E\u082F\u083F\u085C\u085D\u085F-\u089F\u08B5\u08BE-\u08D3\u0984\u098D\u098E\u0991\u0992\u09A9\u09B1\u09B3-\u09B5\u09BA\u09BB\u09C5\u09C6\u09C9\u09CA\u09CF-\u09D6\u09D8-\u09DB\u09DE\u09E4\u09E5\u09FC-\u0A00\u0A04\u0A0B-\u0A0E\u0A11\u0A12\u0A29\u0A31\u0A34\u0A37\u0A3A\u0A3B\u0A3D\u0A43-\u0A46\u0A49\u0A4A\u0A4E-\u0A50\u0A52-\u0A58\u0A5D\u0A5F-\u0A65\u0A76-\u0A80\u0A84\u0A8E\u0A92\u0AA9\u0AB1\u0AB4\u0ABA\u0ABB\u0AC6\u0ACA\u0ACE\u0ACF\u0AD1-\u0ADF\u0AE4\u0AE5\u0AF2-\u0AF8\u0AFA-\u0B00\u0B04\u0B0D\u0B0E\u0B11\u0B12\u0B29\u0B31\u0B34\u0B3A\u0B3B\u0B45\u0B46\u0B49\u0B4A\u0B4E-\u0B55\u0B58-\u0B5B\u0B5E\u0B64\u0B65\u0B78-\u0B81\u0B84\u0B8B-\u0B8D\u0B91\u0B96-\u0B98\u0B9B\u0B9D\u0BA0-\u0BA2\u0BA5-\u0BA7\u0BAB-\u0BAD\u0BBA-\u0BBD\u0BC3-\u0BC5\u0BC9\u0BCE\u0BCF\u0BD1-\u0BD6\u0BD8-\u0BE5\u0BFB-\u0BFF\u0C04\u0C0D\u0C11\u0C29\u0C3A-\u0C3C\u0C45\u0C49\u0C4E-\u0C54\u0C57\u0C5B-\u0C5F\u0C64\u0C65\u0C70-\u0C77\u0C84\u0C8D\u0C91\u0CA9\u0CB4\u0CBA\u0CBB\u0CC5\u0CC9\u0CCE-\u0CD4\u0CD7-\u0CDD\u0CDF\u0CE4\u0CE5\u0CF0\u0CF3-\u0D00\u0D04\u0D0D\u0D11\u0D3B\u0D3C\u0D45\u0D49\u0D50-\u0D53\u0D64\u0D65\u0D80\u0D81\u0D84\u0D97-\u0D99\u0DB2\u0DBC\u0DBE\u0DBF\u0DC7-\u0DC9\u0DCB-\u0DCE\u0DD5\u0DD7\u0DE0-\u0DE5\u0DF0\u0DF1\u0DF5-\u0E00\u0E3B-\u0E3E\u0E5C-\u0E80\u0E83\u0E85\u0E86\u0E89\u0E8B\u0E8C\u0E8E-\u0E93\u0E98\u0EA0\u0EA4\u0EA6\u0EA8\u0EA9\u0EAC\u0EBA\u0EBE\u0EBF\u0EC5\u0EC7\u0ECE\u0ECF\u0EDA\u0EDB\u0EE0-\u0EFF\u0F48\u0F6D-\u0F70\u0F98\u0FBD\u0FCD\u0FDB-\u0FFF\u10C6\u10C8-\u10CC\u10CE\u10CF\u1249\u124E\u124F\u1257\u1259\u125E\u125F\u1289\u128E\u128F\u12B1\u12B6\u12B7\u12BF\u12C1\u12C6\u12C7\u12D7\u1311\u1316\u1317\u135B\u135C\u137D-\u137F\u139A-\u139F\u13F6\u13F7\u13FE\u13FF\u169D-\u169F\u16F9-\u16FF\u170D\u1715-\u171F\u1737-\u173F\u1754-\u175F\u176D\u1771\u1774-\u177F\u17DE\u17DF\u17EA-\u17EF\u17FA-\u17FF\u180F\u181A-\u181F\u1878-\u187F\u18AB-\u18AF\u18F6-\u18FF\u191F\u192C-\u192F\u193C-\u193F\u1941-\u1943\u196E\u196F\u1975-\u197F\u19AC-\u19AF\u19CA-\u19CF\u19DB-\u19DD\u1A1C\u1A1D\u1A5F\u1A7D\u1A7E\u1A8A-\u1A8F\u1A9A-\u1A9F\u1AAE\u1AAF\u1ABF-\u1AFF\u1B4C-\u1B4F\u1B7D-\u1B7F\u1BF4-\u1BFB\u1C38-\u1C3A\u1C4A-\u1C4C\u1C89-\u1CBF\u1CC8-\u1CCF\u1CF7\u1CFA-\u1CFF\u1DF6-\u1DFA\u1F16\u1F17\u1F1E\u1F1F\u1F46\u1F47\u1F4E\u1F4F\u1F58\u1F5A\u1F5C\u1F5E\u1F7E\u1F7F\u1FB5\u1FC5\u1FD4\u1FD5\u1FDC\u1FF0\u1FF1\u1FF5\u1FFF\u2065\u2072\u2073\u208F\u209D-\u209F\u20BF-\u20CF\u20F1-\u20FF\u218C-\u218F\u23FF\u2427-\u243F\u244B-\u245F\u2B74\u2B75\u2B96\u2B97\u2BBA-\u2BBC\u2BC9\u2BD2-\u2BEB\u2BF0-\u2BFF\u2C2F\u2C5F\u2CF4-\u2CF8\u2D26\u2D28-\u2D2C\u2D2E\u2D2F\u2D68-\u2D6E\u2D71-\u2D7E\u2D97-\u2D9F\u2DA7\u2DAF\u2DB7\u2DBF\u2DC7\u2DCF\u2DD7\u2DDF\u2E45-\u2E7F\u2E9A\u2EF4-\u2EFF\u2FD6-\u2FEF\u2FFC-\u2FFF\u3040\u3097\u3098\u3100-\u3104\u312E-\u3130\u318F\u31BB-\u31BF\u31E4-\u31EF\u321F\u32FF\u4DB6-\u4DBF\u9FD6-\u9FFF\uA48D-\uA48F\uA4C7-\uA4CF\uA62C-\uA63F\uA6F8-\uA6FF\uA7AF\uA7B8-\uA7F6\uA82C-\uA82F\uA83A-\uA83F\uA878-\uA87F\uA8C6-\uA8CD\uA8DA-\uA8DF\uA8FE\uA8FF\uA954-\uA95E\uA97D-\uA97F\uA9CE\uA9DA-\uA9DD\uA9FF\uAA37-\uAA3F\uAA4E\uAA4F\uAA5A\uAA5B\uAAC3-\uAADA\uAAF7-\uAB00\uAB07\uAB08\uAB0F\uAB10\uAB17-\uAB1F\uAB27\uAB2F\uAB66-\uAB6F\uABEE\uABEF\uABFA-\uABFF\uD7A4-\uD7AF\uD7C7-\uD7CA\uD7FC-\uD7FF\uFA6E\uFA6F\uFADA-\uFAFF\uFB07-\uFB12\uFB18-\uFB1C\uFB37\uFB3D\uFB3F\uFB42\uFB45\uFBC2-\uFBD2\uFD40-\uFD4F\uFD90\uFD91\uFDC8-\uFDEF\uFDFE\uFDFF\uFE1A-\uFE1F\uFE53\uFE67\uFE6C-\uFE6F\uFE75\uFEFD\uFEFE\uFF00\uFFBF-\uFFC1\uFFC8\uFFC9\uFFD0\uFFD1\uFFD8\uFFD9\uFFDD-\uFFDF\uFFE7\uFFEF-\uFFF8\uFFFE\uFFFF",astral:"\uD800[\uDC0C\uDC27\uDC3B\uDC3E\uDC4E\uDC4F\uDC5E-\uDC7F\uDCFB-\uDCFF\uDD03-\uDD06\uDD34-\uDD36\uDD8F\uDD9C-\uDD9F\uDDA1-\uDDCF\uDDFE-\uDE7F\uDE9D-\uDE9F\uDED1-\uDEDF\uDEFC-\uDEFF\uDF24-\uDF2F\uDF4B-\uDF4F\uDF7B-\uDF7F\uDF9E\uDFC4-\uDFC7\uDFD6-\uDFFF]|\uD801[\uDC9E\uDC9F\uDCAA-\uDCAF\uDCD4-\uDCD7\uDCFC-\uDCFF\uDD28-\uDD2F\uDD64-\uDD6E\uDD70-\uDDFF\uDF37-\uDF3F\uDF56-\uDF5F\uDF68-\uDFFF]|\uD802[\uDC06\uDC07\uDC09\uDC36\uDC39-\uDC3B\uDC3D\uDC3E\uDC56\uDC9F-\uDCA6\uDCB0-\uDCDF\uDCF3\uDCF6-\uDCFA\uDD1C-\uDD1E\uDD3A-\uDD3E\uDD40-\uDD7F\uDDB8-\uDDBB\uDDD0\uDDD1\uDE04\uDE07-\uDE0B\uDE14\uDE18\uDE34-\uDE37\uDE3B-\uDE3E\uDE48-\uDE4F\uDE59-\uDE5F\uDEA0-\uDEBF\uDEE7-\uDEEA\uDEF7-\uDEFF\uDF36-\uDF38\uDF56\uDF57\uDF73-\uDF77\uDF92-\uDF98\uDF9D-\uDFA8\uDFB0-\uDFFF]|\uD803[\uDC49-\uDC7F\uDCB3-\uDCBF\uDCF3-\uDCF9\uDD00-\uDE5F\uDE7F-\uDFFF]|\uD804[\uDC4E-\uDC51\uDC70-\uDC7E\uDCC2-\uDCCF\uDCE9-\uDCEF\uDCFA-\uDCFF\uDD35\uDD44-\uDD4F\uDD77-\uDD7F\uDDCE\uDDCF\uDDE0\uDDF5-\uDDFF\uDE12\uDE3F-\uDE7F\uDE87\uDE89\uDE8E\uDE9E\uDEAA-\uDEAF\uDEEB-\uDEEF\uDEFA-\uDEFF\uDF04\uDF0D\uDF0E\uDF11\uDF12\uDF29\uDF31\uDF34\uDF3A\uDF3B\uDF45\uDF46\uDF49\uDF4A\uDF4E\uDF4F\uDF51-\uDF56\uDF58-\uDF5C\uDF64\uDF65\uDF6D-\uDF6F\uDF75-\uDFFF]|\uD805[\uDC5A\uDC5C\uDC5E-\uDC7F\uDCC8-\uDCCF\uDCDA-\uDD7F\uDDB6\uDDB7\uDDDE-\uDDFF\uDE45-\uDE4F\uDE5A-\uDE5F\uDE6D-\uDE7F\uDEB8-\uDEBF\uDECA-\uDEFF\uDF1A-\uDF1C\uDF2C-\uDF2F\uDF40-\uDFFF]|\uD806[\uDC00-\uDC9F\uDCF3-\uDCFE\uDD00-\uDEBF\uDEF9-\uDFFF]|\uD807[\uDC09\uDC37\uDC46-\uDC4F\uDC6D-\uDC6F\uDC90\uDC91\uDCA8\uDCB7-\uDFFF]|\uD808[\uDF9A-\uDFFF]|\uD809[\uDC6F\uDC75-\uDC7F\uDD44-\uDFFF]|[\uD80A\uD80B\uD80E-\uD810\uD812-\uD819\uD823-\uD82B\uD82D\uD82E\uD830-\uD833\uD837\uD839\uD83F\uD874-\uD87D\uD87F-\uDB3F\uDB41-\uDB7F][\uDC00-\uDFFF]|\uD80D[\uDC2F-\uDFFF]|\uD811[\uDE47-\uDFFF]|\uD81A[\uDE39-\uDE3F\uDE5F\uDE6A-\uDE6D\uDE70-\uDECF\uDEEE\uDEEF\uDEF6-\uDEFF\uDF46-\uDF4F\uDF5A\uDF62\uDF78-\uDF7C\uDF90-\uDFFF]|\uD81B[\uDC00-\uDEFF\uDF45-\uDF4F\uDF7F-\uDF8E\uDFA0-\uDFDF\uDFE1-\uDFFF]|\uD821[\uDFED-\uDFFF]|\uD822[\uDEF3-\uDFFF]|\uD82C[\uDC02-\uDFFF]|\uD82F[\uDC6B-\uDC6F\uDC7D-\uDC7F\uDC89-\uDC8F\uDC9A\uDC9B\uDCA4-\uDFFF]|\uD834[\uDCF6-\uDCFF\uDD27\uDD28\uDDE9-\uDDFF\uDE46-\uDEFF\uDF57-\uDF5F\uDF72-\uDFFF]|\uD835[\uDC55\uDC9D\uDCA0\uDCA1\uDCA3\uDCA4\uDCA7\uDCA8\uDCAD\uDCBA\uDCBC\uDCC4\uDD06\uDD0B\uDD0C\uDD15\uDD1D\uDD3A\uDD3F\uDD45\uDD47-\uDD49\uDD51\uDEA6\uDEA7\uDFCC\uDFCD]|\uD836[\uDE8C-\uDE9A\uDEA0\uDEB0-\uDFFF]|\uD838[\uDC07\uDC19\uDC1A\uDC22\uDC25\uDC2B-\uDFFF]|\uD83A[\uDCC5\uDCC6\uDCD7-\uDCFF\uDD4B-\uDD4F\uDD5A-\uDD5D\uDD60-\uDFFF]|\uD83B[\uDC00-\uDDFF\uDE04\uDE20\uDE23\uDE25\uDE26\uDE28\uDE33\uDE38\uDE3A\uDE3C-\uDE41\uDE43-\uDE46\uDE48\uDE4A\uDE4C\uDE50\uDE53\uDE55\uDE56\uDE58\uDE5A\uDE5C\uDE5E\uDE60\uDE63\uDE65\uDE66\uDE6B\uDE73\uDE78\uDE7D\uDE7F\uDE8A\uDE9C-\uDEA0\uDEA4\uDEAA\uDEBC-\uDEEF\uDEF2-\uDFFF]|\uD83C[\uDC2C-\uDC2F\uDC94-\uDC9F\uDCAF\uDCB0\uDCC0\uDCD0\uDCF6-\uDCFF\uDD0D-\uDD0F\uDD2F\uDD6C-\uDD6F\uDDAD-\uDDE5\uDE03-\uDE0F\uDE3C-\uDE3F\uDE49-\uDE4F\uDE52-\uDEFF]|\uD83D[\uDED3-\uDEDF\uDEED-\uDEEF\uDEF7-\uDEFF\uDF74-\uDF7F\uDFD5-\uDFFF]|\uD83E[\uDC0C-\uDC0F\uDC48-\uDC4F\uDC5A-\uDC5F\uDC88-\uDC8F\uDCAE-\uDD0F\uDD1F\uDD28-\uDD2F\uDD31\uDD32\uDD3F\uDD4C-\uDD4F\uDD5F-\uDD7F\uDD92-\uDDBF\uDDC1-\uDFFF]|\uD869[\uDED7-\uDEFF]|\uD86D[\uDF35-\uDF3F]|\uD86E[\uDC1E\uDC1F]|\uD873[\uDEA2-\uDFFF]|\uD87E[\uDE1E-\uDFFF]|\uDB40[\uDC00\uDC02-\uDC1F\uDC80-\uDCFF\uDDF0-\uDFFF]|[\uDBBF\uDBFF][\uDFFE\uDFFF]"},{name:"Co",alias:"Private_Use",bmp:"\uE000-\uF8FF",astral:"[\uDB80-\uDBBE\uDBC0-\uDBFE][\uDC00-\uDFFF]|[\uDBBF\uDBFF][\uDC00-\uDFFD]"},{name:"Cs",alias:"Surrogate",bmp:"\uD800-\uDFFF"},{name:"L",alias:"Letter",bmp:"A-Za-z\xAA\xB5\xBA\xC0-\xD6\xD8-\xF6\xF8-\u02C1\u02C6-\u02D1\u02E0-\u02E4\u02EC\u02EE\u0370-\u0374\u0376\u0377\u037A-\u037D\u037F\u0386\u0388-\u038A\u038C\u038E-\u03A1\u03A3-\u03F5\u03F7-\u0481\u048A-\u052F\u0531-\u0556\u0559\u0561-\u0587\u05D0-\u05EA\u05F0-\u05F2\u0620-\u064A\u066E\u066F\u0671-\u06D3\u06D5\u06E5\u06E6\u06EE\u06EF\u06FA-\u06FC\u06FF\u0710\u0712-\u072F\u074D-\u07A5\u07B1\u07CA-\u07EA\u07F4\u07F5\u07FA\u0800-\u0815\u081A\u0824\u0828\u0840-\u0858\u08A0-\u08B4\u08B6-\u08BD\u0904-\u0939\u093D\u0950\u0958-\u0961\u0971-\u0980\u0985-\u098C\u098F\u0990\u0993-\u09A8\u09AA-\u09B0\u09B2\u09B6-\u09B9\u09BD\u09CE\u09DC\u09DD\u09DF-\u09E1\u09F0\u09F1\u0A05-\u0A0A\u0A0F\u0A10\u0A13-\u0A28\u0A2A-\u0A30\u0A32\u0A33\u0A35\u0A36\u0A38\u0A39\u0A59-\u0A5C\u0A5E\u0A72-\u0A74\u0A85-\u0A8D\u0A8F-\u0A91\u0A93-\u0AA8\u0AAA-\u0AB0\u0AB2\u0AB3\u0AB5-\u0AB9\u0ABD\u0AD0\u0AE0\u0AE1\u0AF9\u0B05-\u0B0C\u0B0F\u0B10\u0B13-\u0B28\u0B2A-\u0B30\u0B32\u0B33\u0B35-\u0B39\u0B3D\u0B5C\u0B5D\u0B5F-\u0B61\u0B71\u0B83\u0B85-\u0B8A\u0B8E-\u0B90\u0B92-\u0B95\u0B99\u0B9A\u0B9C\u0B9E\u0B9F\u0BA3\u0BA4\u0BA8-\u0BAA\u0BAE-\u0BB9\u0BD0\u0C05-\u0C0C\u0C0E-\u0C10\u0C12-\u0C28\u0C2A-\u0C39\u0C3D\u0C58-\u0C5A\u0C60\u0C61\u0C80\u0C85-\u0C8C\u0C8E-\u0C90\u0C92-\u0CA8\u0CAA-\u0CB3\u0CB5-\u0CB9\u0CBD\u0CDE\u0CE0\u0CE1\u0CF1\u0CF2\u0D05-\u0D0C\u0D0E-\u0D10\u0D12-\u0D3A\u0D3D\u0D4E\u0D54-\u0D56\u0D5F-\u0D61\u0D7A-\u0D7F\u0D85-\u0D96\u0D9A-\u0DB1\u0DB3-\u0DBB\u0DBD\u0DC0-\u0DC6\u0E01-\u0E30\u0E32\u0E33\u0E40-\u0E46\u0E81\u0E82\u0E84\u0E87\u0E88\u0E8A\u0E8D\u0E94-\u0E97\u0E99-\u0E9F\u0EA1-\u0EA3\u0EA5\u0EA7\u0EAA\u0EAB\u0EAD-\u0EB0\u0EB2\u0EB3\u0EBD\u0EC0-\u0EC4\u0EC6\u0EDC-\u0EDF\u0F00\u0F40-\u0F47\u0F49-\u0F6C\u0F88-\u0F8C\u1000-\u102A\u103F\u1050-\u1055\u105A-\u105D\u1061\u1065\u1066\u106E-\u1070\u1075-\u1081\u108E\u10A0-\u10C5\u10C7\u10CD\u10D0-\u10FA\u10FC-\u1248\u124A-\u124D\u1250-\u1256\u1258\u125A-\u125D\u1260-\u1288\u128A-\u128D\u1290-\u12B0\u12B2-\u12B5\u12B8-\u12BE\u12C0\u12C2-\u12C5\u12C8-\u12D6\u12D8-\u1310\u1312-\u1315\u1318-\u135A\u1380-\u138F\u13A0-\u13F5\u13F8-\u13FD\u1401-\u166C\u166F-\u167F\u1681-\u169A\u16A0-\u16EA\u16F1-\u16F8\u1700-\u170C\u170E-\u1711\u1720-\u1731\u1740-\u1751\u1760-\u176C\u176E-\u1770\u1780-\u17B3\u17D7\u17DC\u1820-\u1877\u1880-\u1884\u1887-\u18A8\u18AA\u18B0-\u18F5\u1900-\u191E\u1950-\u196D\u1970-\u1974\u1980-\u19AB\u19B0-\u19C9\u1A00-\u1A16\u1A20-\u1A54\u1AA7\u1B05-\u1B33\u1B45-\u1B4B\u1B83-\u1BA0\u1BAE\u1BAF\u1BBA-\u1BE5\u1C00-\u1C23\u1C4D-\u1C4F\u1C5A-\u1C7D\u1C80-\u1C88\u1CE9-\u1CEC\u1CEE-\u1CF1\u1CF5\u1CF6\u1D00-\u1DBF\u1E00-\u1F15\u1F18-\u1F1D\u1F20-\u1F45\u1F48-\u1F4D\u1F50-\u1F57\u1F59\u1F5B\u1F5D\u1F5F-\u1F7D\u1F80-\u1FB4\u1FB6-\u1FBC\u1FBE\u1FC2-\u1FC4\u1FC6-\u1FCC\u1FD0-\u1FD3\u1FD6-\u1FDB\u1FE0-\u1FEC\u1FF2-\u1FF4\u1FF6-\u1FFC\u2071\u207F\u2090-\u209C\u2102\u2107\u210A-\u2113\u2115\u2119-\u211D\u2124\u2126\u2128\u212A-\u212D\u212F-\u2139\u213C-\u213F\u2145-\u2149\u214E\u2183\u2184\u2C00-\u2C2E\u2C30-\u2C5E\u2C60-\u2CE4\u2CEB-\u2CEE\u2CF2\u2CF3\u2D00-\u2D25\u2D27\u2D2D\u2D30-\u2D67\u2D6F\u2D80-\u2D96\u2DA0-\u2DA6\u2DA8-\u2DAE\u2DB0-\u2DB6\u2DB8-\u2DBE\u2DC0-\u2DC6\u2DC8-\u2DCE\u2DD0-\u2DD6\u2DD8-\u2DDE\u2E2F\u3005\u3006\u3031-\u3035\u303B\u303C\u3041-\u3096\u309D-\u309F\u30A1-\u30FA\u30FC-\u30FF\u3105-\u312D\u3131-\u318E\u31A0-\u31BA\u31F0-\u31FF\u3400-\u4DB5\u4E00-\u9FD5\uA000-\uA48C\uA4D0-\uA4FD\uA500-\uA60C\uA610-\uA61F\uA62A\uA62B\uA640-\uA66E\uA67F-\uA69D\uA6A0-\uA6E5\uA717-\uA71F\uA722-\uA788\uA78B-\uA7AE\uA7B0-\uA7B7\uA7F7-\uA801\uA803-\uA805\uA807-\uA80A\uA80C-\uA822\uA840-\uA873\uA882-\uA8B3\uA8F2-\uA8F7\uA8FB\uA8FD\uA90A-\uA925\uA930-\uA946\uA960-\uA97C\uA984-\uA9B2\uA9CF\uA9E0-\uA9E4\uA9E6-\uA9EF\uA9FA-\uA9FE\uAA00-\uAA28\uAA40-\uAA42\uAA44-\uAA4B\uAA60-\uAA76\uAA7A\uAA7E-\uAAAF\uAAB1\uAAB5\uAAB6\uAAB9-\uAABD\uAAC0\uAAC2\uAADB-\uAADD\uAAE0-\uAAEA\uAAF2-\uAAF4\uAB01-\uAB06\uAB09-\uAB0E\uAB11-\uAB16\uAB20-\uAB26\uAB28-\uAB2E\uAB30-\uAB5A\uAB5C-\uAB65\uAB70-\uABE2\uAC00-\uD7A3\uD7B0-\uD7C6\uD7CB-\uD7FB\uF900-\uFA6D\uFA70-\uFAD9\uFB00-\uFB06\uFB13-\uFB17\uFB1D\uFB1F-\uFB28\uFB2A-\uFB36\uFB38-\uFB3C\uFB3E\uFB40\uFB41\uFB43\uFB44\uFB46-\uFBB1\uFBD3-\uFD3D\uFD50-\uFD8F\uFD92-\uFDC7\uFDF0-\uFDFB\uFE70-\uFE74\uFE76-\uFEFC\uFF21-\uFF3A\uFF41-\uFF5A\uFF66-\uFFBE\uFFC2-\uFFC7\uFFCA-\uFFCF\uFFD2-\uFFD7\uFFDA-\uFFDC",astral:"\uD800[\uDC00-\uDC0B\uDC0D-\uDC26\uDC28-\uDC3A\uDC3C\uDC3D\uDC3F-\uDC4D\uDC50-\uDC5D\uDC80-\uDCFA\uDE80-\uDE9C\uDEA0-\uDED0\uDF00-\uDF1F\uDF30-\uDF40\uDF42-\uDF49\uDF50-\uDF75\uDF80-\uDF9D\uDFA0-\uDFC3\uDFC8-\uDFCF]|\uD801[\uDC00-\uDC9D\uDCB0-\uDCD3\uDCD8-\uDCFB\uDD00-\uDD27\uDD30-\uDD63\uDE00-\uDF36\uDF40-\uDF55\uDF60-\uDF67]|\uD802[\uDC00-\uDC05\uDC08\uDC0A-\uDC35\uDC37\uDC38\uDC3C\uDC3F-\uDC55\uDC60-\uDC76\uDC80-\uDC9E\uDCE0-\uDCF2\uDCF4\uDCF5\uDD00-\uDD15\uDD20-\uDD39\uDD80-\uDDB7\uDDBE\uDDBF\uDE00\uDE10-\uDE13\uDE15-\uDE17\uDE19-\uDE33\uDE60-\uDE7C\uDE80-\uDE9C\uDEC0-\uDEC7\uDEC9-\uDEE4\uDF00-\uDF35\uDF40-\uDF55\uDF60-\uDF72\uDF80-\uDF91]|\uD803[\uDC00-\uDC48\uDC80-\uDCB2\uDCC0-\uDCF2]|\uD804[\uDC03-\uDC37\uDC83-\uDCAF\uDCD0-\uDCE8\uDD03-\uDD26\uDD50-\uDD72\uDD76\uDD83-\uDDB2\uDDC1-\uDDC4\uDDDA\uDDDC\uDE00-\uDE11\uDE13-\uDE2B\uDE80-\uDE86\uDE88\uDE8A-\uDE8D\uDE8F-\uDE9D\uDE9F-\uDEA8\uDEB0-\uDEDE\uDF05-\uDF0C\uDF0F\uDF10\uDF13-\uDF28\uDF2A-\uDF30\uDF32\uDF33\uDF35-\uDF39\uDF3D\uDF50\uDF5D-\uDF61]|\uD805[\uDC00-\uDC34\uDC47-\uDC4A\uDC80-\uDCAF\uDCC4\uDCC5\uDCC7\uDD80-\uDDAE\uDDD8-\uDDDB\uDE00-\uDE2F\uDE44\uDE80-\uDEAA\uDF00-\uDF19]|\uD806[\uDCA0-\uDCDF\uDCFF\uDEC0-\uDEF8]|\uD807[\uDC00-\uDC08\uDC0A-\uDC2E\uDC40\uDC72-\uDC8F]|\uD808[\uDC00-\uDF99]|\uD809[\uDC80-\uDD43]|[\uD80C\uD81C-\uD820\uD840-\uD868\uD86A-\uD86C\uD86F-\uD872][\uDC00-\uDFFF]|\uD80D[\uDC00-\uDC2E]|\uD811[\uDC00-\uDE46]|\uD81A[\uDC00-\uDE38\uDE40-\uDE5E\uDED0-\uDEED\uDF00-\uDF2F\uDF40-\uDF43\uDF63-\uDF77\uDF7D-\uDF8F]|\uD81B[\uDF00-\uDF44\uDF50\uDF93-\uDF9F\uDFE0]|\uD821[\uDC00-\uDFEC]|\uD822[\uDC00-\uDEF2]|\uD82C[\uDC00\uDC01]|\uD82F[\uDC00-\uDC6A\uDC70-\uDC7C\uDC80-\uDC88\uDC90-\uDC99]|\uD835[\uDC00-\uDC54\uDC56-\uDC9C\uDC9E\uDC9F\uDCA2\uDCA5\uDCA6\uDCA9-\uDCAC\uDCAE-\uDCB9\uDCBB\uDCBD-\uDCC3\uDCC5-\uDD05\uDD07-\uDD0A\uDD0D-\uDD14\uDD16-\uDD1C\uDD1E-\uDD39\uDD3B-\uDD3E\uDD40-\uDD44\uDD46\uDD4A-\uDD50\uDD52-\uDEA5\uDEA8-\uDEC0\uDEC2-\uDEDA\uDEDC-\uDEFA\uDEFC-\uDF14\uDF16-\uDF34\uDF36-\uDF4E\uDF50-\uDF6E\uDF70-\uDF88\uDF8A-\uDFA8\uDFAA-\uDFC2\uDFC4-\uDFCB]|\uD83A[\uDC00-\uDCC4\uDD00-\uDD43]|\uD83B[\uDE00-\uDE03\uDE05-\uDE1F\uDE21\uDE22\uDE24\uDE27\uDE29-\uDE32\uDE34-\uDE37\uDE39\uDE3B\uDE42\uDE47\uDE49\uDE4B\uDE4D-\uDE4F\uDE51\uDE52\uDE54\uDE57\uDE59\uDE5B\uDE5D\uDE5F\uDE61\uDE62\uDE64\uDE67-\uDE6A\uDE6C-\uDE72\uDE74-\uDE77\uDE79-\uDE7C\uDE7E\uDE80-\uDE89\uDE8B-\uDE9B\uDEA1-\uDEA3\uDEA5-\uDEA9\uDEAB-\uDEBB]|\uD869[\uDC00-\uDED6\uDF00-\uDFFF]|\uD86D[\uDC00-\uDF34\uDF40-\uDFFF]|\uD86E[\uDC00-\uDC1D\uDC20-\uDFFF]|\uD873[\uDC00-\uDEA1]|\uD87E[\uDC00-\uDE1D]"},{name:"Ll",alias:"Lowercase_Letter",bmp:"a-z\xB5\xDF-\xF6\xF8-\xFF\u0101\u0103\u0105\u0107\u0109\u010B\u010D\u010F\u0111\u0113\u0115\u0117\u0119\u011B\u011D\u011F\u0121\u0123\u0125\u0127\u0129\u012B\u012D\u012F\u0131\u0133\u0135\u0137\u0138\u013A\u013C\u013E\u0140\u0142\u0144\u0146\u0148\u0149\u014B\u014D\u014F\u0151\u0153\u0155\u0157\u0159\u015B\u015D\u015F\u0161\u0163\u0165\u0167\u0169\u016B\u016D\u016F\u0171\u0173\u0175\u0177\u017A\u017C\u017E-\u0180\u0183\u0185\u0188\u018C\u018D\u0192\u0195\u0199-\u019B\u019E\u01A1\u01A3\u01A5\u01A8\u01AA\u01AB\u01AD\u01B0\u01B4\u01B6\u01B9\u01BA\u01BD-\u01BF\u01C6\u01C9\u01CC\u01CE\u01D0\u01D2\u01D4\u01D6\u01D8\u01DA\u01DC\u01DD\u01DF\u01E1\u01E3\u01E5\u01E7\u01E9\u01EB\u01ED\u01EF\u01F0\u01F3\u01F5\u01F9\u01FB\u01FD\u01FF\u0201\u0203\u0205\u0207\u0209\u020B\u020D\u020F\u0211\u0213\u0215\u0217\u0219\u021B\u021D\u021F\u0221\u0223\u0225\u0227\u0229\u022B\u022D\u022F\u0231\u0233-\u0239\u023C\u023F\u0240\u0242\u0247\u0249\u024B\u024D\u024F-\u0293\u0295-\u02AF\u0371\u0373\u0377\u037B-\u037D\u0390\u03AC-\u03CE\u03D0\u03D1\u03D5-\u03D7\u03D9\u03DB\u03DD\u03DF\u03E1\u03E3\u03E5\u03E7\u03E9\u03EB\u03ED\u03EF-\u03F3\u03F5\u03F8\u03FB\u03FC\u0430-\u045F\u0461\u0463\u0465\u0467\u0469\u046B\u046D\u046F\u0471\u0473\u0475\u0477\u0479\u047B\u047D\u047F\u0481\u048B\u048D\u048F\u0491\u0493\u0495\u0497\u0499\u049B\u049D\u049F\u04A1\u04A3\u04A5\u04A7\u04A9\u04AB\u04AD\u04AF\u04B1\u04B3\u04B5\u04B7\u04B9\u04BB\u04BD\u04BF\u04C2\u04C4\u04C6\u04C8\u04CA\u04CC\u04CE\u04CF\u04D1\u04D3\u04D5\u04D7\u04D9\u04DB\u04DD\u04DF\u04E1\u04E3\u04E5\u04E7\u04E9\u04EB\u04ED\u04EF\u04F1\u04F3\u04F5\u04F7\u04F9\u04FB\u04FD\u04FF\u0501\u0503\u0505\u0507\u0509\u050B\u050D\u050F\u0511\u0513\u0515\u0517\u0519\u051B\u051D\u051F\u0521\u0523\u0525\u0527\u0529\u052B\u052D\u052F\u0561-\u0587\u13F8-\u13FD\u1C80-\u1C88\u1D00-\u1D2B\u1D6B-\u1D77\u1D79-\u1D9A\u1E01\u1E03\u1E05\u1E07\u1E09\u1E0B\u1E0D\u1E0F\u1E11\u1E13\u1E15\u1E17\u1E19\u1E1B\u1E1D\u1E1F\u1E21\u1E23\u1E25\u1E27\u1E29\u1E2B\u1E2D\u1E2F\u1E31\u1E33\u1E35\u1E37\u1E39\u1E3B\u1E3D\u1E3F\u1E41\u1E43\u1E45\u1E47\u1E49\u1E4B\u1E4D\u1E4F\u1E51\u1E53\u1E55\u1E57\u1E59\u1E5B\u1E5D\u1E5F\u1E61\u1E63\u1E65\u1E67\u1E69\u1E6B\u1E6D\u1E6F\u1E71\u1E73\u1E75\u1E77\u1E79\u1E7B\u1E7D\u1E7F\u1E81\u1E83\u1E85\u1E87\u1E89\u1E8B\u1E8D\u1E8F\u1E91\u1E93\u1E95-\u1E9D\u1E9F\u1EA1\u1EA3\u1EA5\u1EA7\u1EA9\u1EAB\u1EAD\u1EAF\u1EB1\u1EB3\u1EB5\u1EB7\u1EB9\u1EBB\u1EBD\u1EBF\u1EC1\u1EC3\u1EC5\u1EC7\u1EC9\u1ECB\u1ECD\u1ECF\u1ED1\u1ED3\u1ED5\u1ED7\u1ED9\u1EDB\u1EDD\u1EDF\u1EE1\u1EE3\u1EE5\u1EE7\u1EE9\u1EEB\u1EED\u1EEF\u1EF1\u1EF3\u1EF5\u1EF7\u1EF9\u1EFB\u1EFD\u1EFF-\u1F07\u1F10-\u1F15\u1F20-\u1F27\u1F30-\u1F37\u1F40-\u1F45\u1F50-\u1F57\u1F60-\u1F67\u1F70-\u1F7D\u1F80-\u1F87\u1F90-\u1F97\u1FA0-\u1FA7\u1FB0-\u1FB4\u1FB6\u1FB7\u1FBE\u1FC2-\u1FC4\u1FC6\u1FC7\u1FD0-\u1FD3\u1FD6\u1FD7\u1FE0-\u1FE7\u1FF2-\u1FF4\u1FF6\u1FF7\u210A\u210E\u210F\u2113\u212F\u2134\u2139\u213C\u213D\u2146-\u2149\u214E\u2184\u2C30-\u2C5E\u2C61\u2C65\u2C66\u2C68\u2C6A\u2C6C\u2C71\u2C73\u2C74\u2C76-\u2C7B\u2C81\u2C83\u2C85\u2C87\u2C89\u2C8B\u2C8D\u2C8F\u2C91\u2C93\u2C95\u2C97\u2C99\u2C9B\u2C9D\u2C9F\u2CA1\u2CA3\u2CA5\u2CA7\u2CA9\u2CAB\u2CAD\u2CAF\u2CB1\u2CB3\u2CB5\u2CB7\u2CB9\u2CBB\u2CBD\u2CBF\u2CC1\u2CC3\u2CC5\u2CC7\u2CC9\u2CCB\u2CCD\u2CCF\u2CD1\u2CD3\u2CD5\u2CD7\u2CD9\u2CDB\u2CDD\u2CDF\u2CE1\u2CE3\u2CE4\u2CEC\u2CEE\u2CF3\u2D00-\u2D25\u2D27\u2D2D\uA641\uA643\uA645\uA647\uA649\uA64B\uA64D\uA64F\uA651\uA653\uA655\uA657\uA659\uA65B\uA65D\uA65F\uA661\uA663\uA665\uA667\uA669\uA66B\uA66D\uA681\uA683\uA685\uA687\uA689\uA68B\uA68D\uA68F\uA691\uA693\uA695\uA697\uA699\uA69B\uA723\uA725\uA727\uA729\uA72B\uA72D\uA72F-\uA731\uA733\uA735\uA737\uA739\uA73B\uA73D\uA73F\uA741\uA743\uA745\uA747\uA749\uA74B\uA74D\uA74F\uA751\uA753\uA755\uA757\uA759\uA75B\uA75D\uA75F\uA761\uA763\uA765\uA767\uA769\uA76B\uA76D\uA76F\uA771-\uA778\uA77A\uA77C\uA77F\uA781\uA783\uA785\uA787\uA78C\uA78E\uA791\uA793-\uA795\uA797\uA799\uA79B\uA79D\uA79F\uA7A1\uA7A3\uA7A5\uA7A7\uA7A9\uA7B5\uA7B7\uA7FA\uAB30-\uAB5A\uAB60-\uAB65\uAB70-\uABBF\uFB00-\uFB06\uFB13-\uFB17\uFF41-\uFF5A",astral:"\uD801[\uDC28-\uDC4F\uDCD8-\uDCFB]|\uD803[\uDCC0-\uDCF2]|\uD806[\uDCC0-\uDCDF]|\uD835[\uDC1A-\uDC33\uDC4E-\uDC54\uDC56-\uDC67\uDC82-\uDC9B\uDCB6-\uDCB9\uDCBB\uDCBD-\uDCC3\uDCC5-\uDCCF\uDCEA-\uDD03\uDD1E-\uDD37\uDD52-\uDD6B\uDD86-\uDD9F\uDDBA-\uDDD3\uDDEE-\uDE07\uDE22-\uDE3B\uDE56-\uDE6F\uDE8A-\uDEA5\uDEC2-\uDEDA\uDEDC-\uDEE1\uDEFC-\uDF14\uDF16-\uDF1B\uDF36-\uDF4E\uDF50-\uDF55\uDF70-\uDF88\uDF8A-\uDF8F\uDFAA-\uDFC2\uDFC4-\uDFC9\uDFCB]|\uD83A[\uDD22-\uDD43]"},{name:"Lm",alias:"Modifier_Letter",bmp:"\u02B0-\u02C1\u02C6-\u02D1\u02E0-\u02E4\u02EC\u02EE\u0374\u037A\u0559\u0640\u06E5\u06E6\u07F4\u07F5\u07FA\u081A\u0824\u0828\u0971\u0E46\u0EC6\u10FC\u17D7\u1843\u1AA7\u1C78-\u1C7D\u1D2C-\u1D6A\u1D78\u1D9B-\u1DBF\u2071\u207F\u2090-\u209C\u2C7C\u2C7D\u2D6F\u2E2F\u3005\u3031-\u3035\u303B\u309D\u309E\u30FC-\u30FE\uA015\uA4F8-\uA4FD\uA60C\uA67F\uA69C\uA69D\uA717-\uA71F\uA770\uA788\uA7F8\uA7F9\uA9CF\uA9E6\uAA70\uAADD\uAAF3\uAAF4\uAB5C-\uAB5F\uFF70\uFF9E\uFF9F",astral:"\uD81A[\uDF40-\uDF43]|\uD81B[\uDF93-\uDF9F\uDFE0]"},{name:"Lo",alias:"Other_Letter",bmp:"\xAA\xBA\u01BB\u01C0-\u01C3\u0294\u05D0-\u05EA\u05F0-\u05F2\u0620-\u063F\u0641-\u064A\u066E\u066F\u0671-\u06D3\u06D5\u06EE\u06EF\u06FA-\u06FC\u06FF\u0710\u0712-\u072F\u074D-\u07A5\u07B1\u07CA-\u07EA\u0800-\u0815\u0840-\u0858\u08A0-\u08B4\u08B6-\u08BD\u0904-\u0939\u093D\u0950\u0958-\u0961\u0972-\u0980\u0985-\u098C\u098F\u0990\u0993-\u09A8\u09AA-\u09B0\u09B2\u09B6-\u09B9\u09BD\u09CE\u09DC\u09DD\u09DF-\u09E1\u09F0\u09F1\u0A05-\u0A0A\u0A0F\u0A10\u0A13-\u0A28\u0A2A-\u0A30\u0A32\u0A33\u0A35\u0A36\u0A38\u0A39\u0A59-\u0A5C\u0A5E\u0A72-\u0A74\u0A85-\u0A8D\u0A8F-\u0A91\u0A93-\u0AA8\u0AAA-\u0AB0\u0AB2\u0AB3\u0AB5-\u0AB9\u0ABD\u0AD0\u0AE0\u0AE1\u0AF9\u0B05-\u0B0C\u0B0F\u0B10\u0B13-\u0B28\u0B2A-\u0B30\u0B32\u0B33\u0B35-\u0B39\u0B3D\u0B5C\u0B5D\u0B5F-\u0B61\u0B71\u0B83\u0B85-\u0B8A\u0B8E-\u0B90\u0B92-\u0B95\u0B99\u0B9A\u0B9C\u0B9E\u0B9F\u0BA3\u0BA4\u0BA8-\u0BAA\u0BAE-\u0BB9\u0BD0\u0C05-\u0C0C\u0C0E-\u0C10\u0C12-\u0C28\u0C2A-\u0C39\u0C3D\u0C58-\u0C5A\u0C60\u0C61\u0C80\u0C85-\u0C8C\u0C8E-\u0C90\u0C92-\u0CA8\u0CAA-\u0CB3\u0CB5-\u0CB9\u0CBD\u0CDE\u0CE0\u0CE1\u0CF1\u0CF2\u0D05-\u0D0C\u0D0E-\u0D10\u0D12-\u0D3A\u0D3D\u0D4E\u0D54-\u0D56\u0D5F-\u0D61\u0D7A-\u0D7F\u0D85-\u0D96\u0D9A-\u0DB1\u0DB3-\u0DBB\u0DBD\u0DC0-\u0DC6\u0E01-\u0E30\u0E32\u0E33\u0E40-\u0E45\u0E81\u0E82\u0E84\u0E87\u0E88\u0E8A\u0E8D\u0E94-\u0E97\u0E99-\u0E9F\u0EA1-\u0EA3\u0EA5\u0EA7\u0EAA\u0EAB\u0EAD-\u0EB0\u0EB2\u0EB3\u0EBD\u0EC0-\u0EC4\u0EDC-\u0EDF\u0F00\u0F40-\u0F47\u0F49-\u0F6C\u0F88-\u0F8C\u1000-\u102A\u103F\u1050-\u1055\u105A-\u105D\u1061\u1065\u1066\u106E-\u1070\u1075-\u1081\u108E\u10D0-\u10FA\u10FD-\u1248\u124A-\u124D\u1250-\u1256\u1258\u125A-\u125D\u1260-\u1288\u128A-\u128D\u1290-\u12B0\u12B2-\u12B5\u12B8-\u12BE\u12C0\u12C2-\u12C5\u12C8-\u12D6\u12D8-\u1310\u1312-\u1315\u1318-\u135A\u1380-\u138F\u1401-\u166C\u166F-\u167F\u1681-\u169A\u16A0-\u16EA\u16F1-\u16F8\u1700-\u170C\u170E-\u1711\u1720-\u1731\u1740-\u1751\u1760-\u176C\u176E-\u1770\u1780-\u17B3\u17DC\u1820-\u1842\u1844-\u1877\u1880-\u1884\u1887-\u18A8\u18AA\u18B0-\u18F5\u1900-\u191E\u1950-\u196D\u1970-\u1974\u1980-\u19AB\u19B0-\u19C9\u1A00-\u1A16\u1A20-\u1A54\u1B05-\u1B33\u1B45-\u1B4B\u1B83-\u1BA0\u1BAE\u1BAF\u1BBA-\u1BE5\u1C00-\u1C23\u1C4D-\u1C4F\u1C5A-\u1C77\u1CE9-\u1CEC\u1CEE-\u1CF1\u1CF5\u1CF6\u2135-\u2138\u2D30-\u2D67\u2D80-\u2D96\u2DA0-\u2DA6\u2DA8-\u2DAE\u2DB0-\u2DB6\u2DB8-\u2DBE\u2DC0-\u2DC6\u2DC8-\u2DCE\u2DD0-\u2DD6\u2DD8-\u2DDE\u3006\u303C\u3041-\u3096\u309F\u30A1-\u30FA\u30FF\u3105-\u312D\u3131-\u318E\u31A0-\u31BA\u31F0-\u31FF\u3400-\u4DB5\u4E00-\u9FD5\uA000-\uA014\uA016-\uA48C\uA4D0-\uA4F7\uA500-\uA60B\uA610-\uA61F\uA62A\uA62B\uA66E\uA6A0-\uA6E5\uA78F\uA7F7\uA7FB-\uA801\uA803-\uA805\uA807-\uA80A\uA80C-\uA822\uA840-\uA873\uA882-\uA8B3\uA8F2-\uA8F7\uA8FB\uA8FD\uA90A-\uA925\uA930-\uA946\uA960-\uA97C\uA984-\uA9B2\uA9E0-\uA9E4\uA9E7-\uA9EF\uA9FA-\uA9FE\uAA00-\uAA28\uAA40-\uAA42\uAA44-\uAA4B\uAA60-\uAA6F\uAA71-\uAA76\uAA7A\uAA7E-\uAAAF\uAAB1\uAAB5\uAAB6\uAAB9-\uAABD\uAAC0\uAAC2\uAADB\uAADC\uAAE0-\uAAEA\uAAF2\uAB01-\uAB06\uAB09-\uAB0E\uAB11-\uAB16\uAB20-\uAB26\uAB28-\uAB2E\uABC0-\uABE2\uAC00-\uD7A3\uD7B0-\uD7C6\uD7CB-\uD7FB\uF900-\uFA6D\uFA70-\uFAD9\uFB1D\uFB1F-\uFB28\uFB2A-\uFB36\uFB38-\uFB3C\uFB3E\uFB40\uFB41\uFB43\uFB44\uFB46-\uFBB1\uFBD3-\uFD3D\uFD50-\uFD8F\uFD92-\uFDC7\uFDF0-\uFDFB\uFE70-\uFE74\uFE76-\uFEFC\uFF66-\uFF6F\uFF71-\uFF9D\uFFA0-\uFFBE\uFFC2-\uFFC7\uFFCA-\uFFCF\uFFD2-\uFFD7\uFFDA-\uFFDC",astral:"\uD800[\uDC00-\uDC0B\uDC0D-\uDC26\uDC28-\uDC3A\uDC3C\uDC3D\uDC3F-\uDC4D\uDC50-\uDC5D\uDC80-\uDCFA\uDE80-\uDE9C\uDEA0-\uDED0\uDF00-\uDF1F\uDF30-\uDF40\uDF42-\uDF49\uDF50-\uDF75\uDF80-\uDF9D\uDFA0-\uDFC3\uDFC8-\uDFCF]|\uD801[\uDC50-\uDC9D\uDD00-\uDD27\uDD30-\uDD63\uDE00-\uDF36\uDF40-\uDF55\uDF60-\uDF67]|\uD802[\uDC00-\uDC05\uDC08\uDC0A-\uDC35\uDC37\uDC38\uDC3C\uDC3F-\uDC55\uDC60-\uDC76\uDC80-\uDC9E\uDCE0-\uDCF2\uDCF4\uDCF5\uDD00-\uDD15\uDD20-\uDD39\uDD80-\uDDB7\uDDBE\uDDBF\uDE00\uDE10-\uDE13\uDE15-\uDE17\uDE19-\uDE33\uDE60-\uDE7C\uDE80-\uDE9C\uDEC0-\uDEC7\uDEC9-\uDEE4\uDF00-\uDF35\uDF40-\uDF55\uDF60-\uDF72\uDF80-\uDF91]|\uD803[\uDC00-\uDC48]|\uD804[\uDC03-\uDC37\uDC83-\uDCAF\uDCD0-\uDCE8\uDD03-\uDD26\uDD50-\uDD72\uDD76\uDD83-\uDDB2\uDDC1-\uDDC4\uDDDA\uDDDC\uDE00-\uDE11\uDE13-\uDE2B\uDE80-\uDE86\uDE88\uDE8A-\uDE8D\uDE8F-\uDE9D\uDE9F-\uDEA8\uDEB0-\uDEDE\uDF05-\uDF0C\uDF0F\uDF10\uDF13-\uDF28\uDF2A-\uDF30\uDF32\uDF33\uDF35-\uDF39\uDF3D\uDF50\uDF5D-\uDF61]|\uD805[\uDC00-\uDC34\uDC47-\uDC4A\uDC80-\uDCAF\uDCC4\uDCC5\uDCC7\uDD80-\uDDAE\uDDD8-\uDDDB\uDE00-\uDE2F\uDE44\uDE80-\uDEAA\uDF00-\uDF19]|\uD806[\uDCFF\uDEC0-\uDEF8]|\uD807[\uDC00-\uDC08\uDC0A-\uDC2E\uDC40\uDC72-\uDC8F]|\uD808[\uDC00-\uDF99]|\uD809[\uDC80-\uDD43]|[\uD80C\uD81C-\uD820\uD840-\uD868\uD86A-\uD86C\uD86F-\uD872][\uDC00-\uDFFF]|\uD80D[\uDC00-\uDC2E]|\uD811[\uDC00-\uDE46]|\uD81A[\uDC00-\uDE38\uDE40-\uDE5E\uDED0-\uDEED\uDF00-\uDF2F\uDF63-\uDF77\uDF7D-\uDF8F]|\uD81B[\uDF00-\uDF44\uDF50]|\uD821[\uDC00-\uDFEC]|\uD822[\uDC00-\uDEF2]|\uD82C[\uDC00\uDC01]|\uD82F[\uDC00-\uDC6A\uDC70-\uDC7C\uDC80-\uDC88\uDC90-\uDC99]|\uD83A[\uDC00-\uDCC4]|\uD83B[\uDE00-\uDE03\uDE05-\uDE1F\uDE21\uDE22\uDE24\uDE27\uDE29-\uDE32\uDE34-\uDE37\uDE39\uDE3B\uDE42\uDE47\uDE49\uDE4B\uDE4D-\uDE4F\uDE51\uDE52\uDE54\uDE57\uDE59\uDE5B\uDE5D\uDE5F\uDE61\uDE62\uDE64\uDE67-\uDE6A\uDE6C-\uDE72\uDE74-\uDE77\uDE79-\uDE7C\uDE7E\uDE80-\uDE89\uDE8B-\uDE9B\uDEA1-\uDEA3\uDEA5-\uDEA9\uDEAB-\uDEBB]|\uD869[\uDC00-\uDED6\uDF00-\uDFFF]|\uD86D[\uDC00-\uDF34\uDF40-\uDFFF]|\uD86E[\uDC00-\uDC1D\uDC20-\uDFFF]|\uD873[\uDC00-\uDEA1]|\uD87E[\uDC00-\uDE1D]"},{name:"Lt",alias:"Titlecase_Letter",bmp:"\u01C5\u01C8\u01CB\u01F2\u1F88-\u1F8F\u1F98-\u1F9F\u1FA8-\u1FAF\u1FBC\u1FCC\u1FFC"},{name:"Lu",alias:"Uppercase_Letter",bmp:"A-Z\xC0-\xD6\xD8-\xDE\u0100\u0102\u0104\u0106\u0108\u010A\u010C\u010E\u0110\u0112\u0114\u0116\u0118\u011A\u011C\u011E\u0120\u0122\u0124\u0126\u0128\u012A\u012C\u012E\u0130\u0132\u0134\u0136\u0139\u013B\u013D\u013F\u0141\u0143\u0145\u0147\u014A\u014C\u014E\u0150\u0152\u0154\u0156\u0158\u015A\u015C\u015E\u0160\u0162\u0164\u0166\u0168\u016A\u016C\u016E\u0170\u0172\u0174\u0176\u0178\u0179\u017B\u017D\u0181\u0182\u0184\u0186\u0187\u0189-\u018B\u018E-\u0191\u0193\u0194\u0196-\u0198\u019C\u019D\u019F\u01A0\u01A2\u01A4\u01A6\u01A7\u01A9\u01AC\u01AE\u01AF\u01B1-\u01B3\u01B5\u01B7\u01B8\u01BC\u01C4\u01C7\u01CA\u01CD\u01CF\u01D1\u01D3\u01D5\u01D7\u01D9\u01DB\u01DE\u01E0\u01E2\u01E4\u01E6\u01E8\u01EA\u01EC\u01EE\u01F1\u01F4\u01F6-\u01F8\u01FA\u01FC\u01FE\u0200\u0202\u0204\u0206\u0208\u020A\u020C\u020E\u0210\u0212\u0214\u0216\u0218\u021A\u021C\u021E\u0220\u0222\u0224\u0226\u0228\u022A\u022C\u022E\u0230\u0232\u023A\u023B\u023D\u023E\u0241\u0243-\u0246\u0248\u024A\u024C\u024E\u0370\u0372\u0376\u037F\u0386\u0388-\u038A\u038C\u038E\u038F\u0391-\u03A1\u03A3-\u03AB\u03CF\u03D2-\u03D4\u03D8\u03DA\u03DC\u03DE\u03E0\u03E2\u03E4\u03E6\u03E8\u03EA\u03EC\u03EE\u03F4\u03F7\u03F9\u03FA\u03FD-\u042F\u0460\u0462\u0464\u0466\u0468\u046A\u046C\u046E\u0470\u0472\u0474\u0476\u0478\u047A\u047C\u047E\u0480\u048A\u048C\u048E\u0490\u0492\u0494\u0496\u0498\u049A\u049C\u049E\u04A0\u04A2\u04A4\u04A6\u04A8\u04AA\u04AC\u04AE\u04B0\u04B2\u04B4\u04B6\u04B8\u04BA\u04BC\u04BE\u04C0\u04C1\u04C3\u04C5\u04C7\u04C9\u04CB\u04CD\u04D0\u04D2\u04D4\u04D6\u04D8\u04DA\u04DC\u04DE\u04E0\u04E2\u04E4\u04E6\u04E8\u04EA\u04EC\u04EE\u04F0\u04F2\u04F4\u04F6\u04F8\u04FA\u04FC\u04FE\u0500\u0502\u0504\u0506\u0508\u050A\u050C\u050E\u0510\u0512\u0514\u0516\u0518\u051A\u051C\u051E\u0520\u0522\u0524\u0526\u0528\u052A\u052C\u052E\u0531-\u0556\u10A0-\u10C5\u10C7\u10CD\u13A0-\u13F5\u1E00\u1E02\u1E04\u1E06\u1E08\u1E0A\u1E0C\u1E0E\u1E10\u1E12\u1E14\u1E16\u1E18\u1E1A\u1E1C\u1E1E\u1E20\u1E22\u1E24\u1E26\u1E28\u1E2A\u1E2C\u1E2E\u1E30\u1E32\u1E34\u1E36\u1E38\u1E3A\u1E3C\u1E3E\u1E40\u1E42\u1E44\u1E46\u1E48\u1E4A\u1E4C\u1E4E\u1E50\u1E52\u1E54\u1E56\u1E58\u1E5A\u1E5C\u1E5E\u1E60\u1E62\u1E64\u1E66\u1E68\u1E6A\u1E6C\u1E6E\u1E70\u1E72\u1E74\u1E76\u1E78\u1E7A\u1E7C\u1E7E\u1E80\u1E82\u1E84\u1E86\u1E88\u1E8A\u1E8C\u1E8E\u1E90\u1E92\u1E94\u1E9E\u1EA0\u1EA2\u1EA4\u1EA6\u1EA8\u1EAA\u1EAC\u1EAE\u1EB0\u1EB2\u1EB4\u1EB6\u1EB8\u1EBA\u1EBC\u1EBE\u1EC0\u1EC2\u1EC4\u1EC6\u1EC8\u1ECA\u1ECC\u1ECE\u1ED0\u1ED2\u1ED4\u1ED6\u1ED8\u1EDA\u1EDC\u1EDE\u1EE0\u1EE2\u1EE4\u1EE6\u1EE8\u1EEA\u1EEC\u1EEE\u1EF0\u1EF2\u1EF4\u1EF6\u1EF8\u1EFA\u1EFC\u1EFE\u1F08-\u1F0F\u1F18-\u1F1D\u1F28-\u1F2F\u1F38-\u1F3F\u1F48-\u1F4D\u1F59\u1F5B\u1F5D\u1F5F\u1F68-\u1F6F\u1FB8-\u1FBB\u1FC8-\u1FCB\u1FD8-\u1FDB\u1FE8-\u1FEC\u1FF8-\u1FFB\u2102\u2107\u210B-\u210D\u2110-\u2112\u2115\u2119-\u211D\u2124\u2126\u2128\u212A-\u212D\u2130-\u2133\u213E\u213F\u2145\u2183\u2C00-\u2C2E\u2C60\u2C62-\u2C64\u2C67\u2C69\u2C6B\u2C6D-\u2C70\u2C72\u2C75\u2C7E-\u2C80\u2C82\u2C84\u2C86\u2C88\u2C8A\u2C8C\u2C8E\u2C90\u2C92\u2C94\u2C96\u2C98\u2C9A\u2C9C\u2C9E\u2CA0\u2CA2\u2CA4\u2CA6\u2CA8\u2CAA\u2CAC\u2CAE\u2CB0\u2CB2\u2CB4\u2CB6\u2CB8\u2CBA\u2CBC\u2CBE\u2CC0\u2CC2\u2CC4\u2CC6\u2CC8\u2CCA\u2CCC\u2CCE\u2CD0\u2CD2\u2CD4\u2CD6\u2CD8\u2CDA\u2CDC\u2CDE\u2CE0\u2CE2\u2CEB\u2CED\u2CF2\uA640\uA642\uA644\uA646\uA648\uA64A\uA64C\uA64E\uA650\uA652\uA654\uA656\uA658\uA65A\uA65C\uA65E\uA660\uA662\uA664\uA666\uA668\uA66A\uA66C\uA680\uA682\uA684\uA686\uA688\uA68A\uA68C\uA68E\uA690\uA692\uA694\uA696\uA698\uA69A\uA722\uA724\uA726\uA728\uA72A\uA72C\uA72E\uA732\uA734\uA736\uA738\uA73A\uA73C\uA73E\uA740\uA742\uA744\uA746\uA748\uA74A\uA74C\uA74E\uA750\uA752\uA754\uA756\uA758\uA75A\uA75C\uA75E\uA760\uA762\uA764\uA766\uA768\uA76A\uA76C\uA76E\uA779\uA77B\uA77D\uA77E\uA780\uA782\uA784\uA786\uA78B\uA78D\uA790\uA792\uA796\uA798\uA79A\uA79C\uA79E\uA7A0\uA7A2\uA7A4\uA7A6\uA7A8\uA7AA-\uA7AE\uA7B0-\uA7B4\uA7B6\uFF21-\uFF3A",astral:"\uD801[\uDC00-\uDC27\uDCB0-\uDCD3]|\uD803[\uDC80-\uDCB2]|\uD806[\uDCA0-\uDCBF]|\uD835[\uDC00-\uDC19\uDC34-\uDC4D\uDC68-\uDC81\uDC9C\uDC9E\uDC9F\uDCA2\uDCA5\uDCA6\uDCA9-\uDCAC\uDCAE-\uDCB5\uDCD0-\uDCE9\uDD04\uDD05\uDD07-\uDD0A\uDD0D-\uDD14\uDD16-\uDD1C\uDD38\uDD39\uDD3B-\uDD3E\uDD40-\uDD44\uDD46\uDD4A-\uDD50\uDD6C-\uDD85\uDDA0-\uDDB9\uDDD4-\uDDED\uDE08-\uDE21\uDE3C-\uDE55\uDE70-\uDE89\uDEA8-\uDEC0\uDEE2-\uDEFA\uDF1C-\uDF34\uDF56-\uDF6E\uDF90-\uDFA8\uDFCA]|\uD83A[\uDD00-\uDD21]"},{name:"M",alias:"Mark",bmp:"\u0300-\u036F\u0483-\u0489\u0591-\u05BD\u05BF\u05C1\u05C2\u05C4\u05C5\u05C7\u0610-\u061A\u064B-\u065F\u0670\u06D6-\u06DC\u06DF-\u06E4\u06E7\u06E8\u06EA-\u06ED\u0711\u0730-\u074A\u07A6-\u07B0\u07EB-\u07F3\u0816-\u0819\u081B-\u0823\u0825-\u0827\u0829-\u082D\u0859-\u085B\u08D4-\u08E1\u08E3-\u0903\u093A-\u093C\u093E-\u094F\u0951-\u0957\u0962\u0963\u0981-\u0983\u09BC\u09BE-\u09C4\u09C7\u09C8\u09CB-\u09CD\u09D7\u09E2\u09E3\u0A01-\u0A03\u0A3C\u0A3E-\u0A42\u0A47\u0A48\u0A4B-\u0A4D\u0A51\u0A70\u0A71\u0A75\u0A81-\u0A83\u0ABC\u0ABE-\u0AC5\u0AC7-\u0AC9\u0ACB-\u0ACD\u0AE2\u0AE3\u0B01-\u0B03\u0B3C\u0B3E-\u0B44\u0B47\u0B48\u0B4B-\u0B4D\u0B56\u0B57\u0B62\u0B63\u0B82\u0BBE-\u0BC2\u0BC6-\u0BC8\u0BCA-\u0BCD\u0BD7\u0C00-\u0C03\u0C3E-\u0C44\u0C46-\u0C48\u0C4A-\u0C4D\u0C55\u0C56\u0C62\u0C63\u0C81-\u0C83\u0CBC\u0CBE-\u0CC4\u0CC6-\u0CC8\u0CCA-\u0CCD\u0CD5\u0CD6\u0CE2\u0CE3\u0D01-\u0D03\u0D3E-\u0D44\u0D46-\u0D48\u0D4A-\u0D4D\u0D57\u0D62\u0D63\u0D82\u0D83\u0DCA\u0DCF-\u0DD4\u0DD6\u0DD8-\u0DDF\u0DF2\u0DF3\u0E31\u0E34-\u0E3A\u0E47-\u0E4E\u0EB1\u0EB4-\u0EB9\u0EBB\u0EBC\u0EC8-\u0ECD\u0F18\u0F19\u0F35\u0F37\u0F39\u0F3E\u0F3F\u0F71-\u0F84\u0F86\u0F87\u0F8D-\u0F97\u0F99-\u0FBC\u0FC6\u102B-\u103E\u1056-\u1059\u105E-\u1060\u1062-\u1064\u1067-\u106D\u1071-\u1074\u1082-\u108D\u108F\u109A-\u109D\u135D-\u135F\u1712-\u1714\u1732-\u1734\u1752\u1753\u1772\u1773\u17B4-\u17D3\u17DD\u180B-\u180D\u1885\u1886\u18A9\u1920-\u192B\u1930-\u193B\u1A17-\u1A1B\u1A55-\u1A5E\u1A60-\u1A7C\u1A7F\u1AB0-\u1ABE\u1B00-\u1B04\u1B34-\u1B44\u1B6B-\u1B73\u1B80-\u1B82\u1BA1-\u1BAD\u1BE6-\u1BF3\u1C24-\u1C37\u1CD0-\u1CD2\u1CD4-\u1CE8\u1CED\u1CF2-\u1CF4\u1CF8\u1CF9\u1DC0-\u1DF5\u1DFB-\u1DFF\u20D0-\u20F0\u2CEF-\u2CF1\u2D7F\u2DE0-\u2DFF\u302A-\u302F\u3099\u309A\uA66F-\uA672\uA674-\uA67D\uA69E\uA69F\uA6F0\uA6F1\uA802\uA806\uA80B\uA823-\uA827\uA880\uA881\uA8B4-\uA8C5\uA8E0-\uA8F1\uA926-\uA92D\uA947-\uA953\uA980-\uA983\uA9B3-\uA9C0\uA9E5\uAA29-\uAA36\uAA43\uAA4C\uAA4D\uAA7B-\uAA7D\uAAB0\uAAB2-\uAAB4\uAAB7\uAAB8\uAABE\uAABF\uAAC1\uAAEB-\uAAEF\uAAF5\uAAF6\uABE3-\uABEA\uABEC\uABED\uFB1E\uFE00-\uFE0F\uFE20-\uFE2F",astral:"\uD800[\uDDFD\uDEE0\uDF76-\uDF7A]|\uD802[\uDE01-\uDE03\uDE05\uDE06\uDE0C-\uDE0F\uDE38-\uDE3A\uDE3F\uDEE5\uDEE6]|\uD804[\uDC00-\uDC02\uDC38-\uDC46\uDC7F-\uDC82\uDCB0-\uDCBA\uDD00-\uDD02\uDD27-\uDD34\uDD73\uDD80-\uDD82\uDDB3-\uDDC0\uDDCA-\uDDCC\uDE2C-\uDE37\uDE3E\uDEDF-\uDEEA\uDF00-\uDF03\uDF3C\uDF3E-\uDF44\uDF47\uDF48\uDF4B-\uDF4D\uDF57\uDF62\uDF63\uDF66-\uDF6C\uDF70-\uDF74]|\uD805[\uDC35-\uDC46\uDCB0-\uDCC3\uDDAF-\uDDB5\uDDB8-\uDDC0\uDDDC\uDDDD\uDE30-\uDE40\uDEAB-\uDEB7\uDF1D-\uDF2B]|\uD807[\uDC2F-\uDC36\uDC38-\uDC3F\uDC92-\uDCA7\uDCA9-\uDCB6]|\uD81A[\uDEF0-\uDEF4\uDF30-\uDF36]|\uD81B[\uDF51-\uDF7E\uDF8F-\uDF92]|\uD82F[\uDC9D\uDC9E]|\uD834[\uDD65-\uDD69\uDD6D-\uDD72\uDD7B-\uDD82\uDD85-\uDD8B\uDDAA-\uDDAD\uDE42-\uDE44]|\uD836[\uDE00-\uDE36\uDE3B-\uDE6C\uDE75\uDE84\uDE9B-\uDE9F\uDEA1-\uDEAF]|\uD838[\uDC00-\uDC06\uDC08-\uDC18\uDC1B-\uDC21\uDC23\uDC24\uDC26-\uDC2A]|\uD83A[\uDCD0-\uDCD6\uDD44-\uDD4A]|\uDB40[\uDD00-\uDDEF]"},{name:"Mc",alias:"Spacing_Mark",bmp:"\u0903\u093B\u093E-\u0940\u0949-\u094C\u094E\u094F\u0982\u0983\u09BE-\u09C0\u09C7\u09C8\u09CB\u09CC\u09D7\u0A03\u0A3E-\u0A40\u0A83\u0ABE-\u0AC0\u0AC9\u0ACB\u0ACC\u0B02\u0B03\u0B3E\u0B40\u0B47\u0B48\u0B4B\u0B4C\u0B57\u0BBE\u0BBF\u0BC1\u0BC2\u0BC6-\u0BC8\u0BCA-\u0BCC\u0BD7\u0C01-\u0C03\u0C41-\u0C44\u0C82\u0C83\u0CBE\u0CC0-\u0CC4\u0CC7\u0CC8\u0CCA\u0CCB\u0CD5\u0CD6\u0D02\u0D03\u0D3E-\u0D40\u0D46-\u0D48\u0D4A-\u0D4C\u0D57\u0D82\u0D83\u0DCF-\u0DD1\u0DD8-\u0DDF\u0DF2\u0DF3\u0F3E\u0F3F\u0F7F\u102B\u102C\u1031\u1038\u103B\u103C\u1056\u1057\u1062-\u1064\u1067-\u106D\u1083\u1084\u1087-\u108C\u108F\u109A-\u109C\u17B6\u17BE-\u17C5\u17C7\u17C8\u1923-\u1926\u1929-\u192B\u1930\u1931\u1933-\u1938\u1A19\u1A1A\u1A55\u1A57\u1A61\u1A63\u1A64\u1A6D-\u1A72\u1B04\u1B35\u1B3B\u1B3D-\u1B41\u1B43\u1B44\u1B82\u1BA1\u1BA6\u1BA7\u1BAA\u1BE7\u1BEA-\u1BEC\u1BEE\u1BF2\u1BF3\u1C24-\u1C2B\u1C34\u1C35\u1CE1\u1CF2\u1CF3\u302E\u302F\uA823\uA824\uA827\uA880\uA881\uA8B4-\uA8C3\uA952\uA953\uA983\uA9B4\uA9B5\uA9BA\uA9BB\uA9BD-\uA9C0\uAA2F\uAA30\uAA33\uAA34\uAA4D\uAA7B\uAA7D\uAAEB\uAAEE\uAAEF\uAAF5\uABE3\uABE4\uABE6\uABE7\uABE9\uABEA\uABEC",astral:"\uD804[\uDC00\uDC02\uDC82\uDCB0-\uDCB2\uDCB7\uDCB8\uDD2C\uDD82\uDDB3-\uDDB5\uDDBF\uDDC0\uDE2C-\uDE2E\uDE32\uDE33\uDE35\uDEE0-\uDEE2\uDF02\uDF03\uDF3E\uDF3F\uDF41-\uDF44\uDF47\uDF48\uDF4B-\uDF4D\uDF57\uDF62\uDF63]|\uD805[\uDC35-\uDC37\uDC40\uDC41\uDC45\uDCB0-\uDCB2\uDCB9\uDCBB-\uDCBE\uDCC1\uDDAF-\uDDB1\uDDB8-\uDDBB\uDDBE\uDE30-\uDE32\uDE3B\uDE3C\uDE3E\uDEAC\uDEAE\uDEAF\uDEB6\uDF20\uDF21\uDF26]|\uD807[\uDC2F\uDC3E\uDCA9\uDCB1\uDCB4]|\uD81B[\uDF51-\uDF7E]|\uD834[\uDD65\uDD66\uDD6D-\uDD72]"},{name:"Me",alias:"Enclosing_Mark",bmp:"\u0488\u0489\u1ABE\u20DD-\u20E0\u20E2-\u20E4\uA670-\uA672"},{name:"Mn",alias:"Nonspacing_Mark",bmp:"\u0300-\u036F\u0483-\u0487\u0591-\u05BD\u05BF\u05C1\u05C2\u05C4\u05C5\u05C7\u0610-\u061A\u064B-\u065F\u0670\u06D6-\u06DC\u06DF-\u06E4\u06E7\u06E8\u06EA-\u06ED\u0711\u0730-\u074A\u07A6-\u07B0\u07EB-\u07F3\u0816-\u0819\u081B-\u0823\u0825-\u0827\u0829-\u082D\u0859-\u085B\u08D4-\u08E1\u08E3-\u0902\u093A\u093C\u0941-\u0948\u094D\u0951-\u0957\u0962\u0963\u0981\u09BC\u09C1-\u09C4\u09CD\u09E2\u09E3\u0A01\u0A02\u0A3C\u0A41\u0A42\u0A47\u0A48\u0A4B-\u0A4D\u0A51\u0A70\u0A71\u0A75\u0A81\u0A82\u0ABC\u0AC1-\u0AC5\u0AC7\u0AC8\u0ACD\u0AE2\u0AE3\u0B01\u0B3C\u0B3F\u0B41-\u0B44\u0B4D\u0B56\u0B62\u0B63\u0B82\u0BC0\u0BCD\u0C00\u0C3E-\u0C40\u0C46-\u0C48\u0C4A-\u0C4D\u0C55\u0C56\u0C62\u0C63\u0C81\u0CBC\u0CBF\u0CC6\u0CCC\u0CCD\u0CE2\u0CE3\u0D01\u0D41-\u0D44\u0D4D\u0D62\u0D63\u0DCA\u0DD2-\u0DD4\u0DD6\u0E31\u0E34-\u0E3A\u0E47-\u0E4E\u0EB1\u0EB4-\u0EB9\u0EBB\u0EBC\u0EC8-\u0ECD\u0F18\u0F19\u0F35\u0F37\u0F39\u0F71-\u0F7E\u0F80-\u0F84\u0F86\u0F87\u0F8D-\u0F97\u0F99-\u0FBC\u0FC6\u102D-\u1030\u1032-\u1037\u1039\u103A\u103D\u103E\u1058\u1059\u105E-\u1060\u1071-\u1074\u1082\u1085\u1086\u108D\u109D\u135D-\u135F\u1712-\u1714\u1732-\u1734\u1752\u1753\u1772\u1773\u17B4\u17B5\u17B7-\u17BD\u17C6\u17C9-\u17D3\u17DD\u180B-\u180D\u1885\u1886\u18A9\u1920-\u1922\u1927\u1928\u1932\u1939-\u193B\u1A17\u1A18\u1A1B\u1A56\u1A58-\u1A5E\u1A60\u1A62\u1A65-\u1A6C\u1A73-\u1A7C\u1A7F\u1AB0-\u1ABD\u1B00-\u1B03\u1B34\u1B36-\u1B3A\u1B3C\u1B42\u1B6B-\u1B73\u1B80\u1B81\u1BA2-\u1BA5\u1BA8\u1BA9\u1BAB-\u1BAD\u1BE6\u1BE8\u1BE9\u1BED\u1BEF-\u1BF1\u1C2C-\u1C33\u1C36\u1C37\u1CD0-\u1CD2\u1CD4-\u1CE0\u1CE2-\u1CE8\u1CED\u1CF4\u1CF8\u1CF9\u1DC0-\u1DF5\u1DFB-\u1DFF\u20D0-\u20DC\u20E1\u20E5-\u20F0\u2CEF-\u2CF1\u2D7F\u2DE0-\u2DFF\u302A-\u302D\u3099\u309A\uA66F\uA674-\uA67D\uA69E\uA69F\uA6F0\uA6F1\uA802\uA806\uA80B\uA825\uA826\uA8C4\uA8C5\uA8E0-\uA8F1\uA926-\uA92D\uA947-\uA951\uA980-\uA982\uA9B3\uA9B6-\uA9B9\uA9BC\uA9E5\uAA29-\uAA2E\uAA31\uAA32\uAA35\uAA36\uAA43\uAA4C\uAA7C\uAAB0\uAAB2-\uAAB4\uAAB7\uAAB8\uAABE\uAABF\uAAC1\uAAEC\uAAED\uAAF6\uABE5\uABE8\uABED\uFB1E\uFE00-\uFE0F\uFE20-\uFE2F",astral:"\uD800[\uDDFD\uDEE0\uDF76-\uDF7A]|\uD802[\uDE01-\uDE03\uDE05\uDE06\uDE0C-\uDE0F\uDE38-\uDE3A\uDE3F\uDEE5\uDEE6]|\uD804[\uDC01\uDC38-\uDC46\uDC7F-\uDC81\uDCB3-\uDCB6\uDCB9\uDCBA\uDD00-\uDD02\uDD27-\uDD2B\uDD2D-\uDD34\uDD73\uDD80\uDD81\uDDB6-\uDDBE\uDDCA-\uDDCC\uDE2F-\uDE31\uDE34\uDE36\uDE37\uDE3E\uDEDF\uDEE3-\uDEEA\uDF00\uDF01\uDF3C\uDF40\uDF66-\uDF6C\uDF70-\uDF74]|\uD805[\uDC38-\uDC3F\uDC42-\uDC44\uDC46\uDCB3-\uDCB8\uDCBA\uDCBF\uDCC0\uDCC2\uDCC3\uDDB2-\uDDB5\uDDBC\uDDBD\uDDBF\uDDC0\uDDDC\uDDDD\uDE33-\uDE3A\uDE3D\uDE3F\uDE40\uDEAB\uDEAD\uDEB0-\uDEB5\uDEB7\uDF1D-\uDF1F\uDF22-\uDF25\uDF27-\uDF2B]|\uD807[\uDC30-\uDC36\uDC38-\uDC3D\uDC3F\uDC92-\uDCA7\uDCAA-\uDCB0\uDCB2\uDCB3\uDCB5\uDCB6]|\uD81A[\uDEF0-\uDEF4\uDF30-\uDF36]|\uD81B[\uDF8F-\uDF92]|\uD82F[\uDC9D\uDC9E]|\uD834[\uDD67-\uDD69\uDD7B-\uDD82\uDD85-\uDD8B\uDDAA-\uDDAD\uDE42-\uDE44]|\uD836[\uDE00-\uDE36\uDE3B-\uDE6C\uDE75\uDE84\uDE9B-\uDE9F\uDEA1-\uDEAF]|\uD838[\uDC00-\uDC06\uDC08-\uDC18\uDC1B-\uDC21\uDC23\uDC24\uDC26-\uDC2A]|\uD83A[\uDCD0-\uDCD6\uDD44-\uDD4A]|\uDB40[\uDD00-\uDDEF]"},{name:"N",alias:"Number",bmp:"0-9\xB2\xB3\xB9\xBC-\xBE\u0660-\u0669\u06F0-\u06F9\u07C0-\u07C9\u0966-\u096F\u09E6-\u09EF\u09F4-\u09F9\u0A66-\u0A6F\u0AE6-\u0AEF\u0B66-\u0B6F\u0B72-\u0B77\u0BE6-\u0BF2\u0C66-\u0C6F\u0C78-\u0C7E\u0CE6-\u0CEF\u0D58-\u0D5E\u0D66-\u0D78\u0DE6-\u0DEF\u0E50-\u0E59\u0ED0-\u0ED9\u0F20-\u0F33\u1040-\u1049\u1090-\u1099\u1369-\u137C\u16EE-\u16F0\u17E0-\u17E9\u17F0-\u17F9\u1810-\u1819\u1946-\u194F\u19D0-\u19DA\u1A80-\u1A89\u1A90-\u1A99\u1B50-\u1B59\u1BB0-\u1BB9\u1C40-\u1C49\u1C50-\u1C59\u2070\u2074-\u2079\u2080-\u2089\u2150-\u2182\u2185-\u2189\u2460-\u249B\u24EA-\u24FF\u2776-\u2793\u2CFD\u3007\u3021-\u3029\u3038-\u303A\u3192-\u3195\u3220-\u3229\u3248-\u324F\u3251-\u325F\u3280-\u3289\u32B1-\u32BF\uA620-\uA629\uA6E6-\uA6EF\uA830-\uA835\uA8D0-\uA8D9\uA900-\uA909\uA9D0-\uA9D9\uA9F0-\uA9F9\uAA50-\uAA59\uABF0-\uABF9\uFF10-\uFF19",astral:"\uD800[\uDD07-\uDD33\uDD40-\uDD78\uDD8A\uDD8B\uDEE1-\uDEFB\uDF20-\uDF23\uDF41\uDF4A\uDFD1-\uDFD5]|\uD801[\uDCA0-\uDCA9]|\uD802[\uDC58-\uDC5F\uDC79-\uDC7F\uDCA7-\uDCAF\uDCFB-\uDCFF\uDD16-\uDD1B\uDDBC\uDDBD\uDDC0-\uDDCF\uDDD2-\uDDFF\uDE40-\uDE47\uDE7D\uDE7E\uDE9D-\uDE9F\uDEEB-\uDEEF\uDF58-\uDF5F\uDF78-\uDF7F\uDFA9-\uDFAF]|\uD803[\uDCFA-\uDCFF\uDE60-\uDE7E]|\uD804[\uDC52-\uDC6F\uDCF0-\uDCF9\uDD36-\uDD3F\uDDD0-\uDDD9\uDDE1-\uDDF4\uDEF0-\uDEF9]|\uD805[\uDC50-\uDC59\uDCD0-\uDCD9\uDE50-\uDE59\uDEC0-\uDEC9\uDF30-\uDF3B]|\uD806[\uDCE0-\uDCF2]|\uD807[\uDC50-\uDC6C]|\uD809[\uDC00-\uDC6E]|\uD81A[\uDE60-\uDE69\uDF50-\uDF59\uDF5B-\uDF61]|\uD834[\uDF60-\uDF71]|\uD835[\uDFCE-\uDFFF]|\uD83A[\uDCC7-\uDCCF\uDD50-\uDD59]|\uD83C[\uDD00-\uDD0C]"},{name:"Nd",alias:"Decimal_Number",bmp:"0-9\u0660-\u0669\u06F0-\u06F9\u07C0-\u07C9\u0966-\u096F\u09E6-\u09EF\u0A66-\u0A6F\u0AE6-\u0AEF\u0B66-\u0B6F\u0BE6-\u0BEF\u0C66-\u0C6F\u0CE6-\u0CEF\u0D66-\u0D6F\u0DE6-\u0DEF\u0E50-\u0E59\u0ED0-\u0ED9\u0F20-\u0F29\u1040-\u1049\u1090-\u1099\u17E0-\u17E9\u1810-\u1819\u1946-\u194F\u19D0-\u19D9\u1A80-\u1A89\u1A90-\u1A99\u1B50-\u1B59\u1BB0-\u1BB9\u1C40-\u1C49\u1C50-\u1C59\uA620-\uA629\uA8D0-\uA8D9\uA900-\uA909\uA9D0-\uA9D9\uA9F0-\uA9F9\uAA50-\uAA59\uABF0-\uABF9\uFF10-\uFF19",astral:"\uD801[\uDCA0-\uDCA9]|\uD804[\uDC66-\uDC6F\uDCF0-\uDCF9\uDD36-\uDD3F\uDDD0-\uDDD9\uDEF0-\uDEF9]|\uD805[\uDC50-\uDC59\uDCD0-\uDCD9\uDE50-\uDE59\uDEC0-\uDEC9\uDF30-\uDF39]|\uD806[\uDCE0-\uDCE9]|\uD807[\uDC50-\uDC59]|\uD81A[\uDE60-\uDE69\uDF50-\uDF59]|\uD835[\uDFCE-\uDFFF]|\uD83A[\uDD50-\uDD59]"},{name:"Nl",alias:"Letter_Number",bmp:"\u16EE-\u16F0\u2160-\u2182\u2185-\u2188\u3007\u3021-\u3029\u3038-\u303A\uA6E6-\uA6EF",astral:"\uD800[\uDD40-\uDD74\uDF41\uDF4A\uDFD1-\uDFD5]|\uD809[\uDC00-\uDC6E]"},{name:"No",alias:"Other_Number",bmp:"\xB2\xB3\xB9\xBC-\xBE\u09F4-\u09F9\u0B72-\u0B77\u0BF0-\u0BF2\u0C78-\u0C7E\u0D58-\u0D5E\u0D70-\u0D78\u0F2A-\u0F33\u1369-\u137C\u17F0-\u17F9\u19DA\u2070\u2074-\u2079\u2080-\u2089\u2150-\u215F\u2189\u2460-\u249B\u24EA-\u24FF\u2776-\u2793\u2CFD\u3192-\u3195\u3220-\u3229\u3248-\u324F\u3251-\u325F\u3280-\u3289\u32B1-\u32BF\uA830-\uA835",astral:"\uD800[\uDD07-\uDD33\uDD75-\uDD78\uDD8A\uDD8B\uDEE1-\uDEFB\uDF20-\uDF23]|\uD802[\uDC58-\uDC5F\uDC79-\uDC7F\uDCA7-\uDCAF\uDCFB-\uDCFF\uDD16-\uDD1B\uDDBC\uDDBD\uDDC0-\uDDCF\uDDD2-\uDDFF\uDE40-\uDE47\uDE7D\uDE7E\uDE9D-\uDE9F\uDEEB-\uDEEF\uDF58-\uDF5F\uDF78-\uDF7F\uDFA9-\uDFAF]|\uD803[\uDCFA-\uDCFF\uDE60-\uDE7E]|\uD804[\uDC52-\uDC65\uDDE1-\uDDF4]|\uD805[\uDF3A\uDF3B]|\uD806[\uDCEA-\uDCF2]|\uD807[\uDC5A-\uDC6C]|\uD81A[\uDF5B-\uDF61]|\uD834[\uDF60-\uDF71]|\uD83A[\uDCC7-\uDCCF]|\uD83C[\uDD00-\uDD0C]"},{name:"P",alias:"Punctuation",bmp:"!-#%-\\x2A,-/:;\\x3F@\\x5B-\\x5D_\\x7B}\xA1\xA7\xAB\xB6\xB7\xBB\xBF\u037E\u0387\u055A-\u055F\u0589\u058A\u05BE\u05C0\u05C3\u05C6\u05F3\u05F4\u0609\u060A\u060C\u060D\u061B\u061E\u061F\u066A-\u066D\u06D4\u0700-\u070D\u07F7-\u07F9\u0830-\u083E\u085E\u0964\u0965\u0970\u0AF0\u0DF4\u0E4F\u0E5A\u0E5B\u0F04-\u0F12\u0F14\u0F3A-\u0F3D\u0F85\u0FD0-\u0FD4\u0FD9\u0FDA\u104A-\u104F\u10FB\u1360-\u1368\u1400\u166D\u166E\u169B\u169C\u16EB-\u16ED\u1735\u1736\u17D4-\u17D6\u17D8-\u17DA\u1800-\u180A\u1944\u1945\u1A1E\u1A1F\u1AA0-\u1AA6\u1AA8-\u1AAD\u1B5A-\u1B60\u1BFC-\u1BFF\u1C3B-\u1C3F\u1C7E\u1C7F\u1CC0-\u1CC7\u1CD3\u2010-\u2027\u2030-\u2043\u2045-\u2051\u2053-\u205E\u207D\u207E\u208D\u208E\u2308-\u230B\u2329\u232A\u2768-\u2775\u27C5\u27C6\u27E6-\u27EF\u2983-\u2998\u29D8-\u29DB\u29FC\u29FD\u2CF9-\u2CFC\u2CFE\u2CFF\u2D70\u2E00-\u2E2E\u2E30-\u2E44\u3001-\u3003\u3008-\u3011\u3014-\u301F\u3030\u303D\u30A0\u30FB\uA4FE\uA4FF\uA60D-\uA60F\uA673\uA67E\uA6F2-\uA6F7\uA874-\uA877\uA8CE\uA8CF\uA8F8-\uA8FA\uA8FC\uA92E\uA92F\uA95F\uA9C1-\uA9CD\uA9DE\uA9DF\uAA5C-\uAA5F\uAADE\uAADF\uAAF0\uAAF1\uABEB\uFD3E\uFD3F\uFE10-\uFE19\uFE30-\uFE52\uFE54-\uFE61\uFE63\uFE68\uFE6A\uFE6B\uFF01-\uFF03\uFF05-\uFF0A\uFF0C-\uFF0F\uFF1A\uFF1B\uFF1F\uFF20\uFF3B-\uFF3D\uFF3F\uFF5B\uFF5D\uFF5F-\uFF65",astral:"\uD800[\uDD00-\uDD02\uDF9F\uDFD0]|\u{1056F}|\uD802[\uDC57\uDD1F\uDD3F\uDE50-\uDE58\uDE7F\uDEF0-\uDEF6\uDF39-\uDF3F\uDF99-\uDF9C]|\uD804[\uDC47-\uDC4D\uDCBB\uDCBC\uDCBE-\uDCC1\uDD40-\uDD43\uDD74\uDD75\uDDC5-\uDDC9\uDDCD\uDDDB\uDDDD-\uDDDF\uDE38-\uDE3D\uDEA9]|\uD805[\uDC4B-\uDC4F\uDC5B\uDC5D\uDCC6\uDDC1-\uDDD7\uDE41-\uDE43\uDE60-\uDE6C\uDF3C-\uDF3E]|\uD807[\uDC41-\uDC45\uDC70\uDC71]|\uD809[\uDC70-\uDC74]|\uD81A[\uDE6E\uDE6F\uDEF5\uDF37-\uDF3B\uDF44]|\u{1BC9F}|\uD836[\uDE87-\uDE8B]|\uD83A[\uDD5E\uDD5F]"},{name:"Pc",alias:"Connector_Punctuation",bmp:"_\u203F\u2040\u2054\uFE33\uFE34\uFE4D-\uFE4F\uFF3F"},{name:"Pd",alias:"Dash_Punctuation",bmp:"\\x2D\u058A\u05BE\u1400\u1806\u2010-\u2015\u2E17\u2E1A\u2E3A\u2E3B\u2E40\u301C\u3030\u30A0\uFE31\uFE32\uFE58\uFE63\uFF0D"},{name:"Pe",alias:"Close_Punctuation",bmp:"\\x29\\x5D}\u0F3B\u0F3D\u169C\u2046\u207E\u208E\u2309\u230B\u232A\u2769\u276B\u276D\u276F\u2771\u2773\u2775\u27C6\u27E7\u27E9\u27EB\u27ED\u27EF\u2984\u2986\u2988\u298A\u298C\u298E\u2990\u2992\u2994\u2996\u2998\u29D9\u29DB\u29FD\u2E23\u2E25\u2E27\u2E29\u3009\u300B\u300D\u300F\u3011\u3015\u3017\u3019\u301B\u301E\u301F\uFD3E\uFE18\uFE36\uFE38\uFE3A\uFE3C\uFE3E\uFE40\uFE42\uFE44\uFE48\uFE5A\uFE5C\uFE5E\uFF09\uFF3D\uFF5D\uFF60\uFF63"},{name:"Pf",alias:"Final_Punctuation",bmp:"\xBB\u2019\u201D\u203A\u2E03\u2E05\u2E0A\u2E0D\u2E1D\u2E21"},{name:"Pi",alias:"Initial_Punctuation",bmp:"\xAB\u2018\u201B\u201C\u201F\u2039\u2E02\u2E04\u2E09\u2E0C\u2E1C\u2E20"},{name:"Po",alias:"Other_Punctuation",bmp:"!-#%-'\\x2A,\\x2E/:;\\x3F@\\x5C\xA1\xA7\xB6\xB7\xBF\u037E\u0387\u055A-\u055F\u0589\u05C0\u05C3\u05C6\u05F3\u05F4\u0609\u060A\u060C\u060D\u061B\u061E\u061F\u066A-\u066D\u06D4\u0700-\u070D\u07F7-\u07F9\u0830-\u083E\u085E\u0964\u0965\u0970\u0AF0\u0DF4\u0E4F\u0E5A\u0E5B\u0F04-\u0F12\u0F14\u0F85\u0FD0-\u0FD4\u0FD9\u0FDA\u104A-\u104F\u10FB\u1360-\u1368\u166D\u166E\u16EB-\u16ED\u1735\u1736\u17D4-\u17D6\u17D8-\u17DA\u1800-\u1805\u1807-\u180A\u1944\u1945\u1A1E\u1A1F\u1AA0-\u1AA6\u1AA8-\u1AAD\u1B5A-\u1B60\u1BFC-\u1BFF\u1C3B-\u1C3F\u1C7E\u1C7F\u1CC0-\u1CC7\u1CD3\u2016\u2017\u2020-\u2027\u2030-\u2038\u203B-\u203E\u2041-\u2043\u2047-\u2051\u2053\u2055-\u205E\u2CF9-\u2CFC\u2CFE\u2CFF\u2D70\u2E00\u2E01\u2E06-\u2E08\u2E0B\u2E0E-\u2E16\u2E18\u2E19\u2E1B\u2E1E\u2E1F\u2E2A-\u2E2E\u2E30-\u2E39\u2E3C-\u2E3F\u2E41\u2E43\u2E44\u3001-\u3003\u303D\u30FB\uA4FE\uA4FF\uA60D-\uA60F\uA673\uA67E\uA6F2-\uA6F7\uA874-\uA877\uA8CE\uA8CF\uA8F8-\uA8FA\uA8FC\uA92E\uA92F\uA95F\uA9C1-\uA9CD\uA9DE\uA9DF\uAA5C-\uAA5F\uAADE\uAADF\uAAF0\uAAF1\uABEB\uFE10-\uFE16\uFE19\uFE30\uFE45\uFE46\uFE49-\uFE4C\uFE50-\uFE52\uFE54-\uFE57\uFE5F-\uFE61\uFE68\uFE6A\uFE6B\uFF01-\uFF03\uFF05-\uFF07\uFF0A\uFF0C\uFF0E\uFF0F\uFF1A\uFF1B\uFF1F\uFF20\uFF3C\uFF61\uFF64\uFF65",astral:"\uD800[\uDD00-\uDD02\uDF9F\uDFD0]|\u{1056F}|\uD802[\uDC57\uDD1F\uDD3F\uDE50-\uDE58\uDE7F\uDEF0-\uDEF6\uDF39-\uDF3F\uDF99-\uDF9C]|\uD804[\uDC47-\uDC4D\uDCBB\uDCBC\uDCBE-\uDCC1\uDD40-\uDD43\uDD74\uDD75\uDDC5-\uDDC9\uDDCD\uDDDB\uDDDD-\uDDDF\uDE38-\uDE3D\uDEA9]|\uD805[\uDC4B-\uDC4F\uDC5B\uDC5D\uDCC6\uDDC1-\uDDD7\uDE41-\uDE43\uDE60-\uDE6C\uDF3C-\uDF3E]|\uD807[\uDC41-\uDC45\uDC70\uDC71]|\uD809[\uDC70-\uDC74]|\uD81A[\uDE6E\uDE6F\uDEF5\uDF37-\uDF3B\uDF44]|\u{1BC9F}|\uD836[\uDE87-\uDE8B]|\uD83A[\uDD5E\uDD5F]"},{name:"Ps",alias:"Open_Punctuation",bmp:"\\x28\\x5B\\x7B\u0F3A\u0F3C\u169B\u201A\u201E\u2045\u207D\u208D\u2308\u230A\u2329\u2768\u276A\u276C\u276E\u2770\u2772\u2774\u27C5\u27E6\u27E8\u27EA\u27EC\u27EE\u2983\u2985\u2987\u2989\u298B\u298D\u298F\u2991\u2993\u2995\u2997\u29D8\u29DA\u29FC\u2E22\u2E24\u2E26\u2E28\u2E42\u3008\u300A\u300C\u300E\u3010\u3014\u3016\u3018\u301A\u301D\uFD3F\uFE17\uFE35\uFE37\uFE39\uFE3B\uFE3D\uFE3F\uFE41\uFE43\uFE47\uFE59\uFE5B\uFE5D\uFF08\uFF3B\uFF5B\uFF5F\uFF62"},{name:"S",alias:"Symbol",bmp:"\\x24\\x2B<->\\x5E`\\x7C~\xA2-\xA6\xA8\xA9\xAC\xAE-\xB1\xB4\xB8\xD7\xF7\u02C2-\u02C5\u02D2-\u02DF\u02E5-\u02EB\u02ED\u02EF-\u02FF\u0375\u0384\u0385\u03F6\u0482\u058D-\u058F\u0606-\u0608\u060B\u060E\u060F\u06DE\u06E9\u06FD\u06FE\u07F6\u09F2\u09F3\u09FA\u09FB\u0AF1\u0B70\u0BF3-\u0BFA\u0C7F\u0D4F\u0D79\u0E3F\u0F01-\u0F03\u0F13\u0F15-\u0F17\u0F1A-\u0F1F\u0F34\u0F36\u0F38\u0FBE-\u0FC5\u0FC7-\u0FCC\u0FCE\u0FCF\u0FD5-\u0FD8\u109E\u109F\u1390-\u1399\u17DB\u1940\u19DE-\u19FF\u1B61-\u1B6A\u1B74-\u1B7C\u1FBD\u1FBF-\u1FC1\u1FCD-\u1FCF\u1FDD-\u1FDF\u1FED-\u1FEF\u1FFD\u1FFE\u2044\u2052\u207A-\u207C\u208A-\u208C\u20A0-\u20BE\u2100\u2101\u2103-\u2106\u2108\u2109\u2114\u2116-\u2118\u211E-\u2123\u2125\u2127\u2129\u212E\u213A\u213B\u2140-\u2144\u214A-\u214D\u214F\u218A\u218B\u2190-\u2307\u230C-\u2328\u232B-\u23FE\u2400-\u2426\u2440-\u244A\u249C-\u24E9\u2500-\u2767\u2794-\u27C4\u27C7-\u27E5\u27F0-\u2982\u2999-\u29D7\u29DC-\u29FB\u29FE-\u2B73\u2B76-\u2B95\u2B98-\u2BB9\u2BBD-\u2BC8\u2BCA-\u2BD1\u2BEC-\u2BEF\u2CE5-\u2CEA\u2E80-\u2E99\u2E9B-\u2EF3\u2F00-\u2FD5\u2FF0-\u2FFB\u3004\u3012\u3013\u3020\u3036\u3037\u303E\u303F\u309B\u309C\u3190\u3191\u3196-\u319F\u31C0-\u31E3\u3200-\u321E\u322A-\u3247\u3250\u3260-\u327F\u328A-\u32B0\u32C0-\u32FE\u3300-\u33FF\u4DC0-\u4DFF\uA490-\uA4C6\uA700-\uA716\uA720\uA721\uA789\uA78A\uA828-\uA82B\uA836-\uA839\uAA77-\uAA79\uAB5B\uFB29\uFBB2-\uFBC1\uFDFC\uFDFD\uFE62\uFE64-\uFE66\uFE69\uFF04\uFF0B\uFF1C-\uFF1E\uFF3E\uFF40\uFF5C\uFF5E\uFFE0-\uFFE6\uFFE8-\uFFEE\uFFFC\uFFFD",astral:"\uD800[\uDD37-\uDD3F\uDD79-\uDD89\uDD8C-\uDD8E\uDD90-\uDD9B\uDDA0\uDDD0-\uDDFC]|\uD802[\uDC77\uDC78\uDEC8]|\u{1173F}|\uD81A[\uDF3C-\uDF3F\uDF45]|\u{1BC9C}|\uD834[\uDC00-\uDCF5\uDD00-\uDD26\uDD29-\uDD64\uDD6A-\uDD6C\uDD83\uDD84\uDD8C-\uDDA9\uDDAE-\uDDE8\uDE00-\uDE41\uDE45\uDF00-\uDF56]|\uD835[\uDEC1\uDEDB\uDEFB\uDF15\uDF35\uDF4F\uDF6F\uDF89\uDFA9\uDFC3]|\uD836[\uDC00-\uDDFF\uDE37-\uDE3A\uDE6D-\uDE74\uDE76-\uDE83\uDE85\uDE86]|\uD83B[\uDEF0\uDEF1]|\uD83C[\uDC00-\uDC2B\uDC30-\uDC93\uDCA0-\uDCAE\uDCB1-\uDCBF\uDCC1-\uDCCF\uDCD1-\uDCF5\uDD10-\uDD2E\uDD30-\uDD6B\uDD70-\uDDAC\uDDE6-\uDE02\uDE10-\uDE3B\uDE40-\uDE48\uDE50\uDE51\uDF00-\uDFFF]|\uD83D[\uDC00-\uDED2\uDEE0-\uDEEC\uDEF0-\uDEF6\uDF00-\uDF73\uDF80-\uDFD4]|\uD83E[\uDC00-\uDC0B\uDC10-\uDC47\uDC50-\uDC59\uDC60-\uDC87\uDC90-\uDCAD\uDD10-\uDD1E\uDD20-\uDD27\uDD30\uDD33-\uDD3E\uDD40-\uDD4B\uDD50-\uDD5E\uDD80-\uDD91\uDDC0]"},{name:"Sc",alias:"Currency_Symbol",bmp:"\\x24\xA2-\xA5\u058F\u060B\u09F2\u09F3\u09FB\u0AF1\u0BF9\u0E3F\u17DB\u20A0-\u20BE\uA838\uFDFC\uFE69\uFF04\uFFE0\uFFE1\uFFE5\uFFE6"},{name:"Sk",alias:"Modifier_Symbol",bmp:"\\x5E`\xA8\xAF\xB4\xB8\u02C2-\u02C5\u02D2-\u02DF\u02E5-\u02EB\u02ED\u02EF-\u02FF\u0375\u0384\u0385\u1FBD\u1FBF-\u1FC1\u1FCD-\u1FCF\u1FDD-\u1FDF\u1FED-\u1FEF\u1FFD\u1FFE\u309B\u309C\uA700-\uA716\uA720\uA721\uA789\uA78A\uAB5B\uFBB2-\uFBC1\uFF3E\uFF40\uFFE3",astral:"\uD83C[\uDFFB-\uDFFF]"},{name:"Sm",alias:"Math_Symbol",bmp:"\\x2B<->\\x7C~\xAC\xB1\xD7\xF7\u03F6\u0606-\u0608\u2044\u2052\u207A-\u207C\u208A-\u208C\u2118\u2140-\u2144\u214B\u2190-\u2194\u219A\u219B\u21A0\u21A3\u21A6\u21AE\u21CE\u21CF\u21D2\u21D4\u21F4-\u22FF\u2320\u2321\u237C\u239B-\u23B3\u23DC-\u23E1\u25B7\u25C1\u25F8-\u25FF\u266F\u27C0-\u27C4\u27C7-\u27E5\u27F0-\u27FF\u2900-\u2982\u2999-\u29D7\u29DC-\u29FB\u29FE-\u2AFF\u2B30-\u2B44\u2B47-\u2B4C\uFB29\uFE62\uFE64-\uFE66\uFF0B\uFF1C-\uFF1E\uFF5C\uFF5E\uFFE2\uFFE9-\uFFEC",astral:"\uD835[\uDEC1\uDEDB\uDEFB\uDF15\uDF35\uDF4F\uDF6F\uDF89\uDFA9\uDFC3]|\uD83B[\uDEF0\uDEF1]"},{name:"So",alias:"Other_Symbol",bmp:"\xA6\xA9\xAE\xB0\u0482\u058D\u058E\u060E\u060F\u06DE\u06E9\u06FD\u06FE\u07F6\u09FA\u0B70\u0BF3-\u0BF8\u0BFA\u0C7F\u0D4F\u0D79\u0F01-\u0F03\u0F13\u0F15-\u0F17\u0F1A-\u0F1F\u0F34\u0F36\u0F38\u0FBE-\u0FC5\u0FC7-\u0FCC\u0FCE\u0FCF\u0FD5-\u0FD8\u109E\u109F\u1390-\u1399\u1940\u19DE-\u19FF\u1B61-\u1B6A\u1B74-\u1B7C\u2100\u2101\u2103-\u2106\u2108\u2109\u2114\u2116\u2117\u211E-\u2123\u2125\u2127\u2129\u212E\u213A\u213B\u214A\u214C\u214D\u214F\u218A\u218B\u2195-\u2199\u219C-\u219F\u21A1\u21A2\u21A4\u21A5\u21A7-\u21AD\u21AF-\u21CD\u21D0\u21D1\u21D3\u21D5-\u21F3\u2300-\u2307\u230C-\u231F\u2322-\u2328\u232B-\u237B\u237D-\u239A\u23B4-\u23DB\u23E2-\u23FE\u2400-\u2426\u2440-\u244A\u249C-\u24E9\u2500-\u25B6\u25B8-\u25C0\u25C2-\u25F7\u2600-\u266E\u2670-\u2767\u2794-\u27BF\u2800-\u28FF\u2B00-\u2B2F\u2B45\u2B46\u2B4D-\u2B73\u2B76-\u2B95\u2B98-\u2BB9\u2BBD-\u2BC8\u2BCA-\u2BD1\u2BEC-\u2BEF\u2CE5-\u2CEA\u2E80-\u2E99\u2E9B-\u2EF3\u2F00-\u2FD5\u2FF0-\u2FFB\u3004\u3012\u3013\u3020\u3036\u3037\u303E\u303F\u3190\u3191\u3196-\u319F\u31C0-\u31E3\u3200-\u321E\u322A-\u3247\u3250\u3260-\u327F\u328A-\u32B0\u32C0-\u32FE\u3300-\u33FF\u4DC0-\u4DFF\uA490-\uA4C6\uA828-\uA82B\uA836\uA837\uA839\uAA77-\uAA79\uFDFD\uFFE4\uFFE8\uFFED\uFFEE\uFFFC\uFFFD",astral:"\uD800[\uDD37-\uDD3F\uDD79-\uDD89\uDD8C-\uDD8E\uDD90-\uDD9B\uDDA0\uDDD0-\uDDFC]|\uD802[\uDC77\uDC78\uDEC8]|\u{1173F}|\uD81A[\uDF3C-\uDF3F\uDF45]|\u{1BC9C}|\uD834[\uDC00-\uDCF5\uDD00-\uDD26\uDD29-\uDD64\uDD6A-\uDD6C\uDD83\uDD84\uDD8C-\uDDA9\uDDAE-\uDDE8\uDE00-\uDE41\uDE45\uDF00-\uDF56]|\uD836[\uDC00-\uDDFF\uDE37-\uDE3A\uDE6D-\uDE74\uDE76-\uDE83\uDE85\uDE86]|\uD83C[\uDC00-\uDC2B\uDC30-\uDC93\uDCA0-\uDCAE\uDCB1-\uDCBF\uDCC1-\uDCCF\uDCD1-\uDCF5\uDD10-\uDD2E\uDD30-\uDD6B\uDD70-\uDDAC\uDDE6-\uDE02\uDE10-\uDE3B\uDE40-\uDE48\uDE50\uDE51\uDF00-\uDFFA]|\uD83D[\uDC00-\uDED2\uDEE0-\uDEEC\uDEF0-\uDEF6\uDF00-\uDF73\uDF80-\uDFD4]|\uD83E[\uDC00-\uDC0B\uDC10-\uDC47\uDC50-\uDC59\uDC60-\uDC87\uDC90-\uDCAD\uDD10-\uDD1E\uDD20-\uDD27\uDD30\uDD33-\uDD3E\uDD40-\uDD4B\uDD50-\uDD5E\uDD80-\uDD91\uDDC0]"},{name:"Z",alias:"Separator",bmp:" \xA0\u1680\u2000-\u200A\u2028\u2029\u202F\u205F\u3000"},{name:"Zl",alias:"Line_Separator",bmp:"\u2028"},{name:"Zp",alias:"Paragraph_Separator",bmp:"\u2029"},{name:"Zs",alias:"Space_Separator",bmp:" \xA0\u1680\u2000-\u200A\u202F\u205F\u3000"}])}},{}],6:[function(R,a,G){/*!
 * XRegExp Unicode Properties 3.2.0
 * <xregexp.com>
 * Steven Levithan (c) 2012-2017 MIT License
 * Unicode data by Mathias Bynens <mathiasbynens.be>
 */a.exports=function(b){"use strict";if(!b.addUnicodeData)throw new ReferenceError("Unicode Base must be loaded before Unicode Properties");var K=[{name:"ASCII",bmp:"\0-\x7F"},{name:"Alphabetic",bmp:"A-Za-z\xAA\xB5\xBA\xC0-\xD6\xD8-\xF6\xF8-\u02C1\u02C6-\u02D1\u02E0-\u02E4\u02EC\u02EE\u0345\u0370-\u0374\u0376\u0377\u037A-\u037D\u037F\u0386\u0388-\u038A\u038C\u038E-\u03A1\u03A3-\u03F5\u03F7-\u0481\u048A-\u052F\u0531-\u0556\u0559\u0561-\u0587\u05B0-\u05BD\u05BF\u05C1\u05C2\u05C4\u05C5\u05C7\u05D0-\u05EA\u05F0-\u05F2\u0610-\u061A\u0620-\u0657\u0659-\u065F\u066E-\u06D3\u06D5-\u06DC\u06E1-\u06E8\u06ED-\u06EF\u06FA-\u06FC\u06FF\u0710-\u073F\u074D-\u07B1\u07CA-\u07EA\u07F4\u07F5\u07FA\u0800-\u0817\u081A-\u082C\u0840-\u0858\u08A0-\u08B4\u08B6-\u08BD\u08D4-\u08DF\u08E3-\u08E9\u08F0-\u093B\u093D-\u094C\u094E-\u0950\u0955-\u0963\u0971-\u0983\u0985-\u098C\u098F\u0990\u0993-\u09A8\u09AA-\u09B0\u09B2\u09B6-\u09B9\u09BD-\u09C4\u09C7\u09C8\u09CB\u09CC\u09CE\u09D7\u09DC\u09DD\u09DF-\u09E3\u09F0\u09F1\u0A01-\u0A03\u0A05-\u0A0A\u0A0F\u0A10\u0A13-\u0A28\u0A2A-\u0A30\u0A32\u0A33\u0A35\u0A36\u0A38\u0A39\u0A3E-\u0A42\u0A47\u0A48\u0A4B\u0A4C\u0A51\u0A59-\u0A5C\u0A5E\u0A70-\u0A75\u0A81-\u0A83\u0A85-\u0A8D\u0A8F-\u0A91\u0A93-\u0AA8\u0AAA-\u0AB0\u0AB2\u0AB3\u0AB5-\u0AB9\u0ABD-\u0AC5\u0AC7-\u0AC9\u0ACB\u0ACC\u0AD0\u0AE0-\u0AE3\u0AF9\u0B01-\u0B03\u0B05-\u0B0C\u0B0F\u0B10\u0B13-\u0B28\u0B2A-\u0B30\u0B32\u0B33\u0B35-\u0B39\u0B3D-\u0B44\u0B47\u0B48\u0B4B\u0B4C\u0B56\u0B57\u0B5C\u0B5D\u0B5F-\u0B63\u0B71\u0B82\u0B83\u0B85-\u0B8A\u0B8E-\u0B90\u0B92-\u0B95\u0B99\u0B9A\u0B9C\u0B9E\u0B9F\u0BA3\u0BA4\u0BA8-\u0BAA\u0BAE-\u0BB9\u0BBE-\u0BC2\u0BC6-\u0BC8\u0BCA-\u0BCC\u0BD0\u0BD7\u0C00-\u0C03\u0C05-\u0C0C\u0C0E-\u0C10\u0C12-\u0C28\u0C2A-\u0C39\u0C3D-\u0C44\u0C46-\u0C48\u0C4A-\u0C4C\u0C55\u0C56\u0C58-\u0C5A\u0C60-\u0C63\u0C80-\u0C83\u0C85-\u0C8C\u0C8E-\u0C90\u0C92-\u0CA8\u0CAA-\u0CB3\u0CB5-\u0CB9\u0CBD-\u0CC4\u0CC6-\u0CC8\u0CCA-\u0CCC\u0CD5\u0CD6\u0CDE\u0CE0-\u0CE3\u0CF1\u0CF2\u0D01-\u0D03\u0D05-\u0D0C\u0D0E-\u0D10\u0D12-\u0D3A\u0D3D-\u0D44\u0D46-\u0D48\u0D4A-\u0D4C\u0D4E\u0D54-\u0D57\u0D5F-\u0D63\u0D7A-\u0D7F\u0D82\u0D83\u0D85-\u0D96\u0D9A-\u0DB1\u0DB3-\u0DBB\u0DBD\u0DC0-\u0DC6\u0DCF-\u0DD4\u0DD6\u0DD8-\u0DDF\u0DF2\u0DF3\u0E01-\u0E3A\u0E40-\u0E46\u0E4D\u0E81\u0E82\u0E84\u0E87\u0E88\u0E8A\u0E8D\u0E94-\u0E97\u0E99-\u0E9F\u0EA1-\u0EA3\u0EA5\u0EA7\u0EAA\u0EAB\u0EAD-\u0EB9\u0EBB-\u0EBD\u0EC0-\u0EC4\u0EC6\u0ECD\u0EDC-\u0EDF\u0F00\u0F40-\u0F47\u0F49-\u0F6C\u0F71-\u0F81\u0F88-\u0F97\u0F99-\u0FBC\u1000-\u1036\u1038\u103B-\u103F\u1050-\u1062\u1065-\u1068\u106E-\u1086\u108E\u109C\u109D\u10A0-\u10C5\u10C7\u10CD\u10D0-\u10FA\u10FC-\u1248\u124A-\u124D\u1250-\u1256\u1258\u125A-\u125D\u1260-\u1288\u128A-\u128D\u1290-\u12B0\u12B2-\u12B5\u12B8-\u12BE\u12C0\u12C2-\u12C5\u12C8-\u12D6\u12D8-\u1310\u1312-\u1315\u1318-\u135A\u135F\u1380-\u138F\u13A0-\u13F5\u13F8-\u13FD\u1401-\u166C\u166F-\u167F\u1681-\u169A\u16A0-\u16EA\u16EE-\u16F8\u1700-\u170C\u170E-\u1713\u1720-\u1733\u1740-\u1753\u1760-\u176C\u176E-\u1770\u1772\u1773\u1780-\u17B3\u17B6-\u17C8\u17D7\u17DC\u1820-\u1877\u1880-\u18AA\u18B0-\u18F5\u1900-\u191E\u1920-\u192B\u1930-\u1938\u1950-\u196D\u1970-\u1974\u1980-\u19AB\u19B0-\u19C9\u1A00-\u1A1B\u1A20-\u1A5E\u1A61-\u1A74\u1AA7\u1B00-\u1B33\u1B35-\u1B43\u1B45-\u1B4B\u1B80-\u1BA9\u1BAC-\u1BAF\u1BBA-\u1BE5\u1BE7-\u1BF1\u1C00-\u1C35\u1C4D-\u1C4F\u1C5A-\u1C7D\u1C80-\u1C88\u1CE9-\u1CEC\u1CEE-\u1CF3\u1CF5\u1CF6\u1D00-\u1DBF\u1DE7-\u1DF4\u1E00-\u1F15\u1F18-\u1F1D\u1F20-\u1F45\u1F48-\u1F4D\u1F50-\u1F57\u1F59\u1F5B\u1F5D\u1F5F-\u1F7D\u1F80-\u1FB4\u1FB6-\u1FBC\u1FBE\u1FC2-\u1FC4\u1FC6-\u1FCC\u1FD0-\u1FD3\u1FD6-\u1FDB\u1FE0-\u1FEC\u1FF2-\u1FF4\u1FF6-\u1FFC\u2071\u207F\u2090-\u209C\u2102\u2107\u210A-\u2113\u2115\u2119-\u211D\u2124\u2126\u2128\u212A-\u212D\u212F-\u2139\u213C-\u213F\u2145-\u2149\u214E\u2160-\u2188\u24B6-\u24E9\u2C00-\u2C2E\u2C30-\u2C5E\u2C60-\u2CE4\u2CEB-\u2CEE\u2CF2\u2CF3\u2D00-\u2D25\u2D27\u2D2D\u2D30-\u2D67\u2D6F\u2D80-\u2D96\u2DA0-\u2DA6\u2DA8-\u2DAE\u2DB0-\u2DB6\u2DB8-\u2DBE\u2DC0-\u2DC6\u2DC8-\u2DCE\u2DD0-\u2DD6\u2DD8-\u2DDE\u2DE0-\u2DFF\u2E2F\u3005-\u3007\u3021-\u3029\u3031-\u3035\u3038-\u303C\u3041-\u3096\u309D-\u309F\u30A1-\u30FA\u30FC-\u30FF\u3105-\u312D\u3131-\u318E\u31A0-\u31BA\u31F0-\u31FF\u3400-\u4DB5\u4E00-\u9FD5\uA000-\uA48C\uA4D0-\uA4FD\uA500-\uA60C\uA610-\uA61F\uA62A\uA62B\uA640-\uA66E\uA674-\uA67B\uA67F-\uA6EF\uA717-\uA71F\uA722-\uA788\uA78B-\uA7AE\uA7B0-\uA7B7\uA7F7-\uA801\uA803-\uA805\uA807-\uA80A\uA80C-\uA827\uA840-\uA873\uA880-\uA8C3\uA8C5\uA8F2-\uA8F7\uA8FB\uA8FD\uA90A-\uA92A\uA930-\uA952\uA960-\uA97C\uA980-\uA9B2\uA9B4-\uA9BF\uA9CF\uA9E0-\uA9E4\uA9E6-\uA9EF\uA9FA-\uA9FE\uAA00-\uAA36\uAA40-\uAA4D\uAA60-\uAA76\uAA7A\uAA7E-\uAABE\uAAC0\uAAC2\uAADB-\uAADD\uAAE0-\uAAEF\uAAF2-\uAAF5\uAB01-\uAB06\uAB09-\uAB0E\uAB11-\uAB16\uAB20-\uAB26\uAB28-\uAB2E\uAB30-\uAB5A\uAB5C-\uAB65\uAB70-\uABEA\uAC00-\uD7A3\uD7B0-\uD7C6\uD7CB-\uD7FB\uF900-\uFA6D\uFA70-\uFAD9\uFB00-\uFB06\uFB13-\uFB17\uFB1D-\uFB28\uFB2A-\uFB36\uFB38-\uFB3C\uFB3E\uFB40\uFB41\uFB43\uFB44\uFB46-\uFBB1\uFBD3-\uFD3D\uFD50-\uFD8F\uFD92-\uFDC7\uFDF0-\uFDFB\uFE70-\uFE74\uFE76-\uFEFC\uFF21-\uFF3A\uFF41-\uFF5A\uFF66-\uFFBE\uFFC2-\uFFC7\uFFCA-\uFFCF\uFFD2-\uFFD7\uFFDA-\uFFDC",astral:"\uD800[\uDC00-\uDC0B\uDC0D-\uDC26\uDC28-\uDC3A\uDC3C\uDC3D\uDC3F-\uDC4D\uDC50-\uDC5D\uDC80-\uDCFA\uDD40-\uDD74\uDE80-\uDE9C\uDEA0-\uDED0\uDF00-\uDF1F\uDF30-\uDF4A\uDF50-\uDF7A\uDF80-\uDF9D\uDFA0-\uDFC3\uDFC8-\uDFCF\uDFD1-\uDFD5]|\uD801[\uDC00-\uDC9D\uDCB0-\uDCD3\uDCD8-\uDCFB\uDD00-\uDD27\uDD30-\uDD63\uDE00-\uDF36\uDF40-\uDF55\uDF60-\uDF67]|\uD802[\uDC00-\uDC05\uDC08\uDC0A-\uDC35\uDC37\uDC38\uDC3C\uDC3F-\uDC55\uDC60-\uDC76\uDC80-\uDC9E\uDCE0-\uDCF2\uDCF4\uDCF5\uDD00-\uDD15\uDD20-\uDD39\uDD80-\uDDB7\uDDBE\uDDBF\uDE00-\uDE03\uDE05\uDE06\uDE0C-\uDE13\uDE15-\uDE17\uDE19-\uDE33\uDE60-\uDE7C\uDE80-\uDE9C\uDEC0-\uDEC7\uDEC9-\uDEE4\uDF00-\uDF35\uDF40-\uDF55\uDF60-\uDF72\uDF80-\uDF91]|\uD803[\uDC00-\uDC48\uDC80-\uDCB2\uDCC0-\uDCF2]|\uD804[\uDC00-\uDC45\uDC82-\uDCB8\uDCD0-\uDCE8\uDD00-\uDD32\uDD50-\uDD72\uDD76\uDD80-\uDDBF\uDDC1-\uDDC4\uDDDA\uDDDC\uDE00-\uDE11\uDE13-\uDE34\uDE37\uDE3E\uDE80-\uDE86\uDE88\uDE8A-\uDE8D\uDE8F-\uDE9D\uDE9F-\uDEA8\uDEB0-\uDEE8\uDF00-\uDF03\uDF05-\uDF0C\uDF0F\uDF10\uDF13-\uDF28\uDF2A-\uDF30\uDF32\uDF33\uDF35-\uDF39\uDF3D-\uDF44\uDF47\uDF48\uDF4B\uDF4C\uDF50\uDF57\uDF5D-\uDF63]|\uD805[\uDC00-\uDC41\uDC43-\uDC45\uDC47-\uDC4A\uDC80-\uDCC1\uDCC4\uDCC5\uDCC7\uDD80-\uDDB5\uDDB8-\uDDBE\uDDD8-\uDDDD\uDE00-\uDE3E\uDE40\uDE44\uDE80-\uDEB5\uDF00-\uDF19\uDF1D-\uDF2A]|\uD806[\uDCA0-\uDCDF\uDCFF\uDEC0-\uDEF8]|\uD807[\uDC00-\uDC08\uDC0A-\uDC36\uDC38-\uDC3E\uDC40\uDC72-\uDC8F\uDC92-\uDCA7\uDCA9-\uDCB6]|\uD808[\uDC00-\uDF99]|\uD809[\uDC00-\uDC6E\uDC80-\uDD43]|[\uD80C\uD81C-\uD820\uD840-\uD868\uD86A-\uD86C\uD86F-\uD872][\uDC00-\uDFFF]|\uD80D[\uDC00-\uDC2E]|\uD811[\uDC00-\uDE46]|\uD81A[\uDC00-\uDE38\uDE40-\uDE5E\uDED0-\uDEED\uDF00-\uDF36\uDF40-\uDF43\uDF63-\uDF77\uDF7D-\uDF8F]|\uD81B[\uDF00-\uDF44\uDF50-\uDF7E\uDF93-\uDF9F\uDFE0]|\uD821[\uDC00-\uDFEC]|\uD822[\uDC00-\uDEF2]|\uD82C[\uDC00\uDC01]|\uD82F[\uDC00-\uDC6A\uDC70-\uDC7C\uDC80-\uDC88\uDC90-\uDC99\uDC9E]|\uD835[\uDC00-\uDC54\uDC56-\uDC9C\uDC9E\uDC9F\uDCA2\uDCA5\uDCA6\uDCA9-\uDCAC\uDCAE-\uDCB9\uDCBB\uDCBD-\uDCC3\uDCC5-\uDD05\uDD07-\uDD0A\uDD0D-\uDD14\uDD16-\uDD1C\uDD1E-\uDD39\uDD3B-\uDD3E\uDD40-\uDD44\uDD46\uDD4A-\uDD50\uDD52-\uDEA5\uDEA8-\uDEC0\uDEC2-\uDEDA\uDEDC-\uDEFA\uDEFC-\uDF14\uDF16-\uDF34\uDF36-\uDF4E\uDF50-\uDF6E\uDF70-\uDF88\uDF8A-\uDFA8\uDFAA-\uDFC2\uDFC4-\uDFCB]|\uD838[\uDC00-\uDC06\uDC08-\uDC18\uDC1B-\uDC21\uDC23\uDC24\uDC26-\uDC2A]|\uD83A[\uDC00-\uDCC4\uDD00-\uDD43\uDD47]|\uD83B[\uDE00-\uDE03\uDE05-\uDE1F\uDE21\uDE22\uDE24\uDE27\uDE29-\uDE32\uDE34-\uDE37\uDE39\uDE3B\uDE42\uDE47\uDE49\uDE4B\uDE4D-\uDE4F\uDE51\uDE52\uDE54\uDE57\uDE59\uDE5B\uDE5D\uDE5F\uDE61\uDE62\uDE64\uDE67-\uDE6A\uDE6C-\uDE72\uDE74-\uDE77\uDE79-\uDE7C\uDE7E\uDE80-\uDE89\uDE8B-\uDE9B\uDEA1-\uDEA3\uDEA5-\uDEA9\uDEAB-\uDEBB]|\uD83C[\uDD30-\uDD49\uDD50-\uDD69\uDD70-\uDD89]|\uD869[\uDC00-\uDED6\uDF00-\uDFFF]|\uD86D[\uDC00-\uDF34\uDF40-\uDFFF]|\uD86E[\uDC00-\uDC1D\uDC20-\uDFFF]|\uD873[\uDC00-\uDEA1]|\uD87E[\uDC00-\uDE1D]"},{name:"Any",isBmpLast:!0,bmp:"\0-\uFFFF",astral:"[\uD800-\uDBFF][\uDC00-\uDFFF]"},{name:"Default_Ignorable_Code_Point",bmp:"\xAD\u034F\u061C\u115F\u1160\u17B4\u17B5\u180B-\u180E\u200B-\u200F\u202A-\u202E\u2060-\u206F\u3164\uFE00-\uFE0F\uFEFF\uFFA0\uFFF0-\uFFF8",astral:"\uD82F[\uDCA0-\uDCA3]|\uD834[\uDD73-\uDD7A]|[\uDB40-\uDB43][\uDC00-\uDFFF]"},{name:"Lowercase",bmp:"a-z\xAA\xB5\xBA\xDF-\xF6\xF8-\xFF\u0101\u0103\u0105\u0107\u0109\u010B\u010D\u010F\u0111\u0113\u0115\u0117\u0119\u011B\u011D\u011F\u0121\u0123\u0125\u0127\u0129\u012B\u012D\u012F\u0131\u0133\u0135\u0137\u0138\u013A\u013C\u013E\u0140\u0142\u0144\u0146\u0148\u0149\u014B\u014D\u014F\u0151\u0153\u0155\u0157\u0159\u015B\u015D\u015F\u0161\u0163\u0165\u0167\u0169\u016B\u016D\u016F\u0171\u0173\u0175\u0177\u017A\u017C\u017E-\u0180\u0183\u0185\u0188\u018C\u018D\u0192\u0195\u0199-\u019B\u019E\u01A1\u01A3\u01A5\u01A8\u01AA\u01AB\u01AD\u01B0\u01B4\u01B6\u01B9\u01BA\u01BD-\u01BF\u01C6\u01C9\u01CC\u01CE\u01D0\u01D2\u01D4\u01D6\u01D8\u01DA\u01DC\u01DD\u01DF\u01E1\u01E3\u01E5\u01E7\u01E9\u01EB\u01ED\u01EF\u01F0\u01F3\u01F5\u01F9\u01FB\u01FD\u01FF\u0201\u0203\u0205\u0207\u0209\u020B\u020D\u020F\u0211\u0213\u0215\u0217\u0219\u021B\u021D\u021F\u0221\u0223\u0225\u0227\u0229\u022B\u022D\u022F\u0231\u0233-\u0239\u023C\u023F\u0240\u0242\u0247\u0249\u024B\u024D\u024F-\u0293\u0295-\u02B8\u02C0\u02C1\u02E0-\u02E4\u0345\u0371\u0373\u0377\u037A-\u037D\u0390\u03AC-\u03CE\u03D0\u03D1\u03D5-\u03D7\u03D9\u03DB\u03DD\u03DF\u03E1\u03E3\u03E5\u03E7\u03E9\u03EB\u03ED\u03EF-\u03F3\u03F5\u03F8\u03FB\u03FC\u0430-\u045F\u0461\u0463\u0465\u0467\u0469\u046B\u046D\u046F\u0471\u0473\u0475\u0477\u0479\u047B\u047D\u047F\u0481\u048B\u048D\u048F\u0491\u0493\u0495\u0497\u0499\u049B\u049D\u049F\u04A1\u04A3\u04A5\u04A7\u04A9\u04AB\u04AD\u04AF\u04B1\u04B3\u04B5\u04B7\u04B9\u04BB\u04BD\u04BF\u04C2\u04C4\u04C6\u04C8\u04CA\u04CC\u04CE\u04CF\u04D1\u04D3\u04D5\u04D7\u04D9\u04DB\u04DD\u04DF\u04E1\u04E3\u04E5\u04E7\u04E9\u04EB\u04ED\u04EF\u04F1\u04F3\u04F5\u04F7\u04F9\u04FB\u04FD\u04FF\u0501\u0503\u0505\u0507\u0509\u050B\u050D\u050F\u0511\u0513\u0515\u0517\u0519\u051B\u051D\u051F\u0521\u0523\u0525\u0527\u0529\u052B\u052D\u052F\u0561-\u0587\u13F8-\u13FD\u1C80-\u1C88\u1D00-\u1DBF\u1E01\u1E03\u1E05\u1E07\u1E09\u1E0B\u1E0D\u1E0F\u1E11\u1E13\u1E15\u1E17\u1E19\u1E1B\u1E1D\u1E1F\u1E21\u1E23\u1E25\u1E27\u1E29\u1E2B\u1E2D\u1E2F\u1E31\u1E33\u1E35\u1E37\u1E39\u1E3B\u1E3D\u1E3F\u1E41\u1E43\u1E45\u1E47\u1E49\u1E4B\u1E4D\u1E4F\u1E51\u1E53\u1E55\u1E57\u1E59\u1E5B\u1E5D\u1E5F\u1E61\u1E63\u1E65\u1E67\u1E69\u1E6B\u1E6D\u1E6F\u1E71\u1E73\u1E75\u1E77\u1E79\u1E7B\u1E7D\u1E7F\u1E81\u1E83\u1E85\u1E87\u1E89\u1E8B\u1E8D\u1E8F\u1E91\u1E93\u1E95-\u1E9D\u1E9F\u1EA1\u1EA3\u1EA5\u1EA7\u1EA9\u1EAB\u1EAD\u1EAF\u1EB1\u1EB3\u1EB5\u1EB7\u1EB9\u1EBB\u1EBD\u1EBF\u1EC1\u1EC3\u1EC5\u1EC7\u1EC9\u1ECB\u1ECD\u1ECF\u1ED1\u1ED3\u1ED5\u1ED7\u1ED9\u1EDB\u1EDD\u1EDF\u1EE1\u1EE3\u1EE5\u1EE7\u1EE9\u1EEB\u1EED\u1EEF\u1EF1\u1EF3\u1EF5\u1EF7\u1EF9\u1EFB\u1EFD\u1EFF-\u1F07\u1F10-\u1F15\u1F20-\u1F27\u1F30-\u1F37\u1F40-\u1F45\u1F50-\u1F57\u1F60-\u1F67\u1F70-\u1F7D\u1F80-\u1F87\u1F90-\u1F97\u1FA0-\u1FA7\u1FB0-\u1FB4\u1FB6\u1FB7\u1FBE\u1FC2-\u1FC4\u1FC6\u1FC7\u1FD0-\u1FD3\u1FD6\u1FD7\u1FE0-\u1FE7\u1FF2-\u1FF4\u1FF6\u1FF7\u2071\u207F\u2090-\u209C\u210A\u210E\u210F\u2113\u212F\u2134\u2139\u213C\u213D\u2146-\u2149\u214E\u2170-\u217F\u2184\u24D0-\u24E9\u2C30-\u2C5E\u2C61\u2C65\u2C66\u2C68\u2C6A\u2C6C\u2C71\u2C73\u2C74\u2C76-\u2C7D\u2C81\u2C83\u2C85\u2C87\u2C89\u2C8B\u2C8D\u2C8F\u2C91\u2C93\u2C95\u2C97\u2C99\u2C9B\u2C9D\u2C9F\u2CA1\u2CA3\u2CA5\u2CA7\u2CA9\u2CAB\u2CAD\u2CAF\u2CB1\u2CB3\u2CB5\u2CB7\u2CB9\u2CBB\u2CBD\u2CBF\u2CC1\u2CC3\u2CC5\u2CC7\u2CC9\u2CCB\u2CCD\u2CCF\u2CD1\u2CD3\u2CD5\u2CD7\u2CD9\u2CDB\u2CDD\u2CDF\u2CE1\u2CE3\u2CE4\u2CEC\u2CEE\u2CF3\u2D00-\u2D25\u2D27\u2D2D\uA641\uA643\uA645\uA647\uA649\uA64B\uA64D\uA64F\uA651\uA653\uA655\uA657\uA659\uA65B\uA65D\uA65F\uA661\uA663\uA665\uA667\uA669\uA66B\uA66D\uA681\uA683\uA685\uA687\uA689\uA68B\uA68D\uA68F\uA691\uA693\uA695\uA697\uA699\uA69B-\uA69D\uA723\uA725\uA727\uA729\uA72B\uA72D\uA72F-\uA731\uA733\uA735\uA737\uA739\uA73B\uA73D\uA73F\uA741\uA743\uA745\uA747\uA749\uA74B\uA74D\uA74F\uA751\uA753\uA755\uA757\uA759\uA75B\uA75D\uA75F\uA761\uA763\uA765\uA767\uA769\uA76B\uA76D\uA76F-\uA778\uA77A\uA77C\uA77F\uA781\uA783\uA785\uA787\uA78C\uA78E\uA791\uA793-\uA795\uA797\uA799\uA79B\uA79D\uA79F\uA7A1\uA7A3\uA7A5\uA7A7\uA7A9\uA7B5\uA7B7\uA7F8-\uA7FA\uAB30-\uAB5A\uAB5C-\uAB65\uAB70-\uABBF\uFB00-\uFB06\uFB13-\uFB17\uFF41-\uFF5A",astral:"\uD801[\uDC28-\uDC4F\uDCD8-\uDCFB]|\uD803[\uDCC0-\uDCF2]|\uD806[\uDCC0-\uDCDF]|\uD835[\uDC1A-\uDC33\uDC4E-\uDC54\uDC56-\uDC67\uDC82-\uDC9B\uDCB6-\uDCB9\uDCBB\uDCBD-\uDCC3\uDCC5-\uDCCF\uDCEA-\uDD03\uDD1E-\uDD37\uDD52-\uDD6B\uDD86-\uDD9F\uDDBA-\uDDD3\uDDEE-\uDE07\uDE22-\uDE3B\uDE56-\uDE6F\uDE8A-\uDEA5\uDEC2-\uDEDA\uDEDC-\uDEE1\uDEFC-\uDF14\uDF16-\uDF1B\uDF36-\uDF4E\uDF50-\uDF55\uDF70-\uDF88\uDF8A-\uDF8F\uDFAA-\uDFC2\uDFC4-\uDFC9\uDFCB]|\uD83A[\uDD22-\uDD43]"},{name:"Noncharacter_Code_Point",bmp:"\uFDD0-\uFDEF\uFFFE\uFFFF",astral:"[\uD83F\uD87F\uD8BF\uD8FF\uD93F\uD97F\uD9BF\uD9FF\uDA3F\uDA7F\uDABF\uDAFF\uDB3F\uDB7F\uDBBF\uDBFF][\uDFFE\uDFFF]"},{name:"Uppercase",bmp:"A-Z\xC0-\xD6\xD8-\xDE\u0100\u0102\u0104\u0106\u0108\u010A\u010C\u010E\u0110\u0112\u0114\u0116\u0118\u011A\u011C\u011E\u0120\u0122\u0124\u0126\u0128\u012A\u012C\u012E\u0130\u0132\u0134\u0136\u0139\u013B\u013D\u013F\u0141\u0143\u0145\u0147\u014A\u014C\u014E\u0150\u0152\u0154\u0156\u0158\u015A\u015C\u015E\u0160\u0162\u0164\u0166\u0168\u016A\u016C\u016E\u0170\u0172\u0174\u0176\u0178\u0179\u017B\u017D\u0181\u0182\u0184\u0186\u0187\u0189-\u018B\u018E-\u0191\u0193\u0194\u0196-\u0198\u019C\u019D\u019F\u01A0\u01A2\u01A4\u01A6\u01A7\u01A9\u01AC\u01AE\u01AF\u01B1-\u01B3\u01B5\u01B7\u01B8\u01BC\u01C4\u01C7\u01CA\u01CD\u01CF\u01D1\u01D3\u01D5\u01D7\u01D9\u01DB\u01DE\u01E0\u01E2\u01E4\u01E6\u01E8\u01EA\u01EC\u01EE\u01F1\u01F4\u01F6-\u01F8\u01FA\u01FC\u01FE\u0200\u0202\u0204\u0206\u0208\u020A\u020C\u020E\u0210\u0212\u0214\u0216\u0218\u021A\u021C\u021E\u0220\u0222\u0224\u0226\u0228\u022A\u022C\u022E\u0230\u0232\u023A\u023B\u023D\u023E\u0241\u0243-\u0246\u0248\u024A\u024C\u024E\u0370\u0372\u0376\u037F\u0386\u0388-\u038A\u038C\u038E\u038F\u0391-\u03A1\u03A3-\u03AB\u03CF\u03D2-\u03D4\u03D8\u03DA\u03DC\u03DE\u03E0\u03E2\u03E4\u03E6\u03E8\u03EA\u03EC\u03EE\u03F4\u03F7\u03F9\u03FA\u03FD-\u042F\u0460\u0462\u0464\u0466\u0468\u046A\u046C\u046E\u0470\u0472\u0474\u0476\u0478\u047A\u047C\u047E\u0480\u048A\u048C\u048E\u0490\u0492\u0494\u0496\u0498\u049A\u049C\u049E\u04A0\u04A2\u04A4\u04A6\u04A8\u04AA\u04AC\u04AE\u04B0\u04B2\u04B4\u04B6\u04B8\u04BA\u04BC\u04BE\u04C0\u04C1\u04C3\u04C5\u04C7\u04C9\u04CB\u04CD\u04D0\u04D2\u04D4\u04D6\u04D8\u04DA\u04DC\u04DE\u04E0\u04E2\u04E4\u04E6\u04E8\u04EA\u04EC\u04EE\u04F0\u04F2\u04F4\u04F6\u04F8\u04FA\u04FC\u04FE\u0500\u0502\u0504\u0506\u0508\u050A\u050C\u050E\u0510\u0512\u0514\u0516\u0518\u051A\u051C\u051E\u0520\u0522\u0524\u0526\u0528\u052A\u052C\u052E\u0531-\u0556\u10A0-\u10C5\u10C7\u10CD\u13A0-\u13F5\u1E00\u1E02\u1E04\u1E06\u1E08\u1E0A\u1E0C\u1E0E\u1E10\u1E12\u1E14\u1E16\u1E18\u1E1A\u1E1C\u1E1E\u1E20\u1E22\u1E24\u1E26\u1E28\u1E2A\u1E2C\u1E2E\u1E30\u1E32\u1E34\u1E36\u1E38\u1E3A\u1E3C\u1E3E\u1E40\u1E42\u1E44\u1E46\u1E48\u1E4A\u1E4C\u1E4E\u1E50\u1E52\u1E54\u1E56\u1E58\u1E5A\u1E5C\u1E5E\u1E60\u1E62\u1E64\u1E66\u1E68\u1E6A\u1E6C\u1E6E\u1E70\u1E72\u1E74\u1E76\u1E78\u1E7A\u1E7C\u1E7E\u1E80\u1E82\u1E84\u1E86\u1E88\u1E8A\u1E8C\u1E8E\u1E90\u1E92\u1E94\u1E9E\u1EA0\u1EA2\u1EA4\u1EA6\u1EA8\u1EAA\u1EAC\u1EAE\u1EB0\u1EB2\u1EB4\u1EB6\u1EB8\u1EBA\u1EBC\u1EBE\u1EC0\u1EC2\u1EC4\u1EC6\u1EC8\u1ECA\u1ECC\u1ECE\u1ED0\u1ED2\u1ED4\u1ED6\u1ED8\u1EDA\u1EDC\u1EDE\u1EE0\u1EE2\u1EE4\u1EE6\u1EE8\u1EEA\u1EEC\u1EEE\u1EF0\u1EF2\u1EF4\u1EF6\u1EF8\u1EFA\u1EFC\u1EFE\u1F08-\u1F0F\u1F18-\u1F1D\u1F28-\u1F2F\u1F38-\u1F3F\u1F48-\u1F4D\u1F59\u1F5B\u1F5D\u1F5F\u1F68-\u1F6F\u1FB8-\u1FBB\u1FC8-\u1FCB\u1FD8-\u1FDB\u1FE8-\u1FEC\u1FF8-\u1FFB\u2102\u2107\u210B-\u210D\u2110-\u2112\u2115\u2119-\u211D\u2124\u2126\u2128\u212A-\u212D\u2130-\u2133\u213E\u213F\u2145\u2160-\u216F\u2183\u24B6-\u24CF\u2C00-\u2C2E\u2C60\u2C62-\u2C64\u2C67\u2C69\u2C6B\u2C6D-\u2C70\u2C72\u2C75\u2C7E-\u2C80\u2C82\u2C84\u2C86\u2C88\u2C8A\u2C8C\u2C8E\u2C90\u2C92\u2C94\u2C96\u2C98\u2C9A\u2C9C\u2C9E\u2CA0\u2CA2\u2CA4\u2CA6\u2CA8\u2CAA\u2CAC\u2CAE\u2CB0\u2CB2\u2CB4\u2CB6\u2CB8\u2CBA\u2CBC\u2CBE\u2CC0\u2CC2\u2CC4\u2CC6\u2CC8\u2CCA\u2CCC\u2CCE\u2CD0\u2CD2\u2CD4\u2CD6\u2CD8\u2CDA\u2CDC\u2CDE\u2CE0\u2CE2\u2CEB\u2CED\u2CF2\uA640\uA642\uA644\uA646\uA648\uA64A\uA64C\uA64E\uA650\uA652\uA654\uA656\uA658\uA65A\uA65C\uA65E\uA660\uA662\uA664\uA666\uA668\uA66A\uA66C\uA680\uA682\uA684\uA686\uA688\uA68A\uA68C\uA68E\uA690\uA692\uA694\uA696\uA698\uA69A\uA722\uA724\uA726\uA728\uA72A\uA72C\uA72E\uA732\uA734\uA736\uA738\uA73A\uA73C\uA73E\uA740\uA742\uA744\uA746\uA748\uA74A\uA74C\uA74E\uA750\uA752\uA754\uA756\uA758\uA75A\uA75C\uA75E\uA760\uA762\uA764\uA766\uA768\uA76A\uA76C\uA76E\uA779\uA77B\uA77D\uA77E\uA780\uA782\uA784\uA786\uA78B\uA78D\uA790\uA792\uA796\uA798\uA79A\uA79C\uA79E\uA7A0\uA7A2\uA7A4\uA7A6\uA7A8\uA7AA-\uA7AE\uA7B0-\uA7B4\uA7B6\uFF21-\uFF3A",astral:"\uD801[\uDC00-\uDC27\uDCB0-\uDCD3]|\uD803[\uDC80-\uDCB2]|\uD806[\uDCA0-\uDCBF]|\uD835[\uDC00-\uDC19\uDC34-\uDC4D\uDC68-\uDC81\uDC9C\uDC9E\uDC9F\uDCA2\uDCA5\uDCA6\uDCA9-\uDCAC\uDCAE-\uDCB5\uDCD0-\uDCE9\uDD04\uDD05\uDD07-\uDD0A\uDD0D-\uDD14\uDD16-\uDD1C\uDD38\uDD39\uDD3B-\uDD3E\uDD40-\uDD44\uDD46\uDD4A-\uDD50\uDD6C-\uDD85\uDDA0-\uDDB9\uDDD4-\uDDED\uDE08-\uDE21\uDE3C-\uDE55\uDE70-\uDE89\uDEA8-\uDEC0\uDEE2-\uDEFA\uDF1C-\uDF34\uDF56-\uDF6E\uDF90-\uDFA8\uDFCA]|\uD83A[\uDD00-\uDD21]|\uD83C[\uDD30-\uDD49\uDD50-\uDD69\uDD70-\uDD89]"},{name:"White_Space",bmp:"	-\r \x85\xA0\u1680\u2000-\u200A\u2028\u2029\u202F\u205F\u3000"}];K.push({name:"Assigned",inverseOf:"Cn"}),b.addUnicodeData(K)}},{}],7:[function(R,a,G){/*!
 * XRegExp Unicode Scripts 3.2.0
 * <xregexp.com>
 * Steven Levithan (c) 2010-2017 MIT License
 * Unicode data by Mathias Bynens <mathiasbynens.be>
 */a.exports=function(b){"use strict";if(!b.addUnicodeData)throw new ReferenceError("Unicode Base must be loaded before Unicode Scripts");b.addUnicodeData([{name:"Adlam",astral:"\uD83A[\uDD00-\uDD4A\uDD50-\uDD59\uDD5E\uDD5F]"},{name:"Ahom",astral:"\uD805[\uDF00-\uDF19\uDF1D-\uDF2B\uDF30-\uDF3F]"},{name:"Anatolian_Hieroglyphs",astral:"\uD811[\uDC00-\uDE46]"},{name:"Arabic",bmp:"\u0600-\u0604\u0606-\u060B\u060D-\u061A\u061E\u0620-\u063F\u0641-\u064A\u0656-\u066F\u0671-\u06DC\u06DE-\u06FF\u0750-\u077F\u08A0-\u08B4\u08B6-\u08BD\u08D4-\u08E1\u08E3-\u08FF\uFB50-\uFBC1\uFBD3-\uFD3D\uFD50-\uFD8F\uFD92-\uFDC7\uFDF0-\uFDFD\uFE70-\uFE74\uFE76-\uFEFC",astral:"\uD803[\uDE60-\uDE7E]|\uD83B[\uDE00-\uDE03\uDE05-\uDE1F\uDE21\uDE22\uDE24\uDE27\uDE29-\uDE32\uDE34-\uDE37\uDE39\uDE3B\uDE42\uDE47\uDE49\uDE4B\uDE4D-\uDE4F\uDE51\uDE52\uDE54\uDE57\uDE59\uDE5B\uDE5D\uDE5F\uDE61\uDE62\uDE64\uDE67-\uDE6A\uDE6C-\uDE72\uDE74-\uDE77\uDE79-\uDE7C\uDE7E\uDE80-\uDE89\uDE8B-\uDE9B\uDEA1-\uDEA3\uDEA5-\uDEA9\uDEAB-\uDEBB\uDEF0\uDEF1]"},{name:"Armenian",bmp:"\u0531-\u0556\u0559-\u055F\u0561-\u0587\u058A\u058D-\u058F\uFB13-\uFB17"},{name:"Avestan",astral:"\uD802[\uDF00-\uDF35\uDF39-\uDF3F]"},{name:"Balinese",bmp:"\u1B00-\u1B4B\u1B50-\u1B7C"},{name:"Bamum",bmp:"\uA6A0-\uA6F7",astral:"\uD81A[\uDC00-\uDE38]"},{name:"Bassa_Vah",astral:"\uD81A[\uDED0-\uDEED\uDEF0-\uDEF5]"},{name:"Batak",bmp:"\u1BC0-\u1BF3\u1BFC-\u1BFF"},{name:"Bengali",bmp:"\u0980-\u0983\u0985-\u098C\u098F\u0990\u0993-\u09A8\u09AA-\u09B0\u09B2\u09B6-\u09B9\u09BC-\u09C4\u09C7\u09C8\u09CB-\u09CE\u09D7\u09DC\u09DD\u09DF-\u09E3\u09E6-\u09FB"},{name:"Bhaiksuki",astral:"\uD807[\uDC00-\uDC08\uDC0A-\uDC36\uDC38-\uDC45\uDC50-\uDC6C]"},{name:"Bopomofo",bmp:"\u02EA\u02EB\u3105-\u312D\u31A0-\u31BA"},{name:"Brahmi",astral:"\uD804[\uDC00-\uDC4D\uDC52-\uDC6F\uDC7F]"},{name:"Braille",bmp:"\u2800-\u28FF"},{name:"Buginese",bmp:"\u1A00-\u1A1B\u1A1E\u1A1F"},{name:"Buhid",bmp:"\u1740-\u1753"},{name:"Canadian_Aboriginal",bmp:"\u1400-\u167F\u18B0-\u18F5"},{name:"Carian",astral:"\uD800[\uDEA0-\uDED0]"},{name:"Caucasian_Albanian",astral:"\uD801[\uDD30-\uDD63\uDD6F]"},{name:"Chakma",astral:"\uD804[\uDD00-\uDD34\uDD36-\uDD43]"},{name:"Cham",bmp:"\uAA00-\uAA36\uAA40-\uAA4D\uAA50-\uAA59\uAA5C-\uAA5F"},{name:"Cherokee",bmp:"\u13A0-\u13F5\u13F8-\u13FD\uAB70-\uABBF"},{name:"Common",bmp:"\0-@\\x5B-`\\x7B-\xA9\xAB-\xB9\xBB-\xBF\xD7\xF7\u02B9-\u02DF\u02E5-\u02E9\u02EC-\u02FF\u0374\u037E\u0385\u0387\u0589\u0605\u060C\u061B\u061C\u061F\u0640\u06DD\u08E2\u0964\u0965\u0E3F\u0FD5-\u0FD8\u10FB\u16EB-\u16ED\u1735\u1736\u1802\u1803\u1805\u1CD3\u1CE1\u1CE9-\u1CEC\u1CEE-\u1CF3\u1CF5\u1CF6\u2000-\u200B\u200E-\u2064\u2066-\u2070\u2074-\u207E\u2080-\u208E\u20A0-\u20BE\u2100-\u2125\u2127-\u2129\u212C-\u2131\u2133-\u214D\u214F-\u215F\u2189-\u218B\u2190-\u23FE\u2400-\u2426\u2440-\u244A\u2460-\u27FF\u2900-\u2B73\u2B76-\u2B95\u2B98-\u2BB9\u2BBD-\u2BC8\u2BCA-\u2BD1\u2BEC-\u2BEF\u2E00-\u2E44\u2FF0-\u2FFB\u3000-\u3004\u3006\u3008-\u3020\u3030-\u3037\u303C-\u303F\u309B\u309C\u30A0\u30FB\u30FC\u3190-\u319F\u31C0-\u31E3\u3220-\u325F\u327F-\u32CF\u3358-\u33FF\u4DC0-\u4DFF\uA700-\uA721\uA788-\uA78A\uA830-\uA839\uA92E\uA9CF\uAB5B\uFD3E\uFD3F\uFE10-\uFE19\uFE30-\uFE52\uFE54-\uFE66\uFE68-\uFE6B\uFEFF\uFF01-\uFF20\uFF3B-\uFF40\uFF5B-\uFF65\uFF70\uFF9E\uFF9F\uFFE0-\uFFE6\uFFE8-\uFFEE\uFFF9-\uFFFD",astral:"\uD800[\uDD00-\uDD02\uDD07-\uDD33\uDD37-\uDD3F\uDD90-\uDD9B\uDDD0-\uDDFC\uDEE1-\uDEFB]|\uD82F[\uDCA0-\uDCA3]|\uD834[\uDC00-\uDCF5\uDD00-\uDD26\uDD29-\uDD66\uDD6A-\uDD7A\uDD83\uDD84\uDD8C-\uDDA9\uDDAE-\uDDE8\uDF00-\uDF56\uDF60-\uDF71]|\uD835[\uDC00-\uDC54\uDC56-\uDC9C\uDC9E\uDC9F\uDCA2\uDCA5\uDCA6\uDCA9-\uDCAC\uDCAE-\uDCB9\uDCBB\uDCBD-\uDCC3\uDCC5-\uDD05\uDD07-\uDD0A\uDD0D-\uDD14\uDD16-\uDD1C\uDD1E-\uDD39\uDD3B-\uDD3E\uDD40-\uDD44\uDD46\uDD4A-\uDD50\uDD52-\uDEA5\uDEA8-\uDFCB\uDFCE-\uDFFF]|\uD83C[\uDC00-\uDC2B\uDC30-\uDC93\uDCA0-\uDCAE\uDCB1-\uDCBF\uDCC1-\uDCCF\uDCD1-\uDCF5\uDD00-\uDD0C\uDD10-\uDD2E\uDD30-\uDD6B\uDD70-\uDDAC\uDDE6-\uDDFF\uDE01\uDE02\uDE10-\uDE3B\uDE40-\uDE48\uDE50\uDE51\uDF00-\uDFFF]|\uD83D[\uDC00-\uDED2\uDEE0-\uDEEC\uDEF0-\uDEF6\uDF00-\uDF73\uDF80-\uDFD4]|\uD83E[\uDC00-\uDC0B\uDC10-\uDC47\uDC50-\uDC59\uDC60-\uDC87\uDC90-\uDCAD\uDD10-\uDD1E\uDD20-\uDD27\uDD30\uDD33-\uDD3E\uDD40-\uDD4B\uDD50-\uDD5E\uDD80-\uDD91\uDDC0]|\uDB40[\uDC01\uDC20-\uDC7F]"},{name:"Coptic",bmp:"\u03E2-\u03EF\u2C80-\u2CF3\u2CF9-\u2CFF"},{name:"Cuneiform",astral:"\uD808[\uDC00-\uDF99]|\uD809[\uDC00-\uDC6E\uDC70-\uDC74\uDC80-\uDD43]"},{name:"Cypriot",astral:"\uD802[\uDC00-\uDC05\uDC08\uDC0A-\uDC35\uDC37\uDC38\uDC3C\uDC3F]"},{name:"Cyrillic",bmp:"\u0400-\u0484\u0487-\u052F\u1C80-\u1C88\u1D2B\u1D78\u2DE0-\u2DFF\uA640-\uA69F\uFE2E\uFE2F"},{name:"Deseret",astral:"\uD801[\uDC00-\uDC4F]"},{name:"Devanagari",bmp:"\u0900-\u0950\u0953-\u0963\u0966-\u097F\uA8E0-\uA8FD"},{name:"Duployan",astral:"\uD82F[\uDC00-\uDC6A\uDC70-\uDC7C\uDC80-\uDC88\uDC90-\uDC99\uDC9C-\uDC9F]"},{name:"Egyptian_Hieroglyphs",astral:"\uD80C[\uDC00-\uDFFF]|\uD80D[\uDC00-\uDC2E]"},{name:"Elbasan",astral:"\uD801[\uDD00-\uDD27]"},{name:"Ethiopic",bmp:"\u1200-\u1248\u124A-\u124D\u1250-\u1256\u1258\u125A-\u125D\u1260-\u1288\u128A-\u128D\u1290-\u12B0\u12B2-\u12B5\u12B8-\u12BE\u12C0\u12C2-\u12C5\u12C8-\u12D6\u12D8-\u1310\u1312-\u1315\u1318-\u135A\u135D-\u137C\u1380-\u1399\u2D80-\u2D96\u2DA0-\u2DA6\u2DA8-\u2DAE\u2DB0-\u2DB6\u2DB8-\u2DBE\u2DC0-\u2DC6\u2DC8-\u2DCE\u2DD0-\u2DD6\u2DD8-\u2DDE\uAB01-\uAB06\uAB09-\uAB0E\uAB11-\uAB16\uAB20-\uAB26\uAB28-\uAB2E"},{name:"Georgian",bmp:"\u10A0-\u10C5\u10C7\u10CD\u10D0-\u10FA\u10FC-\u10FF\u2D00-\u2D25\u2D27\u2D2D"},{name:"Glagolitic",bmp:"\u2C00-\u2C2E\u2C30-\u2C5E",astral:"\uD838[\uDC00-\uDC06\uDC08-\uDC18\uDC1B-\uDC21\uDC23\uDC24\uDC26-\uDC2A]"},{name:"Gothic",astral:"\uD800[\uDF30-\uDF4A]"},{name:"Grantha",astral:"\uD804[\uDF00-\uDF03\uDF05-\uDF0C\uDF0F\uDF10\uDF13-\uDF28\uDF2A-\uDF30\uDF32\uDF33\uDF35-\uDF39\uDF3C-\uDF44\uDF47\uDF48\uDF4B-\uDF4D\uDF50\uDF57\uDF5D-\uDF63\uDF66-\uDF6C\uDF70-\uDF74]"},{name:"Greek",bmp:"\u0370-\u0373\u0375-\u0377\u037A-\u037D\u037F\u0384\u0386\u0388-\u038A\u038C\u038E-\u03A1\u03A3-\u03E1\u03F0-\u03FF\u1D26-\u1D2A\u1D5D-\u1D61\u1D66-\u1D6A\u1DBF\u1F00-\u1F15\u1F18-\u1F1D\u1F20-\u1F45\u1F48-\u1F4D\u1F50-\u1F57\u1F59\u1F5B\u1F5D\u1F5F-\u1F7D\u1F80-\u1FB4\u1FB6-\u1FC4\u1FC6-\u1FD3\u1FD6-\u1FDB\u1FDD-\u1FEF\u1FF2-\u1FF4\u1FF6-\u1FFE\u2126\uAB65",astral:"\uD800[\uDD40-\uDD8E\uDDA0]|\uD834[\uDE00-\uDE45]"},{name:"Gujarati",bmp:"\u0A81-\u0A83\u0A85-\u0A8D\u0A8F-\u0A91\u0A93-\u0AA8\u0AAA-\u0AB0\u0AB2\u0AB3\u0AB5-\u0AB9\u0ABC-\u0AC5\u0AC7-\u0AC9\u0ACB-\u0ACD\u0AD0\u0AE0-\u0AE3\u0AE6-\u0AF1\u0AF9"},{name:"Gurmukhi",bmp:"\u0A01-\u0A03\u0A05-\u0A0A\u0A0F\u0A10\u0A13-\u0A28\u0A2A-\u0A30\u0A32\u0A33\u0A35\u0A36\u0A38\u0A39\u0A3C\u0A3E-\u0A42\u0A47\u0A48\u0A4B-\u0A4D\u0A51\u0A59-\u0A5C\u0A5E\u0A66-\u0A75"},{name:"Han",bmp:"\u2E80-\u2E99\u2E9B-\u2EF3\u2F00-\u2FD5\u3005\u3007\u3021-\u3029\u3038-\u303B\u3400-\u4DB5\u4E00-\u9FD5\uF900-\uFA6D\uFA70-\uFAD9",astral:"[\uD840-\uD868\uD86A-\uD86C\uD86F-\uD872][\uDC00-\uDFFF]|\uD869[\uDC00-\uDED6\uDF00-\uDFFF]|\uD86D[\uDC00-\uDF34\uDF40-\uDFFF]|\uD86E[\uDC00-\uDC1D\uDC20-\uDFFF]|\uD873[\uDC00-\uDEA1]|\uD87E[\uDC00-\uDE1D]"},{name:"Hangul",bmp:"\u1100-\u11FF\u302E\u302F\u3131-\u318E\u3200-\u321E\u3260-\u327E\uA960-\uA97C\uAC00-\uD7A3\uD7B0-\uD7C6\uD7CB-\uD7FB\uFFA0-\uFFBE\uFFC2-\uFFC7\uFFCA-\uFFCF\uFFD2-\uFFD7\uFFDA-\uFFDC"},{name:"Hanunoo",bmp:"\u1720-\u1734"},{name:"Hatran",astral:"\uD802[\uDCE0-\uDCF2\uDCF4\uDCF5\uDCFB-\uDCFF]"},{name:"Hebrew",bmp:"\u0591-\u05C7\u05D0-\u05EA\u05F0-\u05F4\uFB1D-\uFB36\uFB38-\uFB3C\uFB3E\uFB40\uFB41\uFB43\uFB44\uFB46-\uFB4F"},{name:"Hiragana",bmp:"\u3041-\u3096\u309D-\u309F",astral:"\u{1B001}|\u{1F200}"},{name:"Imperial_Aramaic",astral:"\uD802[\uDC40-\uDC55\uDC57-\uDC5F]"},{name:"Inherited",bmp:"\u0300-\u036F\u0485\u0486\u064B-\u0655\u0670\u0951\u0952\u1AB0-\u1ABE\u1CD0-\u1CD2\u1CD4-\u1CE0\u1CE2-\u1CE8\u1CED\u1CF4\u1CF8\u1CF9\u1DC0-\u1DF5\u1DFB-\u1DFF\u200C\u200D\u20D0-\u20F0\u302A-\u302D\u3099\u309A\uFE00-\uFE0F\uFE20-\uFE2D",astral:"\uD800[\uDDFD\uDEE0]|\uD834[\uDD67-\uDD69\uDD7B-\uDD82\uDD85-\uDD8B\uDDAA-\uDDAD]|\uDB40[\uDD00-\uDDEF]"},{name:"Inscriptional_Pahlavi",astral:"\uD802[\uDF60-\uDF72\uDF78-\uDF7F]"},{name:"Inscriptional_Parthian",astral:"\uD802[\uDF40-\uDF55\uDF58-\uDF5F]"},{name:"Javanese",bmp:"\uA980-\uA9CD\uA9D0-\uA9D9\uA9DE\uA9DF"},{name:"Kaithi",astral:"\uD804[\uDC80-\uDCC1]"},{name:"Kannada",bmp:"\u0C80-\u0C83\u0C85-\u0C8C\u0C8E-\u0C90\u0C92-\u0CA8\u0CAA-\u0CB3\u0CB5-\u0CB9\u0CBC-\u0CC4\u0CC6-\u0CC8\u0CCA-\u0CCD\u0CD5\u0CD6\u0CDE\u0CE0-\u0CE3\u0CE6-\u0CEF\u0CF1\u0CF2"},{name:"Katakana",bmp:"\u30A1-\u30FA\u30FD-\u30FF\u31F0-\u31FF\u32D0-\u32FE\u3300-\u3357\uFF66-\uFF6F\uFF71-\uFF9D",astral:"\u{1B000}"},{name:"Kayah_Li",bmp:"\uA900-\uA92D\uA92F"},{name:"Kharoshthi",astral:"\uD802[\uDE00-\uDE03\uDE05\uDE06\uDE0C-\uDE13\uDE15-\uDE17\uDE19-\uDE33\uDE38-\uDE3A\uDE3F-\uDE47\uDE50-\uDE58]"},{name:"Khmer",bmp:"\u1780-\u17DD\u17E0-\u17E9\u17F0-\u17F9\u19E0-\u19FF"},{name:"Khojki",astral:"\uD804[\uDE00-\uDE11\uDE13-\uDE3E]"},{name:"Khudawadi",astral:"\uD804[\uDEB0-\uDEEA\uDEF0-\uDEF9]"},{name:"Lao",bmp:"\u0E81\u0E82\u0E84\u0E87\u0E88\u0E8A\u0E8D\u0E94-\u0E97\u0E99-\u0E9F\u0EA1-\u0EA3\u0EA5\u0EA7\u0EAA\u0EAB\u0EAD-\u0EB9\u0EBB-\u0EBD\u0EC0-\u0EC4\u0EC6\u0EC8-\u0ECD\u0ED0-\u0ED9\u0EDC-\u0EDF"},{name:"Latin",bmp:"A-Za-z\xAA\xBA\xC0-\xD6\xD8-\xF6\xF8-\u02B8\u02E0-\u02E4\u1D00-\u1D25\u1D2C-\u1D5C\u1D62-\u1D65\u1D6B-\u1D77\u1D79-\u1DBE\u1E00-\u1EFF\u2071\u207F\u2090-\u209C\u212A\u212B\u2132\u214E\u2160-\u2188\u2C60-\u2C7F\uA722-\uA787\uA78B-\uA7AE\uA7B0-\uA7B7\uA7F7-\uA7FF\uAB30-\uAB5A\uAB5C-\uAB64\uFB00-\uFB06\uFF21-\uFF3A\uFF41-\uFF5A"},{name:"Lepcha",bmp:"\u1C00-\u1C37\u1C3B-\u1C49\u1C4D-\u1C4F"},{name:"Limbu",bmp:"\u1900-\u191E\u1920-\u192B\u1930-\u193B\u1940\u1944-\u194F"},{name:"Linear_A",astral:"\uD801[\uDE00-\uDF36\uDF40-\uDF55\uDF60-\uDF67]"},{name:"Linear_B",astral:"\uD800[\uDC00-\uDC0B\uDC0D-\uDC26\uDC28-\uDC3A\uDC3C\uDC3D\uDC3F-\uDC4D\uDC50-\uDC5D\uDC80-\uDCFA]"},{name:"Lisu",bmp:"\uA4D0-\uA4FF"},{name:"Lycian",astral:"\uD800[\uDE80-\uDE9C]"},{name:"Lydian",astral:"\uD802[\uDD20-\uDD39\uDD3F]"},{name:"Mahajani",astral:"\uD804[\uDD50-\uDD76]"},{name:"Malayalam",bmp:"\u0D01-\u0D03\u0D05-\u0D0C\u0D0E-\u0D10\u0D12-\u0D3A\u0D3D-\u0D44\u0D46-\u0D48\u0D4A-\u0D4F\u0D54-\u0D63\u0D66-\u0D7F"},{name:"Mandaic",bmp:"\u0840-\u085B\u085E"},{name:"Manichaean",astral:"\uD802[\uDEC0-\uDEE6\uDEEB-\uDEF6]"},{name:"Marchen",astral:"\uD807[\uDC70-\uDC8F\uDC92-\uDCA7\uDCA9-\uDCB6]"},{name:"Meetei_Mayek",bmp:"\uAAE0-\uAAF6\uABC0-\uABED\uABF0-\uABF9"},{name:"Mende_Kikakui",astral:"\uD83A[\uDC00-\uDCC4\uDCC7-\uDCD6]"},{name:"Meroitic_Cursive",astral:"\uD802[\uDDA0-\uDDB7\uDDBC-\uDDCF\uDDD2-\uDDFF]"},{name:"Meroitic_Hieroglyphs",astral:"\uD802[\uDD80-\uDD9F]"},{name:"Miao",astral:"\uD81B[\uDF00-\uDF44\uDF50-\uDF7E\uDF8F-\uDF9F]"},{name:"Modi",astral:"\uD805[\uDE00-\uDE44\uDE50-\uDE59]"},{name:"Mongolian",bmp:"\u1800\u1801\u1804\u1806-\u180E\u1810-\u1819\u1820-\u1877\u1880-\u18AA",astral:"\uD805[\uDE60-\uDE6C]"},{name:"Mro",astral:"\uD81A[\uDE40-\uDE5E\uDE60-\uDE69\uDE6E\uDE6F]"},{name:"Multani",astral:"\uD804[\uDE80-\uDE86\uDE88\uDE8A-\uDE8D\uDE8F-\uDE9D\uDE9F-\uDEA9]"},{name:"Myanmar",bmp:"\u1000-\u109F\uA9E0-\uA9FE\uAA60-\uAA7F"},{name:"Nabataean",astral:"\uD802[\uDC80-\uDC9E\uDCA7-\uDCAF]"},{name:"New_Tai_Lue",bmp:"\u1980-\u19AB\u19B0-\u19C9\u19D0-\u19DA\u19DE\u19DF"},{name:"Newa",astral:"\uD805[\uDC00-\uDC59\uDC5B\uDC5D]"},{name:"Nko",bmp:"\u07C0-\u07FA"},{name:"Ogham",bmp:"\u1680-\u169C"},{name:"Ol_Chiki",bmp:"\u1C50-\u1C7F"},{name:"Old_Hungarian",astral:"\uD803[\uDC80-\uDCB2\uDCC0-\uDCF2\uDCFA-\uDCFF]"},{name:"Old_Italic",astral:"\uD800[\uDF00-\uDF23]"},{name:"Old_North_Arabian",astral:"\uD802[\uDE80-\uDE9F]"},{name:"Old_Permic",astral:"\uD800[\uDF50-\uDF7A]"},{name:"Old_Persian",astral:"\uD800[\uDFA0-\uDFC3\uDFC8-\uDFD5]"},{name:"Old_South_Arabian",astral:"\uD802[\uDE60-\uDE7F]"},{name:"Old_Turkic",astral:"\uD803[\uDC00-\uDC48]"},{name:"Oriya",bmp:"\u0B01-\u0B03\u0B05-\u0B0C\u0B0F\u0B10\u0B13-\u0B28\u0B2A-\u0B30\u0B32\u0B33\u0B35-\u0B39\u0B3C-\u0B44\u0B47\u0B48\u0B4B-\u0B4D\u0B56\u0B57\u0B5C\u0B5D\u0B5F-\u0B63\u0B66-\u0B77"},{name:"Osage",astral:"\uD801[\uDCB0-\uDCD3\uDCD8-\uDCFB]"},{name:"Osmanya",astral:"\uD801[\uDC80-\uDC9D\uDCA0-\uDCA9]"},{name:"Pahawh_Hmong",astral:"\uD81A[\uDF00-\uDF45\uDF50-\uDF59\uDF5B-\uDF61\uDF63-\uDF77\uDF7D-\uDF8F]"},{name:"Palmyrene",astral:"\uD802[\uDC60-\uDC7F]"},{name:"Pau_Cin_Hau",astral:"\uD806[\uDEC0-\uDEF8]"},{name:"Phags_Pa",bmp:"\uA840-\uA877"},{name:"Phoenician",astral:"\uD802[\uDD00-\uDD1B\uDD1F]"},{name:"Psalter_Pahlavi",astral:"\uD802[\uDF80-\uDF91\uDF99-\uDF9C\uDFA9-\uDFAF]"},{name:"Rejang",bmp:"\uA930-\uA953\uA95F"},{name:"Runic",bmp:"\u16A0-\u16EA\u16EE-\u16F8"},{name:"Samaritan",bmp:"\u0800-\u082D\u0830-\u083E"},{name:"Saurashtra",bmp:"\uA880-\uA8C5\uA8CE-\uA8D9"},{name:"Sharada",astral:"\uD804[\uDD80-\uDDCD\uDDD0-\uDDDF]"},{name:"Shavian",astral:"\uD801[\uDC50-\uDC7F]"},{name:"Siddham",astral:"\uD805[\uDD80-\uDDB5\uDDB8-\uDDDD]"},{name:"SignWriting",astral:"\uD836[\uDC00-\uDE8B\uDE9B-\uDE9F\uDEA1-\uDEAF]"},{name:"Sinhala",bmp:"\u0D82\u0D83\u0D85-\u0D96\u0D9A-\u0DB1\u0DB3-\u0DBB\u0DBD\u0DC0-\u0DC6\u0DCA\u0DCF-\u0DD4\u0DD6\u0DD8-\u0DDF\u0DE6-\u0DEF\u0DF2-\u0DF4",astral:"\uD804[\uDDE1-\uDDF4]"},{name:"Sora_Sompeng",astral:"\uD804[\uDCD0-\uDCE8\uDCF0-\uDCF9]"},{name:"Sundanese",bmp:"\u1B80-\u1BBF\u1CC0-\u1CC7"},{name:"Syloti_Nagri",bmp:"\uA800-\uA82B"},{name:"Syriac",bmp:"\u0700-\u070D\u070F-\u074A\u074D-\u074F"},{name:"Tagalog",bmp:"\u1700-\u170C\u170E-\u1714"},{name:"Tagbanwa",bmp:"\u1760-\u176C\u176E-\u1770\u1772\u1773"},{name:"Tai_Le",bmp:"\u1950-\u196D\u1970-\u1974"},{name:"Tai_Tham",bmp:"\u1A20-\u1A5E\u1A60-\u1A7C\u1A7F-\u1A89\u1A90-\u1A99\u1AA0-\u1AAD"},{name:"Tai_Viet",bmp:"\uAA80-\uAAC2\uAADB-\uAADF"},{name:"Takri",astral:"\uD805[\uDE80-\uDEB7\uDEC0-\uDEC9]"},{name:"Tamil",bmp:"\u0B82\u0B83\u0B85-\u0B8A\u0B8E-\u0B90\u0B92-\u0B95\u0B99\u0B9A\u0B9C\u0B9E\u0B9F\u0BA3\u0BA4\u0BA8-\u0BAA\u0BAE-\u0BB9\u0BBE-\u0BC2\u0BC6-\u0BC8\u0BCA-\u0BCD\u0BD0\u0BD7\u0BE6-\u0BFA"},{name:"Tangut",astral:"\u{16FE0}|[\uD81C-\uD820][\uDC00-\uDFFF]|\uD821[\uDC00-\uDFEC]|\uD822[\uDC00-\uDEF2]"},{name:"Telugu",bmp:"\u0C00-\u0C03\u0C05-\u0C0C\u0C0E-\u0C10\u0C12-\u0C28\u0C2A-\u0C39\u0C3D-\u0C44\u0C46-\u0C48\u0C4A-\u0C4D\u0C55\u0C56\u0C58-\u0C5A\u0C60-\u0C63\u0C66-\u0C6F\u0C78-\u0C7F"},{name:"Thaana",bmp:"\u0780-\u07B1"},{name:"Thai",bmp:"\u0E01-\u0E3A\u0E40-\u0E5B"},{name:"Tibetan",bmp:"\u0F00-\u0F47\u0F49-\u0F6C\u0F71-\u0F97\u0F99-\u0FBC\u0FBE-\u0FCC\u0FCE-\u0FD4\u0FD9\u0FDA"},{name:"Tifinagh",bmp:"\u2D30-\u2D67\u2D6F\u2D70\u2D7F"},{name:"Tirhuta",astral:"\uD805[\uDC80-\uDCC7\uDCD0-\uDCD9]"},{name:"Ugaritic",astral:"\uD800[\uDF80-\uDF9D\uDF9F]"},{name:"Vai",bmp:"\uA500-\uA62B"},{name:"Warang_Citi",astral:"\uD806[\uDCA0-\uDCF2\uDCFF]"},{name:"Yi",bmp:"\uA000-\uA48C\uA490-\uA4C6"}])}},{}],8:[function(R,a,G){var b=R("./xregexp");R("./addons/build")(b),R("./addons/matchrecursive")(b),R("./addons/unicode-base")(b),R("./addons/unicode-blocks")(b),R("./addons/unicode-categories")(b),R("./addons/unicode-properties")(b),R("./addons/unicode-scripts")(b),a.exports=b},{"./addons/build":1,"./addons/matchrecursive":2,"./addons/unicode-base":3,"./addons/unicode-blocks":4,"./addons/unicode-categories":5,"./addons/unicode-properties":6,"./addons/unicode-scripts":7,"./xregexp":9}],9:[function(R,a,G){/*!
 * XRegExp 3.2.0
 * <xregexp.com>
 * Steven Levithan (c) 2007-2017 MIT License
 */var b={astral:!1,natives:!1},K={exec:RegExp.prototype.exec,test:RegExp.prototype.test,match:String.prototype.match,replace:String.prototype.replace,split:String.prototype.split},_={},c={},x={},s=[],E={default:/\\(?:0(?:[0-3][0-7]{0,2}|[4-7][0-7]?)?|[1-9]\d*|x[\dA-Fa-f]{2}|u(?:[\dA-Fa-f]{4}|{[\dA-Fa-f]+})|c[A-Za-z]|[\s\S])|\(\?(?:[:=!]|<[=!])|[?*+]\?|{\d+(?:,\d*)?}\??|[\s\S]/,class:/\\(?:[0-3][0-7]{0,2}|[4-7][0-7]?|x[\dA-Fa-f]{2}|u(?:[\dA-Fa-f]{4}|{[\dA-Fa-f]+})|c[A-Za-z]|[\s\S])|[\s\S]/},L=/\$(?:{([\w$]+)}|(\d\d?|[\s\S]))/g,j=K.exec.call(/()??/,"")[1]===void 0,D=/x/.flags!==void 0,A={}.toString;function N(t){var h=!0;try{new RegExp("",t)}catch{h=!1}return h}var M=N("u"),U=N("y"),F={g:!0,i:!0,m:!0,u:M,y:U};function p(t,h,I,S,k){var w;if(t.xregexp={captureNames:h},k)return t;if(t.__proto__)t.__proto__=v.prototype;else for(w in v.prototype)t[w]=v.prototype[w];return t.xregexp.source=I,t.xregexp.flags=S&&S.split("").sort().join(""),t}function n(t){return K.replace.call(t,/([\s\S])(?=[\s\S]*\1)/g,"")}function o(t,h){if(!v.isRegExp(t))throw new TypeError("Type RegExp expected");var I=t.xregexp||{},S=function(V){return D?V.flags:K.exec.call(/\/([a-z]*)$/i,RegExp.prototype.toString.call(V))[1]}(t),k="",w="",T=null,O=null;return(h=h||{}).removeG&&(w+="g"),h.removeY&&(w+="y"),w&&(S=K.replace.call(S,new RegExp("["+w+"]+","g"),"")),h.addG&&(k+="g"),h.addY&&(k+="y"),k&&(S=n(S+k)),h.isInternalOnly||(I.source!==void 0&&(T=I.source),I.flags!=null&&(O=k?n(I.flags+k):I.flags)),t=p(new RegExp(h.source||t.source,S),function(V){return!(!V.xregexp||!V.xregexp.captureNames)}(t)?I.captureNames.slice(0):null,T,O,h.isInternalOnly)}function r(t){return parseInt(t,16)}function l(t,h,I){return t.input.charAt(t.index-1)==="("||t.input.charAt(t.index+t[0].length)===")"||function(S,k,w,T){var O=w.indexOf("x")>-1?["\\s","#[^#\\n]*","\\(\\?#[^)]*\\)"]:["\\(\\?#[^)]*\\)"];return K.test.call(new RegExp("^(?:"+O.join("|")+")*(?:"+T+")"),S.slice(k))}(t.input,t.index+t[0].length,I,"[?*+]|{\\d+(?:,\\d*)?}")?"":"(?:)"}function m(t){return parseInt(t,10).toString(16)}function y(t,h){var I,S=t.length;for(I=0;I<S;++I)if(t[I]===h)return I;return-1}function C(t,h){return A.call(t)==="[object "+h+"]"}function f(t){for(;t.length<4;)t="0"+t;return t}function P(t){var h={};return C(t,"String")?(v.forEach(t,/[^\s,]+/,function(I){h[I]=!0}),h):t}function d(t){if(!/^[\w$]$/.test(t))throw new Error("Flag must be a single character A-Za-z0-9_$");F[t]=!0}function u(t,h,I,S,k){for(var w,T,O=s.length,V=t.charAt(I),B=null;O--;)if(!((T=s[O]).leadChar&&T.leadChar!==V||T.scope!==S&&T.scope!=="all"||T.flag&&h.indexOf(T.flag)===-1)&&(w=v.exec(t,T.regex,I,"sticky"))){B={matchLength:w[0].length,output:T.handler.call(k,w,S,h),reparse:T.reparse};break}return B}function e(t){b.astral=t}function i(t){RegExp.prototype.exec=(t?_:K).exec,RegExp.prototype.test=(t?_:K).test,String.prototype.match=(t?_:K).match,String.prototype.replace=(t?_:K).replace,String.prototype.split=(t?_:K).split,b.natives=t}function g(t){if(t==null)throw new TypeError("Cannot convert null or undefined to object");return t}function v(t,h){if(v.isRegExp(t)){if(h!==void 0)throw new TypeError("Cannot supply flags when copying a RegExp");return o(t)}if(t=t===void 0?"":String(t),h=h===void 0?"":String(h),v.isInstalled("astral")&&h.indexOf("A")===-1&&(h+="A"),x[t]||(x[t]={}),!x[t][h]){for(var I,S={hasNamedCapture:!1,captureNames:[]},k="default",w="",T=0,O=function(H,z){var W;if(n(z)!==z)throw new SyntaxError("Invalid duplicate regex flag "+z);for(H=K.replace.call(H,/^\(\?([\w$]+)\)/,function(Q,q){if(K.test.call(/[gy]/,q))throw new SyntaxError("Cannot use flag g or y in mode modifier "+Q);return z=n(z+q),""}),W=0;W<z.length;++W)if(!F[z.charAt(W)])throw new SyntaxError("Unknown regex flag "+z.charAt(W));return{pattern:H,flags:z}}(t,h),V=O.pattern,B=O.flags;T<V.length;){do(I=u(V,B,T,k,S))&&I.reparse&&(V=V.slice(0,T)+I.output+V.slice(T+I.matchLength));while(I&&I.reparse);if(I)w+=I.output,T+=I.matchLength||1;else{var $=v.exec(V,E[k],T,"sticky")[0];w+=$,T+=$.length,$==="["&&k==="default"?k="class":$==="]"&&k==="class"&&(k="default")}}x[t][h]={pattern:K.replace.call(w,/(?:\(\?:\))+/g,"(?:)"),flags:K.replace.call(B,/[^gimuy]+/g,""),captures:S.hasNamedCapture?S.captureNames:null}}var J=x[t][h];return p(new RegExp(J.pattern,J.flags),J.captures,t,h)}v.prototype=new RegExp,v.version="3.2.0",v._clipDuplicates=n,v._hasNativeFlag=N,v._dec=r,v._hex=m,v._pad4=f,v.addToken=function(t,h,I){var S,k=(I=I||{}).optionalFlags;if(I.flag&&d(I.flag),k)for(k=K.split.call(k,""),S=0;S<k.length;++S)d(k[S]);s.push({regex:o(t,{addG:!0,addY:U,isInternalOnly:!0}),handler:h,scope:I.scope||"default",flag:I.flag,reparse:I.reparse,leadChar:I.leadChar}),v.cache.flush("patterns")},v.cache=function(t,h){return c[t]||(c[t]={}),c[t][h]||(c[t][h]=v(t,h))},v.cache.flush=function(t){t==="patterns"?x={}:c={}},v.escape=function(t){return K.replace.call(g(t),/[-\[\]{}()*+?.,\\^$|#\s]/g,"\\$&")},v.exec=function(t,h,I,S){var k,w,T,O="g",V=!1;return(k=U&&!!(S||h.sticky&&S!==!1))?O+="y":S&&(V=!0,O+="FakeY"),h.xregexp=h.xregexp||{},I=I||0,(T=h.xregexp[O]||(h.xregexp[O]=o(h,{addG:!0,addY:k,source:V?h.source+"|()":void 0,removeY:S===!1,isInternalOnly:!0}))).lastIndex=I,w=_.exec.call(T,t),V&&w&&w.pop()===""&&(w=null),h.global&&(h.lastIndex=w?T.lastIndex:0),w},v.forEach=function(t,h,I){for(var S,k=0,w=-1;S=v.exec(t,h,k);)I(S,++w,t,h),k=S.index+(S[0].length||1)},v.globalize=function(t){return o(t,{addG:!0})},v.install=function(t){t=P(t),!b.astral&&t.astral&&e(!0),!b.natives&&t.natives&&i(!0)},v.isInstalled=function(t){return!!b[t]},v.isRegExp=function(t){return A.call(t)==="[object RegExp]"},v.match=function(t,h,I){var S,k,w=h.global&&I!=="one"||I==="all",T=(w?"g":"")+(h.sticky?"y":"")||"noGY";return h.xregexp=h.xregexp||{},k=h.xregexp[T]||(h.xregexp[T]=o(h,{addG:!!w,removeG:I==="one",isInternalOnly:!0})),S=K.match.call(g(t),k),h.global&&(h.lastIndex=I==="one"&&S?S.index+S[0].length:0),w?S||[]:S&&S[0]},v.matchChain=function(t,h){return function I(S,k){var w=h[k].regex?h[k]:{regex:h[k]},T=[];function O(B){if(w.backref){if(!(B.hasOwnProperty(w.backref)||+w.backref<B.length))throw new ReferenceError("Backreference to undefined group: "+w.backref);T.push(B[w.backref]||"")}else T.push(B[0])}for(var V=0;V<S.length;++V)v.forEach(S[V],w.regex,O);return k!==h.length-1&&T.length?I(T,k+1):T}([t],0)},v.replace=function(t,h,I,S){var k,w=v.isRegExp(h),T=h.global&&S!=="one"||S==="all",O=(T?"g":"")+(h.sticky?"y":"")||"noGY",V=h;return w?(h.xregexp=h.xregexp||{},V=h.xregexp[O]||(h.xregexp[O]=o(h,{addG:!!T,removeG:S==="one",isInternalOnly:!0}))):T&&(V=new RegExp(v.escape(String(h)),"g")),k=_.replace.call(g(t),V,I),w&&h.global&&(h.lastIndex=0),k},v.replaceEach=function(t,h){var I,S;for(I=0;I<h.length;++I)S=h[I],t=v.replace(t,S[0],S[1],S[2]);return t},v.split=function(t,h,I){return _.split.call(g(t),h,I)},v.test=function(t,h,I,S){return!!v.exec(t,h,I,S)},v.uninstall=function(t){t=P(t),b.astral&&t.astral&&e(!1),b.natives&&t.natives&&i(!1)},v.union=function(t,h,I){var S,k,w=(I=I||{}).conjunction||"or",T=0;function O(z,W,Q){var q=k[T-S];if(W){if(++T,q)return"(?<"+q+">"}else if(Q)return"\\"+(+Q+S);return z}if(!C(t,"Array")||!t.length)throw new TypeError("Must provide a nonempty array of patterns to merge");for(var V,B=/(\()(?!\?)|\\([1-9]\d*)|\\[\s\S]|\[(?:[^\\\]]|\\[\s\S])*\]/g,$=[],J=0;J<t.length;++J)V=t[J],v.isRegExp(V)?(S=T,k=V.xregexp&&V.xregexp.captureNames||[],$.push(K.replace.call(v(V.source).source,B,O))):$.push(v.escape(V));var H=w==="none"?"":"|";return v($.join(H),h)},_.exec=function(t){var h,I,S,k=this.lastIndex,w=K.exec.apply(this,arguments);if(w){if(!j&&w.length>1&&y(w,"")>-1&&(I=o(this,{removeG:!0,isInternalOnly:!0}),K.replace.call(String(t).slice(w.index),I,function(){var T,O=arguments.length;for(T=1;T<O-2;++T)arguments[T]===void 0&&(w[T]=void 0)})),this.xregexp&&this.xregexp.captureNames)for(S=1;S<w.length;++S)(h=this.xregexp.captureNames[S-1])&&(w[h]=w[S]);this.global&&!w[0].length&&this.lastIndex>w.index&&(this.lastIndex=w.index)}return this.global||(this.lastIndex=k),w},_.test=function(t){return!!_.exec.call(this,t)},_.match=function(t){var h;if(v.isRegExp(t)){if(t.global)return h=K.match.apply(this,arguments),t.lastIndex=0,h}else t=new RegExp(t);return _.exec.call(t,g(this))},_.replace=function(t,h){var I,S,k,w=v.isRegExp(t);return w?(t.xregexp&&(S=t.xregexp.captureNames),I=t.lastIndex):t+="",k=C(h,"Function")?K.replace.call(String(this),t,function(){var T,O=arguments;if(S)for(O[0]=new String(O[0]),T=0;T<S.length;++T)S[T]&&(O[0][S[T]]=O[T+1]);return w&&t.global&&(t.lastIndex=O[O.length-2]+O[0].length),h.apply(void 0,O)}):K.replace.call(this==null?this:String(this),t,function(){var T=arguments;return K.replace.call(String(h),L,function(O,V,B){var $;if(V){if(($=+V)<=T.length-3)return T[$]||"";if(($=S?y(S,V):-1)<0)throw new SyntaxError("Backreference to undefined group "+O);return T[$+1]||""}if(B==="$")return"$";if(B==="&"||+B==0)return T[0];if(B==="`")return T[T.length-1].slice(0,T[T.length-2]);if(B==="'")return T[T.length-1].slice(T[T.length-2]+T[0].length);if(B=+B,!isNaN(B)){if(B>T.length-3)throw new SyntaxError("Backreference to undefined group "+O);return T[B]||""}throw new SyntaxError("Invalid token "+O)})}),w&&(t.global?t.lastIndex=0:t.lastIndex=I),k},_.split=function(t,h){if(!v.isRegExp(t))return K.split.apply(this,arguments);var I,S=String(this),k=[],w=t.lastIndex,T=0;return h=(h===void 0?-1:h)>>>0,v.forEach(S,t,function(O){O.index+O[0].length>T&&(k.push(S.slice(T,O.index)),O.length>1&&O.index<S.length&&Array.prototype.push.apply(k,O.slice(1)),I=O[0].length,T=O.index+I)}),T===S.length?K.test.call(t,"")&&!I||k.push(""):k.push(S.slice(T)),t.lastIndex=w,k.length>h?k.slice(0,h):k},v.addToken(/\\([ABCE-RTUVXYZaeg-mopqyz]|c(?![A-Za-z])|u(?![\dA-Fa-f]{4}|{[\dA-Fa-f]+})|x(?![\dA-Fa-f]{2}))/,function(t,h){if(t[1]==="B"&&h==="default")return t[0];throw new SyntaxError("Invalid escape "+t[0])},{scope:"all",leadChar:"\\"}),v.addToken(/\\u{([\dA-Fa-f]+)}/,function(t,h,I){var S=r(t[1]);if(S>1114111)throw new SyntaxError("Invalid Unicode code point "+t[0]);if(S<=65535)return"\\u"+f(m(S));if(M&&I.indexOf("u")>-1)return t[0];throw new SyntaxError("Cannot use Unicode code point above \\u{FFFF} without flag u")},{scope:"all",leadChar:"\\"}),v.addToken(/\[(\^?)\]/,function(t){return t[1]?"[\\s\\S]":"\\b\\B"},{leadChar:"["}),v.addToken(/\(\?#[^)]*\)/,l,{leadChar:"("}),v.addToken(/\s+|#[^\n]*\n?/,l,{flag:"x"}),v.addToken(/\./,function(){return"[\\s\\S]"},{flag:"s",leadChar:"."}),v.addToken(/\\k<([\w$]+)>/,function(t){var h=isNaN(t[1])?y(this.captureNames,t[1])+1:+t[1],I=t.index+t[0].length;if(!h||h>this.captureNames.length)throw new SyntaxError("Backreference to undefined group "+t[0]);return"\\"+h+(I===t.input.length||isNaN(t.input.charAt(I))?"":"(?:)")},{leadChar:"\\"}),v.addToken(/\\(\d+)/,function(t,h){if(!(h==="default"&&/^[1-9]/.test(t[1])&&+t[1]<=this.captureNames.length)&&t[1]!=="0")throw new SyntaxError("Cannot use octal escape or backreference to undefined group "+t[0]);return t[0]},{scope:"all",leadChar:"\\"}),v.addToken(/\(\?P?<([\w$]+)>/,function(t){if(!isNaN(t[1]))throw new SyntaxError("Cannot use integer as capture name "+t[0]);if(t[1]==="length"||t[1]==="__proto__")throw new SyntaxError("Cannot use reserved word as capture name "+t[0]);if(y(this.captureNames,t[1])>-1)throw new SyntaxError("Cannot use same name for multiple groups "+t[0]);return this.captureNames.push(t[1]),this.hasNamedCapture=!0,"("},{leadChar:"("}),v.addToken(/\((?!\?)/,function(t,h,I){return I.indexOf("n")>-1?"(?:":(this.captureNames.push(null),"(")},{optionalFlags:"n",leadChar:"("}),a.exports=v},{}]},{},[8])(8)}),define("xregexp",["xregexp/xregexp-all"],function(R){return R});var __assign=this&&this.__assign||function(){return(__assign=Object.assign||function(R){for(var a,G=1,b=arguments.length;G<b;G++)for(var K in a=arguments[G])Object.prototype.hasOwnProperty.call(a,K)&&(R[K]=a[K]);return R}).apply(this,arguments)};define("vs/language/kusto/languageService/kustoLanguageService",["require","exports","./schema","vscode-languageserver-types","xregexp","./schema"],function(R,a,G,b,K,_){"use strict";Object.defineProperty(a,"__esModule",{value:!0}),a.getKustoLanguageService=a.TokenKind=void 0,String.prototype.endsWith||(String.prototype.endsWith=function(p,n){return(n===void 0||n>this.length)&&(n=this.length),this.substring(n-p.length,n)===p}),typeof document>"u"&&(importScripts("../../language/kusto/bridge.min.js"),importScripts("../../language/kusto/kusto.javascript.client.min.js"),importScripts("../../language/kusto/Kusto.Language.Bridge.min.js"));var c=Kusto.Data.IntelliSense,x=Kusto.Language.Parsing,s=Kusto.Language.Editor,E=Kusto.Language.Symbols,L=Kusto.Language.GlobalState,j=System.Collections.Generic.List$1;function D(p){throw new Error("Unexpected object: "+p)}var A,N=function(){function p(n,o,r,l){this.version=n,this.uri=o,this.rulesProvider=r,this.parseMode=l}return p.prototype.isParseNeeded=function(n,o,r){return!(n.uri===this.uri&&(!o||o===this.rulesProvider)&&n.version<=this.version&&r&&r<=this.parseMode)},p}();function M(p){return p.map(function(n){return{start:n.Start,end:n.End,length:n.Length,kind:n.Kind}})}(function(p){p[p.TableToken=2]="TableToken",p[p.TableColumnToken=4]="TableColumnToken",p[p.OperatorToken=8]="OperatorToken",p[p.SubOperatorToken=16]="SubOperatorToken",p[p.CalculatedColumnToken=32]="CalculatedColumnToken",p[p.StringLiteralToken=64]="StringLiteralToken",p[p.FunctionNameToken=128]="FunctionNameToken",p[p.UnknownToken=256]="UnknownToken",p[p.CommentToken=512]="CommentToken",p[p.PlainTextToken=1024]="PlainTextToken",p[p.DataTypeToken=2048]="DataTypeToken",p[p.ControlCommandToken=4096]="ControlCommandToken",p[p.CommandPartToken=8192]="CommandPartToken",p[p.QueryParametersToken=16384]="QueryParametersToken",p[p.CslCommandToken=32768]="CslCommandToken",p[p.LetVariablesToken=65536]="LetVariablesToken",p[p.PluginToken=131072]="PluginToken",p[p.BracketRangeToken=262144]="BracketRangeToken",p[p.ClientDirectiveToken=524288]="ClientDirectiveToken"})(A=a.TokenKind||(a.TokenKind={}));var U=function(){function p(n,o){var r,l,m,y,C=this;this._toOptionKind=((r={})[s.CompletionKind.AggregateFunction]=c.OptionKind.FunctionAggregation,r[s.CompletionKind.BuiltInFunction]=c.OptionKind.FunctionScalar,r[s.CompletionKind.Cluster]=c.OptionKind.Database,r[s.CompletionKind.Column]=c.OptionKind.Column,r[s.CompletionKind.CommandPrefix]=c.OptionKind.Command,r[s.CompletionKind.Database]=c.OptionKind.Database,r[s.CompletionKind.DatabaseFunction]=c.OptionKind.FunctionServerSide,r[s.CompletionKind.Example]=c.OptionKind.Literal,r[s.CompletionKind.Identifier]=c.OptionKind.None,r[s.CompletionKind.Keyword]=c.OptionKind.Option,r[s.CompletionKind.LocalFunction]=c.OptionKind.FunctionLocal,r[s.CompletionKind.MaterialiedView]=c.OptionKind.MaterializedView,r[s.CompletionKind.Parameter]=c.OptionKind.Parameter,r[s.CompletionKind.Punctuation]=c.OptionKind.None,r[s.CompletionKind.QueryPrefix]=c.OptionKind.Operator,r[s.CompletionKind.RenderChart]=c.OptionKind.OptionRender,r[s.CompletionKind.ScalarInfix]=c.OptionKind.None,r[s.CompletionKind.ScalarPrefix]=c.OptionKind.Literal,r[s.CompletionKind.ScalarType]=c.OptionKind.DataType,r[s.CompletionKind.Syntax]=c.OptionKind.None,r[s.CompletionKind.Table]=c.OptionKind.Table,r[s.CompletionKind.TabularPrefix]=c.OptionKind.None,r[s.CompletionKind.TabularSuffix]=c.OptionKind.None,r[s.CompletionKind.Unknown]=c.OptionKind.None,r[s.CompletionKind.Variable]=c.OptionKind.Parameter,r[s.CompletionKind.Option]=c.OptionKind.Option,r[s.CompletionKind.Graph]=c.OptionKind.Graph,r),this.disabledCompletionItemsV2={ladderchart:s.CompletionKind.RenderChart,pivotchart:s.CompletionKind.RenderChart,timeline:s.CompletionKind.RenderChart,timepivot:s.CompletionKind.RenderChart,"3Dchart":s.CompletionKind.RenderChart,list:s.CompletionKind.RenderChart},this.isIntellisenseV2=function(){return C._languageSettings.useIntellisenseV2&&C._schema&&C._schema.clusterType==="Engine"},this.disabledCompletionItemsV1={capacity:c.OptionKind.Policy,callout:c.OptionKind.Policy,encoding:c.OptionKind.Policy,batching:c.OptionKind.Policy,querythrottling:c.OptionKind.Policy,merge:c.OptionKind.Policy,querylimit:c.OptionKind.Policy,rowstore:c.OptionKind.Policy,streamingingestion:c.OptionKind.Policy,restricted_view_access:c.OptionKind.Policy,sharding:c.OptionKind.Policy,"restricted-viewers":c.OptionKind.Policy,attach:c.OptionKind.Command,purge:c.OptionKind.Command},this._kustoKindtolsKind=((l={})[c.OptionKind.None]=b.CompletionItemKind.Interface,l[c.OptionKind.Operator]=b.CompletionItemKind.Method,l[c.OptionKind.Command]=b.CompletionItemKind.Method,l[c.OptionKind.Service]=b.CompletionItemKind.Class,l[c.OptionKind.Policy]=b.CompletionItemKind.Reference,l[c.OptionKind.Database]=b.CompletionItemKind.Class,l[c.OptionKind.Table]=b.CompletionItemKind.Class,l[c.OptionKind.DataType]=b.CompletionItemKind.Class,l[c.OptionKind.Literal]=b.CompletionItemKind.Property,l[c.OptionKind.Parameter]=b.CompletionItemKind.Variable,l[c.OptionKind.IngestionMapping]=b.CompletionItemKind.Variable,l[c.OptionKind.ExpressionFunction]=b.CompletionItemKind.Variable,l[c.OptionKind.Option]=b.CompletionItemKind.Interface,l[c.OptionKind.OptionKind]=b.CompletionItemKind.Interface,l[c.OptionKind.OptionRender]=b.CompletionItemKind.Interface,l[c.OptionKind.Column]=b.CompletionItemKind.Function,l[c.OptionKind.ColumnString]=b.CompletionItemKind.Field,l[c.OptionKind.ColumnNumeric]=b.CompletionItemKind.Field,l[c.OptionKind.ColumnDateTime]=b.CompletionItemKind.Field,l[c.OptionKind.ColumnTimespan]=b.CompletionItemKind.Field,l[c.OptionKind.FunctionServerSide]=b.CompletionItemKind.Field,l[c.OptionKind.FunctionAggregation]=b.CompletionItemKind.Field,l[c.OptionKind.FunctionFilter]=b.CompletionItemKind.Field,l[c.OptionKind.FunctionScalar]=b.CompletionItemKind.Field,l[c.OptionKind.ClientDirective]=b.CompletionItemKind.Enum,l),this._kustoKindToLsKindV2=((m={})[s.CompletionKind.AggregateFunction]=b.CompletionItemKind.Field,m[s.CompletionKind.BuiltInFunction]=b.CompletionItemKind.Field,m[s.CompletionKind.Cluster]=b.CompletionItemKind.Class,m[s.CompletionKind.Column]=b.CompletionItemKind.Function,m[s.CompletionKind.CommandPrefix]=b.CompletionItemKind.Field,m[s.CompletionKind.Database]=b.CompletionItemKind.Class,m[s.CompletionKind.DatabaseFunction]=b.CompletionItemKind.Field,m[s.CompletionKind.Example]=b.CompletionItemKind.Text,m[s.CompletionKind.Identifier]=b.CompletionItemKind.Method,m[s.CompletionKind.Keyword]=b.CompletionItemKind.Method,m[s.CompletionKind.LocalFunction]=b.CompletionItemKind.Field,m[s.CompletionKind.MaterialiedView]=b.CompletionItemKind.Class,m[s.CompletionKind.Parameter]=b.CompletionItemKind.Variable,m[s.CompletionKind.Punctuation]=b.CompletionItemKind.Interface,m[s.CompletionKind.QueryPrefix]=b.CompletionItemKind.Function,m[s.CompletionKind.RenderChart]=b.CompletionItemKind.Method,m[s.CompletionKind.ScalarInfix]=b.CompletionItemKind.Field,m[s.CompletionKind.ScalarPrefix]=b.CompletionItemKind.Field,m[s.CompletionKind.ScalarType]=b.CompletionItemKind.TypeParameter,m[s.CompletionKind.Syntax]=b.CompletionItemKind.Method,m[s.CompletionKind.Table]=b.CompletionItemKind.Class,m[s.CompletionKind.TabularPrefix]=b.CompletionItemKind.Field,m[s.CompletionKind.TabularSuffix]=b.CompletionItemKind.Field,m[s.CompletionKind.Unknown]=b.CompletionItemKind.Interface,m[s.CompletionKind.Variable]=b.CompletionItemKind.Variable,m[s.CompletionKind.Option]=b.CompletionItemKind.Text,m[s.CompletionKind.Graph]=b.CompletionItemKind.Class,m),this._tokenKindToClassificationKind=((y={})[A.TableToken]=s.ClassificationKind.Table,y[A.TableColumnToken]=s.ClassificationKind.Column,y[A.OperatorToken]=s.ClassificationKind.QueryOperator,y[A.SubOperatorToken]=s.ClassificationKind.Function,y[A.CalculatedColumnToken]=s.ClassificationKind.Column,y[A.StringLiteralToken]=s.ClassificationKind.Literal,y[A.FunctionNameToken]=s.ClassificationKind.Function,y[A.UnknownToken]=s.ClassificationKind.PlainText,y[A.CommentToken]=s.ClassificationKind.Comment,y[A.PlainTextToken]=s.ClassificationKind.PlainText,y[A.DataTypeToken]=s.ClassificationKind.Type,y[A.ControlCommandToken]=s.ClassificationKind.PlainText,y[A.CommandPartToken]=s.ClassificationKind.PlainText,y[A.QueryParametersToken]=s.ClassificationKind.QueryParameter,y[A.CslCommandToken]=s.ClassificationKind.Keyword,y[A.LetVariablesToken]=s.ClassificationKind.Identifier,y[A.PluginToken]=s.ClassificationKind.Function,y[A.BracketRangeToken]=s.ClassificationKind.Keyword,y[A.ClientDirectiveToken]=s.ClassificationKind.Keyword,y),this._schemaCache={},this._kustoJsSchema=p.convertToKustoJsSchema(n),this.__kustoJsSchemaV2=this.convertToKustoJsSchemaV2(n),this._schema=n,this._clustersSetInGlobalState=new Set,this._nonEmptyDatabaseSetInGlobalState=new Set,this.configure(o),this._newlineAppendPipePolicy=new Kusto.Data.IntelliSense.ApplyPolicy,this._newlineAppendPipePolicy.Text=`
| `}return p.prototype.createDatabaseUniqueName=function(n,o){return n+"_"+o},Object.defineProperty(p.prototype,"_kustoJsSchemaV2",{get:function(){return this.__kustoJsSchemaV2},set:function(n){this.__kustoJsSchemaV2=n,this._clustersSetInGlobalState.clear(),this._nonEmptyDatabaseSetInGlobalState.clear();for(var o=0;o<n.Clusters.Count;o++){var r=this._kustoJsSchemaV2.Clusters.getItem(o);this._clustersSetInGlobalState.add(r.Name);for(var l=0;l<r.Databases.Count;l++){var m=r.Databases.getItem(l);m.Tables.Count>0&&this._nonEmptyDatabaseSetInGlobalState.add(this.createDatabaseUniqueName(r.Name,m.Name))}}},enumerable:!1,configurable:!0}),p.prototype.configure=function(n){this._languageSettings=n,this.createRulesProvider(this._kustoJsSchema,this._schema.clusterType)},p.prototype.doComplete=function(n,o){return this.isIntellisenseV2()?this.doCompleteV2(n,o):this.doCompleteV1(n,o)},p.prototype.debugGlobalState=function(n){console.log("globals.Clusters.Count: "+n.Clusters.Count);for(var o=0;o<n.Clusters.Count;o++){var r=n.Clusters.getItem(o);console.log("cluster: "+r.Name),console.log("cluster.Databases.Count: "+r.Databases.Count);for(var l=0;l<r.Databases.Count;l++){var m=r.Databases.getItem(l);console.log("cluster.database: ["+r.Name+"].["+m.Name+"]"),console.log("cluster.Databases.Tables.Count: "+m.Tables.Count);for(var y=0;y<m.Tables.Count;y++){var C=m.Tables.getItem(y);console.log("cluster.database.table: ["+r.Name+"].["+m.Name+"].["+C.Name+"]")}}}},p.prototype.formatHelpTopic=function(n){return"**"+n.Name+" [(view online)]("+n.Url+`)**

`+n.LongDescription},p.prototype.doCompleteV2=function(n,o){var r=this;if(!n)return Promise.resolve(b.CompletionList.create([]));var l=this.parseDocumentV2(n),m=n.offsetAt(o),y=l.GetBlockAtPosition(m).Service.GetCompletionItems(m),C=this.disabledCompletionItemsV2;this._languageSettings.disabledCompletionItems&&this._languageSettings.disabledCompletionItems.map(function(d){C[d]=s.CompletionKind.Unknown});var f=this.toArray(y.Items),P=f.filter(function(d){return!(d&&d.MatchText&&C[d.MatchText]!==void 0&&(C[d.MatchText]===s.CompletionKind.Unknown||C[d.MatchText]===d.Kind))}).map(function(d,u){var e=new c.CompletionOption(r._toOptionKind[d.Kind]||c.OptionKind.None,d.DisplayText),i=r.getTopic(e),g=d.AfterText&&d.AfterText.length>0?{textToInsert:d.EditText.replace("$","\\$")+"$0"+d.AfterText,format:b.InsertTextFormat.Snippet}:{textToInsert:d.EditText,format:b.InsertTextFormat.PlainText},v=g.textToInsert,t=g.format,h=b.CompletionItem.create(d.DisplayText),I=h.kind===b.CompletionItemKind.Field?0:f.length,S=n.positionAt(y.EditStart),k=n.positionAt(y.EditStart+y.EditLength);return h.textEdit=b.TextEdit.replace(b.Range.create(S,k),v),h.sortText=r.getSortText(I+u+1),h.filterText=h.label.charAt(0).toLowerCase()+h.label.slice(1),h.kind=r.kustoKindToLsKindV2(d.Kind),h.insertTextFormat=t,h.detail=i?i.ShortDescription:void 0,h.documentation=i?{value:r.formatHelpTopic(i),kind:b.MarkupKind.Markdown}:void 0,h});return Promise.resolve(b.CompletionList.create(P))},p.prototype.getTopic=function(n){if(n.Kind==c.OptionKind.FunctionScalar||n.Kind==c.OptionKind.FunctionAggregation){var o=n.Value.indexOf("(");o>=0&&(n=new c.CompletionOption(n.Kind,n.Value.substring(0,o)))}return c.CslDocumentation.Instance.GetTopic(n)},p.prototype.doCompleteV1=function(n,o){var r=this,l=n.offsetAt(o);this.parseDocumentV1(n,c.ParseMode.CommandTokensOnly);var m=this.getCurrentCommand(n,l),y="";if(m){m.AbsoluteStart,this.parseTextV1(m.Text,c.ParseMode.TokenizeAllText);var C=l-m.AbsoluteStart;y=m.Text.substring(m.CslExpressionStartPosition,C)}var f=this.getCommandWithoutLastWord(y),P=this._rulesProvider.AnalyzeCommand$1(y,m).Context,d={v:null};this._rulesProvider.TryMatchAnyRule(f,d);var u=d.v;if(u){var e=this.toArray(u.GetCompletionOptions(P));this._languageSettings.newlineAfterPipe&&u.DefaultAfterApplyPolicy===Kusto.Data.IntelliSense.ApplyPolicy.AppendPipePolicy&&(u.DefaultAfterApplyPolicy=this._newlineAppendPipePolicy);var i=e.filter(function(g){return!(g&&g.Value&&r.disabledCompletionItemsV1[g.Value]===g.Kind)}).map(function(g,v){var t=r.getTextToInsert(u,g),h=t.insertText,I=t.insertTextFormat,S=c.CslDocumentation.Instance.GetTopic(g),k=b.CompletionItem.create(g.Value);return k.kind=r.kustoKindToLsKind(g.Kind),k.insertText=h,k.insertTextFormat=I,k.sortText=r.getSortText(v+1),k.detail=S?S.ShortDescription:void 0,k.documentation=S?{value:S.LongDescription,kind:b.MarkupKind.Markdown}:void 0,k});return Promise.resolve(b.CompletionList.create(i))}return Promise.resolve(b.CompletionList.create([]))},p.prototype.doRangeFormat=function(n,o){if(!n)return Promise.resolve([]);var r=n.offsetAt(o.start),l=n.offsetAt(o.end),m=this.getFormattedCommandsInDocumentV2(n,r,l);return m.originalRange&&m.formattedCommands.length!==0?Promise.resolve([b.TextEdit.replace(m.originalRange,m.formattedCommands.join(""))]):Promise.resolve([])},p.prototype.doDocumentFormat=function(n){if(!n)return Promise.resolve([]);var o=n.positionAt(0),r=n.positionAt(n.getText().length),l=b.Range.create(o,r),m=this.getFormattedCommandsInDocumentV2(n).formattedCommands.join("");return Promise.resolve([b.TextEdit.replace(l,m)])},p.prototype.doCurrentCommandFormat=function(n,o){var r=n.offsetAt(o),l=this.createRange(n,r-1,r+1);return this.doRangeFormat(n,l)},p.prototype.doFolding=function(n){return n?this.getCommandsInDocument(n).then(function(o){return o.map(function(r){r.text.endsWith(`\r
`)?r.absoluteEnd-=2:(r.text.endsWith("\r")||r.text.endsWith(`
`))&&--r.absoluteEnd;var l=n.positionAt(r.absoluteStart),m=n.positionAt(r.absoluteEnd);return{startLine:l.line,startCharacter:l.character,endLine:m.line,endCharacter:m.character}})}):Promise.resolve([])},p.prototype.getClusterReferences=function(n,o){var r,l=this.parseDocumentV2(n),m=this.getCurrentCommandV2(l,o),y=(r=m?.Service)===null||r===void 0?void 0:r.GetClusterReferences();if(!y)return Promise.resolve([]);for(var C=[],f=new Set,P=0;P<y.Count;P++){var d=y.getItem(P),u=Kusto.Language.KustoFacts.GetHostName(d.Cluster);f.has(u)||(f.add(u),this._clustersSetInGlobalState.has(u)||C.push({clusterName:u}))}return Promise.resolve(C)},p.prototype.getDatabaseReferences=function(n,o){var r,l=this.parseDocumentV2(n),m=this.getCurrentCommandV2(l,o),y=(r=m?.Service)===null||r===void 0?void 0:r.GetDatabaseReferences();if(!y)return Promise.resolve([]);for(var C=[],f=new Set,P=0;P<y.Count;P++){var d=y.getItem(P),u=Kusto.Language.KustoFacts.GetHostName(d.Cluster),e=this.createDatabaseUniqueName(u,d.Database);f.has(e)||(f.add(e),this._nonEmptyDatabaseSetInGlobalState.has(e)||C.push({databaseName:d.Database,clusterName:d.Cluster}))}return Promise.resolve(C)},p.prototype.doValidation=function(n,o,r,l){var m=this;if(!n||!this.isIntellisenseV2())return Promise.resolve([]);var y=this.parseDocumentV2(n),C=this.toArray(y.Blocks);o.length>0&&(C=this.getAffectedBlocks(C,o));var f=C.map(function(d){var u=m.toArray(d.Service.GetDiagnostics()),e=r??m._languageSettings.enableQueryWarnings,i=l??m._languageSettings.enableQuerySuggestions;if(e||i){var g=d.Service.GetAnalyzerDiagnostics(!0),v=m.toArray(g).filter(function(t){var h,I=e&&t.Severity==="Warning"||i&&t.Severity==="Suggestion",S=!(!((h=m._languageSettings.disabledDiagnoticCodes)===null||h===void 0)&&h.includes(t.Code));return I&&S});u=u.concat(v)}return u}).reduce(function(d,u){return d.concat(u)},[]),P=this.toLsDiagnostics(f,n);return Promise.resolve(P)},p.prototype.toLsDiagnostics=function(n,o){return n.filter(function(r){return r.HasLocation}).map(function(r){var l,m=o.positionAt(r.Start),y=o.positionAt(r.Start+r.Length),C=b.Range.create(m,y);switch(r.Severity){case"Suggestion":l=b.DiagnosticSeverity.Information;break;case"Warning":l=b.DiagnosticSeverity.Warning;break;default:l=b.DiagnosticSeverity.Error}return b.Diagnostic.create(C,r.Message,l,r.Code)})},p.prototype.doColorization=function(n,o){var r=this;if(!n||!this._languageSettings.useSemanticColorization)return Promise.resolve([]);if(!this.isIntellisenseV2()){if(o.length>0){this.parseDocumentV1(n,c.ParseMode.CommandTokensOnly);var l=this.toArray(this._parser.Results).filter(function(u){return!!u&&o.some(function(e){var i=e.start,g=e.end;return u.AbsoluteStart>=i&&u.AbsoluteStart<=g||i>=u.AbsoluteStart&&i<=u.AbsoluteEnd+1})});if(!l||l.length===0)return Promise.resolve([{classifications:[],absoluteStart:o[0].start,absoluteEnd:o[0].end}]);var m=l.map(function(u){return r.parseTextV1(u.Text,c.ParseMode.TokenizeAllText),{classifications:M(r.getClassificationsFromParseResult(u.AbsoluteStart)),absoluteStart:u.AbsoluteStart,absoluteEnd:u.AbsoluteEnd}});return Promise.resolve(m)}this.parseDocumentV1(n,c.ParseMode.TokenizeAllText);var y=this.getClassificationsFromParseResult();return Promise.resolve([{classifications:M(y),absoluteStart:0,absoluteEnd:n.getText().length}])}var C=this.parseDocumentV2(n);if(o.length>0){var f=this.toArray(C.Blocks),P=this.getAffectedBlocks(f,o).map(function(u){return{classifications:M(r.toArray(u.Service.GetClassifications(u.Start,u.End).Classifications)),absoluteStart:u.Start,absoluteEnd:u.End}});return Promise.resolve(P)}var d=this.toArray(C.Blocks).map(function(u){return r.toArray(u.Service.GetClassifications(u.Start,u.Length).Classifications)}).reduce(function(u,e){return u.concat(e)},[]);return Promise.resolve([{classifications:M(d),absoluteStart:0,absoluteEnd:n.getText().length}])},p.prototype.getAffectedBlocks=function(n,o){return n.filter(function(r){return!!r&&o.some(function(l){var m=l.start,y=l.end;return r.Start>=m&&r.Start<=y||m>=r.Start&&m<=r.End+1})})},p.prototype.addClusterToSchema=function(n,o,r){var l=Kusto.Language.KustoFacts.GetHostName(o),m=this._kustoJsSchemaV2.GetCluster$1(l);if(m&&r.filter(function(f){return!m.GetDatabase(f)}).map(function(f){var P=new E.DatabaseSymbol.$ctor1(f,void 0,!1);m=m.AddDatabase(P)}),!m){var y=r.map(function(f){return new E.DatabaseSymbol.$ctor1(f,void 0,!1)}),C=new(j(E.DatabaseSymbol)).$ctor1(y);m=new E.ClusterSymbol.$ctor1(l,C,!1)}return this._kustoJsSchemaV2=this._kustoJsSchemaV2.AddOrReplaceCluster(m),this._script=s.CodeScript.From$1(n.getText(),this._kustoJsSchemaV2),Promise.resolve()},p.prototype.addDatabaseToSchema=function(n,o,r){var l=Kusto.Language.KustoFacts.GetHostName(o),m=this._kustoJsSchemaV2.GetCluster$1(l);m||(m=new E.ClusterSymbol.$ctor1(l,null,!1));var y=p.convertToDatabaseSymbol(r);return m=m.AddOrUpdateDatabase(y),this._kustoJsSchemaV2=this._kustoJsSchemaV2.AddOrReplaceCluster(m),this._script=s.CodeScript.From$1(n.getText(),this._kustoJsSchemaV2),Promise.resolve()},p.prototype.setSchema=function(n){var o=this;if(this._schema=n,this._languageSettings.useIntellisenseV2){var r=n&&n.clusterType==="Engine"?this.convertToKustoJsSchemaV2(n):null;this._kustoJsSchemaV2=r,this._script=void 0,this._parsePropertiesV2=void 0}return new Promise(function(l,m){var y=n?p.convertToKustoJsSchema(n):void 0;o._kustoJsSchema=y,o.createRulesProvider(y,n.clusterType),l(void 0)})},p.prototype.setParameters=function(n){if(!this._languageSettings.useIntellisenseV2||this._schema.clusterType!=="Engine")throw new Error("setParameters requires intellisense V2 and Engine cluster");this._schema.globalParameters=n;var o=n.map(function(r){return p.createParameterSymbol(r)});return this._kustoJsSchemaV2=this._kustoJsSchemaV2.WithParameters(p.toBridgeList(o)),Promise.resolve(void 0)},p.prototype.setSchemaFromShowSchema=function(n,o,r,l){var m=this;return this.normalizeSchema(n,o,r).then(function(y){return m.setSchema(__assign(__assign({},y),{globalParameters:l}))})},p.prototype.normalizeSchema=function(n,o,r){var l=Object.keys(n.Databases).map(function(y){return n.Databases[y]}).map(function(y){var C=y.Name,f=y.Tables,P=y.ExternalTables,d=y.MaterializedViews,u=y.Functions;return{name:C,minorVersion:y.MinorVersion,majorVersion:y.MajorVersion,tables:[].concat.apply([],[[f,"Table"],[d,"MaterializedView"],[P,"ExternalTable"]].filter(function(e){return e[0]}).map(function(e){var i=e[0],g=e[1];return Object.values(i).map(function(v){var t=v.Name,h=v.OrderedColumns;return{name:t,docstring:v.DocString,entityType:g,columns:h.map(function(I){var S=I.Name,k=(I.Type,I.DocString);return{name:S,type:I.CslType,docstring:k}})}})})),functions:Object.keys(u).map(function(e){return u[e]}).map(function(e){return{name:e.Name,body:e.Body,docstring:e.DocString,inputParameters:e.InputParameters.map(function(i){return{name:i.Name,type:i.Type,cslType:i.CslType,cslDefaultValue:i.CslDefaultValue,columns:i.Columns?i.Columns.map(function(g){return{name:g.Name,type:g.Type,cslType:g.CslType}}):i.Columns}})}})}}),m={clusterType:"Engine",cluster:{connectionString:o,databases:l},database:l.filter(function(y){return y.name===r})[0]};return Promise.resolve(m)},p.prototype.getSchema=function(){return Promise.resolve(this._schema)},p.prototype.getCommandInContext=function(n,o){return this.isIntellisenseV2()?this.getCommandInContextV2(n,o):this.getCommandInContextV1(n,o)},p.prototype.getCommandAndLocationInContext=function(n,o){if(!n||!this.isIntellisenseV2())return Promise.resolve(null);var r=this.parseDocumentV2(n),l=this.getCurrentCommandV2(r,o);if(!l)return Promise.resolve(null);var m=n.positionAt(l.Start),y=n.positionAt(l.End),C=b.Location.create(n.uri,b.Range.create(m,y)),f=l.Text;return Promise.resolve({text:f,location:C})},p.prototype.getCommandInContextV1=function(n,o){this.parseDocumentV1(n,c.ParseMode.CommandTokensOnly);var r=this.getCurrentCommand(n,o);return r?Promise.resolve(r.Text):Promise.resolve(null)},p.prototype.getCommandInContextV2=function(n,o){if(!n)return Promise.resolve(null);var r=this.parseDocumentV2(n),l=this.getCurrentCommandV2(r,o);return l?Promise.resolve(l.Text):Promise.resolve(null)},p.prototype.getCommandsInDocument=function(n){return n?this.isIntellisenseV2()?this.getCommandsInDocumentV2(n):this.getCommandsInDocumentV1(n):Promise.resolve([])},p.prototype.getCommandsInDocumentV1=function(n){this.parseDocumentV1(n,c.ParseMode.CommandTokensOnly);var o=this.toArray(this._parser.Results);return Promise.resolve(o.map(function(r){return{absoluteStart:r.AbsoluteStart,absoluteEnd:r.AbsoluteEnd,text:r.Text}}))},p.prototype.toPlacementStyle=function(n){if(n)switch(n){case"None":return s.PlacementStyle.None;case"NewLine":return s.PlacementStyle.NewLine;case"Smart":return s.PlacementStyle.Smart;default:throw new Error("Unknown PlacementStyle")}},p.prototype.getFormattedCommandsInDocumentV2=function(n,o,r){var l=this,m=this.parseDocumentV2(n),y=this.toArray(m.Blocks).filter(function(C){if(!C.Text||C.Text.trim()=="")return!1;if(o==null||r==null)return!0;for(var f=C.End,P=C.Text,d=P.length-1;d>=0&&(P[d]=="\r"||P[d]==`
`);d--)f--;return C.Start>o&&C.Start<r||f>o&&f<r||C.Start<=o&&f>=r||void 0});return y.length===0?{formattedCommands:[]}:{formattedCommands:y.map(function(C){var f,P,d=l._languageSettings.formatter,u=Kusto.Language.Editor.FormattingOptions.Default.WithIndentationSize((f=d?.indentationSize)!==null&&f!==void 0?f:4).WithInsertMissingTokens(!1).WithPipeOperatorStyle((P=l.toPlacementStyle(d?.pipeOperatorStyle))!==null&&P!==void 0?P:s.PlacementStyle.Smart).WithSemicolonStyle(Kusto.Language.Editor.PlacementStyle.None).WithBrackettingStyle(s.BrackettingStyle.Diagonal);return o==null||r==null||o===C.Start&&C.End,C.Service.GetFormattedText(u).Text}),originalRange:this.createRange(n,y[0].Start,y[y.length-1].End)}},p.prototype.getCommandsInDocumentV2=function(n){var o=this.parseDocumentV2(n),r=this.toArray(o.Blocks).filter(function(l){return l.Text.trim()!=""});return Promise.resolve(r.map(function(l){return{absoluteStart:l.Start,absoluteEnd:l.End,text:l.Text}}))},p.prototype.getClientDirective=function(n){var o={v:null},r=c.CslCommandParser.IsClientDirective(n,o);return Promise.resolve({isClientDirective:r,directiveWithoutLeadingComments:o.v})},p.prototype.getAdminCommand=function(n){var o={v:null},r=c.CslCommandParser.IsAdminCommand$1(n,o);return Promise.resolve({isAdminCommand:r,adminCommandWithoutLeadingComments:o.v})},p.prototype.findDefinition=function(n,o){if(!n||!this.isIntellisenseV2())return Promise.resolve([]);var r=this.parseDocumentV2(n),l=n.offsetAt(o),m=this.getCurrentCommandV2(r,l);if(!m)return Promise.resolve([]);var y=m.Service.GetRelatedElements(n.offsetAt(o)),C=this.toArray(y.Elements)[0];if(!C)return Promise.resolve([]);var f=n.positionAt(C.Start),P=n.positionAt(C.End),d=b.Range.create(f,P),u=b.Location.create(n.uri,d);return Promise.resolve([u])},p.prototype.findReferences=function(n,o){if(!n||!this.isIntellisenseV2())return Promise.resolve([]);var r=this.parseDocumentV2(n),l=n.offsetAt(o),m=this.getCurrentCommandV2(r,l);if(!m)return Promise.resolve([]);var y=m.Service.GetRelatedElements(n.offsetAt(o)),C=this.toArray(y.Elements);if(!C||C.length==0)return Promise.resolve([]);var f=C.map(function(P){var d=n.positionAt(P.Start),u=n.positionAt(P.End),e=b.Range.create(d,u);return b.Location.create(n.uri,e)});return Promise.resolve(f)},p.prototype.getQueryParams=function(n,o){if(!n||!this.isIntellisenseV2())return Promise.resolve([]);this.parseDocumentV2(n);var r=this.parseAndAnalyze(n,o),l=this.toArray(r.Syntax.GetDescendants(Kusto.Language.Syntax.QueryParametersStatement));if(!l||l.length==0)return Promise.resolve([]);var m=[];return l.forEach(function(y){y.WalkElements(function(C){return C.ReferencedSymbol&&C.ReferencedSymbol.Type?m.push({name:C.ReferencedSymbol.Name,type:C.ReferencedSymbol.Type.Name}):void 0})}),Promise.resolve(m)},p.prototype.getRenderInfo=function(n,o){var r=this,l=this.parseAndAnalyze(n,o);if(!l)return Promise.resolve(void 0);var m=this.toArray(l.Syntax.GetDescendants(Kusto.Language.Syntax.RenderOperator));if(!m||m.length===0)return Promise.resolve(void 0);var y=m[0],C=y.TextStart,f=y.End,P=y.ChartType.ValueText,d=y.WithClause;if(!d){var u={options:{visualization:P},location:{startOffset:C,endOffset:f}};return Promise.resolve(u)}var e=this.toArray(d.Properties).reduce(function(g,v){var t=v.Element$1.Name.SimpleName;switch(t){case"xcolumn":var h=v.Element$1.Expression.ReferencedSymbol.Name;g[t]=h;break;case"ycolumns":case"anomalycolumns":var I=r.toArray(v.Element$1.Expression.Names).map(function($){return $.Element$1.SimpleName});g[t]=I;break;case"ymin":case"ymax":var S=parseFloat(v.Element$1.Expression.ConstantValue);g[t]=S;break;case"title":case"xtitle":case"ytitle":case"visualization":case"series":var k=v.Element$1.Expression.ConstantValue;g[t]=k;break;case"xaxis":case"yaxis":var w=v.Element$1.Expression.ConstantValue;g[t]=w;break;case"legend":var T=v.Element$1.Expression.ConstantValue;g[t]=T;break;case"ysplit":var O=v.Element$1.Expression.ConstantValue;g[t]=O;break;case"accumulate":var V=v.Element$1.Expression.ConstantValue;g[t]=V;break;case"kind":var B=v.Element$1.Expression.ConstantValue;g[t]=B;break;default:D(t)}return g},{}),i={options:__assign({visualization:P},e),location:{startOffset:C,endOffset:f}};return Promise.resolve(i)},p.prototype.getReferencedGlobalParams=function(n,o){if(!n||!this.isIntellisenseV2())return Promise.resolve([]);var r=this.parseDocumentV2(n),l=this.getCurrentCommandV2(r,o);if(!l)return Promise.resolve([]);var m=l.Text,y=Kusto.Language.KustoCode.ParseAndAnalyze(m,this._kustoJsSchemaV2),C=this.toArray(this._kustoJsSchemaV2.Parameters),f=this.toArray(y.Syntax.GetDescendants(Kusto.Language.Syntax.Expression)).filter(function(P){return P.ReferencedSymbol!==null}).map(function(P){return P.ReferencedSymbol}).filter(function(P){return C.filter(function(d){return d===P}).length>0}).map(function(P){return{name:P.Name,type:P.Type.Name}});return Promise.resolve(f)},p.prototype.getGlobalParams=function(n){if(!this.isIntellisenseV2())return Promise.resolve([]);var o=this.toArray(this._kustoJsSchemaV2.Parameters).map(function(r){return{name:r.Name,type:r.Type.Name}});return Promise.resolve(o)},p.prototype.doRename=function(n,o,r){var l;if(!n||!this.isIntellisenseV2())return Promise.resolve(void 0);var m=this.parseDocumentV2(n),y=n.offsetAt(o),C=this.getCurrentCommandV2(m,y);if(!C)return Promise.resolve(void 0);var f=C.Service.GetRelatedElements(n.offsetAt(o)),P=this.toArray(f.Elements),d=P.filter(function(i){return i.Kind==s.RelatedElementKind.Declaration});if(!d||d.length==0)return Promise.resolve(void 0);var u=P.map(function(i){var g=n.positionAt(i.Start),v=n.positionAt(i.End),t=b.Range.create(g,v);return b.TextEdit.replace(t,r)}),e={changes:(l={},l[n.uri]=u,l)};return Promise.resolve(e)},p.prototype.doHover=function(n,o){if(!n||!this.isIntellisenseV2())return Promise.resolve(void 0);var r=this.parseDocumentV2(n),l=n.offsetAt(o),m=this.getCurrentCommandV2(r,l);if(!m||!m.Service.IsFeatureSupported(s.CodeServiceFeatures.QuickInfo,l))return Promise.resolve(void 0);var y=m.Service.GetQuickInfo(l);if(!y||!y.Items)return Promise.resolve(void 0);var C=this.toArray(y.Items);if(!C)return Promise.resolve(void 0);var f=(C=C.filter(function(P){return P.Kind!==s.QuickInfoKind.Error&&P.Kind!==s.QuickInfoKind.Suggestion&&P.Kind!==s.QuickInfoKind.Warning})).map(function(P){return P.Text.replace(`

`,`
* * *
`)}).join(`
* * *
`);return Promise.resolve({contents:f})},Object.defineProperty(p,"dummySchema",{get:function(){var n={majorVersion:0,minorVersion:0,name:"Kuskus",tables:[{name:"KustoLogs",columns:[{name:"Source",type:"string"},{name:"Timestamp",type:"datetime"},{name:"Directory",type:"string"}],docstring:"A dummy description to test that docstring shows as expected when hovering over a table"}],functions:[{name:"HowBig",inputParameters:[{name:"T",columns:[{name:"Timestamp",type:"System.DateTime",cslType:"datetime"}]}],docstring:"A dummy description to test that docstring shows as expected when hovering over a function",body:`{\r
    union \r
    (T | count | project V='Volume', Metric = strcat(Count/1e9, ' Billion records')),\r
    (T | summarize FirstRecord=min(Timestamp)| project V='Volume', Metric = strcat(toint((now()-FirstRecord)/1d), ' Days of data (from: ', format_datetime(FirstRecord, 'yyyy-MM-dd'),')')),\r
    (T | where Timestamp > ago(1h) | count | project V='Velocity', Metric = strcat(Count/1e6, ' Million records / hour')),\r
    (T | summarize Latency=now()-max(Timestamp) | project V='Velocity', Metric = strcat(Latency / 1sec, ' seconds latency')),\r
    (T | take 1 | project V='Variety', Metric=tostring(pack_all()))\r
    | order by V \r
}`},{name:"FindCIDPast24h",inputParameters:[{name:"clientActivityId",type:"System.String",cslType:"string"}],body:"{ KustoLogs | where Timestamp > now(-1d) | where ClientActivityId == clientActivityId}   "}]};return{clusterType:"Engine",cluster:{connectionString:"https://kuskus.kusto.windows.net;fed=true",databases:[n]},database:n}},enumerable:!1,configurable:!0}),p.convertToEntityDataType=function(n){},p.convertToKustoJsSchema=function(n){switch(n.clusterType){case"Engine":var o=n.database?n.database.name:void 0,r=new c.KustoIntelliSenseClusterEntity,l=void 0;r.ConnectionString=n.cluster.connectionString;var m=[];return n.cluster.databases.forEach(function(y){var C=new c.KustoIntelliSenseDatabaseEntity;C.Name=y.name;var f=[];y.tables.forEach(function(d){var u=new c.KustoIntelliSenseTableEntity;u.Name=d.name;var e=[];d.columns.forEach(function(i){var g=new c.KustoIntelliSenseColumnEntity;g.Name=i.name,g.TypeCode=c.EntityDataType[_.getEntityDataTypeFromCslType(i.type)],e.push(g)}),u.Columns=new Bridge.ArrayEnumerable(e),f.push(u)});var P=[];y.functions.forEach(function(d){var u=new c.KustoIntelliSenseFunctionEntity;u.Name=d.name,u.CallName=G.getCallName(d),u.Expression=G.getExpression(d),P.push(u)}),C.Tables=new Bridge.ArrayEnumerable(f),C.Functions=new Bridge.ArrayEnumerable(P),m.push(C),y.name==o&&(l=C)}),r.Databases=new Bridge.ArrayEnumerable(m),new c.KustoIntelliSenseQuerySchema(r,l);case"ClusterManager":return{accounts:n.accounts.map(function(y){var C=new c.KustoIntelliSenseAccountEntity;return C.Name=y,C}),services:n.services.map(function(y){var C=new c.KustoIntelliSenseServiceEntity;return C.Name=y,C}),connectionString:n.connectionString};case"DataManagement":return;default:return D(n)}},p.scalarParametersToSignature=function(n){return"("+n.map(function(o){return o.name+": "+o.cslType}).join(", ")+")"},p.inputParameterToSignature=function(n){var o=this;return"("+n.map(function(r){if(r.columns){var l=o.scalarParametersToSignature(r.columns);return r.name+": "+l}return r.name+": "+r.cslType}).join(", ")+")"},p.toLetStatement=function(n){var o=this.inputParameterToSignature(n.inputParameters);return"let "+n.name+" = "+o+" "+n.body},p.createColumnSymbol=function(n){return new E.ColumnSymbol(n.name,E.ScalarTypes.GetSymbol(_.getCslTypeNameFromClrType(n.type)),n.docstring,null)},p.createParameterSymbol=function(n){var o=Kusto.Language.Symbols.ScalarTypes.GetSymbol(_.getCslTypeNameFromClrType(n.type));return new E.ParameterSymbol(n.name,o,null)},p.createParameter=function(n){if(!n.columns){var o=Kusto.Language.Symbols.ScalarTypes.GetSymbol(_.getCslTypeNameFromClrType(n.type)),r=n.cslDefaultValue&&typeof n.cslDefaultValue=="string"?x.QueryParser.ParseLiteral$1(n.cslDefaultValue):void 0;return new E.Parameter.$ctor3(n.name,o,null,null,null,!1,null,1,1,r,null)}if(n.columns.length==0)return new E.Parameter.ctor(n.name,E.ParameterTypeKind.Tabular,E.ArgumentKind.Expression,null,null,!1,null,1,1,null,null);var l=new E.TableSymbol.ctor(n.columns.map(function(m){return p.createColumnSymbol(m)}));return new E.Parameter.$ctor2(n.name,l)},p.convertToDatabaseSymbol=function(n){return function(o){var r=o.tables?o.tables.map(function(m){return function(y){var C,f=y.columns.map(function(u){return p.createColumnSymbol(u)}),P=new E.TableSymbol.$ctor4(y.name,f);switch(P.Description=y.docstring,y.entityType){case"MaterializedViewTable":var d=(C=y.mvQuery)!==null&&C!==void 0?C:null;P=(P=new E.MaterializedViewSymbol.$ctor2(y.name,P.Columns,d,y.docstring)).WithIsMaterializedView(!0);break;case"ExternalTable":P=P.WithIsExternal(!0)}return P}(m)}):[],l=o.functions?o.functions.map(function(m){return C=(y=m).inputParameters.map(function(f){return p.createParameter(f)}),new E.FunctionSymbol.$ctor16(y.name,y.body,p.toBridgeList(C),y.docstring);var y,C}):[];return new E.DatabaseSymbol.ctor(o.name,r.concat(l))}(n)},p.prototype.convertToKustoJsSchemaV2=function(n){var o=this._schemaCache[n.cluster.connectionString];o||(this._schemaCache[n.cluster.connectionString]={},o=this._schemaCache[n.cluster.connectionString]);var r=n.cluster.databases.reduce(function(u,e){return u[e.name]=e},{});Object.keys(o).map(function(u){r[u]||delete o.dbName});var l=L.Default,m=n.database?n.database.name:void 0,y=void 0,C=n.cluster.databases.map(function(u){var e=u.name===m,i=o[u.name];if(!i||i.database.majorVersion<u.majorVersion||e&&!i.includesFunctions){var g=p.convertToDatabaseSymbol(u);o[u.name]={database:u,symbol:g,includesFunctions:e}}var v=o[u.name].symbol;return u.name===m&&(y=v),v}),f=n.cluster.connectionString.match(/(.*\/\/)?([^\/;]*)/)[2].split(".")[0],P=new E.ClusterSymbol.ctor(f,C);if(l=l.WithCluster(P),y&&(l=l.WithDatabase(y)),n.globalParameters){var d=n.globalParameters.map(function(u){return p.createParameterSymbol(u)});l=l.WithParameters(p.toBridgeList(d))}return l},p.prototype.getClassificationsFromParseResult=function(n){var o=this;return n===void 0&&(n=0),this.toArray(this._parser.Results).map(function(r){return o.toArray(r.Tokens)}).reduce(function(r,l){return r.concat(l)},[]).map(function(r){return new s.ClassifiedRange(o.tokenKindToClassificationKind(r.TokenKind),r.AbsoluteStart+n,r.Length)})},p.trimTrailingNewlineFromRange=function(n,o,r,l){for(var m=n.length-1;n[m]==="\r"||n[m]===`
`;)--m;var y=o+m+1,C=r.positionAt(y);return b.Range.create(l.start,C)},p.prototype.getSortText=function(n){if(n<=0)throw new RangeError("order should be a number >= 1. instead got "+n);for(var o="",r=Math.floor(n/26),l=0;l<r;++l)o+="z";var m=n%26;return m>0&&(o+=String.fromCharCode(96+m)),o},p.prototype.parseTextV1=function(n,o){this._parser.Parse(this._schema.clusterType==="Engine"?this._rulesProvider:null,n,o)},p.prototype.parseDocumentV1=function(n,o){this._parsePropertiesV1&&!this._parsePropertiesV1.isParseNeeded(n,this._rulesProvider,o)||(this.parseTextV1(n.getText(),o),this._parsePropertiesV1=new N(n.version,n.uri,this._rulesProvider,o))},p.prototype.parseDocumentV2=function(n){return this._parsePropertiesV2&&!this._parsePropertiesV2.isParseNeeded(n,this._rulesProvider)||(this._script?this._script=this._script.WithText(n.getText()):this._script=s.CodeScript.From$1(n.getText(),this._kustoJsSchemaV2),this._parsePropertiesV2=new N(n.version,n.uri)),this._script},p.prototype.getCurrentCommand=function(n,o){var r=this.toArray(this._parser.Results),l=r.filter(function(m){return m.AbsoluteStart<=o&&m.AbsoluteEnd>=o})[0];return l||(l=r.filter(function(m){return m.AbsoluteStart<=o&&m.AbsoluteEnd+1>=o})[0])&&!l.Text.endsWith(`\r
\r
`)?l:null},p.prototype.getCurrentCommandV2=function(n,o){return n.GetBlockAtPosition(o)},p.prototype.getTextToInsert=function(n,o){var r=n.GetBeforeApplyInfo(o.Value),l=n.GetAfterApplyInfo(o.Value),m=r.Text||""+o.Value+l.Text||"",y=b.InsertTextFormat.PlainText;if(l.OffsetToken&&l.OffsetPosition){var C=m.indexOf(l.OffsetToken);C>=0&&(m=this.insertToString(m,"$0",C-m.length+l.OffsetPosition),y=b.InsertTextFormat.Snippet)}else l.OffsetPosition&&(m=this.insertToString(m,"$0",l.OffsetPosition),y=b.InsertTextFormat.Snippet);return{insertText:m,insertTextFormat:y}},p.prototype.insertToString=function(n,o,r){var l=n.length+r;return r>=0||l<0?n:n.substring(0,l)+o+n.substring(l)},p.prototype.getCommandWithoutLastWord=function(n){var o=K("[\\w_]*$","s");return n.replace(o,"")},p.prototype.createRulesProvider=function(n,o){var r=new(j(String)),l=new(j(String));if(this._parser=new c.CslCommandParser,o!="Engine")if(o!=="DataManagement"){var m=n,y=m.accounts,C=m.services,f=m.connectionString;new c.KustoIntelliSenseAccountEntity,new c.KustoIntelliSenseServiceEntity,this._rulesProvider=new c.ClusterManagerIntelliSenseRulesProvider.$ctor1(new Bridge.ArrayEnumerable(y),new Bridge.ArrayEnumerable(C),f)}else this._rulesProvider=new c.DataManagerIntelliSenseRulesProvider(null);else{var P=n;this._rulesProvider=this._languageSettings&&this._languageSettings.includeControlCommands?new c.CslIntelliSenseRulesProvider.$ctor1(P.Cluster,P,r,l,null,!0,!0):new c.CslQueryIntelliSenseRulesProvider.$ctor1(P.Cluster,P,r,l,null,null,null)}},p.prototype.kustoKindToLsKind=function(n){var o=this._kustoKindtolsKind[n];return o||b.CompletionItemKind.Variable},p.prototype.kustoKindToLsKindV2=function(n){var o=this._kustoKindToLsKindV2[n];return o||b.CompletionItemKind.Variable},p.prototype.createRange=function(n,o,r){return b.Range.create(n.positionAt(o),n.positionAt(r))},p.prototype.toArray=function(n){return Bridge.toArray(n)},p.toBridgeList=function(n){return new(System.Collections.Generic.List$1(System.Object)).$ctor1(n)},p.prototype.tokenKindToClassificationKind=function(n){return this._tokenKindToClassificationKind[n]||s.ClassificationKind.PlainText},p.prototype.parseAndAnalyze=function(n,o){if(n&&this.isIntellisenseV2()){var r=this.parseDocumentV2(n),l=this.getCurrentCommandV2(r,o);if(l){var m=l.Text;return Kusto.Language.KustoCode.ParseAndAnalyze(m,this._kustoJsSchemaV2)}}},p}(),F=new U(U.dummySchema,{includeControlCommands:!0,useIntellisenseV2:!0,useSemanticColorization:!0});a.getKustoLanguageService=function(){return F}}),define("vs/language/kusto/kustoWorker",["require","exports","./languageService/kustoLanguageService","vscode-languageserver-types"],function(R,a,G,b){"use strict";Object.defineProperty(a,"__esModule",{value:!0}),a.create=a.KustoWorker=void 0;var K=function(){function _(c,x){this._ctx=c,this._languageSettings=x.languageSettings,this._languageService=G.getKustoLanguageService(),this._languageService.configure(this._languageSettings)}return _.prototype.setSchema=function(c){return this._languageService.setSchema(c)},_.prototype.addClusterToSchema=function(c,x,s){var E=this._getTextDocument(c);return E?this._languageService.addClusterToSchema(E,x,s):(console.error("addClusterToSchema: document is "+E+". uri is "+c),Promise.resolve())},_.prototype.addDatabaseToSchema=function(c,x,s){var E=this._getTextDocument(c);return E?this._languageService.addDatabaseToSchema(E,x,s):(console.error("addDatabaseToSchema: document is "+E+". uri is "+c),Promise.resolve())},_.prototype.setSchemaFromShowSchema=function(c,x,s){return this._languageService.setSchemaFromShowSchema(c,x,s)},_.prototype.normalizeSchema=function(c,x,s){return this._languageService.normalizeSchema(c,x,s)},_.prototype.getSchema=function(){return this._languageService.getSchema()},_.prototype.getCommandInContext=function(c,x){var s=this._getTextDocument(c);if(!s)return console.error("getCommandInContext: document is "+s+". uri is "+c),null;var E=this._languageService.getCommandInContext(s,x);return E===void 0?null:E},_.prototype.getQueryParams=function(c,x){var s=this._getTextDocument(c);if(!s)return console.error("getQueryParams: document is "+s+". uri is "+c),null;var E=this._languageService.getQueryParams(s,x);return E===void 0?null:E},_.prototype.getGlobalParams=function(c){var x=this._getTextDocument(c);if(!x)return console.error("getGLobalParams: document is "+x+". uri is "+c),null;var s=this._languageService.getGlobalParams(x);return s===void 0?null:s},_.prototype.getReferencedGlobalParams=function(c,x){var s=this._getTextDocument(c);if(!s)return console.error("getReferencedGlobalParams: document is "+s+". uri is "+c),null;var E=this._languageService.getReferencedGlobalParams(s,x);return E===void 0?null:E},_.prototype.getRenderInfo=function(c,x){var s=this._getTextDocument(c);return s||console.error("getRenderInfo: document is "+s+". uri is "+c),this._languageService.getRenderInfo(s,x).then(function(E){return E||null})},_.prototype.getCommandAndLocationInContext=function(c,x){var s=this._getTextDocument(c);return s?this._languageService.getCommandAndLocationInContext(s,x).then(function(E){if(!E)return null;var L=E.text,j=E.location.range,D=j.start,A=j.end;return{range:new monaco.Range(D.line+1,D.character+1,A.line+1,A.character+1),text:L}}):(console.error("getCommandAndLocationInContext: document is "+s+". uri is "+c),Promise.resolve(null))},_.prototype.getCommandsInDocument=function(c){var x=this._getTextDocument(c);return x?this._languageService.getCommandsInDocument(x):(console.error("getCommandInDocument: document is "+x+". uri is "+c),null)},_.prototype.doComplete=function(c,x){var s=this._getTextDocument(c);return s?this._languageService.doComplete(s,x):null},_.prototype.doValidation=function(c,x,s,E){var L=this._getTextDocument(c);return this._languageService.doValidation(L,x,s,E)},_.prototype.doRangeFormat=function(c,x){var s=this._getTextDocument(c);return this._languageService.doRangeFormat(s,x)},_.prototype.doFolding=function(c){var x=this._getTextDocument(c);return this._languageService.doFolding(x)},_.prototype.doDocumentFormat=function(c){var x=this._getTextDocument(c);return this._languageService.doDocumentFormat(x)},_.prototype.doCurrentCommandFormat=function(c,x){var s=this._getTextDocument(c);return this._languageService.doCurrentCommandFormat(s,x)},_.prototype.doColorization=function(c,x){var s=this._getTextDocument(c);return this._languageService.doColorization(s,x)},_.prototype.getClientDirective=function(c){return this._languageService.getClientDirective(c)},_.prototype.getAdminCommand=function(c){return this._languageService.getAdminCommand(c)},_.prototype.findDefinition=function(c,x){var s=this._getTextDocument(c);return this._languageService.findDefinition(s,x)},_.prototype.findReferences=function(c,x){var s=this._getTextDocument(c);return this._languageService.findReferences(s,x)},_.prototype.doRename=function(c,x,s){var E=this._getTextDocument(c);return this._languageService.doRename(E,x,s)},_.prototype.doHover=function(c,x){var s=this._getTextDocument(c);return this._languageService.doHover(s,x)},_.prototype.setParameters=function(c){return this._languageService.setParameters(c)},_.prototype.getClusterReferences=function(c,x){var s=this._getTextDocument(c);return s?this._languageService.getClusterReferences(s,x):Promise.resolve(null)},_.prototype.getDatabaseReferences=function(c,x){var s=this._getTextDocument(c);return s?this._languageService.getDatabaseReferences(s,x):Promise.resolve(null)},_.prototype._getTextDocument=function(c){for(var x=0,s=this._ctx.getMirrorModels();x<s.length;x++){var E=s[x];if(E.uri.toString()===c)return b.TextDocument.create(c,this._languageId,E.version,E.getValue())}return null},_}();a.KustoWorker=K,a.create=function(_,c){return new K(_,c)}});

//# sourceMappingURL=kustoWorker.js.map