import { getFooterLinks, FooterLink } from 'app/core/components/Footer/Footer';

import { processFooterLinks, defaultLinksChanged } from './footerLinks';

describe('processFooterLinks', () => {
  it('should add correct icons to the links', () => {
    const links = [
      { text: 'Google', url: 'google.com' },
      { text: 'Community', url: 'discord.com' },
      { text: 'Documentation', url: 'docs.com' },
    ];

    expect(processFooterLinks(links).map((link) => link.icon)).toEqual([
      'external-link-alt',
      'comments-alt',
      'document-info',
    ]);
  });
});

describe('defaultLinksChanged', () => {
  it('should detect that default links did not change', () => {
    const defaultLinks = getFooterLinks();
    {
      expect(defaultLinksChanged(defaultLinks, defaultLinks)).toBe(false);
    }
    {
      const links: FooterLink[] = [
        {
          text: 'Documentation',
          url: 'https://grafana.com/docs/grafana/latest/?utm_source=grafana_footer',
        },
        {
          text: 'Support',
          url: 'https://grafana.com/products/enterprise/?utm_source=grafana_footer',
        },
        {
          text: 'Community',
          url: 'https://community.grafana.com/?utm_source=grafana_footer',
        },
      ];
      expect(defaultLinksChanged(links, defaultLinks)).toBe(false);
    }
  });

  it('should detect that default links have changed', () => {
    const defaultLinks = getFooterLinks();
    {
      const links: FooterLink[] = [
        {
          text: 'Documentation',
          icon: 'document-info',
          url: 'https://grafana.com/docs/grafana/latest/?utm_source=grafana_footer',
          target: '_blank',
        },
        {
          text: 'Support',
          icon: 'question-circle',
          url: 'custom.url',
          target: '_blank',
        },
        {
          text: 'Community',
          icon: 'comments-alt',
          url: 'https://community.grafana.com/?utm_source=grafana_footer',
          target: '_blank',
        },
      ];
      expect(defaultLinksChanged(links, defaultLinks)).toBe(true);
    }
    {
      const links: FooterLink[] = [
        {
          text: 'Documentation',
          url: 'https://grafana.com/docs/grafana/latest/?utm_source=grafana_footer',
        },
        {
          text: 'Support',
          url: 'https://grafana.com/products/enterprise/?utm_source=grafana_footer',
        },
        {
          text: 'Communities',
          url: 'https://community.grafana.com/?utm_source=grafana_footer',
        },
      ];
      expect(defaultLinksChanged(links, defaultLinks)).toBe(true);
    }
  });
});
