import { FooterLink } from 'app/core/components/Footer/Footer';

export type LoginPageData = {
  loginLogo: string | File;
  loginTitle: string;
  loginSubtitle: string;
  loginBackground: string | File;
  loginBoxBackground: string | File;
};

export type FooterData = {
  footerLinks: FooterLink[];
};

export type OtherSectionData = {
  appTitle: string;
  favIcon: string;
  menuLogo: string | File;
  loadingLogo: string | File;
  appleTouchIcon: string | File;
};

export type ContentType = 'url' | 'file' | 'color';

export type TypeOptions = Array<{ label: string; value: ContentType }>;
export type ConfigData = LoginPageData & FooterData & OtherSectionData;

export interface BrandingSettingsDTO {
  footerLinks: FooterLink[] | null;
  appTitle: string;
  loginSubtitle: string;
  loginTitle: string;
  loginLogo: string;
  loginBackground: string;
  loginBoxBackground: string;
  menuLogo: string;
  favIcon: string;
  loadingLogo: string;
  appleTouchIcon: string;
}
