Bridge.assembly("Kusto.JavaScript.Client",(function(e,t){"use strict";Bridge.define("Kusto.Charting.AnomalyDataHelper2",{statics:{props:{TimestampColumnName:null,ValueColumnName:null,SeriesColumnName:null,AnomalySerieSuffix:null},ctors:{init:function(){this.TimestampColumnName="Timestamp",this.ValueColumnName="Value",this.SeriesColumnName="Series",this.AnomalySerieSuffix="(anomaly)"}},methods:{EnchanceDataWithAnomalyDataFromServiceAsync:function(t,n){var s,i,r,a,o,l,u,d=0,m=new System.Threading.Tasks.TaskCompletionSource,c=Bridge.fn.bind(this,(function(){try{for(;;)switch(d=System.Array.min([0,1],d)){case 0:if(null==t)return void m.setResult(n);if(r=Kusto.Charting.AnomalyDataHelper2.DataItemsToDataTableLiteral(n),a=(r||"")+(System.String.format("| summarize dt = makelist({0}, 100000), y=makelist({1}, 100000) by {2}\r\n| extend (anomalies, scores, baseline)=series_decompose_anomalies(y)\r\n| project dt, y, anomalies, Series\r\n| mvexpand dt to typeof(datetime), y to typeof(double), anomalies to typeof(double) limit 1000000\r\n| where anomalies != 0\r\n| project dt, anomaly_value = (anomalies * anomalies)*y, Series",Kusto.Charting.AnomalyDataHelper2.TimestampColumnName,Kusto.Charting.AnomalyDataHelper2.ValueColumnName,Kusto.Charting.AnomalyDataHelper2.SeriesColumnName)||""),s=t.Kusto$Charting$IKustoClientContext$ExecuteQueryAsync(Kusto.Charting.AnomalyDataHelper2.AnomalyInputOutputRecord,a),d=1,s.isCompleted())continue;return void s.continue(c);case 1:return i=s.getAwaitedResult(),o=i,l=Kusto.Charting.AnomalyDataHelper2.AnomalyInputOutputRecord,null!=(o=System.Linq.Enumerable.from(o,l).ToArray(l))&&System.Linq.Enumerable.from(o,Kusto.Charting.AnomalyDataHelper2.AnomalyInputOutputRecord).any()?(n.AddRange(System.Linq.Enumerable.from(o,Kusto.Charting.AnomalyDataHelper2.AnomalyInputOutputRecord).select(e.$.Kusto.Charting.AnomalyDataHelper2.f1)),void m.setResult(n)):void m.setResult(n);default:return void m.setResult(null)}}catch(e){u=System.Exception.create(e),m.setException(u)}}),arguments);return c(),m.task},DataItemsToDataTableLiteral:function(e){var t,n,s,i=new System.Text.StringBuilder;i.append("datatable"),i.appendLine(System.String.format("({0}:datetime,{1}:double,{2}:string)",Kusto.Charting.AnomalyDataHelper2.TimestampColumnName,Kusto.Charting.AnomalyDataHelper2.ValueColumnName,Kusto.Charting.AnomalyDataHelper2.SeriesColumnName)),i.append("["),t=Bridge.getEnumerator(e,Kusto.Charting.DataItem);try{for(;t.moveNext();)n=t.Current,i.append("datetime("),i.append(System.DateTime.format(n.ArgumentDateTime,"o")),i.append("),"),i.append("double("),i.append(System.Double.format(n.ValueData)),i.append("),"),s=Kusto.Cloud.Platform.Text.StringLiteral.GetLiteral(n.SeriesName),i.append(s),i.appendLine(",")}finally{Bridge.is(t,System.IDisposable)&&t.System$IDisposable$Dispose()}return i.appendLine("]"),i.toString()},EnchanceDataWithAnomalyDataFromColumns:function(t,n,s){var i,r,a,o,l,u,d,m,c,p,S,g;s.v=new(System.Collections.Generic.Dictionary$2(System.String,System.String).ctor);var h=new(System.Collections.Generic.List$1(Kusto.Charting.DataItem).ctor),y=new(System.Collections.Generic.HashSet$1(System.String).$ctor1)(n),f=System.Linq.Enumerable.from(t,Kusto.Charting.DataItem).where((function(e){return!y.contains(e.ValueName)})).select(e.$.Kusto.Charting.AnomalyDataHelper2.f2).firstOrDefault(null,null);if(System.String.isNullOrEmpty(f))return t;h.AddRange(System.Linq.Enumerable.from(t,Kusto.Charting.DataItem).where((function(e){return!y.contains(e.ValueName)}))),a=System.Linq.Enumerable.from(t,Kusto.Charting.DataItem).where((function(e){return System.String.equals(e.ValueName,f)})).ToArray(Kusto.Charting.DataItem),i=Bridge.getEnumerator(n);try{for(;i.moveNext();){if(o={v:i.Current},l=System.Linq.Enumerable.from(t,Kusto.Charting.DataItem).where(function(e,t){return function(e){return System.String.equals(e.ValueName,t.v)}}(0,o)).ToArray(Kusto.Charting.DataItem),a.length!==l.length)return t;for(u=0,d=0;d<a.length;d=d+1|0)m=a[System.Array.index(d,a)],0!==(c=l[System.Array.index(d,l)]).ValueData&&(u=u+1|0,p=(c.SeriesName||"")+(Kusto.Charting.AnomalyDataHelper2.AnomalySerieSuffix||""),(r=new Kusto.Charting.DataItem).ArgumentDateTime=c.ArgumentDateTime,r.ArgumentData=c.ArgumentData,r.SeriesName=p,r.ValueData=m.ValueData,r.PrefferredChartKind=Kusto.Charting.ChartKind.Point,S=r,h.add(S),s.v.containsKey(p)||s.v.add(p,m.SeriesName));0===u&&((r=new Kusto.Charting.DataItem).ArgumentDateTime=l[System.Array.index(0,l)].ArgumentDateTime,r.ArgumentData=null,r.SeriesName=(l[System.Array.index(0,l)].SeriesName||"")+(Kusto.Charting.AnomalyDataHelper2.AnomalySerieSuffix||""),r.ValueData=Number.NaN,r.PrefferredChartKind=Kusto.Charting.ChartKind.Point,g=r,h.add(g))}}finally{Bridge.is(i,System.IDisposable)&&i.System$IDisposable$Dispose()}return h}}}}),Bridge.ns("Kusto.Charting.AnomalyDataHelper2",e.$),Bridge.apply(e.$.Kusto.Charting.AnomalyDataHelper2,{f1:function(e){var t;return(t=new Kusto.Charting.DataItem).ArgumentDateTime=e.Timestamp,t.ArgumentData=System.DateTime.format(e.Timestamp,"o"),t.SeriesName=(e.Series||"")+(Kusto.Charting.AnomalyDataHelper2.AnomalySerieSuffix||""),t.ValueData=e.Value,t.PrefferredChartKind=Kusto.Charting.ChartKind.Point,t},f2:function(e){return e.ValueName}}),Bridge.define("Kusto.Charting.AnomalyDataHelper2.AnomalyInputOutputRecord",{$kind:"nested class",fields:{Timestamp:null,Value:0,Series:null},ctors:{init:function(){this.Timestamp=System.DateTime.getDefaultValue()}}}),Bridge.define("Kusto.Charting.ArgumentColumnType",{$kind:"enum",statics:{fields:{None:0,Numeric:2,DateTime:4,TimeSpan:8,String:16,Object:32,Geospatial:64,DateTimeOrTimeSpan:12,StringOrDateTimeOrTimeSpan:28,NumericOrDateTimeOrTimeSpan:14,StringOrObject:48,AllExceptGeospatial:62}},$flags:!0}),Bridge.define("Kusto.Charting.ArgumentRestrictions",{$kind:"enum",statics:{fields:{None:0,MustHave:1,NotIncludedInSeries:2,GeospatialAsSeries:4}},$flags:!0}),Bridge.define("Kusto.Charting.ChartKind",{$kind:"enum",statics:{fields:{Unspecified:0,Line:1,Point:2,Bar:3}}}),Bridge.define("Kusto.Charting.ChartLimitsPolicy",{props:{MaxPointsPerChartError:0,MaxPointsPerChartWarning:0,MaxSeriesPerChartError:0,MaxSeriesPerChartWarning:0,MaxDatetimePeriodError:null},ctors:{init:function(){this.MaxDatetimePeriodError=new System.TimeSpan},ctor:function(e,t,n,s,i){this.$initialize(),this.MaxPointsPerChartError=e,this.MaxPointsPerChartWarning=t,this.MaxSeriesPerChartError=n,this.MaxSeriesPerChartWarning=s,this.MaxDatetimePeriodError=i}}}),Bridge.define("Kusto.Charting.DataChartsHelper",{statics:{fields:{c_minFractionOfIntervalsToDetectDistribution:0,c_minElementsAmountToFillGapsWithNans:0,c_decimalRoundingPrecision:0,c_doubleAcceptableApproximation:0,c_defaultArgumentNumeric:0,c_defaultArgumentString:null,c_defaultArgumentDatetime:null},ctors:{init:function(){this.c_defaultArgumentDatetime=System.DateTime.getDefaultValue(),this.c_minFractionOfIntervalsToDetectDistribution=.8,this.c_minElementsAmountToFillGapsWithNans=4,this.c_decimalRoundingPrecision=8,this.c_doubleAcceptableApproximation=1e-8,this.c_defaultArgumentNumeric=Number.NaN,this.c_defaultArgumentString="<empty>",this.c_defaultArgumentDatetime=Bridge.getDefaultValue(System.DateTime)}},methods:{GetData:function(e,t,n,s,i,r,a){void 0===t&&(t=16),void 0===n&&(n=0),void 0===s&&(s=null),void 0===i&&(i=!1),void 0===r&&(r=null),void 0===a&&(a=null);var o=Kusto.Charting.DataChartsHelper.GetMetaData(e,t,n,s,r,a);return Kusto.Charting.DataChartsHelper.GetData$1(e,o,i)},GetData$1:function(t,n,s){var i,r;if(void 0===s&&(s=!1),null==t||null==n)return System.Linq.Enumerable.empty();var a=t.Kusto$Charting$IChartingDataSource$GetSchema(),o=System.Linq.Enumerable.from(a,System.Tuple$2(System.String,Kusto.Charting.ArgumentColumnType)).select(e.$.Kusto.Charting.DataChartsHelper.f1).toList(Kusto.Charting.DataChartsHelper.ColumnDesc),l=System.Linq.Enumerable.from(n.Kusto$Charting$IChartMetaData$SeriesIndexes,System.Int32).any()?System.Linq.Enumerable.from(o,Kusto.Charting.DataChartsHelper.ColumnDesc).where((function(e){return System.Linq.Enumerable.from(n.Kusto$Charting$IChartMetaData$SeriesIndexes,System.Int32).contains(e.Index)})).ToArray(Kusto.Charting.DataChartsHelper.ColumnDesc):null,u=System.Linq.Enumerable.from(o,Kusto.Charting.DataChartsHelper.ColumnDesc).where((function(e){return System.Linq.Enumerable.from(n.Kusto$Charting$IChartMetaData$DataIndexes,System.Int32).contains(e.Index)})).ToArray(Kusto.Charting.DataChartsHelper.ColumnDesc),d=System.Linq.Enumerable.from(o,Kusto.Charting.DataChartsHelper.ColumnDesc).where((function(e){return System.Linq.Enumerable.from(n.Kusto$Charting$IChartMetaData$UnusedIndexes,System.Int32).contains(e.Index)})).ToArray(Kusto.Charting.DataChartsHelper.ColumnDesc),m=new Kusto.Charting.DataChartsHelper.ArgumentData(n.Kusto$Charting$IChartMetaData$ArgumentDataColumnIndex,-1!==n.Kusto$Charting$IChartMetaData$ArgumentDataColumnIndex?o.getItem(n.Kusto$Charting$IChartMetaData$ArgumentDataColumnIndex).Name:"",-1!==n.Kusto$Charting$IChartMetaData$ArgumentDataColumnIndex?System.Linq.Enumerable.from(a,System.Tuple$2(System.String,Kusto.Charting.ArgumentColumnType)).elementAt(n.Kusto$Charting$IChartMetaData$ArgumentDataColumnIndex).Item2:Kusto.Charting.ArgumentColumnType.None,n.Kusto$Charting$IChartMetaData$ArgumentColumnType,n.Kusto$Charting$IChartMetaData$GeospatialColumnIndexes),c=new(System.Collections.Generic.List$1(Kusto.Charting.DataItem).ctor),p=new(System.Collections.Generic.Dictionary$2(System.String,System.Double).ctor);for(i=0;i<t.Kusto$Charting$IChartingDataSource$RowsCount;i=i+1|0)r=Kusto.Charting.DataChartsHelper.GetBaseSeriesName(t,l,i),n.Kusto$Charting$IChartMetaData$IsDataFormedAsSeries?Kusto.Charting.DataChartsHelper.ResolveDataSeriesFromDataRow(c,t,u,d,i,r,n.Kusto$Charting$IChartMetaData$ArgumentColumnType,s,n.Kusto$Charting$IChartMetaData$ArgumentDataColumnIndex):(m.ResolveArgumentFromRow(t,i),Kusto.Charting.DataChartsHelper.ResolveDataItemsFromDataRow(c,t,u,d,i,r,m,p,s));return c},GetMetaData:function(t,n,s,i,r,a){var o,l,u,d,m;return void 0===n&&(n=16),void 0===s&&(s=0),void 0===i&&(i=null),void 0===r&&(r=null),void 0===a&&(a=null),null!=(o=t.Kusto$Charting$IChartingDataSource$GetSchema())&&System.Linq.Enumerable.from(o,System.Tuple$2(System.String,Kusto.Charting.ArgumentColumnType)).any()?(null==i&&(i=new(System.Collections.Generic.List$1(System.String).ctor)),null==a&&(a=new(System.Collections.Generic.List$1(System.String).ctor)),l={v:new Kusto.Charting.DataChartsHelper.ChartMetaData(n)},Kusto.Charting.DataChartsHelper.ResolvePredefinedColumnsIndexes(t,i,a,r,s,l),u=!1,l.v.IsDataFormedAsSeries||(u=Kusto.Charting.DataChartsHelper.DetectChartDimensionsUsingColumnTypesAndData(o,t,s,l),l.v.IsDataFormedAsSeries=!u),l.v.IsDataFormedAsSeries&&(u=Kusto.Charting.DataChartsHelper.DetectChartDimensionsUsingData(o,t,i,s,l)),u?(d=l.v.DataIndexes,l.v.DataIndexesList=System.Linq.Enumerable.from(o,System.Tuple$2(System.String,Kusto.Charting.ArgumentColumnType)).select((function(e,t){return t===l.v.ArgumentDataColumnIndex||l.v.GeospatiaColumnlIndexesList.contains(t)||System.Linq.Enumerable.from(d,System.Int32).any()&&!System.Linq.Enumerable.from(d,System.Int32).contains(t)||System.Linq.Enumerable.from(l.v.SeriesIndexes,System.Int32).contains(t)||!(!l.v.IsDataFormedAsSeries&&System.Enum.hasFlag(Kusto.Charting.ArgumentColumnType.NumericOrDateTimeOrTimeSpan,Bridge.box(e.Item2,Kusto.Charting.ArgumentColumnType,System.Enum.toStringFn(Kusto.Charting.ArgumentColumnType)))||l.v.IsDataFormedAsSeries&&System.Enum.hasFlag(Kusto.Charting.ArgumentColumnType.StringOrObject,Bridge.box(e.Item2,Kusto.Charting.ArgumentColumnType,System.Enum.toStringFn(Kusto.Charting.ArgumentColumnType))))?-1:t})).where(e.$.Kusto.Charting.DataChartsHelper.f2).toList(System.Int32),l.v.ArgumentColumnType!==Kusto.Charting.ArgumentColumnType.Geospatial||(l.v.DataIndexesList.Count>1&&(m=System.Linq.Enumerable.from(l.v.DataIndexesList,System.Int32).first(),l.v.DataIndexesList.clear(),l.v.DataIndexesList.add(m)),s!==Kusto.Charting.ArgumentRestrictions.GeospatialAsSeries||-1!==l.v.ArgumentDataColumnIndex&&System.Linq.Enumerable.from(l.v.DataIndexesList,System.Int32).any())?(l.v.UnusedIndexes=System.Linq.Enumerable.range(0,System.Linq.Enumerable.from(o,System.Tuple$2(System.String,Kusto.Charting.ArgumentColumnType)).count()).except(l.v.DataIndexes).except(l.v.GeospatialColumnIndexes).except(l.v.SeriesIndexes).except(System.Array.init([l.v.ArgumentDataColumnIndex],System.Int32)).toList(System.Int32),l.v):null):null):null},IsNumericType:function(e,t){return void 0===t&&(t=!0),null!=e&&(Bridge.referenceEquals(e,System.TimeSpan)||Bridge.referenceEquals(e,System.DateTime)?t:!!(Bridge.referenceEquals(e,System.Byte)||Bridge.referenceEquals(e,System.Decimal)||Bridge.referenceEquals(e,System.Double)||Bridge.referenceEquals(e,System.Int16)||Bridge.referenceEquals(e,System.Int32)||Bridge.referenceEquals(e,System.Int64)||Bridge.referenceEquals(e,System.SByte)||Bridge.referenceEquals(e,System.UInt16)||Bridge.referenceEquals(e,System.UInt32)||Bridge.referenceEquals(e,System.UInt64))||!!(Bridge.referenceEquals(e,System.Object)&&Bridge.Reflection.isGenericType(e)&&Bridge.referenceEquals(Bridge.Reflection.getGenericTypeDefinition(e),System.Nullable$1))&&Kusto.Charting.DataChartsHelper.IsNumericType(System.Nullable.getUnderlyingType(e),t))},GetAllArgumentColumns:function(e,t){var n,s;void 0===t&&(t=null);var i=new(System.Collections.Generic.List$1(System.String).ctor),r=e.Kusto$Charting$IChartingDataSource$GetSchema(),a=System.Linq.Enumerable.from(e.Kusto$Charting$IChartingDataSource$GetSchema(),System.Tuple$2(System.String,Kusto.Charting.ArgumentColumnType)).count(),o=null!=t&&System.Linq.Enumerable.from(t,System.String).any();if(a>1)for(n=0;n<a;n=n+1|0)s=System.Linq.Enumerable.from(r,System.Tuple$2(System.String,Kusto.Charting.ArgumentColumnType)).elementAt(n).Item1,o&&System.Linq.Enumerable.from(t,System.String).contains(s)||i.add(s);return i},GetFirstStringColumnName:function(e,t){var n,s,i;for(void 0===t&&(t=0),n=e.Kusto$Charting$IChartingDataSource$GetSchema(),s=System.Linq.Enumerable.from(e.Kusto$Charting$IChartingDataSource$GetSchema(),System.Tuple$2(System.String,Kusto.Charting.ArgumentColumnType)).count(),i=0;i<s;i=i+1|0)if(System.Linq.Enumerable.from(n,System.Tuple$2(System.String,Kusto.Charting.ArgumentColumnType)).elementAt(i).Item2===Kusto.Charting.ArgumentColumnType.String){if(0===t)return System.Linq.Enumerable.from(n,System.Tuple$2(System.String,Kusto.Charting.ArgumentColumnType)).elementAt(i).Item1;t=t-1|0}return null},FillGapsWithNaNs:function(t,n){var s,i,r,a,o;if(null==t||!System.Linq.Enumerable.from(t,Kusto.Charting.DataItem).any()||t.Count<Kusto.Charting.DataChartsHelper.c_minElementsAmountToFillGapsWithNans)return t;i=System.Linq.Enumerable.from(t,Kusto.Charting.DataItem).groupBy(e.$.Kusto.Charting.DataChartsHelper.f3),r=new(System.Collections.Generic.List$1(Kusto.Charting.DataItem).$ctor2)(t.Count),s=Bridge.getEnumerator(i);try{for(;s.moveNext();)a=s.Current,o=Kusto.Charting.DataChartsHelper.FillGapsWithNaNs$1(a.select(e.$.Kusto.Charting.DataChartsHelper.f4),n),r.AddRange(o)}finally{Bridge.is(s,System.IDisposable)&&s.System$IDisposable$Dispose()}return r},FillGapsWithNaNs$1:function(t,n){var s,i,r,a,o,l,u,d,m;if(System.Linq.Enumerable.from(t,Kusto.Charting.DataItem).count()<Kusto.Charting.DataChartsHelper.c_minElementsAmountToFillGapsWithNans)return t;switch(n){case Kusto.Charting.ArgumentColumnType.TimeSpan:case Kusto.Charting.ArgumentColumnType.DateTime:t=System.Linq.Enumerable.from(t,Kusto.Charting.DataItem).orderBy(e.$.Kusto.Charting.DataChartsHelper.f5),i=System.Linq.Enumerable.from(t,Kusto.Charting.DataItem).select(e.$.Kusto.Charting.DataChartsHelper.f6).ToArray(System.Double);break;case Kusto.Charting.ArgumentColumnType.Numeric:t=System.Linq.Enumerable.from(t,Kusto.Charting.DataItem).orderBy(e.$.Kusto.Charting.DataChartsHelper.f7),i=System.Linq.Enumerable.from(t,Kusto.Charting.DataItem).select(e.$.Kusto.Charting.DataChartsHelper.f7).ToArray(System.Double);break;default:return t}if(null==i||!System.Linq.Enumerable.from(i,System.Double).any())return t;var c=Kusto.Charting.DataChartsHelper.SelectSuccessivePairs(i),p=Kusto.Charting.DataChartsHelper.GetTopGroupByCount(c,n),S=p.Item1;if(null==p||System.Convert.toDouble(Bridge.box(p.Item2,System.Int32))/System.Linq.Enumerable.from(c,System.Double).count()<Kusto.Charting.DataChartsHelper.c_minFractionOfIntervalsToDetectDistribution)return t;r=new(System.Collections.Generic.List$1(Kusto.Charting.DataItem).$ctor2)(System.Linq.Enumerable.from(t,Kusto.Charting.DataItem).count()),a=null,s=Bridge.getEnumerator(t,Kusto.Charting.DataItem);try{for(;s.moveNext();)if(o=s.Current,null!=a){if((l=Kusto.Charting.DataChartsHelper.GetDistance(a,o,n))-S>Kusto.Charting.DataChartsHelper.c_doubleAcceptableApproximation){u=0;try{u=System.Convert.toInt32(Bridge.box(Bridge.Math.round(l/S,0,6),System.Double,System.Double.format,System.Double.getHashCode))}catch(e){return e=System.Exception.create(e),t}if(l-u*S>Kusto.Charting.DataChartsHelper.c_doubleAcceptableApproximation)return t;for(d=1;d<u;d=d+1|0){switch((m=a.Clone()).ValueData=Number.NaN,n){case Kusto.Charting.ArgumentColumnType.Numeric:m.ArgumentNumeric+=S*d,m.ArgumentData=System.Double.format(m.ArgumentNumeric);break;case Kusto.Charting.ArgumentColumnType.DateTime:m.ArgumentDateTime=System.DateTime.addTicks(m.ArgumentDateTime,System.Convert.toInt64(Bridge.box(S,System.Double,System.Double.format,System.Double.getHashCode)).mul(System.Int64(d))),m.ArgumentData=System.DateTime.format(m.ArgumentDateTime);break;case Kusto.Charting.ArgumentColumnType.TimeSpan:m.ArgumentDateTime=System.DateTime.addTicks(m.ArgumentDateTime,System.Convert.toInt64(Bridge.box(S,System.Double,System.Double.format,System.Double.getHashCode)).mul(System.Int64(d))),m.ArgumentData=Bridge.toString(System.TimeSpan.fromTicks(System.DateTime.getTicks(m.ArgumentDateTime)))}r.add(m)}}r.add(o),a=o}else r.add(o),a=o}finally{Bridge.is(s,System.IDisposable)&&s.System$IDisposable$Dispose()}return r},ResolveArgumentType:function(t){if(null==t||!System.Linq.Enumerable.from(t,Kusto.Charting.DataItem).any())return Kusto.Charting.ArgumentColumnType.None;var n={};return System.Linq.Enumerable.from(t,Kusto.Charting.DataItem).all((function(e){return!System.String.isNullOrEmpty(e.ArgumentData)&&System.String.indexOf(e.ArgumentData,":")>0&&System.TimeSpan.tryParse(e.ArgumentData,null,n)}))?Kusto.Charting.ArgumentColumnType.TimeSpan:System.Linq.Enumerable.from(t,Kusto.Charting.DataItem).all(e.$.Kusto.Charting.DataChartsHelper.f8)?Kusto.Charting.ArgumentColumnType.DateTime:System.Linq.Enumerable.from(t,Kusto.Charting.DataItem).any(e.$.Kusto.Charting.DataChartsHelper.f9)?Kusto.Charting.ArgumentColumnType.Numeric:Kusto.Charting.ArgumentColumnType.String},ValidateData:function(t,n,s,i){var r,a,o,l,u,d;if(i.v="",null==t||!System.Linq.Enumerable.from(t,Kusto.Charting.DataItem).any())return i.v="Data was not provided",Kusto.Charting.ValidationStatus.PolicyViolationError;if(System.Linq.Enumerable.from(t,Kusto.Charting.DataItem).where(e.$.Kusto.Charting.DataChartsHelper.f10).any())return i.v="Data includes non-finite values",Kusto.Charting.ValidationStatus.PolicyViolationError;if(n===Kusto.Charting.ArgumentColumnType.Geospatial&&System.Linq.Enumerable.from(t,Kusto.Charting.DataItem).any(e.$.Kusto.Charting.DataChartsHelper.f11))return i.v="Data includes invalid geospatial coordinates. Longitude values must be in range [-180,180]. Latitude values must be in range [-90,90].",Kusto.Charting.ValidationStatus.PolicyViolationError;if(n===Kusto.Charting.ArgumentColumnType.DateTime&&System.TimeSpan.neq(s.MaxDatetimePeriodError,Bridge.getDefaultValue(System.TimeSpan))){a=System.DateTime.getMaxValue(),o=System.DateTime.getMinValue(),r=Bridge.getEnumerator(t,Kusto.Charting.DataItem);try{for(;r.moveNext();)l=r.Current,System.DateTime.lt(o,l.ArgumentDateTime)&&(o=l.ArgumentDateTime),System.DateTime.gt(a,l.ArgumentDateTime)&&(a=l.ArgumentDateTime)}finally{Bridge.is(r,System.IDisposable)&&r.System$IDisposable$Dispose()}if(System.DateTime.gt(a,o)||System.TimeSpan.gt(System.DateTime.subdd(o,a),s.MaxDatetimePeriodError))return i.v="Input time range is too wide to fit into chart",Kusto.Charting.ValidationStatus.PolicyViolationError}return u=System.Linq.Enumerable.from(t,Kusto.Charting.DataItem).select(e.$.Kusto.Charting.DataChartsHelper.f3).distinct().count(),d=System.Linq.Enumerable.from(t,Kusto.Charting.DataItem).count(),u>s.MaxSeriesPerChartError?(i.v="Too many series\n"+(System.String.format("Provided data contains {0} series which exceeds allowed amount for the chart: {1}",Bridge.box(u,System.Int32),Bridge.box(s.MaxSeriesPerChartError,System.Int32))||""),Kusto.Charting.ValidationStatus.PolicyViolationError):d>s.MaxPointsPerChartError?(i.v="Too many points\n"+(System.String.format("Provided data contains {0} points which exceeds allowed amount for the chart: {1}",Bridge.box(d,System.Int32),Bridge.box(s.MaxPointsPerChartError,System.Int32))||""),Kusto.Charting.ValidationStatus.PolicyViolationError):u>s.MaxSeriesPerChartWarning||d>s.MaxPointsPerChartWarning?(i.v="Too many series or data points\nChart can perform badly when large amount of data is used.\n"+(System.String.format("You are about to plot {0} series with {1} points.",Bridge.box(u,System.Int32),Bridge.box(d,System.Int32))||""),Kusto.Charting.ValidationStatus.PolicyViolationWarning):Kusto.Charting.ValidationStatus.Valid},ResolveJsonArrayType:function(e){var t;try{t=Newtonsoft.Json.JsonConvert.DeserializeObject(e,System.Array.type(System.String))}catch(e){return e=System.Exception.create(e),Kusto.Charting.ArgumentColumnType.None}return null==t||0===System.Linq.Enumerable.from(t,System.String).count()?Kusto.Charting.ArgumentColumnType.None:Kusto.Charting.DataChartsHelper.ArrayIsDouble(t)?Kusto.Charting.ArgumentColumnType.Numeric:Kusto.Charting.DataChartsHelper.ArrayIsTimespan(t)?Kusto.Charting.ArgumentColumnType.TimeSpan:Kusto.Charting.DataChartsHelper.ArrayIsDatetime(t)?Kusto.Charting.ArgumentColumnType.DateTime:Kusto.Charting.ArgumentColumnType.String},SelectSuccessivePairs:function(e){var t,n;if(null==e||System.Linq.Enumerable.from(e,System.Double).count()<=1)return null;var s=System.Array.init(System.Linq.Enumerable.from(e,System.Double).count()-1|0,0,System.Double),i=!0,r=Bridge.getDefaultValue(System.Double),a=0;t=Bridge.getEnumerator(e);try{for(;t.moveNext();)n=t.Current,i?(i=!1,r=n):(s[System.Array.index(a,s)]=Math.abs(n-r),a=a+1|0,r=n)}finally{Bridge.is(t,System.IDisposable)&&t.System$IDisposable$Dispose()}return s},GetTopGroupByCount:function(t,n){var s,i,r=System.Linq.Enumerable.from(t,System.Double).orderBy(e.$.Kusto.Charting.DataChartsHelper.f4),a=new(System.Collections.Generic.List$1(System.Double).$ctor2)(System.Linq.Enumerable.from(t,System.Double).count()),o=0,l=0,u=null;s=Bridge.getEnumerator(r);try{for(;s.moveNext();)i=s.Current,System.Nullable.hasValue(u)?(i-System.Nullable.getValue(u)>Kusto.Charting.DataChartsHelper.c_doubleAcceptableApproximation&&(System.Linq.Enumerable.from(a,System.Double).count()>o&&(o=System.Linq.Enumerable.from(a,System.Double).count(),l=Bridge.Math.round(System.Linq.Enumerable.from(a,System.Double).average(),Kusto.Charting.DataChartsHelper.c_decimalRoundingPrecision,6)),a.clear()),a.add(i),u=i):(u=i,a.add(i))}finally{Bridge.is(s,System.IDisposable)&&s.System$IDisposable$Dispose()}return{Item1:l,Item2:o}},GetDistance:function(e,t,n){if(null==e||null==t)return-1;var s=-1;switch(n){case Kusto.Charting.ArgumentColumnType.TimeSpan:case Kusto.Charting.ArgumentColumnType.DateTime:s=System.Int64.toNumber(System.DateTime.getTicks(t.ArgumentDateTime).sub(System.DateTime.getTicks(e.ArgumentDateTime)));break;case Kusto.Charting.ArgumentColumnType.Numeric:s=t.ArgumentNumeric-e.ArgumentNumeric}return Bridge.Math.round(Math.abs(s),Kusto.Charting.DataChartsHelper.c_decimalRoundingPrecision,6)},ResolvePredefinedColumnsIndexes:function(e,t,n,s,i,r){var a,o,l,u,d,m,c,p,S,g=null,h=e.Kusto$Charting$IChartingDataSource$GetSchema();if(i===Kusto.Charting.ArgumentRestrictions.GeospatialAsSeries&&System.Linq.Enumerable.from(t,System.String).any()&&(System.Linq.Enumerable.from(n,System.String).any()||!System.String.isNullOrWhiteSpace(s)))throw new Kusto.Charting.SeriesCreationException("GeospatialAsSeries: it's not possible to set both series and x/y columns.");for(a=0;a<System.Linq.Enumerable.from(h,System.Tuple$2(System.String,Kusto.Charting.ArgumentColumnType)).count();a=a+1|0)if(l=(o=System.Linq.Enumerable.from(h,System.Tuple$2(System.String,Kusto.Charting.ArgumentColumnType)).elementAt(a)).Item1,System.Linq.Enumerable.from(t,System.String).any()&&System.Linq.Enumerable.from(t,System.String).contains(l))r.v.SeriesIndexesList.add(a),i===Kusto.Charting.ArgumentRestrictions.GeospatialAsSeries&&r.v.GeospatiaColumnlIndexesList.add(a);else if(u=System.Linq.Enumerable.from(n,System.String).any()&&System.Linq.Enumerable.from(n,System.String).contains(l),d=!System.String.isNullOrWhiteSpace(s)&&Bridge.referenceEquals(s,l),u||d){if(m=o.Item2,c=!1,System.Enum.hasFlag(Kusto.Charting.ArgumentColumnType.StringOrObject,Bridge.box(m,Kusto.Charting.ArgumentColumnType,System.Enum.toStringFn(Kusto.Charting.ArgumentColumnType)))&&r.v.ArgumentColumnType!==Kusto.Charting.ArgumentColumnType.Geospatial&&(p=Bridge.toString(e.Kusto$Charting$IChartingDataSource$GetValue(0,a)),(S=Kusto.Charting.DataChartsHelper.ResolveJsonArrayType(p))!==Kusto.Charting.ArgumentColumnType.None&&(m=S,c=!0)),System.Nullable.hasValue(g)){if(System.Nullable.getValue(g)!==c)throw new Kusto.Charting.SeriesCreationException("Y-Axes and X-Axis both should be defined as scalars or as series")}else g=c;if(r.v.ArgumentColumnType===Kusto.Charting.ArgumentColumnType.Geospatial)r.v.GeospatiaColumnlIndexesList.add(a),i===Kusto.Charting.ArgumentRestrictions.GeospatialAsSeries&&r.v.SeriesIndexesList.add(a);else if(d){if(!System.Enum.hasFlag(r.v.ArgumentColumnType,Bridge.box(m,Kusto.Charting.ArgumentColumnType,System.Enum.toStringFn(Kusto.Charting.ArgumentColumnType))))throw new Kusto.Charting.SeriesCreationException(System.String.format("Type of column {0}, provided as X-Axis, does not match required by chart type",[l]));r.v.ArgumentDataColumnIndex=a}else if(u){if(!System.Enum.hasFlag(Kusto.Charting.ArgumentColumnType.NumericOrDateTimeOrTimeSpan,Bridge.box(m,Kusto.Charting.ArgumentColumnType,System.Enum.toStringFn(Kusto.Charting.ArgumentColumnType))))throw new Kusto.Charting.SeriesCreationException(System.String.format("Column {0}, provided as Y-Axis, sould be one of types: Numeric, DateTime, Timespan",[l]));r.v.DataIndexesList.add(a)}}if(r.v.IsDataFormedAsSeries=!!System.Nullable.hasValue(g)&&System.Nullable.getValue(g),!System.Linq.Enumerable.from(r.v.DataIndexesList,System.Int32).any()&&System.Linq.Enumerable.from(n,System.String).any()&&r.v.ArgumentColumnType!==Kusto.Charting.ArgumentColumnType.Geospatial)throw new Kusto.Charting.SeriesCreationException("Any of columns defined as Y-Axes were not found in data, not of an appropriate type or used as argument or series");if(!System.String.isNullOrWhiteSpace(s)&&r.v.ArgumentDataColumnIndex<0&&r.v.ArgumentColumnType!==Kusto.Charting.ArgumentColumnType.Geospatial)throw new Kusto.Charting.SeriesCreationException(System.String.format("Column {0}, provided as X-Axis, was not found in data",[s]));if(System.Linq.Enumerable.from(t,System.String).any()&&!System.Linq.Enumerable.from(r.v.SeriesIndexesList,System.Int32).any())throw new Kusto.Charting.SeriesCreationException("Any of columns, provided as Series, were not found in data")},ResolveDataSeriesFromDataRow:function(t,n,s,i,r,a,o,l,u){var d,m,c,p,S,g,h,y=n.Kusto$Charting$IChartingDataSource$GetValue(r,u),f=Kusto.Charting.DataChartsHelper.ResolveJsonArrayType(Bridge.toString(y));d=Bridge.getEnumerator(s,Kusto.Charting.DataChartsHelper.ColumnDesc);try{for(;d.moveNext();){var I=d.Current,K=n.Kusto$Charting$IChartingDataSource$GetValue(r,I.Index),T=null!=(m=Bridge.as(K,System.String))?m:Bridge.toString(K),C=Kusto.Charting.DataChartsHelper.ResolveJsonArrayType(T);if(C!==Kusto.Charting.ArgumentColumnType.None&&System.Enum.hasFlag(Kusto.Charting.ArgumentColumnType.NumericOrDateTimeOrTimeSpan,Bridge.box(C,Kusto.Charting.ArgumentColumnType,System.Enum.toStringFn(Kusto.Charting.ArgumentColumnType)))){if(null==(p=Kusto.Charting.DataChartsHelper.ParseJsonArrayAsDouble(T,!0))||0===System.Linq.Enumerable.from(T,System.Char).count())continue;var x=System.String.isNullOrEmpty(a)?I.Name:(a||"")+":"+(I.Name||""),D=0,R=Kusto.Charting.DataChartsHelper.GetArgumentDateTimeArray(y,f,u,System.Linq.Enumerable.from(p,System.Double).count()),b=Kusto.Charting.DataChartsHelper.GetArgumentNumericArray(y,f,u,System.Linq.Enumerable.from(p,System.Double).count()),v=Kusto.Charting.DataChartsHelper.GetArgumentStringArray(y,f,u,System.Linq.Enumerable.from(p,System.Double).count()),w=System.Linq.Enumerable.from(i,Kusto.Charting.DataChartsHelper.ColumnDesc).select((function(e){return n.Kusto$Charting$IChartingDataSource$GetValue(r,e.Index)})).select(e.$.Kusto.Charting.DataChartsHelper.f12).ToArray(System.Object);for(S=0;S<p.length;S=S+1|0)g="",System.Enum.hasFlag(Kusto.Charting.ArgumentColumnType.DateTimeOrTimeSpan,Bridge.box(o,Kusto.Charting.ArgumentColumnType,System.Enum.toStringFn(Kusto.Charting.ArgumentColumnType)))&&System.Enum.hasFlag(Kusto.Charting.ArgumentColumnType.DateTimeOrTimeSpan,Bridge.box(f,Kusto.Charting.ArgumentColumnType,System.Enum.toStringFn(Kusto.Charting.ArgumentColumnType)))?g=System.DateTime.format(R[System.Array.index(S,R)]):System.Enum.hasFlag(o,Bridge.box(Kusto.Charting.ArgumentColumnType.Numeric,Kusto.Charting.ArgumentColumnType,System.Enum.toStringFn(Kusto.Charting.ArgumentColumnType)))&&f===Kusto.Charting.ArgumentColumnType.Numeric?g=System.Double.format(b[System.Array.index(S,b)]):System.Enum.hasFlag(o,Bridge.box(Kusto.Charting.ArgumentColumnType.String,Kusto.Charting.ArgumentColumnType,System.Enum.toStringFn(Kusto.Charting.ArgumentColumnType)))&&(g=v[System.Array.index(S,v)],System.String.isNullOrEmpty(g)&&(g=Bridge.as(y,System.String))),(c=new Kusto.Charting.DataItem).ArgumentData=g,c.ArgumentDateTime=R[System.Array.index(S,R)],c.ArgumentNumeric=b[System.Array.index(S,b)],c.ValueData=l?p[System.Array.index(S,p)]+D:p[System.Array.index(S,p)],c.ValueName=I.Name,c.SeriesName=x,c.Properties=Kusto.Charting.DataChartsHelper.ResolvePropertiesFromMultiValue(n,w,i,S),h=c,System.String.isNullOrEmpty(h.ArgumentData)&&(h.ArgumentData=Kusto.Charting.DataChartsHelper.c_defaultArgumentString),t.add(h),D=h.ValueData}}}finally{Bridge.is(d,System.IDisposable)&&d.System$IDisposable$Dispose()}},ResolveProperties:function(e,t,n){return Kusto.Cloud.Platform.Utils.ExtendedEnumerable.SafeFastNone$2(Kusto.Charting.DataChartsHelper.ColumnDesc,n)?"":Bridge.toArray(System.Linq.Enumerable.from(n,Kusto.Charting.DataChartsHelper.ColumnDesc).select((function(n){var s=e.Kusto$Charting$IChartingDataSource$GetValue(t,n.Index),i=Kusto.Charting.DataChartsHelper.ObjectToString(s);return System.String.format("{0}:{1}",n.Name,i)}))).join(", ")},ResolvePropertiesFromMultiValue:function(t,n,s,i){return Kusto.Cloud.Platform.Utils.ExtendedEnumerable.SafeFastNone$2(Kusto.Charting.DataChartsHelper.ColumnDesc,s)?"":Bridge.toArray(System.Linq.Enumerable.from(s,Kusto.Charting.DataChartsHelper.ColumnDesc).zip(n,e.$.Kusto.Charting.DataChartsHelper.f13).select((function(e){var t,n;return t=null!=(n=Bridge.as(e.Item2,System.Array.type(System.String)))?n[System.Array.index(i,n)]:Kusto.Charting.DataChartsHelper.ObjectToString(e.Item2),System.String.format("{0}:{1}",e.Item1.Name,t)}))).join(", ")},ObjectToString:function(e){var t,n;return null!=(t=Bridge.as(e,System.String))?t:Bridge.equals(n=Bridge.is(e,System.DateTime)?System.Nullable.getValue(Bridge.cast(Bridge.unbox(e,System.DateTime),System.DateTime)):null,null)?Bridge.toString(e):Kusto.Cloud.Platform.Utils.ExtendedDateTime.ToUtcString(n)},GetArgumentStringArray:function(e,t,n,s){if(!System.Enum.hasFlag(t,Bridge.box(Kusto.Charting.ArgumentColumnType.String,Kusto.Charting.ArgumentColumnType,System.Enum.toStringFn(Kusto.Charting.ArgumentColumnType)))||n<0)return System.Array.init(s,null,System.String);var i=Kusto.Charting.DataChartsHelper.ParseJsonArrayAsString(Bridge.toString(e));return null==i?System.Array.init(s,null,System.String):i},GetArgumentNumericArray:function(e,t,n,s){if(t!==Kusto.Charting.ArgumentColumnType.Numeric||n<0)return System.Linq.Enumerable.repeat(Kusto.Charting.DataChartsHelper.c_defaultArgumentNumeric,s).ToArray(System.Double);var i=Kusto.Charting.DataChartsHelper.ParseJsonArrayAsDouble(Bridge.toString(e));return null==i?System.Linq.Enumerable.repeat(Kusto.Charting.DataChartsHelper.c_defaultArgumentNumeric,s).ToArray(System.Double):i},GetArgumentDateTimeArray:function(e,t,n,s){if(!System.Enum.hasFlag(Kusto.Charting.ArgumentColumnType.DateTimeOrTimeSpan,Bridge.box(t,Kusto.Charting.ArgumentColumnType,System.Enum.toStringFn(Kusto.Charting.ArgumentColumnType)))||n<0)return System.Linq.Enumerable.repeat(Kusto.Charting.DataChartsHelper.c_defaultArgumentDatetime,s).ToArray(System.DateTime);var i=Kusto.Charting.DataChartsHelper.ParseJsonArrayAsDateTime(Bridge.toString(e),t);return null==i?System.Linq.Enumerable.repeat(Kusto.Charting.DataChartsHelper.c_defaultArgumentDatetime,s).ToArray(System.DateTime):i},ResolveDataItemsFromDataRow:function(e,t,n,s,i,r,a,o,l){var u,d;System.Linq.Enumerable.from(n,Kusto.Charting.DataChartsHelper.ColumnDesc).any()||a.GeospatialArgumentDataType!==Kusto.Charting.ArgumentColumnType.Geospatial||e.add(((u=new Kusto.Charting.DataItem).GeoCoordinates=a.GeoCoordinates,u.SeriesName=System.String.isNullOrWhiteSpace(r)?"":r,u.Properties=Kusto.Charting.DataChartsHelper.ResolveProperties(t,i,s),u)),u=Bridge.getEnumerator(n,Kusto.Charting.DataChartsHelper.ColumnDesc);try{for(;u.moveNext();){var m=u.Current,c=t.Kusto$Charting$IChartingDataSource$GetValue(i,m.Index),p=Kusto.Charting.DataChartsHelper.TryConvertToDouble(c,m.Type),S={},g=((d=new Kusto.Charting.DataItem).ArgumentData=a.Value,d.ArgumentDateTime=a.DateTime,d.ArgumentNumeric=a.NumericValue,d.ValueName=m.Name,d.Properties=Kusto.Charting.DataChartsHelper.ResolveProperties(t,i,s),d);a.GeospatialArgumentDataType===Kusto.Charting.ArgumentColumnType.Geospatial?(g.SeriesName=System.String.isNullOrWhiteSpace(r)?"":r,g.GeoCoordinates=a.GeoCoordinates):g.SeriesName=System.String.isNullOrEmpty(r)?m.Name:(r||"")+":"+(m.Name||""),g.ValueData=l&&o.tryGetValue(g.SeriesName,S)?p+S.v:p,e.add(g),o.setItem(g.SeriesName,g.ValueData)}}finally{Bridge.is(u,System.IDisposable)&&u.System$IDisposable$Dispose()}},GetBaseSeriesName:function(e,t,n){var s,i,r,a,o="";if(null!=t){i=new System.Text.StringBuilder,s=Bridge.getEnumerator(t,Kusto.Charting.DataChartsHelper.ColumnDesc);try{for(;s.moveNext();)r=s.Current,i.getLength()>0&&i.append(", "),a=Bridge.toString(e.Kusto$Charting$IChartingDataSource$GetValue(n,r.Index)),a=System.String.isNullOrWhiteSpace(a)?Kusto.Charting.DataChartsHelper.c_defaultArgumentString:a,i.appendFormat("{0}:{1}",r.Name,a)}finally{Bridge.is(s,System.IDisposable)&&s.System$IDisposable$Dispose()}o=i.toString()}return o},TrySetGeoJSONPoint:function(e,t){t.v=null;try{t.v=Newtonsoft.Json.JsonConvert.DeserializeObject(e,Kusto.Charting.DataChartsHelper.GeoJSONPoint)}catch(e){if(e=System.Exception.create(e),Bridge.is(e,Newtonsoft.Json.JsonException))return!1;throw e}return null!=(null!=t.v?t.v.coordinates:null)&&2===t.v.coordinates.length},GetArgumentDateTime:function(e,t){return System.Enum.hasFlag(t,Bridge.box(Kusto.Charting.ArgumentColumnType.DateTime,Kusto.Charting.ArgumentColumnType,System.Enum.toStringFn(Kusto.Charting.ArgumentColumnType)))||System.Enum.hasFlag(t,Bridge.box(Kusto.Charting.ArgumentColumnType.TimeSpan,Kusto.Charting.ArgumentColumnType,System.Enum.toStringFn(Kusto.Charting.ArgumentColumnType)))?Bridge.is(e,System.DateTime)?System.Nullable.getValue(Bridge.cast(Bridge.unbox(e,System.DateTime),System.DateTime)):Bridge.is(e,System.TimeSpan)?Kusto.Charting.DataChartsHelper.TimeSpanToDateTime(System.Nullable.getValue(Bridge.cast(Bridge.unbox(e,System.TimeSpan),System.TimeSpan))):Kusto.Charting.DataChartsHelper.c_defaultArgumentDatetime:Kusto.Charting.DataChartsHelper.c_defaultArgumentDatetime},ConvertToDouble:function(e,t){var n=Kusto.Charting.DataChartsHelper.c_defaultArgumentNumeric;if(null==e)return n;if(t===Kusto.Charting.ArgumentColumnType.DateTime)n=Kusto.Charting.DataChartsHelper.DateTimeToTotalSeconds(System.Nullable.getValue(Bridge.cast(Bridge.unbox(e,System.DateTime),System.DateTime)));else if(t===Kusto.Charting.ArgumentColumnType.TimeSpan)n=Kusto.Charting.DataChartsHelper.TimeSpanToTotalSeconds(System.Nullable.getValue(Bridge.cast(Bridge.unbox(e,System.TimeSpan),System.TimeSpan)));else try{n=System.Convert.toDouble(e)}catch(e){e=System.Exception.create(e),n=Kusto.Charting.DataChartsHelper.c_defaultArgumentNumeric}return n},TryConvertToDouble:function(e,t){return null==e||Kusto.Charting.DataChartsHelper.IsEmptyValue(e)?Kusto.Charting.DataChartsHelper.c_defaultArgumentNumeric:Kusto.Charting.DataChartsHelper.ConvertToDouble(e,t)},DetectChartDimensionsUsingData:function(e,t,n,s,i){var r,a,o,l,u=System.Array.init(System.Linq.Enumerable.from(e,System.Tuple$2(System.String,Kusto.Charting.ArgumentColumnType)).count(),0,Kusto.Charting.ArgumentColumnType);if(0===t.Kusto$Charting$IChartingDataSource$RowsCount)return!1;for(a=-1,o=0;o<System.Linq.Enumerable.from(e,System.Tuple$2(System.String,Kusto.Charting.ArgumentColumnType)).count();o=o+1|0)if(!(l=System.Linq.Enumerable.from(e,System.Tuple$2(System.String,Kusto.Charting.ArgumentColumnType)).elementAt(o),u[System.Array.index(o,u)]=l.Item2,i.v.DataIndexesList.contains(o)||l.Item2!==Kusto.Charting.ArgumentColumnType.String&&l.Item2!==Kusto.Charting.ArgumentColumnType.Object)){var d=t.Kusto$Charting$IChartingDataSource$GetValue(0,o),m=null!=(r=Bridge.as(d,System.String))?r:Bridge.toString(d),c=Kusto.Charting.DataChartsHelper.ResolveJsonArrayType(m);if(c===Kusto.Charting.ArgumentColumnType.None){!System.Linq.Enumerable.from(n,System.String).any()&&i.v.ArgumentDataColumnIndex<0&&i.v.SeriesIndexesList.add(o);continue}u[System.Array.index(o,u)]=c,System.Enum.hasFlag(i.v.ArgumentColumnType,Bridge.box(c,Kusto.Charting.ArgumentColumnType,System.Enum.toStringFn(Kusto.Charting.ArgumentColumnType)))&&i.v.ArgumentDataColumnIndex<0?i.v.ArgumentDataColumnIndex=o:c===Kusto.Charting.ArgumentColumnType.Numeric&&a<0&&(a=o)}return Kusto.Charting.DataChartsHelper.CompleteChartDimentionsDetection(e,s,a,u,i)},DetectChartDimensionsUsingColumnTypesAndData:function(t,n,s,i){for(var r,a,o,l=-1,u=new(System.Collections.Generic.List$1(System.Int32).ctor),d=System.Linq.Enumerable.from(i.v.GeospatiaColumnlIndexesList,System.Int32).any(),m=0;m<System.Linq.Enumerable.from(t,System.Tuple$2(System.String,Kusto.Charting.ArgumentColumnType)).count();m=m+1|0)if(!i.v.DataIndexesList.contains(m)&&!i.v.SeriesIndexesList.contains(m))if(r=System.Linq.Enumerable.from(t,System.Tuple$2(System.String,Kusto.Charting.ArgumentColumnType)).elementAt(m),i.v.ArgumentColumnType===Kusto.Charting.ArgumentColumnType.Geospatial&&System.Enum.hasFlag(Kusto.Charting.ArgumentColumnType.StringOrObject,Bridge.box(r.Item2,Kusto.Charting.ArgumentColumnType,System.Enum.toStringFn(Kusto.Charting.ArgumentColumnType)))&&u.add(m),i.v.ArgumentColumnType===Kusto.Charting.ArgumentColumnType.Geospatial&&System.Enum.hasFlag(Kusto.Charting.ArgumentColumnType.Numeric,Bridge.box(r.Item2,Kusto.Charting.ArgumentColumnType,System.Enum.toStringFn(Kusto.Charting.ArgumentColumnType)))&&System.Linq.Enumerable.from(i.v.GeospatiaColumnlIndexesList,System.Int32).count()<2&&!d)i.v.GeospatiaColumnlIndexesList.add(m);else if(System.Enum.hasFlag(i.v.ArgumentColumnType,Bridge.box(r.Item2,Kusto.Charting.ArgumentColumnType,System.Enum.toStringFn(Kusto.Charting.ArgumentColumnType)))&&i.v.ArgumentDataColumnIndex<0)i.v.ArgumentDataColumnIndex=m;else if(r.Item2===Kusto.Charting.ArgumentColumnType.Numeric){l=m;break}if(i.v.ArgumentColumnType===Kusto.Charting.ArgumentColumnType.Geospatial&&System.Linq.Enumerable.from(i.v.GeospatiaColumnlIndexesList,System.Int32).count()<2&&!d){i.v.GeospatiaColumnlIndexesList.clear(),o=Bridge.getEnumerator(u);try{for(;o.moveNext();){var c=o.Current,p=Bridge.toString(n.Kusto$Charting$IChartingDataSource$GetValue(0,c));if(Kusto.Charting.DataChartsHelper.TrySetGeoJSONPoint(p,{})){i.v.GeospatiaColumnlIndexesList.add(c);break}}}finally{Bridge.is(o,System.IDisposable)&&o.System$IDisposable$Dispose()}}return a=System.Linq.Enumerable.from(t,System.Tuple$2(System.String,Kusto.Charting.ArgumentColumnType)).select(e.$.Kusto.Charting.DataChartsHelper.f14).ToArray(Kusto.Charting.ArgumentColumnType),Kusto.Charting.DataChartsHelper.CompleteChartDimentionsDetection(t,s,l,a,i)},CompleteChartDimentionsDetection:function(e,t,n,s,i){var r,a,o,l;if(i.v.ArgumentDataColumnIndex>=0&&System.Linq.Enumerable.from(i.v.SeriesIndexesList,System.Int32).any())return!0;if(i.v.ArgumentDataColumnIndex<0&&n<0&&System.Enum.hasFlag(i.v.ArgumentColumnType,Bridge.box(Kusto.Charting.ArgumentColumnType.Numeric,Kusto.Charting.ArgumentColumnType,System.Enum.toStringFn(Kusto.Charting.ArgumentColumnType))))return!1;if(i.v.ArgumentColumnType===Kusto.Charting.ArgumentColumnType.Geospatial&&!System.Linq.Enumerable.from(i.v.GeospatiaColumnlIndexesList,System.Int32).any())return!1;if(i.v.ArgumentDataColumnIndex<0&&i.v.ArgumentColumnType!==Kusto.Charting.ArgumentColumnType.Geospatial){if(System.Enum.hasFlag(Kusto.Charting.ArgumentColumnType.DateTimeOrTimeSpan,Bridge.box(i.v.ArgumentColumnType,Kusto.Charting.ArgumentColumnType,System.Enum.toStringFn(Kusto.Charting.ArgumentColumnType))))return!1;System.Enum.hasFlag(i.v.ArgumentColumnType,Bridge.box(Kusto.Charting.ArgumentColumnType.Numeric,Kusto.Charting.ArgumentColumnType,System.Enum.toStringFn(Kusto.Charting.ArgumentColumnType)))?System.Linq.Enumerable.from(e,System.Tuple$2(System.String,Kusto.Charting.ArgumentColumnType)).count()>1&&(i.v.ArgumentDataColumnIndex=n):i.v.ArgumentDataColumnIndex=System.Enum.hasFlag(t,Bridge.box(Kusto.Charting.ArgumentRestrictions.NotIncludedInSeries,Kusto.Charting.ArgumentRestrictions,System.Enum.toStringFn(Kusto.Charting.ArgumentRestrictions)))?Kusto.Charting.DataChartsHelper.GoBackwardsAndFindColumnNotInList(n,i.v.SeriesIndexes,i.v.DataIndexes):n-1|0}if(i.v.ArgumentDataColumnIndex<0&&System.Enum.hasFlag(t,Bridge.box(Kusto.Charting.ArgumentRestrictions.MustHave,Kusto.Charting.ArgumentRestrictions,System.Enum.toStringFn(Kusto.Charting.ArgumentRestrictions)))&&(i.v.ArgumentDataColumnIndex=0),i.v.ArgumentColumnType===Kusto.Charting.ArgumentColumnType.Geospatial)if(a=Kusto.Charting.DataChartsHelper.GetFirstStringAvailableColumnIndexOrNonStringIfAbsent(s,i.v.GeospatialColumnIndexes),t===Kusto.Charting.ArgumentRestrictions.GeospatialAsSeries){if(i.v.ArgumentDataColumnIndex=a,!System.Linq.Enumerable.from(i.v.SeriesIndexesList,System.Int32).any()){r=Bridge.getEnumerator(i.v.GeospatiaColumnlIndexesList);try{for(;r.moveNext();)o=r.Current,i.v.SeriesIndexesList.add(o)}finally{Bridge.is(r,System.IDisposable)&&r.System$IDisposable$Dispose()}}}else-1===a||System.Linq.Enumerable.from(i.v.SeriesIndexesList,System.Int32).any()||i.v.SeriesIndexesList.add(a);else!System.Linq.Enumerable.from(i.v.SeriesIndexesList,System.Int32).any()&&i.v.ArgumentDataColumnIndex>=0&&(l=i.v.ArgumentDataColumnIndex,s[System.Array.index(i.v.ArgumentDataColumnIndex,s)]!==Kusto.Charting.ArgumentColumnType.String?l=Kusto.Charting.DataChartsHelper.GetFirstStringColumnIndex(s):System.Enum.hasFlag(t,Bridge.box(Kusto.Charting.ArgumentRestrictions.NotIncludedInSeries,Kusto.Charting.ArgumentRestrictions,System.Enum.toStringFn(Kusto.Charting.ArgumentRestrictions)))&&(l=i.v.ArgumentDataColumnIndex-1|0),l>=0&&!i.v.DataIndexesList.contains(l)&&i.v.SeriesIndexesList.add(l));return!0},GoBackwardsAndFindColumnNotInList:function(e,t,n){for(var s,i,r=e-1|0;r>=0;r=r-1|0)if(s=null==t||!System.Linq.Enumerable.from(t,System.Int32).contains(r),i=null==n||!System.Linq.Enumerable.from(n,System.Int32).contains(r),s&&i)return r;return-1},GetFirstStringColumnIndex:function(e){for(var t=0;t<System.Linq.Enumerable.from(e,Kusto.Charting.ArgumentColumnType).count();t=t+1|0)if(System.Linq.Enumerable.from(e,Kusto.Charting.ArgumentColumnType).elementAt(t)===Kusto.Charting.ArgumentColumnType.String)return t;return-1},GetFirstStringAvailableColumnIndexOrNonStringIfAbsent:function(e,t){for(var n=-1,s=0;s<System.Linq.Enumerable.from(e,Kusto.Charting.ArgumentColumnType).count();s=s+1|0){if(e[System.Array.index(s,e)]===Kusto.Charting.ArgumentColumnType.String&&!System.Linq.Enumerable.from(t,System.Int32).contains(s))return s;-1!==n||System.Linq.Enumerable.from(t,System.Int32).contains(s)||(n=s)}return n},TimeSpanToDateTime:function(e){return e.getTicks().lte(System.Int64(0))?System.DateTime.getMinValue():System.DateTime.create$2(e.getTicks(),1)},TimeSpanToTotalSeconds:function(e){return e.getTotalSeconds()},DateTimeToTotalSeconds:function(e){return System.TimeSpan.fromTicks(System.DateTime.getTicks(e)).getTotalSeconds()},ParseJsonArrayAsDateTime:function(t,n){if(System.String.isNullOrWhiteSpace(t)||!System.String.startsWith(t.trim(),"["))return null;try{if(n===Kusto.Charting.ArgumentColumnType.DateTime)return System.Linq.Enumerable.from(Newtonsoft.Json.JsonConvert.DeserializeObject(t,System.Array.type(System.DateTime)),System.DateTime).select(e.$.Kusto.Charting.DataChartsHelper.f15).ToArray(System.DateTime);if(n===Kusto.Charting.ArgumentColumnType.TimeSpan){var s=Newtonsoft.Json.JsonConvert.DeserializeObject(t,System.Array.type(System.TimeSpan));return System.Linq.Enumerable.from(s,System.TimeSpan).select(e.$.Kusto.Charting.DataChartsHelper.f16).ToArray(System.DateTime)}}catch(e){e=System.Exception.create(e)}return null},ParseJsonArrayAsDouble:function(e,t){var n,s,i,r,a,o,l,u;if(void 0===t&&(t=!1),System.String.isNullOrWhiteSpace(e)||!System.String.startsWith(e.trim(),"["))return null;try{s=Newtonsoft.Json.JsonConvert.DeserializeObject(e,System.Array.type(System.String)),n=System.Array.init(System.Linq.Enumerable.from(s,System.String).count(),0,System.Double)}catch(e){return e=System.Exception.create(e),null}for(i=Kusto.Charting.ArgumentColumnType.None,r={},a=0;a<s.length;a=a+1|0)if(null!=(o=s[System.Array.index(a,s)])){if(!System.Enum.hasFlag(Kusto.Charting.ArgumentColumnType.Numeric,Bridge.box(i,Kusto.Charting.ArgumentColumnType,System.Enum.toStringFn(Kusto.Charting.ArgumentColumnType)))||!System.Double.tryParse(o,null,r)){if(t){if(l={},System.Enum.hasFlag(Kusto.Charting.ArgumentColumnType.TimeSpan,Bridge.box(i,Kusto.Charting.ArgumentColumnType,System.Enum.toStringFn(Kusto.Charting.ArgumentColumnType)))&&System.TimeSpan.tryParse(o,null,l)){i===Kusto.Charting.ArgumentColumnType.None&&(i=Kusto.Charting.ArgumentColumnType.TimeSpan),n[System.Array.index(a,n)]=l.v.getTotalSeconds();continue}if(u={},System.Enum.hasFlag(Kusto.Charting.ArgumentColumnType.DateTime,Bridge.box(i,Kusto.Charting.ArgumentColumnType,System.Enum.toStringFn(Kusto.Charting.ArgumentColumnType)))&&System.DateTime.tryParse(o,null,u)){i===Kusto.Charting.ArgumentColumnType.None&&(i=Kusto.Charting.ArgumentColumnType.DateTime),n[System.Array.index(a,n)]=System.TimeSpan.fromTicks(System.DateTime.getTicks(u.v)).getTotalSeconds();continue}}return null}i===Kusto.Charting.ArgumentColumnType.None&&(i=Kusto.Charting.ArgumentColumnType.Numeric),n[System.Array.index(a,n)]=r.v}else n[System.Array.index(a,n)]=Number.NaN;return i!==Kusto.Charting.ArgumentColumnType.None?n:null},ParseJsonArrayAsString:function(e){if(System.String.isNullOrWhiteSpace(e)||!System.String.startsWith(e.trim(),"["))return null;try{return Newtonsoft.Json.JsonConvert.DeserializeObject(e,System.Array.type(System.String))}catch(e){e=System.Exception.create(e)}return null},ArrayIsTimespan:function(e){var t,n,s=!1,i={};t=Bridge.getEnumerator(e);try{for(;t.moveNext();)if(null!=(n=t.Current)){if(!System.TimeSpan.tryParse(n,null,i))return!1;s=!0}}finally{Bridge.is(t,System.IDisposable)&&t.System$IDisposable$Dispose()}return s},ArrayIsDatetime:function(e){var t,n,s=!1,i={};t=Bridge.getEnumerator(e);try{for(;t.moveNext();)if(null!=(n=t.Current)){if(!System.DateTime.tryParse(n,null,i))return!1;s=!0}}finally{Bridge.is(t,System.IDisposable)&&t.System$IDisposable$Dispose()}return s},ArrayIsDouble:function(e){var t,n,s=!1,i={};t=Bridge.getEnumerator(e);try{for(;t.moveNext();)if(null!=(n=t.Current)){if(!System.Double.tryParse(n,null,i))return!1;s=!0}}finally{Bridge.is(t,System.IDisposable)&&t.System$IDisposable$Dispose()}return s},IsEmptyValue:function(e){return null==e||(!!Bridge.referenceEquals(e,System.DBNull.Value)||!(!Bridge.is(e,System.String)||!System.String.isNullOrEmpty(Bridge.cast(e,System.String))))}}}}),Bridge.ns("Kusto.Charting.DataChartsHelper",e.$),Bridge.apply(e.$.Kusto.Charting.DataChartsHelper,{f1:function(e,t){return new Kusto.Charting.DataChartsHelper.ColumnDesc(e.Item1,e.Item2,t)},f2:function(e){return e>=0},f3:function(e){return e.SeriesName},f4:function(e){return e},f5:function(e){return System.DateTime.getTicks(e.ArgumentDateTime)},f6:function(e){return System.Convert.toDouble(System.DateTime.getTicks(e.ArgumentDateTime))},f7:function(e){return e.ArgumentNumeric},f8:function(e){return!Bridge.equals(e.ArgumentDateTime,Kusto.Charting.DataChartsHelper.c_defaultArgumentDatetime)},f9:function(e){return!isNaN(e.ArgumentNumeric)},f10:function(e){return Math.abs(e.ValueData)===Number.POSITIVE_INFINITY},f11:function(e){return null!=e.GeoCoordinates&&(e.GeoCoordinates.Longitude>180||e.GeoCoordinates.Longitude<-180||e.GeoCoordinates.Latitude>90||e.GeoCoordinates.Latitude<-90)},f12:function(e){return Kusto.Charting.DataChartsHelper.ParseJsonArrayAsString(Bridge.as(e,System.String))||e},f13:function(e,t){return{Item1:e,Item2:t}},f14:function(e){return e.Item2},f15:function(e){return Kusto.Cloud.Platform.Utils.ExtendedDateTime.ToUtc(e)},f16:function(e){return Kusto.Charting.DataChartsHelper.TimeSpanToDateTime(e)}}),Bridge.define("Kusto.Charting.DataChartsHelper.ArgumentData",{$kind:"nested class",fields:{m_requestedType:0,m_colIndex:0,m_colName:null,m_colType:0,m_geospatialIndexes:null},props:{GeospatialArgumentDataType:0,Value:null,DateTime:null,NumericValue:0,GeoCoordinates:null},ctors:{init:function(){this.DateTime=System.DateTime.getDefaultValue()},ctor:function(e,t,n,s,i){var r;void 0===i&&(i=null),this.$initialize(),this.m_colIndex=e,this.m_colName=t,this.m_colType=n,this.m_requestedType=s,null!=i&&System.Linq.Enumerable.from(i,System.Int32).any()?(this.m_geospatialIndexes=(r=System.Int32,System.Linq.Enumerable.from(i,r).toList(r)),this.GeospatialArgumentDataType=Kusto.Charting.ArgumentColumnType.Geospatial):this.GeospatialArgumentDataType=Kusto.Charting.ArgumentColumnType.None}},methods:{ResolveArgumentFromRow:function(e,t){var n,s,i,r,a,o;this.m_requestedType===Kusto.Charting.ArgumentColumnType.Geospatial?(2===this.m_geospatialIndexes.Count?(r=e.Kusto$Charting$IChartingDataSource$GetValue(t,this.m_geospatialIndexes.getItem(0)),a=e.Kusto$Charting$IChartingDataSource$GetValue(t,this.m_geospatialIndexes.getItem(1)),this.GeoCoordinates=((n=new Kusto.Charting.GeospatialCoordinates).Longitude=Kusto.Charting.DataChartsHelper.TryConvertToDouble(r,Kusto.Charting.ArgumentColumnType.Numeric),n.Latitude=Kusto.Charting.DataChartsHelper.TryConvertToDouble(a,Kusto.Charting.ArgumentColumnType.Numeric),n)):(o={},this.GeoCoordinates=1===this.m_geospatialIndexes.Count&&Kusto.Charting.DataChartsHelper.TrySetGeoJSONPoint(Bridge.toString(e.Kusto$Charting$IChartingDataSource$GetValue(t,this.m_geospatialIndexes.getItem(0))),o)?((n=new Kusto.Charting.GeospatialCoordinates).Longitude=(s=o.v.coordinates)[System.Array.index(0,s)],n.Latitude=(i=o.v.coordinates)[System.Array.index(1,i)],n):((n=new Kusto.Charting.GeospatialCoordinates).Longitude=Kusto.Charting.DataChartsHelper.c_defaultArgumentNumeric,n.Latitude=Kusto.Charting.DataChartsHelper.c_defaultArgumentNumeric,n)),-1!==this.m_colIndex&&this.ResolveArgument(e,t,!0)):this.ResolveArgument(e,t)},ResolveArgument:function(e,t,n){var s,i,r;void 0===n&&(n=!1),i=null==(s=e.Kusto$Charting$IChartingDataSource$GetValue(t,this.m_colIndex))?this.m_requestedType:this.m_colType,this.DateTime=Kusto.Charting.DataChartsHelper.GetArgumentDateTime(s,i),r=this.m_colIndex>=0?Bridge.toString(s):"",System.String.isNullOrWhiteSpace(r)&&(r=Kusto.Charting.DataChartsHelper.c_defaultArgumentString),this.Value=n?System.String.format("{0}:{1}",this.m_colName,r):r,this.NumericValue=!System.Enum.hasFlag(i,Bridge.box(Kusto.Charting.ArgumentColumnType.Numeric,Kusto.Charting.ArgumentColumnType,System.Enum.toStringFn(Kusto.Charting.ArgumentColumnType)))||Kusto.Charting.DataChartsHelper.IsEmptyValue(s)?Kusto.Charting.DataChartsHelper.c_defaultArgumentNumeric:Kusto.Charting.DataChartsHelper.TryConvertToDouble(s,i)}}}),Bridge.define("Kusto.Charting.IChartMetaData",{$kind:"interface"}),Bridge.define("Kusto.Charting.DataChartsHelper.ColumnDesc",{$kind:"nested class",props:{Name:null,Type:0,Index:0},ctors:{ctor:function(e,t,n){this.$initialize(),this.Name=e,this.Type=t,this.Index=n}}}),Bridge.define("Kusto.Charting.DataChartsHelper.GeoJSON",{$kind:"nested enum",statics:{fields:{Point:0}}}),Bridge.define("Kusto.Charting.DataChartsHelper.GeoJSONPoint",{$kind:"nested class",props:{type:0,coordinates:null}}),Bridge.define("Kusto.Charting.DataItem",{props:{SeriesName:null,ArgumentData:null,ValueData:0,ValueName:null,ArgumentDateTime:null,ArgumentNumeric:0,GeoCoordinates:null,SecondaryAxisYName:null,PrefferredChartKind:0,Properties:null},ctors:{init:function(){this.ArgumentDateTime=System.DateTime.getDefaultValue()}},methods:{Clone:function(){var e,t;return(e=new Kusto.Charting.DataItem).SeriesName=this.SeriesName,e.ArgumentData=this.ArgumentData,e.ValueData=this.ValueData,e.ValueName=this.ValueName,e.ArgumentDateTime=this.ArgumentDateTime,e.ArgumentNumeric=this.ArgumentNumeric,e.SecondaryAxisYName=this.SecondaryAxisYName,e.PrefferredChartKind=this.PrefferredChartKind,e.Properties=this.Properties,e.GeoCoordinates=null==this.GeoCoordinates?null:((t=new Kusto.Charting.GeospatialCoordinates).Longitude=this.GeoCoordinates.Longitude,t.Latitude=this.GeoCoordinates.Latitude,t),e}}}),Bridge.define("Kusto.Charting.ExtendedDouble",{statics:{methods:{IsFinite:function(e){return!(Math.abs(e)===Number.POSITIVE_INFINITY||isNaN(e))}}}}),Bridge.define("Kusto.Charting.GeospatialCoordinates",{props:{Longitude:0,Latitude:0}}),Bridge.define("Kusto.Charting.IChartingDataSource",{$kind:"interface"}),Bridge.define("Kusto.Charting.IKustoClientContext",{$kind:"interface"}),Bridge.define("Kusto.Charting.SeriesCreationException",{inherits:[System.Exception],ctors:{ctor:function(e){this.$initialize(),System.Exception.ctor.call(this,e)}}}),Bridge.define("Kusto.Charting.ValidationStatus",{$kind:"enum",statics:{fields:{Valid:0,PolicyViolationError:1,PolicyViolationWarning:2}}}),Bridge.define("Kusto.Cloud.Platform.Text.StringLiteral",{statics:{fields:{categoryForLatin1:null},ctors:{init:function(){this.categoryForLatin1=System.Array.init([14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,11,24,24,24,26,24,24,24,20,21,24,25,24,19,24,24,8,8,8,8,8,8,8,8,8,8,24,24,25,25,25,24,24,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,24,21,27,18,27,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,20,25,21,25,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,11,24,26,26,26,26,28,28,27,28,1,22,25,19,28,27,28,25,10,10,27,1,28,24,27,10,1,23,10,10,10,24,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,25,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,25,1,1,1,1,1,1,1,1],System.Byte)}},methods:{ParseStringLiteral:function(e){var t={};if(Kusto.Cloud.Platform.Text.StringLiteral.TryParseStringLiteral(e,t))return t.v;throw new System.ArgumentException.$ctor1(System.String.format("Malformed string literal: '{0}'",[e]))},TryParseStringLiteral:function(e,t){var n,s;if(t.v=e,System.String.isNullOrWhiteSpace(t.v))return!1;if((104===t.v.charCodeAt(0)||72===t.v.charCodeAt(0))&&(t.v=t.v.substr(1)),System.String.startsWith(t.v,'"',4)){if(t.v.length>=2&&System.String.endsWith(t.v,'"'))return t.v=t.v.substr(1,t.v.length-2|0),!!Kusto.Cloud.Platform.Utils.ExtendedRegex.TryUnescape(t.v,t)}else if(System.String.startsWith(t.v,"'",4)){if(t.v.length>=2&&System.String.endsWith(t.v,"'",4))return t.v=t.v.substr(1,t.v.length-2|0),!!Kusto.Cloud.Platform.Utils.ExtendedRegex.TryUnescape(t.v,t)}else if(System.String.startsWith(t.v,'@"',4)){if(t.v.length>=3&&System.String.endsWith(t.v,'"',4))return n=t.v.substr(2,t.v.length-3|0),t.v=System.String.replaceAll(n,'""','"'),!0}else if(System.String.startsWith(t.v,"@'",4)&&t.v.length>=3&&System.String.endsWith(t.v,"'",4))return s=t.v.substr(2,t.v.length-3|0),t.v=System.String.replaceAll(s,"''","'"),!0;return!1},Equals:function(e,t){return null==e&&null==t||null!=e&&null!=t&&System.String.equals(e,t,4)},TrimSingleQuotes:function(e){return System.String.isNullOrWhiteSpace(e)||System.String.startsWith(e,"'",4)&&System.String.endsWith(e,"'",4)&&e.length>=2&&(e=e.substr(1,e.length-2|0)),e},TrimBrackets:function(e){return System.String.startsWith(e,"[",4)&&System.String.endsWith(e,"]",4)&&e.length>=2&&(e=e.substr(1,e.length-2|0)),e},InitArray:function(e,t,n){if(null!=t)for(var s=0;s<t.length;s=s+1|0)t[System.Array.index(s,t)]=n},GetLiteral:function(e){return Kusto.Cloud.Platform.Text.StringLiteral.GetLiteral$1(e,!1)},GetLiteral$1:function(e,t){var n,s,i;if(null==e)return null;s=new System.Text.StringBuilder,t&&s.append("h"),s.append('"'),n=Bridge.getEnumerator(e);try{for(;n.moveNext();)switch(i=n.Current){case 39:s.append("\\'");break;case 34:s.append('\\"');break;case 92:s.append("\\\\");break;case 0:s.append("\\0");break;case 7:s.append("\\a");break;case 8:s.append("\\b");break;case 12:s.append("\\f");break;case 10:s.append("\\n");break;case 13:s.append("\\r");break;case 9:s.append("\\t");break;case 11:s.append("\\v");break;default:Kusto.Cloud.Platform.Text.StringLiteral.ShouldBeEscaped(i)?(s.append("\\u"),s.append(System.UInt16.format(i,"x4"))):s.append(String.fromCharCode(i))}}finally{Bridge.is(n,System.IDisposable)&&n.System$IDisposable$Dispose()}return s.append('"'),s.toString()},GetLiteralAsHiddenString:function(e){return Kusto.Cloud.Platform.Text.StringLiteral.GetLiteral$1(e,!0)},ShouldBeEscaped:function(e){return!Kusto.Cloud.Platform.Text.StringLiteral.IsLatin1(e)||14===Kusto.Cloud.Platform.Text.StringLiteral.GetLatin1UnicodeCategory(e)},GetLatin1UnicodeCategory:function(e){return Kusto.Cloud.Platform.Text.StringLiteral.categoryForLatin1[System.Array.index(e,Kusto.Cloud.Platform.Text.StringLiteral.categoryForLatin1)]},IsLatin1:function(e){return e<=255},IsAscii:function(e){return e<=127}}}}),Bridge.define("Kusto.Cloud.Platform.Utils.BitTwiddling",{statics:{methods:{CountBits:function(e){for(var t=0;0!==e;)e&=e-1|0,t=t+1|0;return t},CountBits$1:function(e){for(var t=0;e.ne(System.Int64(0));)e=e.and(e.sub(System.Int64(1))),t=t+1|0;return t}}}}),Bridge.define("Kusto.Cloud.Platform.Utils.ChopOptions",{$kind:"enum",statics:{fields:{ChopFromBeginning:1,ChopFromEnd:2,ChopFromMiddle:4,ThreeDotsCharacterNotSupported:8}}}),Bridge.define("Kusto.Cloud.Platform.Utils.DateTimeRange",{inherits:function(){return[System.IEquatable$1(Kusto.Cloud.Platform.Utils.DateTimeRange)]},statics:{fields:{All:null},ctors:{init:function(){this.All=new Kusto.Cloud.Platform.Utils.DateTimeRange(Kusto.Cloud.Platform.Utils.ExtendedDateTime.MinValueUtc,Kusto.Cloud.Platform.Utils.ExtendedDateTime.MaxValueUtc)}},methods:{Aggregate:function(e,t){return new Kusto.Cloud.Platform.Utils.DateTimeRange(System.DateTime.gt(e.Begin,t.Begin)?t.Begin:e.Begin,System.DateTime.gt(e.End,t.End)?e.End:t.End)},Merge:function(t){var n,s,i,r,a=new(System.Collections.Generic.List$1(Kusto.Cloud.Platform.Utils.DateTimeRange).ctor);if(Kusto.Cloud.Platform.Utils.ExtendedEnumerable.SafeFastNone$2(Kusto.Cloud.Platform.Utils.DateTimeRange,t))return a;i=(s=System.Linq.Enumerable.from(t,Kusto.Cloud.Platform.Utils.DateTimeRange).orderBy(e.$.Kusto.Cloud.Platform.Utils.DateTimeRange.f1)).first().Clone(),a.add(i),n=Bridge.getEnumerator(s);try{for(;n.moveNext();)r=n.Current,System.DateTime.lte(r.Begin,i.End)?System.DateTime.lt(i.End,r.End)&&(i.End=r.End):(i=r.Clone(),a.add(i))}finally{Bridge.is(n,System.IDisposable)&&n.System$IDisposable$Dispose()}return a},Intersect:function(e,t){var n,s,i,r,a;if(Kusto.Cloud.Platform.Utils.ExtendedEnumerable.SafeFastNone$2(Kusto.Cloud.Platform.Utils.DateTimeRange,e)||Kusto.Cloud.Platform.Utils.ExtendedEnumerable.SafeFastNone$2(Kusto.Cloud.Platform.Utils.DateTimeRange,t))return new(System.Collections.Generic.List$1(Kusto.Cloud.Platform.Utils.DateTimeRange).ctor);r=new(System.Collections.Generic.HashSet$1(Kusto.Cloud.Platform.Utils.DateTimeRange).ctor),n=Bridge.getEnumerator(e,Kusto.Cloud.Platform.Utils.DateTimeRange);try{for(;n.moveNext();){a=n.Current,s=Bridge.getEnumerator(t,Kusto.Cloud.Platform.Utils.DateTimeRange);try{for(;s.moveNext();){var o=s.Current,l=System.DateTime.create$2(System.Int64.max(System.DateTime.getTicks(a.Begin),System.DateTime.getTicks(o.Begin)),1),u=System.DateTime.create$2(System.Int64.min(System.DateTime.getTicks(a.End),System.DateTime.getTicks(o.End)),1);System.DateTime.lte(l,u)&&r.add(new Kusto.Cloud.Platform.Utils.DateTimeRange(l,u))}}finally{Bridge.is(s,System.IDisposable)&&s.System$IDisposable$Dispose()}}}finally{Bridge.is(n,System.IDisposable)&&n.System$IDisposable$Dispose()}return i=Kusto.Cloud.Platform.Utils.DateTimeRange,System.Linq.Enumerable.from(r,i).toList(i)}}},props:{Begin:null,End:null,Span:{get:function(){return System.DateTime.subdd(this.End,this.Begin)}},IsOpenRange:{get:function(){return Bridge.equalsT(this.Begin,Kusto.Cloud.Platform.Utils.ExtendedDateTime.MinValueUtc)||Bridge.equalsT(this.End,Kusto.Cloud.Platform.Utils.ExtendedDateTime.MaxValueUtc)}}},alias:["equalsT","System$IEquatable$1$Kusto$Cloud$Platform$Utils$DateTimeRange$equalsT"],ctors:{init:function(){this.Begin=System.DateTime.getDefaultValue(),this.End=System.DateTime.getDefaultValue()},ctor:function(e,t){throw this.$initialize(),this.Begin=e,this.End=t,new System.ArgumentException.$ctor1("DateTimeRange construction: End parameter should be later than Begin parameter")}},methods:{Clone:function(){return new Kusto.Cloud.Platform.Utils.DateTimeRange(this.Begin,this.End)},equalsT:function(e){return null!=e&&(Bridge.equalsT(this.Begin,e.Begin)&&Bridge.equalsT(this.End,e.End))},equals:function(e){return this.equalsT(Bridge.as(e,Kusto.Cloud.Platform.Utils.DateTimeRange))},getHashCode:function(){return Bridge.getHashCode(this.Begin)^Bridge.getHashCode(this.End)},toString:function(){return System.String.formatProvider(System.Globalization.CultureInfo.invariantCulture,"[Begin={0}, End={1}]",System.DateTime.format(this.Begin,"R"),System.DateTime.format(this.End,"R"))}}}),Bridge.ns("Kusto.Cloud.Platform.Utils.DateTimeRange",e.$),Bridge.apply(e.$.Kusto.Cloud.Platform.Utils.DateTimeRange,{f1:function(e){return e.Begin}}),Bridge.define("Kusto.Cloud.Platform.Utils.ExtendedDateTime",{statics:{fields:{TicksPerMillisecond:System.Int64(0),TicksPerSecond:System.Int64(0),TicksPerMinute:System.Int64(0),TicksPerHour:System.Int64(0),TicksPerDay:System.Int64(0),MillisPerSecond:0,MillisPerMinute:0,MillisPerHour:0,MillisPerDay:0,DaysPerYear:0,DaysPer4Years:0,DaysPer100Years:0,DaysPer400Years:0,DaysTo1601:0,DaysTo1899:0,DaysTo1970:0,DaysTo10000:0,MinTicks:System.Int64(0),MaxTicks:System.Int64(0),MaxMillis:System.Int64(0),FileTimeOffset:System.Int64(0),DoubleDateOffset:System.Int64(0),OADateMinAsTicks:System.Int64(0),OADateMinAsDouble:0,OADateMaxAsDouble:0,DatePartYear:0,DatePartDayOfYear:0,DatePartMonth:0,DatePartDay:0,MinValueUtc:null,MaxValueUtc:null,SupportedNonStandardFormats:null,EpochStart:null,s_simulating:!1,s_simulatedUtcNow:null,s_numCharactersInIso8601:0,ts_lastUtcNow:null,ts_lastUtcNowAsString:null,DaysToMonth365:null,DaysToMonth366:null},events:{OnSimulatedTimeChange:null,OnStopSimulatingTime:null},props:{IsSimulatingTime:{get:function(){return Kusto.Cloud.Platform.Utils.ExtendedDateTime.s_simulating}},UtcNow:{get:function(){return Kusto.Cloud.Platform.Utils.ExtendedDateTime.s_simulating?Kusto.Cloud.Platform.Utils.ExtendedDateTime.s_simulatedUtcNow:System.DateTime.getUtcNow()}}},ctors:{init:function(){this.MinValueUtc=System.DateTime.getDefaultValue(),this.MaxValueUtc=System.DateTime.getDefaultValue(),this.EpochStart=System.DateTime.getDefaultValue(),this.s_simulatedUtcNow=System.DateTime.getDefaultValue(),this.ts_lastUtcNow=System.DateTime.getDefaultValue(),this.TicksPerMillisecond=System.Int64(1e4),this.TicksPerSecond=System.Int64(1e7),this.TicksPerMinute=System.Int64(6e8),this.TicksPerHour=System.Int64([1640261632,8]),this.TicksPerDay=System.Int64([711573504,201]),this.MillisPerSecond=1e3,this.MillisPerMinute=6e4,this.MillisPerHour=36e5,this.MillisPerDay=864e5,this.DaysPerYear=365,this.DaysPer4Years=1461,this.DaysPer100Years=36524,this.DaysPer400Years=146097,this.DaysTo1601=584388,this.DaysTo1899=693593,this.DaysTo1970=719162,this.DaysTo10000=3652059,this.MinTicks=System.Int64(0),this.MaxTicks=System.Int64([-197705729,734668917]),this.MaxMillis=System.Int64([-464735232,73466]),this.FileTimeOffset=System.Int64([578224128,117558807]),this.DoubleDateOffset=System.Int64([-880558080,139527104]),this.OADateMinAsTicks=System.Int64([-1362739200,7273949]),this.OADateMinAsDouble=-657435,this.OADateMaxAsDouble=2958466,this.DatePartYear=0,this.DatePartDayOfYear=1,this.DatePartMonth=2,this.DatePartDay=3,this.MinValueUtc=System.DateTime.create$2(System.DateTime.getTicks(System.DateTime.getMinValue()),1),this.MaxValueUtc=System.DateTime.create$2(System.DateTime.getTicks(System.DateTime.getMaxValue()),1),this.SupportedNonStandardFormats=e.$.Kusto.Cloud.Platform.Utils.ExtendedDateTime.f1(new(System.Collections.Generic.Dictionary$2(System.Int32,System.Array.type(System.String)).ctor)),this.EpochStart=System.DateTime.create(1970,1,1,0,0,0,0,1),this.s_numCharactersInIso8601=System.DateTime.format(Kusto.Cloud.Platform.Utils.ExtendedDateTime.MinValueUtc,"O").length,this.ts_lastUtcNow=Kusto.Cloud.Platform.Utils.ExtendedDateTime.MinValueUtc,this.ts_lastUtcNowAsString=System.DateTime.format(Kusto.Cloud.Platform.Utils.ExtendedDateTime.ts_lastUtcNow,"O"),this.DaysToMonth365=System.Array.init([0,31,59,90,120,151,181,212,243,273,304,334,365],System.Int32),this.DaysToMonth366=System.Array.init([0,31,60,91,121,152,182,213,244,274,305,335,366],System.Int32)}},methods:{StopSimulatingTime:function(){Kusto.Cloud.Platform.Utils.ExtendedDateTime.s_simulating=!1,Bridge.staticEquals(Kusto.Cloud.Platform.Utils.ExtendedDateTime.OnStopSimulatingTime,null)||Kusto.Cloud.Platform.Utils.ExtendedDateTime.OnStopSimulatingTime()},ToUtcString:function(e){var t=e,n=t;return 0===System.DateTime.getKind(t)?n=System.DateTime.create$2(System.DateTime.getTicks(e),1):2===System.DateTime.getKind(t)&&(n=System.DateTime.toUniversalTime(t)),System.String.format("{0:yyyy-MM-dd HH:mm:ss.fffffff}",[Bridge.box(n,System.DateTime,System.DateTime.format)])},Max:function(e,t){return System.DateTime.gt(e,t)?e:t},Max$1:function(e,t){return Bridge.equals(t,null)?e:Bridge.equals(e,null)?t:Kusto.Cloud.Platform.Utils.ExtendedDateTime.Max(System.Nullable.getValue(e),System.Nullable.getValue(t))},Min:function(e,t){return System.DateTime.lt(e,t)?e:t},Min$1:function(e,t){return Bridge.equals(t,null)?e:Bridge.equals(e,null)?t:Kusto.Cloud.Platform.Utils.ExtendedDateTime.Min(System.Nullable.getValue(e),System.Nullable.getValue(t))},RangesIntersect:function(e,t,n,s){return System.DateTime.gte(e,n)&&System.DateTime.lte(e,s)||System.DateTime.gte(t,n)&&System.DateTime.lte(t,s)||System.DateTime.gte(n,e)&&System.DateTime.lte(n,t)||System.DateTime.gte(s,e)&&System.DateTime.lte(s,t)},ToUnixTimeSpan:function(e){return System.DateTime.subdd(System.DateTime.toUniversalTime(e),Kusto.Cloud.Platform.Utils.ExtendedDateTime.EpochStart)},FromTimeSpan:function(e){return System.DateTime.create$2(e.getTicks())},ToUtc:function(e){switch(System.DateTime.getKind(e)){case 1:return e;case 0:return System.DateTime.create$2(System.DateTime.getTicks(e),1);case 2:return System.DateTime.toUniversalTime(e);default:throw new System.ArgumentException.$ctor1(System.String.format("DateTimeKind: {0} is not supported",[Bridge.box(System.DateTime.getKind(e),System.DateTimeKind,System.Enum.toStringFn(System.DateTimeKind))]))}},FastAppendFormattedInt7:function(e,t){var n,s,i,r,a,o,l=System.Int64.clipu16(System.Int64(48).add(t.mod(System.Int64(10))));t=t.div(System.Int64(10)),n=System.Int64.clipu16(System.Int64(48).add(t.mod(System.Int64(10)))),t=t.div(System.Int64(10)),s=System.Int64.clipu16(System.Int64(48).add(t.mod(System.Int64(10)))),t=t.div(System.Int64(10)),i=System.Int64.clipu16(System.Int64(48).add(t.mod(System.Int64(10)))),t=t.div(System.Int64(10)),r=System.Int64.clipu16(System.Int64(48).add(t.mod(System.Int64(10)))),t=t.div(System.Int64(10)),a=System.Int64.clipu16(System.Int64(48).add(t.mod(System.Int64(10)))),t=t.div(System.Int64(10)),o=System.Int64.clipu16(System.Int64(48).add(t.mod(System.Int64(10)))),e.append(String.fromCharCode(o)),e.append(String.fromCharCode(a)),e.append(String.fromCharCode(r)),e.append(String.fromCharCode(i)),e.append(String.fromCharCode(s)),e.append(String.fromCharCode(n)),e.append(String.fromCharCode(l))},FastAppendFormattedInt4:function(e,t){var n,s,i,r=65535&(48+t%10|0);n=65535&(48+(t=0|Bridge.Int.div(t,10))%10|0),s=65535&(48+(t=0|Bridge.Int.div(t,10))%10|0),i=65535&(48+(t=0|Bridge.Int.div(t,10))%10|0),e.append(String.fromCharCode(i)),e.append(String.fromCharCode(s)),e.append(String.fromCharCode(n)),e.append(String.fromCharCode(r))},FastAppendFormattedInt2:function(e,t){var n,s=65535&(48+t%10|0);n=65535&(48+(t=0|Bridge.Int.div(t,10))%10|0),e.append(String.fromCharCode(n)),e.append(String.fromCharCode(s))},FastGetParts:function(e,t,n,s,i,r,a,o){var l,u,d,m=System.DateTime.getTicks(e),c=System.Int64.clip32(m.div(Kusto.Cloud.Platform.Utils.ExtendedDateTime.TicksPerDay)),p=0|Bridge.Int.div(c,Kusto.Cloud.Platform.Utils.ExtendedDateTime.DaysPer400Years);c=c-Bridge.Int.mul(p,Kusto.Cloud.Platform.Utils.ExtendedDateTime.DaysPer400Years)|0,4===(l=0|Bridge.Int.div(c,Kusto.Cloud.Platform.Utils.ExtendedDateTime.DaysPer100Years))&&(l=3),c=c-Bridge.Int.mul(l,Kusto.Cloud.Platform.Utils.ExtendedDateTime.DaysPer100Years)|0,u=0|Bridge.Int.div(c,Kusto.Cloud.Platform.Utils.ExtendedDateTime.DaysPer4Years),c=c-Bridge.Int.mul(u,Kusto.Cloud.Platform.Utils.ExtendedDateTime.DaysPer4Years)|0,4===(d=0|Bridge.Int.div(c,Kusto.Cloud.Platform.Utils.ExtendedDateTime.DaysPerYear))&&(d=3),t.v=1+(((Bridge.Int.mul(p,400)+Bridge.Int.mul(l,100)|0)+Bridge.Int.mul(u,4)|0)+d|0)|0,c=c-Bridge.Int.mul(d,Kusto.Cloud.Platform.Utils.ExtendedDateTime.DaysPerYear)|0;for(var S=3===d&&(24!==u||3===l)?Kusto.Cloud.Platform.Utils.ExtendedDateTime.DaysToMonth366:Kusto.Cloud.Platform.Utils.ExtendedDateTime.DaysToMonth365,g=c>>6;c>=S[System.Array.index(g,S)];)g=g+1|0;n.v=g,s.v=1+(c-S[System.Array.index(g-1|0,S)]|0)|0,i.v=System.DateTime.getHour(e),r.v=System.DateTime.getMinute(e),a.v=System.DateTime.getSecond(e),o.v=m.mod(Kusto.Cloud.Platform.Utils.ExtendedDateTime.TicksPerSecond)},FromUnixTimeSeconds$1:function(e){return System.DateTimeOffset.FromUnixTimeSeconds(e).UtcDateTime},FromUnixTimeSeconds:function(e){var t=Bridge.Int.clip64(e),n=Bridge.Int.clip64((e-System.Int64.toNumber(t))*Kusto.Cloud.Platform.Utils.ExtendedDateTime.TicksPerSecond);return System.DateTimeOffset.FromUnixTimeSeconds(t).AddTicks(n).UtcDateTime},FromUnixTimeMilliseconds$1:function(e){return System.DateTimeOffset.FromUnixTimeMilliseconds(e).UtcDateTime},FromUnixTimeMilliseconds:function(e){var t=Bridge.Int.clip64(e),n=Bridge.Int.clip64((e-System.Int64.toNumber(t))*Kusto.Cloud.Platform.Utils.ExtendedDateTime.TicksPerMillisecond);return System.DateTimeOffset.FromUnixTimeMilliseconds(t).AddTicks(n).UtcDateTime},FromUnixTimeMicroseconds$1:function(e){var t=System.Int64(10),n=System.Int64(1e3),s=e.div(n),i=e.sub(s.mul(n)).mul(t);return System.DateTimeOffset.FromUnixTimeMilliseconds(s).AddTicks(i).UtcDateTime},FromUnixTimeMicroseconds:function(e){var t=System.Int64(10),n=System.Int64(1e3),s=Bridge.Int.clip64(e/n),i=Bridge.Int.clip64((e-System.Int64.toNumber(s.mul(n)))*t);return System.DateTimeOffset.FromUnixTimeMilliseconds(s).AddTicks(i).UtcDateTime},FromUnixTimeNanoseconds:function(e){var t=System.Int64(100),n=System.Int64(1e6),s=e.div(n),i=e.sub(s.mul(n)).div(t);return System.DateTimeOffset.FromUnixTimeMilliseconds(s).AddTicks(i).UtcDateTime}}}}),Bridge.ns("Kusto.Cloud.Platform.Utils.ExtendedDateTime",e.$),Bridge.apply(e.$.Kusto.Cloud.Platform.Utils.ExtendedDateTime,{f1:function(e){return e.add(4,System.Array.init(["yyyy"],System.String)),e.add(6,System.Array.init(["yyyyMM"],System.String)),e.add(8,System.Array.init(["yyyyMMdd"],System.String)),e.add(10,System.Array.init(["yyyyMMddHH"],System.String)),e.add(12,System.Array.init(["yyyyMMddHHmm"],System.String)),e.add(14,System.Array.init(["yyyyMMddHHmmss"],System.String)),e.add(17,System.Array.init(["yyyyMMdd HH:mm:ss"],System.String)),e.add(19,System.Array.init(["yyyyMMdd HH:mm:ss.f"],System.String)),e.add(20,System.Array.init(["yyyyMMdd HH:mm:ss.ff"],System.String)),e.add(21,System.Array.init(["yyyyMMdd HH:mm:ss.fff"],System.String)),e.add(22,System.Array.init(["yyyyMMdd HH:mm:ss.ffff"],System.String)),e.add(23,System.Array.init(["yyyyMMdd HH:mm:ss.fffff"],System.String)),e.add(24,System.Array.init(["yyyyMMdd HH:mm:ss.ffffff"],System.String)),e.add(25,System.Array.init(["yyyyMMdd HH:mm:ss.fffffff"],System.String)),e}}),Bridge.define("Kusto.Cloud.Platform.Utils.ExtendedDateTime.RoundTo",{$kind:"nested enum",statics:{fields:{Second:0,Minute:1,Hour:2,Day:3}}}),Bridge.define("Kusto.Cloud.Platform.Utils.ExtendedEnumerable",{statics:{methods:{SafeFastDistinct:function(e,t){var n,s;return null==t?null:null!=(n=Bridge.as(t,System.Collections.Generic.ICollection$1(e)))&&System.Array.getCount(n,e)<=1||null!=(s=Bridge.as(t,System.Collections.ICollection))&&System.Array.getCount(s)<=1?t:System.Linq.Enumerable.from(t,e).distinct()},SafeSequenceEquals:function(t,n,s,i){void 0===i&&(i=null);var r=Kusto.Cloud.Platform.Utils.ExtendedEnumerable.BasicCompare(t,n,s);return System.Nullable.hasValue(r)?System.Nullable.getValue(r):System.Linq.Enumerable.from(System.Linq.Enumerable.from(n,t).orderBy(e.$.Kusto.Cloud.Platform.Utils.ExtendedEnumerable.f1),t).sequenceEqual(System.Linq.Enumerable.from(s,t).orderBy(e.$.Kusto.Cloud.Platform.Utils.ExtendedEnumerable.f2),i)},SortedSequenceEquals:function(e,t,n,s){void 0===s&&(s=null);var i=Kusto.Cloud.Platform.Utils.ExtendedEnumerable.BasicCompare(e,t,n);return System.Nullable.hasValue(i)?System.Nullable.getValue(i):System.Linq.Enumerable.from(t,e).sequenceEqual(n,s)},SequenceEqual:function(e,t,n,s){var i,r,a=Kusto.Cloud.Platform.Utils.ExtendedEnumerable.BasicCompare(e,t,n);if(System.Nullable.hasValue(a))return System.Nullable.getValue(a);i=Bridge.getEnumerator(t,e);try{r=Bridge.getEnumerator(n,e);try{for(;i.System$Collections$IEnumerator$moveNext();)if(!r.System$Collections$IEnumerator$moveNext()||!s(i[Bridge.geti(i,"System$Collections$Generic$IEnumerator$1$"+Bridge.getTypeAlias(e)+"$Current$1","System$Collections$Generic$IEnumerator$1$Current$1")],r[Bridge.geti(r,"System$Collections$Generic$IEnumerator$1$"+Bridge.getTypeAlias(e)+"$Current$1","System$Collections$Generic$IEnumerator$1$Current$1")]))return!1;if(r.System$Collections$IEnumerator$moveNext())return!1}finally{Bridge.hasValue(r)&&r.System$IDisposable$Dispose()}}finally{Bridge.hasValue(i)&&i.System$IDisposable$Dispose()}return!0},BasicCompare:function(e,t,n){if(Bridge.referenceEquals(t,n))return!0;if(null==t||null==n)return!1;var s=Kusto.Cloud.Platform.Utils.ExtendedEnumerable.GetSequenceLength(e,t),i=Kusto.Cloud.Platform.Utils.ExtendedEnumerable.GetSequenceLength(e,n);return!(System.Nullable.hasValue(s)&&System.Nullable.hasValue(i)&&System.Nullable.getValue(s).ne(System.Nullable.getValue(i)))&&null},GetSequenceLength:function(e,t){var n,s,i,r;return null!=(n=Bridge.as(t,System.Array.type(e)))?System.Int64.lift(n.length):null!=(s=Bridge.as(t,System.Collections.Generic.IReadOnlyCollection$1(e)))?System.Int64.lift(System.Array.getCount(s,e)):null!=(i=Bridge.as(t,System.Collections.Generic.ICollection$1(e)))?System.Int64.lift(System.Array.getCount(i,e)):null!=(r=Bridge.as(t,System.Collections.ICollection))?System.Int64.lift(System.Array.getCount(r)):System.Int64.lift(null)},ToDisplayString:function(e,t,n,s,i,r){var a,o,l,u,d,m;if(void 0===n&&(n=", "),void 0===s&&(s=null),void 0===i&&(i="[null]"),void 0===r&&(r=128),Kusto.Cloud.Platform.Utils.ExtendedEnumerable.SafeFastNone$2(e,t)||System.Nullable.lte(s,0))return"";n=null!=(a=n)?a:", ",i=null!=(o=i)?o:"[null]";var c=new System.Text.StringBuilder("",r),p=0,S=Bridge.getEnumerator(t,e);try{for(S.System$Collections$IEnumerator$moveNext()&&(c.append(null!=(l=null!=(u=S[Bridge.geti(S,"System$Collections$Generic$IEnumerator$1$"+Bridge.getTypeAlias(e)+"$Current$1","System$Collections$Generic$IEnumerator$1$Current$1")])?Bridge.toString(u):null)?l:i),p=p+1|0);S.System$Collections$IEnumerator$moveNext()&&!System.Nullable.gte(p,s);)c.append(n),c.append(null!=(d=null!=(m=S[Bridge.geti(S,"System$Collections$Generic$IEnumerator$1$"+Bridge.getTypeAlias(e)+"$Current$1","System$Collections$Generic$IEnumerator$1$Current$1")])?Bridge.toString(m):null)?d:i),p=p+1|0;S.System$Collections$IEnumerator$moveNext()&&(c=c.append(n).append("... more"))}finally{Bridge.hasValue(S)&&S.System$IDisposable$Dispose()}return c.toString()},SafeShallowClone:function(e,t){return null==t?null:new(System.Collections.Generic.List$1(e).$ctor1)(t)},IndexOf:function(e,t,n){var s,i;if(Bridge.staticEquals(n,null)||null==t)return-1;i=0,s=Bridge.getEnumerator(t,e);try{for(;s.moveNext();){if(n(s.Current))return i;i=i+1|0}}finally{Bridge.is(s,System.IDisposable)&&s.System$IDisposable$Dispose()}return-1},SafeConcat:function(e,t,n){return null==t?n:null==n?t:System.Linq.Enumerable.from(t,e).concat(n)},SafeUnion:function(e,t,n){return null==t&&null==n?null:null==t?System.Linq.Enumerable.from(n,e).distinct():null==n?System.Linq.Enumerable.from(t,e).distinct():System.Linq.Enumerable.from(t,e).union(n)},SafeFastNullIfEmpty:function(e,t){return null==t||Kusto.Cloud.Platform.Utils.ExtendedEnumerable.SafeFastNone(t)?null:t},SafeEmptyIEnumerableIfNull:function(e,t){return t||System.Linq.Enumerable.empty()},SafeFastAny$2:function(e,t){var n,s;return null!=t&&(null!=(n=Bridge.as(t,System.Collections.ICollection))?0!==System.Array.getCount(n):null!=(s=Bridge.as(t,System.Collections.Generic.IReadOnlyCollection$1(e)))?0!==System.Array.getCount(s,e):System.Linq.Enumerable.from(t,e).any())},SafeFastAny$1:function(e,t){return null!=t&&System.Array.getCount(t,e)>0},SafeFastAny:function(e){var t,n,s;if(null==e)return!1;if(null!=(n=Bridge.as(e,System.Collections.ICollection)))return 0!==System.Array.getCount(n);s=Bridge.getEnumerator(e),t=Bridge.as(s,System.IDisposable);try{if(s.System$Collections$IEnumerator$moveNext())return!0}finally{Bridge.hasValue(t)&&t.System$IDisposable$Dispose()}return!1},SafeFastAny$3:function(e,t,n){return!!Kusto.Cloud.Platform.Utils.ExtendedEnumerable.SafeFastAny$2(e,t)&&System.Linq.Enumerable.from(t,e).any(n)},SafeFastNone$2:function(e,t){return!Kusto.Cloud.Platform.Utils.ExtendedEnumerable.SafeFastAny$2(e,t)},SafeFastNone$1:function(e,t){return!Kusto.Cloud.Platform.Utils.ExtendedEnumerable.SafeFastAny$1(e,t)},SafeFastNone:function(e){return!Kusto.Cloud.Platform.Utils.ExtendedEnumerable.SafeFastAny(e)},SafeFastNone$3:function(e,t,n){return!Kusto.Cloud.Platform.Utils.ExtendedEnumerable.SafeFastAny$3(e,t,n)},None$1:function(e,t,n){return!System.Linq.Enumerable.from(t,e).any(n)},None:function(e,t){return Kusto.Cloud.Platform.Utils.ExtendedEnumerable.SafeFastNone$2(e,t)},SafeFastContains:function(e,t,n,s){return void 0===s&&(s=null),!Kusto.Cloud.Platform.Utils.ExtendedEnumerable.SafeFastNone$2(e,t)&&System.Linq.Enumerable.from(t,e).contains(n,s)},DistinctBy:function(t,n,s,i){return System.Linq.Enumerable.from(s,t).groupBy(i).select(e.$.Kusto.Cloud.Platform.Utils.ExtendedEnumerable.f3)},Intersect:function(e,t){var n,s;if(Kusto.Cloud.Platform.Utils.ExtendedEnumerable.SafeFastNone$2(System.Collections.Generic.IEnumerable$1(e),t))return null;if((n=Bridge.getEnumerator(t,System.Collections.Generic.IEnumerable$1(e))).System$Collections$IEnumerator$moveNext()){for(s=new(System.Collections.Generic.HashSet$1(e).$ctor1)(n[Bridge.geti(n,"System$Collections$Generic$IEnumerator$1$System$Collections$Generic$IEnumerable$1$"+Bridge.getTypeAlias(e)+"$Current$1","System$Collections$Generic$IEnumerator$1$Current$1")]);n.System$Collections$IEnumerator$moveNext();)s.intersectWith(n[Bridge.geti(n,"System$Collections$Generic$IEnumerator$1$System$Collections$Generic$IEnumerable$1$"+Bridge.getTypeAlias(e)+"$Current$1","System$Collections$Generic$IEnumerator$1$Current$1")]);return s}return null},IntersectWith:function(e,t,n){if(Kusto.Cloud.Platform.Utils.ExtendedEnumerable.SafeFastNone$2(e,t))return n;if(Kusto.Cloud.Platform.Utils.ExtendedEnumerable.SafeFastNone$2(e,n))return t;var s=new(System.Collections.Generic.HashSet$1(e).$ctor1)(t);return s.intersectWith(n),s}}}}),Bridge.ns("Kusto.Cloud.Platform.Utils.ExtendedEnumerable",e.$),Bridge.apply(e.$.Kusto.Cloud.Platform.Utils.ExtendedEnumerable,{f1:function(e){return e},f2:function(e){return e},f3:function(e){return e.first()}}),Bridge.define("Kusto.Cloud.Platform.Utils.ExtendedRegex",{statics:{methods:{TryUnescape:function(e,t){t.v="";try{return t.v=System.Text.RegularExpressions.Regex.unescape(e),!0}catch(e){if(e=System.Exception.create(e),Bridge.is(e,System.ArgumentException))return!1;throw e}},TryTransformWildCardPatternToRegex:function(e){try{var t=System.String.trim(e,[91,93]),n=System.String.replaceAll(t,"*",".*");return new System.Text.RegularExpressions.Regex.ctor(n,0)}catch(e){return e=System.Exception.create(e),null}},IsWildCardPattern:function(e){return System.String.indexOf(e,String.fromCharCode(42))>=0},RegexEquals:function(e,t){return!!Bridge.referenceEquals(e,t)||null!=e&&null!=t&&null!=(n=Bridge.as(t,System.Text.RegularExpressions.Regex))&&Kusto.Cloud.Platform.Utils.ExtendedRegex.RegexEquals$1(e,n);var n},RegexEquals$1:function(e,t){return!!Bridge.referenceEquals(e,t)||null!=e&&null!=t&&(System.String.equals(Bridge.toString(e),Bridge.toString(t))&&e.getOptions()===t.getOptions()&&System.TimeSpan.eq(e.getMatchTimeout(),t.getMatchTimeout()))},RegexEquivalent:function(e,t){return!!Bridge.referenceEquals(e,t)||null!=e&&null!=t&&(System.String.equals(Bridge.toString(e),Bridge.toString(t))&&e.getOptions()===t.getOptions())}}}}),Bridge.define("Kusto.Cloud.Platform.Utils.ExtendedString",{statics:{fields:{c_postfix:null,c_wrap:null,c_newlineAsStringArray:null,c_nullGuids:null,SafeToString:null,EmptyArray:null,s_alternativeSpaceChars:null,s_alternativeNewlineChars:null},ctors:{init:function(){this.c_postfix="...",this.c_wrap="  ",this.c_newlineAsStringArray=System.Array.init(["\n"],System.String),this.c_nullGuids=System.Array.init([System.Guid.Empty.toString(),"{"+(System.Guid.Empty.toString()||"")+"}"],System.String),this.SafeToString=e.$.Kusto.Cloud.Platform.Utils.ExtendedString.f1,this.EmptyArray=System.Array.init(0,null,System.String),this.s_alternativeSpaceChars=e.$.Kusto.Cloud.Platform.Utils.ExtendedString.f2(new(System.Collections.Generic.HashSet$1(System.Char).ctor)),this.s_alternativeNewlineChars=e.$.Kusto.Cloud.Platform.Utils.ExtendedString.f3(new(System.Collections.Generic.HashSet$1(System.Char).ctor))}},methods:{SafeGetHashCode:function(e){return null==e?20080512:Bridge.getHashCode(e)},GuidSafeFastGetHashCode:function(e){return null==e||e.length<26?Kusto.Cloud.Platform.Utils.ExtendedString.SafeGetHashCode(e):(e.charCodeAt(1)^e.charCodeAt(9)<<8|e.charCodeAt(10))^(e.charCodeAt(16)<<16|e.charCodeAt(17))^(e.charCodeAt(24)<<24|e.charCodeAt(25))},SafeToTraceString:function(e){return null==e?"[null]":0===e.length?"[empty]":e},SafeFormat:function(e,t){var n,s,i,r,a;if(void 0===t&&(t=[]),null==e)return"[format:null]";if(null==t||0===t.length)return System.String.format.apply(System.String,[e].concat(t));for(n=System.Array.init(t.length,null,System.String),s=0;s<t.length;s=s+1|0)null==(i=t[System.Array.index(s,t)])?r="[null]":r=null==(a=Bridge.toString(i))?"[ToStringNull]":0===a.length?"[ToStringEmpty]":System.String.isNullOrWhiteSpace(a)?"[ToStringWhitespace]":a,n[System.Array.index(s,n)]=r;return System.String.format.apply(System.String,[e].concat(n))},FormatWithCurrentCulture:function(e,t){return void 0===t&&(t=[]),Kusto.Cloud.Platform.Utils.ExtendedString.FormatWith(e,System.Globalization.CultureInfo.getCurrentCulture(),t)},FormatWithInvariantCulture:function(e,t){return void 0===t&&(t=[]),Kusto.Cloud.Platform.Utils.ExtendedString.FormatWith(e,System.Globalization.CultureInfo.invariantCulture,t)},FormatWith:function(e,t,n){return void 0===n&&(n=[]),System.String.formatProvider.apply(System.String,[t,e].concat(n))},SafeIsNullGuid:function(e){return System.String.isNullOrWhiteSpace(e)||Bridge.referenceEquals(e,Kusto.Cloud.Platform.Utils.ExtendedString.c_nullGuids[System.Array.index(0,Kusto.Cloud.Platform.Utils.ExtendedString.c_nullGuids)])||Bridge.referenceEquals(e,Kusto.Cloud.Platform.Utils.ExtendedString.c_nullGuids[System.Array.index(1,Kusto.Cloud.Platform.Utils.ExtendedString.c_nullGuids)])},GetDiff:function(e,t){var n;if(Bridge.referenceEquals(e,t))return null==e?"Strings are the same (both null)":Bridge.referenceEquals(e,"")?"Strings are the same (both empty)":"Strings are the same";if(null==e)return"LHS is null, RHS is not";if(null==t)return"RHS is null, LHS is not";for(n=0;n<Math.min(e.length,t.length);n=n+1|0)if(e.charCodeAt(n)!==t.charCodeAt(n)){Kusto.Cloud.Platform.Utils.ExtendedString.GetDiffFromPosition(e,t,n);break}return Kusto.Cloud.Platform.Utils.ExtendedString.GetDiffFromPosition(e,t,Math.min(e.length,t.length))},GetDiffFromPosition:function(e,t,n){var s=Math.max(0,n-20|0);return"Strings differ starting from position "+(Bridge.toString(n)||"")+" \nLHS=...'"+(Kusto.Cloud.Platform.Utils.ExtendedString.SafeSubstring(e,s,40)||"")+"'...\nRHS=...'"+(Kusto.Cloud.Platform.Utils.ExtendedString.SafeSubstring(t,s,40)||"")+"'...\n"+(System.String.fromCharCount(32,7+((0===s?n:20)+1|0)|0)||"")+"^"},SafeSubstring:function(e,t,n){return null==e?null:(t=Math.max(0,t))>=e.length||n<=0?"":(n=Math.min(n,e.length-t|0),e.substr(t,n))},SafeIsValidNonEmptyBase64:function(e,t){var n,s,i,r,a;if(void 0===t&&(t=!1),t&&null!=e&&(e=e.trim()),System.String.isNullOrEmpty(e)||e.length%4!=0)return!1;s=-1,i=-1,n=Bridge.getEnumerator(e);try{for(;n.moveNext();)if(r=n.Current,i=i+1|0,!(r>=48&&r<=57||r>=65&&r<=90||r>=97&&r<=122||43===r||47===r)){if(61===r){s=i;break}return!1}}finally{Bridge.is(n,System.IDisposable)&&n.System$IDisposable$Dispose()}if(-1===s)return e.length%4==0;if((e.length-s|0)>3)return!1;for(a=s;a<e.length;a=a+1|0)if(61!==e.charCodeAt(a))return!1;return!0},SafeIsDoubleSlashCommentOrEmptyBlock:function(e){if(System.String.isNullOrWhiteSpace(e))return!0;for(var t,n=!1,s=0;;){if(s>=e.length)return!n;if(47!==(t=e.charCodeAt(s))){if(n)return!1;if(!System.Char.isWhiteSpace(String.fromCharCode(t))&&13!==t&&10!==t)return!1;s=s+1|0}else{if(n){for(;(s=s+1|0)<e.length&&(13!==(t=e.charCodeAt(s))&&10!==t););n=!1}else n=!0;s=s+1|0}}},SafeFastTrim:function(e){return System.String.isNullOrEmpty(e)?e:e.trim()},TrimStart$1:function(e,t,n){return void 0===n&&(n=4),System.String.startsWith(e,t,n)?e.substr(t.length,e.length-t.length|0):e},TrimStart:function(e,t,n){if(System.String.isNullOrEmpty(e))return e;if(n)return e.charCodeAt(0)===t?e.substr(1):e;if(e.charCodeAt(0)!==t)return e;for(var s=0;s<e.length&&e.charCodeAt(s)===t;)s=s+1|0;return s===e.length?"":e.substr(s)},TrimEnd:function(e,t,n){return void 0===n&&(n=4),System.String.endsWith(e,t,n)?e.substr(0,e.length-t.length|0):e},TrimBalancedSquareBrackets:function(e,t){return void 0===t&&(t=4),null!=e&&System.String.startsWith(e,"[",t)&&System.String.endsWith(e,"]",t)&&(e=e.substr(1,e.length-2|0)),e},TrimBalancedRoundBrackets:function(e){return Kusto.Cloud.Platform.Utils.ExtendedString.TrimBalanced(e,"(",")")},TrimBalanced:function(e,t,n,s){return void 0===s&&(s=4),null!=e&&System.String.startsWith(e,t,s)&&System.String.endsWith(e,n,s)&&(e=e.substr(t.length,e.length-(t.length+n.length|0)|0)),e},TrimBalancedSingleAndDoubleQuotes:function(e){if(System.String.isNullOrEmpty(e))return e;for(var t=0,n=e.length-1|0;t<n;)if(34!==e.charCodeAt(t)||34!==e.charCodeAt(n)){if(39!==e.charCodeAt(t)||39!==e.charCodeAt(n))break;t=t+1|0,n=n-1|0}else t=t+1|0,n=n-1|0;return t>n?"":e.substr(t,1+(n-t|0)|0)},DetermineMaxLineWidth:function(e){var t,n,s,i;if(System.String.isNullOrEmpty(e))return 0;for(t=0,n=0,s=0;s<e.length;s=s+1|0)13===(i=e.charCodeAt(s))||10===i?(t=Math.max(t,s-n|0),n=s+1|0):s===(e.length-1|0)&&(t=Math.max(t,1+(s-n|0)|0));return t},SafeCountCharacterUpTo:function(e,t,n){var s,i;if(null==e)return System.Int64(-1);for(s=0,i=0;i<e.length&&(e.charCodeAt(i)===t&&(s=s+1|0),!System.Int64(s).equals(n));i=i+1|0);return System.Int64(s)},SafeCountAnyCharacterUpTo:function(e,t,n){var s,i;if(null==e)return System.Int64(-1);for(s=0,i=0;i<e.length&&(System.Array.contains(t,e.charCodeAt(i),System.Char)&&(s=s+1|0),!System.Int64(s).equals(n));i=i+1|0);return System.Int64(s)},FindFirstNonWhitespaceCharacter:function(e,t){if(void 0===t&&(t=0),null==e)return-1;for(;;){if(t>=e.length)return-1;if(!System.Char.isWhiteSpace(String.fromCharCode(e.charCodeAt(t))))return t;t=t+1|0}},FirstFirstUnequalCharacter:function(e,t){if(Bridge.referenceEquals(e,t))return-1;if(null==e||null==t||0===e.length||0===t.length)return 0;for(var n=0;n<e.length&&n<t.length;n=n+1|0)if(e.charCodeAt(n)!==t.charCodeAt(n))return n;return n},CountNonOverlappingSubstrings$1:function(e,t,n){if(void 0===n&&(n=4),System.String.isNullOrEmpty(e)||System.String.isNullOrEmpty(t))return 0;for(var s=0,i=0;i<e.length;){if((i=System.String.indexOf(e,t,i,null,n))<0)return s;s=s+1|0,i=i+t.length|0}return s},CountNonOverlappingSubstrings:function(e,t){if(System.String.isNullOrEmpty(e))return 0;for(var n=0,s=0;s<e.length;){if((s=System.String.indexOf(e,String.fromCharCode(t),s))<0)return n;n=n+1|0,s=s+1|0}return n},SafeStartsWith:function(e,t){return!System.String.isNullOrEmpty(e)&&e.charCodeAt(0)===t},SafeStartsWith$1:function(e,t,n){return void 0===n&&(n=4),!System.String.isNullOrEmpty(e)&&System.String.startsWith(e,t,n)},EqualsOrdinalIgnoreCase:function(e,t){return System.String.equals(e,t,5)},IsEmpty:function(e){return Bridge.referenceEquals(e,"")},IsNotEmpty:function(e){return!Bridge.referenceEquals(e,"")},IsNullOrEmpty:function(e){return System.String.isNullOrEmpty(e)},IsNotNullOrEmpty:function(e){return!System.String.isNullOrEmpty(e)},SafeGetTail:function(e,t){return null==e?null:t<=0?"":t>=e.length?e:e.substr(e.length-t|0)},SafeIndexOf$1:function(e,t,n,s){return System.String.isNullOrEmpty(e)||System.String.isNullOrEmpty(t)||n>e.length?-1:System.String.indexOf(e,t,n,null,s)},SafeIndexOf:function(e,t,n,s,i){return System.String.isNullOrEmpty(e)||System.String.isNullOrEmpty(t)||(n+t.length|0)>e.length?-1:System.String.indexOf(e,t,n,s,i)},SplitFirst$1:function(e,t,n){var s;return void 0===n&&(n=4),null==e||System.String.isNullOrEmpty(t)?null:(s=System.String.indexOf(e,t,0,null,n))<0?e:e.substr(0,s)},SplitFirst:function(e,t){var n;return null==e?null:(n=System.String.indexOf(e,String.fromCharCode(t)))<0?e:e.substr(0,n)},Rotate:function(e){return System.String.isNullOrEmpty(e)||e.length<2?e:(e.substr(1,e.length-1|0)||"")+(e.substr(0,1)||"")},AdjustNewLineDelimiter:function(e){for(var t,n=System.String.toCharArray(e,0,e.length),s=new System.Text.StringBuilder,i=0;i<n.length;i=i+1|0)switch(t=n[System.Array.index(i,n)]){case 13:i<(n.length-1|0)&&10===n[System.Array.index(i+1|0,n)]&&(i=i+1|0),s.append("\n");break;case 10:s.append("\n");break;default:s.append(String.fromCharCode(t))}return s.toString()},ReplaceInvisibleWhitespaces:function(e){var t,n,s;if(System.String.isNullOrEmpty(e))return e;for(t=null,n=0;n<e.length;n=n+1|0)s=e.charCodeAt(n),Kusto.Cloud.Platform.Utils.ExtendedString.s_alternativeSpaceChars.contains(s)?(t=Kusto.Cloud.Platform.Utils.ExtendedString.InitializeStringBuildIfNeeded(e,t,n)).append(String.fromCharCode(32)):Kusto.Cloud.Platform.Utils.ExtendedString.s_alternativeNewlineChars.contains(s)?(t=Kusto.Cloud.Platform.Utils.ExtendedString.InitializeStringBuildIfNeeded(e,t,n)).append("\n"):null!=t&&t.append(String.fromCharCode(s));return null==t?e:t.toString()},InitializeStringBuildIfNeeded:function(e,t,n){return null!=t||(t=new System.Text.StringBuilder("",e.length),n>0&&t.append(e.substr(0,n))),t}}}}),Bridge.ns("Kusto.Cloud.Platform.Utils.ExtendedString",e.$),Bridge.apply(e.$.Kusto.Cloud.Platform.Utils.ExtendedString,{f1:function(e){var t;return null!=e?null!=(t=Bridge.toString(e))?t:"[ToStringNull]":"[null]"},f2:function(e){return e.add(160),e.add(5760),e.add(6158),e.add(8192),e.add(8193),e.add(8194),e.add(8195),e.add(8196),e.add(8197),e.add(8198),e.add(8199),e.add(8200),e.add(8201),e.add(8202),e.add(8203),e.add(8239),e.add(8287),e.add(12288),e.add(65279),e},f3:function(e){return e.add(11),e}}),Bridge.define("Kusto.Data.Common.CslQueryParser",{statics:{methods:{PrettifyQuery:function(e,t){var n,s=(new Kusto.Data.IntelliSense.CslCommandParser).Parse(null,e,Kusto.Data.IntelliSense.ParseMode.CommandTokensOnly);return 1!==System.Linq.Enumerable.from(s,Kusto.Data.IntelliSense.CslCommand).count()?e:(n=System.Linq.Enumerable.from(s,Kusto.Data.IntelliSense.CslCommand).first().FormatAsString("\n",7),System.String.isNullOrEmpty(n)&&(n=e),System.String.isNullOrEmpty(t)||(n=(n||"")+(t||"")),n)}}}}),Bridge.define("Kusto.Data.Common.CslSyntaxGenerator",{statics:{fields:{s_keywords:null},ctors:{init:function(){this.s_keywords=e.$.Kusto.Data.Common.CslSyntaxGenerator.f1(new(System.Collections.Generic.HashSet$1(System.String).ctor))}},methods:{NormalizeDatabaseName$1:function(e,t){return Kusto.Data.Common.CslSyntaxGenerator.NormalizeName(e,t)},NormalizeDatabaseName:function(e){return Kusto.Data.Common.CslSyntaxGenerator.NormalizeName(e,!1)},NormalizeFunctionName:function(e,t){return void 0===t&&(t=!1),Kusto.Data.Common.CslSyntaxGenerator.NormalizeName(e,t)},NormalizeTableName:function(e,t){return void 0===t&&(t=!1),Kusto.Data.Common.CslSyntaxGenerator.NormalizeName(e,t)},NormalizeColumnName:function(e,t){return void 0===t&&(t=!1),Kusto.Data.Common.CslSyntaxGenerator.NormalizeName(e,t)},NormalizeRowStoreName:function(e){return Kusto.Data.Common.CslSyntaxGenerator.NormalizeName(e,!1)},NormalizeWorkloadGroupName:function(e){return Kusto.Data.Common.CslSyntaxGenerator.NormalizeName(e,!1)},IsIdentifier:function(t){return!(System.String.isNullOrEmpty(t)||!System.Char.isLetter(t.charCodeAt(0))&&95!==t.charCodeAt(0))&&System.Linq.Enumerable.from(t,System.Char).all(e.$.Kusto.Data.Common.CslSyntaxGenerator.f2)},IsAscii:function(e){return e<=127},NormalizeName:function(e,t){return System.String.isNullOrEmpty(e)?e:t||!Kusto.Data.Common.CslSyntaxGenerator.IsIdentifier(e)||Kusto.Data.Common.CslSyntaxGenerator.IsKeyword(e)?System.String.startsWith(e,"[")?e:System.String.contains(e,"'")?'["'+(e||"")+'"]':"['"+(e||"")+"']":e},IsKeyword:function(e){return Kusto.Data.Common.CslSyntaxGenerator.s_keywords.contains(e)}}}}),Bridge.ns("Kusto.Data.Common.CslSyntaxGenerator",e.$),Bridge.apply(e.$.Kusto.Data.Common.CslSyntaxGenerator,{f1:function(e){return e.add("access"),e.add("accounts"),e.add("accumulate"),e.add("add"),e.add("adl"),e.add("admin"),e.add("admins"),e.add("aggregations"),e.add("alias"),e.add("all"),e.add("alter"),e.add("alter-merge"),e.add("and"),e.add("anomalycolumns"),e.add("append"),e.add("artifacts"),e.add("as"),e.add("asc"),e.add("async"),e.add("attach"),e.add("avro"),e.add("apacheavro"),e.add("axes"),e.add("base"),e.add("basicauth"),e.add("between"),e.add("bin"),e.add("blob"),e.add("block"),e.add("blocked"),e.add("by"),e.add("cache"),e.add("caching"),e.add("cachingpolicy"),e.add("callout"),e.add("cancel"),e.add("capacity"),e.add("classification"),e.add("clear"),e.add("cluster"),e.add("column"),e.add("columns"),e.add("column-docstrings"),e.add("commands"),e.add("commands-and-queries"),e.add("commconcurrency"),e.add("commpools"),e.add("completed"),e.add("compressed"),e.add("consume"),e.add("contains"),e.add("continuous-export"),e.add("continuous-exports"),e.add("continuous-job"),e.add("conservative"),e.add("count"),e.add("crash"),e.add("create"),e.add("create-or-alter"),e.add("createdon"),e.add("create-merge"),e.add("csl"),e.add("cslschema"),e.add("csv"),e.add("cursor"),e.add("data"),e.add("database"),e.add("databasecreators"),e.add("databases"),e.add("alldatabasesadmins"),e.add("alldatabasesviewers"),e.add("dataexport"),e.add("dataformat"),e.add("datatable"),e.add("declare"),e.add("decryption-certificate-thumbprint"),e.add("default"),e.add("define"),e.add("delete"),e.add("delta"),e.add("desc"),e.add("detach"),e.add("details"),e.add("diagnostics"),e.add("disable"),e.add("distinct"),e.add("docstring"),e.add("drop"),e.add("drop-pretend"),e.add("dup-next-failed-ingest"),e.add("dup-next-ingest"),e.add("earliest"),e.add("echo"),e.add("effective"),e.add("enable"),e.add("encoding"),e.add("encodingpolicy"),e.add("entity"),e.add("ephemeral"),e.add("evaluate"),e.add("except"),e.add("execute"),e.add("export"),e.add("extend"),e.add("extent"),e.add("extentcontainers"),e.add("extents"),e.add("extentsmerge"),e.add("external"),e.add("externaldata"),e.add("external_data"),e.add("fabric"),e.add("fabriccache"),e.add("fabricclocks"),e.add("fabriclocks"),e.add("facet"),e.add("failures"),e.add("featureflags"),e.add("filter"),e.add("find"),e.add("first"),e.add("flags"),e.add("folder"),e.add("fork"),e.add("freshness"),e.add("from"),e.add("function"),e.add("functions"),e.add("generic"),e.add("get"),e.add("getschema"),e.add("groups"),e.add("harddelete"),e.add("hardretention"),e.add("has"),e.add("has_any"),e.add("hash"),e.add("hidden"),e.add("hot"),e.add("hotdata"),e.add("hotindex"),e.add("hours"),e.add("id"),e.add("if_later_than"),e.add("ifexists"),e.add("ifnotexists"),e.add("in"),e.add("in~"),e.add("ingest"),e.add("ingestion"),e.add("ingestionbatching"),e.add("ingestions"),e.add("ingestiontime"),e.add("ingestors"),e.add("inline"),e.add("internal"),e.add("into"),e.add("invoke"),e.add("journal"),e.add("json"),e.add("jobs"),e.add("key"),e.add("keys"),e.add("kind"),e.add("last"),e.add("latest"),e.add("legend"),e.add("let"),e.add("limit"),e.add("linear"),e.add("list"),e.add("load"),e.add("local"),e.add("location"),e.add("lookup"),e.add("log"),e.add("make-series"),e.add("management"),e.add("map"),e.add("mapping"),e.add("mappings"),e.add("materialize"),e.add("materialized-view"),e.add("materialized-views"),e.add("materialized-view-combine"),e.add("mdm"),e.add("memory"),e.add("mempools"),e.add("merge"),e.add("metadata"),e.add("method"),e.add("missing"),e.add("monitoring"),e.add("monitors"),e.add("move"),e.add("multidatabaseadmins"),e.add("mv-apply"),e.add("mv-expand"),e.add("mvapply"),e.add("mvexpand"),e.add("nan"),e.add("node"),e.add("none"),e.add("!between"),e.add("!in"),e.add("!in~"),e.add("null"),e.add("nulls"),e.add("of"),e.add("on"),e.add("older"),e.add("operation"),e.add("operations"),e.add("optional"),e.add("or"),e.add("orc"),e.add("order"),e.add("others"),e.add("over"),e.add("pack"),e.add("panels"),e.add("parse"),e.add("parse-where"),e.add("parquet"),e.add("partition"),e.add("partitioning"),e.add("password"),e.add("pathformat"),e.add("pattern"),e.add("pending"),e.add("persist"),e.add("plugin"),e.add("plugins"),e.add("policies"),e.add("policy"),e.add("pretend"),e.add("prettyname"),e.add("principal"),e.add("principals"),e.add("print"),e.add("project"),e.add("project-away"),e.add("project-keep"),e.add("project-rename"),e.add("project-reorder"),e.add("project-smart"),e.add("purge"),e.add("purge-cleanup"),e.add("queries"),e.add("query"),e.add("query_parameters"),e.add("queryexecution"),e.add("queryplan"),e.add("querythrottling"),e.add("query_weak_consistency"),e.add("query_results"),e.add("range"),e.add("readonly"),e.add("readwrite"),e.add("rebuild"),e.add("recycle"),e.add("reduce"),e.add("remote"),e.add("rename"),e.add("render"),e.add("replace"),e.add("resources"),e.add("restore"),e.add("restrict"),e.add("restricted_view_access"),e.add("resume-purges"),e.add("retention"),e.add("request_classification"),e.add("roles"),e.add("row_level_security"),e.add("roworder"),e.add("roworderpolicy"),e.add("rowstore"),e.add("rowstorepolicy"),e.add("rowstore_references"),e.add("rowstores"),e.add("rowstore_sealinfo"),e.add("run"),e.add("running"),e.add("sample"),e.add("sample-distinct"),e.add("sandbox"),e.add("sandboxes"),e.add("save"),e.add("scan"),e.add("schema"),e.add("script"),e.add("seal"),e.add("seals"),e.add("search"),e.add("serialize"),e.add("series"),e.add("servicepoints"),e.add("set"),e.add("set-or-append"),e.add("set-or-replace"),e.add("sharding"),e.add("shards"),e.add("show"),e.add("softdelete"),e.add("softretention"),e.add("sort"),e.add("sql"),e.add("stacked"),e.add("stacked100"),e.add("state"),e.add("statistics"),e.add("step"),e.add("storedqueryresultcontainers"),e.add("stream"),e.add("streamingingestion"),e.add("summarize"),e.add("sstream"),e.add("storage"),e.add("systemdb"),e.add("usage"),e.add("table"),e.add("tablepurge"),e.add("tables"),e.add("tags"),e.add("take"),e.add("tcpconnections"),e.add("tcpports"),e.add("tempstorage"),e.add("tenants"),e.add("threadpools"),e.add("threshold"),e.add("throw"),e.add("title"),e.add("to"),e.add("top"),e.add("top-hitters"),e.add("top-nested"),e.add("toscalar"),e.add("totable"),e.add("trace"),e.add("traceresults"),e.add("tsv"),e.add("type"),e.add("typeof"),e.add("undo"),e.add("unstacked"),e.add("unrestrictedviewers"),e.add("update"),e.add("user"),e.add("users"),e.add("using"),e.add("uuid"),e.add("verbose"),e.add("version"),e.add("view"),e.add("views"),e.add("viewers"),e.add("visible"),e.add("volatile"),e.add("v9"),e.add("v10"),e.add("w3clogfile"),e.add("warm"),e.add("warming"),e.add("whatif"),e.add("where"),e.add("with"),e.add("workload_group"),e.add("workload_groups"),e.add("writeaheadlog"),e.add("xaxis"),e.add("xcolumn"),e.add("xtitle"),e.add("yaxis"),e.add("ycolumns"),e.add("ymin"),e.add("ymax"),e.add("ysplit"),e.add("ytitle"),e.add("bool"),e.add("boolean"),e.add("int8"),e.add("char"),e.add("uint8"),e.add("byte"),e.add("int16"),e.add("uint16"),e.add("int"),e.add("int32"),e.add("uint"),e.add("uint32"),e.add("long"),e.add("int64"),e.add("ulong"),e.add("uint64"),e.add("float"),e.add("real"),e.add("double"),e.add("string"),e.add("time"),e.add("timespan"),e.add("date"),e.add("datetime"),e.add("guid"),e.add("uniqueid"),e.add("dynamic"),e.add("decimal"),e.add("GB"),e.add("MB"),e.add("application"),e.add("blockedprincipals"),e.add("bytes"),e.add("callstacks"),e.add("concurrency"),e.add("configuration"),e.add("consumers"),e.add("container"),e.add("containers"),e.add("datasize"),e.add("datastats"),e.add("datetime_pattern"),e.add("days"),e.add("dimensions"),e.add("disabled"),e.add("dryrun"),e.add("empty"),e.add("enabled"),e.add("exclude"),e.add("expired_tables_cleanup"),e.add("extentsize"),e.add("follower"),e.add("for"),e.add("format_datetime"),e.add("granularity"),e.add("identity"),e.add("include"),e.add("info"),e.add("maxRecords"),e.add("network"),e.add("period"),e.add("querylimit"),e.add("quota"),e.add("reason"),e.add("record"),e.add("records"),e.add("recoverability"),e.add("startofday"),e.add("startofmonth"),e.add("startofweek"),e.add("startofyear"),e.add("stats"),e.add("stored_query_result"),e.add("stored_query_results"),e.add("suspend"),e.add("transactions"),e.add("trim"),e.add("union"),e.add("until"),e.add("unused"),e.add("utilization"),e.add("violations"),e.add("3Dchart"),e.add("__contextual_datatable"),e.add("__crossCluster"),e.add("__crossDB"),e.add("__executeAndCache"),e.add("__id"),e.add("__isFuzzy"),e.add("__noWithSource"),e.add("__packedColumn"),e.add("__projectAway"),e.add("__sourceColumnIndex"),e.add("anomalychart"),e.add("areachart"),e.add("bagexpansion"),e.add("barchart"),e.add("bin_legacy"),e.add("card"),e.add("columnchart"),e.add("datascope"),e.add("decodeblocks"),e.add("expandoutput"),e.add("hotcache"),e.add("isfuzzy"),e.add("join"),e.add("ladderchart"),e.add("linechart"),e.add("nooptimization"),e.add("piechart"),e.add("pivotchart"),e.add("regex"),e.add("relaxed"),e.add("scatterchart"),e.add("simple"),e.add("stackedareachart"),e.add("timechart"),e.add("timeline"),e.add("timepivot"),e.add("with_itemindex"),e.add("with_match_id"),e.add("with_source"),e.add("with_step_name"),e.add("withsource"),e},f2:function(e){return(System.Char.isDigit(e)||System.Char.isLetter(e))&&Kusto.Data.Common.CslSyntaxGenerator.IsAscii(e)||95===e}}),Bridge.define("Kusto.Data.Common.DatabaseShowFlavor",{$kind:"enum",statics:{fields:{Identity:0,Verbose:1,Policies:2,DataStats:3,Default:4}}}),Bridge.define("Kusto.Data.Common.DataRecoverability",{$kind:"enum",statics:{fields:{Unknown:0,Enabled:1,Disabled:2}}}),Bridge.define("Kusto.Data.Common.DataSourceCompressionType",{$kind:"enum",statics:{fields:{None:0,GZip:1,Zip:2}}}),Bridge.define("Kusto.Data.Common.EntityType",{$kind:"enum",statics:{fields:{Unknown:0,Cluster:1,Database:2,Table:3,Column:4,Function:5,ExternalTable:6,MaterializedView:7}}}),Bridge.define("Kusto.Data.Common.ExtendedDatabaseShowFlavor",{statics:{methods:{FastToString:function(e){switch(e){case Kusto.Data.Common.DatabaseShowFlavor.Identity:return"Identity";case Kusto.Data.Common.DatabaseShowFlavor.Verbose:return"Verbose";case Kusto.Data.Common.DatabaseShowFlavor.Policies:return"Policies";case Kusto.Data.Common.DatabaseShowFlavor.DataStats:return"DataStats";case Kusto.Data.Common.DatabaseShowFlavor.Default:return"Default"}return System.String.format("[unknown: {0}]",[Bridge.box(e,System.Int32)])},FastIsDefined$1:function(e){var t={v:new Kusto.Data.Common.DatabaseShowFlavor};return Kusto.Data.Common.ExtendedDatabaseShowFlavor.FastTryParse(e,t,!1,!0)},FastIsDefined:function(e){switch(e){case Kusto.Data.Common.DatabaseShowFlavor.Identity:case Kusto.Data.Common.DatabaseShowFlavor.Verbose:case Kusto.Data.Common.DatabaseShowFlavor.Policies:case Kusto.Data.Common.DatabaseShowFlavor.DataStats:case Kusto.Data.Common.DatabaseShowFlavor.Default:return!0;default:return!1}},FastHasFlag$1:function(e,t){return(e&t)===t},FastHasFlag:function(e,t){return(e&t)===t},FastParse:function(e,t){void 0===t&&(t=!1);var n={v:new Kusto.Data.Common.DatabaseShowFlavor};if(Kusto.Data.Common.ExtendedDatabaseShowFlavor.FastTryParse(e,n,t))return n.v;throw new System.Exception("Invalid enum value: "+(e||""))},FastTryParse:function(e,t,n,s){switch(void 0===n&&(n=!1),void 0===s&&(s=!1),e){case"0":case"Identity":return t.v=Kusto.Data.Common.DatabaseShowFlavor.Identity,!0;case"1":case"Verbose":return t.v=Kusto.Data.Common.DatabaseShowFlavor.Verbose,!0;case"2":case"Policies":return t.v=Kusto.Data.Common.DatabaseShowFlavor.Policies,!0;case"3":case"DataStats":return t.v=Kusto.Data.Common.DatabaseShowFlavor.DataStats,!0;case"4":case"Default":return t.v=Kusto.Data.Common.DatabaseShowFlavor.Default,!0}if(n&&!System.String.isNullOrEmpty(e))switch(e.toLowerCase()){case"identity":return t.v=Kusto.Data.Common.DatabaseShowFlavor.Identity,!0;case"verbose":return t.v=Kusto.Data.Common.DatabaseShowFlavor.Verbose,!0;case"policies":return t.v=Kusto.Data.Common.DatabaseShowFlavor.Policies,!0;case"datastats":return t.v=Kusto.Data.Common.DatabaseShowFlavor.DataStats,!0;case"default":return t.v=Kusto.Data.Common.DatabaseShowFlavor.Default,!0}if(!s){var i={v:0};if(System.Int32.tryParse(e,i))return t.v=i.v,!0}return t.v=0,!1},FastGetDescription:function(e){switch(e){case Kusto.Data.Common.DatabaseShowFlavor.Identity:case Kusto.Data.Common.DatabaseShowFlavor.Verbose:case Kusto.Data.Common.DatabaseShowFlavor.Policies:case Kusto.Data.Common.DatabaseShowFlavor.DataStats:case Kusto.Data.Common.DatabaseShowFlavor.Default:return"";default:return null}}}}}),Bridge.define("Kusto.Data.Common.ExtendedDataRecoverability",{statics:{methods:{FastToString:function(e){switch(e){case Kusto.Data.Common.DataRecoverability.Unknown:return"Unknown";case Kusto.Data.Common.DataRecoverability.Enabled:return"Enabled";case Kusto.Data.Common.DataRecoverability.Disabled:return"Disabled"}return System.String.format("[unknown: {0}]",[Bridge.box(e,System.Int32)])},FastIsDefined$1:function(e){var t={v:new Kusto.Data.Common.DataRecoverability};return Kusto.Data.Common.ExtendedDataRecoverability.FastTryParse(e,t,!1,!0)},FastIsDefined:function(e){switch(e){case Kusto.Data.Common.DataRecoverability.Unknown:case Kusto.Data.Common.DataRecoverability.Enabled:case Kusto.Data.Common.DataRecoverability.Disabled:return!0;default:return!1}},FastHasFlag$1:function(e,t){return(e&t)===t},FastHasFlag:function(e,t){return(e&t)===t},FastParse:function(e,t){void 0===t&&(t=!1);var n={v:new Kusto.Data.Common.DataRecoverability};if(Kusto.Data.Common.ExtendedDataRecoverability.FastTryParse(e,n,t))return n.v;throw new System.Exception("Invalid enum value: "+(e||""))},FastTryParse:function(e,t,n,s){switch(void 0===n&&(n=!1),void 0===s&&(s=!1),e){case"0":case"Unknown":return t.v=Kusto.Data.Common.DataRecoverability.Unknown,!0;case"1":case"Enabled":return t.v=Kusto.Data.Common.DataRecoverability.Enabled,!0;case"2":case"Disabled":return t.v=Kusto.Data.Common.DataRecoverability.Disabled,!0}if(n&&!System.String.isNullOrEmpty(e))switch(e.toLowerCase()){case"unknown":return t.v=Kusto.Data.Common.DataRecoverability.Unknown,!0;case"enabled":return t.v=Kusto.Data.Common.DataRecoverability.Enabled,!0;case"disabled":return t.v=Kusto.Data.Common.DataRecoverability.Disabled,!0}if(!s){var i={v:0};if(System.Int32.tryParse(e,i))return t.v=i.v,!0}return t.v=0,!1},FastGetDescription:function(e){switch(e){case Kusto.Data.Common.DataRecoverability.Unknown:case Kusto.Data.Common.DataRecoverability.Enabled:case Kusto.Data.Common.DataRecoverability.Disabled:return"";default:return null}}}}}),Bridge.define("Kusto.Data.Common.ExtendedDataSourceCompressionType",{statics:{methods:{FastToString:function(e){switch(e){case Kusto.Data.Common.DataSourceCompressionType.None:return"None";case Kusto.Data.Common.DataSourceCompressionType.GZip:return"GZip";case Kusto.Data.Common.DataSourceCompressionType.Zip:return"Zip"}return System.String.format("[unknown: {0}]",[Bridge.box(e,System.Int32)])},FastIsDefined$1:function(e){var t={v:new Kusto.Data.Common.DataSourceCompressionType};return Kusto.Data.Common.ExtendedDataSourceCompressionType.FastTryParse(e,t,!1,!0)},FastIsDefined:function(e){switch(e){case Kusto.Data.Common.DataSourceCompressionType.None:case Kusto.Data.Common.DataSourceCompressionType.GZip:case Kusto.Data.Common.DataSourceCompressionType.Zip:return!0;default:return!1}},FastHasFlag$1:function(e,t){return(e&t)===t},FastHasFlag:function(e,t){return(e&t)===t},FastParse:function(e,t){void 0===t&&(t=!1);var n={v:new Kusto.Data.Common.DataSourceCompressionType};if(Kusto.Data.Common.ExtendedDataSourceCompressionType.FastTryParse(e,n,t))return n.v;throw new System.Exception("Invalid enum value: "+(e||""))},FastTryParse:function(e,t,n,s){switch(void 0===n&&(n=!1),void 0===s&&(s=!1),e){case"0":case"None":return t.v=Kusto.Data.Common.DataSourceCompressionType.None,!0;case"1":case"GZip":return t.v=Kusto.Data.Common.DataSourceCompressionType.GZip,!0;case"2":case"Zip":return t.v=Kusto.Data.Common.DataSourceCompressionType.Zip,!0}if(n&&!System.String.isNullOrEmpty(e))switch(e.toLowerCase()){case"none":return t.v=Kusto.Data.Common.DataSourceCompressionType.None,!0;case"gzip":return t.v=Kusto.Data.Common.DataSourceCompressionType.GZip,!0;case"zip":return t.v=Kusto.Data.Common.DataSourceCompressionType.Zip,!0}if(!s){var i={v:0};if(System.Int32.tryParse(e,i))return t.v=i.v,!0}return t.v=0,!1},FastGetDescription:function(e){switch(e){case Kusto.Data.Common.DataSourceCompressionType.None:return"No compression";case Kusto.Data.Common.DataSourceCompressionType.GZip:return"GZip compression";case Kusto.Data.Common.DataSourceCompressionType.Zip:return"Zip compression";default:return null}}}}}),Bridge.define("Kusto.Data.Common.ExtendedEntityType",{statics:{methods:{FastToString:function(e){switch(e){case Kusto.Data.Common.EntityType.Unknown:return"Unknown";case Kusto.Data.Common.EntityType.Cluster:return"Cluster";case Kusto.Data.Common.EntityType.Database:return"Database";case Kusto.Data.Common.EntityType.Table:return"Table";case Kusto.Data.Common.EntityType.Column:return"Column";case Kusto.Data.Common.EntityType.Function:return"Function";case Kusto.Data.Common.EntityType.ExternalTable:return"ExternalTable";case Kusto.Data.Common.EntityType.MaterializedView:return"MaterializedView"}return System.String.format("[unknown: {0}]",[Bridge.box(e,System.Int32)])},FastIsDefined$1:function(e){var t={v:new Kusto.Data.Common.EntityType};return Kusto.Data.Common.ExtendedEntityType.FastTryParse(e,t,!1,!0)},FastIsDefined:function(e){switch(e){case Kusto.Data.Common.EntityType.Unknown:case Kusto.Data.Common.EntityType.Cluster:case Kusto.Data.Common.EntityType.Database:case Kusto.Data.Common.EntityType.Table:case Kusto.Data.Common.EntityType.Column:case Kusto.Data.Common.EntityType.Function:case Kusto.Data.Common.EntityType.ExternalTable:case Kusto.Data.Common.EntityType.MaterializedView:return!0;default:return!1}},FastHasFlag$1:function(e,t){return(e&t)===t},FastHasFlag:function(e,t){return(e&t)===t},FastParse:function(e,t){void 0===t&&(t=!1);var n={v:new Kusto.Data.Common.EntityType};if(Kusto.Data.Common.ExtendedEntityType.FastTryParse(e,n,t))return n.v;throw new System.Exception("Invalid enum value: "+(e||""))},FastTryParse:function(e,t,n,s){switch(void 0===n&&(n=!1),void 0===s&&(s=!1),e){case"0":case"Unknown":return t.v=Kusto.Data.Common.EntityType.Unknown,!0;case"1":case"Cluster":return t.v=Kusto.Data.Common.EntityType.Cluster,!0;case"2":case"Database":return t.v=Kusto.Data.Common.EntityType.Database,!0;case"3":case"Table":return t.v=Kusto.Data.Common.EntityType.Table,!0;case"4":case"Column":return t.v=Kusto.Data.Common.EntityType.Column,!0;case"5":case"Function":return t.v=Kusto.Data.Common.EntityType.Function,!0;case"6":case"ExternalTable":return t.v=Kusto.Data.Common.EntityType.ExternalTable,!0;case"7":case"MaterializedView":case"materialized-view":return t.v=Kusto.Data.Common.EntityType.MaterializedView,!0}if(n&&!System.String.isNullOrEmpty(e))switch(e.toLowerCase()){case"unknown":return t.v=Kusto.Data.Common.EntityType.Unknown,!0;case"cluster":return t.v=Kusto.Data.Common.EntityType.Cluster,!0;case"database":return t.v=Kusto.Data.Common.EntityType.Database,!0;case"table":return t.v=Kusto.Data.Common.EntityType.Table,!0;case"column":return t.v=Kusto.Data.Common.EntityType.Column,!0;case"function":return t.v=Kusto.Data.Common.EntityType.Function,!0;case"externaltable":return t.v=Kusto.Data.Common.EntityType.ExternalTable,!0;case"materializedview":case"materialized-view":return t.v=Kusto.Data.Common.EntityType.MaterializedView,!0}if(!s){var i={v:0};if(System.Int32.tryParse(e,i))return t.v=i.v,!0}return t.v=0,!1},FastGetDescription:function(e){switch(e){case Kusto.Data.Common.EntityType.Unknown:return"Unknown";case Kusto.Data.Common.EntityType.Cluster:return"Cluster entity type";case Kusto.Data.Common.EntityType.Database:return"Database entity type";case Kusto.Data.Common.EntityType.Table:return"Table entity type";case Kusto.Data.Common.EntityType.Column:return"Column entity type";case Kusto.Data.Common.EntityType.Function:return"Function entity type";case Kusto.Data.Common.EntityType.ExternalTable:return"External table entity type";case Kusto.Data.Common.EntityType.MaterializedView:return"Materialized view entity type";default:return null}}}}}),Bridge.define("Kusto.Data.Common.ExtendedIngestionErrorCategory",{statics:{methods:{FastToString:function(e){switch(e){case Kusto.Data.Common.IngestionErrorCategory.Unknown:return"Unknown";case Kusto.Data.Common.IngestionErrorCategory.InternalServiceError:return"InternalServiceError";case Kusto.Data.Common.IngestionErrorCategory.BadFormat:return"BadFormat";case Kusto.Data.Common.IngestionErrorCategory.BadRequest:return"BadRequest";case Kusto.Data.Common.IngestionErrorCategory.BlobNotFound:return"BlobNotFound";case Kusto.Data.Common.IngestionErrorCategory.UpdatePolicyFailure:return"UpdatePolicyFailure";case Kusto.Data.Common.IngestionErrorCategory.EntityNotFound:return"EntityNotFound";case Kusto.Data.Common.IngestionErrorCategory.UserAccessNotAuthorized:return"UserAccessNotAuthorized";case Kusto.Data.Common.IngestionErrorCategory.DataAccessNotAuthorized:return"DataAccessNotAuthorized";case Kusto.Data.Common.IngestionErrorCategory.FileTooLarge:return"FileTooLarge";case Kusto.Data.Common.IngestionErrorCategory.ThrottledOnEngine:return"ThrottledOnEngine";case Kusto.Data.Common.IngestionErrorCategory.DownloadFailed:return"DownloadFailed"}return System.String.format("[unknown: {0}]",[Bridge.box(e,System.Int32)])},FastIsDefined$1:function(e){var t={v:new Kusto.Data.Common.IngestionErrorCategory};return Kusto.Data.Common.ExtendedIngestionErrorCategory.FastTryParse(e,t,!1,!0)},FastIsDefined:function(e){switch(e){case Kusto.Data.Common.IngestionErrorCategory.Unknown:case Kusto.Data.Common.IngestionErrorCategory.InternalServiceError:case Kusto.Data.Common.IngestionErrorCategory.BadFormat:case Kusto.Data.Common.IngestionErrorCategory.BadRequest:case Kusto.Data.Common.IngestionErrorCategory.BlobNotFound:case Kusto.Data.Common.IngestionErrorCategory.UpdatePolicyFailure:case Kusto.Data.Common.IngestionErrorCategory.EntityNotFound:case Kusto.Data.Common.IngestionErrorCategory.UserAccessNotAuthorized:case Kusto.Data.Common.IngestionErrorCategory.DataAccessNotAuthorized:case Kusto.Data.Common.IngestionErrorCategory.FileTooLarge:case Kusto.Data.Common.IngestionErrorCategory.ThrottledOnEngine:case Kusto.Data.Common.IngestionErrorCategory.DownloadFailed:return!0;default:return!1}},FastHasFlag$1:function(e,t){return(e&t)===t},FastHasFlag:function(e,t){return(e&t)===t},FastParse:function(e,t){void 0===t&&(t=!1);var n={v:new Kusto.Data.Common.IngestionErrorCategory};if(Kusto.Data.Common.ExtendedIngestionErrorCategory.FastTryParse(e,n,t))return n.v;throw new System.Exception("Invalid enum value: "+(e||""))},FastTryParse:function(e,t,n,s){switch(void 0===n&&(n=!1),void 0===s&&(s=!1),e){case"Unknown":return t.v=Kusto.Data.Common.IngestionErrorCategory.Unknown,!0;case"InternalServiceError":return t.v=Kusto.Data.Common.IngestionErrorCategory.InternalServiceError,!0;case"BadFormat":return t.v=Kusto.Data.Common.IngestionErrorCategory.BadFormat,!0;case"BadRequest":return t.v=Kusto.Data.Common.IngestionErrorCategory.BadRequest,!0;case"BlobNotFound":return t.v=Kusto.Data.Common.IngestionErrorCategory.BlobNotFound,!0;case"UpdatePolicyFailure":return t.v=Kusto.Data.Common.IngestionErrorCategory.UpdatePolicyFailure,!0;case"EntityNotFound":return t.v=Kusto.Data.Common.IngestionErrorCategory.EntityNotFound,!0;case"UserAccessNotAuthorized":return t.v=Kusto.Data.Common.IngestionErrorCategory.UserAccessNotAuthorized,!0;case"DataAccessNotAuthorized":return t.v=Kusto.Data.Common.IngestionErrorCategory.DataAccessNotAuthorized,!0;case"FileTooLarge":return t.v=Kusto.Data.Common.IngestionErrorCategory.FileTooLarge,!0;case"ThrottledOnEngine":return t.v=Kusto.Data.Common.IngestionErrorCategory.ThrottledOnEngine,!0;case"DownloadFailed":return t.v=Kusto.Data.Common.IngestionErrorCategory.DownloadFailed,!0}if(n&&!System.String.isNullOrEmpty(e))switch(e.toLowerCase()){case"unknown":return t.v=Kusto.Data.Common.IngestionErrorCategory.Unknown,!0;case"internalserviceerror":return t.v=Kusto.Data.Common.IngestionErrorCategory.InternalServiceError,!0;case"badformat":return t.v=Kusto.Data.Common.IngestionErrorCategory.BadFormat,!0;case"badrequest":return t.v=Kusto.Data.Common.IngestionErrorCategory.BadRequest,!0;case"blobnotfound":return t.v=Kusto.Data.Common.IngestionErrorCategory.BlobNotFound,!0;case"updatepolicyfailure":return t.v=Kusto.Data.Common.IngestionErrorCategory.UpdatePolicyFailure,!0;case"entitynotfound":return t.v=Kusto.Data.Common.IngestionErrorCategory.EntityNotFound,!0;case"useraccessnotauthorized":return t.v=Kusto.Data.Common.IngestionErrorCategory.UserAccessNotAuthorized,!0;case"dataaccessnotauthorized":return t.v=Kusto.Data.Common.IngestionErrorCategory.DataAccessNotAuthorized,!0;case"filetoolarge":return t.v=Kusto.Data.Common.IngestionErrorCategory.FileTooLarge,!0;case"throttledonengine":return t.v=Kusto.Data.Common.IngestionErrorCategory.ThrottledOnEngine,!0;case"downloadfailed":return t.v=Kusto.Data.Common.IngestionErrorCategory.DownloadFailed,!0}if(!s){var i={v:0};if(System.Int32.tryParse(e,i))return t.v=i.v,!0}return t.v=0,!1},FastGetDescription:function(e){switch(e){case Kusto.Data.Common.IngestionErrorCategory.Unknown:case Kusto.Data.Common.IngestionErrorCategory.InternalServiceError:case Kusto.Data.Common.IngestionErrorCategory.BadFormat:case Kusto.Data.Common.IngestionErrorCategory.BadRequest:case Kusto.Data.Common.IngestionErrorCategory.BlobNotFound:case Kusto.Data.Common.IngestionErrorCategory.UpdatePolicyFailure:case Kusto.Data.Common.IngestionErrorCategory.EntityNotFound:case Kusto.Data.Common.IngestionErrorCategory.UserAccessNotAuthorized:case Kusto.Data.Common.IngestionErrorCategory.DataAccessNotAuthorized:case Kusto.Data.Common.IngestionErrorCategory.FileTooLarge:case Kusto.Data.Common.IngestionErrorCategory.ThrottledOnEngine:case Kusto.Data.Common.IngestionErrorCategory.DownloadFailed:return"";default:return null}}}}}),Bridge.define("Kusto.Data.Common.ExtendedIngestionErrorCode",{statics:{methods:{FastToString:function(e){switch(e){case Kusto.Data.Common.IngestionErrorCode.Unknown:return"Unknown";case Kusto.Data.Common.IngestionErrorCode.Stream_WrongNumberOfFields:return"Stream_WrongNumberOfFields";case Kusto.Data.Common.IngestionErrorCode.Stream_InputStreamTooLarge:return"Stream_InputStreamTooLarge";case Kusto.Data.Common.IngestionErrorCode.Stream_NoDataToIngest:return"Stream_NoDataToIngest";case Kusto.Data.Common.IngestionErrorCode.Stream_ClosingQuoteMissing:return"Stream_ClosingQuoteMissing";case Kusto.Data.Common.IngestionErrorCode.Stream_DynamicPropertyBagTooLarge:return"Stream_DynamicPropertyBagTooLarge";case Kusto.Data.Common.IngestionErrorCode.Download_SourceNotFound:return"Download_SourceNotFound";case Kusto.Data.Common.IngestionErrorCode.Download_AccessConditionNotSatisfied:return"Download_AccessConditionNotSatisfied";case Kusto.Data.Common.IngestionErrorCode.Download_Forbidden:return"Download_Forbidden";case Kusto.Data.Common.IngestionErrorCode.Download_AccountNotFound:return"Download_AccountNotFound";case Kusto.Data.Common.IngestionErrorCode.Download_BadRequest:return"Download_BadRequest";case Kusto.Data.Common.IngestionErrorCode.Download_NotTransient:return"Download_NotTransient";case Kusto.Data.Common.IngestionErrorCode.Download_UnknownError:return"Download_UnknownError";case Kusto.Data.Common.IngestionErrorCode.UpdatePolicy_QuerySchemaDoesNotMatchTableSchema:return"UpdatePolicy_QuerySchemaDoesNotMatchTableSchema";case Kusto.Data.Common.IngestionErrorCode.UpdatePolicy_FailedDescendantTransaction:return"UpdatePolicy_FailedDescendantTransaction";case Kusto.Data.Common.IngestionErrorCode.UpdatePolicy_IngestionError:return"UpdatePolicy_IngestionError";case Kusto.Data.Common.IngestionErrorCode.UpdatePolicy_UnknownError:return"UpdatePolicy_UnknownError";case Kusto.Data.Common.IngestionErrorCode.BadRequest_MissingJsonMappingtFailure:return"BadRequest_MissingJsonMappingtFailure";case Kusto.Data.Common.IngestionErrorCode.BadRequest_InvalidBlob:return"BadRequest_InvalidBlob";case Kusto.Data.Common.IngestionErrorCode.BadRequest_EmptyBlob:return"BadRequest_EmptyBlob";case Kusto.Data.Common.IngestionErrorCode.BadRequest_EmptyArchive:return"BadRequest_EmptyArchive";case Kusto.Data.Common.IngestionErrorCode.BadRequest_InvalidArchive:return"BadRequest_InvalidArchive";case Kusto.Data.Common.IngestionErrorCode.BadRequest_EmptyBlobUri:return"BadRequest_EmptyBlobUri";case Kusto.Data.Common.IngestionErrorCode.BadRequest_DatabaseNotExist:return"BadRequest_DatabaseNotExist";case Kusto.Data.Common.IngestionErrorCode.BadRequest_TableNotExist:return"BadRequest_TableNotExist";case Kusto.Data.Common.IngestionErrorCode.BadRequest_InvalidKustoIdentityToken:return"BadRequest_InvalidKustoIdentityToken";case Kusto.Data.Common.IngestionErrorCode.BadRequest_FileTooLarge:return"BadRequest_FileTooLarge";case Kusto.Data.Common.IngestionErrorCode.BadRequest_TableAccessDenied:return"BadRequest_TableAccessDenied";case Kusto.Data.Common.IngestionErrorCode.BadRequest_MessageExhausted:return"BadRequest_MessageExhausted";case Kusto.Data.Common.IngestionErrorCode.General_BadRequest:return"General_BadRequest";case Kusto.Data.Common.IngestionErrorCode.General_InternalServerError:return"General_InternalServerError";case Kusto.Data.Common.IngestionErrorCode.UpdatePolicy_Cyclic_Update_Not_Allowed:return"UpdatePolicy_Cyclic_Update_Not_Allowed";case Kusto.Data.Common.IngestionErrorCode.BadRequest_InvalidMapping:return"BadRequest_InvalidMapping";case Kusto.Data.Common.IngestionErrorCode.BadRequest_InvalidMappingReference:return"BadRequest_InvalidMappingReference";case Kusto.Data.Common.IngestionErrorCode.BadRequest_MappingReferenceWasNotFound:return"BadRequest_MappingReferenceWasNotFound";case Kusto.Data.Common.IngestionErrorCode.BadRequest_FormatNotSupported:return"BadRequest_FormatNotSupported";case Kusto.Data.Common.IngestionErrorCode.BadRequest_DuplicateMapping:return"BadRequest_DuplicateMapping";case Kusto.Data.Common.IngestionErrorCode.BadRequest_CorruptedMessage:return"BadRequest_CorruptedMessage";case Kusto.Data.Common.IngestionErrorCode.BadRequest_InconsistentMapping:return"BadRequest_InconsistentMapping";case Kusto.Data.Common.IngestionErrorCode.BadRequest_SyntaxError:return"BadRequest_SyntaxError";case Kusto.Data.Common.IngestionErrorCode.BadRequest_InvalidOrEmptyTableName:return"BadRequest_InvalidOrEmptyTableName";case Kusto.Data.Common.IngestionErrorCode.BadRequest_EmptyDatabaseName:return"BadRequest_EmptyDatabaseName";case Kusto.Data.Common.IngestionErrorCode.BadRequest_EmptyTenantIdentifier:return"BadRequest_EmptyTenantIdentifier";case Kusto.Data.Common.IngestionErrorCode.BadRequest_EmptyMappingReference:return"BadRequest_EmptyMappingReference";case Kusto.Data.Common.IngestionErrorCode.BadRequest_EntityNotFound:return"BadRequest_EntityNotFound";case Kusto.Data.Common.IngestionErrorCode.BadRequest_EntityNameIsNotValid:return"BadRequest_EntityNameIsNotValid";case Kusto.Data.Common.IngestionErrorCode.General_AbandonedIngestion:return"General_AbandonedIngestion";case Kusto.Data.Common.IngestionErrorCode.General_ThrottledIngestion:return"General_ThrottledIngestion";case Kusto.Data.Common.IngestionErrorCode.General_TransientSchemaMismatch:return"General_TransientSchemaMismatch";case Kusto.Data.Common.IngestionErrorCode.BadRequest_DatabaseAccessDenied:return"BadRequest_DatabaseAccessDenied";case Kusto.Data.Common.IngestionErrorCode.BadRequest_UnexpectedCharacterInInputStream:return"BadRequest_UnexpectedCharacterInInputStream";case Kusto.Data.Common.IngestionErrorCode.Forbidden:return"Forbidden";case Kusto.Data.Common.IngestionErrorCode.BadRequest_ZeroRetentionPolicyWithNoUpdatePolicy:return"BadRequest_ZeroRetentionPolicyWithNoUpdatePolicy";case Kusto.Data.Common.IngestionErrorCode.BadRequest_CreationTimeEarlierThanSoftDeletePeriod:return"BadRequest_CreationTimeEarlierThanSoftDeletePeriod";case Kusto.Data.Common.IngestionErrorCode.BadRequest_NotSupported:return"BadRequest_NotSupported";case Kusto.Data.Common.IngestionErrorCode.Skipped_IngestByTagAlreadyExists:return"Skipped_IngestByTagAlreadyExists";case Kusto.Data.Common.IngestionErrorCode.Timeout:return"Timeout"}return System.String.format("[unknown: {0}]",[Bridge.box(e,System.UInt32)])},FastIsDefined:function(e){var t={v:new Kusto.Data.Common.IngestionErrorCode};return Kusto.Data.Common.ExtendedIngestionErrorCode.FastTryParse(e,t,!1,!0)},FastIsDefined$1:function(e){switch(e){case Kusto.Data.Common.IngestionErrorCode.Unknown:case Kusto.Data.Common.IngestionErrorCode.Stream_WrongNumberOfFields:case Kusto.Data.Common.IngestionErrorCode.Stream_InputStreamTooLarge:case Kusto.Data.Common.IngestionErrorCode.Stream_NoDataToIngest:case Kusto.Data.Common.IngestionErrorCode.Stream_ClosingQuoteMissing:case Kusto.Data.Common.IngestionErrorCode.Stream_DynamicPropertyBagTooLarge:case Kusto.Data.Common.IngestionErrorCode.Download_SourceNotFound:case Kusto.Data.Common.IngestionErrorCode.Download_AccessConditionNotSatisfied:case Kusto.Data.Common.IngestionErrorCode.Download_Forbidden:case Kusto.Data.Common.IngestionErrorCode.Download_AccountNotFound:case Kusto.Data.Common.IngestionErrorCode.Download_BadRequest:case Kusto.Data.Common.IngestionErrorCode.Download_NotTransient:case Kusto.Data.Common.IngestionErrorCode.Download_UnknownError:case Kusto.Data.Common.IngestionErrorCode.UpdatePolicy_QuerySchemaDoesNotMatchTableSchema:case Kusto.Data.Common.IngestionErrorCode.UpdatePolicy_FailedDescendantTransaction:case Kusto.Data.Common.IngestionErrorCode.UpdatePolicy_IngestionError:case Kusto.Data.Common.IngestionErrorCode.UpdatePolicy_UnknownError:case Kusto.Data.Common.IngestionErrorCode.BadRequest_MissingJsonMappingtFailure:case Kusto.Data.Common.IngestionErrorCode.BadRequest_InvalidBlob:case Kusto.Data.Common.IngestionErrorCode.BadRequest_EmptyBlob:case Kusto.Data.Common.IngestionErrorCode.BadRequest_EmptyArchive:case Kusto.Data.Common.IngestionErrorCode.BadRequest_InvalidArchive:case Kusto.Data.Common.IngestionErrorCode.BadRequest_EmptyBlobUri:case Kusto.Data.Common.IngestionErrorCode.BadRequest_DatabaseNotExist:case Kusto.Data.Common.IngestionErrorCode.BadRequest_TableNotExist:case Kusto.Data.Common.IngestionErrorCode.BadRequest_InvalidKustoIdentityToken:case Kusto.Data.Common.IngestionErrorCode.BadRequest_FileTooLarge:case Kusto.Data.Common.IngestionErrorCode.BadRequest_TableAccessDenied:case Kusto.Data.Common.IngestionErrorCode.BadRequest_MessageExhausted:case Kusto.Data.Common.IngestionErrorCode.General_BadRequest:case Kusto.Data.Common.IngestionErrorCode.General_InternalServerError:case Kusto.Data.Common.IngestionErrorCode.UpdatePolicy_Cyclic_Update_Not_Allowed:case Kusto.Data.Common.IngestionErrorCode.BadRequest_InvalidMapping:case Kusto.Data.Common.IngestionErrorCode.BadRequest_InvalidMappingReference:case Kusto.Data.Common.IngestionErrorCode.BadRequest_MappingReferenceWasNotFound:case Kusto.Data.Common.IngestionErrorCode.BadRequest_FormatNotSupported:case Kusto.Data.Common.IngestionErrorCode.BadRequest_DuplicateMapping:case Kusto.Data.Common.IngestionErrorCode.BadRequest_CorruptedMessage:case Kusto.Data.Common.IngestionErrorCode.BadRequest_InconsistentMapping:case Kusto.Data.Common.IngestionErrorCode.BadRequest_SyntaxError:case Kusto.Data.Common.IngestionErrorCode.BadRequest_InvalidOrEmptyTableName:case Kusto.Data.Common.IngestionErrorCode.BadRequest_EmptyDatabaseName:case Kusto.Data.Common.IngestionErrorCode.BadRequest_EmptyTenantIdentifier:case Kusto.Data.Common.IngestionErrorCode.BadRequest_EmptyMappingReference:case Kusto.Data.Common.IngestionErrorCode.BadRequest_EntityNotFound:case Kusto.Data.Common.IngestionErrorCode.BadRequest_EntityNameIsNotValid:case Kusto.Data.Common.IngestionErrorCode.General_AbandonedIngestion:case Kusto.Data.Common.IngestionErrorCode.General_ThrottledIngestion:case Kusto.Data.Common.IngestionErrorCode.General_TransientSchemaMismatch:case Kusto.Data.Common.IngestionErrorCode.BadRequest_DatabaseAccessDenied:case Kusto.Data.Common.IngestionErrorCode.BadRequest_UnexpectedCharacterInInputStream:case Kusto.Data.Common.IngestionErrorCode.Forbidden:case Kusto.Data.Common.IngestionErrorCode.BadRequest_ZeroRetentionPolicyWithNoUpdatePolicy:case Kusto.Data.Common.IngestionErrorCode.BadRequest_CreationTimeEarlierThanSoftDeletePeriod:case Kusto.Data.Common.IngestionErrorCode.BadRequest_NotSupported:case Kusto.Data.Common.IngestionErrorCode.Skipped_IngestByTagAlreadyExists:case Kusto.Data.Common.IngestionErrorCode.Timeout:return!0;default:return!1}},FastHasFlag$1:function(e,t){return(e&t)>>>0===t},FastHasFlag:function(e,t){return(e&t)>>>0===t},FastParse:function(e,t){void 0===t&&(t=!1);var n={v:new Kusto.Data.Common.IngestionErrorCode};if(Kusto.Data.Common.ExtendedIngestionErrorCode.FastTryParse(e,n,t))return n.v;throw new System.Exception("Invalid enum value: "+(e||""))},FastTryParse:function(e,t,n,s){switch(void 0===n&&(n=!1),void 0===s&&(s=!1),e){case"Unknown":return t.v=Kusto.Data.Common.IngestionErrorCode.Unknown,!0;case"0x80DA0008":case"Stream_WrongNumberOfFields":return t.v=Kusto.Data.Common.IngestionErrorCode.Stream_WrongNumberOfFields,!0;case"0x80DA0009":case"Stream_InputStreamTooLarge":return t.v=Kusto.Data.Common.IngestionErrorCode.Stream_InputStreamTooLarge,!0;case"Stream_NoDataToIngest":return t.v=Kusto.Data.Common.IngestionErrorCode.Stream_NoDataToIngest,!0;case"0x80DA000b":case"Stream_ClosingQuoteMissing":return t.v=Kusto.Data.Common.IngestionErrorCode.Stream_ClosingQuoteMissing,!0;case"0x80DA000E":case"Stream_DynamicPropertyBagTooLarge":return t.v=Kusto.Data.Common.IngestionErrorCode.Stream_DynamicPropertyBagTooLarge,!0;case"Download_SourceNotFound":return t.v=Kusto.Data.Common.IngestionErrorCode.Download_SourceNotFound,!0;case"Download_AccessConditionNotSatisfied":return t.v=Kusto.Data.Common.IngestionErrorCode.Download_AccessConditionNotSatisfied,!0;case"Download_Forbidden":return t.v=Kusto.Data.Common.IngestionErrorCode.Download_Forbidden,!0;case"Download_AccountNotFound":return t.v=Kusto.Data.Common.IngestionErrorCode.Download_AccountNotFound,!0;case"Download_BadRequest":return t.v=Kusto.Data.Common.IngestionErrorCode.Download_BadRequest,!0;case"Download_NotTransient":return t.v=Kusto.Data.Common.IngestionErrorCode.Download_NotTransient,!0;case"Download_UnknownError":return t.v=Kusto.Data.Common.IngestionErrorCode.Download_UnknownError,!0;case"UpdatePolicy_QuerySchemaDoesNotMatchTableSchema":return t.v=Kusto.Data.Common.IngestionErrorCode.UpdatePolicy_QuerySchemaDoesNotMatchTableSchema,!0;case"UpdatePolicy_FailedDescendantTransaction":return t.v=Kusto.Data.Common.IngestionErrorCode.UpdatePolicy_FailedDescendantTransaction,!0;case"UpdatePolicy_IngestionError":return t.v=Kusto.Data.Common.IngestionErrorCode.UpdatePolicy_IngestionError,!0;case"UpdatePolicy_UnknownError":return t.v=Kusto.Data.Common.IngestionErrorCode.UpdatePolicy_UnknownError,!0;case"BadRequest_MissingJsonMappingtFailure":return t.v=Kusto.Data.Common.IngestionErrorCode.BadRequest_MissingJsonMappingtFailure,!0;case"BadRequest_InvalidBlob":return t.v=Kusto.Data.Common.IngestionErrorCode.BadRequest_InvalidBlob,!0;case"BadRequest_EmptyBlob":return t.v=Kusto.Data.Common.IngestionErrorCode.BadRequest_EmptyBlob,!0;case"BadRequest_EmptyArchive":return t.v=Kusto.Data.Common.IngestionErrorCode.BadRequest_EmptyArchive,!0;case"BadRequest_InvalidArchive":return t.v=Kusto.Data.Common.IngestionErrorCode.BadRequest_InvalidArchive,!0;case"BadRequest_EmptyBlobUri":return t.v=Kusto.Data.Common.IngestionErrorCode.BadRequest_EmptyBlobUri,!0;case"BadRequest_DatabaseNotExist":return t.v=Kusto.Data.Common.IngestionErrorCode.BadRequest_DatabaseNotExist,!0;case"BadRequest_TableNotExist":return t.v=Kusto.Data.Common.IngestionErrorCode.BadRequest_TableNotExist,!0;case"BadRequest_InvalidKustoIdentityToken":return t.v=Kusto.Data.Common.IngestionErrorCode.BadRequest_InvalidKustoIdentityToken,!0;case"BadRequest_FileTooLarge":return t.v=Kusto.Data.Common.IngestionErrorCode.BadRequest_FileTooLarge,!0;case"BadRequest_TableAccessDenied":return t.v=Kusto.Data.Common.IngestionErrorCode.BadRequest_TableAccessDenied,!0;case"BadRequest_MessageExhausted":return t.v=Kusto.Data.Common.IngestionErrorCode.BadRequest_MessageExhausted,!0;case"General_BadRequest":return t.v=Kusto.Data.Common.IngestionErrorCode.General_BadRequest,!0;case"General_InternalServerError":return t.v=Kusto.Data.Common.IngestionErrorCode.General_InternalServerError,!0;case"UpdatePolicy_Cyclic_Update_Not_Allowed":return t.v=Kusto.Data.Common.IngestionErrorCode.UpdatePolicy_Cyclic_Update_Not_Allowed,!0;case"BadRequest_InvalidMapping":return t.v=Kusto.Data.Common.IngestionErrorCode.BadRequest_InvalidMapping,!0;case"BadRequest_InvalidMappingReference":return t.v=Kusto.Data.Common.IngestionErrorCode.BadRequest_InvalidMappingReference,!0;case"BadRequest_MappingReferenceWasNotFound":return t.v=Kusto.Data.Common.IngestionErrorCode.BadRequest_MappingReferenceWasNotFound,!0;case"BadRequest_FormatNotSupported":return t.v=Kusto.Data.Common.IngestionErrorCode.BadRequest_FormatNotSupported,!0;case"BadRequest_DuplicateMapping":return t.v=Kusto.Data.Common.IngestionErrorCode.BadRequest_DuplicateMapping,!0;case"BadRequest_CorruptedMessage":return t.v=Kusto.Data.Common.IngestionErrorCode.BadRequest_CorruptedMessage,!0;case"BadRequest_InconsistentMapping":return t.v=Kusto.Data.Common.IngestionErrorCode.BadRequest_InconsistentMapping,!0;case"BadRequest_SyntaxError":return t.v=Kusto.Data.Common.IngestionErrorCode.BadRequest_SyntaxError,!0;case"BadRequest_InvalidOrEmptyTableName":return t.v=Kusto.Data.Common.IngestionErrorCode.BadRequest_InvalidOrEmptyTableName,!0;case"BadRequest_EmptyDatabaseName":return t.v=Kusto.Data.Common.IngestionErrorCode.BadRequest_EmptyDatabaseName,!0;case"BadRequest_EmptyTenantIdentifier":return t.v=Kusto.Data.Common.IngestionErrorCode.BadRequest_EmptyTenantIdentifier,!0;case"BadRequest_EmptyMappingReference":return t.v=Kusto.Data.Common.IngestionErrorCode.BadRequest_EmptyMappingReference,!0;case"BadRequest_EntityNotFound":return t.v=Kusto.Data.Common.IngestionErrorCode.BadRequest_EntityNotFound,!0;case"BadRequest_EntityNameIsNotValid":return t.v=Kusto.Data.Common.IngestionErrorCode.BadRequest_EntityNameIsNotValid,!0;case"General_AbandonedIngestion":return t.v=Kusto.Data.Common.IngestionErrorCode.General_AbandonedIngestion,!0;case"General_ThrottledIngestion":return t.v=Kusto.Data.Common.IngestionErrorCode.General_ThrottledIngestion,!0;case"General_TransientSchemaMismatch":return t.v=Kusto.Data.Common.IngestionErrorCode.General_TransientSchemaMismatch,!0;case"BadRequest_DatabaseAccessDenied":return t.v=Kusto.Data.Common.IngestionErrorCode.BadRequest_DatabaseAccessDenied,!0;case"BadRequest_UnexpectedCharacterInInputStream":return t.v=Kusto.Data.Common.IngestionErrorCode.BadRequest_UnexpectedCharacterInInputStream,!0;case"Forbidden":return t.v=Kusto.Data.Common.IngestionErrorCode.Forbidden,!0;case"BadRequest_ZeroRetentionPolicyWithNoUpdatePolicy":return t.v=Kusto.Data.Common.IngestionErrorCode.BadRequest_ZeroRetentionPolicyWithNoUpdatePolicy,!0;case"BadRequest_CreationTimeEarlierThanSoftDeletePeriod":return t.v=Kusto.Data.Common.IngestionErrorCode.BadRequest_CreationTimeEarlierThanSoftDeletePeriod,!0;case"BadRequest_NotSupported":return t.v=Kusto.Data.Common.IngestionErrorCode.BadRequest_NotSupported,!0;case"Skipped_IngestByTagAlreadyExists":return t.v=Kusto.Data.Common.IngestionErrorCode.Skipped_IngestByTagAlreadyExists,!0;case"Timeout":return t.v=Kusto.Data.Common.IngestionErrorCode.Timeout,!0}if(n&&!System.String.isNullOrEmpty(e))switch(e.toLowerCase()){case"unknown":return t.v=Kusto.Data.Common.IngestionErrorCode.Unknown,!0;case"stream_wrongnumberoffields":return t.v=Kusto.Data.Common.IngestionErrorCode.Stream_WrongNumberOfFields,!0;case"stream_inputstreamtoolarge":return t.v=Kusto.Data.Common.IngestionErrorCode.Stream_InputStreamTooLarge,!0;case"stream_nodatatoingest":return t.v=Kusto.Data.Common.IngestionErrorCode.Stream_NoDataToIngest,!0;case"stream_closingquotemissing":return t.v=Kusto.Data.Common.IngestionErrorCode.Stream_ClosingQuoteMissing,!0;case"stream_dynamicpropertybagtoolarge":return t.v=Kusto.Data.Common.IngestionErrorCode.Stream_DynamicPropertyBagTooLarge,!0;case"download_sourcenotfound":return t.v=Kusto.Data.Common.IngestionErrorCode.Download_SourceNotFound,!0;case"download_accessconditionnotsatisfied":return t.v=Kusto.Data.Common.IngestionErrorCode.Download_AccessConditionNotSatisfied,!0;case"download_forbidden":return t.v=Kusto.Data.Common.IngestionErrorCode.Download_Forbidden,!0;case"download_accountnotfound":return t.v=Kusto.Data.Common.IngestionErrorCode.Download_AccountNotFound,!0;case"download_badrequest":return t.v=Kusto.Data.Common.IngestionErrorCode.Download_BadRequest,!0;case"download_nottransient":return t.v=Kusto.Data.Common.IngestionErrorCode.Download_NotTransient,!0;case"download_unknownerror":return t.v=Kusto.Data.Common.IngestionErrorCode.Download_UnknownError,!0;case"updatepolicy_queryschemadoesnotmatchtableschema":return t.v=Kusto.Data.Common.IngestionErrorCode.UpdatePolicy_QuerySchemaDoesNotMatchTableSchema,!0;case"updatepolicy_faileddescendanttransaction":return t.v=Kusto.Data.Common.IngestionErrorCode.UpdatePolicy_FailedDescendantTransaction,!0;case"updatepolicy_ingestionerror":return t.v=Kusto.Data.Common.IngestionErrorCode.UpdatePolicy_IngestionError,!0;case"updatepolicy_unknownerror":return t.v=Kusto.Data.Common.IngestionErrorCode.UpdatePolicy_UnknownError,!0;case"badrequest_missingjsonmappingtfailure":return t.v=Kusto.Data.Common.IngestionErrorCode.BadRequest_MissingJsonMappingtFailure,!0;case"badrequest_invalidblob":return t.v=Kusto.Data.Common.IngestionErrorCode.BadRequest_InvalidBlob,!0;case"badrequest_emptyblob":return t.v=Kusto.Data.Common.IngestionErrorCode.BadRequest_EmptyBlob,!0;case"badrequest_emptyarchive":return t.v=Kusto.Data.Common.IngestionErrorCode.BadRequest_EmptyArchive,!0;case"badrequest_invalidarchive":return t.v=Kusto.Data.Common.IngestionErrorCode.BadRequest_InvalidArchive,!0;case"badrequest_emptybloburi":return t.v=Kusto.Data.Common.IngestionErrorCode.BadRequest_EmptyBlobUri,!0;case"badrequest_databasenotexist":return t.v=Kusto.Data.Common.IngestionErrorCode.BadRequest_DatabaseNotExist,!0;case"badrequest_tablenotexist":return t.v=Kusto.Data.Common.IngestionErrorCode.BadRequest_TableNotExist,!0;case"badrequest_invalidkustoidentitytoken":return t.v=Kusto.Data.Common.IngestionErrorCode.BadRequest_InvalidKustoIdentityToken,!0;case"badrequest_filetoolarge":return t.v=Kusto.Data.Common.IngestionErrorCode.BadRequest_FileTooLarge,!0;case"badrequest_tableaccessdenied":return t.v=Kusto.Data.Common.IngestionErrorCode.BadRequest_TableAccessDenied,!0;case"badrequest_messageexhausted":return t.v=Kusto.Data.Common.IngestionErrorCode.BadRequest_MessageExhausted,!0;case"general_badrequest":return t.v=Kusto.Data.Common.IngestionErrorCode.General_BadRequest,!0;case"general_internalservererror":return t.v=Kusto.Data.Common.IngestionErrorCode.General_InternalServerError,!0;case"updatepolicy_cyclic_update_not_allowed":return t.v=Kusto.Data.Common.IngestionErrorCode.UpdatePolicy_Cyclic_Update_Not_Allowed,!0;case"badrequest_invalidmapping":return t.v=Kusto.Data.Common.IngestionErrorCode.BadRequest_InvalidMapping,!0;case"badrequest_invalidmappingreference":return t.v=Kusto.Data.Common.IngestionErrorCode.BadRequest_InvalidMappingReference,!0;case"badrequest_mappingreferencewasnotfound":return t.v=Kusto.Data.Common.IngestionErrorCode.BadRequest_MappingReferenceWasNotFound,!0;case"badrequest_formatnotsupported":return t.v=Kusto.Data.Common.IngestionErrorCode.BadRequest_FormatNotSupported,!0;case"badrequest_duplicatemapping":return t.v=Kusto.Data.Common.IngestionErrorCode.BadRequest_DuplicateMapping,!0;case"badrequest_corruptedmessage":return t.v=Kusto.Data.Common.IngestionErrorCode.BadRequest_CorruptedMessage,!0;case"badrequest_inconsistentmapping":return t.v=Kusto.Data.Common.IngestionErrorCode.BadRequest_InconsistentMapping,!0;case"badrequest_syntaxerror":return t.v=Kusto.Data.Common.IngestionErrorCode.BadRequest_SyntaxError,!0;case"badrequest_invalidoremptytablename":return t.v=Kusto.Data.Common.IngestionErrorCode.BadRequest_InvalidOrEmptyTableName,!0;case"badrequest_emptydatabasename":return t.v=Kusto.Data.Common.IngestionErrorCode.BadRequest_EmptyDatabaseName,!0;case"badrequest_emptytenantidentifier":return t.v=Kusto.Data.Common.IngestionErrorCode.BadRequest_EmptyTenantIdentifier,!0;case"badrequest_emptymappingreference":return t.v=Kusto.Data.Common.IngestionErrorCode.BadRequest_EmptyMappingReference,!0;case"badrequest_entitynotfound":return t.v=Kusto.Data.Common.IngestionErrorCode.BadRequest_EntityNotFound,!0;case"badrequest_entitynameisnotvalid":return t.v=Kusto.Data.Common.IngestionErrorCode.BadRequest_EntityNameIsNotValid,!0;case"general_abandonedingestion":return t.v=Kusto.Data.Common.IngestionErrorCode.General_AbandonedIngestion,!0;case"general_throttledingestion":return t.v=Kusto.Data.Common.IngestionErrorCode.General_ThrottledIngestion,!0;case"general_transientschemamismatch":return t.v=Kusto.Data.Common.IngestionErrorCode.General_TransientSchemaMismatch,!0;case"badrequest_databaseaccessdenied":return t.v=Kusto.Data.Common.IngestionErrorCode.BadRequest_DatabaseAccessDenied,!0;case"badrequest_unexpectedcharacterininputstream":return t.v=Kusto.Data.Common.IngestionErrorCode.BadRequest_UnexpectedCharacterInInputStream,!0;case"forbidden":return t.v=Kusto.Data.Common.IngestionErrorCode.Forbidden,!0;case"badrequest_zeroretentionpolicywithnoupdatepolicy":return t.v=Kusto.Data.Common.IngestionErrorCode.BadRequest_ZeroRetentionPolicyWithNoUpdatePolicy,!0;case"badrequest_creationtimeearlierthansoftdeleteperiod":return t.v=Kusto.Data.Common.IngestionErrorCode.BadRequest_CreationTimeEarlierThanSoftDeletePeriod,!0;case"badrequest_notsupported":return t.v=Kusto.Data.Common.IngestionErrorCode.BadRequest_NotSupported,!0;case"skipped_ingestbytagalreadyexists":return t.v=Kusto.Data.Common.IngestionErrorCode.Skipped_IngestByTagAlreadyExists,!0;case"timeout":return t.v=Kusto.Data.Common.IngestionErrorCode.Timeout,!0}if(!s){var i={v:0};if(System.Int32.tryParse(e,i))return t.v=i.v>>>0,!0}return t.v=0,!1},FastGetDescription:function(e){switch(e){case Kusto.Data.Common.IngestionErrorCode.Unknown:return"Unknown error occurred";case Kusto.Data.Common.IngestionErrorCode.Stream_WrongNumberOfFields:return"Wrong number of fields.";case Kusto.Data.Common.IngestionErrorCode.Stream_InputStreamTooLarge:return"Input stream/record/field too large.";case Kusto.Data.Common.IngestionErrorCode.Stream_NoDataToIngest:return"No data streams to ingest";case Kusto.Data.Common.IngestionErrorCode.Stream_ClosingQuoteMissing:return"Invalid csv format - closing quote missing.";case Kusto.Data.Common.IngestionErrorCode.Stream_DynamicPropertyBagTooLarge:return"The combined size of the property bag's distinct keys is getting too large.";case Kusto.Data.Common.IngestionErrorCode.Download_SourceNotFound:return"Failed to download source from Azure storage - source not found";case Kusto.Data.Common.IngestionErrorCode.Download_AccessConditionNotSatisfied:return"Failed to download source from Azure storage - access condition not satisfied";case Kusto.Data.Common.IngestionErrorCode.Download_Forbidden:return"Failed to download source from Azure storage - access forbidden";case Kusto.Data.Common.IngestionErrorCode.Download_AccountNotFound:return"Failed to download source from Azure storage - account not found";case Kusto.Data.Common.IngestionErrorCode.Download_BadRequest:return"Failed to download source from Azure storage - bad request";case Kusto.Data.Common.IngestionErrorCode.Download_NotTransient:return"Failed to download source from Azure storage - not transient error";case Kusto.Data.Common.IngestionErrorCode.Download_UnknownError:return"Failed to download source from Azure storage - unknown error";case Kusto.Data.Common.IngestionErrorCode.UpdatePolicy_QuerySchemaDoesNotMatchTableSchema:return"Failed to invoke update policy. Query schema does not match table schema";case Kusto.Data.Common.IngestionErrorCode.UpdatePolicy_FailedDescendantTransaction:return"Failed to invoke update policy. Failed descendant transactional update policy";case Kusto.Data.Common.IngestionErrorCode.UpdatePolicy_IngestionError:return"Failed to invoke update policy. Ingestion Error occurred";case Kusto.Data.Common.IngestionErrorCode.UpdatePolicy_UnknownError:return"Failed to invoke update policy. Unknown error occurred";case Kusto.Data.Common.IngestionErrorCode.BadRequest_MissingJsonMappingtFailure:return"Json pattern was not ingested with jsonMapping parameter";case Kusto.Data.Common.IngestionErrorCode.BadRequest_InvalidBlob:return"Blob is invalid";case Kusto.Data.Common.IngestionErrorCode.BadRequest_EmptyBlob:return"Blob is empty";case Kusto.Data.Common.IngestionErrorCode.BadRequest_EmptyArchive:return"Archive is empty";case Kusto.Data.Common.IngestionErrorCode.BadRequest_InvalidArchive:return"Archive is invalid";case Kusto.Data.Common.IngestionErrorCode.BadRequest_EmptyBlobUri:return"Blob Uri is empty";case Kusto.Data.Common.IngestionErrorCode.BadRequest_DatabaseNotExist:return"Database does not exist";case Kusto.Data.Common.IngestionErrorCode.BadRequest_TableNotExist:return"Table does not exist";case Kusto.Data.Common.IngestionErrorCode.BadRequest_InvalidKustoIdentityToken:return"Invalid kusto identity token";case Kusto.Data.Common.IngestionErrorCode.BadRequest_FileTooLarge:return"File too large";case Kusto.Data.Common.IngestionErrorCode.BadRequest_TableAccessDenied:return"Access to table is denied";case Kusto.Data.Common.IngestionErrorCode.BadRequest_MessageExhausted:return"Message is exhausted";case Kusto.Data.Common.IngestionErrorCode.General_BadRequest:return"Bad request";case Kusto.Data.Common.IngestionErrorCode.General_InternalServerError:return"Internal server error occurred";case Kusto.Data.Common.IngestionErrorCode.UpdatePolicy_Cyclic_Update_Not_Allowed:return"Failed to invoke update policy. Cyclic update is not allowed";case Kusto.Data.Common.IngestionErrorCode.BadRequest_InvalidMapping:return"Failed to parse ingestion mapping.";case Kusto.Data.Common.IngestionErrorCode.BadRequest_InvalidMappingReference:return"Invalid mapping reference.";case Kusto.Data.Common.IngestionErrorCode.BadRequest_MappingReferenceWasNotFound:return"Mapping reference wasn't found.";case Kusto.Data.Common.IngestionErrorCode.BadRequest_FormatNotSupported:return"Format is not supported";case Kusto.Data.Common.IngestionErrorCode.BadRequest_DuplicateMapping:return"Ingestion properties contains ingestion mapping and ingestion mapping reference.";case Kusto.Data.Common.IngestionErrorCode.BadRequest_CorruptedMessage:return"Message is corrupted";case Kusto.Data.Common.IngestionErrorCode.BadRequest_InconsistentMapping:return"Inconsistent ingestion mapping";case Kusto.Data.Common.IngestionErrorCode.BadRequest_SyntaxError:return"Syntax error";case Kusto.Data.Common.IngestionErrorCode.BadRequest_InvalidOrEmptyTableName:return"Table name is empty or invalid";case Kusto.Data.Common.IngestionErrorCode.BadRequest_EmptyDatabaseName:return"Database name is empty";case Kusto.Data.Common.IngestionErrorCode.BadRequest_EmptyTenantIdentifier:return"TenantIdentifier is empty";case Kusto.Data.Common.IngestionErrorCode.BadRequest_EmptyMappingReference:return"MappingReference is empty";case Kusto.Data.Common.IngestionErrorCode.BadRequest_EntityNotFound:return"Failed to locate an entity";case Kusto.Data.Common.IngestionErrorCode.BadRequest_EntityNameIsNotValid:return"Entity name is not valid";case Kusto.Data.Common.IngestionErrorCode.General_AbandonedIngestion:return"Abandoned ingestion.";case Kusto.Data.Common.IngestionErrorCode.General_ThrottledIngestion:return"Throttled ingestion.";case Kusto.Data.Common.IngestionErrorCode.General_TransientSchemaMismatch:return"Schema of target table at start time doesn't match the one at commit time.";case Kusto.Data.Common.IngestionErrorCode.BadRequest_DatabaseAccessDenied:return"Access to database is denied";case Kusto.Data.Common.IngestionErrorCode.BadRequest_UnexpectedCharacterInInputStream:return"Unexpected character in the input stream";case Kusto.Data.Common.IngestionErrorCode.Forbidden:return"Insufficient security permissions to execute request";case Kusto.Data.Common.IngestionErrorCode.BadRequest_ZeroRetentionPolicyWithNoUpdatePolicy:return"Table has zero rentention policy and is not the source table for any update policy";case Kusto.Data.Common.IngestionErrorCode.BadRequest_CreationTimeEarlierThanSoftDeletePeriod:return"Specified creation time is earlier than table's soft delete period";case Kusto.Data.Common.IngestionErrorCode.BadRequest_NotSupported:return"Request not supported";case Kusto.Data.Common.IngestionErrorCode.Skipped_IngestByTagAlreadyExists:return"Another stream with the same ingest-by tag was already ingested";case Kusto.Data.Common.IngestionErrorCode.Timeout:return"Ingestion operation timed out";default:return null}}}}}),Bridge.define("Kusto.Data.Common.ExtendedStorageEngineKind",{statics:{methods:{FastToString:function(e){switch(e){case Kusto.Data.Common.StorageEngineKind.StorageV2:return"StorageV2";case Kusto.Data.Common.StorageEngineKind.StorageV3:return"StorageV3"}return System.String.format("[unknown: {0}]",[Bridge.box(e,System.Int32)])},FastIsDefined$1:function(e){var t={v:new Kusto.Data.Common.StorageEngineKind};return Kusto.Data.Common.ExtendedStorageEngineKind.FastTryParse(e,t,!1,!0)},FastIsDefined:function(e){switch(e){case Kusto.Data.Common.StorageEngineKind.StorageV2:case Kusto.Data.Common.StorageEngineKind.StorageV3:return!0;default:return!1}},FastHasFlag$1:function(e,t){return(e&t)===t},FastHasFlag:function(e,t){return(e&t)===t},FastParse:function(e,t){void 0===t&&(t=!1);var n={v:new Kusto.Data.Common.StorageEngineKind};if(Kusto.Data.Common.ExtendedStorageEngineKind.FastTryParse(e,n,t))return n.v;throw new System.Exception("Invalid enum value: "+(e||""))},FastTryParse:function(e,t,n,s){switch(void 0===n&&(n=!1),void 0===s&&(s=!1),e){case"0":case"StorageV2":return t.v=Kusto.Data.Common.StorageEngineKind.StorageV2,!0;case"1":case"StorageV3":return t.v=Kusto.Data.Common.StorageEngineKind.StorageV3,!0}if(n&&!System.String.isNullOrEmpty(e))switch(e.toLowerCase()){case"storagev2":return t.v=Kusto.Data.Common.StorageEngineKind.StorageV2,!0;case"storagev3":return t.v=Kusto.Data.Common.StorageEngineKind.StorageV3,!0}if(!s){var i={v:0};if(System.Int32.tryParse(e,i))return t.v=i.v,!0}return t.v=0,!1},FastGetDescription:function(e){switch(e){case Kusto.Data.Common.StorageEngineKind.StorageV2:return"V2 - extents data storage engine";case Kusto.Data.Common.StorageEngineKind.StorageV3:return"V3 - shard data storage engine";default:return null}}}}}),Bridge.define("Kusto.Data.Common.ExtendedStreamingIngestionMechanismUsage",{statics:{methods:{FastToString:function(e){switch(e){case Kusto.Data.Common.StreamingIngestionMechanismUsage.None:return"None";case Kusto.Data.Common.StreamingIngestionMechanismUsage.UserData:return"UserData";case Kusto.Data.Common.StreamingIngestionMechanismUsage.SystemDB:return"SystemDB";case Kusto.Data.Common.StreamingIngestionMechanismUsage.UserDataAndSystemDB:return"UserDataAndSystemDB"}var t=Kusto.Data.Common.ExtendedStreamingIngestionMechanismUsage.FastGetFlags(e);return Bridge.toArray(t).join("|")},FastIsDefined$1:function(e){var t={v:new Kusto.Data.Common.StreamingIngestionMechanismUsage};return Kusto.Data.Common.ExtendedStreamingIngestionMechanismUsage.FastTryParse(e,t,!1,!0)},FastIsDefined:function(e){switch(e){case Kusto.Data.Common.StreamingIngestionMechanismUsage.None:case Kusto.Data.Common.StreamingIngestionMechanismUsage.UserData:case Kusto.Data.Common.StreamingIngestionMechanismUsage.SystemDB:case Kusto.Data.Common.StreamingIngestionMechanismUsage.UserDataAndSystemDB:return!0;default:return!1}},FastHasFlag$1:function(e,t){return(e&t)===t},FastHasFlag:function(e,t){return(e&t)===t},FastHasAllFlags:function(e,t){return(e&t)===t},FastHasAnyFlags:function(e,t){return 0!=(e&t)},FastCountIntersectionsWith:function(e,t){var n=e&t;return Kusto.Cloud.Platform.Utils.BitTwiddling.CountBits(n)},FastParse:function(e,t){void 0===t&&(t=!1);var n={v:new Kusto.Data.Common.StreamingIngestionMechanismUsage};if(Kusto.Data.Common.ExtendedStreamingIngestionMechanismUsage.FastTryParse(e,n,t))return n.v;throw new System.Exception("Invalid enum value: "+(e||""))},FastTryParse:function(e,t,n,s){var i,r,a,o,l;switch(void 0===n&&(n=!1),void 0===s&&(s=!1),e){case"0":case"None":return t.v=Kusto.Data.Common.StreamingIngestionMechanismUsage.None,!0;case"1":case"UserData":return t.v=Kusto.Data.Common.StreamingIngestionMechanismUsage.UserData,!0;case"2":case"SystemDB":return t.v=Kusto.Data.Common.StreamingIngestionMechanismUsage.SystemDB,!0;case"UserData | SystemDB":case"UserDataAndSystemDB":return t.v=Kusto.Data.Common.StreamingIngestionMechanismUsage.UserDataAndSystemDB,!0}if(n&&!System.String.isNullOrEmpty(e))switch(e.toLowerCase()){case"none":return t.v=Kusto.Data.Common.StreamingIngestionMechanismUsage.None,!0;case"userdata":return t.v=Kusto.Data.Common.StreamingIngestionMechanismUsage.UserData,!0;case"systemdb":return t.v=Kusto.Data.Common.StreamingIngestionMechanismUsage.SystemDB,!0;case"userdataandsystemdb":return t.v=Kusto.Data.Common.StreamingIngestionMechanismUsage.UserDataAndSystemDB,!0}if(!s&&(r={v:0},System.Int32.tryParse(e,r)))return t.v=r.v,!0;if(t.v=0,!System.String.isNullOrEmpty(e)&&System.String.contains(e,"|")){a=System.String.split(e,System.Array.init([124],System.Char).map((function(e){return String.fromCharCode(e)})),null,1),i=Bridge.getEnumerator(a);try{for(;i.moveNext();){if(o=i.Current,l={v:new Kusto.Data.Common.StreamingIngestionMechanismUsage},!Kusto.Data.Common.ExtendedStreamingIngestionMechanismUsage.FastTryParse(o,l,n,s))return t.v=0,!1;t.v|=l.v}}finally{Bridge.is(i,System.IDisposable)&&i.System$IDisposable$Dispose()}return!0}return!1},FastGetDescription:function(e){switch(e){case Kusto.Data.Common.StreamingIngestionMechanismUsage.None:return"Rowstore is not in use";case Kusto.Data.Common.StreamingIngestionMechanismUsage.UserData:return"Streaming ingestion mechanism is used for user data";case Kusto.Data.Common.StreamingIngestionMechanismUsage.SystemDB:return"Streaming ingestion mechanism is used for $systemdb";case Kusto.Data.Common.StreamingIngestionMechanismUsage.UserDataAndSystemDB:return"Streaming ingestion mechanism can be used for both user data and systemdb.";default:return null}},FastGetFlags:function(e){return new(Bridge.GeneratorEnumerable$1(Kusto.Data.Common.StreamingIngestionMechanismUsage))(Bridge.fn.bind(this,(function(e){var t=0,n=new(Bridge.GeneratorEnumerator$1(Kusto.Data.Common.StreamingIngestionMechanismUsage))(Bridge.fn.bind(this,(function(){try{for(;;)switch(t){case 0:if((e&Kusto.Data.Common.StreamingIngestionMechanismUsage.UserData)===Kusto.Data.Common.StreamingIngestionMechanismUsage.UserData){t=1;continue}t=3;continue;case 1:return n.current=Kusto.Data.Common.StreamingIngestionMechanismUsage.UserData,t=2,!0;case 2:t=3;continue;case 3:if((e&Kusto.Data.Common.StreamingIngestionMechanismUsage.SystemDB)===Kusto.Data.Common.StreamingIngestionMechanismUsage.SystemDB){t=4;continue}t=6;continue;case 4:return n.current=Kusto.Data.Common.StreamingIngestionMechanismUsage.SystemDB,t=5,!0;case 5:t=6;continue;case 6:if((e&Kusto.Data.Common.StreamingIngestionMechanismUsage.UserDataAndSystemDB)===Kusto.Data.Common.StreamingIngestionMechanismUsage.UserDataAndSystemDB){t=7;continue}t=9;continue;case 7:return n.current=Kusto.Data.Common.StreamingIngestionMechanismUsage.UserDataAndSystemDB,t=8,!0;case 8:t=9;continue;default:return!1}}catch(e){throw System.Exception.create(e)}})));return n}),arguments))}}}}),Bridge.define("Kusto.Data.Common.ExtendedTransformationMethod",{statics:{methods:{FastToString:function(e){switch(e){case Kusto.Data.Common.TransformationMethod.None:return"None";case Kusto.Data.Common.TransformationMethod.PropertyBagArrayToDictionary:return"PropertyBagArrayToDictionary";case Kusto.Data.Common.TransformationMethod.SourceLocation:return"SourceLocation";case Kusto.Data.Common.TransformationMethod.SourceLineNumber:return"SourceLineNumber";case Kusto.Data.Common.TransformationMethod.UnknownMethod1:return"UnknownMethod1";case Kusto.Data.Common.TransformationMethod.UnknownMethod:return"UnknownMethod";case Kusto.Data.Common.TransformationMethod.DateTimeFromUnixSeconds:return"DateTimeFromUnixSeconds";case Kusto.Data.Common.TransformationMethod.DateTimeFromUnixMilliseconds:return"DateTimeFromUnixMilliseconds";case Kusto.Data.Common.TransformationMethod.DateTimeFromUnixMicroseconds:return"DateTimeFromUnixMicroseconds";case Kusto.Data.Common.TransformationMethod.DateTimeFromUnixNanoseconds:return"DateTimeFromUnixNanoseconds"}return System.String.format("[unknown: {0}]",[Bridge.box(e,System.Int32)])},FastIsDefined$1:function(e){var t={v:new Kusto.Data.Common.TransformationMethod};return Kusto.Data.Common.ExtendedTransformationMethod.FastTryParse(e,t,!1,!0)},FastIsDefined:function(e){switch(e){case Kusto.Data.Common.TransformationMethod.None:case Kusto.Data.Common.TransformationMethod.PropertyBagArrayToDictionary:case Kusto.Data.Common.TransformationMethod.SourceLocation:case Kusto.Data.Common.TransformationMethod.SourceLineNumber:case Kusto.Data.Common.TransformationMethod.UnknownMethod1:case Kusto.Data.Common.TransformationMethod.UnknownMethod:case Kusto.Data.Common.TransformationMethod.DateTimeFromUnixSeconds:case Kusto.Data.Common.TransformationMethod.DateTimeFromUnixMilliseconds:case Kusto.Data.Common.TransformationMethod.DateTimeFromUnixMicroseconds:case Kusto.Data.Common.TransformationMethod.DateTimeFromUnixNanoseconds:return!0;default:return!1}},FastHasFlag$1:function(e,t){return(e&t)===t},FastHasFlag:function(e,t){return(e&t)===t},FastParse:function(e,t){void 0===t&&(t=!1);var n={v:new Kusto.Data.Common.TransformationMethod};if(Kusto.Data.Common.ExtendedTransformationMethod.FastTryParse(e,n,t))return n.v;throw new System.Exception("Invalid enum value: "+(e||""))},FastTryParse:function(e,t,n,s){switch(void 0===n&&(n=!1),void 0===s&&(s=!1),e){case"0":case"None":return t.v=Kusto.Data.Common.TransformationMethod.None,!0;case"1":case"PropertyBagArrayToDictionary":return t.v=Kusto.Data.Common.TransformationMethod.PropertyBagArrayToDictionary,!0;case"2":case"SourceLocation":return t.v=Kusto.Data.Common.TransformationMethod.SourceLocation,!0;case"3":case"SourceLineNumber":return t.v=Kusto.Data.Common.TransformationMethod.SourceLineNumber,!0;case"4":case"UnknownMethod1":return t.v=Kusto.Data.Common.TransformationMethod.UnknownMethod1,!0;case"5":case"UnknownMethod":return t.v=Kusto.Data.Common.TransformationMethod.UnknownMethod,!0;case"6":case"DateTimeFromUnixSeconds":return t.v=Kusto.Data.Common.TransformationMethod.DateTimeFromUnixSeconds,!0;case"7":case"DateTimeFromUnixMilliseconds":return t.v=Kusto.Data.Common.TransformationMethod.DateTimeFromUnixMilliseconds,!0;case"8":case"DateTimeFromUnixMicroseconds":return t.v=Kusto.Data.Common.TransformationMethod.DateTimeFromUnixMicroseconds,!0;case"9":case"DateTimeFromUnixNanoseconds":return t.v=Kusto.Data.Common.TransformationMethod.DateTimeFromUnixNanoseconds,!0}if(n&&!System.String.isNullOrEmpty(e))switch(e.toLowerCase()){case"none":return t.v=Kusto.Data.Common.TransformationMethod.None,!0;case"propertybagarraytodictionary":return t.v=Kusto.Data.Common.TransformationMethod.PropertyBagArrayToDictionary,!0;case"sourcelocation":return t.v=Kusto.Data.Common.TransformationMethod.SourceLocation,!0;case"sourcelinenumber":return t.v=Kusto.Data.Common.TransformationMethod.SourceLineNumber,!0;case"unknownmethod1":return t.v=Kusto.Data.Common.TransformationMethod.UnknownMethod1,!0;case"unknownmethod":return t.v=Kusto.Data.Common.TransformationMethod.UnknownMethod,!0;case"datetimefromunixseconds":return t.v=Kusto.Data.Common.TransformationMethod.DateTimeFromUnixSeconds,!0;case"datetimefromunixmilliseconds":return t.v=Kusto.Data.Common.TransformationMethod.DateTimeFromUnixMilliseconds,!0;case"datetimefromunixmicroseconds":return t.v=Kusto.Data.Common.TransformationMethod.DateTimeFromUnixMicroseconds,!0;case"datetimefromunixnanoseconds":return t.v=Kusto.Data.Common.TransformationMethod.DateTimeFromUnixNanoseconds,!0}if(!s){var i={v:0};if(System.Int32.tryParse(e,i))return t.v=i.v,!0}return t.v=0,!1},FastGetDescription:function(e){switch(e){case Kusto.Data.Common.TransformationMethod.None:return"Comma-separated value.";case Kusto.Data.Common.TransformationMethod.PropertyBagArrayToDictionary:return"Property bag array to dictionary.";case Kusto.Data.Common.TransformationMethod.SourceLocation:return"Source location.";case Kusto.Data.Common.TransformationMethod.SourceLineNumber:return"Source line number.";case Kusto.Data.Common.TransformationMethod.UnknownMethod1:return"Was GetPathElement";case Kusto.Data.Common.TransformationMethod.UnknownMethod:return"Unknown method.";case Kusto.Data.Common.TransformationMethod.DateTimeFromUnixSeconds:return"Converts UNIX epoch (seconds) to UTC datetime.";case Kusto.Data.Common.TransformationMethod.DateTimeFromUnixMilliseconds:return"Converts UNIX epoch (milliseconds) to UTC datetime.";case Kusto.Data.Common.TransformationMethod.DateTimeFromUnixMicroseconds:return"Converts UNIX epoch (microseconds) to UTC datetime.";case Kusto.Data.Common.TransformationMethod.DateTimeFromUnixNanoseconds:return"Converts UNIX epoch (nanoseconds) to UTC datetime.";default:return null}}}}}),Bridge.define("Kusto.Data.Common.IngestionErrorCategory",{$kind:"enum",statics:{fields:{Unknown:0,InternalServiceError:1,BadFormat:2,BadRequest:3,BlobNotFound:4,UpdatePolicyFailure:5,EntityNotFound:6,UserAccessNotAuthorized:7,DataAccessNotAuthorized:8,FileTooLarge:9,ThrottledOnEngine:10,DownloadFailed:11}}}),Bridge.define("Kusto.Data.Common.IngestionErrorCode",{$kind:"enum",statics:{fields:{Unknown:0,Stream_WrongNumberOfFields:2161770504,Stream_InputStreamTooLarge:2161770505,Stream_NoDataToIngest:2161770506,Stream_ClosingQuoteMissing:2161770507,Stream_DynamicPropertyBagTooLarge:2161770510,Download_SourceNotFound:2161770511,Download_AccessConditionNotSatisfied:2161770512,Download_Forbidden:2161770513,Download_AccountNotFound:2161770514,Download_BadRequest:2161770515,Download_NotTransient:2161770516,Download_UnknownError:2161770517,UpdatePolicy_QuerySchemaDoesNotMatchTableSchema:2161770518,UpdatePolicy_FailedDescendantTransaction:2161770519,UpdatePolicy_IngestionError:2161770520,UpdatePolicy_UnknownError:2161770521,BadRequest_MissingJsonMappingtFailure:2161770522,BadRequest_InvalidBlob:2161770523,BadRequest_EmptyBlob:2161770524,BadRequest_EmptyArchive:2161770525,BadRequest_InvalidArchive:2161770526,BadRequest_EmptyBlobUri:2161770527,BadRequest_DatabaseNotExist:2161770528,BadRequest_TableNotExist:2161770529,BadRequest_InvalidKustoIdentityToken:2161770530,BadRequest_FileTooLarge:2161770531,BadRequest_TableAccessDenied:2161770532,BadRequest_MessageExhausted:2161770533,General_BadRequest:2161770534,General_InternalServerError:2161770535,UpdatePolicy_Cyclic_Update_Not_Allowed:2161770536,BadRequest_InvalidMapping:2161770537,BadRequest_InvalidMappingReference:2161770538,BadRequest_MappingReferenceWasNotFound:2161770539,BadRequest_FormatNotSupported:2161770540,BadRequest_DuplicateMapping:2161770541,BadRequest_CorruptedMessage:2161770542,BadRequest_InconsistentMapping:2161770543,BadRequest_SyntaxError:2161770544,BadRequest_InvalidOrEmptyTableName:2161770545,BadRequest_EmptyDatabaseName:2161770546,BadRequest_EmptyTenantIdentifier:2161770547,BadRequest_EmptyMappingReference:2161770548,BadRequest_EntityNotFound:2161770549,BadRequest_EntityNameIsNotValid:2161770550,General_AbandonedIngestion:2161770551,General_ThrottledIngestion:2161770552,General_TransientSchemaMismatch:2161770553,BadRequest_DatabaseAccessDenied:2161770554,BadRequest_UnexpectedCharacterInInputStream:2161770555,Forbidden:2161770556,BadRequest_ZeroRetentionPolicyWithNoUpdatePolicy:2161770557,BadRequest_CreationTimeEarlierThanSoftDeletePeriod:2161770558,BadRequest_NotSupported:2161770559,Skipped_IngestByTagAlreadyExists:2161770560,Timeout:2161770561}},$utype:System.UInt32}),Bridge.define("Kusto.Data.Common.StorageEngineKind",{$kind:"enum",statics:{fields:{StorageV2:0,StorageV3:1}}}),Bridge.define("Kusto.Data.Common.StreamingIngestionMechanismUsage",{$kind:"enum",statics:{fields:{None:0,UserData:1,SystemDB:2,UserDataAndSystemDB:3}},$flags:!0}),Bridge.define("Kusto.Data.Common.TransformationMethod",{$kind:"enum",statics:{fields:{None:0,PropertyBagArrayToDictionary:1,SourceLocation:2,SourceLineNumber:3,UnknownMethod1:4,UnknownMethod:5,DateTimeFromUnixSeconds:6,DateTimeFromUnixMilliseconds:7,DateTimeFromUnixMicroseconds:8,DateTimeFromUnixNanoseconds:9}}}),Bridge.define("Kusto.Data.DmSettingsType",{$kind:"enum",statics:{fields:{AdminSettings:0,DataObtainerServiceSettings:1,DataAggregatorSettings:2,DataObtainerSettings:3,CloudQueueMessageManagerSettings:4,CloudManagersSettings:5,SchemaManagmentSettings:6,CommonSettings:7,DataImporterSettings:8,StatusReporterSettings:9,All:10}}}),Bridge.define("Kusto.Data.ExtendedDmSettingsType",{statics:{methods:{FastToString:function(e){switch(e){case Kusto.Data.DmSettingsType.AdminSettings:return"AdminSettings";case Kusto.Data.DmSettingsType.DataObtainerServiceSettings:return"DataObtainerServiceSettings";case Kusto.Data.DmSettingsType.DataAggregatorSettings:return"DataAggregatorSettings";case Kusto.Data.DmSettingsType.DataObtainerSettings:return"DataObtainerSettings";case Kusto.Data.DmSettingsType.CloudQueueMessageManagerSettings:return"CloudQueueMessageManagerSettings";case Kusto.Data.DmSettingsType.CloudManagersSettings:return"CloudManagersSettings";case Kusto.Data.DmSettingsType.SchemaManagmentSettings:return"SchemaManagmentSettings";case Kusto.Data.DmSettingsType.CommonSettings:return"CommonSettings";case Kusto.Data.DmSettingsType.DataImporterSettings:return"DataImporterSettings";case Kusto.Data.DmSettingsType.StatusReporterSettings:return"StatusReporterSettings";case Kusto.Data.DmSettingsType.All:return"All"}return System.String.format("[unknown: {0}]",[Bridge.box(e,System.Int32)])},FastIsDefined$1:function(e){var t={v:new Kusto.Data.DmSettingsType};return Kusto.Data.ExtendedDmSettingsType.FastTryParse(e,t,!1,!0)},FastIsDefined:function(e){switch(e){case Kusto.Data.DmSettingsType.AdminSettings:case Kusto.Data.DmSettingsType.DataObtainerServiceSettings:case Kusto.Data.DmSettingsType.DataAggregatorSettings:case Kusto.Data.DmSettingsType.DataObtainerSettings:case Kusto.Data.DmSettingsType.CloudQueueMessageManagerSettings:case Kusto.Data.DmSettingsType.CloudManagersSettings:case Kusto.Data.DmSettingsType.SchemaManagmentSettings:case Kusto.Data.DmSettingsType.CommonSettings:case Kusto.Data.DmSettingsType.DataImporterSettings:case Kusto.Data.DmSettingsType.StatusReporterSettings:case Kusto.Data.DmSettingsType.All:return!0;default:return!1}},FastHasFlag$1:function(e,t){return(e&t)===t},FastHasFlag:function(e,t){return(e&t)===t},FastParse:function(e,t){void 0===t&&(t=!1);var n={v:new Kusto.Data.DmSettingsType};if(Kusto.Data.ExtendedDmSettingsType.FastTryParse(e,n,t))return n.v;throw new System.Exception("Invalid enum value: "+(e||""))},FastTryParse:function(e,t,n,s){switch(void 0===n&&(n=!1),void 0===s&&(s=!1),e){case"AdminSettings":return t.v=Kusto.Data.DmSettingsType.AdminSettings,!0;case"DataObtainerServiceSettings":return t.v=Kusto.Data.DmSettingsType.DataObtainerServiceSettings,!0;case"DataAggregatorSettings":return t.v=Kusto.Data.DmSettingsType.DataAggregatorSettings,!0;case"DataObtainerSettings":return t.v=Kusto.Data.DmSettingsType.DataObtainerSettings,!0;case"CloudQueueMessageManagerSettings":return t.v=Kusto.Data.DmSettingsType.CloudQueueMessageManagerSettings,!0;case"CloudManagersSettings":return t.v=Kusto.Data.DmSettingsType.CloudManagersSettings,!0;case"SchemaManagmentSettings":return t.v=Kusto.Data.DmSettingsType.SchemaManagmentSettings,!0;case"CommonSettings":return t.v=Kusto.Data.DmSettingsType.CommonSettings,!0;case"DataImporterSettings":return t.v=Kusto.Data.DmSettingsType.DataImporterSettings,!0;case"StatusReporterSettings":return t.v=Kusto.Data.DmSettingsType.StatusReporterSettings,!0;case"All":return t.v=Kusto.Data.DmSettingsType.All,!0}if(n&&!System.String.isNullOrEmpty(e))switch(e.toLowerCase()){case"adminsettings":return t.v=Kusto.Data.DmSettingsType.AdminSettings,!0;case"dataobtainerservicesettings":return t.v=Kusto.Data.DmSettingsType.DataObtainerServiceSettings,!0;case"dataaggregatorsettings":return t.v=Kusto.Data.DmSettingsType.DataAggregatorSettings,!0;case"dataobtainersettings":return t.v=Kusto.Data.DmSettingsType.DataObtainerSettings,!0;case"cloudqueuemessagemanagersettings":return t.v=Kusto.Data.DmSettingsType.CloudQueueMessageManagerSettings,!0;case"cloudmanagerssettings":return t.v=Kusto.Data.DmSettingsType.CloudManagersSettings,!0;case"schemamanagmentsettings":return t.v=Kusto.Data.DmSettingsType.SchemaManagmentSettings,!0;case"commonsettings":return t.v=Kusto.Data.DmSettingsType.CommonSettings,!0;case"dataimportersettings":return t.v=Kusto.Data.DmSettingsType.DataImporterSettings,!0;case"statusreportersettings":return t.v=Kusto.Data.DmSettingsType.StatusReporterSettings,!0;case"all":return t.v=Kusto.Data.DmSettingsType.All,!0}if(!s){var i={v:0};if(System.Int32.tryParse(e,i))return t.v=i.v,!0}return t.v=0,!1},FastGetDescription:function(e){switch(e){case Kusto.Data.DmSettingsType.AdminSettings:case Kusto.Data.DmSettingsType.DataObtainerServiceSettings:case Kusto.Data.DmSettingsType.DataAggregatorSettings:case Kusto.Data.DmSettingsType.DataObtainerSettings:case Kusto.Data.DmSettingsType.CloudQueueMessageManagerSettings:case Kusto.Data.DmSettingsType.CloudManagersSettings:case Kusto.Data.DmSettingsType.SchemaManagmentSettings:case Kusto.Data.DmSettingsType.CommonSettings:case Kusto.Data.DmSettingsType.DataImporterSettings:case Kusto.Data.DmSettingsType.StatusReporterSettings:case Kusto.Data.DmSettingsType.All:return"";default:return null}}}}}),Bridge.define("Kusto.Data.ExtendedIngestionQueueType",{statics:{methods:{FastToString:function(e){switch(e){case Kusto.Data.IngestionQueueType.All:return"All";case Kusto.Data.IngestionQueueType.InputQueue:return"InputQueue";case Kusto.Data.IngestionQueueType.InternalQueue:return"InternalQueue";case Kusto.Data.IngestionQueueType.ReadyForAggregationQueue:return"ReadyForAggregationQueue";case Kusto.Data.IngestionQueueType.SecuredReadyForAggregationQueue:return"SecuredReadyForAggregationQueue";case Kusto.Data.IngestionQueueType.AggregatedReadyForImportQueue:return"AggregatedReadyForImportQueue";case Kusto.Data.IngestionQueueType.FailedIngestionsQueue:return"FailedIngestionsQueue";case Kusto.Data.IngestionQueueType.SuccessfulIngestionsQueue:return"SuccessfulIngestionsQueue";case Kusto.Data.IngestionQueueType.AbandonedIngestionsQueue:return"AbandonedIngestionsQueue";case Kusto.Data.IngestionQueueType.SecuredAbandonedIngestionsQueue:return"SecuredAbandonedIngestionsQueue";case Kusto.Data.IngestionQueueType.InternalFailedIngestionsQueue:return"InternalFailedIngestionsQueue";case Kusto.Data.IngestionQueueType.AbandonedInputQueues:return"AbandonedInputQueues"}return System.String.format("[unknown: {0}]",[Bridge.box(e,System.Int32)])},FastIsDefined$1:function(e){var t={v:new Kusto.Data.IngestionQueueType};return Kusto.Data.ExtendedIngestionQueueType.FastTryParse(e,t,!1,!0)},FastIsDefined:function(e){switch(e){case Kusto.Data.IngestionQueueType.All:case Kusto.Data.IngestionQueueType.InputQueue:case Kusto.Data.IngestionQueueType.InternalQueue:case Kusto.Data.IngestionQueueType.ReadyForAggregationQueue:case Kusto.Data.IngestionQueueType.SecuredReadyForAggregationQueue:case Kusto.Data.IngestionQueueType.AggregatedReadyForImportQueue:case Kusto.Data.IngestionQueueType.FailedIngestionsQueue:case Kusto.Data.IngestionQueueType.SuccessfulIngestionsQueue:case Kusto.Data.IngestionQueueType.AbandonedIngestionsQueue:case Kusto.Data.IngestionQueueType.SecuredAbandonedIngestionsQueue:case Kusto.Data.IngestionQueueType.InternalFailedIngestionsQueue:case Kusto.Data.IngestionQueueType.AbandonedInputQueues:return!0;default:return!1}},FastHasFlag$1:function(e,t){return(e&t)===t},FastHasFlag:function(e,t){return(e&t)===t},FastParse:function(e,t){void 0===t&&(t=!1);var n={v:new Kusto.Data.IngestionQueueType};if(Kusto.Data.ExtendedIngestionQueueType.FastTryParse(e,n,t))return n.v;throw new System.Exception("Invalid enum value: "+(e||""))},FastTryParse:function(e,t,n,s){switch(void 0===n&&(n=!1),void 0===s&&(s=!1),e){case"0":case"All":return t.v=Kusto.Data.IngestionQueueType.All,!0;case"1":case"InputQueue":return t.v=Kusto.Data.IngestionQueueType.InputQueue,!0;case"2":case"InternalQueue":return t.v=Kusto.Data.IngestionQueueType.InternalQueue,!0;case"3":case"ReadyForAggregationQueue":return t.v=Kusto.Data.IngestionQueueType.ReadyForAggregationQueue,!0;case"4":case"SecuredReadyForAggregationQueue":return t.v=Kusto.Data.IngestionQueueType.SecuredReadyForAggregationQueue,!0;case"5":case"AggregatedReadyForImportQueue":return t.v=Kusto.Data.IngestionQueueType.AggregatedReadyForImportQueue,!0;case"6":case"FailedIngestionsQueue":return t.v=Kusto.Data.IngestionQueueType.FailedIngestionsQueue,!0;case"7":case"SuccessfulIngestionsQueue":return t.v=Kusto.Data.IngestionQueueType.SuccessfulIngestionsQueue,!0;case"9":case"AbandonedIngestionsQueue":return t.v=Kusto.Data.IngestionQueueType.AbandonedIngestionsQueue,!0;case"10":case"SecuredAbandonedIngestionsQueue":return t.v=Kusto.Data.IngestionQueueType.SecuredAbandonedIngestionsQueue,!0;case"11":case"InternalFailedIngestionsQueue":return t.v=Kusto.Data.IngestionQueueType.InternalFailedIngestionsQueue,!0;case"12":case"AbandonedInputQueues":return t.v=Kusto.Data.IngestionQueueType.AbandonedInputQueues,!0}if(n&&!System.String.isNullOrEmpty(e))switch(e.toLowerCase()){case"all":return t.v=Kusto.Data.IngestionQueueType.All,!0;case"inputqueue":return t.v=Kusto.Data.IngestionQueueType.InputQueue,!0;case"internalqueue":return t.v=Kusto.Data.IngestionQueueType.InternalQueue,!0;case"readyforaggregationqueue":return t.v=Kusto.Data.IngestionQueueType.ReadyForAggregationQueue,!0;case"securedreadyforaggregationqueue":return t.v=Kusto.Data.IngestionQueueType.SecuredReadyForAggregationQueue,!0;case"aggregatedreadyforimportqueue":return t.v=Kusto.Data.IngestionQueueType.AggregatedReadyForImportQueue,!0;case"failedingestionsqueue":return t.v=Kusto.Data.IngestionQueueType.FailedIngestionsQueue,!0;case"successfulingestionsqueue":return t.v=Kusto.Data.IngestionQueueType.SuccessfulIngestionsQueue,!0;case"abandonedingestionsqueue":return t.v=Kusto.Data.IngestionQueueType.AbandonedIngestionsQueue,!0;case"securedabandonedingestionsqueue":return t.v=Kusto.Data.IngestionQueueType.SecuredAbandonedIngestionsQueue,!0;case"internalfailedingestionsqueue":return t.v=Kusto.Data.IngestionQueueType.InternalFailedIngestionsQueue,!0;case"abandonedinputqueues":return t.v=Kusto.Data.IngestionQueueType.AbandonedInputQueues,!0}if(!s){var i={v:0};if(System.Int32.tryParse(e,i))return t.v=i.v,!0}return t.v=0,!1},FastGetDescription:function(e){switch(e){case Kusto.Data.IngestionQueueType.All:case Kusto.Data.IngestionQueueType.InputQueue:case Kusto.Data.IngestionQueueType.InternalQueue:case Kusto.Data.IngestionQueueType.ReadyForAggregationQueue:case Kusto.Data.IngestionQueueType.SecuredReadyForAggregationQueue:case Kusto.Data.IngestionQueueType.AggregatedReadyForImportQueue:case Kusto.Data.IngestionQueueType.FailedIngestionsQueue:case Kusto.Data.IngestionQueueType.SuccessfulIngestionsQueue:case Kusto.Data.IngestionQueueType.AbandonedIngestionsQueue:case Kusto.Data.IngestionQueueType.SecuredAbandonedIngestionsQueue:case Kusto.Data.IngestionQueueType.InternalFailedIngestionsQueue:case Kusto.Data.IngestionQueueType.AbandonedInputQueues:return"";default:return null}}}}}),Bridge.define("Kusto.Data.Ingestion.ExtendedIngestionMappingKind",{statics:{methods:{FastToString:function(e){switch(e){case Kusto.Data.Ingestion.IngestionMappingKind.Unknown:return"Unknown";case Kusto.Data.Ingestion.IngestionMappingKind.Csv:return"Csv";case Kusto.Data.Ingestion.IngestionMappingKind.Json:return"Json";case Kusto.Data.Ingestion.IngestionMappingKind.Avro:return"Avro";case Kusto.Data.Ingestion.IngestionMappingKind.Parquet:return"Parquet";case Kusto.Data.Ingestion.IngestionMappingKind.SStream:return"SStream";case Kusto.Data.Ingestion.IngestionMappingKind.Orc:return"Orc";case Kusto.Data.Ingestion.IngestionMappingKind.ApacheAvro:return"ApacheAvro";case Kusto.Data.Ingestion.IngestionMappingKind.W3CLogFile:return"W3CLogFile"}return System.String.format("[unknown: {0}]",[Bridge.box(e,System.Int32)])},FastIsDefined$1:function(e){var t={v:new Kusto.Data.Ingestion.IngestionMappingKind};return Kusto.Data.Ingestion.ExtendedIngestionMappingKind.FastTryParse(e,t,!1,!0)},FastIsDefined:function(e){switch(e){case Kusto.Data.Ingestion.IngestionMappingKind.Unknown:case Kusto.Data.Ingestion.IngestionMappingKind.Csv:case Kusto.Data.Ingestion.IngestionMappingKind.Json:case Kusto.Data.Ingestion.IngestionMappingKind.Avro:case Kusto.Data.Ingestion.IngestionMappingKind.Parquet:case Kusto.Data.Ingestion.IngestionMappingKind.SStream:case Kusto.Data.Ingestion.IngestionMappingKind.Orc:case Kusto.Data.Ingestion.IngestionMappingKind.ApacheAvro:case Kusto.Data.Ingestion.IngestionMappingKind.W3CLogFile:return!0;default:return!1}},FastHasFlag$1:function(e,t){return(e&t)===t},FastHasFlag:function(e,t){return(e&t)===t},FastParse:function(e,t){void 0===t&&(t=!1);var n={v:new Kusto.Data.Ingestion.IngestionMappingKind};if(Kusto.Data.Ingestion.ExtendedIngestionMappingKind.FastTryParse(e,n,t))return n.v;throw new System.Exception("Invalid enum value: "+(e||""))},FastTryParse:function(e,t,n,s){switch(void 0===n&&(n=!1),void 0===s&&(s=!1),e){case"0":case"Unknown":return t.v=Kusto.Data.Ingestion.IngestionMappingKind.Unknown,!0;case"1":case"Csv":return t.v=Kusto.Data.Ingestion.IngestionMappingKind.Csv,!0;case"2":case"Json":return t.v=Kusto.Data.Ingestion.IngestionMappingKind.Json,!0;case"4":case"Avro":return t.v=Kusto.Data.Ingestion.IngestionMappingKind.Avro,!0;case"5":case"Parquet":return t.v=Kusto.Data.Ingestion.IngestionMappingKind.Parquet,!0;case"6":case"SStream":return t.v=Kusto.Data.Ingestion.IngestionMappingKind.SStream,!0;case"7":case"Orc":return t.v=Kusto.Data.Ingestion.IngestionMappingKind.Orc,!0;case"8":case"ApacheAvro":return t.v=Kusto.Data.Ingestion.IngestionMappingKind.ApacheAvro,!0;case"9":case"W3CLogFile":return t.v=Kusto.Data.Ingestion.IngestionMappingKind.W3CLogFile,!0}if(n&&!System.String.isNullOrEmpty(e))switch(e.toLowerCase()){case"unknown":return t.v=Kusto.Data.Ingestion.IngestionMappingKind.Unknown,!0;case"csv":return t.v=Kusto.Data.Ingestion.IngestionMappingKind.Csv,!0;case"json":return t.v=Kusto.Data.Ingestion.IngestionMappingKind.Json,!0;case"avro":return t.v=Kusto.Data.Ingestion.IngestionMappingKind.Avro,!0;case"parquet":return t.v=Kusto.Data.Ingestion.IngestionMappingKind.Parquet,!0;case"sstream":return t.v=Kusto.Data.Ingestion.IngestionMappingKind.SStream,!0;case"orc":return t.v=Kusto.Data.Ingestion.IngestionMappingKind.Orc,!0;case"apacheavro":return t.v=Kusto.Data.Ingestion.IngestionMappingKind.ApacheAvro,!0;case"w3clogfile":return t.v=Kusto.Data.Ingestion.IngestionMappingKind.W3CLogFile,!0}if(!s){var i={v:0};if(System.Int32.tryParse(e,i))return t.v=i.v,!0}return t.v=0,!1},FastGetDescription:function(e){switch(e){case Kusto.Data.Ingestion.IngestionMappingKind.Unknown:return"Unknown";case Kusto.Data.Ingestion.IngestionMappingKind.Csv:return"Csv";case Kusto.Data.Ingestion.IngestionMappingKind.Json:return"Json";case Kusto.Data.Ingestion.IngestionMappingKind.Avro:return"Avro";case Kusto.Data.Ingestion.IngestionMappingKind.Parquet:return"Parquet";case Kusto.Data.Ingestion.IngestionMappingKind.SStream:return"SStream";case Kusto.Data.Ingestion.IngestionMappingKind.Orc:return"Orc";case Kusto.Data.Ingestion.IngestionMappingKind.ApacheAvro:return"Apache Avro (through avro2json)";case Kusto.Data.Ingestion.IngestionMappingKind.W3CLogFile:return"W3C Extended Log File format";default:return null}}}}}),Bridge.define("Kusto.Data.Ingestion.IngestionMappingKind",{$kind:"enum",statics:{fields:{Unknown:0,Csv:1,Json:2,Avro:4,Parquet:5,SStream:6,Orc:7,ApacheAvro:8,W3CLogFile:9}}}),Bridge.define("Kusto.Data.IngestionQueueType",{$kind:"enum",statics:{fields:{All:0,InputQueue:1,InternalQueue:2,ReadyForAggregationQueue:3,SecuredReadyForAggregationQueue:4,AggregatedReadyForImportQueue:5,FailedIngestionsQueue:6,SuccessfulIngestionsQueue:7,AbandonedIngestionsQueue:9,SecuredAbandonedIngestionsQueue:10,InternalFailedIngestionsQueue:11,AbandonedInputQueues:12}}}),Bridge.define("Kusto.Data.IntelliSense.AdminEngineRuleKind",{$kind:"enum",statics:{fields:{None:0,Start:0,YieldShowCommandOptions:0,YieldTableNamesForAdminOptions:1,YieldFunctionNamesForAdminOptions:2,YieldDatabaseNames:3,YieldShowBasicAuthOptions:4,YieldShowDatabasePrincipalsPoliciesAndSchemaOptions:5,YieldShowDatabasesOptions:6,YieldShowClusterPrincipalsOptions:7,YieldSetDatabaseAdminsUsersViewersPrettyNameOptions:8,YieldSetClusterAdminsUsersViewersDatabaseCreatorsOptions:9,YieldSetTableAdminsOptions:10,YieldAddDatabaseAdminsUsersViewersOptions:11,YieldDropDatabaseOptions:12,YieldAddClusterAdminsUsersViewersDatabaseCreatorsBlockedPrincipalsOptions:13,YieldDropClusterAdminsUsersViewersDatabaseCreatorsBlockedPrincipalsOptions:14,YieldAddClusterBlockedPrincipalsOptions:15,YieldAddTableAdminsOptions:16,YieldDropTableEntitiesOptions:17,YieldDeleteTableEntitiesOptions:18,YieldCreateTableEntitiesOptions:19,YieldAlterTableEntitiesOptions:20,YieldDropTableColumnsSyntaxOptions:21,YieldSetDatabaseUsersNoneOptions:22,YieldSetDatabaseAdminsNoneOptions:23,YieldSetDatabaseViewersNoneOptions:24,YieldSetClusterUsersNoneOptions:25,YieldSetClusterAdminsNoneOptions:26,YieldSetClusterViewersNoneOptions:27,YieldSetClusterDatabaseCreatorsNoneOptions:28,YieldSetTableAdminsNoneOptions:29,YieldShowTableEntitiesOptions:30,YieldAlterExtentTagsOptions:31,YieldAttachExtentsOptions:32,YieldAttachExtentsIntoTableOptions:33,YieldDropExtentTagsOptions:34,YieldMoveExtentsOptions:35,YieldMoveSpecifiedExtentsOptions:36,YieldMoveExtentsToTableOptions:37,YieldReplaceCommandOptions:38,YieldReplaceExtentsOptions:39,YieldRunCommandOptions:40,YieldShowExtentsOptions:41,YieldShowExtentsByEntityOptions:42,YieldShowExtentsByEntityWithTagsFiltersOptions:43,YieldSetCommandOptions:44,YieldSetOrAppendCommandOptions:45,YieldAddCommandOptions:46,YieldAttachCommandOptions:47,YieldDropCommandOptions:48,YieldMoveCommandOptions:49,YieldPoliciesOptions:50,YieldClusterPoliciesOptions:51,YieldDatabasePoliciesOptions:52,YieldTablePoliciesOptions:53,YieldColumnPoliciesOptions:54,YieldAlterCommandOptions:55,YieldAlterMergeCommandOptions:56,YieldDeleteCommandOptions:57,YieldCreateCommandOptions:58,YieldMultiplePoliciesOptions:59,YieldDatabaseCreatePersistencyOptions:60,YieldCreateIfNotExistsOptions:61,YieldAdminCommandsOptions:62,YieldExportCommandOptions:63,YieldExportCommandWithModifiersAndOptions:64,YieldExportCommandNoModifiersAndOptions:65,YieldAlterDatabaseCommandOptions:66,YieldDeleteMultiplePoliciesOptions:67,YieldIngestionDuplicationOptions:68,YieldPurgeOptions:69,YieldPurgeCleanupOptions:70,YieldPurgeWhatIfOptions:71,YieldPurgeWithPropertiesOptions:72,YieldPurgeTableOptions:73,YieldShowPrincipalCommandOptions:74,YieldAlterFunctionEntitiesOptions:75,YieldAlterMergePolicyRetentionOptions:76,YieldAlterMergePolicyRetentionSoftDeleteDefinedOptions:77,YieldAlterTimeSpanPolicyOptions:78,YieldCreateOrAlterOptions:79,YieldShowFabricOptions:80,YieldRowStoreCreatePersistencyOptions:81,YieldSetDatabaseIngestorsNoneOptions:82,YieldSetTableIngestorsNoneOptions:83,YieldSuspendNodeControlCommandOptions:84},ctors:{init:function(){this.None=Kusto.Data.IntelliSense.RuleKind.None,this.Start=Kusto.Data.IntelliSense.RuleKind.Last}}}}),Bridge.define("Kusto.Data.IntelliSense.AnalyzedCommand",{fields:{Command:null,Context:null}}),Bridge.define("Kusto.Data.IntelliSense.ApiKind",{$kind:"enum",statics:{fields:{Query:0,AdminSyncCommand:1,AdminAsyncCommand:2}}}),Bridge.define("Kusto.Data.IntelliSense.ApplyPolicy",{statics:{fields:{NullApplyPolicy:null,AppendSpacePolicy:null,AppendPipePolicy:null,AppendStringLiteralArrayPolicy:null,StringComparisonPolicy:null,AppendCommaPolicy:null,AppendDoubleCommaPolicy:null,AppendSpaceStepBackPolicy:null,AppendSpaceAfterBracketPolicy:null,MoveAfterTheBracketPolicy:null,AppendAssignmentPolicy:null,AppendJoinClauseWithOpenningBracketPolicy:null,AppendJoinClauseWithoutOpenningBracketPolicy:null,AppendFindInClausePolicy:null,AppendSearchInClausePolicy:null,AppendFindInClauseWithoutOpenningBracketPolicy:null},ctors:{init:function(){var e;this.NullApplyPolicy=((e=new Kusto.Data.IntelliSense.ApplyPolicy).Text="",e),this.AppendSpacePolicy=((e=new Kusto.Data.IntelliSense.ApplyPolicy).Text=" ",e),this.AppendPipePolicy=((e=new Kusto.Data.IntelliSense.ApplyPolicy).Text=" | ",e),this.AppendStringLiteralArrayPolicy=((e=new Kusto.Data.IntelliSense.ApplyPolicy).Text=' ("", "")',e.OffsetPosition=2,e.OffsetToken="(",e),this.StringComparisonPolicy=((e=new Kusto.Data.IntelliSense.ApplyPolicy).Text=' "" ',e.OffsetPosition=-2,e),this.AppendCommaPolicy=((e=new Kusto.Data.IntelliSense.ApplyPolicy).Text=", ",e.OffsetPosition=0,e),this.AppendDoubleCommaPolicy=((e=new Kusto.Data.IntelliSense.ApplyPolicy).Text=", , ",e.OffsetPosition=-2,e),this.AppendSpaceStepBackPolicy=((e=new Kusto.Data.IntelliSense.ApplyPolicy).Text=" ",e.OffsetPosition=-2,e),this.AppendSpaceAfterBracketPolicy=((e=new Kusto.Data.IntelliSense.ApplyPolicy).Text=" ",e.OffsetToken="(",e.OffsetPosition=1,e),this.MoveAfterTheBracketPolicy=((e=new Kusto.Data.IntelliSense.ApplyPolicy).Text="",e.OffsetToken=")",e.OffsetPosition=1,e),this.AppendAssignmentPolicy=((e=new Kusto.Data.IntelliSense.ApplyPolicy).Text=" = ",e),this.AppendJoinClauseWithOpenningBracketPolicy=((e=new Kusto.Data.IntelliSense.ApplyPolicy).OffsetPosition=-13,e.Text=" (\r\n    \r\n) on Key1 ",e),this.AppendJoinClauseWithoutOpenningBracketPolicy=((e=new Kusto.Data.IntelliSense.ApplyPolicy).OffsetPosition=-13,e.Text="\r\n    \r\n) on Key1 ",e),this.AppendFindInClausePolicy=((e=new Kusto.Data.IntelliSense.ApplyPolicy).OffsetPosition=-8,e.Text=" () where ",e),this.AppendSearchInClausePolicy=((e=new Kusto.Data.IntelliSense.ApplyPolicy).OffsetPosition=-2,e.Text=" () ",e),this.AppendFindInClauseWithoutOpenningBracketPolicy=((e=new Kusto.Data.IntelliSense.ApplyPolicy).OffsetPosition=-8,e.Text=") where ",e)}}},props:{Text:null,OffsetPosition:0,OffsetToken:null},ctors:{ctor:function(){this.$initialize()}}}),Bridge.define("Kusto.Data.IntelliSense.IntelliSenseRulesProviderBase",{statics:{fields:{CommonRegexOptions:0,DefaultRegexOptions:0,s_isCommandRegex:null,s_firstWordAfterPipeRegex:null},ctors:{init:function(){this.CommonRegexOptions=16,this.DefaultRegexOptions=0,this.s_isCommandRegex=new System.Text.RegularExpressions.Regex.ctor("^\\s*\\.",Kusto.Data.IntelliSense.IntelliSenseRulesProviderBase.CommonRegexOptions),this.s_firstWordAfterPipeRegex=new System.Text.RegularExpressions.Regex.ctor("^\\s*(?<FirstWord>[\\w\\-]+)\\s+",Kusto.Data.IntelliSense.IntelliSenseRulesProviderBase.CommonRegexOptions)}},methods:{FindRules:function(e,t,n,s,i){var r,a;r=Bridge.getEnumerator(e);try{for(;r.moveNext();)if((null==(a=r.Current).RequiredKeywords||!(a.RequiredKeywords.Count>0)||(!1,a.RequiresFullCommand?System.Linq.Enumerable.from(a.RequiredKeywords,System.String).any((function(e){return System.String.contains(t,e)})):!System.String.isNullOrEmpty(i)&&a.RequiredKeywords.contains(i)))&&a.IsMatch(n,a.RequiresFullCommand?t:s))return a}finally{Bridge.is(r,System.IDisposable)&&r.System$IDisposable$Dispose()}return null},FindLastStatement:function(e){return System.String.isNullOrEmpty(e)?"":System.Linq.Enumerable.from(Kusto.Data.IntelliSense.IntelliSenseRulesProviderBase.ParseAsStatements(e,59,!1),System.String).lastOrDefault(null,null)},ParseAsStatements:function(e,t,n){var s,i,r,a,o,l,u=new(System.Collections.Generic.List$1(System.String).ctor);if(System.String.isNullOrEmpty(e))return u;for(s=0,i=System.String.toCharArray(e,0,e.length),r=0;r<i.length;r=r+1|0)!(34===(a=i[System.Array.index(r,i)])|39===a)||(r=Kusto.Data.IntelliSense.IntelliSenseRulesProviderBase.SkipToBalancedChar(i,r+1|0,a,System.Array.init([34,39],System.Char))),o=r===(i.length-1|0),(a===t||o)&&(l=1+(r-s|0)|0,n&&a===t&&(l=l-1|0),l>0&&u.add(e.substr(s,l)),s=r+1|0);return u},SkipToBalancedChar:function(e,t,n,s){for(var i,r=t;r<e.length;r=r+1|0){if((i=e[System.Array.index(r,e)])===n)return r;System.Array.contains(s,i,System.Char)&&(r=Kusto.Data.IntelliSense.IntelliSenseRulesProviderBase.SkipToBalancedChar(e,r+1|0,i,s))}return e.length-1|0},GetApproximateCommandLastPart:function(e,t,n){var s=System.String.split(e,[124].map((function(e){return String.fromCharCode(e)}))),i=System.Linq.Enumerable.from(s,System.String).lastOrDefault(null,null);t.v=i,s.length>1&&(t.v="|"+(i||"")),System.String.isNullOrEmpty(i)?n.v="":n.v=Kusto.Data.IntelliSense.IntelliSenseRulesProviderBase.GetFirstWordAfterPipe(i)},GetFirstWordAfterPipe:function(e){return Kusto.Data.IntelliSense.IntelliSenseRulesProviderBase.s_firstWordAfterPipeRegex.match(e).getGroups().getByName("FirstWord").toString()}}},props:{Locker:null,GeneralRules:null,CommandRules:null,QueryParametersRules:null,DefaultRule:null,CommandToolTips:null,ContextConnection:null},ctors:{ctor:function(){this.$initialize(),this.Locker={}}},methods:{TryMatchAnyRule:function(e,t){var n,s,i,r,a,o=this.AnalyzeCommand$1(e,null),l=o.Context,u={},d={};if(Kusto.Data.IntelliSense.IntelliSenseRulesProviderBase.GetApproximateCommandLastPart(o.Command,d,u),i=Kusto.Data.IntelliSense.IntelliSenseRulesProviderBase.s_isCommandRegex.isMatch(e),t.v=null,i){Kusto.Data.IntelliSense.IntelliSenseRulesProviderBase.PrivateTracer.Tracer.TraceVerbose("TryMatchAnyRule: start matching rules for commands rules"),n=Bridge.getEnumerator(this.CommandRules);try{for(;n.moveNext();)if((r=n.Current).IsMatch(l,r.RequiresFullCommand?e:d.v)){t.v=r;break}}finally{Bridge.is(n,System.IDisposable)&&n.System$IDisposable$Dispose()}}if(null==t.v&&(Kusto.Data.IntelliSense.IntelliSenseRulesProviderBase.PrivateTracer.Tracer.TraceVerbose("TryMatchAnyRule: start matching rules for general rules"),t.v=Kusto.Data.IntelliSense.IntelliSenseRulesProviderBase.FindRules(this.GeneralRules,e,l,d.v,u.v)),null==t.v){Kusto.Data.IntelliSense.IntelliSenseRulesProviderBase.PrivateTracer.Tracer.TraceVerbose("TryMatchAnyRule: start matching rules for query parameters rules"),s=Bridge.getEnumerator(this.QueryParametersRules);try{for(;s.moveNext();)if((a=s.Current).IsMatch(l,a.RequiresFullCommand?e:d.v)){t.v=a;break}}finally{Bridge.is(s,System.IDisposable)&&s.System$IDisposable$Dispose()}}return null!=t.v&&t.v.IsContextual?(Kusto.Data.IntelliSense.IntelliSenseRulesProviderBase.PrivateTracer.Tracer.TraceVerbose("TryMatchAnyRule: rule {0} was found",[Bridge.box(t.v.Kind,System.Int32)]),this.UpdateProviderAvailableEntities(e,l),Kusto.Data.IntelliSense.IntelliSenseRulesProviderBase.PrivateTracer.Tracer.TraceVerbose("TryMatchAnyRule: Entities were updated",[Bridge.box(t.v.Kind,System.Int32)])):Kusto.Data.IntelliSense.IntelliSenseRulesProviderBase.PrivateTracer.Tracer.TraceVerbose("TryMatchAnyRule: no rule was found"),null!=t.v},TryMatchSpecificRule:function(e,t,n,s){return s.v=null,Kusto.Data.IntelliSense.IntelliSenseRulesProviderBase.s_isCommandRegex.isMatch(e)&&(s.v=System.Linq.Enumerable.from(this.CommandRules,Kusto.Data.IntelliSense.IntelliSenseRule).firstOrDefault((function(s){return s.Kind===n&&s.IsMatch(t,e)}),null)),null==s.v&&(s.v=System.Linq.Enumerable.from(this.GeneralRules,Kusto.Data.IntelliSense.IntelliSenseRule).firstOrDefault((function(s){return s.Kind===n&&s.IsMatch(t,e)}),null)),null!=s.v&&s.v.IsContextual&&this.UpdateProviderAvailableEntities(e,t),null!=s.v},SetQueryParametersRule:function(e){},Initialize:function(){this.CommandRules=new(System.Collections.Generic.List$1(Kusto.Data.IntelliSense.IntelliSenseRule).ctor),this.GeneralRules=new(System.Collections.Generic.List$1(Kusto.Data.IntelliSense.IntelliSenseRule).ctor),this.CommandToolTips=new(System.Collections.Generic.List$1(Kusto.Data.IntelliSense.IntelliSenseCommandTip).ctor),this.QueryParametersRules=new(System.Collections.Generic.List$1(Kusto.Data.IntelliSense.IntelliSenseRule).ctor)}}}),Bridge.define("Kusto.Data.IntelliSense.CMRuleKind",{$kind:"enum",statics:{fields:{None:0,Start:0,YieldAdminCommandsOptions:0,YieldPipeOptions:1,YieldOperatorsAfterPipe:2,YieldShowCommandOptions:3,YieldShowAccountCommandOptions:4,YieldShowAccountsKeywordOptions:5,YieldMoveAccountCommandOptions:6,YieldMoveAccountSubscriptionCommandOptions:7,YieldMoveCommandOptions:8,YieldAlterCommandOptions:9,YieldAddCommandOptions:10,YieldDropCommandOptions:11,YieldRemoveCommandOptions:12,YieldCreateCommandOptions:13,YieldCreateExternalCommandOptions:14,YieldDeleteCommandOptions:15,YieldDetachCommandOptions:16,YieldCheckCommandOptions:17,YieldSetCommandOptions:18,YieldRegisterCommandOptions:19,YieldServiceKeywordOptions:20,YieldServiceOrClusterKeywordOptions:21,YieldStorageAccountsKeywordOptions:22,YieldIngestLogsIntoKeywordsOptions:23,YieldInServiceKeywordOptions:24,YieldShowClusterKeywordOptions:25,YieldOperationsKeywordOptions:26,YieldPcCodeKeywordOptions:27,YieldFromServiceKeywordOptions:28,YieldFromAccountKeywordOptions:29,YieldShowAuditLogCommandOptions:30,YieldShowAuditLogFromCommandOptions:31,YieldShowCmServiceCommandOptions:32,YieldShowClusterClientOptions:33,YieldShowClusterClientSubscriptionCommandOptions:34,YieldShowClusterClusterNamePrincipalCommandOptions:35,YieldShowServicesCompletionKeywordsOptions:36,YieldConfigurationPropertySetKeywordOptions:37,YieldConfigurationPropertyDropKeywordOptions:38,YieldToStringKeywordOptions:39,YieldToKeywordOptions:40,YieldConfigurationPropertyWithConsentKeywordOptions:41,YieldAccountAlterOperationsKeywordOptions:42,YieldAccountAddOperationsKeywordOptions:43,YieldAccountRemoveOperationsKeywordOptions:44,YieldAccountSetOperationsKeywordOptions:45,YieldAccountRenameOperationsKeywordOptions:46,YieldServiceAlterOperationsKeywordOptions:47,YieldMetadataKeywordOptions:48,YieldSummaryKeywordOptions:49,YieldSummaryOrMetadataKeywordOptions:50,YieldDatabaseOrAccountMetadataKeywordOptions:51,YieldAccountNames:52,YieldDmServiceAddKeywordOptions:53,YieldDmServiceDropKeywordOptions:54,YieldDmServiceAlterKeywordOptions:55,YieldDmServiceAlterSettingsOptions:56,YieldDmServiceShowKeywordOptions:57,YieldServicesNames:58,YieldServicesNamesCombinedWithOptions:59,YieldTargetServiceOptions:60,YieldWithPropertiesSuffix:61,YieldWithEventHubPropertiesSuffix:62,YieldInstallCommandOptions:63,YieldReinstallCommandOptions:64,YieldUninstallServiceCommandOptions:65,YieldUninstallCommandOptions:66,YieldMigrateServiceCommandOptions:67,YieldDatabaseMoveCommandOptions:68,YieldDatabaseMoveFromServiceCommandOptions:69,YieldSetClusterPrincipalsCommandOptions:70,YieldAddClusterPrincipalsCommandOptions:71,YieldDropClusterPrincipalsCommandOptions:72,YieldAddClusterJitPrincipalsCommandOptions:73,YieldDropClusterJitPrincipalsCommandOptions:74,YieldSetClusterPrincipalsNoneOptions:75,YieldDropAccountPrincipalsCommandOptions:76,YieldDatabaseCreateCommandOptions:77,YieldServiceCreateCommandOptions:78,YieldShowPrincipalRolesCommandOptions:79,YieldAddKeywordOptions:80,YieldAlterServiceConfigurationPropertiesOptions:81,YieldAlterServiceConfigurationCommandOptions:82,YieldMoveServiceConfigurationCommandOptions:83,YieldAddServiceServiceNameOptions:84,YieldLoadBalancerKeywordOptions:85,YieldOperationKeywordOptions:86,YieldShowSubscriptionCommandOptions:87,YieldShowServiceSecurityRulesCommandOptions:88,YieldKeysCommandOptions:89,YieldKeyTypesCommandOptions:90,YieldAlterServiceStorageAccountsCommandOptions:91,YieldCmNotifyCommandOptions:92,YieldExecuteCommandOptions:93,YieldExecuteJobCommandOptions:94,YieldGenerateCommandOptions:95,YieldPublishCommandOptions:96,YieldSkuAvailabilityPrefix:97,YieldSkuAvailabilityCommandValues:98,YieldSkuAvailabilityPropertiesSuffix:99,YieldServiceRegenerateSuffix:100,YieldVersionKeywordOptions:101,YieldExportCommandOptions:102,YieldExportPackageForOptions:103,YieldExportPackageForServiceTypeOptions:104,YieldSharedIdentity:105,YieldSetRegionVisibility:106,YieldRegisterFeature:107,YieldBillingServiceCreateResources:108,YieldPublishServiceCommandOptions:109,YieldUnPublishCommandOptions:110,YieldUnPublishServiceCommandOptions:111,YieldRotateCommandOptions:112,YieldRotateServiceCommandOptions:113},ctors:{init:function(){this.None=Kusto.Data.IntelliSense.RuleKind.None,this.Start=Kusto.Data.IntelliSense.RuleKind.Last}}}}),Bridge.define("Kusto.Data.IntelliSense.CompletionOption",{props:{Kind:0,Value:null},ctors:{ctor:function(e,t){this.$initialize(),this.Kind=e,this.Value=t}}}),Bridge.define("Kusto.Data.IntelliSense.CompletionOptionCollection",{fields:{m_materializedOptions:null},props:{Kind:0,Values:null,Priority:0},ctors:{ctor:function(e,t,n){void 0===n&&(n=0),this.$initialize(),this.Kind=e,this.Values=t,this.Priority=n}},methods:{GetCompletionOptions:function(){return null==this.m_materializedOptions&&(this.m_materializedOptions=System.Linq.Enumerable.from(this.Values,System.String).select(Bridge.fn.bind(this,e.$.Kusto.Data.IntelliSense.CompletionOptionCollection.f1)).ToArray(Kusto.Data.IntelliSense.CompletionOption)),this.m_materializedOptions}}}),Bridge.ns("Kusto.Data.IntelliSense.CompletionOptionCollection",e.$),Bridge.apply(e.$.Kusto.Data.IntelliSense.CompletionOptionCollection,{f1:function(e){return new Kusto.Data.IntelliSense.CompletionOption(this.Kind,e)}}),Bridge.define("Kusto.Data.IntelliSense.ContextOperation",{$kind:"enum",statics:{fields:{None:0,Union:1,Intersect:2}}}),Bridge.define("Kusto.Data.IntelliSense.IntelliSenseRule",{props:{Kind:0,RequiredKeywords:null,AfterApplyPolicies:null,BeforeApplyPolicies:null,DefaultAfterApplyPolicy:null,DefaultBeforeApplyPolicy:null},methods:{GetAfterApplyInfo:function(e){var t={v:null};return null!=this.AfterApplyPolicies&&this.AfterApplyPolicies.tryGetValue(e,t),t.v||this.DefaultAfterApplyPolicy||Kusto.Data.IntelliSense.ApplyPolicy.NullApplyPolicy},GetBeforeApplyInfo:function(e){var t={v:null};return null!=this.BeforeApplyPolicies&&this.BeforeApplyPolicies.tryGetValue(e,t),t.v||this.DefaultBeforeApplyPolicy||Kusto.Data.IntelliSense.ApplyPolicy.NullApplyPolicy}}}),Bridge.define("Kusto.Data.IntelliSense.CslCommand",{statics:{fields:{c_tabulation:null,s_newLineRegex:null,s_removeWhiteSpacesAfterPipeRegex:null,s_joinStartRegex:null,s_joinEndRegex:null,s_makeSeriesOperatorRegex:null,s_operatorRegex:null,s_operatorsNotRequiringFullEntitiesResolve:null,s_nameOrListRegex:null,s_hasAssignmentOperationRegex:null,s_startsWithAlpha:null},ctors:{init:function(){this.c_tabulation="    ",this.s_newLineRegex=new System.Text.RegularExpressions.Regex.ctor("[\\n\\r]",Kusto.Data.IntelliSense.IntelliSenseRulesProviderBase.CommonRegexOptions),this.s_removeWhiteSpacesAfterPipeRegex=new System.Text.RegularExpressions.Regex.ctor("^\\|\\s+",Kusto.Data.IntelliSense.IntelliSenseRulesProviderBase.DefaultRegexOptions),this.s_joinStartRegex=new System.Text.RegularExpressions.Regex.ctor("(?<JoinOpPart>^\\s*\\|\\s*join\\s+(kind\\s*=\\s*\\w+\\s*)?)(?<Bracket>\\()?(?<PostJoinPart>.+$)",Kusto.Data.IntelliSense.IntelliSenseRulesProviderBase.CommonRegexOptions),this.s_joinEndRegex=new System.Text.RegularExpressions.Regex.ctor("(?!^.*\\bmake-series\\b.*$)((?<InnerJoinPart>^.*?)(?<Bracket>\\)?)\\s*\\b(?<JoinOnPart>on\\s+.+))",Kusto.Data.IntelliSense.IntelliSenseRulesProviderBase.CommonRegexOptions),this.s_makeSeriesOperatorRegex=new System.Text.RegularExpressions.Regex.ctor("\\bmake-series\\b",Kusto.Data.IntelliSense.IntelliSenseRulesProviderBase.DefaultRegexOptions),this.s_operatorRegex=new System.Text.RegularExpressions.Regex.ctor("\\|\\s*(?<Operator>[\\w-]+)",Kusto.Data.IntelliSense.IntelliSenseRulesProviderBase.DefaultRegexOptions),this.s_operatorsNotRequiringFullEntitiesResolve=e.$.Kusto.Data.IntelliSense.CslCommand.f1(new(System.Collections.Generic.HashSet$1(System.String).ctor)),this.s_nameOrListRegex="(?:\\w+)|(?:\\((\\w+)(,\\s*\\w+)*\\))",this.s_hasAssignmentOperationRegex=new System.Text.RegularExpressions.Regex.ctor("(^\\s*\\|\\s*(extend|parse|summarize|project|mvexpand|mv-expand|make-series|project-rename)\\s+"+(Kusto.Data.IntelliSense.CslCommand.s_nameOrListRegex||"")+")|(^\\s*range)",Kusto.Data.IntelliSense.IntelliSenseRulesProviderBase.DefaultRegexOptions),this.s_startsWithAlpha=new System.Text.RegularExpressions.Regex.ctor("^\\s*[a-z]",1)}},methods:{MakeTrivialCommandFromText:function(e){var t,n;return(t=new Kusto.Data.IntelliSense.CslCommand).m_commandParts=(n=Kusto.Data.IntelliSense.CslCommandToken,System.Linq.Enumerable.from(System.Array.init([new Kusto.Data.IntelliSense.CslCommandToken(e,0,Kusto.Data.IntelliSense.CslCommandToken.Kind.CslCommandToken)],Kusto.Data.IntelliSense.CslCommandToken),n).toList(n)),t.Text=e,t.Length=e.length,t.AbsolutePositionBias=0,t.RelativeStart=0,t.ParseMode=Kusto.Data.IntelliSense.ParseMode.CommandTokensOnly,t.IsRunnable=!System.String.isNullOrWhiteSpace(e),t},UnionCommands:function(t){var n,s,i;return System.Linq.Enumerable.from(t,Kusto.Data.IntelliSense.CslCommand).count()<2?System.Linq.Enumerable.from(t,Kusto.Data.IntelliSense.CslCommand).firstOrDefault(null,null):(s=System.Linq.Enumerable.from(t,Kusto.Data.IntelliSense.CslCommand).first(),(n=new Kusto.Data.IntelliSense.CslCommand).m_tokens=System.Linq.Enumerable.from(t,Kusto.Data.IntelliSense.CslCommand).selectMany(e.$.Kusto.Data.IntelliSense.CslCommand.f2).toList(Kusto.Data.IntelliSense.CslCommandToken),n.m_commandParts=System.Linq.Enumerable.from(t,Kusto.Data.IntelliSense.CslCommand).selectMany(e.$.Kusto.Data.IntelliSense.CslCommand.f3).toList(Kusto.Data.IntelliSense.CslCommandToken),n.m_commentsParts=System.Linq.Enumerable.from(t,Kusto.Data.IntelliSense.CslCommand).selectMany(e.$.Kusto.Data.IntelliSense.CslCommand.f4).toList(Kusto.Data.IntelliSense.CslCommandToken),n.m_clientDirectivesParts=System.Linq.Enumerable.from(t,Kusto.Data.IntelliSense.CslCommand).selectMany(e.$.Kusto.Data.IntelliSense.CslCommand.f5).toList(Kusto.Data.IntelliSense.CslCommandToken),n.m_bracketParts=System.Linq.Enumerable.from(t,Kusto.Data.IntelliSense.CslCommand).selectMany(e.$.Kusto.Data.IntelliSense.CslCommand.f6).toList(Kusto.Data.IntelliSense.CslCommandToken),n.Text=Bridge.toArray(System.Linq.Enumerable.from(t,Kusto.Data.IntelliSense.CslCommand).selectMany(e.$.Kusto.Data.IntelliSense.CslCommand.f7)).join(""),n.IsRunnable=System.Linq.Enumerable.from(t,Kusto.Data.IntelliSense.CslCommand).any(e.$.Kusto.Data.IntelliSense.CslCommand.f8),n.RelativeStart=s.RelativeStart,n.AbsolutePositionBias=s.AbsolutePositionBias,n.ParseMode=s.ParseMode,(i=n).Length=i.Text.length,i)},NormalizeCommandPart:function(e){return e=e.trim(),Kusto.Data.IntelliSense.CslCommand.s_removeWhiteSpacesAfterPipeRegex.replace(e,"| ")},AppendTabulatedText:function(e,t,n){Kusto.Data.IntelliSense.CslCommand.AppendTabulations(e,t),e.append(n)},AppendTabulations:function(e,t){if(!(t<=0))for(var n=0;n<t;n=n+1|0)e.append(Kusto.Data.IntelliSense.CslCommand.c_tabulation)},ResolveOperatorContext:function(e){return null==e||System.String.indexOf(e.Text," on ")>0&&!Kusto.Data.IntelliSense.CslCommand.s_makeSeriesOperatorRegex.isMatch(e.Text)?"":Kusto.Data.IntelliSense.CslCommand.s_operatorRegex.match(e.Text).getGroups().getByName("Operator").toString()},GetKnownEntities:function(e,t,n,s,i,r,a,o,l){if(o.v=new(System.Collections.Generic.List$1(System.String).ctor),l.v=n.containsKey(r)?n.getItem(r):new(System.Collections.Generic.List$1(System.String).ctor),null==s||Kusto.Data.IntelliSense.CslCommand.s_operatorsNotRequiringFullEntitiesResolve.contains(a))return t.containsKey(r)&&(o.v=t.getItem(r)),!1;var u=i.toString();return e.GetKnownEntities(u,r,n,o,l)},IsMatchingRegex:function(e,t){return!System.String.isNullOrWhiteSpace(e)&&t.isMatch(e)},StartsWithAlpha:function(e){return!System.String.isNullOrWhiteSpace(e)&&Kusto.Data.IntelliSense.CslCommand.s_startsWithAlpha.isMatch(e)}}},fields:{m_tokens:null,m_commandParts:null,m_commentsParts:null,m_clientDirectivesParts:null,m_bracketParts:null,m_commandPartsParseStates:null},props:{CslExpressionStartPosition:{get:function(){return Kusto.Cloud.Platform.Utils.ExtendedEnumerable.SafeFastNone$1(Kusto.Data.IntelliSense.CslCommandToken,this.m_commandParts)?0:this.m_commandParts.getItem(0).RelativeStart}},CslExpressionLength:{get:function(){return Kusto.Cloud.Platform.Utils.ExtendedEnumerable.SafeFastNone$1(Kusto.Data.IntelliSense.CslCommandToken,this.m_commandParts)?0:System.Linq.Enumerable.from(this.m_commandParts,Kusto.Data.IntelliSense.CslCommandToken).last().RelativeEnd-this.m_commandParts.getItem(0).RelativeStart|0}},Tokens:{get:function(){return this.m_tokens}},CommandParts:{get:function(){return this.m_commandParts}},CommentParts:{get:function(){return this.m_commentsParts}},BracketParts:{get:function(){return this.m_bracketParts}},AllParts:{get:function(){var t=0,n=null;return Kusto.Cloud.Platform.Utils.ExtendedEnumerable.SafeFastAny$1(Kusto.Data.IntelliSense.CslCommandToken,this.m_commandParts)&&(t=t+1|0,n=this.m_commandParts),Kusto.Cloud.Platform.Utils.ExtendedEnumerable.SafeFastAny$1(Kusto.Data.IntelliSense.CslCommandToken,this.m_commentsParts)&&(t=t+1|0,n=null!=n?System.Linq.Enumerable.from(n,Kusto.Data.IntelliSense.CslCommandToken).union(this.m_commentsParts):Bridge.cast(this.m_commentsParts,System.Collections.Generic.IEnumerable$1(Kusto.Data.IntelliSense.CslCommandToken))),Kusto.Cloud.Platform.Utils.ExtendedEnumerable.SafeFastAny$1(Kusto.Data.IntelliSense.CslCommandToken,this.m_clientDirectivesParts)&&(t=t+1|0,n=null!=n?System.Linq.Enumerable.from(n,Kusto.Data.IntelliSense.CslCommandToken).union(this.m_clientDirectivesParts):Bridge.cast(this.m_clientDirectivesParts,System.Collections.Generic.IEnumerable$1(Kusto.Data.IntelliSense.CslCommandToken))),t>1?System.Linq.Enumerable.from(n,Kusto.Data.IntelliSense.CslCommandToken).orderBy(e.$.Kusto.Data.IntelliSense.CslCommand.f9):n}},Text:null,RelativeStart:0,Length:0,RelativeEnd:{get:function(){return(this.RelativeStart+this.Length|0)-1|0}},AbsoluteStart:{get:function(){return this.AbsolutePositionBias+this.RelativeStart|0}},AbsoluteEnd:{get:function(){return this.AbsolutePositionBias+this.RelativeEnd|0}},AbsolutePositionBias:0,IsRunnable:!1,ParseMode:0,ContextCache:null},ctors:{ctor:function(){this.$initialize()}},methods:{FormatAsString:function(t,n){var s,i,r,a,o;if(Kusto.Cloud.Platform.Utils.ExtendedEnumerable.SafeFastNone$1(Kusto.Data.IntelliSense.CslCommandToken,this.m_commandParts))return"";i=this.m_commandParts,System.Enum.hasFlag(n,Bridge.box(Kusto.Data.IntelliSense.CslCommand.FormatTraits.IncludeComments,Kusto.Data.IntelliSense.CslCommand.FormatTraits,System.Enum.toStringFn(Kusto.Data.IntelliSense.CslCommand.FormatTraits)))&&Kusto.Cloud.Platform.Utils.ExtendedEnumerable.SafeFastAny$1(Kusto.Data.IntelliSense.CslCommandToken,this.m_commentsParts)&&(i=System.Linq.Enumerable.from(i,Kusto.Data.IntelliSense.CslCommandToken).union(this.m_commentsParts).union(this.m_clientDirectivesParts).orderBy(e.$.Kusto.Data.IntelliSense.CslCommand.f10).toList(Kusto.Data.IntelliSense.CslCommandToken));var l=new System.Text.StringBuilder,u={v:0},d=!0;s=Bridge.getEnumerator(i);try{for(;s.moveNext();)r=s.Current,a=Kusto.Data.IntelliSense.CslCommand.s_newLineRegex.replace(r.Value," "),d||l.append(t),d=!1,Kusto.Data.IntelliSense.CslCommand.AppendTabulations(l,u.v),!(o=!1)&&System.Enum.hasFlag(n,Bridge.box(Kusto.Data.IntelliSense.CslCommand.FormatTraits.IncludeComments,Kusto.Data.IntelliSense.CslCommand.FormatTraits,System.Enum.toStringFn(Kusto.Data.IntelliSense.CslCommand.FormatTraits)))&&(o=this.HandleCommentsAndClientDirectives(t,l,u,r,a)),!o&&System.Enum.hasFlag(n,Bridge.box(Kusto.Data.IntelliSense.CslCommand.FormatTraits.TabulateOnFunctionBoundaries,Kusto.Data.IntelliSense.CslCommand.FormatTraits,System.Enum.toStringFn(Kusto.Data.IntelliSense.CslCommand.FormatTraits)))&&(o=this.HandleFunctions(t,l,u,r)),!o&&System.Enum.hasFlag(n,Bridge.box(Kusto.Data.IntelliSense.CslCommand.FormatTraits.TabulateOnJoins,Kusto.Data.IntelliSense.CslCommand.FormatTraits,System.Enum.toStringFn(Kusto.Data.IntelliSense.CslCommand.FormatTraits)))&&(o=this.HandleJoins(t,l,u,r,a)),o||l.append(Kusto.Data.IntelliSense.CslCommand.NormalizeCommandPart(a))}finally{Bridge.is(s,System.IDisposable)&&s.System$IDisposable$Dispose()}return l.toString()},HandleCommentsAndClientDirectives:function(e,t,n,s,i){return!Kusto.Cloud.Platform.Utils.ExtendedEnumerable.None$1(Kusto.Data.IntelliSense.CslCommandToken,System.Linq.Enumerable.from(this.m_commentsParts,Kusto.Data.IntelliSense.CslCommandToken).union(this.m_clientDirectivesParts),(function(e){return e.AbsoluteStart===s.AbsoluteStart&&e.AbsoluteEnd===s.AbsoluteEnd}))&&(t.append(i.trim()),!0)},HandleFunctions:function(e,t,n,s){var i,r,a,o,l,u,d=!1,m=0,c=System.String.indexOf(s.Value,String.fromCharCode(123)),p=s.AbsoluteStart+c|0;return c>=0&&Kusto.Cloud.Platform.Utils.ExtendedEnumerable.None$1(Kusto.Data.IntelliSense.CslCommandToken,this.m_tokens,(function(e){return p>=e.AbsoluteStart&&p<=e.AbsoluteEnd}))&&(i=s.Value.substr(0,c).trim(),i=Kusto.Data.IntelliSense.CslCommand.s_newLineRegex.replace(i," "),t.append(i),t.append(e),t.append("{"),t.append(e),n.v=n.v+1|0,d=!0,m=c+1|0),r=System.String.indexOf(s.Value,String.fromCharCode(125)),a=s.AbsoluteStart+r|0,r>=0&&Kusto.Cloud.Platform.Utils.ExtendedEnumerable.None$1(Kusto.Data.IntelliSense.CslCommandToken,this.m_tokens,(function(e){return a>=e.AbsoluteStart&&a<=e.AbsoluteEnd}))&&c<r?(o=s.Value.substr(m,r-m|0).trim(),l=s.Value.substr(r+1|0).trim(),l=Kusto.Data.IntelliSense.CslCommand.s_newLineRegex.replace(l," "),d&&Kusto.Data.IntelliSense.CslCommand.AppendTabulations(t,n.v),t.append(o),t.append(e),t.append("}"),n.v=n.v-1|0,n.v<0&&(n.v=0),Kusto.Data.IntelliSense.CslCommand.AppendTabulatedText(t,n.v,l),d=!0):d&&(u=s.Value.substr(m).trim(),u=Kusto.Data.IntelliSense.CslCommand.s_newLineRegex.replace(u," "),Kusto.Data.IntelliSense.CslCommand.AppendTabulatedText(t,n.v,u)),d},HandleJoins:function(e,t,n,s,i){var r,a,o,l,u=!1,d=!1,m=i,c=Kusto.Data.IntelliSense.CslCommand.s_joinStartRegex.match(m),p=0;if(c.getSuccess()&&(r=c.getGroups().getByName("JoinOpPart").toString(),t.append(Kusto.Data.IntelliSense.CslCommand.NormalizeCommandPart(r)),t.append(e),u=!System.String.isNullOrEmpty(c.getGroups().getByName("Bracket").toString()),n.v=n.v+1|0,m=c.getGroups().getByName("PostJoinPart").toString(),p=c.getGroups().getByName("PostJoinPart").getIndex(),d=!0),(a=Kusto.Data.IntelliSense.CslCommand.s_joinEndRegex.match(m)).getSuccess()&&System.Linq.Enumerable.from(this.m_tokens,Kusto.Data.IntelliSense.CslCommandToken).any((function(e){return e.TokenKind===Kusto.Data.IntelliSense.CslCommandToken.Kind.SubOperatorToken&&Bridge.referenceEquals(e.Value,"on")&&e.AbsoluteStart===((a.getGroups().getByName("JoinOnPart").getIndex()+s.AbsoluteStart|0)+p|0)}))){var S=Kusto.Data.IntelliSense.CslCommand.NormalizeCommandPart(a.getGroups().getByName("InnerJoinPart").toString()),g=Kusto.Data.IntelliSense.CslCommand.NormalizeCommandPart(a.getGroups().getByName("JoinOnPart").toString()),h=!System.String.isNullOrEmpty(a.getGroups().getByName("Bracket").toString()),y=h||u,f=Kusto.Cloud.Platform.Utils.ExtendedString.CountNonOverlappingSubstrings$1(S,"("),I=Kusto.Cloud.Platform.Utils.ExtendedString.CountNonOverlappingSubstrings$1(S,")");h&&f>I&&(y=!1,S=(S||"")+")"),c.getSuccess()&&(u&&(Kusto.Data.IntelliSense.CslCommand.AppendTabulatedText(t,n.v-1|0,"("),t.append(e)),Kusto.Data.IntelliSense.CslCommand.AppendTabulations(t,n.v)),n.v=n.v-1|0,n.v<0&&(n.v=0),System.String.isNullOrEmpty(S)?(o=Kusto.Data.IntelliSense.CslCommand.c_tabulation.length,t.replace(Kusto.Data.IntelliSense.CslCommand.c_tabulation,"",t.getLength()-o|0,o),l=!1,y&&(t.append(")"),t.append(e),l=!0),l?Kusto.Data.IntelliSense.CslCommand.AppendTabulatedText(t,n.v,Kusto.Data.IntelliSense.CslCommand.NormalizeCommandPart(g)):t.append(g)):(t.append(S),t.append(e),y&&(Kusto.Data.IntelliSense.CslCommand.AppendTabulatedText(t,n.v,")"),t.append(e)),Kusto.Data.IntelliSense.CslCommand.AppendTabulatedText(t,n.v,Kusto.Data.IntelliSense.CslCommand.NormalizeCommandPart(g))),d=!0}else c.getSuccess()&&(u&&(Kusto.Data.IntelliSense.CslCommand.AppendTabulatedText(t,n.v-1|0,"("),t.append(e)),Kusto.Data.IntelliSense.CslCommand.AppendTabulatedText(t,n.v,Kusto.Data.IntelliSense.CslCommand.NormalizeCommandPart(m)));return d},AcquireTokens:function(t){this.m_tokens=System.Linq.Enumerable.from(t.m_tokens,Kusto.Data.IntelliSense.CslCommandToken).select(Bridge.fn.bind(this,e.$.Kusto.Data.IntelliSense.CslCommand.f11)).toList(Kusto.Data.IntelliSense.CslCommandToken),this.m_commandParts=System.Linq.Enumerable.from(t.m_commandParts,Kusto.Data.IntelliSense.CslCommandToken).select(Bridge.fn.bind(this,e.$.Kusto.Data.IntelliSense.CslCommand.f11)).toList(Kusto.Data.IntelliSense.CslCommandToken),this.m_commentsParts=System.Linq.Enumerable.from(t.m_commentsParts,Kusto.Data.IntelliSense.CslCommandToken).select(Bridge.fn.bind(this,e.$.Kusto.Data.IntelliSense.CslCommand.f11)).toList(Kusto.Data.IntelliSense.CslCommandToken),this.m_clientDirectivesParts=System.Linq.Enumerable.from(t.m_clientDirectivesParts,Kusto.Data.IntelliSense.CslCommandToken).select(Bridge.fn.bind(this,e.$.Kusto.Data.IntelliSense.CslCommand.f11)).toList(Kusto.Data.IntelliSense.CslCommandToken),this.m_bracketParts=System.Linq.Enumerable.from(t.m_bracketParts,Kusto.Data.IntelliSense.CslCommandToken).select(Bridge.fn.bind(this,e.$.Kusto.Data.IntelliSense.CslCommand.f11)).toList(Kusto.Data.IntelliSense.CslCommandToken)},ParseTokens:function(t,n,s){var i,r,a,o,l,u,d=new(System.Collections.Generic.List$1(Kusto.Data.IntelliSense.CslCommandToken).ctor);System.String.isNullOrEmpty(this.Text)?this.m_tokens=d:(null!=t&&(t.ResetState(),null!=s&&Kusto.Cloud.Platform.Utils.ExtendedEnumerable.SafeFastAny$1(System.Collections.Generic.KeyValuePair$2(System.Int32,Kusto.Data.IntelliSense.KustoCommandContext),s.ContextCache)&&(t.ContextCache=new(System.Collections.Generic.Dictionary$2(System.Int32,Kusto.Data.IntelliSense.KustoCommandContext).$ctor1)(s.ContextCache))),i=null!=t&&t.AllowQueryParameters,(r=new Kusto.Data.IntelliSense.CslCommandIndexer(i)).AntiTokenizers=new(System.Collections.Generic.HashSet$1(System.Char).$ctor1)(System.Array.init([45,95,40],System.Char)),r.TokenStarters=System.Array.init([46],System.Char),r.TokenTerminators=new(System.Collections.Generic.HashSet$1(System.Char).$ctor1)(System.Array.init([40,46],System.Char)),r.IndexText(this.Text),a=new(System.Collections.Generic.List$1(Kusto.Data.IntelliSense.CslCommandIndexer.TokenPosition).ctor),this.m_commandParts=new(System.Collections.Generic.List$1(Kusto.Data.IntelliSense.CslCommandToken).ctor),o=r.GetCommandPartsPositions(),this.AddCategorizedTokens(this.m_commandParts,null,o,Kusto.Data.IntelliSense.CslCommandToken.Kind.CommandPartToken),this.m_commentsParts=new(System.Collections.Generic.List$1(Kusto.Data.IntelliSense.CslCommandToken).ctor),l=r.GetCommentsPositions(),this.AddCategorizedTokens(this.m_commentsParts,null,l,Kusto.Data.IntelliSense.CslCommandToken.Kind.CommentToken),this.m_clientDirectivesParts=new(System.Collections.Generic.List$1(Kusto.Data.IntelliSense.CslCommandToken).ctor),u=r.GetClientDirectivesPositions(),this.AddCategorizedTokens(this.m_clientDirectivesParts,null,u,Kusto.Data.IntelliSense.CslCommandToken.Kind.ClientDirectiveToken),this.m_bracketParts=new(System.Collections.Generic.List$1(Kusto.Data.IntelliSense.CslCommandToken).ctor),this.AddCategorizedTokens(this.m_bracketParts,null,r.GetBracketsPositions(),Kusto.Data.IntelliSense.CslCommandToken.Kind.BracketRangeToken),this.AddCategorizedTokens(d,a,l,Kusto.Data.IntelliSense.CslCommandToken.Kind.CommentToken),this.AddCategorizedTokens(d,a,u,Kusto.Data.IntelliSense.CslCommandToken.Kind.ClientDirectiveToken),i&&this.AddCategorizedTokens(d,a,r.GetQueryParametersPositions(),Kusto.Data.IntelliSense.CslCommandToken.Kind.QueryParametersToken),this.AddCategorizedTokens(d,a,r.GetStringLiteralsPositions(),Kusto.Data.IntelliSense.CslCommandToken.Kind.StringLiteralToken),this.AddCategorizedTokens(d,a,r.GetAllTokenPositions(Kusto.Data.IntelliSense.CslCommandParser.ControlCommandsTokens),Kusto.Data.IntelliSense.CslCommandToken.Kind.ControlCommandToken),this.AddCategorizedTokens(d,a,r.GetAllTokenPositions(Kusto.Data.IntelliSense.CslCommandParser.CslCommandsTokens),Kusto.Data.IntelliSense.CslCommandToken.Kind.CslCommandToken),this.AddCategorizedTokens(d,a,r.GetAllTokenPositions(Kusto.Data.IntelliSense.CslCommandParser.OperatorCommandTokens),Kusto.Data.IntelliSense.CslCommandToken.Kind.OperatorToken),this.AddCategorizedTokens(d,a,r.GetAllTokenPositions(Kusto.Data.IntelliSense.CslCommandParser.SubOperatorsTokens),Kusto.Data.IntelliSense.CslCommandToken.Kind.SubOperatorToken),this.AddCategorizedTokens(d,a,r.GetAllTokenPositions(Kusto.Data.IntelliSense.CslCommandParser.JoinKindTokens),Kusto.Data.IntelliSense.CslCommandToken.Kind.SubOperatorToken),this.AddCategorizedTokens(d,a,r.GetAllTokenPositions(Kusto.Data.IntelliSense.CslCommandParser.ReduceByKindTokens),Kusto.Data.IntelliSense.CslCommandToken.Kind.SubOperatorToken),this.AddCategorizedTokens(d,a,r.GetAllTokenPositions(Kusto.Data.IntelliSense.CslCommandParser.DataTypesTokens),Kusto.Data.IntelliSense.CslCommandToken.Kind.DataTypeToken),this.AddCategorizedTokens(d,a,r.GetAllTokenPositions(Kusto.Data.IntelliSense.CslCommandParser.FunctionsTokens,40),Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken),this.AddCategorizedTokens(d,a,r.GetAllTokenPositions(Kusto.Data.IntelliSense.CslCommandParser.PluginTokens,40),Kusto.Data.IntelliSense.CslCommandToken.Kind.PluginToken),null!=t&&this.AddEntitiesTokens(t,d,a,r,o,s),d.Sort$2(e.$.Kusto.Data.IntelliSense.CslCommand.f12),this.ValidateTokensOutput(d,this.Text),n===Kusto.Data.IntelliSense.ParseMode.TokenizeAllText&&(this.EnsureAllTextIsAnnotated(r,d,a),d.Sort$2(e.$.Kusto.Data.IntelliSense.CslCommand.f12)),this.m_tokens=d,null!=t&&(this.ContextCache=t.ContextCache))},ValidateTokensOutput:function(e,t){for(var n,s,i,r=new(System.Collections.Generic.List$1(Kusto.Data.IntelliSense.CslCommandToken).ctor),a=0,o=t.length,l=0;l<System.Linq.Enumerable.from(e,Kusto.Data.IntelliSense.CslCommandToken).count();l=l+1|0)(n=e.getItem(l)).RelativeEnd<a||n.RelativeStart<a||n.RelativeEnd>o?r.add(n):a=n.RelativeEnd;i=Bridge.getEnumerator(r);try{for(;i.moveNext();)s=i.Current,e.remove(s)}finally{Bridge.is(i,System.IDisposable)&&i.System$IDisposable$Dispose()}},AddEntitiesTokens:function(t,n,s,i,r,a){var o,l,u,d,m,c,p,S,g,h;this.AddCategorizedTokens(n,s,i.GetAllTokenPositions(t.TableNames),Kusto.Data.IntelliSense.CslCommandToken.Kind.TableToken),this.m_commandPartsParseStates=new(System.Collections.Generic.List$1(Kusto.Data.IntelliSense.CslCommand.AddEntitiesTokensState).ctor);var y=new System.Text.StringBuilder,f=new(System.Collections.Generic.HashSet$1(System.String).$ctor1)(t.FunctionNames),I=null!=a,K=null,T=null;for(o=0;o<(System.Array.getCount(r,Kusto.Data.IntelliSense.CslCommandIndexer.TokenPosition)+1|0);o=o+1|0)if(l=o>0?System.Array.getItem(r,o-1|0,Kusto.Data.IntelliSense.CslCommandIndexer.TokenPosition):null,u={v:o<System.Array.getCount(r,Kusto.Data.IntelliSense.CslCommandIndexer.TokenPosition)?System.Array.getItem(r,o,Kusto.Data.IntelliSense.CslCommandIndexer.TokenPosition):null},K=null!=K?K.Clone():new Kusto.Data.IntelliSense.CslCommand.AddEntitiesTokensState,null!=u.v&&y.append(u.v.Text),I=!!(I&(null!=u.v&&null!=a&&Kusto.Cloud.Platform.Utils.ExtendedEnumerable.SafeFastAny$2(Kusto.Data.IntelliSense.CslCommandToken,a.CommandParts)&&Kusto.Cloud.Platform.Utils.ExtendedEnumerable.SafeFastAny$1(Kusto.Data.IntelliSense.CslCommand.AddEntitiesTokensState,a.m_commandPartsParseStates)&&System.Linq.Enumerable.from(a.m_commandPartsParseStates,Kusto.Data.IntelliSense.CslCommand.AddEntitiesTokensState).count()>o&&System.Linq.Enumerable.from(a.CommandParts,Kusto.Data.IntelliSense.CslCommandToken).count()>o&&System.String.equals(u.v.Text,System.Linq.Enumerable.from(a.CommandParts,Kusto.Data.IntelliSense.CslCommandToken).elementAt(o).Value)))){var C=System.Linq.Enumerable.from(a.CommandParts,Kusto.Data.IntelliSense.CslCommandToken).elementAt(o),x={v:u.v.Start-C.RelativeStart|0},D=System.Linq.Enumerable.from(a.Tokens,Kusto.Data.IntelliSense.CslCommandToken).where(function(e,t){return function(e){return(e.TokenKind===Kusto.Data.IntelliSense.CslCommandToken.Kind.CalculatedColumnToken||e.TokenKind===Kusto.Data.IntelliSense.CslCommandToken.Kind.TableColumnToken||e.TokenKind===Kusto.Data.IntelliSense.CslCommandToken.Kind.TableToken||e.TokenKind===Kusto.Data.IntelliSense.CslCommandToken.Kind.LetVariablesToken)&&e.RelativeStart>=t.v.Start&&e.RelativeEnd<=t.v.End}}(0,u)).select(function(e,t){return function(e){var n=Bridge.as(e.clone(),Kusto.Data.IntelliSense.CslCommandToken);return n.RelativeStart=n.RelativeStart+t.v|0,n}}(0,x)).ToArray(Kusto.Data.IntelliSense.CslCommandToken);n.AddRange(D),s.AddRange(i.GetTokenPositionsInRange(System.Linq.Enumerable.from(D,Kusto.Data.IntelliSense.CslCommandToken).select(e.$.Kusto.Data.IntelliSense.CslCommand.f13),u.v.Start,u.v.End)),this.AddLetStatementTokens(n,s,i,f,u.v),K=a.m_commandPartsParseStates.getItem(o).Clone(),this.m_commandPartsParseStates.add(K)}else if(null!=u.v&&this.AddLetStatementTokens(n,s,i,f,u.v),null==T?(d=y.toString(),T=t.AnalyzeCommand$1(d,a)):null!=u.v&&(T=t.AnalyzeCommand(T,u.v.Text)),!(m=T.Context).IsEmpty()){var R=Kusto.Data.IntelliSense.CslCommand.ResolveOperatorContext(u.v),b={},v={},w=Kusto.Data.IntelliSense.CslCommand.GetKnownEntities(t,K.MapOfKnownEntities,K.MapOfOriginallyKnownEntities,u.v,y,m,R,b,v);if(null!=u.v&&(t.ResolveKnownEntitiesFromContext(m),c=System.Linq.Enumerable.from(b.v,System.String).except(v.v),p=System.Linq.Enumerable.from(v.v,System.String).intersect(b.v),this.AddCategorizedTokens(n,s,i.GetTokenPositionsInRange(p,u.v.Start,u.v.End),Kusto.Data.IntelliSense.CslCommandToken.Kind.TableColumnToken),this.AddCategorizedTokens(n,s,i.GetTokenPositionsInRange(c,u.v.Start,u.v.End),Kusto.Data.IntelliSense.CslCommandToken.Kind.CalculatedColumnToken),this.AddCategorizedTokens(n,s,i.GetTokenPositionsInRange(t.RemoteTableNames,u.v.Start,u.v.End),Kusto.Data.IntelliSense.CslCommandToken.Kind.TableToken)),!w&&null!=u.v)switch(S=new(System.Collections.Generic.List$1(System.String).ctor),t.ResolveEntitiesFromCommand((u.v.Text||"")+" | ",S,b.v)){case Kusto.Data.IntelliSense.CslQueryIntelliSenseRulesProvider.ResolveResult.ReplaceEntities:b.v=S;break;case Kusto.Data.IntelliSense.CslQueryIntelliSenseRulesProvider.ResolveResult.None:break;case Kusto.Data.IntelliSense.CslQueryIntelliSenseRulesProvider.ResolveResult.AppendEntities:b.v=System.Linq.Enumerable.from(b.v,System.String).union(S).toList(System.String)}K.MapOfKnownEntities.setItem(m,b.v),null!=l&&Kusto.Data.IntelliSense.CslCommand.IsMatchingRegex(l.Text,Kusto.Data.IntelliSense.CslCommand.s_hasAssignmentOperationRegex)&&K.MapOfPreviousCalculatedEntities.containsKey(m)&&(g=K.MapOfPreviousCalculatedEntities.getItem(m),Kusto.Cloud.Platform.Utils.ExtendedEnumerable.SafeFastAny$1(System.String,g)&&(h=i.GetTokenPositionsInRange(g,l.Start,l.End),System.Linq.Enumerable.from(h,Kusto.Data.IntelliSense.CslCommandIndexer.TokenPosition).any()&&this.AddCategorizedTokens(n,s,h,Kusto.Data.IntelliSense.CslCommandToken.Kind.CalculatedColumnToken))),K.MapOfPreviousCalculatedEntities.setItem(m,System.Linq.Enumerable.from(b.v,System.String).except(v.v).toList(System.String)),this.m_commandPartsParseStates.add(K)}},AddLetStatementTokens:function(e,t,n,s,i){var r=Kusto.Data.IntelliSense.CslQueryIntelliSenseRulesProvider.ResolveLetVariable(i.Text);System.String.isNullOrEmpty(r)||s.add(r),s.Count>0&&this.AddCategorizedTokens(e,t,n.GetTokenPositionsInRange(s,i.Start,i.End),Kusto.Data.IntelliSense.CslCommandToken.Kind.LetVariablesToken)},AddCategorizedTokens:function(e,t,n,s){null!=t&&t.AddRange(n),e.AddRange(System.Linq.Enumerable.from(n,Kusto.Data.IntelliSense.CslCommandIndexer.TokenPosition).select(Bridge.fn.bind(this,(function(e){var t;return(t=new Kusto.Data.IntelliSense.CslCommandToken(e.Text,this.RelativeStart,s)).Length=e.Length,t.RelativeStart=e.Start,t}))))},EnsureAllTextIsAnnotated:function(t,n,s){var i,r,a,o,l,u,d;if(null!=n){for(this.AddUnrecognizedTokens(t,n,s),n.Sort$2(e.$.Kusto.Data.IntelliSense.CslCommand.f12),i=0,r=n.Count,a=0;a<r;a=a+1|0)i<(o=n.getItem(a)).RelativeStart&&((l=o.RelativeStart-i|0)>0&&(u=this.Text.substr(i,l),this.AddPlainOrUnrecognizedTokens(n,i,u))),i=o.RelativeEnd;i<this.Length&&(d=this.Text.substr(i,this.Length-i|0),this.AddPlainOrUnrecognizedTokens(n,i,d))}},AddUnrecognizedTokens:function(e,t,n){var s,i,r=e.GetUnrecognizedTokenPositions(n);s=Bridge.getEnumerator(r,Kusto.Data.IntelliSense.CslCommandIndexer.TokenPosition);try{for(;s.moveNext();)i=s.Current,this.AddPlainOrUnrecognizedTokens(t,i.Start,i.Text)}finally{Bridge.is(s,System.IDisposable)&&s.System$IDisposable$Dispose()}},AddPlainOrUnrecognizedTokens:function(e,t,n){for(var s,i,r,a,o,l=System.String.toCharArray(n,0,n.length),u=-1,d=l.length,m=0;m<l.length;m=m+1|0)System.Char.isWhiteSpace(String.fromCharCode(l[System.Array.index(m,l)]))||(d=m+1|0,u=u>=0?u:m);u>0?(s=n.substr(0,u),(o=new Kusto.Data.IntelliSense.CslCommandToken(s,this.RelativeStart,Kusto.Data.IntelliSense.CslCommandToken.Kind.PlainTextToken)).Length=u,o.RelativeStart=t,i=o,e.add(i)):u=0;var c=n.substr(u,d-u|0),p=Kusto.Data.IntelliSense.CslCommand.StartsWithAlpha(c)?Kusto.Data.IntelliSense.CslCommandToken.Kind.UnknownToken:Kusto.Data.IntelliSense.CslCommandToken.Kind.PlainTextToken,S=((o=new Kusto.Data.IntelliSense.CslCommandToken(c,this.RelativeStart,p)).Length=c.length,o.RelativeStart=t+u|0,o);e.add(S),d<l.length&&(r=n.substr(d,l.length-d|0),(o=new Kusto.Data.IntelliSense.CslCommandToken(r,this.RelativeStart,Kusto.Data.IntelliSense.CslCommandToken.Kind.PlainTextToken)).Length=r.length,o.RelativeStart=t+d|0,a=o,e.add(a))}}}),Bridge.ns("Kusto.Data.IntelliSense.CslCommand",e.$),Bridge.apply(e.$.Kusto.Data.IntelliSense.CslCommand,{f1:function(e){return e.add("distinct"),e.add("extend"),e.add("project"),e.add("project-rename"),e.add("mvexpand"),e.add("mv-expand"),e.add("where"),e.add("filter"),e.add("parse"),e.add("limit"),e.add("count"),e.add("order"),e.add("sort"),e.add("reduce"),e.add("take"),e.add("summarize"),e.add("top"),e.add("top-nested"),e.add("top-hitters"),e.add("render"),e.add("fork"),e.add("find"),e.add("sample"),e.add("sample-distinct"),e.add("search"),e.add("make-series"),e},f2:function(e){return e.m_tokens},f3:function(e){return e.m_commandParts},f4:function(e){return e.m_commentsParts},f5:function(e){return e.m_clientDirectivesParts},f6:function(e){return e.m_bracketParts},f7:function(e){return e.Text},f8:function(e){return e.IsRunnable},f9:function(e){return e.AbsoluteStart},f10:function(e){return e.RelativeStart},f11:function(e){var t=Bridge.as(e.clone(),Kusto.Data.IntelliSense.CslCommandToken);return t.AbsolutePositionBias=this.RelativeStart,t},f12:function(e,t){return e.CompareTo(t)},f13:function(e){return e.Value}}),Bridge.define("Kusto.Data.IntelliSense.CslCommand.AddEntitiesTokensState",{$kind:"nested class",fields:{MapOfKnownEntities:null,MapOfPreviousCalculatedEntities:null,MapOfOriginallyKnownEntities:null},ctors:{init:function(){this.MapOfKnownEntities=new(System.Collections.Generic.Dictionary$2(Kusto.Data.IntelliSense.KustoCommandContext,System.Collections.Generic.List$1(System.String)).ctor),this.MapOfPreviousCalculatedEntities=new(System.Collections.Generic.Dictionary$2(Kusto.Data.IntelliSense.KustoCommandContext,System.Collections.Generic.List$1(System.String)).ctor),this.MapOfOriginallyKnownEntities=new(System.Collections.Generic.Dictionary$2(Kusto.Data.IntelliSense.KustoCommandContext,System.Collections.Generic.List$1(System.String)).ctor)}},methods:{Clone:function(){var e;return(e=new Kusto.Data.IntelliSense.CslCommand.AddEntitiesTokensState).MapOfKnownEntities=new(System.Collections.Generic.Dictionary$2(Kusto.Data.IntelliSense.KustoCommandContext,System.Collections.Generic.List$1(System.String)).$ctor1)(this.MapOfKnownEntities),e.MapOfOriginallyKnownEntities=new(System.Collections.Generic.Dictionary$2(Kusto.Data.IntelliSense.KustoCommandContext,System.Collections.Generic.List$1(System.String)).$ctor1)(this.MapOfOriginallyKnownEntities),e.MapOfPreviousCalculatedEntities=new(System.Collections.Generic.Dictionary$2(Kusto.Data.IntelliSense.KustoCommandContext,System.Collections.Generic.List$1(System.String)).$ctor1)(this.MapOfPreviousCalculatedEntities),e}}}),Bridge.define("Kusto.Data.IntelliSense.CslCommand.FormatTraits",{$kind:"nested enum",statics:{fields:{None:0,IncludeComments:1,TabulateOnJoins:2,TabulateOnFunctionBoundaries:4}},$flags:!0}),Bridge.define("Kusto.Data.IntelliSense.CslCommand.PrivateTracer",{$kind:"nested class",statics:{fields:{Tracer:null},ctors:{init:function(){this.Tracer=new Kusto.Data.IntelliSense.CslCommand.PrivateTracer}}},methods:{TraceVerbose:function(e,t){void 0===t&&(t=[])}}}),Bridge.define("Kusto.Data.IntelliSense.CslCommandIndexer",{statics:{fields:{MultiLineRegexOptions:0,SingleLineRegexOptions:0,s_defaultCommentRegex:null,s_defaultClientDirectivesRegex:null,s_defaultStringLiteralsRegex:null,s_defaultQueryParametersRegex:null,s_matchingBrackets:null},ctors:{init:function(){this.MultiLineRegexOptions=2,this.SingleLineRegexOptions=16,this.s_defaultCommentRegex=new System.Text.RegularExpressions.Regex.ctor("(^\\s*//.*?(\\n|$))",Kusto.Data.IntelliSense.CslCommandIndexer.MultiLineRegexOptions),this.s_defaultClientDirectivesRegex=new System.Text.RegularExpressions.Regex.ctor("(^\\s*#.*?(\\n|$))",Kusto.Data.IntelliSense.CslCommandIndexer.MultiLineRegexOptions),this.s_defaultStringLiteralsRegex=new System.Text.RegularExpressions.Regex.ctor("(@?'.*?\\'|@?\\\".*?\\\")",Kusto.Data.IntelliSense.CslCommandIndexer.MultiLineRegexOptions),this.s_defaultQueryParametersRegex=new System.Text.RegularExpressions.Regex.ctor("\\{([a-zA-Z]\\w+?)\\}",Kusto.Data.IntelliSense.CslCommandIndexer.MultiLineRegexOptions),this.s_matchingBrackets=e.$.Kusto.Data.IntelliSense.CslCommandIndexer.f1(new(System.Collections.Generic.Dictionary$2(System.Char,System.Char).ctor))}},methods:{AddToCollection:function(e,t,n,s,i){var r,a,o={},l=System.Array.init([10,13],System.Char),u=((r=new Kusto.Data.IntelliSense.CslCommandIndexer.TokenPosition).Start=n,r.End=Kusto.Data.IntelliSense.CslCommandIndexer.ReadTill(t,s+1|0,l,null,o),r);return u.End>u.Start&&(o.v&&(u.End=u.End-1|0),a=1+(u.End-u.Start|0)|0,u.Text=e.substr(u.Start,a),i.add(u)),u.End},ReadTill:function(e,t,n,s,i){i.v=!0;for(var r=new(System.Collections.Generic.HashSet$1(System.Char).ctor);t<e.length;t=t+1|0){if(System.Linq.Enumerable.from(r,System.Char).any()){if(System.Array.contains(n,e[System.Array.index(t,e)],System.Char)&&!r.contains(e[System.Array.index(t,e)])){r.add(e[System.Array.index(t,e)]);continue}i.v=!1,t=t-1|0;break}System.Array.contains(n,e[System.Array.index(t,e)],System.Char)?r.add(e[System.Array.index(t,e)]):null!=s&&System.Linq.Enumerable.from(s,System.Char).any((function(n){return e[System.Array.index(t,e)]===n}))&&(t=t+1|0)}return t>e.length?e.length:t},ReadVerbatimTill:function(e,t,n,s){s.v=!0;for(var i=0;t<e.length;t=t+1|0)if(System.Array.contains(n,e[System.Array.index(t,e)],System.Char)&&((i=i+1|0)%2!=0&&t<(e.length-1|0)&&!System.Array.contains(n,e[System.Array.index(t+1|0,e)],System.Char))){s.v=!1;break}return t},CaptureTokensUsingRegex:function(e,t,n){var s,i,r,a,o,l,u,d;if(!Kusto.Cloud.Platform.Utils.ExtendedEnumerable.SafeFastNone$1(System.Text.RegularExpressions.Regex,t)){s=Bridge.getEnumerator(t);try{for(;s.moveNext();){o=s.Current.matches(e),i=Bridge.getEnumerator(o);try{for(;i.moveNext();){l=Bridge.cast(i.Current,System.Text.RegularExpressions.Match),r=Bridge.getEnumerator(l.getCaptures());try{for(;r.moveNext();)u=Bridge.cast(r.Current,System.Text.RegularExpressions.Capture),(a=new Kusto.Data.IntelliSense.CslCommandIndexer.TokenPosition).Start=u.getIndex(),a.End=(u.getIndex()+u.getLength()|0)-1|0,a.Text=u.getValue(),d=a,n.add(d)}finally{Bridge.is(r,System.IDisposable)&&r.System$IDisposable$Dispose()}}}finally{Bridge.is(i,System.IDisposable)&&i.System$IDisposable$Dispose()}}}finally{Bridge.is(s,System.IDisposable)&&s.System$IDisposable$Dispose()}}}}},fields:{m_tokensAndPositions:null,m_commentTokenPositions:null,m_clientDirectivesTokenPositions:null,m_stringLiteralsPositions:null,m_queryParametersPositions:null,m_commandPartsPositions:null,m_bracketPartsPositions:null,m_sourceText:null,m_commentRegexCollection:null,m_clientDirectivesRegexCollection:null,m_stringLiteralsRegexCollection:null,m_queryParametersRegexCollection:null},props:{AntiTokenizers:null,TokenTerminators:null,TokenStarters:null},ctors:{init:function(){this.m_tokensAndPositions=new(System.Collections.Generic.Dictionary$2(System.String,System.Collections.Generic.List$1(Kusto.Data.IntelliSense.CslCommandIndexer.TokenPosition)).ctor),this.m_commentTokenPositions=new(System.Collections.Generic.List$1(Kusto.Data.IntelliSense.CslCommandIndexer.TokenPosition).ctor),this.m_clientDirectivesTokenPositions=new(System.Collections.Generic.List$1(Kusto.Data.IntelliSense.CslCommandIndexer.TokenPosition).ctor),this.m_stringLiteralsPositions=new(System.Collections.Generic.List$1(Kusto.Data.IntelliSense.CslCommandIndexer.TokenPosition).ctor),this.m_queryParametersPositions=new(System.Collections.Generic.List$1(Kusto.Data.IntelliSense.CslCommandIndexer.TokenPosition).ctor),this.m_commandPartsPositions=new(System.Collections.Generic.List$1(Kusto.Data.IntelliSense.CslCommandIndexer.TokenPosition).ctor),this.m_bracketPartsPositions=new(System.Collections.Generic.List$1(Kusto.Data.IntelliSense.CslCommandIndexer.TokenPosition).ctor),this.m_commentRegexCollection=new(System.Collections.Generic.List$1(System.Text.RegularExpressions.Regex).ctor),this.m_clientDirectivesRegexCollection=new(System.Collections.Generic.List$1(System.Text.RegularExpressions.Regex).ctor),this.m_stringLiteralsRegexCollection=new(System.Collections.Generic.List$1(System.Text.RegularExpressions.Regex).ctor),this.m_queryParametersRegexCollection=new(System.Collections.Generic.List$1(System.Text.RegularExpressions.Regex).ctor)},ctor:function(e){this.$initialize(),this.m_commentRegexCollection.add(Kusto.Data.IntelliSense.CslCommandIndexer.s_defaultCommentRegex),this.m_clientDirectivesRegexCollection.add(Kusto.Data.IntelliSense.CslCommandIndexer.s_defaultClientDirectivesRegex),this.m_stringLiteralsRegexCollection.add(Kusto.Data.IntelliSense.CslCommandIndexer.s_defaultStringLiteralsRegex),e&&this.m_queryParametersRegexCollection.add(Kusto.Data.IntelliSense.CslCommandIndexer.s_defaultQueryParametersRegex)}},methods:{IndexText:function(e){var t,n,s,i,r,a,o,l;this.m_tokensAndPositions.clear(),this.m_sourceText=e,n=System.String.toCharArray(e,0,e.length),this.DetectCommentsAndStringLiterals(e);var u=this.GetTokenLookupSkipRanges(e.length),d=Kusto.Data.IntelliSense.CslCommandIndexer.State.LookingForTokenStart,m=null,c=null,p=null,S=new(System.Collections.Generic.Stack$1(System.Tuple$2(System.Char,System.Int32)).ctor);for(s=0;s<n.length;s=s+1|0){var g=u[System.Array.index(s,u)],h=System.Linq.Enumerable.from(this.m_commentTokenPositions,Kusto.Data.IntelliSense.CslCommandIndexer.TokenPosition).where((function(e){return s>=e.Start&&s<=e.End})).any(),y=n[System.Array.index(s,n)],f=0===s||System.Char.isWhiteSpace(String.fromCharCode(n[System.Array.index(s-1|0,n)])),I=!0;switch(null!=p&&((124===y||59===y)&&!g||h||s===(n.length-1|0))&&(s===(n.length-1|0)||59===y?(p.End=s,I=!1):p.End=s-1|0,(i=1+(p.End-p.Start|0)|0)>1&&(r=e.substr(p.Start,i),p.Text=r,System.String.equals(r,"\n")||System.String.isNullOrWhiteSpace(r)||this.m_commandPartsPositions.add(p)),p=null),null==p&&!h&&I&&((t=new Kusto.Data.IntelliSense.CslCommandIndexer.TokenPosition).Start=s,t.End=s,p=t),g||System.Linq.Enumerable.from(Kusto.Data.IntelliSense.CslCommandIndexer.s_matchingBrackets.Keys,System.Char).contains(y)&&(System.Linq.Enumerable.from(S,System.Tuple$2(System.Char,System.Int32)).any()&&S.Peek().Item1===y?(a=S.Pop(),(t=new Kusto.Data.IntelliSense.CslCommandIndexer.TokenPosition).Start=a.Item2,t.End=s,(o=t).Text=e.substr(o.Start,1+(o.End-o.Start|0)|0),this.m_bracketPartsPositions.add(o)):S.Push({Item1:Kusto.Data.IntelliSense.CslCommandIndexer.s_matchingBrackets.getItem(y),Item2:s})),d){case Kusto.Data.IntelliSense.CslCommandIndexer.State.LookingForTokenStart:!g&&(this.IsPartOfTheToken(y)&&!this.IsTokenTerminator(y)||f&&this.IsTokenStarter(y))&&(m=new System.Text.StringBuilder,(t=new Kusto.Data.IntelliSense.CslCommandIndexer.TokenPosition).Start=s,t.End=s,c=t,m.append(String.fromCharCode(y)),d=Kusto.Data.IntelliSense.CslCommandIndexer.State.LookingForTokenEnd);break;case Kusto.Data.IntelliSense.CslCommandIndexer.State.LookingForTokenEnd:l=!1,!g&&this.IsPartOfTheToken(y)?this.IsTokenTerminator(y)?(c.TokenTerminator=y,l=!0):(m.append(String.fromCharCode(y)),c.End=s):l=!0,(l||s===(n.length-1|0))&&(c.Text=m.toString(),this.AddTokenPosition(c),d=Kusto.Data.IntelliSense.CslCommandIndexer.State.LookingForTokenStart)}}},GetTokenLookupSkipRanges:function(t){var n,s=new(System.Collections.Generic.List$1(System.Tuple$2(System.Int32,System.Int32)).ctor);s.AddRange(System.Linq.Enumerable.from(this.m_stringLiteralsPositions,Kusto.Data.IntelliSense.CslCommandIndexer.TokenPosition).select(e.$.Kusto.Data.IntelliSense.CslCommandIndexer.f2)),s.AddRange(System.Linq.Enumerable.from(this.m_commentTokenPositions,Kusto.Data.IntelliSense.CslCommandIndexer.TokenPosition).select(e.$.Kusto.Data.IntelliSense.CslCommandIndexer.f2)),s.AddRange(System.Linq.Enumerable.from(this.m_clientDirectivesTokenPositions,Kusto.Data.IntelliSense.CslCommandIndexer.TokenPosition).select(e.$.Kusto.Data.IntelliSense.CslCommandIndexer.f2)),s.AddRange(System.Linq.Enumerable.from(this.m_queryParametersPositions,Kusto.Data.IntelliSense.CslCommandIndexer.TokenPosition).select(e.$.Kusto.Data.IntelliSense.CslCommandIndexer.f2)),s.Sort$2(e.$.Kusto.Data.IntelliSense.CslCommandIndexer.f3);var i=0,r=System.Linq.Enumerable.from(s,System.Tuple$2(System.Int32,System.Int32)).firstOrDefault(null,null),a=System.Array.init(t,!1,System.Boolean);for(n=0;n<t&&null!=r;n=n+1|0)n>=r.Item1&&(a[System.Array.index(n,a)]=!0),r.Item2===n&&(r=System.Linq.Enumerable.from(s,System.Tuple$2(System.Int32,System.Int32)).elementAtOrDefault(i=i+1|0,null));return a},GetCommandPartsPositions:function(){return this.m_commandPartsPositions},GetCommentsPositions:function(){return this.m_commentTokenPositions},GetClientDirectivesPositions:function(){return this.m_clientDirectivesTokenPositions},GetStringLiteralsPositions:function(){return this.m_stringLiteralsPositions},GetQueryParametersPositions:function(){return this.m_queryParametersPositions},GetBracketsPositions:function(){return this.m_bracketPartsPositions},GetUnrecognizedTokenPositions:function(t){return System.Linq.Enumerable.from(this.m_tokensAndPositions.Values,System.Collections.Generic.List$1(Kusto.Data.IntelliSense.CslCommandIndexer.TokenPosition)).selectMany(e.$.Kusto.Data.IntelliSense.CslCommandIndexer.f4).except(t)},GetTokenPositionsInRange:function(e,t,n){var s,i,r,a=new(System.Collections.Generic.List$1(Kusto.Data.IntelliSense.CslCommandIndexer.TokenPosition).ctor);if(Kusto.Cloud.Platform.Utils.ExtendedEnumerable.SafeFastNone$2(System.String,e))return a;s=Bridge.getEnumerator(e,System.String);try{for(;s.moveNext();)i=s.Current,System.String.isNullOrEmpty(i)||this.m_tokensAndPositions.containsKey(i)&&(r=System.Linq.Enumerable.from(this.m_tokensAndPositions.getItem(i),Kusto.Data.IntelliSense.CslCommandIndexer.TokenPosition).where((function(e){return e.Start>=t&&e.End<=n})),Kusto.Cloud.Platform.Utils.ExtendedEnumerable.SafeFastAny$2(Kusto.Data.IntelliSense.CslCommandIndexer.TokenPosition,r)&&a.AddRange(r))}finally{Bridge.is(s,System.IDisposable)&&s.System$IDisposable$Dispose()}return a},GetAllTokensSortedByPosition:function(){return Kusto.Cloud.Platform.Utils.ExtendedEnumerable.SafeFastNone$1(System.Collections.Generic.KeyValuePair$2(System.String,System.Collections.Generic.List$1(Kusto.Data.IntelliSense.CslCommandIndexer.TokenPosition)),this.m_tokensAndPositions)?null:System.Linq.Enumerable.from(this.m_tokensAndPositions,System.Collections.Generic.KeyValuePair$2(System.String,System.Collections.Generic.List$1(Kusto.Data.IntelliSense.CslCommandIndexer.TokenPosition))).selectMany(e.$.Kusto.Data.IntelliSense.CslCommandIndexer.f5).orderBy(e.$.Kusto.Data.IntelliSense.CslCommandIndexer.f6)},GetAllTokenPositions:function(e,t){var n,s,i;if(void 0===t&&(t=0),s=new(System.Collections.Generic.List$1(Kusto.Data.IntelliSense.CslCommandIndexer.TokenPosition).ctor),Kusto.Cloud.Platform.Utils.ExtendedEnumerable.SafeFastNone$2(System.String,e))return s;n=Bridge.getEnumerator(e,System.String);try{for(;n.moveNext();)i=n.Current,this.m_tokensAndPositions.containsKey(i)&&s.AddRange(System.Linq.Enumerable.from(this.m_tokensAndPositions.getItem(i),Kusto.Data.IntelliSense.CslCommandIndexer.TokenPosition).where((function(e){return e.TokenTerminator===t})))}finally{Bridge.is(n,System.IDisposable)&&n.System$IDisposable$Dispose()}return s},IsPartOfTheToken:function(e){return System.Char.isDigit(e)||System.Char.isLetter(e)||null!=this.AntiTokenizers&&this.AntiTokenizers.contains(e)},IsTokenTerminator:function(e){return null!=this.TokenTerminators&&this.TokenTerminators.contains(e)},IsTokenStarter:function(e){return null!=this.TokenStarters&&System.Array.contains(this.TokenStarters,e,System.Char)},DetectCommentsAndStringLiterals:function(e){Kusto.Data.IntelliSense.CslCommandIndexer.CaptureTokensUsingRegex(e,this.m_queryParametersRegexCollection,this.m_queryParametersPositions),Kusto.Cloud.Platform.Utils.ExtendedEnumerable.None(Kusto.Data.IntelliSense.CslCommandIndexer.TokenPosition,this.m_queryParametersPositions)?this.DetectCommentsAndStringLiterals_Simple(e):this.DetectCommentsAndStringLiterals_Complex(e)},DetectCommentsAndStringLiterals_Simple:function(e){for(var t,n=System.String.toCharArray(e,0,e.length),s=0,i=0;i<n.length;i=i+1|0)switch(t=n[System.Array.index(i,n)],s){case 0:64===t?s=1:39===t||34===t?i=this.AddStringLiteralToken(e,n,i,i,t,!1):47===t?s=2:35===t&&(i=this.AddClientDirectiveToken(e,n,i,i),s=0);break;case 1:(39===t||34===t)&&(i=this.AddStringLiteralToken(e,n,i-1|0,i,t,!0)),s=0;break;case 2:47===t&&(i=this.AddCommentToken(e,n,i-1|0,i)),s=0}},AddCommentToken:function(e,t,n,s){return Kusto.Data.IntelliSense.CslCommandIndexer.AddToCollection(e,t,n,s,this.m_commentTokenPositions)},AddClientDirectiveToken:function(e,t,n,s){return Kusto.Data.IntelliSense.CslCommandIndexer.AddToCollection(e,t,n,s,this.m_clientDirectivesTokenPositions)},AddStringLiteralToken:function(e,t,n,s,i,r){var a,o,l={},u=((a=new Kusto.Data.IntelliSense.CslCommandIndexer.TokenPosition).Start=n,a.End=r?Kusto.Data.IntelliSense.CslCommandIndexer.ReadVerbatimTill(t,s+1|0,System.Array.init([i],System.Char),l):Kusto.Data.IntelliSense.CslCommandIndexer.ReadTill(t,s+1|0,System.Array.init([i],System.Char),System.Array.init([92],System.Char),l),a);return u.End>u.Start&&(l.v&&(u.End=u.End-1|0),o=1+(u.End-u.Start|0)|0,u.Text=e.substr(u.Start,o),this.m_stringLiteralsPositions.add(u)),u.End},DetectCommentsAndStringLiterals_Complex:function(e){var t,n,s,i,r,a,o,l,u;for(Kusto.Data.IntelliSense.CslCommandIndexer.CaptureTokensUsingRegex(e,this.m_commentRegexCollection,this.m_commentTokenPositions),Kusto.Data.IntelliSense.CslCommandIndexer.CaptureTokensUsingRegex(e,this.m_clientDirectivesRegexCollection,this.m_clientDirectivesTokenPositions),n=this.m_queryParametersPositions.Count-1|0;n>=0;n=n-1|0)s={v:this.m_queryParametersPositions.getItem(n)},System.Linq.Enumerable.from(this.m_commentTokenPositions,Kusto.Data.IntelliSense.CslCommandIndexer.TokenPosition).where(function(e,t){return function(e){return e.Start<=t.v.Start&&e.End>=t.v.End}}(0,s)).any()&&this.m_queryParametersPositions.removeAt(n);for(Kusto.Data.IntelliSense.CslCommandIndexer.CaptureTokensUsingRegex(e,this.m_stringLiteralsRegexCollection,this.m_stringLiteralsPositions),i=this.m_stringLiteralsPositions.Count-1|0;i>=0;i=i-1|0)r={v:this.m_stringLiteralsPositions.getItem(i)},System.Linq.Enumerable.from(this.m_commentTokenPositions,Kusto.Data.IntelliSense.CslCommandIndexer.TokenPosition).where(function(e,t){return function(e){return e.Start<=t.v.Start&&e.End>=t.v.End}}(0,r)).any()&&this.m_stringLiteralsPositions.removeAt(i);for(a=this.m_queryParametersPositions.Count-1|0;a>=0;a=a-1|0)o={v:this.m_queryParametersPositions.getItem(a)},l=System.Linq.Enumerable.from(this.m_stringLiteralsPositions,Kusto.Data.IntelliSense.CslCommandIndexer.TokenPosition).where(function(e,t){return function(e){return e.Start<=t.v.Start&&e.End>=t.v.End}}(0,o)).firstOrDefault(null,null),null!=l&&((t=new Kusto.Data.IntelliSense.CslCommandIndexer.TokenPosition).Start=o.v.End+1|0,t.End=l.End,t.Text=l.Text.substr(1+(o.v.End-l.Start|0)|0),u=t,l.End=o.v.Start-1|0,l.Text=l.Text.substr(0,l.Length),this.m_stringLiteralsPositions.add(u))},AddTokenPosition:function(e){this.m_tokensAndPositions.containsKey(e.Text)||this.m_tokensAndPositions.add(e.Text,new(System.Collections.Generic.List$1(Kusto.Data.IntelliSense.CslCommandIndexer.TokenPosition).ctor)),this.m_tokensAndPositions.getItem(e.Text).add(e)}}}),Bridge.ns("Kusto.Data.IntelliSense.CslCommandIndexer",e.$),Bridge.apply(e.$.Kusto.Data.IntelliSense.CslCommandIndexer,{f1:function(e){return e.add(40,41),e.add(41,40),e.add(91,93),e.add(93,91),e.add(123,125),e.add(125,123),e},f2:function(e){return{Item1:e.Start,Item2:e.End}},f3:function(e,t){return Bridge.compare(e.Item1,t.Item1)},f4:function(e){return e},f5:function(e){return e.value},f6:function(e){return e.Start}}),Bridge.define("Kusto.Data.IntelliSense.CslCommandIndexer.State",{$kind:"nested enum",statics:{fields:{LookingForTokenStart:0,LookingForTokenEnd:1,InsideComment:2,InsideStringLiteral:3}}}),Bridge.define("Kusto.Data.IntelliSense.CslCommandIndexer.TokenPosition",{$kind:"nested class",props:{Text:null,Start:0,End:0,TokenTerminator:0,Length:{get:function(){return 1+(this.End-this.Start|0)|0}}},ctors:{ctor:function(){this.$initialize(),this.TokenTerminator=0}}}),Bridge.define("Kusto.Data.IntelliSense.CslCommandParser",{statics:{fields:{ControlCommandsTokens:null,CslCommandsTokens:null,ChartRenderTypesTokens:null,ChartRenderKindTokens:null,SubOperatorsTokens:null,JoinKindTokens:null,ReduceByKindTokens:null,DataTypesTokens:null,ScalarFunctionsDateTimeTokens:null,ScalarFunctionsNoDateTimeTokens:null,SingleParameterFunctionsDateTimeTokens:null,ZeroParameterFunctionsNoDateTimeTokens:null,SingleParameterFunctionsNoDateTimeTokens:null,IntrinsicFunctionTokens:null,TwoParameterFunctionsTokens:null,ThreeParameterFunctionsTokens:null,ManyParametersFunctionsTokens:null,PromotedOperatorCommandTokens:null,ClientDirectiveTokens:null,OperatorCommandTokens:null,DataOperatorTokens:null,SummarizeAggregationSingleParameterTokens:null,SummarizeAggregationTwoParametersTokens:null,SummarizeAggregationThreeParametersTokens:null,SummarizeAggregationManyParametersTokens:null,MakeSeriesAggregationTokens:null,PluginTokens:null,DatetimeFunctionsTokens:null,ScalarFunctionsTokens:null,SingleParameterFunctionsTokens:null,SummarizeAggregationTokens:null,SummarizeAggregationAliasesTokens:null,SortedSummarizeAggregators:null,SortedMakeSeriesAggregationTokens:null,SortedDatetimeFunctions:null,SortedExtendFunctions:null,FunctionsTokens:null,SortedEvaluateFunctions:null,s_asyncSeeker:null,s_isCommentLineRegex:null},ctors:{init:function(){this.ControlCommandsTokens=System.Array.init([".add",".alter",".alter-merge",".attach",".append",".create",".create-merge",".create-set",".create-or-alter",".define",".detach",".delete",".drop",".drop-pretend",".dup-next-ingest",".dup-next-failed-ingest",".ingest",".export",".load",".move",".purge",".purge-cleanup",".remove",".replace",".save",".set",".set-or-append",".set-or-replace",".show",".rename",".run","async","data","into","ifnotexists","whatif","compressed","monitoring","metadata","folder","docstring","details","hot","records","until","as","csv","tsv","json","sql","policy","encoding","retention","merge","policies","update","ingestiontime","caching","querythrottling","sharding","callout","querylimit","restricted_view_access","ingestionbatching","query_weak_consistency","partitioning","softdelete","harddelete","rowstore","rowstores","seal","writeaheadlog","streamingingestion","rowstore_references","follower"],System.String),this.CslCommandsTokens=System.Array.init(["set","let","restrict","access","alias","pattern","declare","query_parameters"],System.String),this.ChartRenderTypesTokens=System.Linq.Enumerable.from(System.Array.init(["columnchart","barchart","piechart","timechart","anomalychart","linechart","ladderchart","pivotchart","areachart","stackedareachart","scatterchart","timepivot","timeline","card","table","list"],System.String),System.String).orderBy(e.$.Kusto.Data.IntelliSense.CslCommandParser.f1).ToArray(System.String),this.ChartRenderKindTokens=System.Array.init(["default","stacked","stacked100","unstacked","map"],System.String),this.SubOperatorsTokens=System.Linq.Enumerable.from(System.Array.init(["like","notlike","contains","notcontains","!contains","contains_cs","!contains_cs","startswith","!startswith","has","!has","has_cs","!has_cs","hasprefix","!hasprefix","hassuffix","!hassuffix","matches","regex","in","!in","endswith","!endswith","between","!between","extent","database","diagnostics","jitmanagers","admins","basicauth","cache","capacity","cluster","continuous-export","continuous-exports","databases","extents","external","journal","memory","extentcontainers","viewers","unrestrictedviewers","tags","prettyname","blockedprincipals","failed","operations","password","principal","principals","settings","schema","table","tables","user","users","ingestors","monitors","version","roles","fabric","locks","service","services","nodes","unallocated","subscriptions","nonregistered","packages","configuration","commands","commands-and-queries","queries","query","function","functions","by","on","of","true","false","and","or","asc","desc","nulls","last","first","with","withsource","kind","flags","from","to","step","ingestion","failures","mapping","mappings","geneva","eventhub","source","sources","types","application","period","reason","title"],System.String),System.String).union(Kusto.Data.IntelliSense.CslCommandParser.ChartRenderTypesTokens).union(Kusto.Data.IntelliSense.CslCommandParser.ChartRenderKindTokens).distinct().ToArray(System.String),this.JoinKindTokens=System.Array.init(["anti","inner","innerunique","fullouter","leftanti","leftantisemi","leftouter","leftsemi","rightanti","rightantisemi","rightsemi","rightouter"],System.String),this.ReduceByKindTokens=System.Array.init(["mining"],System.String),this.DataTypesTokens=System.Array.init(["timespan","datetime","int","long","real","string","bool","double","dynamic","decimal","guid"],System.String),this.ScalarFunctionsDateTimeTokens=System.Array.init(["now","ago","datetime","ingestion_time"],System.String),this.ScalarFunctionsNoDateTimeTokens=System.Array.init(["time","timespan","dynamic","decimal"],System.String),this.SingleParameterFunctionsDateTimeTokens=System.Array.init(["todatetime","between","!between"],System.String),this.ZeroParameterFunctionsNoDateTimeTokens=System.Array.init(["row_number","extent_id","extent_tags","pi","pack_all","rowstore_ordinal_range"],System.String),this.SingleParameterFunctionsNoDateTimeTokens=System.Array.init(["strlen","tostring","toupper","tolower","typeof","reverse","parsejson","parse_json","parse_xml","parse_csv","tobool","toboolean","todynamic","toobject","toint","tolong","toguid","todouble","toreal","totimespan","tohex","todecimal","isempty","isnotempty","isnull","isnotnull","isnan","isinf","isfinite","dayofweek","dayofmonth","dayofyear","week_of_year","monthofyear","sqrt","rand","log","log10","log2","exp","exp2","exp10","abs","degrees","radians","sign","sin","cos","tan","asin","acos","atan","cot","getmonth","getyear","array_length","gettype","bag_keys","cursor_after","gamma","loggamma","dcount_hll","parse_ipv4","parse_url","parse_path","parse_version","parse_urlquery","url_encode","url_decode","binary_not","not","toscalar","materialize","series_stats","series_fit_line","series_fit_2lines","series_stats_dynamic","series_fit_line_dynamic","series_fit_2lines_dynamic","base64_encodestring","base64_decodestring","hash_sha256","ceiling","string_size","isascii","isutf8","geo_geohash_to_central_point"],System.String),this.IntrinsicFunctionTokens=System.Array.init(["cluster","database","table"],System.String),this.TwoParameterFunctionsTokens=System.Array.init(["bin","columnifexists","floor","countof","hash","round","pow","binary_and","binary_or","binary_xor","binary_shift_left","binary_shift_right","datepart","datetime_part","repeat","series_seasonal","series_outliers","array_split","series_add","series_subtract","series_multiply","series_divide","series_pearson_correlation","series_greater","series_greater_equals","series_less","series_less_equals","series_equals","series_not_equals","rank_tdigest","percentrank_tdigest","trim","trim_start","trim_end","startofday","startofweek","startofmonth","startofyear","endofday","endofweek","endofmonth","endofyear","series_fill_backward","series_fill_forward","atan2","format_datetime","format_timespan","strrep","strcat_array","parse_user_agent","strcmp","row_cumsum"],System.String),this.ThreeParameterFunctionsTokens=System.Array.init(["iff","iif","range","replace","translate","series_iir","bin_at","series_fill_const","series_decompose","series_decompose_forecast","series_decompose_anomalies","datetime_diff","datetime_add","geo_point_to_geohash","geo_point_in_polygon"],System.String),this.ManyParametersFunctionsTokens=System.Array.init(["extract","extractjson","extractall","strcat","strcat_delim","substring","indexof","split","case","coalesce","max_of","min_of","percentile_tdigest","zip","pack","pack_dictionary","pack_array","array_concat","array_slice","welch_test","row_window_session","series_fir","series_periods_detect","prev","next","tdigest_merge","hll_merge","series_fill_linear","series_periods_validate","datatable","make_datetime","make_timespan","make_string","geo_distance_2points","geo_point_in_circle"],System.String),this.PromotedOperatorCommandTokens=System.Array.init(["where","count","extend","join","limit","order","project","project-away","project-rename","project-reorder","render","sort","summarize","distinct","take","top","top-nested","top-hitters","union","mv-expand","mv-apply","reduce","evaluate","parse","parse-where","sample","sample-distinct","make-series","getschema","serialize","invoke","as"],System.String),this.ClientDirectiveTokens=System.Array.init(["connect"],System.String),this.OperatorCommandTokens=System.Linq.Enumerable.from(System.Array.init(["filter","fork","facet","range","consume","find","search","print","partition","lookup"],System.String),System.String).union(Kusto.Data.IntelliSense.CslCommandParser.PromotedOperatorCommandTokens).ToArray(System.String),this.DataOperatorTokens=System.Array.init(["datatable","externaldata"],System.String),this.SummarizeAggregationSingleParameterTokens=System.Array.init(["count","countif","dcount","dcountif","sum","min","max","avg","avgif","any","makelist","makeset","make_dictionary","stdev","stdevif","varianceif","variance","buildschema","hll","hll_merge","tdigest","tdigest_merge"],System.String),this.SummarizeAggregationTwoParametersTokens=System.Array.init(["percentile","sumif"],System.String),this.SummarizeAggregationThreeParametersTokens=System.Array.init(["percentilew"],System.String),this.SummarizeAggregationManyParametersTokens=System.Array.init(["arg_min","arg_max","percentilesw_array","percentilesw","percentiles_array","percentiles"],System.String),this.MakeSeriesAggregationTokens=System.Array.init(["count","countif","dcount","dcountif","sum","min","max","avg","any","stdev","stdevp","variance","variancep","sumif"],System.String),this.PluginTokens=System.Array.init(["autocluster","diffpatterns","basket","extractcolumns"],System.String),this.DatetimeFunctionsTokens=System.Linq.Enumerable.from(Kusto.Data.IntelliSense.CslCommandParser.ScalarFunctionsDateTimeTokens,System.String).union(Kusto.Data.IntelliSense.CslCommandParser.SingleParameterFunctionsDateTimeTokens).ToArray(System.String),this.ScalarFunctionsTokens=System.Linq.Enumerable.from(Kusto.Data.IntelliSense.CslCommandParser.ScalarFunctionsDateTimeTokens,System.String).union(Kusto.Data.IntelliSense.CslCommandParser.ScalarFunctionsNoDateTimeTokens).ToArray(System.String),this.SingleParameterFunctionsTokens=System.Linq.Enumerable.from(Kusto.Data.IntelliSense.CslCommandParser.SingleParameterFunctionsDateTimeTokens,System.String).union(Kusto.Data.IntelliSense.CslCommandParser.SingleParameterFunctionsNoDateTimeTokens).ToArray(System.String),this.SummarizeAggregationTokens=System.Linq.Enumerable.from(Kusto.Data.IntelliSense.CslCommandParser.SummarizeAggregationSingleParameterTokens,System.String).union(Kusto.Data.IntelliSense.CslCommandParser.SummarizeAggregationManyParametersTokens).union(Kusto.Data.IntelliSense.CslCommandParser.SummarizeAggregationThreeParametersTokens).union(Kusto.Data.IntelliSense.CslCommandParser.SummarizeAggregationTwoParametersTokens).ToArray(System.String),this.SummarizeAggregationAliasesTokens=System.Array.init(["argmax","argmin"],System.String),this.SortedSummarizeAggregators=System.Linq.Enumerable.from(Kusto.Data.IntelliSense.CslCommandParser.SummarizeAggregationTokens,System.String).orderBy(e.$.Kusto.Data.IntelliSense.CslCommandParser.f2).select(e.$.Kusto.Data.IntelliSense.CslCommandParser.f3).ToArray(System.String),this.SortedMakeSeriesAggregationTokens=System.Linq.Enumerable.from(Kusto.Data.IntelliSense.CslCommandParser.MakeSeriesAggregationTokens,System.String).orderBy(e.$.Kusto.Data.IntelliSense.CslCommandParser.f2).select(e.$.Kusto.Data.IntelliSense.CslCommandParser.f3).ToArray(System.String),this.SortedDatetimeFunctions=System.Linq.Enumerable.from(Kusto.Data.IntelliSense.CslCommandParser.DatetimeFunctionsTokens,System.String).orderBy(e.$.Kusto.Data.IntelliSense.CslCommandParser.f2).select(e.$.Kusto.Data.IntelliSense.CslCommandParser.f3).ToArray(System.String),this.SortedExtendFunctions=System.Linq.Enumerable.from(Kusto.Data.IntelliSense.CslCommandParser.ManyParametersFunctionsTokens,System.String).union(Kusto.Data.IntelliSense.CslCommandParser.ScalarFunctionsTokens).union(Kusto.Data.IntelliSense.CslCommandParser.ZeroParameterFunctionsNoDateTimeTokens).union(Kusto.Data.IntelliSense.CslCommandParser.SingleParameterFunctionsTokens).union(Kusto.Data.IntelliSense.CslCommandParser.TwoParameterFunctionsTokens).union(Kusto.Data.IntelliSense.CslCommandParser.ThreeParameterFunctionsTokens).orderBy(e.$.Kusto.Data.IntelliSense.CslCommandParser.f2).select(e.$.Kusto.Data.IntelliSense.CslCommandParser.f3).ToArray(System.String),this.FunctionsTokens=System.Linq.Enumerable.from(Kusto.Data.IntelliSense.CslCommandParser.ManyParametersFunctionsTokens,System.String).union(Kusto.Data.IntelliSense.CslCommandParser.ScalarFunctionsTokens).union(Kusto.Data.IntelliSense.CslCommandParser.ZeroParameterFunctionsNoDateTimeTokens).union(Kusto.Data.IntelliSense.CslCommandParser.SingleParameterFunctionsTokens).union(Kusto.Data.IntelliSense.CslCommandParser.TwoParameterFunctionsTokens).union(Kusto.Data.IntelliSense.CslCommandParser.ThreeParameterFunctionsTokens).union(Kusto.Data.IntelliSense.CslCommandParser.SummarizeAggregationTokens).union(Kusto.Data.IntelliSense.CslCommandParser.IntrinsicFunctionTokens).ToArray(System.String),this.SortedEvaluateFunctions=System.Linq.Enumerable.from(Kusto.Data.IntelliSense.CslCommandParser.PluginTokens,System.String).orderBy(e.$.Kusto.Data.IntelliSense.CslCommandParser.f2).ToArray(System.String),this.s_asyncSeeker=new System.Text.RegularExpressions.Regex.ctor("^\\.[\\w\\-]+\\s+async",Kusto.Data.IntelliSense.IntelliSenseRulesProviderBase.DefaultRegexOptions),this.s_isCommentLineRegex=new System.Text.RegularExpressions.Regex.ctor("^\\s*//",Kusto.Data.IntelliSense.IntelliSenseRulesProviderBase.DefaultRegexOptions)}},methods:{IsAdminCommand$1:function(e,t){return Kusto.Data.IntelliSense.CslCommandParser.IsStartingWithPrefix(e,".",t)},IsAdminCommand:function(e){return Kusto.Data.IntelliSense.CslCommandParser.IsAdminCommand$1(e,{})},ResolveRequestApiKind:function(e){var t={};return Kusto.Data.IntelliSense.CslCommandParser.IsStartingWithPrefix(e,".",t)?Kusto.Data.IntelliSense.CslCommandParser.s_asyncSeeker.isMatch(t.v)?Kusto.Data.IntelliSense.ApiKind.AdminAsyncCommand:Kusto.Data.IntelliSense.ApiKind.AdminSyncCommand:Kusto.Data.IntelliSense.ApiKind.Query},IsStartingWithPrefix:function(e,t,n){var s,i,r;for(n.v=e.trim(),s=System.String.split(e,System.Array.init([13,10],System.Char).map((function(e){return String.fromCharCode(e)})),null,1),i=0;i<s.length;i=i+1|0){if(r=s[System.Array.index(i,s)],System.String.startsWith(System.String.trimStart(r),t))return i>0&&(n.v=Bridge.toArray(System.Linq.Enumerable.from(s,System.String).skip(i)).join("\n").trim()),!0;if(!Kusto.Data.IntelliSense.CslCommandParser.s_isCommentLineRegex.isMatch(r))return i>0&&(n.v=Bridge.toArray(System.Linq.Enumerable.from(s,System.String).skip(i)).join("\n").trim()),!1}return!1},IsClientDirective:function(e,t){return Kusto.Data.IntelliSense.CslCommandParser.IsStartingWithPrefix(e,"#",t)}}},fields:{m_hashedCommands:null,m_rulesProvider:null},props:{Results:null},ctors:{ctor:function(){this.$initialize(),this.Reset()}},methods:{Reset:function(){this.m_hashedCommands=new(System.Collections.Generic.Dictionary$2(System.String,Kusto.Data.IntelliSense.CslCommand).ctor),this.Results=new(System.Collections.Generic.List$1(Kusto.Data.IntelliSense.CslCommand).ctor)},Parse:function(t,n,s){var i,r,a,o,l=new(System.Collections.Generic.List$1(Kusto.Data.IntelliSense.CslCommand).ctor);if(Bridge.referenceEquals(this.m_rulesProvider,t)||(this.Reset(),this.m_rulesProvider=t),i=Kusto.Data.IntelliSense.CslCommandParser.CslCommandTokenizer.GetCommands(n),Kusto.Cloud.Platform.Utils.ExtendedEnumerable.SafeFastAny$1(Kusto.Data.IntelliSense.CslCommand,i))for(r=0;r<i.Count;r=r+1|0)(a=i.getItem(r)).ParseMode=s,this.FetchFromCache(s,a)||(o=null!=this.Results?System.Linq.Enumerable.from(this.Results,Kusto.Data.IntelliSense.CslCommand).elementAtOrDefault(r,null):null,a.ParseTokens(t,s,o)),l.add(a);return this.m_hashedCommands=System.Linq.Enumerable.from(Kusto.Cloud.Platform.Utils.ExtendedEnumerable.DistinctBy(Kusto.Data.IntelliSense.CslCommand,System.String,l,e.$.Kusto.Data.IntelliSense.CslCommandParser.f4),Kusto.Data.IntelliSense.CslCommand).toDictionary(e.$.Kusto.Data.IntelliSense.CslCommandParser.f4,e.$.Kusto.Data.IntelliSense.CslCommandParser.f5,System.String,Kusto.Data.IntelliSense.CslCommand),this.Results=l,l},FetchFromCache:function(e,t){var n=!1,s={};return this.m_hashedCommands.tryGetValue(t.Text,s)&&s.v.ParseMode===e&&(t.AcquireTokens(s.v),n=!0),n},Clone:function(){var e,t=new Kusto.Data.IntelliSense.CslCommandParser;return t.m_hashedCommands=Kusto.Cloud.Platform.Utils.ExtendedEnumerable.SafeFastAny$1(System.Collections.Generic.KeyValuePair$2(System.String,Kusto.Data.IntelliSense.CslCommand),this.m_hashedCommands)?new(System.Collections.Generic.Dictionary$2(System.String,Kusto.Data.IntelliSense.CslCommand).$ctor1)(this.m_hashedCommands):new(System.Collections.Generic.Dictionary$2(System.String,Kusto.Data.IntelliSense.CslCommand).ctor),t.m_rulesProvider=this.m_rulesProvider,t.Results=Kusto.Cloud.Platform.Utils.ExtendedEnumerable.SafeFastAny$2(Kusto.Data.IntelliSense.CslCommand,this.Results)?(e=Kusto.Data.IntelliSense.CslCommand,System.Linq.Enumerable.from(this.Results,e).toList(e)):new(System.Collections.Generic.List$1(Kusto.Data.IntelliSense.CslCommand).ctor),t}}}),Bridge.ns("Kusto.Data.IntelliSense.CslCommandParser",e.$),Bridge.apply(e.$.Kusto.Data.IntelliSense.CslCommandParser,{f1:function(e){return e},f2:function(e){return e},f3:function(e){return(e||"")+"()"},f4:function(e){return e.Text},f5:function(e){return e}}),Bridge.define("Kusto.Data.IntelliSense.CslCommandParser.CslCommandTokenizer",{$kind:"nested class",statics:{methods:{GetCommands:function(e){var t,n,s,i,r,a=new(System.Collections.Generic.List$1(Kusto.Data.IntelliSense.CslCommand).ctor);if(System.String.isNullOrEmpty(e))return a;var o=null,l=0,u=!1,d=0,m=(t=System.Char,System.Linq.Enumerable.from(e,t).ToArray(t));for(s=0;s<m.length;s=s+1|0)switch(i=m[System.Array.index(s,m)],(u=s===(m.length-1|0))&&(0===l&&((n=new Kusto.Data.IntelliSense.CslCommand).RelativeStart=s,o=n),l=2),l){case 0:(n=new Kusto.Data.IntelliSense.CslCommand).RelativeStart=s,o=n,l=1;break;case 1:(13===i||10===i)&&(d=i,l=2);break;case 2:if((10===i||13===i)&&m[System.Array.index(s-1|0,m)]===i&&(i=d),i===d||u){if(null!=o){for(;!u&&(13===m[System.Array.index(s+1|0,m)]||10===m[System.Array.index(s+1|0,m)]);)u=(s=s+1|0)===(m.length-1|0);r=1+(s-o.RelativeStart|0)|0,o.Text=e.substr(o.RelativeStart,r),o.Length=r,o.IsRunnable=!System.String.isNullOrWhiteSpace(o.Text),a.add(o)}l=0,o=null}else System.Char.isWhiteSpace(String.fromCharCode(i))||(l=1)}return a}}}}),Bridge.define("Kusto.Data.IntelliSense.CslCommandToken",{inherits:[System.ICloneable],props:{AbsolutePositionBias:0,Value:null,TokenKind:0,AbsoluteStart:{get:function(){return this.RelativeStart+this.AbsolutePositionBias|0}},AbsoluteEnd:{get:function(){return this.RelativeEnd+this.AbsolutePositionBias|0}},RelativeStart:0,Length:0,RelativeEnd:{get:function(){return this.RelativeStart+this.Length|0}}},alias:["clone","System$ICloneable$clone"],ctors:{ctor:function(e,t,n){this.$initialize(),this.Value=e,this.TokenKind=n,this.AbsolutePositionBias=t}},methods:{CompareTo:function(e){return null==e?1:this.RelativeStart===e.RelativeStart?0:this.RelativeStart<e.RelativeStart?-1:1},clone:function(){var e;return(e=new Kusto.Data.IntelliSense.CslCommandToken(this.Value,this.AbsolutePositionBias,this.TokenKind)).RelativeStart=this.RelativeStart,e.Length=this.Length,e},equals:function(e){var t=Bridge.as(e,Kusto.Data.IntelliSense.CslCommandToken);return null!=t&&(Bridge.referenceEquals(this.Value,t.Value)&&this.TokenKind===t.TokenKind&&this.RelativeStart===t.RelativeStart&&this.RelativeEnd===t.RelativeEnd&&this.AbsolutePositionBias===t.AbsolutePositionBias)},getHashCode:function(){return Bridge.getHashCode(this.Value)^Bridge.getHashCode(this.TokenKind)^this.RelativeStart^this.RelativeEnd^this.AbsolutePositionBias}}}),Bridge.define("Kusto.Data.IntelliSense.CslCommandToken.Kind",{$kind:"nested enum",statics:{fields:{TableToken:2,TableColumnToken:4,OperatorToken:8,SubOperatorToken:16,CalculatedColumnToken:32,StringLiteralToken:64,FunctionNameToken:128,UnknownToken:256,CommentToken:512,PlainTextToken:1024,DataTypeToken:2048,ControlCommandToken:4096,CommandPartToken:8192,QueryParametersToken:16384,CslCommandToken:32768,LetVariablesToken:65536,PluginToken:131072,BracketRangeToken:262144,ClientDirectiveToken:524288,IsRecognizedEntity:536870912,IsMismatchedTokenValue:1073741824}},$flags:!0}),Bridge.define("Kusto.Data.IntelliSense.CslDocumentation",{statics:{fields:{s_instance:null},props:{Instance:{get:function(){return null==Kusto.Data.IntelliSense.CslDocumentation.s_instance&&(Kusto.Data.IntelliSense.CslDocumentation.s_instance=new Kusto.Data.IntelliSense.CslDocumentation,Kusto.Data.IntelliSense.CslDocumentation.s_instance.Initialize()),Kusto.Data.IntelliSense.CslDocumentation.s_instance}}},methods:{TrimFunctionParameters:function(e){var t=System.String.indexOf(e,String.fromCharCode(40));return t>0?e.substr(0,t):e}}},fields:{m_documentation:null},props:{Topics:{get:function(){return null==this.m_documentation?System.Linq.Enumerable.empty():System.Linq.Enumerable.from(this.m_documentation,System.Collections.Generic.KeyValuePair$2(System.Tuple$2(Kusto.Data.IntelliSense.CslCommandToken.Kind,System.String),Kusto.Data.IntelliSense.CslTopicDocumentation)).select(e.$.Kusto.Data.IntelliSense.CslDocumentation.f1)}}},ctors:{init:function(){this.m_documentation=new(System.Collections.Generic.Dictionary$2(System.Tuple$2(Kusto.Data.IntelliSense.CslCommandToken.Kind,System.String),Kusto.Data.IntelliSense.CslTopicDocumentation).ctor)}},methods:{AddTopic:function(e){var t={Item1:e.TokenKind,Item2:e.Name.toLowerCase()};this.m_documentation.setItem(t,e)},GetTopic:function(e){return e.Kind===Kusto.Data.IntelliSense.OptionKind.Operator?this.GetTopic$1(Kusto.Data.IntelliSense.CslCommandToken.Kind.OperatorToken,e.Value):e.Kind===Kusto.Data.IntelliSense.OptionKind.FunctionAggregation||e.Kind===Kusto.Data.IntelliSense.OptionKind.FunctionScalar?this.GetTopic$1(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,Kusto.Data.IntelliSense.CslDocumentation.TrimFunctionParameters(e.Value)):null},GetTopic$1:function(e,t){var n={Item1:e,Item2:t.toLowerCase()},s={};return this.m_documentation.tryGetValue(n,s),s.v},GetTopicByMarkdownSource:function(e){var t,n;if(System.String.isNullOrWhiteSpace(e))return null;t=Bridge.getEnumerator(this.m_documentation);try{for(;t.moveNext();)if(n=t.Current,Bridge.referenceEquals(n.value.MarkdownSource,e))return n.value}finally{Bridge.is(t,System.IDisposable)&&t.System$IDisposable$Dispose()}return null},GetTopicByName:function(e){var t,n;if(System.String.isNullOrWhiteSpace(e))return null;t=Bridge.getEnumerator(this.m_documentation);try{for(;t.moveNext();)if(n=t.Current,Bridge.referenceEquals(n.key.Item2,e))return n.value}finally{Bridge.is(t,System.IDisposable)&&t.System$IDisposable$Dispose()}return null},equals:function(e){if(null==e)return!1;var t=Bridge.as(e,Kusto.Data.IntelliSense.CslDocumentation);return null!=t&&(this.m_documentation.Count===t.m_documentation.Count&&(!System.Linq.Enumerable.from(t.m_documentation,System.Collections.Generic.KeyValuePair$2(System.Tuple$2(Kusto.Data.IntelliSense.CslCommandToken.Kind,System.String),Kusto.Data.IntelliSense.CslTopicDocumentation)).except(this.m_documentation).any()&&!System.Linq.Enumerable.from(this.m_documentation,System.Collections.Generic.KeyValuePair$2(System.Tuple$2(Kusto.Data.IntelliSense.CslCommandToken.Kind,System.String),Kusto.Data.IntelliSense.CslTopicDocumentation)).except(t.m_documentation).any()))},getHashCode:function(){return Bridge.getHashCode(this.m_documentation)},Initialize:function(){System.Linq.Enumerable.from(this.m_documentation,System.Collections.Generic.KeyValuePair$2(System.Tuple$2(Kusto.Data.IntelliSense.CslCommandToken.Kind,System.String),Kusto.Data.IntelliSense.CslTopicDocumentation)).any()||(this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"abs","Calculates the absolute value of the input.","## Syntax\r\n\r\n`abs(`*x*`)`\r\n\r\n## Arguments\r\n\r\n* *x*: An integer or real number, or a timespan value.\r\n\r\n## Returns\r\n\r\n* Absolute value of x.","","https://docs.microsoft.com/en-us/azure/kusto/query/abs-function","")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"acos","Returns the angle whose cosine is the specified number (the inverse operation of [`cos()`](cosfunction.md)) .","## Syntax\r\n\r\n`acos(`*x*`)`\r\n\r\n## Arguments\r\n\r\n* *x*: A real number in range [-1, 1].\r\n\r\n## Returns\r\n\r\n* The value of the arc cosine of `x`\r\n* `null` if `x` < -1 or `x` > 1","","https://docs.microsoft.com/en-us/azure/kusto/query/acosfunction","")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"ago","Subtracts the given timespan from the current UTC clock time.","```\r\nago(1h)\r\nago(1d)\r\n```\r\n\r\nLike `now()`, this function can be used multiple times\r\nin a statement and the UTC clock time being referenced will be the same\r\nfor all instantiations.\r\n\r\n## Syntax\r\n\r\n`ago(`*a_timespan*`)`\r\n\r\n## Arguments\r\n\r\n* *a_timespan*: Interval to subtract from the current UTC clock time\r\n(`now()`).\r\n\r\n## Returns\r\n\r\n`now() - a_timespan`","All rows with a timestamp in the past hour:\r\n\r\n```\r\nT | where Timestamp > ago(1h)\r\n```","https://docs.microsoft.com/en-us/azure/kusto/query/agofunction","agofunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"any","Arbitrarily chooses one record for each group in a [summarize operator](summarizeoperator.md),\r\nand returns the value of one or more expressions over each such record.","## Syntax\r\n\r\n`summarize` `any` `(` (*Expr* [`,` *Expr2* ...]) | `*` `)`\r\n\r\n## Arguments\r\n\r\n* *Expr*: An expression over each record selected from the input to return.\r\n* *Expr2* .. *ExprN*: Additional expressions.\r\n\r\n## Returns\r\n\r\nThe `any` aggregation function returns the values of the expressions calculated\r\nfor each of the records, selected randomly from each group of the summarize operator.\r\n\r\nIf the `*` argument is provided, the function behaves as if the expressions are all columns\r\nof the input to the summarize operator barring the group-by columns, if any.\r\n\r\n**Remarks**\r\n\r\nThis function is useful when you want to get a sample value of one or more columns\r\nper value of the compound group key.\r\n\r\nWhen the function is provided with a single column reference, it will attempt to\r\nreturn a non-null/non-empty value, if such value is present.\r\n\r\nAs a result of the random nature of this function, using it multiple times in\r\na single application of the `summarize` operator is not equivalent to using\r\nit a single time with multiple expressions. The former may have each application\r\nselect a different record, while the latter guarantees that all values are calculated\r\nover a single record (per distinct group).","Show Random Continent:\r\n\r\n```\r\nContinents | summarize any(Continent)\r\n```\r\n\r\n![Any 1](images/aggfunction/any1.png)\r\nShow all the details for a random record:\r\n\r\n```\r\nContinents | summarize any(*)\r\n```\r\n\r\n![Any 2](images/aggfunction/any2.png)\r\nShow all the details for each random continent:\r\n\r\n```\r\nContinents | summarize any(*) by Continent\r\n```\r\n\r\n![Any 3](images/aggfunction/any3.png)","https://docs.microsoft.com/en-us/azure/kusto/query/any-aggfunction","any-aggfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"anyif",'Arbitrarily selects one record for each group in a [summarize operator](summarizeoperator.md), for which the predicate\r\nis "true". The function returns the value of an expression over each such record.','> [!NOTE]\r\n> This function is useful when you want to get a sample value of one column per value of the compound group key, subject to some predicate that is "true".\r\n> If such a value is present, the function attempts to return a non-null/non-empty value.\r\n\r\n## Syntax\r\n\r\n`summarize` `anyif` `(` *Expr*, *Predicate* `)`\r\n\r\n## Arguments\r\n\r\n* *Expr*: An expression over each record selected from the input to return.\r\n* *Predicate*: Predicate to indicate which records may be considered for evaluation.\r\n\r\n## Returns\r\n\r\nThe `anyif` aggregation function returns the value of the expression calculated\r\nfor each of the records randomly selected from each group of the summarize operator. Only records for which *Predicate* returns "true" may be selected. If the predicate doesn\'t return "true", a null value is produced.',"Show a random continent that has a population of 300 to 600 million.\r\n\r\n```\r\nContinents | summarize anyif(Continent, Population between (300000000 .. 600000000))\r\n```\r\n\r\n![Any 1](images/aggfunction/any1.png)","https://docs.microsoft.com/en-us/azure/kusto/query/anyif-aggfunction","anyif-aggfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"arg_max","Finds a row in the group that maximizes *ExprToMaximize*, and returns the value of *ExprToReturn* (or `*` to return the entire row).","* Can be used only in context of aggregation inside [summarize](summarizeoperator.md)\r\n\r\n## Syntax\r\n\r\n`summarize` [`(`*NameExprToMaximize* `,` *NameExprToReturn* [`,` ...] `)=`] `arg_max` `(`*ExprToMaximize*, `*` | *ExprToReturn*  [`,` ...]`)`\r\n\r\n## Arguments\r\n\r\n* *ExprToMaximize*: Expression that will be used for aggregation calculation. \r\n* *ExprToReturn*: Expression that will be used for returning the value when *ExprToMaximize* is\r\n  maximum. Expression to return may be a wildcard (*) to return all columns of the input table.\r\n* *NameExprToMaximize*: An optional name for the result column representing *ExprToMaximize*.\r\n* *NameExprToReturn*: Additional optional names for the result columns representing *ExprToReturn*.\r\n\r\n## Returns\r\n\r\nFinds a row in the group that maximizes *ExprToMaximize*, and \r\nreturns the value of *ExprToReturn* (or `*` to return the entire row).","See examples for [arg_min()](arg-min-aggfunction.md) aggregation function","https://docs.microsoft.com/en-us/azure/kusto/query/arg-max-aggfunction","arg-max-aggfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"arg_min","Finds a row in the group that minimizes *ExprToMinimize*, and returns the value of *ExprToReturn* (or `*` to return the entire row).","* Can be used only in context of aggregation inside [summarize](summarizeoperator.md)\r\n\r\n## Syntax\r\n\r\n`summarize` [`(`*NameExprToMinimize* `,` *NameExprToReturn* [`,` ...] `)=`] `arg_min` `(`*ExprToMinimize*, `*` | *ExprToReturn*  [`,` ...]`)`\r\n\r\n## Arguments\r\n\r\n* *ExprToMinimize*: Expression that will be used for aggregation calculation. \r\n* *ExprToReturn*: Expression that will be used for returning the value when *ExprToMinimize* is\r\n  minimum. Expression to return may be a wildcard (*) to return all columns of the input table.\r\n* *NameExprToMinimize*: An optional name for the result column representing *ExprToMinimize*.\r\n* *NameExprToReturn*: Additional optional names for the result columns representing *ExprToReturn*.\r\n\r\n## Returns\r\n\r\nFinds a row in the group that minimizes *ExprToMinimize*, and returns the value of *ExprToReturn* (or `*` to return the entire row).","Show cheapest supplier of each product:\r\n\r\n```\r\nSupplies | summarize arg_min(Price, Supplier) by Product\r\n```\r\n\r\nShow all the details, not just the supplier name:\r\n\r\n```\r\nSupplies | summarize arg_min(Price, *) by Product\r\n```\r\n\r\nFind the southernmost city in each continent, with its country:\r\n\r\n```\r\nPageViewLog \r\n| summarize (latitude, min_lat_City, min_lat_country)=arg_min(latitude, City, country) \r\n    by continent\r\n```\r\n\r\n![Arg min](images/arg-min-aggfunction/arg-min.png)","https://docs.microsoft.com/en-us/azure/kusto/query/arg-min-aggfunction","arg-min-aggfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"array_concat","Concatenates a number of dynamic arrays to a single array.","## Syntax\r\n\r\n`array_concat(`*arr1*`[`,` *arr2*, ...]`)`\r\n\r\n## Arguments\r\n\r\n* *arr1...arrN*: Input arrays to be concatenated into a dynamic array. All arguments must be dynamic arrays (see [pack_array](packarrayfunction.md)). \r\n\r\n## Returns\r\n\r\nDynamic array of arrays with arr1, arr2, ... , arrN.","```\r\nrange x from 1 to 3 step 1\r\n| extend y = x * 2\r\n| extend z = y * 2\r\n| extend a1 = pack_array(x,y,z), a2 = pack_array(x, y)\r\n| project array_concat(a1, a2)\r\n```\r\n\r\n|Column1|\r\n|---|\r\n|[1,2,4,1,2]|\r\n|[2,4,8,2,4]|\r\n|[3,6,12,3,6]|","https://docs.microsoft.com/en-us/azure/kusto/query/arrayconcatfunction","arrayconcatfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"array_iif","Element-wise iif function on dynamic arrays.","Another alias: array_iff().\r\n\r\n## Syntax\r\n\r\n`array_iif(`*ConditionArray*, *IfTrue*, *IfFalse*]`)`\r\n\r\n## Arguments\r\n\r\n* *conditionArray*: Input array of *boolean* or numeric values, must be dynamic array.\r\n* *ifTrue*: Input array of values or primitive value - the result value(s) when the corresponding value of *ConditionArray* is *true*.\r\n* *ifFalse*: Input array of values or primitive value - the result value(s) when the corresponding value of *ConditionArray* is *false*.\r\n\r\n**Notes**\r\n\r\n* The result length is the length of *conditionArray*.\r\n* Numeric condition value is treated as *condition* != *0*.\r\n* Non-numeric/null condition value will have null in the corresponding index of the result.\r\n* Missing values (in shorter length arrays) are treated as null.\r\n\r\n## Returns\r\n\r\nDynamic array of the values taken either from the *IfTrue* or *IfFalse* [array] values, according to the corresponding value of the Condition array.","```\r\nprint condition=dynamic([true,false,true]), l=dynamic([1,2,3]), r=dynamic([4,5,6]) \r\n| extend res=array_iif(condition, l, r)\r\n```\r\n\r\n|condition|l|r|res|\r\n|---|---|---|---|\r\n|[true, false, true]|[1, 2, 3]|[4, 5, 6]|[1, 5, 3]|","https://docs.microsoft.com/en-us/azure/kusto/query/arrayifffunction","arrayifffunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"array_index_of","Searches the array for the specified item, and returns its position.","## Syntax\r\n\r\n`array_index_of(`*array*,*value*`)`\r\n\r\n## Arguments\r\n\r\n* *array*: Input array to search.\r\n* *value*: Value to search for. The value should be of type long, integer, double, datetime, timespan, decimal, string, or guid.\r\n\r\n## Returns\r\n\r\nZero-based index position of lookup.\r\nReturns -1 if the value isn't found in the array.",'```\r\nprint arr=dynamic(["this", "is", "an", "example"]) \r\n| project Result=array_index_of(arr, "example")\r\n```\r\n\r\n|Result|\r\n|---|\r\n|3|\r\n\r\n## See also\r\n\r\nIf you only want to check whether a value exists in an array,\r\nbut you are not interested in its position, you can use\r\n[set_has_element(`arr`, `value`)](sethaselementfunction.md). This function will improve the readability of your query. Both functions have the same performance.',"https://docs.microsoft.com/en-us/azure/kusto/query/arrayindexoffunction","arrayindexoffunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"array_length","Calculates the number of elements in a dynamic array.","## Syntax\r\n\r\n`array_length(`*array*`)`\r\n\r\n## Arguments\r\n\r\n* *array*: A `dynamic` value.\r\n\r\n## Returns\r\n\r\nThe number of elements in *array*, or `null` if *array* is not an array.","```\r\nprint array_length(parse_json('[1, 2, 3, \"four\"]')) == 4\r\n\r\nprint array_length(parse_json('[8]')) == 1\r\n\r\nprint array_length(parse_json('[{}]')) == 1\r\n\r\nprint array_length(parse_json('[]')) == 0\r\n\r\nprint array_length(parse_json('{}')) == null\r\n\r\nprint array_length(parse_json('21')) == null\r\n```","https://docs.microsoft.com/en-us/azure/kusto/query/arraylengthfunction","arraylengthfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"array_rotate_left","Rotates values inside a `dynamic` array to the left.","## Syntax\r\n\r\n`array_rotate_left(`*arr*, *rotate_count*`)`\r\n\r\n## Arguments\r\n\r\n* *arr*: Input array to split, must be dynamic array.\r\n* *rotate_count*: Integer specifying the number of positions that array elements will be rotated to the left. If the value is negative, the elements will be rotated to the right.\r\n\r\n## Returns\r\n\r\nDynamic array containing the same amount of the elements as in original array, where each element was rotated according to *rotate_count*.\r\n\r\n## See also\r\n\r\n* For rotating array to the right, see [array_rotate_right()](array_rotate_rightfunction.md).\r\n* For shifting array to the left, see [array_shift_left()](array_shift_leftfunction.md).\r\n* For shifting array to the right, see [array_shift_right()](array_shift_rightfunction.md).","* Rotating to the left by two positions:\r\n\r\n    \r\n    ```\r\n    print arr=dynamic([1,2,3,4,5]) \r\n    | extend arr_rotated=array_rotate_left(arr, 2)\r\n    ```\r\n    \r\n    |arr|arr_rotated|\r\n    |---|---|\r\n    |[1,2,3,4,5]|[3,4,5,1,2]|\r\n\r\n* Rotating to the right by two positions by using negative rotate_count value:\r\n\r\n    \r\n    ```\r\n    print arr=dynamic([1,2,3,4,5]) \r\n    | extend arr_rotated=array_rotate_left(arr, -2)\r\n    ```\r\n    \r\n    |arr|arr_rotated|\r\n    |---|---|\r\n    |[1,2,3,4,5]|[4,5,1,2,3]|","https://docs.microsoft.com/en-us/azure/kusto/query/array_rotate_leftfunction","array_rotate_leftfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"array_rotate_right","Rotates values inside a `dynamic` array to the right.","## Syntax\r\n\r\n`array_rotate_right(`*arr*, *rotate_count*`)`\r\n\r\n## Arguments\r\n\r\n* *arr*: Input array to split, must be dynamic array.\r\n* *rotate_count*: Integer specifying the number of positions that array elements will be rotated to the right. If the value is negative, the elements will be rotated to the left.\r\n\r\n## Returns\r\n\r\nDynamic array containing the same amount of the elements as in the original array, where each element was rotated according to *rotate_count*.\r\n\r\n## See also\r\n\r\n* For rotating array to the left, see [array_rotate_left()](array_rotate_leftfunction.md).\r\n* For shifting array to the left, see [array_shift_left()](array_shift_leftfunction.md).\r\n* For shifting array to the right, see [array_shift_right()](array_shift_rightfunction.md).","* Rotating to the right by two positions:\r\n\r\n    \r\n    ```\r\n    print arr=dynamic([1,2,3,4,5]) \r\n    | extend arr_rotated=array_rotate_right(arr, 2)\r\n    ```\r\n    \r\n    |arr|arr_rotated|\r\n    |---|---|\r\n    |[1,2,3,4,5]|[4,5,1,2,3]|\r\n\r\n* Rotating to the left by two positions by using negative rotate_count value:\r\n\r\n    \r\n    ```\r\n    print arr=dynamic([1,2,3,4,5]) \r\n    | extend arr_rotated=array_rotate_right(arr, -2)\r\n    ```\r\n    \r\n    |arr|arr_rotated|\r\n    |---|---|\r\n    |[1,2,3,4,5]|[3,4,5,1,2]|","https://docs.microsoft.com/en-us/azure/kusto/query/array_rotate_rightfunction","array_rotate_rightfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"array_shift_left","Shifts the values inside a `dynamic` array to the left.","## Syntax\r\n\r\n`array_shift_left(`*`arr`*, *`shift_count`* `[,` *`fill_value`* ]`)`\r\n\r\n## Arguments\r\n\r\n* *`arr`*: Input array to split, must be dynamic array.\r\n* *`shift_count`*: Integer specifying the number of positions that array elements will be shifted to the left. If the value is negative, the elements will be shifted to the right.\r\n* *`fill_value`*: Scalar value that is used for inserting elements instead of the ones that were shifted and removed. Default: null value or empty string (depending on the *`arr`* type).\r\n\r\n## Returns\r\n\r\nDynamic array containing the same number of elements as in the original array. Each element has been shifted according to *shift_count*. New elements that are added in place of removed elements will have a value of *fill_value*.\r\n\r\n## See also\r\n\r\n* For shifting array right, see [array_shift_right()](array_shift_rightfunction.md).\r\n* For rotating array right, see [array_rotate_right()](array_rotate_rightfunction.md).\r\n* For rotating array left, see [array_rotate_left()](array_rotate_leftfunction.md).","* Shifting to the left by two positions:\r\n\r\n    \r\n    ```\r\n    print arr=dynamic([1,2,3,4,5]) \r\n    | extend arr_shift=array_shift_left(arr, 2)\r\n    ```\r\n    \r\n    |`arr`|`arr_shift`|\r\n    |---|---|\r\n    |[1,2,3,4,5]|[3,4,5,null,null]|\r\n\r\n* Shifting to the left by two positions and adding default value:\r\n\r\n    \r\n    ```\r\n    print arr=dynamic([1,2,3,4,5]) \r\n    | extend arr_shift=array_shift_left(arr, 2, -1)\r\n    ```\r\n    \r\n    |`arr`|`arr_shift`|\r\n    |---|---|\r\n    |[1,2,3,4,5]|[3,4,5,-1,-1]|\r\n\r\n\r\n* Shifting to the right by two positions by using negative *shift_count* value:\r\n\r\n    \r\n    ```\r\n    print arr=dynamic([1,2,3,4,5]) \r\n    | extend arr_shift=array_shift_left(arr, -2, -1)\r\n    ```\r\n    \r\n    |`arr`|`arr_shift`|\r\n    |---|---|\r\n    |[1,2,3,4,5]|[-1,-1,1,2,3]|","https://docs.microsoft.com/en-us/azure/kusto/query/array_shift_leftfunction","array_shift_leftfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"array_shift_right","`array_shift_right()` shifts values inside an array to the right.","## Syntax\r\n\r\n`array_shift_right(`*`arr`*, *`shift_count`* [, *`fill_value`* ]`)`\r\n\r\n## Arguments\r\n\r\n* *`arr`*: Input array to split, must be dynamic array.\r\n* *`shift_count`*: Integer specifying the number of positions that array elements will be shifted to the right. If the value is negative, the elements will be shifted to the left.\r\n* *`fill_value`*: scalar value that is used for inserting elements instead of the ones that were shifted and removed. Default: null value or empty string (depending on the *arr* type).\r\n\r\n## Returns\r\n\r\nDynamic array containing the same amount of the elements as in the original array. Each element has been shifted according to *`shift_count`*. New elements that are added instead of the removed elements will have a value of *`fill_value`*.\r\n\r\n## See also\r\n\r\n* For shifting array left, see [array_shift_left()](array_shift_leftfunction.md).\r\n* For rotating array right, see [array_rotate_right()](array_rotate_rightfunction.md).\r\n* For rotating array left, see [array_rotate_left()](array_rotate_leftfunction.md).","* Shifting to the right by two positions:\r\n\r\n    \r\n    ```\r\n    print arr=dynamic([1,2,3,4,5]) \r\n    | extend arr_shift=array_shift_right(arr, 2)\r\n    ```\r\n    \r\n    |arr|arr_shift|\r\n    |---|---|\r\n    |[1,2,3,4,5]|[null,null,1,2,3]|\r\n\r\n* Shifting to the right by two positions and adding a default value:\r\n\r\n    \r\n    ```\r\n    print arr=dynamic([1,2,3,4,5]) \r\n    | extend arr_shift=array_shift_right(arr, 2, -1)\r\n    ```\r\n    \r\n    |arr|arr_shift|\r\n    |---|---|\r\n    |[1,2,3,4,5]|[-1,-1,1,2,3]|\r\n\r\n* Shifting to the left by two positions by using a negative shift_count value:\r\n\r\n    \r\n    ```\r\n    print arr=dynamic([1,2,3,4,5]) \r\n    | extend arr_shift=array_shift_right(arr, -2, -1)\r\n    ```\r\n    \r\n    |arr|arr_shift|\r\n    |---|---|\r\n    |[1,2,3,4,5]|[3,4,5,-1,-1]|","https://docs.microsoft.com/en-us/azure/kusto/query/array_shift_rightfunction","array_shift_rightfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"array_slice","Extracts a slice of a dynamic array.","## Syntax\r\n\r\n`array_slice`(*`arr`*, *`start`*, *`end`*)\r\n\r\n## Arguments\r\n\r\n* *`arr`*: Input array to extract the slice from must be dynamic array.\r\n* *`start`*: zero-based (inclusive) start index of the slice, negative values are converted to array_length+start.\r\n* *`end`*: zero-based (inclusive) end index of the slice, negative values are converted to array_length+end.\r\n\r\nNote: out of bounds indices are ignored.\r\n\r\n## Returns\r\n\r\nDynamic array of the values in the range [`start..end`] from `arr`.","```\r\nprint arr=dynamic([1,2,3]) \r\n| extend sliced=array_slice(arr, 1, 2)\r\n```\r\n\r\n|`arr`|`sliced`|\r\n|---|---|\r\n|[1,2,3]|[2,3]|\r\n\r\n```\r\nprint arr=dynamic([1,2,3,4,5]) \r\n| extend sliced=array_slice(arr, 2, -1)\r\n```\r\n\r\n|`arr`|sliced|\r\n|---|---|\r\n|[1,2,3,4,5]|[3,4,5]|\r\n\r\n```\r\nprint arr=dynamic([1,2,3,4,5]) \r\n| extend sliced=array_slice(arr, -3, -2)\r\n```\r\n\r\n|`arr`|sliced|\r\n|---|---|\r\n|[1,2,3,4,5]|[3,4]|","https://docs.microsoft.com/en-us/azure/kusto/query/arrayslicefunction","arrayslicefunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"array_split","Splits an array to multiple arrays according to the split indices and packs the generated array in a dynamic array.","## Syntax\r\n\r\n`array_split`(*`arr`*, *`indices`*)\r\n\r\n## Arguments\r\n\r\n* *`arr`*: Input array to split, must be dynamic array.\r\n* *`indices`*: Integer or dynamic array of integers with the split indices (zero based), negative values are converted to array_length + value.\r\n\r\n## Returns\r\n\r\nDynamic array containing N+1 arrays with the values in the range `[0..i1), [i1..i2), ... [iN..array_length)` from `arr`, where N is the number of input indices and `i1...iN` are the indices.","```\r\nprint arr=dynamic([1,2,3,4,5]) \r\n| extend arr_split=array_split(arr, 2)\r\n```\r\n\r\n|`arr`|`arr_split`|\r\n|---|---|\r\n|[1,2,3,4,5]|[[1,2],[3,4,5]]|\r\n\r\n```\r\nprint arr=dynamic([1,2,3,4,5]) \r\n| extend arr_split=array_split(arr, dynamic([1,3]))\r\n```\r\n\r\n|`arr`|`arr_split`|\r\n|---|---|\r\n|[1,2,3,4,5]|[[1],[2,3],[4,5]]|","https://docs.microsoft.com/en-us/azure/kusto/query/arraysplitfunction","arraysplitfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.OperatorToken,"as","Binds a name to the operator's input tabular expression, thus allowing the query\r\nto reference the value of the tabular expression multiple times without breaking\r\nthe query and binding a name through the [let statement](letstatement.md).","## Syntax\r\n\r\n*T* `|` `as` [`hint.materialized` `=` `true`] *Name*\r\n\r\n## Arguments\r\n\r\n* *T*: A tabular expression.\r\n* *Name*: A temporary name for the tabular expression.\r\n* `hint.materialized`: If set to `true`, the value of the tabular expression will be\r\n  materialized as if it was wrapped by a [materialize()](./materializefunction.md) function\r\n  call.\r\n\r\n> [!NOTE]\r\n> * The name given by `as` will be used in the `withsource=` column of [union](./unionoperator.md), the `source_` column of [find](./findoperator.md), and the `$table` column of [search](./searchoperator.md).\r\n> * The tabular expression named using the operator in a [join](./joinoperator.md)'s outer tabular input (`$left`) can also be used in the join's tabular inner input (`$right`).",'```\r\n// 1. In the following 2 example the union\'s generated TableName column will consist of \'T1\' and \'T2\'\r\nrange x from 1 to 10 step 1 \r\n| as T1 \r\n| union withsource=TableName T2\r\n\r\nunion withsource=TableName (range x from 1 to 10 step 1 | as T1), T2\r\n\r\n// 2. In the following example, the \'left side\' of the join will be: \r\n//      MyLogTable filtered by type == "Event" and Name == "Start"\r\n//    and the \'right side\' of the join will be: \r\n//      MyLogTable filtered by type == "Event" and Name == "Stop"\r\nMyLogTable  \r\n| where type == "Event"\r\n| as T\r\n| where Name == "Start"\r\n| join (\r\n    T\r\n    | where Name == "Stop"\r\n) on ActivityId\r\n```',"https://docs.microsoft.com/en-us/azure/kusto/query/asoperator","asoperator.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"asin","Returns the angle whose sine is the specified number (the inverse operation of [`sin()`](sinfunction.md)) .","## Syntax\r\n\r\n`asin(`*x*`)`\r\n\r\n## Arguments\r\n\r\n* *x*: A real number in range [-1, 1].\r\n\r\n## Returns\r\n\r\n* The value of the arc sine of `x`\r\n* `null` if `x` < -1 or `x` > 1","","https://docs.microsoft.com/en-us/azure/kusto/query/asinfunction","")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"assert","Checks for a condition. If the condition is false, outputs error messages and fails the query.","## Syntax\r\n\r\n`assert(`*condition*`, `*message*`)`\r\n\r\n## Arguments\r\n\r\n* *condition*: The conditional expression to evaluate. If the condition is `false`, the specified message is used to report an error. If the condition is `true`, it returns `true` as an evaluation result. Condition must be evaluated to constant during the query analysis phase.\r\n* *message*: The message used if assertion is evaluated to `false`. The *message* must be a string literal.\r\n\r\n> [!NOTE]\r\n> `condition` must be evaluated to constant during the query analysis phase. In other words, it can be constructed from other expressions referencing constants, and can't be bound to row-context.\r\n\r\n## Returns\r\n\r\n* `true` - if the condition is `true`\r\n* Raises semantic error if the condition is evaluated to `false`.","The following query defines a function `checkLength()` that checks input string length, and uses `assert` to validate input length parameter (checks that it is greater than zero).\r\n\r\n```\r\nlet checkLength = (len:long, s:string)\r\n{\r\n    assert(len > 0, \"Length must be greater than zero\") and \r\n    strlen(s) > len\r\n};\r\ndatatable(input:string)\r\n[\r\n    '123',\r\n    '4567'\r\n]\r\n| where checkLength(len=long(-1), input)\r\n```\r\n\r\nRunning this query yields an error:  \r\n`assert() has failed with message: 'Length must be greater than zero'`\r\n\r\nExample of running with valid `len` input:\r\n\r\n```\r\nlet checkLength = (len:long, s:string)\r\n{\r\n    assert(len > 0, \"Length must be greater than zero\") and strlen(s) > len\r\n};\r\ndatatable(input:string)\r\n[\r\n    '123',\r\n    '4567'\r\n]\r\n| where checkLength(len=3, input)\r\n```\r\n\r\n|input|\r\n|---|\r\n|4567|","https://docs.microsoft.com/en-us/azure/kusto/query/assert-function","assert-function.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"atan","Returns the angle whose tangent is the specified number (the inverse operation of [`tan()`](tanfunction.md)) .","## Syntax\r\n\r\n`atan(`*x*`)`\r\n\r\n## Arguments\r\n\r\n* *x*: A real number.\r\n\r\n## Returns\r\n\r\n* The value of the arc tangent of `x`","","https://docs.microsoft.com/en-us/azure/kusto/query/atanfunction","")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"atan2","Calculates the angle, in radians, between the positive x-axis and the ray from the origin to the point (y, x).","## Syntax\r\n\r\n`atan2(`*y*`,`*x*`)`\r\n\r\n## Arguments\r\n\r\n* *x*: X coordinate (a real number).\r\n* *y*: Y coordinate (a real number).\r\n\r\n## Returns\r\n\r\n* The angle, in radians, between the positive x-axis and the ray from the origin to the point (y, x).","```\r\nprint atan2_0 = atan2(1,1) // Pi / 4 radians (45 degrees)\r\n| extend atan2_1 = atan2(0,-1) // Pi radians (180 degrees)\r\n| extend atan2_2 = atan2(-1,0) // - Pi / 2 radians (-90 degrees)\r\n```\r\n\r\n|atan2_0|atan2_1|atan2_2|\r\n|---|---|---|\r\n|0.785398163397448|3.14159265358979|-1.5707963267949|","https://docs.microsoft.com/en-us/azure/kusto/query/atan2function","atan2function.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"avg","Calculates the average of *Expr* across the group.","* Can only be used in context of aggregation inside [summarize](summarizeoperator.md)\r\n\r\n## Syntax\r\n\r\nsummarize `avg(`*Expr*`)`\r\n\r\n## Arguments\r\n\r\n* *Expr*: Expression that will be used for aggregation calculation. Records with `null` values are ignored and not included in the calculation.\r\n\r\n## Returns\r\n\r\nThe average value of *Expr* across the group.","","https://docs.microsoft.com/en-us/azure/kusto/query/avg-aggfunction","")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"avgif","Calculates the [average](avg-aggfunction.md) of *Expr* across the group for which *Predicate* evaluates to `true`.","* Can only be used in context of aggregation inside [summarize](summarizeoperator.md)\r\n\r\n## Syntax\r\n\r\nsummarize `avgif(`*Expr*`, `*Predicate*`)`\r\n\r\n## Arguments\r\n\r\n* *Expr*: Expression that will be used for aggregation calculation. Records with `null` values are ignored and not included in the calculation.\r\n* *Predicate*:  predicate that if true, the *Expr* calculated value will be added to the average.\r\n\r\n## Returns\r\n\r\nThe average value of *Expr* across the group where *Predicate* evaluates to `true`.","```\r\nrange x from 1 to 100 step 1\r\n| summarize avgif(x, x%2 == 0)\r\n```\r\n\r\n|avgif_x|\r\n|---|\r\n|51|","https://docs.microsoft.com/en-us/azure/kusto/query/avgif-aggfunction","avgif-aggfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"bag_keys","Enumerates all the root keys in a dynamic property-bag object.","## Syntax\r\n\r\n`bag_keys(`*dynamic object*`)`\r\n\r\n## Returns\r\n\r\nAn array of keys, order is undetermined.",'```\r\ndatatable(index:long, d:dynamic) [\r\n1, dynamic({\'a\':\'b\', \'c\':123}), \r\n2, dynamic({\'a\':\'b\', \'c\':{\'d\':123}}),\r\n3, dynamic({\'a\':\'b\', \'c\':[{\'d\':123}]}),\r\n4, dynamic(null),\r\n5, dynamic({}),\r\n6, dynamic(\'a\'),\r\n7, dynamic([])]\r\n| extend keys = bag_keys(d)\r\n```\r\n\r\n|index|d|keys|\r\n|---|---|---|\r\n|1|{<br>  "a": "b",<br>  "c": 123<br>}|[<br>  "a",<br>  "c"<br>]|\r\n|2|{<br>  "a": "b",<br>  "c": {<br>    "d": 123<br>  }<br>}|[<br>  "a",<br>  "c"<br>]|\r\n|3|{<br>  "a": "b",<br>  "c": [<br>    {<br>      "d": 123<br>    }<br>  ]<br>}|[<br>  "a",<br>  "c"<br>]|\r\n|4|||\r\n|5|{}|[]|\r\n|6|a||\r\n|7|[]||',"https://docs.microsoft.com/en-us/azure/kusto/query/bagkeysfunction","bagkeysfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"bag_merge","Merges `dynamic` property-bags into a `dynamic` property-bag with all properties merged.","## Syntax\r\n\r\n`bag_merge(`*bag1*`, `*bag2*`[`,` *bag3*, ...])`\r\n\r\n## Arguments\r\n\r\n* *bag1...bagN*: Input `dynamic` property-bags. The function accepts between 2 to 64 arguments.\r\n\r\n## Returns\r\n\r\nReturns a `dynamic` property-bag. Results from merging all of the input property-bag objects. If a key appears in more than one input object, an arbitrary value (out of the possible values for this key) will be chosen.","Expression:\r\n\r\n```\r\nprint result = bag_merge(\r\n   dynamic({'A1':12, 'B1':2, 'C1':3}),\r\n   dynamic({'A2':81, 'B2':82, 'A1':1}))\r\n```\r\n\r\n|result|\r\n|---|\r\n|{<br>  \"A1\": 12,<br>  \"B1\": 2,<br>  \"C1\": 3,<br>  \"A2\": 81,<br>  \"B2\": 82<br>}|","https://docs.microsoft.com/en-us/azure/kusto/query/bag-merge-function","bag-merge-function.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"bag_remove_keys","Removes keys and associated values from a `dynamic` property-bag.","## Syntax\r\n\r\n`bag_remove_keys(`*bag*`, `*keys*`)`\r\n\r\n## Arguments\r\n\r\n* *bag*: `dynamic` property-bag input.\r\n* *keys*: `dynamic` array includes keys to be removed from the input. Keys refer to the first level of the property bag.\r\nSpecifying keys on the nested levels isn't supported.\r\n\r\n## Returns\r\n\r\nReturns a `dynamic` property-bag without specified keys and their values.",'```\r\ndatatable(input:dynamic)\r\n[\r\n    dynamic({\'key1\' : 123,     \'key2\': \'abc\'}),\r\n    dynamic({\'key1\' : \'value\', \'key3\': 42.0}),\r\n]\r\n| extend result=bag_remove_keys(input, dynamic([\'key2\', \'key4\']))\r\n```\r\n\r\n|input|result|\r\n|---|---|\r\n|{<br>  "key1": 123,<br>  "key2": "abc"<br>}|{<br>  "key1": 123<br>}|\r\n|{<br>  "key1": "value",<br>  "key3": 42.0<br>}|{<br>  "key1": "value",<br>  "key3": 42.0<br>}|',"https://docs.microsoft.com/en-us/azure/kusto/query/bag-remove-keys-function","bag-remove-keys-function.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"base64_decode_toarray","Decodes a base64 string to an array of long values.","## Syntax\r\n\r\n`base64_decode_toarray(`*String*`)`\r\n\r\n## Arguments\r\n\r\n* *String*: Input string to be decoded from base64 to UTF8 string.\r\n\r\n## Returns\r\n\r\nReturns an array of long values decoded from a base64 string.\r\n\r\n* To decode base64 strings to a UTF-8 string, see [base64_decode_tostring()](base64_decode_tostringfunction.md)\r\n* To encode strings to a base64 string, see [base64_encode_tostring()](base64_encode_tostringfunction.md)","```\r\nprint Quine=base64_decode_toarray(\"S3VzdG8=\")  \r\n// 'K', 'u', 's', 't', 'o'\r\n```\r\n\r\n|Quine|\r\n|-----|\r\n|[75,117,115,116,111]|\r\n\r\nIf you try to decode a base64 string that was generated from an invalid UTF-8 encoding, \"null\" will be returned:\r\n\r\n```\r\nprint Empty=base64_decode_toarray(\"U3RyaW5n0KHR0tGA0L7Rh9C60LA=\")\r\n```\r\n\r\n|Empty|\r\n|-----|\r\n||","https://docs.microsoft.com/en-us/azure/kusto/query/base64_decode_toarrayfunction","base64_decode_toarrayfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"base64_decode_tostring","Decodes a base64 string to a UTF-8 string.","## Syntax\r\n\r\n`base64_decode_tostring(`*String*`)`\r\n\r\n## Arguments\r\n\r\n* *String*: Input string to be decoded from base64 to UTF8-8 string.\r\n\r\n## Returns\r\n\r\nReturns UTF-8 string decoded from base64 string.\r\n\r\n* To decode base64 strings to an array of long values, see [base64_decode_toarray()](base64_decode_toarrayfunction.md)\r\n* To decode strings to base64 string, see [base64_encode_tostring()](base64_encode_tostringfunction.md)",'```\r\nprint Quine=base64_decode_tostring("S3VzdG8=")\r\n```\r\n\r\n|Quine|\r\n|-----|\r\n|Kusto|\r\n\r\nTrying to decode a base64 string that was generated from invalid UTF-8 encoding will return null:\r\n\r\n```\r\nprint Empty=base64_decode_tostring("U3RyaW5n0KHR0tGA0L7Rh9C60LA=")\r\n```\r\n\r\n|Empty|\r\n|-----|\r\n||',"https://docs.microsoft.com/en-us/azure/kusto/query/base64_decode_tostringfunction","base64_decode_tostringfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"base64_encode_fromarray","Encodes a base64 string from a bytes array.","## Syntax\r\n\r\n`base64_encode_fromarray(`*BytesArray*`)`\r\n\r\n## Arguments\r\n\r\n* *BytesArray*: Input bytes array to be encoded into base64 string.\r\n\r\n## Returns\r\n\r\nReturns the base64 string encoded from the bytes array.\r\n\r\n* For decoding base64 strings to a UTF-8 string see [base64_decode_tostring()](base64_decode_tostringfunction.md)\r\n* For encoding strings to base64 string see [base64_encode_tostring()](base64_encode_tostringfunction.md)\r\n* This function is the inverse of [base64_decode_toarray()](base64_decode_toarrayfunction.md)",'```\r\nlet bytes_array = toscalar(print base64_decode_toarray("S3VzdG8="));\r\nprint decoded_base64_string = base64_encode_fromarray(bytes_array)\r\n```\r\n\r\n|decoded_base64_string|\r\n|---|\r\n|S3VzdG8=|\r\n\r\nTrying to encode a base64 string from an invalid bytes array which was generated from invalid UTF-8 encoded string will return null:\r\n\r\n```\r\nlet empty_bytes_array = toscalar(print base64_decode_toarray("U3RyaW5n0KHR0tGA0L7Rh9C60LA"));\r\nprint empty_string = base64_encode_fromarray(empty_bytes_array)\r\n```\r\n\r\n|empty_string|\r\n|---|\r\n||',"https://docs.microsoft.com/en-us/azure/kusto/query/base64_encode_fromarrayfunction","base64_encode_fromarrayfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"base64_encode_tostring","Encodes a string as base64 string.","## Syntax\r\n\r\n`base64_encode_tostring(`*String*`)`\r\n\r\n## Arguments\r\n\r\n* *String*: Input string to be encoded as base64 string.\r\n\r\n## Returns\r\n\r\nReturns the string encoded as base64 string.\r\n\r\n* To decode base64 strings to UTF-8 strings, see [base64_decode_tostring()](base64_decode_tostringfunction.md)\r\n* To decode base64 strings to an array of long values, see [base64_decode_toarray()](base64_decode_toarrayfunction.md)",'```\r\nprint Quine=base64_encode_tostring("Kusto")\r\n```\r\n\r\n|Quine   |\r\n|--------|\r\n|S3VzdG8=|',"https://docs.microsoft.com/en-us/azure/kusto/query/base64_encode_tostringfunction","base64_encode_tostringfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"beta_cdf","Returns the standard cumulative beta distribution function.","```\r\nbeta_cdf(0.2, 10.0, 50.0)\r\n```\r\n\r\nIf *probability* = `beta_cdf(`*x*,...`)`, then `beta_inv(`*probability*,...`)` = *x*.\r\n\r\nThe beta distribution is commonly used to study variation in the percentage of something across samples, such as the fraction of the day people spend watching television.\r\n\r\n## Syntax\r\n\r\n`beta_cdf(`*x*`, `*alpha*`, `*beta*`)`\r\n\r\n## Arguments\r\n\r\n* *x*: A value at which to evaluate the function.\r\n* *alpha*: A parameter of the distribution.\r\n* *beta*: A parameter of the distribution.\r\n\r\n## Returns\r\n\r\n* The [cumulative beta distribution function](https://en.wikipedia.org/wiki/Beta_distribution#Cumulative_distribution_function).\r\n\r\n**Notes**\r\n\r\nIf any argument is nonnumeric, beta_cdf() returns null value.\r\n\r\nIf x < 0 or x > 1, beta_cdf() returns NaN value.\r\n\r\nIf alpha ≤ 0 or alpha > 10000, beta_cdf() returns the NaN value.\r\n\r\nIf beta ≤ 0 or beta > 10000, beta_cdf() returns the NaN value.",'```\r\ndatatable(x:double, alpha:double, beta:double, comment:string)\r\n[\r\n    0.9, 10.0, 20.0, "Valid input",\r\n    1.5, 10.0, 20.0, "x > 1, yields NaN",\r\n    double(-10), 10.0, 20.0, "x < 0, yields NaN",\r\n    0.1, double(-1.0), 20.0, "alpha is < 0, yields NaN"\r\n]\r\n| extend b = beta_cdf(x, alpha, beta)\r\n```\r\n\r\n|x|alpha|beta|comment|b|\r\n|---|---|---|---|---|\r\n|0.9|10|20|Valid input|0.999999999999959|\r\n|1.5|10|20|x > 1, yields NaN|NaN|\r\n|-10|10|20|x < 0, yields NaN|NaN|\r\n|0.1|-1|20|alpha is < 0, yields NaN|NaN|\r\n\r\n## See also\r\n\r\n* For computing the inverse of the beta cumulative probability density function, see [beta-inv()](./beta-invfunction.md).\r\n* For computing probability density function, see [beta-pdf()](./beta-pdffunction.md).',"https://docs.microsoft.com/en-us/azure/kusto/query/beta-cdffunction","beta-cdffunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"beta_inv","Returns the inverse of the beta cumulative probability beta density function.","```\r\nbeta_inv(0.1, 10.0, 50.0)\r\n```\r\n\r\nIf *probability* = `beta_cdf(`*x*,...`)`, then `beta_inv(`*probability*,...`)` = *x*. \r\n\r\nThe beta distribution can be used in project planning to model probable completion times given an expected completion time and variability.\r\n\r\n## Syntax\r\n\r\n`beta_inv(`*probability*`, `*alpha*`, `*beta*`)`\r\n\r\n## Arguments\r\n\r\n* *probability*: A probability associated with the beta distribution.\r\n* *alpha*: A parameter of the distribution.\r\n* *beta*: A parameter of the distribution.\r\n\r\n## Returns\r\n\r\n* The inverse of the beta cumulative probability density function [beta_cdf()](./beta-cdffunction.md)\r\n\r\n**Notes**\r\n\r\nIf any argument is nonnumeric, beta_inv() returns null value.\r\n\r\nIf alpha ≤ 0 or beta ≤ 0, beta_inv() returns the null value.\r\n\r\nIf probability ≤ 0 or probability > 1, beta_inv() returns the NaN value.\r\n\r\nGiven a value for probability, beta_inv() seeks that value x such that beta_cdf(x, alpha, beta) = probability.",'```\r\ndatatable(p:double, alpha:double, beta:double, comment:string)\r\n[\r\n    0.1, 10.0, 20.0, "Valid input",\r\n    1.5, 10.0, 20.0, "p > 1, yields null",\r\n    0.1, double(-1.0), 20.0, "alpha is < 0, yields NaN"\r\n]\r\n| extend b = beta_inv(p, alpha, beta)\r\n```\r\n\r\n|p|alpha|beta|comment|b|\r\n|---|---|---|---|---|\r\n|0.1|10|20|Valid input|0.226415022388749|\r\n|1.5|10|20|p > 1, yields null||\r\n|0.1|-1|20|alpha is < 0, yields NaN|NaN|\r\n\r\n## See also\r\n\r\n* For computing cumulative beta distribution function, see [beta-cdf()](./beta-cdffunction.md).\r\n* For computing probability beta density function, see [beta-pdf()](./beta-pdffunction.md).',"https://docs.microsoft.com/en-us/azure/kusto/query/beta-invfunction","beta-invfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"beta_pdf","Returns the probability density beta function.","```\r\nbeta_pdf(0.2, 10.0, 50.0)\r\n```\r\n\r\nThe beta distribution is commonly used to study variation in the percentage of something across samples, such as the fraction of the day people spend watching television.\r\n\r\n## Syntax\r\n\r\n`beta_pdf(`*x*`, `*alpha*`, `*beta*`)`\r\n\r\n## Arguments\r\n\r\n* *x*: A value at which to evaluate the function.\r\n* *alpha*: A parameter of the distribution.\r\n* *beta*: A parameter of the distribution.\r\n\r\n## Returns\r\n\r\n* The [probability beta density function](https://en.wikipedia.org/wiki/Beta_distribution#Probability_density_function).\r\n\r\n**Notes**\r\n\r\nIf any argument is nonnumeric, beta_pdf() returns null value.\r\n\r\nIf x ≤ 0 or 1 ≤ x, beta_pdf() returns NaN value.\r\n\r\nIf alpha ≤ 0 or beta ≤ 0, beta_pdf() returns the NaN value.",'```\r\ndatatable(x:double, alpha:double, beta:double, comment:string)\r\n[\r\n    0.5, 10.0, 20.0, "Valid input",\r\n    1.5, 10.0, 20.0, "x > 1, yields NaN",\r\n    double(-10), 10.0, 20.0, "x < 0, yields NaN",\r\n    0.1, double(-1.0), 20.0, "alpha is < 0, yields NaN"\r\n]\r\n| extend r = beta_pdf(x, alpha, beta)\r\n```\r\n\r\n|x|alpha|beta|comment|r|\r\n|---|---|---|---|---|\r\n|0.5|10|20|Valid input|0.746176019310951|\r\n|1.5|10|20|x > 1, yields NaN|NaN|\r\n|-10|10|20|x < 0, yields NaN|NaN|\r\n|0.1|-1|20|alpha is < 0, yields NaN|NaN|\r\n\r\n**References**\r\n\r\n* For computing the inverse of the beta cumulative probability density function, see [beta-inv()](./beta-invfunction.md).\r\n* For the standard cumulative beta distribution function, see [beta-cdf()](./beta-cdffunction.md).',"https://docs.microsoft.com/en-us/azure/kusto/query/beta-pdffunction","beta-pdffunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.OperatorToken,"between","Matches the input that is inside the inclusive range.","```\r\nTable1 | where Num1 between (1 .. 10)\r\nTable1 | where Time between (datetime(2017-01-01) .. datetime(2017-01-01))\r\n```\r\n\r\n`between` can operate on any numeric, datetime, or timespan expression.\r\n\r\n## Syntax\r\n\r\n*T* `|` `where` *expr* `between` `(`*leftRange*` .. `*rightRange*`)`   \r\n\r\nIf *expr* expression is datetime - another syntactic sugar syntax is provided:\r\n\r\n*T* `|` `where` *expr* `between` `(`*leftRangeDateTime*` .. `*rightRangeTimespan*`)`   \r\n\r\n## Arguments\r\n\r\n* *T* - The tabular input whose records are to be matched.\r\n* *expr* - the expression to filter.\r\n* *leftRange* - expression of the left range (inclusive).\r\n* *rightRange* - expression of the right range (inclusive).\r\n\r\n## Returns\r\n\r\nRows in *T* for which the predicate of (*expr* >= *leftRange* and *expr* <= *rightRange*) evaluates to `true`.","**Filtering numeric values using 'between' operator**  \r\n\r\n```\r\nrange x from 1 to 100 step 1\r\n| where x between (50 .. 55)\r\n```\r\n\r\n|x|\r\n|---|\r\n|50|\r\n|51|\r\n|52|\r\n|53|\r\n|54|\r\n|55|\r\n\r\n**Filtering datetime using 'between' operator**  \r\n\r\n```\r\nStormEvents\r\n| where StartTime between (datetime(2007-07-27) .. datetime(2007-07-30))\r\n| count \r\n```\r\n\r\n|Count|\r\n|---|\r\n|476|\r\n\r\n```\r\nStormEvents\r\n| where StartTime between (datetime(2007-07-27) .. 3d)\r\n| count \r\n```\r\n\r\n|Count|\r\n|---|\r\n|476|","https://docs.microsoft.com/en-us/azure/kusto/query/betweenoperator","betweenoperator.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"bin","Rounds values down to an integer multiple of a given bin size.",'Used frequently in combination with [`summarize by ...`](./summarizeoperator.md).\r\nIf you have a scattered set of values, they will be grouped into a smaller set of specific values.\r\n\r\nNull values, a null bin size, or a negative bin size will result in null. \r\n\r\nAlias to `floor()` function.\r\n\r\n## Syntax\r\n\r\n`bin(`*value*`,`*roundTo*`)`\r\n\r\n## Arguments\r\n\r\n* *value*: A number, date, or timespan. \r\n* *roundTo*: The "bin size". A number or timespan that divides *value*. \r\n\r\n## Returns\r\n\r\nThe nearest multiple of *roundTo* below *value*.  \r\n\r\n```\r\n(toint((value/roundTo))) * roundTo`\r\n```',"Expression | Result\r\n---|---\r\n`bin(4.5, 1)` | `4.0`\r\n`bin(time(16d), 7d)` | `14d`\r\n`bin(datetime(1970-05-11 13:45:07), 1d)`|  `datetime(1970-05-11)`\r\n\r\nThe following expression calculates a histogram of durations,\r\nwith a bucket size of 1 second:\r\n\r\n```\r\nT | summarize Hits=count() by bin(Duration, 1s)\r\n```","https://docs.microsoft.com/en-us/azure/kusto/query/binfunction","binfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"bin_at",'Rounds values down to a fixed-size "bin", with control over the bin\'s starting point.\r\n(See also [`bin function`](./binfunction.md).)','## Syntax\r\n\r\n`bin_at` `(`*Expression*`,` *BinSize*`, ` *FixedPoint*`)`\r\n\r\n## Arguments\r\n\r\n* *Expression*: A scalar expression of a numeric type (including `datetime` and `timespan`)\r\n  indicating the value to round.\r\n* *BinSize*: A scalar constant of a numeric type or `timespan` (for a `datetime` or `timespan` *Expression*) indicating\r\n  the size of each bin.\r\n* *FixedPoint*: A scalar constant of the same type as *Expression* indicating\r\n  one value of *Expression* which is a "fixed point" (that is, a value `fixed_point`\r\n  for which `bin_at(fixed_point, bin_size, fixed_point) == fixed_point`.)\r\n\r\n## Returns\r\n\r\nThe nearest multiple of *BinSize* below *Expression*, shifted so that *FixedPoint*\r\nwill be translated into itself.','|Expression                                                                    |Result                           |Comments                   |\r\n|------------------------------------------------------------------------------|---------------------------------|---------------------------|\r\n|`bin_at(6.5, 2.5, 7)`                                                         |`4.5`                            ||\r\n|`bin_at(time(1h), 1d, 12h)`                                                   |`-12h`                           ||\r\n|`bin_at(datetime(2017-05-15 10:20:00.0), 1d, datetime(1970-01-01 12:00:00.0))`|`datetime(2017-05-14 12:00:00.0)`|All bins will be at noon   |\r\n|`bin_at(datetime(2017-05-17 10:20:00.0), 7d, datetime(2017-06-04 00:00:00.0))`|`datetime(2017-05-14 00:00:00.0)`|All bins will be on Sundays|\r\n\r\nIn the following example, notice that the `"fixed point"` arg is returned as one of the bins and the other bins are aligned to it based on the `bin_size`. Also note that each datetime bin represents the starting time of that bin:\r\n\r\n```\r\n\r\ndatatable(Date:datetime, Num:int)[\r\ndatetime(2018-02-24T15:14),3,\r\ndatetime(2018-02-23T16:14),4,\r\ndatetime(2018-02-26T15:14),5]\r\n| summarize sum(Num) by bin_at(Date, 1d, datetime(2018-02-24 15:14:00.0000000)) \r\n```\r\n\r\n|Date|sum_Num|\r\n|---|---|\r\n|2018-02-23 15:14:00.0000000|4|\r\n|2018-02-24 15:14:00.0000000|3|\r\n|2018-02-26 15:14:00.0000000|5|',"https://docs.microsoft.com/en-us/azure/kusto/query/binatfunction","binatfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"bin_auto",'Rounds values down to a fixed-size "bin", with control over the bin size and starting point provided by a query property.','## Syntax\r\n\r\n`bin_auto` `(` *Expression* `)`\r\n\r\n## Arguments\r\n\r\n* *Expression*: A scalar expression of a numeric type indicating the value to round.\r\n\r\n**Client Request Properties**\r\n\r\n* `query_bin_auto_size`: A numeric literal indicating the size of each bin.\r\n* `query_bin_auto_at`: A numeric literal indicating one value of *Expression* which is a "fixed point" (that is, a value `fixed_point`\r\n  for which `bin_auto(fixed_point)` == `fixed_point`.)\r\n\r\n## Returns\r\n\r\nThe nearest multiple of `query_bin_auto_at` below *Expression*, shifted so that `query_bin_auto_at`\r\nwill be translated into itself.',"```\r\nset query_bin_auto_size=1h;\r\nset query_bin_auto_at=datetime(2017-01-01 00:05);\r\nrange Timestamp from datetime(2017-01-01 00:05) to datetime(2017-01-01 02:00) step 1m\r\n| summarize count() by bin_auto(Timestamp)\r\n```\r\n\r\n|Timestamp                    | count_|\r\n|-----------------------------|-------|\r\n|2017-01-01 00:05:00.0000000  | 60    |\r\n|2017-01-01 01:05:00.0000000  | 56    |","https://docs.microsoft.com/en-us/azure/kusto/query/bin-autofunction","bin-autofunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"binary_all_and","Accumulates values using the binary `AND` operation per summarization group (or in total, if summarization is done without grouping).","* Can be used only in context of aggregation inside [summarize](summarizeoperator.md)\r\n\r\n## Syntax\r\n\r\nsummarize `binary_all_and(`*Expr*`)`\r\n\r\n## Arguments\r\n\r\n* *Expr*: long number.\r\n\r\n## Returns\r\n\r\nReturns a value that is aggregated using the binary `AND` operation over records per summarization group (or in total, if summarization is done without grouping).","Producing 'cafe-food' using binary `AND` operations:\r\n\r\n```\r\ndatatable(num:long)\r\n[\r\n  0xFFFFFFFF, \r\n  0xFFFFF00F,\r\n  0xCFFFFFFD,\r\n  0xFAFEFFFF,\r\n]\r\n| summarize result = toupper(tohex(binary_all_and(num)))\r\n```\r\n\r\n|result|\r\n|---|\r\n|CAFEF00D|","https://docs.microsoft.com/en-us/azure/kusto/query/binary-all-and-aggfunction","binary-all-and-aggfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"binary_all_or","Accumulates values using the binary `OR` operation per summarization group (or in total, if summarization is done without grouping).","* Can be used only in context of aggregation inside [summarize](summarizeoperator.md)\r\n\r\n## Syntax\r\n\r\nsummarize `binary_all_or(`*Expr*`)`\r\n\r\n## Arguments\r\n\r\n* *Expr*: long number.\r\n\r\n## Returns\r\n\r\nReturns a value that is aggregated using the binary `OR` operation over records per summarization group (or in total, if summarization is done without grouping).","Producing 'cafe-food' using binary `OR` operations:\r\n\r\n```\r\ndatatable(num:long)\r\n[\r\n  0x88888008,\r\n  0x42000000,\r\n  0x00767000,\r\n  0x00000005, \r\n]\r\n| summarize result = toupper(tohex(binary_all_or(num)))\r\n```\r\n\r\n|result|\r\n|---|\r\n|CAFEF00D|","https://docs.microsoft.com/en-us/azure/kusto/query/binary-all-or-aggfunction","binary-all-or-aggfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"binary_all_xor","Accumulates values using the binary `XOR` operation per summarization group (or in total, if summarization is done without grouping).","* Can be used only in context of aggregation inside [summarize](summarizeoperator.md)\r\n\r\n## Syntax\r\n\r\nsummarize `binary_all_xor(`*Expr*`)`\r\n\r\n## Arguments\r\n\r\n* *Expr*: long number.\r\n\r\n## Returns\r\n\r\nReturns a value that is aggregated using the binary `XOR` operation over records per summarization group (or in total, if summarization is done without grouping).","Producing 'cafe-food' using binary `XOR` operations:\r\n\r\n```\r\ndatatable(num:long)\r\n[\r\n  0x44404440,\r\n  0x1E1E1E1E,\r\n  0x90ABBA09,\r\n  0x000B105A,\r\n]\r\n| summarize result = toupper(tohex(binary_all_xor(num)))\r\n```\r\n\r\n|result|\r\n|---|\r\n|CAFEF00D|","https://docs.microsoft.com/en-us/azure/kusto/query/binary-all-xor-aggfunction","binary-all-xor-aggfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"binary_and","Returns a result of the bitwise `and` operation between two values.","```\r\nbinary_and(x,y)\t\r\n```\r\n\r\n## Syntax\r\n\r\n`binary_and(`*num1*`,` *num2* `)`\r\n\r\n## Arguments\r\n\r\n* *num1*, *num2*: long numbers.\r\n\r\n## Returns\r\n\r\nReturns logical AND operation on a pair of numbers: num1 & num2.","","https://docs.microsoft.com/en-us/azure/kusto/query/binary-andfunction","")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"binary_not","Returns a bitwise negation of the input value.","```\r\nbinary_not(x)\r\n```\r\n\r\n## Syntax\r\n\r\n`binary_not(`*num1*`)`\r\n\r\n## Arguments\r\n\r\n* *num1*: numeric \r\n\r\n## Returns\r\n\r\nReturns logical NOT operation on a number: num1.","","https://docs.microsoft.com/en-us/azure/kusto/query/binary-notfunction","")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"binary_or","Returns a result of the bitwise `or` operation of the two values.","```\r\nbinary_or(x,y)\r\n```\r\n\r\n## Syntax\r\n\r\n`binary_or(`*num1*`,` *num2* `)`\r\n\r\n## Arguments\r\n\r\n* *num1*, *num2*: long numbers.\r\n\r\n## Returns\r\n\r\nReturns logical OR operation on a pair of numbers: num1 | num2.","","https://docs.microsoft.com/en-us/azure/kusto/query/binary-orfunction","")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"binary_shift_left","Returns binary shift left operation on a pair of numbers.","```\r\nbinary_shift_left(x,y)\t\r\n```\r\n\r\n## Syntax\r\n\r\n`binary_shift_left(`*num1*`,` *num2* `)`\r\n\r\n## Arguments\r\n\r\n* *num1*, *num2*: int numbers.\r\n\r\n## Returns\r\n\r\nReturns binary shift left operation on a pair of numbers: num1 << (num2%64).\r\nIf n is negative a NULL value is returned.","","https://docs.microsoft.com/en-us/azure/kusto/query/binary-shift-leftfunction","")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"binary_shift_right","Returns binary shift right operation on a pair of numbers.","```\r\nbinary_shift_right(x,y)\t\r\n```\r\n\r\n## Syntax\r\n\r\n`binary_shift_right(`*num1*`,` *num2* `)`\r\n\r\n## Arguments\r\n\r\n* *num1*, *num2*: long numbers.\r\n\r\n## Returns\r\n\r\nReturns binary shift right operation on a pair of numbers: num1 >> (num2%64).\r\nIf n is negative a NULL value is returned.","","https://docs.microsoft.com/en-us/azure/kusto/query/binary-shift-rightfunction","")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"binary_xor","Returns a result of the bitwise `xor` operation of the two values.","```\r\nbinary_xor(x,y)\r\n```\r\n\r\n## Syntax\r\n\r\n`binary_xor(`*num1*`,` *num2* `)`\r\n\r\n## Arguments\r\n\r\n* *num1*, *num2*: long numbers.\r\n\r\n## Returns\r\n\r\nReturns logical XOR operation on a pair of numbers: num1 ^ num2.","","https://docs.microsoft.com/en-us/azure/kusto/query/binary-xorfunction","")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"bitset_count_ones","Returns the number of set bits in the binary representation of a number.","```\r\nbitset_count_ones(42)\r\n```\r\n\r\n## Syntax\r\n\r\n`bitset_count_ones(`*num1*``)`\r\n\r\n## Arguments\r\n\r\n* *num1*: long or integer number.\r\n\r\n## Returns\r\n\r\nReturns the number of set bits in the binary representation of a number.","```\r\n// 42 = 32+8+2 : b'00101010' == 3 bits set\r\nprint ones = bitset_count_ones(42) \r\n```\r\n\r\n|ones|\r\n|---|\r\n|3|","https://docs.microsoft.com/en-us/azure/kusto/query/bitset-count-onesfunction","bitset-count-onesfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"buildschema","Returns the minimal schema that admits all values of *DynamicExpr*.","* Can be used only in context of aggregation, inside [summarize](summarizeoperator.md)\r\n\r\n## Syntax\r\n\r\nsummarize `buildschema(`*DynamicExpr*`)`\r\n\r\n## Arguments\r\n\r\n* *DynamicExpr*: Expression that is used for the aggregation calculation. The parameter column type must be `dynamic`. \r\n\r\n## Returns\r\n\r\nThe maximum value of *`Expr`* across the group.\r\n\r\n> [!TIP] \r\n> If `buildschema(json_column)` gives a syntax error:\r\n>\r\n> > *Is your `json_column` a string rather than a dynamic object?*\r\n>\r\n> then use `buildschema(parsejson(json_column))`.",'Assume the input column has three dynamic values.\r\n\r\n||\r\n|---|\r\n|`{"x":1, "y":3.5}`|\r\n|`{"x":"somevalue", "z":[1, 2, 3]}`|\r\n|`{"y":{"w":"zzz"}, "t":["aa", "bb"], "z":["foo"]}`|\r\n||\r\n\r\nThe resulting schema would be:\r\n\r\n```\r\n{ \r\n    "x":["int", "string"],\r\n    "y":["double", {"w": "string"}],\r\n    "z":{"`indexer`": ["int", "string"]},\r\n    "t":{"`indexer`": "string"}\r\n}\r\n```\r\n\r\nThe schema tells us that:\r\n\r\n* The root object is a container with four properties named x, y, z, and t.\r\n* The property called "x" that could be of type "int" or of type "string".\r\n* The property called "y" that could be of type "double", or another container with a property called "w" of type "string".\r\n* The ``indexer`` keyword indicates that "z" and "t" are arrays.\r\n* Each item in the array "z" is of type "int" or of type "string".\r\n* "t" is an array of strings.\r\n* Every property is implicitly optional, and any array may be empty.\r\n\r\n\r\n### Schema model\r\n\r\nThe syntax of the returned schema is:\r\n\r\n```output\r\nContainer ::= \'{\' Named-type* \'}\';\r\nNamed-type ::= (name | \'"`indexer`"\') \':\' Type;\r\nType ::= Primitive-type | Union-type | Container;\r\nUnion-type ::= \'[\' Type* \']\';\r\nPrimitive-type ::= "int" | "string" | ...;\r\n```\r\n\r\nThe values are equivalent to a subset of the TypeScript type annotations, encoded as a Kusto dynamic value. \r\nIn Typescript, the example schema would be:\r\n\r\n```typescript\r\nvar someobject: \r\n{\r\n    x?: (number | string),\r\n    y?: (number | { w?: string}),\r\n    z?: { [n:number] : (int | string)},\r\n    t?: { [n:number]: string }\r\n}\r\n```',"https://docs.microsoft.com/en-us/azure/kusto/query/buildschema-aggfunction","buildschema-aggfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"case","Evaluates a list of predicates and returns the first result expression whose predicate is satisfied.","If neither of the predicates return `true`, the result of the last expression (the `else`) is returned.\r\nAll odd arguments (count starts at 1) must be expressions that evaluate to a  `boolean` value.\r\nAll even arguments (the `then`s) and the last argument (the `else`) must be of the same type.\r\n\r\n## Syntax\r\n\r\n`case(`*predicate_1*`,` *then_1*,\r\n       *predicate_2*`,` *then_2*,\r\n       *predicate_3*`,` *then_3*,\r\n       *else*`)`\r\n\r\n## Arguments\r\n\r\n* *predicate_i*: An expression that evaluates to a `boolean` value.\r\n* *then_i*: An expression that gets evaluated and its value is returned from the function if *predicate_i* is the first predicate that evaluates to `true`.\r\n* *else*: An expression that gets evaluated and its value is returned from the function if neither of the *predicate_i* evaluate to `true`.\r\n\r\n## Returns\r\n\r\nThe value of the first *then_i* whose *predicate_i* evaluates to `true`, or the value of *else* if neither of the predicates are satisfied.",'```\r\nrange Size from 1 to 15 step 2\r\n| extend bucket = case(Size <= 3, "Small", \r\n                       Size <= 10, "Medium", \r\n                       "Large")\r\n```\r\n\r\n|Size|bucket|\r\n|---|---|\r\n|1|Small|\r\n|3|Small|\r\n|5|Medium|\r\n|7|Medium|\r\n|9|Medium|\r\n|11|Large|\r\n|13|Large|\r\n|15|Large|',"https://docs.microsoft.com/en-us/azure/kusto/query/casefunction","casefunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"ceiling","Calculates the smallest integer greater than, or equal to, the specified numeric expression.","## Syntax\r\n\r\n`ceiling(`*x*`)`\r\n\r\n## Arguments\r\n\r\n* *x*: A real number.\r\n\r\n## Returns\r\n\r\n* The smallest integer greater than, or equal to, the specified numeric expression.","```\r\nprint c1 = ceiling(-1.1), c2 = ceiling(0), c3 = ceiling(0.9)\r\n```\r\n\r\n|c1|c2|c3|\r\n|---|---|---|\r\n|-1|0|1|","https://docs.microsoft.com/en-us/azure/kusto/query/ceilingfunction","ceilingfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"cluster","Changes the reference of the query to a remote cluster.","```\r\ncluster('help').database('Sample').SomeTable\r\n```\r\n\r\n## Syntax\r\n\r\n`cluster(`*stringConstant*`)`\r\n\r\n## Arguments\r\n\r\n* *stringConstant*: Name of the cluster that is referenced. Cluster name can be either \r\na fully qualified DNS name, or a string that will be suffixed with `.kusto.windows.net`. Argument has to be _constant_ prior to the query's execution,\r\ni.e. cannot come from sub-query evaluation.\r\n\r\n**Notes**\r\n\r\n* For accessing database within the same cluster - use [database()](databasefunction.md) function.\r\n* More information about cross-cluster and cross-database queries available [here](cross-cluster-or-database-queries.md)","### Use cluster() to access remote cluster \r\n\r\nThe next query can be run on any of the Kusto clusters.\r\n\r\n```\r\ncluster('help').database('Samples').StormEvents | count\r\n\r\ncluster('help.kusto.windows.net').database('Samples').StormEvents | count  \r\n```\r\n\r\n|Count|\r\n|---|\r\n|59066|\r\n\r\n### Use cluster() inside let statements \r\n\r\nThe same query as above can be rewritten to use inline function (let statement) that \r\nreceives a parameter `clusterName` - which is passed into the cluster() function.\r\n\r\n```\r\nlet foo = (clusterName:string)\r\n{\r\n    cluster(clusterName).database('Samples').StormEvents | count\r\n};\r\nfoo('help')\r\n```\r\n\r\n|Count|\r\n|---|\r\n|59066|\r\n\r\n### Use cluster() inside Functions \r\n\r\nThe same query as above can be rewritten to be used in a function that \r\nreceives a parameter `clusterName` - which is passed into the cluster() function.\r\n\r\n```\r\n.create function foo(clusterName:string)\r\n{\r\n    cluster(clusterName).database('Samples').StormEvents | count\r\n};\r\n```\r\n\r\n**Note:** such functions can be used only locally and not in the cross-cluster query.","https://docs.microsoft.com/en-us/azure/kusto/query/clusterfunction","clusterfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"coalesce","Evaluates a list of expressions and returns the first non-null (or non-empty for string) expression.",'```\r\ncoalesce(tolong("not a number"), tolong("42"), 33) == 42\r\n```\r\n\r\n## Syntax\r\n\r\n`coalesce(`*expr_1*`, `*expr_2*`,` ...)\r\n\r\n## Arguments\r\n\r\n* *expr_i*: A scalar expression, to be evaluated.\r\n\r\n- All arguments must be of the same type.\r\n- Maximum of 64 arguments is supported.\r\n\r\n\r\n## Returns\r\n\r\nThe value of the first *expr_i* whose value is not null (or not-empty for string expressions).','```\r\nprint result=coalesce(tolong("not a number"), tolong("42"), 33)\r\n```\r\n\r\n|result|\r\n|---|\r\n|42|',"https://docs.microsoft.com/en-us/azure/kusto/query/coalescefunction","coalescefunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.OperatorToken,"consume","Consumes the tabular data stream handed to the operator.","The `consume` operator is mostly used for triggering the query side-effect without actually returning\r\nthe results back to the caller.\r\n\r\n```\r\nT | consume\r\n```\r\n\r\n## Syntax\r\n\r\n`consume` [`decodeblocks` `=` *DecodeBlocks*]\r\n\r\n## Arguments\r\n\r\n* *DecodeBlocks*: A constant Boolean value. If set to `true`, or if the request\r\n  property `perftrace` is set to `true`, the `consume` operator will not just\r\n  enumerate the records at its input, but actually force each value in those\r\n  records to be decompressed and decoded.\r\n\r\nThe `consume` operator can be used for estimating the\r\ncost of a query without actually delivering the results back to the client.\r\n(The estimation is not exact for a variety of reasons; for example, `consume`\r\nis calculated distributively, so `T | consume` will not transmit the table's\r\ndata between the nodes of the cluster.)\r\n\r\n\x3c!--\r\n* *WithStats*: A constant Boolean value. If set to `true` (or if the global\r\n  property `perftrace` is set), the operator will return a single\r\n  row with a single column called `Stats` of type `dynamic` holding the statistics\r\n  of the data source fed to the `consume` operator.\r\n--\x3e","","https://docs.microsoft.com/en-us/azure/kusto/query/consumeoperator","")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"cos","Returns the cosine function.","## Syntax\r\n\r\n`cos(`*x*`)`\r\n\r\n## Arguments\r\n\r\n* *x*: A real number.\r\n\r\n## Returns\r\n\r\n* The result of `cos(x)`","","https://docs.microsoft.com/en-us/azure/kusto/query/cosfunction","")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"cot","Calculates the trigonometric cotangent of the specified angle, in radians.","## Syntax\r\n\r\n`cot(`*x*`)`\r\n\r\n## Arguments\r\n\r\n* *x*: A real number.\r\n\r\n## Returns\r\n\r\n* The cotangent function value for `x`","","https://docs.microsoft.com/en-us/azure/kusto/query/cotfunction","")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"count","Returns a count of the records per summarization group (or in total, if summarization is done without grouping).","* Can be used only in context of aggregation inside [summarize](summarizeoperator.md)\r\n* Use the [countif](countif-aggfunction.md) aggregation function\r\n  to count only records for which some predicate returns `true`.\r\n\r\n## Syntax\r\n\r\nsummarize `count()`\r\n\r\n## Returns\r\n\r\nReturns a count of the records per summarization group (or in total, if summarization is done without grouping).",'Counting events in states starting with letter `W`:\r\n\r\n```\r\nStormEvents\r\n| where State startswith "W"\r\n| summarize Count=count() by State\r\n```\r\n\r\n|State|Count|\r\n|---|---|\r\n|WEST VIRGINIA|757|\r\n|WYOMING|396|\r\n|WASHINGTON|261|\r\n|WISCONSIN|1850|',"https://docs.microsoft.com/en-us/azure/kusto/query/count-aggfunction","count-aggfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.OperatorToken,"count","Returns the number of records in the input record set.","## Syntax\r\n\r\n`T | count`\r\n\r\n## Arguments\r\n\r\n*T*: The tabular data whose records are to be counted.\r\n\r\n## Returns\r\n\r\nThis function returns a table with a single record and column of type\r\n`long`. The value of the only cell is the number of records in *T*.","```\r\nStormEvents | count\r\n```","https://docs.microsoft.com/en-us/azure/kusto/query/countoperator","countoperator.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"countif","Returns a count of rows for which *Predicate* evaluates to `true`. Can only be used only in context of aggregation inside [summarize](summarizeoperator.md).","## Syntax\r\n\r\nsummarize `countif(`*Predicate*`)`\r\n\r\n## Arguments\r\n\r\n*Predicate*: Expression that will be used for aggregation calculation. *Predicate* can be any scalar expression with return type of bool (evaluating to true/false).\r\n\r\n## Returns\r\n\r\nReturns a count of rows for which *Predicate* evaluates to `true`.",'```\r\nlet T = datatable(name:string, day_of_birth:long)\r\n[\r\n   "John", 9,\r\n   "Paul", 18,\r\n   "George", 25,\r\n   "Ringo", 7\r\n];\r\nT\r\n| summarize countif(strlen(name) > 4)\r\n```\r\n\r\n|countif_|\r\n|----|\r\n|2|\r\n\r\n## See also\r\n\r\n[count()](count-aggfunction.md) function, which counts rows without predicate expression.',"https://docs.microsoft.com/en-us/azure/kusto/query/countif-aggfunction","countif-aggfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"countof","Counts occurrences of a substring in a string. Plain string matches may overlap; regex matches do not.",'```\r\ncountof("The cat sat on the mat", "at") == 3\r\ncountof("The cat sat on the mat", @"\\b.at\\b", "regex") == 3\r\n```\r\n\r\n## Syntax\r\n\r\n`countof(`*text*`,` *search* [`,` *kind*]`)`\r\n\r\n## Arguments\r\n\r\n* *text*: A string.\r\n* *search*: The plain string or [regular expression](./re2.md) to match inside *text*.\r\n* *kind*: `"normal"|"regex"` Default `normal`. \r\n\r\n## Returns\r\n\r\nThe number of times that the search string can be matched in the container. Plain string matches may overlap; regex matches do not.','|Function call|Result|\r\n|---|---\r\n|`countof("aaa", "a")`| 3 \r\n|`countof("aaaa", "aa")`| 3 (not 2!)\r\n|`countof("ababa", "ab", "normal")`| 2\r\n|`countof("ababa", "aba")`| 2\r\n|`countof("ababa", "aba", "regex")`| 1\r\n|`countof("abcabc", "a.c", "regex")`| 2',"https://docs.microsoft.com/en-us/azure/kusto/query/countoffunction","countoffunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"current_cluster_endpoint","Returns the network endpoint (DNS name) of the current cluster being queried.","## Syntax\r\n\r\n`current_cluster_endpoint()`\r\n\r\n## Returns\r\n\r\nThe network endpoint (DNS name) of the current cluster being queried,\r\nas a value of type `string`.",'```\r\nprint strcat("This query executed on: ", current_cluster_endpoint())\r\n```',"https://docs.microsoft.com/en-us/azure/kusto/query/current-cluster-endpoint-function","current-cluster-endpoint-function.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"current_database","Returns the name of the database in scope (database that all query\r\nentities are resolved against if no other database is specified).","## Syntax\r\n\r\n`current_database()`\r\n\r\n## Returns\r\n\r\nThe name of the database in scope as a value of type `string`.",'```\r\nprint strcat("Database in scope: ", current_database())\r\n```',"https://docs.microsoft.com/en-us/azure/kusto/query/current-database-function","current-database-function.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"current_principal","Returns the current principal name that runs the query.","## Syntax\r\n\r\n`current_principal()`\r\n\r\n## Returns\r\n\r\nThe current principal fully qualified name (FQN) as a `string`.  \r\nThe string format is:  \r\n*PrinciplaType*`=`*PrincipalId*`;`*TenantId*","```\r\nprint fqn=current_principal()\r\n```\r\n\r\n|fqn|\r\n|---|\r\n|aaduser=346e950e-4a62-42bf-96f5-4cf4eac3f11e;72f988bf-86f1-41af-91ab-2d7cd011db47|","https://docs.microsoft.com/en-us/azure/kusto/query/current-principalfunction","current-principalfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"current_principal_details","Returns details of the principal running the query.","## Syntax\r\n\r\n`current_principal_details()`\r\n\r\n## Returns\r\n\r\nThe details of the current principal as a `dynamic`.",'```\r\nprint d=current_principal_details()\r\n```\r\n\r\n|d|\r\n|---|\r\n|{<br>  "UserPrincipalName": "user@fabrikam.com",<br>  "IdentityProvider": "https://sts.windows.net",<br>  "Authority": "72f988bf-86f1-41af-91ab-2d7cd011db47",<br>  "Mfa": "True",<br>  "Type": "AadUser",<br>  "DisplayName": "James Smith (upn: user@fabrikam.com)",<br>  "ObjectId": "346e950e-4a62-42bf-96f5-4cf4eac3f11e",<br>  "FQN": null,<br>  "Notes": null<br>}|',"https://docs.microsoft.com/en-us/azure/kusto/query/current-principal-detailsfunction","current-principal-detailsfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"current_principal_is_member_of","Checks group membership or principal identity of the current principal running the query.","```\r\nprint current_principal_is_member_of(\r\n    'aaduser=user1@fabrikam.com', \r\n    'aadgroup=group1@fabrikam.com',\r\n    'aadapp=66ad1332-3a94-4a69-9fa2-17732f093664;72f988bf-86f1-41af-91ab-2d7cd011db47'\r\n    )\r\n```\r\n\r\n## Syntax\r\n\r\n`current_principal_is_member_of`(`*list of string literals*`)\r\n\r\n## Arguments\r\n\r\n* *list of expressions* - a comma-separated list of string literals, where each literal is a principal fully qualified name (FQN) string formed as:  \r\n*PrinciplaType*`=`*PrincipalId*`;`*TenantId*\r\n\r\n| PrincipalType   | FQN Prefix  |\r\n|-----------------|-------------|\r\n| AAD User        | `aaduser=`  |\r\n| AAD Group       | `aadgroup=` |\r\n| AAD Application | `aadapp=`   |\r\n\r\n## Returns\r\n\r\nThe function returns:\r\n\r\n* `true`: if the current principal running the query was successfully matched for at least one input argument.\r\n* `false`: if the current principal running the query was not member of any `aadgroup=` FQN arguments and was not equal to any of the `aaduser=` or `aadapp=` FQN arguments.\r\n* `(null)`: if the current principal running the query was not member of any `aadgroup=` FQN arguments and was not equal to any of the `aaduser=` or `aadapp=` FQN arguments, and at least one FQN argument wasn't successfully resolved (wasn't  pressed in Azure AD). \r\n\r\n> [!NOTE]\r\n> Because the function returns a tri-state value (`true`, `false`,  and `null`), it's important to rely only on positive return values to confirm successful membership. In other words, the following expressions are NOT the same:\r\n> \r\n> * `where current_principal_is_member_of('non-existing-group')`\r\n> * `where current_principal_is_member_of('non-existing-group') != false`","```\r\nprint result=current_principal_is_member_of(\r\n    'aaduser=user1@fabrikam.com', \r\n    'aadgroup=group1@fabrikam.com',\r\n    'aadapp=66ad1332-3a94-4a69-9fa2-17732f093664;72f988bf-86f1-41af-91ab-2d7cd011db47'\r\n    )\r\n```\r\n\r\n| result |\r\n|--------|\r\n| (null) |\r\n\r\nUsing dynamic array instead of multiple arguments:\r\n\r\n```\r\nprint result=current_principal_is_member_of(\r\n    dynamic([\r\n    'aaduser=user1@fabrikam.com', \r\n    'aadgroup=group1@fabrikam.com',\r\n    'aadapp=66ad1332-3a94-4a69-9fa2-17732f093664;72f988bf-86f1-41af-91ab-2d7cd011db47'\r\n    ]))\r\n```\r\n\r\n| result |\r\n|--------|\r\n| (null) |","https://docs.microsoft.com/en-us/azure/kusto/query/current-principal-ismemberoffunction","current-principal-ismemberoffunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"cursor_after","A predicate over the records of a table to compare their ingestion time\r\nagainst a database cursor.","## Syntax\r\n\r\n`cursor_after` `(` *RHS* `)`\r\n\r\n## Arguments\r\n\r\n* *RHS*: Either an empty string literal, or a valid database cursor value.\r\n\r\n## Returns\r\n\r\nA scalar value of type `bool` that indicates whether the record was ingested\r\nafter the database cursor *RHS* (`true`) or not (`false`).\r\n\r\n**Notes**\r\n\r\nSee [database cursors](../management/databasecursor.md) for additional\r\ndetails on database cursors.\r\n\r\nThis function can only be invoked on records of a table which has the\r\n[IngestionTime policy](../management/ingestiontimepolicy.md) enabled.","","https://docs.microsoft.com/en-us/azure/kusto/query/cursorafterfunction","")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"cursor_before_or_at","A predicate over the records of a table to compare their ingestion time\r\nagainst a database cursor.","## Syntax\r\n\r\n`cursor_before_or_at` `(` *RHS* `)`\r\n\r\n## Arguments\r\n\r\n* *RHS*: Either an empty string literal, or a valid database cursor value.\r\n\r\n## Returns\r\n\r\nA scalar value of type `bool` that indicates whether the record was ingested\r\nbefore or at the database cursor *RHS* (`true`) or not (`false`).\r\n\r\n**Notes**\r\n\r\nSee [database cursors](../management/databasecursor.md) for additional\r\ndetails on database cursors.\r\n\r\nThis function can only be invoked on records of a table which has the\r\n[IngestionTime policy](../management/ingestiontimepolicy.md) enabled.","","https://docs.microsoft.com/en-us/azure/kusto/query/cursorbeforeoratfunction","")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"database","Changes the reference of the query to a specific database within the cluster scope.","```\r\ndatabase('Sample').StormEvents\r\ncluster('help').database('Sample').StormEvents\r\n```\r\n\r\n> [!NOTE]\r\n> * For more information, see [cross-database and cross-cluster queries](cross-cluster-or-database-queries.md).\r\n> * For accessing remote cluster and remote database, see [cluster()](clusterfunction.md) scope function.\r\n\r\n## Syntax\r\n\r\n`database(`*stringConstant*`)`\r\n\r\n## Arguments\r\n\r\n* *stringConstant*: Name of the database that is referenced. Database identified can be either `DatabaseName` or `PrettyName`. Argument has to be _constant_ prior of query execution, i.e. cannot come from sub-query evaluation.","### Use database() to access table of other database\r\n\r\n```\r\ndatabase('Samples').StormEvents | count\r\n```\r\n\r\n|Count|\r\n|---|\r\n|59066|\r\n\r\n### Use database() inside let statements \r\n\r\nThe same query as above can be rewritten to use inline function (let statement) that \r\nreceives a parameter `dbName` - which is passed into the database() function.\r\n\r\n```\r\nlet foo = (dbName:string)\r\n{\r\n    database(dbName).StormEvents | count\r\n};\r\nfoo('help')\r\n```\r\n\r\n|Count|\r\n|---|\r\n|59066|\r\n\r\n### Use database() inside functions \r\n\r\nThe same query as above can be rewritten to be used in a function that \r\nreceives a parameter `dbName` - which is passed into the database() function.\r\n\r\n```\r\n.create function foo(dbName:string)\r\n{\r\n    database(dbName).StormEvents | count\r\n};\r\n```\r\n\r\n> [!NOTE]\r\n> Such functions can be used only locally and not in the cross-cluster query.","https://docs.microsoft.com/en-us/azure/kusto/query/databasefunction","databasefunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.OperatorToken,"datatable","Returns a table whose schema and values are defined in the query itself.","> [!NOTE]\r\n> This operator doesn't have a pipeline input.\r\n\r\n## Syntax\r\n\r\n`datatable` `(` *ColumnName* `:` *ColumnType* [`,` ...] `)` `[` *ScalarValue* [`,` *ScalarValue* ...] `]`\r\n\r\n## Arguments\r\n\r\n* *ColumnName*, *ColumnType*: These arguments define the schema of the table. The arguments use the same syntax as used when defining a table.\r\n  For more information, see [.create table](../management/create-table-command.md)).\r\n* *ScalarValue*: A constant scalar value to insert into the table. The number of values\r\n  must be an integer multiple of the columns in the table. The *n*'th value\r\n  must have a type that corresponds to column *n* % *NumColumns*.\r\n\r\n\r\n## Returns\r\n\r\nThis operator returns a data table of the given schema and data.",'```\r\ndatatable (Date:datetime, Event:string)\r\n    [datetime(1910-06-11), "Born",\r\n     datetime(1930-01-01), "Enters Ecole Navale",\r\n     datetime(1953-01-01), "Published first book",\r\n     datetime(1997-06-25), "Died"]\r\n| where strlen(Event) > 4\r\n```',"https://docs.microsoft.com/en-us/azure/kusto/query/datatableoperator","datatableoperator.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"datetime_add","Calculates a new [datetime](./scalar-data-types/datetime.md) from a specified datepart multiplied by a specified amount, added to a specified [datetime](./scalar-data-types/datetime.md).","## Syntax\r\n\r\n`datetime_add(`*period*`,`*amount*`,`*datetime*`)`\r\n\r\n## Arguments\r\n\r\n* `period`: [string](./scalar-data-types/string.md). \r\n* `amount`: [integer](./scalar-data-types/int.md).\r\n* `datetime`: [datetime](./scalar-data-types/datetime.md) value.\r\n\r\nPossible values of *period*: \r\n\r\n- Year\r\n- Quarter\r\n- Month\r\n- Week\r\n- Day\r\n- Hour\r\n- Minute\r\n- Second\r\n- Millisecond\r\n- Microsecond\r\n- Nanosecond\r\n\r\n## Returns\r\n\r\nA date after a certain time/date interval has been added.","```\r\nprint  year = datetime_add('year',1,make_datetime(2017,1,1)),\r\nquarter = datetime_add('quarter',1,make_datetime(2017,1,1)),\r\nmonth = datetime_add('month',1,make_datetime(2017,1,1)),\r\nweek = datetime_add('week',1,make_datetime(2017,1,1)),\r\nday = datetime_add('day',1,make_datetime(2017,1,1)),\r\nhour = datetime_add('hour',1,make_datetime(2017,1,1)),\r\nminute = datetime_add('minute',1,make_datetime(2017,1,1)),\r\nsecond = datetime_add('second',1,make_datetime(2017,1,1))\r\n\r\n```\r\n\r\n|year|quarter|month|week|day|hour|minute|second|\r\n|---|---|---|---|---|---|---|---|\r\n|2018-01-01 00:00:00.0000000|2017-04-01 00:00:00.0000000|2017-02-01 00:00:00.0000000|2017-01-08 00:00:00.0000000|2017-01-02 00:00:00.0000000|2017-01-01 01:00:00.0000000|2017-01-01 00:01:00.0000000|2017-01-01 00:00:01.0000000|","https://docs.microsoft.com/en-us/azure/kusto/query/datetime-addfunction","datetime-addfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"datetime_diff","Calculates calendarian difference between two [datetime](./scalar-data-types/datetime.md) values.","## Syntax\r\n\r\n`datetime_diff(`*period*`,`*datetime_1*`,`*datetime_2*`)`\r\n\r\n## Arguments\r\n\r\n* `period`: `string`. \r\n* `datetime_1`: [datetime](./scalar-data-types/datetime.md) value.\r\n* `datetime_2`: [datetime](./scalar-data-types/datetime.md) value.\r\n\r\nPossible values of *period*: \r\n\r\n- Year\r\n- Quarter\r\n- Month\r\n- Week\r\n- Day\r\n- Hour\r\n- Minute\r\n- Second\r\n- Millisecond\r\n- Microsecond\r\n- Nanosecond\r\n\r\n## Returns\r\n\r\nAn integer, which represents amount of `periods` in the result of subtraction (`datetime_1` - `datetime_2`).","```\r\nprint\r\nyear = datetime_diff('year',datetime(2017-01-01),datetime(2000-12-31)),\r\nquarter = datetime_diff('quarter',datetime(2017-07-01),datetime(2017-03-30)),\r\nmonth = datetime_diff('month',datetime(2017-01-01),datetime(2015-12-30)),\r\nweek = datetime_diff('week',datetime(2017-10-29 00:00),datetime(2017-09-30 23:59)),\r\nday = datetime_diff('day',datetime(2017-10-29 00:00),datetime(2017-09-30 23:59)),\r\nhour = datetime_diff('hour',datetime(2017-10-31 01:00),datetime(2017-10-30 23:59)),\r\nminute = datetime_diff('minute',datetime(2017-10-30 23:05:01),datetime(2017-10-30 23:00:59)),\r\nsecond = datetime_diff('second',datetime(2017-10-30 23:00:10.100),datetime(2017-10-30 23:00:00.900)),\r\nmillisecond = datetime_diff('millisecond',datetime(2017-10-30 23:00:00.200100),datetime(2017-10-30 23:00:00.100900)),\r\nmicrosecond = datetime_diff('microsecond',datetime(2017-10-30 23:00:00.1009001),datetime(2017-10-30 23:00:00.1008009)),\r\nnanosecond = datetime_diff('nanosecond',datetime(2017-10-30 23:00:00.0000000),datetime(2017-10-30 23:00:00.0000007))\r\n```\r\n\r\n|year|quarter|month|week|day|hour|minute|second|millisecond|microsecond|nanosecond|\r\n|---|---|---|---|---|---|---|---|---|---|---|\r\n|17|2|13|5|29|2|5|10|100|100|-700|","https://docs.microsoft.com/en-us/azure/kusto/query/datetime-difffunction","datetime-difffunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"datetime_part","Extracts the requested date part as an integer value.",'```\r\ndatetime_part("Day",datetime(2015-12-14))\r\n```\r\n\r\n## Syntax\r\n\r\n`datetime_part(`*part*`,`*datetime*`)`\r\n\r\n## Arguments\r\n\r\n* `date`: `datetime`\r\n* `part`: `string`\r\n\r\nPossible values of `part`: \r\n\r\n* Year\r\n* Quarter\r\n* Month\r\n* week_of_year\r\n* Day\r\n* DayOfYear\r\n* Hour\r\n* Minute\r\n* Second\r\n* Millisecond\r\n* Microsecond\r\n* Nanosecond\r\n\r\n## Returns\r\n\r\nAn integer representing the extracted part.\r\n\r\n> [!NOTE]\r\n> `week_of_year` returns an integer which represents the week number. The week number is calculated from the first week of a year, which is the one that includes the first Thursday.','```\r\nlet dt = datetime(2017-10-30 01:02:03.7654321); \r\nprint \r\nyear = datetime_part("year", dt),\r\nquarter = datetime_part("quarter", dt),\r\nmonth = datetime_part("month", dt),\r\nweekOfYear = datetime_part("week_of_year", dt),\r\nday = datetime_part("day", dt),\r\ndayOfYear = datetime_part("dayOfYear", dt),\r\nhour = datetime_part("hour", dt),\r\nminute = datetime_part("minute", dt),\r\nsecond = datetime_part("second", dt),\r\nmillisecond = datetime_part("millisecond", dt),\r\nmicrosecond = datetime_part("microsecond", dt),\r\nnanosecond = datetime_part("nanosecond", dt)\r\n\r\n```\r\n\r\n|year|quarter|month|weekOfYear|day|dayOfYear|hour|minute|second|millisecond|microsecond|nanosecond|\r\n|---|---|---|---|---|---|---|---|---|---|---|---|\r\n|2017|4|10|44|30|303|1|2|3|765|765432|765432100|\r\n\r\n> [!NOTE]\r\n> `weekofyear` is an obsolete variant of `week_of_year` part. `weekofyear` was not ISO 8601 compliant; the first week of a year was defined as the week with the year\'s first Wednesday in it.\r\n> `week_of_year` is ISO 8601 compliant; the first week of a year is defined as the week with the year\'s first Thursday in it. [For more information](https://en.wikipedia.org/wiki/ISO_8601#Week_dates).',"https://docs.microsoft.com/en-us/azure/kusto/query/datetime-partfunction","datetime-partfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"dayofmonth","Returns the integer number representing the day number of the given month","```\r\ndayofmonth(datetime(2015-12-14)) == 14\r\n```\r\n\r\n## Syntax\r\n\r\n`dayofmonth(`*a_date*`)`\r\n\r\n## Arguments\r\n\r\n* `a_date`: A `datetime`.\r\n\r\n## Returns\r\n\r\n`day number` of the given month.","","https://docs.microsoft.com/en-us/azure/kusto/query/dayofmonthfunction","")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"dayofweek","Returns the integer number of days since the preceding Sunday, as a `timespan`.","```\r\ndayofweek(datetime(2015-12-14)) == 1d  // Monday\r\n```\r\n\r\n## Syntax\r\n\r\n`dayofweek(`*a_date*`)`\r\n\r\n## Arguments\r\n\r\n* `a_date`: A `datetime`.\r\n\r\n## Returns\r\n\r\nThe `timespan` since midnight at the beginning of the preceding Sunday, rounded down to an integer number of days.","```\r\ndayofweek(datetime(1947-11-30 10:00:05))  // time(0.00:00:00), indicating Sunday\r\ndayofweek(datetime(1970-05-11))           // time(1.00:00:00), indicating Monday\r\n```","https://docs.microsoft.com/en-us/azure/kusto/query/dayofweekfunction","dayofweekfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"dayofyear","Returns the integer number represents the day number of the given year.","```\r\ndayofyear(datetime(2015-12-14))\r\n```\r\n\r\n## Syntax\r\n\r\n`dayofweek(`*a_date*`)`\r\n\r\n## Arguments\r\n\r\n* `a_date`: A `datetime`.\r\n\r\n## Returns\r\n\r\n`day number` of the given year.","","https://docs.microsoft.com/en-us/azure/kusto/query/dayofyearfunction","")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"dcount","Returns an estimate for the number of distinct values that are taken by a scalar expression in the summary group.","> [!NOTE]\r\n> The `dcount()` aggregation function is primarily useful for estimating the cardinality of huge sets. It trades performance for accuracy, and may return a result that varies between executions. The order of inputs may have an effect on its output.\r\n\r\n## Syntax\r\n\r\n... `|` `summarize` `dcount` `(`*`Expr`*[, *`Accuracy`*]`)` ...\r\n\r\n## Arguments\r\n\r\n* *Expr*: A scalar expression whose distinct values are to be counted.\r\n* *Accuracy*: An optional `int` literal that defines the requested estimation accuracy. See below for supported values. If unspecified, the default value\r\n  `1` is used.\r\n\r\n## Returns\r\n\r\nReturns an estimate of the number of distinct values of *`Expr`* in the group.",'```\r\nPageViewLog | summarize countries=dcount(country) by continent\r\n```\r\n\r\n![D count](images/dcount-aggfunction/dcount.png)\r\nGet an exact count of distinct values of `V` grouped by `G`.\r\n\r\n```\r\nT | summarize by V, G | summarize count() by G\r\n```\r\n\r\nThis calculation requires a great amount of internal memory, since distinct values of `V` are multiplied by the number of distinct values of `G`.\r\nIt may result in memory errors or large execution times. \r\n`dcount()`provides a fast and reliable alternative:\r\n\r\n```\r\nT | summarize dcount(B) by G | count\r\n```\r\n\r\n## Estimation accuracy\r\n\r\nThe `dcount()` aggregate function uses a variant of the [HyperLogLog (HLL) algorithm](https://en.wikipedia.org/wiki/HyperLogLog),\r\nwhich does a stochastic estimation of set cardinality. The algorithm provides a "knob" that can be used to balance accuracy and execution time per memory size:\r\n\r\n|Accuracy|Error (%)|Entry count   |\r\n|--------|---------|--------------|\r\n|       0|      1.6|2<sup>12</sup>|\r\n|       1|      0.8|2<sup>14</sup>|\r\n|       2|      0.4|2<sup>16</sup>|\r\n|       3|     0.28|2<sup>17</sup>|\r\n|       4|      0.2|2<sup>18</sup>|\r\n\r\n> [!NOTE]\r\n> The "entry count" column is the number of 1-byte counters in the HLL implementation.\r\n\r\nThe algorithm includes some provisions for doing a perfect count (zero error), if the set cardinality is small enough:\r\n\r\n* When the accuracy level is `1`, 1000 values are returned\r\n* When the accuracy level is `2`, 8000 values are returned\r\n\r\n\r\nThe error bound is probabilistic, not a theoretical bound. The value is the standard deviation of error distribution (the sigma), and 99.7% of the estimations will have a relative error of under 3 x sigma.\r\n\r\nThe following image shows the probability distribution function of the relative\r\nestimation error, in percentages, for all supported accuracy settings:\r\n\r\n![hll error distribution](images/dcount-aggfunction/hll-error-distribution.png)',"https://docs.microsoft.com/en-us/azure/kusto/query/dcount-aggfunction","dcount-aggfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"dcount_hll","Calculates the dcount from hll results (that were generated by [hll](hll-aggfunction.md) or [hll_merge](hll-merge-aggfunction.md)).","Read about the [underlying algorithm (*H*yper*L*og*L*og) and estimation accuracy](dcount-aggfunction.md#estimation-accuracy).\r\n\r\n## Syntax\r\n\r\n`dcount_hll(`*Expr*`)`\r\n\r\n## Arguments\r\n\r\n* *Expr*: Expression that was generated by [hll](hll-aggfunction.md) or [hll-merge](hll-merge-aggfunction.md)\r\n\r\n## Returns\r\n\r\nThe distinct count of each value in *Expr*","```\r\nStormEvents\r\n| summarize hllRes = hll(DamageProperty) by bin(StartTime,10m)\r\n| summarize hllMerged = hll_merge(hllRes)\r\n| project dcount_hll(hllMerged)\r\n```\r\n\r\n|dcount_hll_hllMerged|\r\n|---|\r\n|315|","https://docs.microsoft.com/en-us/azure/kusto/query/dcount-hllfunction","dcount-hllfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"dcountif","Returns an estimate of the number of distinct values of *Expr* of rows for which *Predicate* evaluates to `true`.","* Can be used only in context of aggregation inside [summarize](summarizeoperator.md).\r\n\r\nRead about the [estimation accuracy](dcount-aggfunction.md#estimation-accuracy).\r\n\r\n## Syntax\r\n\r\nsummarize `dcountif(`*Expr*, *Predicate*, [`,` *Accuracy*]`)`\r\n\r\n## Arguments\r\n\r\n* *Expr*: Expression that will be used for aggregation calculation.\r\n* *Predicate*: Expression that will be used to filter rows.\r\n* *Accuracy*, if specified, controls the balance between speed and accuracy.\r\n    * `0` = the least accurate and fastest calculation. 1.6% error\r\n    * `1` = the default, which balances accuracy and calculation time; about 0.8% error.\r\n    * `2` = accurate and slow calculation; about 0.4% error.\r\n    * `3` = extra accurate and slow calculation; about 0.28% error.\r\n    * `4` = super accurate and slowest calculation; about 0.2% error.\r\n\t\r\n\r\n## Returns\r\n\r\nReturns an estimate of the number of distinct values of *Expr*  of rows for which *Predicate* evaluates to `true` in the group.",'```\r\nPageViewLog | summarize countries=dcountif(country, country startswith "United") by continent\r\n```\r\n\r\n**Tip: Offset error**\r\n\r\n`dcountif()` might result in a one-off error in the edge cases where all rows\r\npass, or none of the rows pass, the `Predicate` expression',"https://docs.microsoft.com/en-us/azure/kusto/query/dcountif-aggfunction","dcountif-aggfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"degrees","Converts angle value in radians into value in degrees, using formula `degrees = (180 / PI ) * angle_in_radians`","## Syntax\r\n\r\n`degrees(`*a*`)`\r\n\r\n## Arguments\r\n\r\n* *a*: Angle in radians (a real number).\r\n\r\n## Returns\r\n\r\n* The corresponding angle in degrees for an angle specified in radians.","```\r\nprint degrees0 = degrees(pi()/4), degrees1 = degrees(pi()*1.5), degrees2 = degrees(0)\r\n\r\n```\r\n\r\n|degrees0|degrees1|degrees2|\r\n|---|---|---|\r\n|45|270|0|","https://docs.microsoft.com/en-us/azure/kusto/query/degreesfunction","degreesfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.OperatorToken,"distinct","Produces a table with the distinct combination of the provided columns of the input table.","```\r\nT | distinct Column1, Column2\r\n```\r\n\r\nProduces a table with the distinct combination of all columns in the input table.\r\n\r\n```\r\nT | distinct *\r\n```","Shows the distinct combination of fruit and price.\r\n\r\n```\r\nTable | distinct fruit, price\r\n```\r\n\r\n![Distinct](images/distinctoperator/distinct.PNG)\r\n**Notes**\r\n\r\n* Unlike `summarize by ...`, the `distinct` operator supports providing an asterisk (`*`) as the group key, making it easier to use for wide tables.\r\n* If the group by keys are of high cardinalities, using `summarize by ...` with the [shuffle strategy](shufflequery.md) could be useful.","https://docs.microsoft.com/en-us/azure/kusto/query/distinctoperator","distinctoperator.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"dynamic_to_json","Converts `dynamic` input to a string representation.\r\nIf the input is a property bag, the output string prints its content sorted by the keys, recursively. Otherwise, the output is similar to the `tostring` function output.","## Syntax\r\n\r\n`dynamic_to_json(Expr)`\r\n\r\n## Arguments\r\n\r\n* *Expr*: `dynamic` input. The function accepts one argument.\r\n\r\n## Returns\r\n\r\nReturns a string representation of the `dynamic` input. If the input is a property bag, the output string prints its content sorted by the keys, recursively.",'Expression:\r\n\r\n```\r\n  let bag1 = dynamic_to_json(dynamic({ \'Y10\':dynamic({ }), \'X8\': dynamic({ \'c3\':1, \'d8\':5, \'a4\':6 }),\'D1\':114, \'A1\':12, \'B1\':2, \'C1\':3, \'A14\':[15, 13, 18]}));\r\n  print bag1\r\n```\r\n\r\nResult:\r\n\r\n```\r\n"{\r\n  ""A1"": 12,\r\n  ""A14"": [\r\n    15,\r\n    13,\r\n    18\r\n  ],\r\n  ""B1"": 2,\r\n  ""C1"": 3,\r\n  ""D1"": 114,\r\n  ""X8"": {\r\n    ""c3"": 1,\r\n    ""d8"": 5,\r\n    ""a4"": 6\r\n  },\r\n  ""Y10"": {}\r\n}"\r\n```\r\n\r\nExpression:\r\n\r\n```\r\n let bag2 = dynamic_to_json(dynamic({ \'X8\': dynamic({ \'a4\':6, \'c3\':1, \'d8\':5}), \'A14\':[15, 13, 18], \'C1\':3, \'B1\':2, \'Y10\': dynamic({ }), \'A1\':12, \'D1\':114}));\r\n print bag2\r\n```\r\n\r\nResult:\r\n\r\n```\r\n{\r\n  "A1": 12,\r\n  "A14": [\r\n    15,\r\n    13,\r\n    18\r\n  ],\r\n  "B1": 2,\r\n  "C1": 3,\r\n  "D1": 114,\r\n  "X8": {\r\n    "a4": 6,\r\n    "c3": 1,\r\n    "d8": 5\r\n  },\r\n  "Y10": {}\r\n}\r\n```',"https://docs.microsoft.com/en-us/azure/kusto/query/dynamic-to-json-function","dynamic-to-json-function.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"endofday","Returns the end of the day containing the date, shifted by an offset, if provided.","## Syntax\r\n\r\n`endofday(`*date* [`,`*offset*]`)`\r\n\r\n## Arguments\r\n\r\n* `date`: The input date.\r\n* `offset`: An optional number of offset days from the input date (integer, default - 0).\r\n\r\n## Returns\r\n\r\nA datetime representing the end of the day for the given *date* value, with the offset, if specified.","```\r\n  range offset from -1 to 1 step 1\r\n | project dayEnd = endofday(datetime(2017-01-01 10:10:17), offset) \r\n```\r\n\r\n|dayEnd|\r\n|---|\r\n|2016-12-31 23:59:59.9999999|\r\n|2017-01-01 23:59:59.9999999|\r\n|2017-01-02 23:59:59.9999999|","https://docs.microsoft.com/en-us/azure/kusto/query/endofdayfunction","endofdayfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"endofmonth","Returns the end of the month containing the date, shifted by an offset, if provided.","## Syntax\r\n\r\n`endofmonth(`*date* [`,`*offset*]`)`\r\n\r\n## Arguments\r\n\r\n* `date`: The input date.\r\n* `offset`: An optional number of offset months from the input date (integer, default - 0).\r\n\r\n## Returns\r\n\r\nA datetime representing the end of the month for the given *date* value, with the offset, if specified.","```\r\n  range offset from -1 to 1 step 1\r\n | project monthEnd = endofmonth(datetime(2017-01-01 10:10:17), offset) \r\n```\r\n\r\n|monthEnd|\r\n|---|\r\n|2016-12-31 23:59:59.9999999|\r\n|2017-01-31 23:59:59.9999999|\r\n|2017-02-28 23:59:59.9999999|","https://docs.microsoft.com/en-us/azure/kusto/query/endofmonthfunction","endofmonthfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"endofweek","Returns the end of the week containing the date, shifted by an offset, if provided.","Last day of the week is considered to be a Saturday.\r\n\r\n## Syntax\r\n\r\n`endofweek(`*date* [`,`*offset*]`)`\r\n\r\n## Arguments\r\n\r\n* `date`: The input date.\r\n* `offset`: An optional number of offset weeks from the input date (integer, default - 0).\r\n\r\n## Returns\r\n\r\nA datetime representing the end of the week for the given *date* value, with the offset, if specified.","```\r\n  range offset from -1 to 1 step 1\r\n | project weekEnd = endofweek(datetime(2017-01-01 10:10:17), offset)  \r\n\r\n```\r\n\r\n|weekEnd|\r\n|---|\r\n|2016-12-31 23:59:59.9999999|\r\n|2017-01-07 23:59:59.9999999|\r\n|2017-01-14 23:59:59.9999999|","https://docs.microsoft.com/en-us/azure/kusto/query/endofweekfunction","endofweekfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"endofyear","Returns the end of the year containing the date, shifted by an offset, if provided.","## Syntax\r\n\r\n`endofyear(`*date* [`,`*offset*]`)`\r\n\r\n## Arguments\r\n\r\n* `date`: The input date.\r\n* `offset`: An optional number of offset years from the input date (integer, default - 0).\r\n\r\n## Returns\r\n\r\nA datetime representing the end of the year for the given *date* value, with the offset, if specified.","```\r\n  range offset from -1 to 1 step 1\r\n | project yearEnd = endofyear(datetime(2017-01-01 10:10:17), offset) \r\n```\r\n\r\n|yearEnd|\r\n|---|\r\n|2016-12-31 23:59:59.9999999|\r\n|2017-12-31 23:59:59.9999999|\r\n|2018-12-31 23:59:59.9999999|","https://docs.microsoft.com/en-us/azure/kusto/query/endofyearfunction","endofyearfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"estimate_data_size","Returns an estimated data size in bytes of the selected columns of the tabular expression.","```\r\nestimate_data_size(*)\r\nestimate_data_size(Col1, Col2, Col3)\r\n```\r\n\r\n## Syntax\r\n\r\n`estimate_data_size(*)`\r\n\r\n`estimate_data_size(`*col1*`, `*col2*`, `...`)`\r\n\r\n## Arguments\r\n\r\n* *col1*, *col2*: Selection of column references in the source tabular expression that are used for data size estimation. To include all columns, use `*` (asterisk) syntax.\r\n\r\n## Returns\r\n\r\n* The estimated data size  in bytes of the record size. Estimation is based on data types and values lengths.","Calculating total data size using `estimated_data_size()`:\r\n\r\n```\r\nrange x from 1 to 10 step 1                    // x (long) is 8 \r\n| extend Text = '1234567890'                   // Text length is 10  \r\n| summarize Total=sum(estimate_data_size(*))   // (8+10)x10 = 180\r\n```\r\n\r\n|Total|\r\n|---|\r\n|180|","https://docs.microsoft.com/en-us/azure/kusto/query/estimate-data-sizefunction","estimate-data-sizefunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.OperatorToken,"evaluate","Invokes a service-side query extension (plugin).","The `evaluate` operator is a tabular operator that provides the ability to\r\ninvoke query language extensions known as **plugins**. Plugins can be enabled\r\nor disabled (unlike other language constructs, which are always available),\r\nand aren't \"bound\" by the relational nature of the language (for example, they may\r\nnot have a predefined, statically determined, output schema).\r\n\r\n> [!NOTE]\r\n> * Syntactically, `evaluate` behaves similarly to the [invoke operator](./invokeoperator.md), which invokes tabular functions.\r\n> * Plugins provided through the evaluate operator aren't bound by the regular rules of query execution or argument evaluation.\r\n> * Specific plugins may have specific restrictions. For example, plugins whose output schema depends on the data (for example, [bag_unpack plugin](./bag-unpackplugin.md) and [pivot plugin](./pivotplugin.md)) can't be used when performing cross-cluster queries.\r\n\r\n## Syntax \r\n\r\n[*T* `|`] `evaluate` [ *evaluateParameters* ] *PluginName* `(` [*PluginArg1* [`,` *PluginArg2*]... `)`\r\n\r\n## Arguments\r\n\r\n* *T* is an optional tabular input to the plugin. (Some plugins don't take\r\n  any input, and act as a tabular data source.)\r\n* *PluginName* is the mandatory name of the plugin being invoked.\r\n* *PluginArg1*, ... are the optional arguments to the plugin.\r\n* *evaluateParameters*: Zero or more (space-separated) parameters in the form of\r\n  *Name* `=` *Value* that control the behavior of the evaluate operation and execution plan. Each plugin may decide differently how to handle each parameter. Refer to each plugin's documentation for specific behavior.  \r\n\r\n## Parameters\r\n\r\nThe following parameters are supported: \r\n\r\n|Name                |Values                           |Description                                |\r\n  |--------------------|---------------------------------|-------------------------------------------|\r\n  |`hint.distribution` |`single`, `per_node`, `per_shard`| [Distribution hints](#distribution-hints) |\r\n  |`hint.pass_filters` |`true`, `false`| Allow `evaluate` operator to passthrough any matching filters before the plugin. Filter is considered as 'matched' if it refers to a column existing before the `evaluate` operator. Default: `false` |\r\n  |`hint.pass_filters_column` |*column_name*| Allow plugin operator to passthrough filters referring to *column_name* before the plugin. Parameter can be used multiple times with different column names. |\r\n\r\n## Distribution hints\r\n\r\nDistribution hints specify how the plugin execution will be distributed across multiple cluster nodes. Each plugin may implement a different support for the distribution. The plugin's documentation specifies the distribution options supported by the plugin.\r\n\r\nPossible values:\r\n\r\n* `single`: A single instance of the plugin will run over the entire query data.\r\n* `per_node`: If the query before the plugin call is distributed across nodes, then an instance of the plugin will run on each node over the data that it contains.\r\n* `per_shard`: If the data before the plugin call is distributed across shards, then an instance of the plugin will run over each shard of the data.","","https://docs.microsoft.com/en-us/azure/kusto/query/evaluateoperator","")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"exp","The base-e exponential function of x, which is e raised to the power x: e^x.","## Syntax\r\n\r\n`exp(`*x*`)`\r\n\r\n## Arguments\r\n\r\n* *x*: A real number, value of the exponent.\r\n\r\n## Returns\r\n\r\n* Exponential value of x.\r\n* For natural (base-e) logarithms, see [log()](log-function.md).\r\n* For exponential functions of base-2 and base-10 logarithms, see [exp2()](exp2-function.md), [exp10()](exp10-function.md)","","https://docs.microsoft.com/en-us/azure/kusto/query/exp-function","")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"exp10","The base-10 exponential function of x, which is 10 raised to the power x: 10^x.","## Syntax\r\n\r\n`exp10(`*x*`)`\r\n\r\n## Arguments\r\n\r\n* *x*: A real number, value of the exponent.\r\n\r\n## Returns\r\n\r\n* Exponential value of x.\r\n* For natural (base-10) logarithms, see [log10()](log10-function.md).\r\n* For exponential functions of base-e and base-2 logarithms, see [exp()](exp-function.md), [exp2()](exp2-function.md)","","https://docs.microsoft.com/en-us/azure/kusto/query/exp10-function","")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"exp2","The base-2 exponential function of x, which is 2 raised to the power x: 2^x.","## Syntax\r\n\r\n`exp2(`*x*`)`\r\n\r\n## Arguments\r\n\r\n* *x*: A real number, value of the exponent.\r\n\r\n## Returns\r\n\r\n* Exponential value of x.\r\n* For natural (base-2) logarithms, see [log2()](log2-function.md).\r\n* For exponential functions of base-e and base-10 logarithms, see [exp()](exp-function.md), [exp10()](exp10-function.md)","","https://docs.microsoft.com/en-us/azure/kusto/query/exp2-function","")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.OperatorToken,"extend","Create calculated columns and append them to the result set.","```\r\nT | extend duration = endTime - startTime\r\n```\r\n\r\n## Syntax\r\n\r\n*T* `| extend` [*ColumnName* | `(`*ColumnName*[`,` ...]`)` `=`] *Expression* [`,` ...]\r\n\r\n## Arguments\r\n\r\n* *T*: The input tabular result set.\r\n* *ColumnName:* Optional. The name of the column to add or update. If omitted, the name will be generated. If *Expression* returns more than one column, a list of column names can be specified in parentheses. In this case *Expression*'s output columns will be given the specified names, dropping the rest of the output columns, if there are any. If a list of the column names is not specified, all *Expression*'s output columns with generated names will be added to the output.\r\n* *Expression:* A calculation over the columns of the input.\r\n\r\n## Returns\r\n\r\nA copy of the input tabular result set, such that:\r\n\r\n1. Column names noted by `extend` that already exist in the input are removed\r\n   and appended as their new calculated values.\r\n2. Column names noted by `extend` that do not exist in the input are appended\r\n   as their new calculated values.\r\n\r\n**Tips**\r\n\r\n* The `extend` operator adds a new column to the input result set, which does\r\n  **not** have an index. In most cases, if the new column is set to be exactly\r\n  the same as an existing table column that has an index, Kusto can automatically\r\n  use the existing index. However, in some complex scenarios this propagation is\r\n  not done. In such cases, if the goal is to rename a column,\r\n  use the [`project-rename` operator](projectrenameoperator.md) instead.",'```\r\nLogs\r\n| extend\r\n    Duration = CreatedOn - CompletedOn\r\n    , Age = now() - CreatedOn\r\n    , IsSevere = Level == "Critical" or Level == "Error"\r\n```\r\n\r\nYou can use the [series_stats](series-statsfunction.md) function to return multiple columns.',"https://docs.microsoft.com/en-us/azure/kusto/query/extendoperator","extendoperator.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"extent_id",'Returns a unique identifier that identifies the data shard ("extent") that the current record resides in.',"Applying this function to calculated data that isn't attached to a data shard returns an empty guid (all zeros).\r\n\r\n## Syntax\r\n\r\n`extent_id()`\r\n\r\n## Returns\r\n\r\nA value of type `guid` that identifies the current record's data shard,\r\nor an empty guid (all zeros).","The following example shows how to get a list of all the data shards\r\nthat have records from an hour ago with a specific value for the\r\ncolumn `ActivityId`. It demonstrates that some query operators (here,\r\nthe `where` operator, and also `extend` and `project`)\r\npreserve the information about the data shard hosting the record.\r\n\r\n```\r\nT\r\n| where Timestamp > ago(1h)\r\n| where ActivityId == 'dd0595d4-183e-494e-b88e-54c52fe90e5a'\r\n| extend eid=extent_id()\r\n| summarize by eid\r\n```","https://docs.microsoft.com/en-us/azure/kusto/query/extentidfunction","extentidfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"extent_tags",'Returns a dynamic array with the [tags](../management/extents-overview.md#extent-tagging) of the data shard ("extent") that the current record resides in.',"Applying this function to calculated data which is not attached to a data shard returns an empty value.\r\n\r\n## Syntax\r\n\r\n`extent_tags()`\r\n\r\n## Returns\r\n\r\nA value of type `dynamic` that is an array holding the current record's extent tags,\r\nor an empty value.","The following example shows how to get a list the tags of all the data shards\r\nthat have records from an hour ago with a specific value for the\r\ncolumn `ActivityId`. It demonstrates that some query operators (here,\r\nthe `where` operator, but this is also true for `extend` and `project`)\r\npreserve the information about the data shard hosting the record.\r\n\r\n```\r\nT\r\n| where Timestamp > ago(1h)\r\n| where ActivityId == 'dd0595d4-183e-494e-b88e-54c52fe90e5a'\r\n| extend tags = extent_tags()\r\n| summarize by tostring(tags)\r\n```\r\n\r\nThe following example shows how to obtain a count of all records from the \r\nlast hour, which are stored in extents which are tagged with the tag `MyTag`\r\n(and potentially other tags), but not tagged with the tag `drop-by:MyOtherTag`.\r\n\r\n```\r\nT\r\n| where Timestamp > ago(1h)\r\n| extend Tags = extent_tags()\r\n| where Tags has_cs 'MyTag' and Tags !has_cs 'drop-by:MyOtherTag'\r\n| count\r\n```","https://docs.microsoft.com/en-us/azure/kusto/query/extenttagsfunction","extenttagsfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"external_table","References an [external table](schema-entities/externaltables.md) by name.","```\r\nexternal_table('StormEvent')\r\n```\r\n\r\n> [!NOTE]\r\n> * The `external_table` function has similar restrictions as the [table](tablefunction.md) function.\r\n> * Standard [query limits](../concepts/querylimits.md) apply to external table queries as well.\r\n\r\n## Syntax\r\n\r\n`external_table` `(` *TableName* [`,` *MappingName* ] `)`\r\n\r\n## Arguments\r\n\r\n* *TableName*: The name of the external table being queried.\r\n  Must be a string literal referencing an external table of kind\r\n  `blob`, `adl` or `sql`.\r\n* *MappingName*: An optional name of the mapping object that maps the\r\n  fields in the actual (external) data shards to the columns output\r\n  by this function.\r\n\r\n## Next steps\r\n\r\n* [External table general control commands](../management/externaltables.md)\r\n* [Create and alter external tables in Azure Storage or Azure Data Lake](../management/external-tables-azurestorage-azuredatalake.md)\r\n* [Create and alter external SQL tables](../management/external-sql-tables.md)","","https://docs.microsoft.com/en-us/azure/kusto/query/externaltablefunction","")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.OperatorToken,"externaldata","The `externaldata` operator returns a table whose schema is defined in the query itself, and whose data is read from an external storage artifact, such as a blob in \r\nAzure Blob Storage or a file in Azure Data Lake Storage.","## Syntax\r\n\r\n`externaldata` `(` *ColumnName* `:` *ColumnType* [`,` ...] `)`   \r\n`[` *StorageConnectionString* [`,` ...] `]`   \r\n[`with` `(` *PropertyName* `=` *PropertyValue* [`,` ...] `)`]\r\n\r\n## Arguments\r\n\r\n* *ColumnName*, *ColumnType*: The arguments define the schema of the table.\r\n  The syntax is the same as the syntax used when defining a table in [.create table](../management/create-table-command.md).\r\n* *StorageConnectionString*: [Storage connection strings](../api/connection-strings/storage.md) that describe the storage artifacts holding the data to return.\r\n* *PropertyName*, *PropertyValue*, ...: Additional properties that describe how to interpret\r\n  the data retrieved from storage, as listed under [ingestion properties](../../ingestion-properties.md).\r\n\r\nCurrently supported properties are:\r\n\r\n| Property         | Type     | Description       |\r\n|------------------|----------|-------------------|\r\n| `format`         | `string` | Data format. If not specified, an attempt is made to detect the data format from file extension (defaults to `CSV`). Any of the [ingestion data formats](../../ingestion-supported-formats.md) are supported. |\r\n| `ignoreFirstRecord` | `bool` | If set to true, indicates that the first record in every file is ignored. This property is useful when querying CSV files with headers. |\r\n| `ingestionMapping` | `string` | A string value that indicates how to map data from the source file to the actual columns in the operator result set. See [data mappings](../management/mappings.md). |\r\n\r\n> [!NOTE]\r\n> * This operator doesn't accept any pipeline input.\r\n> * Standard [query limits](../concepts/querylimits.md) apply to external data queries as well.\r\n\r\n## Returns\r\n\r\nThe `externaldata` operator returns a data table of the given schema whose data was parsed from the specified storage artifact, indicated by the storage connection string.",'**Fetch a list of user IDs stored in Azure Blob Storage**\r\n\r\nThe following example shows how to find all records in a table whose `UserID` column falls into a known set of IDs, held (one per line) in an external storage file. Since the data format isn\'t specified, the detected data format is `TXT`.\r\n\r\n```\r\nUsers\r\n| where UserID in ((externaldata (UserID:string) [\r\n    @"https://storageaccount.blob.core.windows.net/storagecontainer/users.txt" \r\n      h@"?...SAS..." // Secret token needed to access the blob\r\n    ]))\r\n| ...\r\n```\r\n\r\n**Query multiple data files**\r\n\r\nThe following example queries multiple data files stored in external storage.\r\n\r\n```\r\nexternaldata(Timestamp:datetime, ProductId:string, ProductDescription:string)\r\n[\r\n  h@"https://mycompanystorage.blob.core.windows.net/archivedproducts/2019/01/01/part-00000-7e967c99-cf2b-4dbb-8c53-ce388389470d.csv.gz?...SAS...",\r\n  h@"https://mycompanystorage.blob.core.windows.net/archivedproducts/2019/01/02/part-00000-ba356fa4-f85f-430a-8b5a-afd64f128ca4.csv.gz?...SAS...",\r\n  h@"https://mycompanystorage.blob.core.windows.net/archivedproducts/2019/01/03/part-00000-acb644dc-2fc6-467c-ab80-d1590b23fc31.csv.gz?...SAS..."\r\n]\r\nwith(format="csv")\r\n| summarize count() by ProductId\r\n```\r\n\r\nThe above example can be thought of as a quick way to query multiple data files without defining an [external table](schema-entities/externaltables.md).\r\n\r\n> [!NOTE]\r\n> Data partitioning isn\'t recognized by the `externaldata` operator.\r\n\r\n**Query hierarchical data formats**\r\n\r\nTo query hierarchical data format, such as `JSON`, `Parquet`, `Avro`, or `ORC`, `ingestionMapping` must be specified in the operator properties. \r\nIn this example, there\'s a JSON file stored in Azure Blob Storage with the following contents:\r\n\r\n```JSON\r\n{\r\n  "timestamp": "2019-01-01 10:00:00.238521",   \r\n  "data": {    \r\n    "tenant": "e1ef54a6-c6f2-4389-836e-d289b37bcfe0",   \r\n    "method": "RefreshTableMetadata"   \r\n  }   \r\n}   \r\n{\r\n  "timestamp": "2019-01-01 10:00:01.845423",   \r\n  "data": {   \r\n    "tenant": "9b49d0d7-b3e6-4467-bb35-fa420a25d324",   \r\n    "method": "GetFileList"   \r\n  }   \r\n}\r\n...\r\n```\r\n\r\nTo query this file using the `externaldata` operator, a data mapping must be specified. The mapping dictates how to map JSON fields to the operator result set columns:\r\n\r\n```\r\nexternaldata(Timestamp: datetime, TenantId: guid, MethodName: string)\r\n[ \r\n   h@\'https://mycompanystorage.blob.core.windows.net/events/2020/09/01/part-0000046c049c1-86e2-4e74-8583-506bda10cca8.json?...SAS...\'\r\n]\r\nwith(format=\'multijson\', ingestionMapping=\'[{"Column":"Timestamp","Properties":{"Path":"$.time"}},{"Column":"TenantId","Properties":{"Path":"$.data.tenant"}},{"Column":"MethodName","Properties":{"Path":"$.data.method"}}]\')\r\n```\r\n\r\nThe `MultiJSON` format is used here because single JSON records are spanned into multiple lines.\r\n\r\nFor more info on mapping syntax, see [data mappings](../management/mappings.md).',"https://docs.microsoft.com/en-us/azure/kusto/query/externaldata-operator","externaldata-operator.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"extract","Get a match for a [regular expression](./re2.md) from a text string.",'Optionally, convert the extracted substring to the indicated type.\r\n\r\n```\r\nextract("x=([0-9.]+)", 1, "hello x=45.6|wo") == "45.6"\r\n```\r\n\r\n## Syntax\r\n\r\n`extract(`*regex*`,` *captureGroup*`,` *text* [`,` *typeLiteral*]`)`\r\n\r\n## Arguments\r\n\r\n* *regex*: A [regular expression](./re2.md).\r\n* *captureGroup*: A positive `int` constant indicating the\r\ncapture group to extract. 0 stands for the entire match, 1 for the value matched by the first \'(\'parenthesis\')\' in the regular expression, 2 or more for subsequent parentheses.\r\n* *text*: A `string` to search.\r\n* *typeLiteral*: An optional type literal (e.g., `typeof(long)`). If provided, the extracted substring is converted to this type. \r\n\r\n## Returns\r\n\r\nIf *regex* finds a match in *text*: the substring matched against the indicated capture group *captureGroup*, optionally converted to *typeLiteral*.\r\n\r\nIf there\'s no match, or the type conversion fails: `null`.','The example string `Trace` is searched for a definition for `Duration`. \r\nThe match is converted to `real`, then multiplied it by a time constant (`1s`) so that `Duration` is of type `timespan`. In this example, it is equal to 123.45 seconds:\r\n\r\n```\r\n...\r\n| extend Trace="A=1, B=2, Duration=123.45, ..."\r\n| extend Duration = extract("Duration=([0-9.]+)", 1, Trace, typeof(real)) * time(1s) \r\n```\r\n\r\nThis example is equivalent to `substring(Text, 2, 4)`:\r\n\r\n```\r\nextract("^.{2,2}(.{4,4})", 1, Text)\r\n```',"https://docs.microsoft.com/en-us/azure/kusto/query/extractfunction","extractfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"extract_all","Get all matches for a [regular expression](./re2.md) from a text string.\r\nOptionally, retrieve a subset of matching groups.",'```\r\nprint extract_all(@"(\\d+)", "a set of numbers: 123, 567 and 789") // results with the dynamic array ["123", "567", "789"]\r\n```\r\n\r\n## Syntax\r\n\r\n`extract_all(`*regex*`,` [*captureGroups*`,`] *text*`)`\r\n\r\n## Arguments\r\n\r\n|Argument        |Description                                  |Required or Optional  |\r\n|----------------|---------------------------------------------|----------------------|\r\n|regex           | A [regular expression](./re2.md). The expression must have at least one capturing group, and less than or equal to 16 capturing groups                                                         |Required              |\r\n|captureGroups   |A dynamic array constant that indicates the capture group to extract. Valid values are from 1 to the number of capturing groups in the regular expression. Named capture groups are allowed as well (See [Examples](#examples))|Optional         |\r\n|text            |A `string` to search                         |Required              |\r\n\r\n## Returns\r\n\r\n* If *regex* finds a match in *text*: Returns dynamic array including all matches against the indicated capture groups *captureGroups*, or all of capturing groups in the *regex*.\r\n* If number of *captureGroups* is 1: The returned array has a single dimension of matched values.\r\n* If number of *captureGroups* is more than 1: The returned array is a two-dimensional collection of multi-value matches per *captureGroups* selection, or all capture groups present in the *regex* if *captureGroups* is omitted.\r\n* If there\'s no match: `null`.','### Extract a single capture group\r\n\r\nReturns hex-byte representation (two hex-digits) of the GUID.\r\n\r\n```\r\nprint Id="82b8be2d-dfa7-4bd1-8f63-24ad26d31449"\r\n| extend guid_bytes = extract_all(@"([\\da-f]{2})", Id) \r\n```\r\n\r\n|ID|guid_bytes|\r\n|---|---|\r\n|82b8be2d-dfa7-4bd1-8f63-24ad26d31449|["82","b8","be","2d","df","a7","4b","d1","8f","63","24","ad","26","d3","14","49"]|\r\n\r\n### Extract several capture groups \r\n\r\nUses a regular expression with three capturing groups to split each GUID part into first letter, last letter, and whatever is in the middle.\r\n\r\n```\r\nprint Id="82b8be2d-dfa7-4bd1-8f63-24ad26d31449"\r\n| extend guid_bytes = extract_all(@"(\\w)(\\w+)(\\w)", Id)\r\n```\r\n\r\n|ID|guid_bytes|\r\n|---|---|\r\n|82b8be2d-dfa7-4bd1-8f63-24ad26d31449|[["8","2b8be2","d"],["d","fa","7"],["4","bd","1"],["8","f6","3"],["2","4ad26d3144","9"]]|\r\n\r\n### Extract a subset of capture groups\r\n\r\nShows how to select a subset of capturing groups. \r\nThe regular expression matches the first letter, last letter, and all the rest. \r\nThe *captureGroups* parameter is used to select only the first and the last parts.\r\n\r\n```\r\nprint Id="82b8be2d-dfa7-4bd1-8f63-24ad26d31449"\r\n| extend guid_bytes = extract_all(@"(\\w)(\\w+)(\\w)", dynamic([1,3]), Id) \r\n```\r\n\r\n|ID|guid_bytes|\r\n|---|---|\r\n|82b8be2d-dfa7-4bd1-8f63-24ad26d31449|[["8","d"],["d","7"],["4","1"],["8","3"],["2","9"]]|\r\n\r\n### Using named capture groups\r\n\r\nYou can use named capture groups of RE2 in extract_all().\r\nThe *captureGroups* uses both capture group indexes and named capture group reference to fetch matching values.\r\n\r\n```\r\nprint Id="82b8be2d-dfa7-4bd1-8f63-24ad26d31449"\r\n| extend guid_bytes = extract_all(@"(?P<first>\\w)(?P<middle>\\w+)(?P<last>\\w)", dynamic([\'first\',2,\'last\']), Id) \r\n```\r\n\r\n|ID|guid_bytes|\r\n|---|---|\r\n|82b8be2d-dfa7-4bd1-8f63-24ad26d31449|[["8","2b8be2","d"],["d","fa","7"],["4","bd","1"],["8","f6","3"],["2","4ad26d3144","9"]]|',"https://docs.microsoft.com/en-us/azure/kusto/query/extractallfunction","extractallfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"extractjson","Get a specified element out of a JSON text using a path expression.",'Optionally convert the extracted string to a specific type.\r\n\r\n```\r\nextractjson("$.hosts[1].AvailableMB", EventText, typeof(int))\r\n```\r\n\r\n## Syntax\r\n\r\n`extractjson(`*jsonPath*`,` *dataSource*`)` \r\n\r\n## Arguments\r\n\r\n* *jsonPath*: JsonPath string that defines an accessor into the JSON document.\r\n* *dataSource*:  A JSON document.\r\n\r\n## Returns\r\n\r\nThis function performs a JsonPath query into dataSource which contains a valid JSON string, optionally converting that value to another type depending on the third argument.',"The `[`bracket`]` notatation and dot (`.`) notation are equivalent:\r\n\r\n```\r\nT \r\n| extend AvailableMB = extractjson(\"$.hosts[1].AvailableMB\", EventText, typeof(int)) \r\n\r\nT\r\n| extend AvailableMD = extractjson(\"$['hosts'][1]['AvailableMB']\", EventText, typeof(int)) \r\n```\r\n\r\n### JSON Path expressions\r\n\r\n|Path expression|Description|\r\n|---|---|\r\n|`$`|Root object|\r\n|`@`|Current object|\r\n|`.` or `[ ]` | Child|\r\n|`[ ]`|Array subscript|\r\n\r\n*(We don't currently implement wildcards, recursion, union, or slices.)*\r\n\r\n**Performance tips**\r\n\r\n* Apply where-clauses before using `extractjson()`\r\n* Consider using a regular expression match with [extract](extractfunction.md) instead. This can run very much faster, and is effective if the JSON is produced from a template.\r\n* Use `parse_json()` if you need to extract more than one value from the JSON.\r\n* Consider having the JSON parsed at ingestion by declaring the type of the column to be dynamic.","https://docs.microsoft.com/en-us/azure/kusto/query/extractjsonfunction","extractjsonfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.OperatorToken,"facet","Returns a set of tables, one for each specified column.\r\nEach table specifies the list of values taken by its column.\r\nAn additional table can be created by using the `with` clause.","## Syntax\r\n\r\n*T* `| facet by` *ColumnName* [`, ` ...] [`with (` *filterPipe* `)`\r\n\r\n## Arguments\r\n\r\n* *ColumnName:* The name of column in the input, to be summarized as an output table.\r\n* *filterPipe:* A query expression applied to the input table to produce one of the outputs.\r\n\r\n## Returns\r\n\r\nMultiple tables: one for the `with` clause, and one for each column.","```\r\nMyTable \r\n| facet by city, eventType \r\n    with (where timestamp > ago(7d) | take 1000)\r\n```","https://docs.microsoft.com/en-us/azure/kusto/query/facetoperator","facetoperator.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.OperatorToken,"find","Finds rows that match a predicate across a set of tables.","The scope of the `find` can also be cross-database or cross-cluster.\r\n\r\n```\r\nfind in (Table1, Table2, Table3) where Fruit==\"apple\"\r\nfind in (database('*').*) where Fruit == \"apple\"\r\nfind in (cluster('cluster_name').database('MyDB*'.*)) where Fruit == \"apple\"\r\n```\r\n\r\n## Syntax\r\n\r\n* `find` [`withsource`=*ColumnName*] [`in` `(`*Table* [`,` *Table*, ...]`)`] `where` *Predicate* [`project-smart` | `project` *ColumnName* [`:`*ColumnType*] [`,` *ColumnName*[`:`*ColumnType*], ...][`,` `pack(*)`]] \r\n* `find` *Predicate* [`project-smart` | `project` *ColumnName*[`:`*ColumnType*] [`,` *ColumnName*[`:`*ColumnType*], ...] [`, pack(*)`]] \r\n\r\n## Arguments\r\n\r\n* `withsource=`*ColumnName*: Optional. By default, the output will include a column called *source_* whose values indicate which source table has contributed each row. If specified, *ColumnName* will be used instead of *source_*.\r\nAfter wildcard matching, if the query references tables from more than one database (including the default database), the value of this column will have a table name qualified with the database. Similarly *cluster* and *database* qualifications will be present in the value if more than one cluster is referenced.\r\n* *Predicate*: A `boolean` [expression](./scalar-data-types/bool.md) over the columns of the input tables *Table* [`,` *Table*, ...]. It's evaluated for each row in each input table. For more information, see  [predicate-syntax details](./findoperator.md#predicate-syntax).\r\n* `Table`: Optional. By default, *find* will look in all the tables in the current database, for:\r\n    *  The name of a table, such as `Events`\r\n    *  A query expression, such as `(Events | where id==42)`\r\n    *  A set of tables specified with a wildcard. For example, `E*` would form the union of all the tables in the database whose names begin with `E`.\r\n* `project-smart` | `project`: If not specified, `project-smart` will be used by default. For more information, see [output-schema details](./findoperator.md#output-schema).\r\n\r\n\r\n## Returns\r\n\r\nTransformation of rows in *Table* [`,` *Table*, ...] for which *Predicate* is `true`. The rows are transformed according to the [output schema](#output-schema).\r\n\r\n## Output schema\r\n\r\n**source_ column**\r\n\r\nThe find operator output will always include a *source_* column with the source table name. The column can be renamed using the `withsource` parameter.\r\n\r\n**results columns**\r\n\r\nSource tables that don't contain any column used by the predicate evaluation, will be filtered out.\r\n\r\nWhen using `project-smart`, the columns that will appear in the output will be:\r\n\r\n* Columns that appear explicitly in the predicate.\r\n* Columns that are common to all the filtered tables.\r\n\r\nThe rest of the columns will be packed into a property bag and will appear in an additional `pack_` column.\r\nA column that is referenced explicitly by the predicate and appears in multiple tables with multiple types, will have a different column in the result schema for each such type. Each of the column names will be constructed from the original column name and type, separated by an underscore.\r\n\r\nWhen using `project` *ColumnName*[`:`*ColumnType*] [`,` *ColumnName*[`:`*ColumnType*], ...][`,` `pack(*)`]:\r\n\r\n* The result table will include the columns specified in the list. If a source table doesn't contain a certain column, the values in the corresponding rows will be null.\r\n* When specifying a *ColumnType* with a *ColumnName*, this column in the \"result\" will have the given type, and the values will be cast to that type if needed. The casting won't have an effect on the column type when evaluating the *Predicate*.\r\n* When `pack(*)` is used, the rest of the columns will be packed into a property bag and will appear in an additional `pack_` column.\r\n\r\n**pack_ column**\r\n\r\nThis column will contain a property bag with the data from all the columns that doesn't appear in the output schema. The source column name will serve as the property name and the column value will serve as the property value.\r\n\r\n## Predicate syntax\r\n\r\nThe *find* operator supports an alternative syntax for the `* has` term, and using just *term*, will search a term across all input columns.\r\n\r\nFor a summary of some filtering functions, see [where operator](./whereoperator.md).\r\n\r\n## Notes\r\n\r\n* If the `project` clause references a column that appears in multiple tables and has multiple types, a type must follow this column reference in the project clause\r\n* If a column appears in multiple tables and has multiple types and `project-smart` is in use, there will be a corresponding column for each type in the `find`'s result, as described in [union](./unionoperator.md)\r\n* When using *project-smart*, changes in the predicate, in the source tables set, or in the tables schema, may result in a change to the output schema. If a constant result schema is needed, use *project* instead\r\n* `find` scope can't include [functions](../management/functions.md). To include a function in the find scope, define a [let statement](./letstatement.md) with [view keyword](./letstatement.md).\r\n\r\n## Performance tips\r\n\r\n* Use [tables](../management/tables.md) as opposed to [tabular expressions](./tabularexpressionstatements.md).\r\nIf tabular expression, the find operator falls back to a `union` query that can result in degraded performance.\r\n* If a column that appears in multiple tables and has multiple types, is part of the project clause, prefer adding a *ColumnType* to the project clause over modifying the table before passing it to `find`.\r\n* Add time-based filters to the predicate. Use a datetime column value or [ingestion_time()](./ingestiontimefunction.md).\r\n* Search in specific columns rather than a full text search.\r\n* It's better not to reference columns that appear in multiple tables and have multiple types. If the predicate is valid when resolving such columns type for more than one type, the query will fall back to union.\r\nFor example, see [examples of cases where find will act as a union](./findoperator.md#examples-of-cases-where-find-will-act-as-union).",'### Term lookup across all tables in current database\r\n\r\nThe query finds all rows from all tables in the current database in which any column includes the word `Kusto`.\r\nThe resulting records are transformed according to the [output schema](#output-schema).\r\n\r\n```\r\nfind "Kusto"\r\n```\r\n\r\n## Term lookup across all tables matching a name pattern in the current database\r\n\r\nThe query finds all rows from all tables in the current database whose name starts with `K`, and in which any column includes the word `Kusto`.\r\nThe resulting records are transformed according to the [output schema](#output-schema).\r\n\r\n```\r\nfind in (K*) where * has "Kusto"\r\n```\r\n\r\n### Term lookup across all tables in all databases in the cluster\r\n\r\nThe query finds all rows from all tables in all databases in which any column includes the word `Kusto`.\r\nThis query is a [cross-database](./cross-cluster-or-database-queries.md) query.\r\nThe resulting records are transformed according to the [output schema](#output-schema).\r\n\r\n```\r\nfind in (database(\'*\').*) "Kusto"\r\n```\r\n\r\n### Term lookup across all tables and databases matching a name pattern in the cluster\r\n\r\nThe query finds all rows from all tables whose name starts with `K` in all databases whose name start with `B` and in which any column includes the word `Kusto`.\r\nThe resulting records are transformed according to the [output schema](#output-schema).\r\n\r\n```\r\nfind in (database("B*").K*) where * has "Kusto"\r\n```\r\n\r\n### Term lookup in several clusters\r\n\r\nThe query finds all rows from all tables whose name starts with `K` in all databases whose name start with `B` and in which any column includes the word `Kusto`.\r\nThe resulting records are transformed according to the [output schema](#output-schema).\r\n\r\n```\r\nfind in (cluster("cluster1").database("B*").K*, cluster("cluster2").database("C*".*))\r\nwhere * has "Kusto"\r\n```\r\n\r\n## Examples of `find` output results  \r\n\r\nThe following examples show how `find` can be used over two tables: *EventsTable1* and *EventsTable2*.\r\nAssume we have the next content of these two tables:\r\n\r\n### EventsTable1\r\n\r\n|Session_Id|Level|EventText|Version\r\n|---|---|---|---|\r\n|acbd207d-51aa-4df7-bfa7-be70eb68f04e|Information|Some Text1|v1.0.0\r\n|acbd207d-51aa-4df7-bfa7-be70eb68f04e|Error|Some Text2|v1.0.0\r\n|28b8e46e-3c31-43cf-83cb-48921c3986fc|Error|Some Text3|v1.0.1\r\n|8f057b11-3281-45c3-a856-05ebb18a3c59|Information|Some Text4|v1.1.0\r\n\r\n### EventsTable2\r\n\r\n|Session_Id|Level|EventText|EventName\r\n|---|---|---|---|\r\n|f7d5f95f-f580-4ea6-830b-5776c8d64fdd|Information|Some Other Text1|Event1\r\n|acbd207d-51aa-4df7-bfa7-be70eb68f04e|Information|Some Other Text2|Event2\r\n|acbd207d-51aa-4df7-bfa7-be70eb68f04e|Error|Some Other Text3|Event3\r\n|15eaeab5-8576-4b58-8fc6-478f75d8fee4|Error|Some Other Text4|Event4\r\n\r\n### Search in common columns, project common and uncommon columns, and pack the rest  \r\n\r\n```\r\nfind in (EventsTable1, EventsTable2) \r\n     where Session_Id == \'acbd207d-51aa-4df7-bfa7-be70eb68f04e\' and Level == \'Error\' \r\n     project EventText, Version, EventName, pack(*)\r\n```\r\n\r\n|source_|EventText|Version|EventName|pack_\r\n|---|---|---|---|---|\r\n|EventsTable1|Some Text2|v1.0.0||{"Session_Id":"acbd207d-51aa-4df7-bfa7-be70eb68f04e", "Level":"Error"}\r\n|EventsTable2|Some Other Text3||Event3|{"Session_Id":"acbd207d-51aa-4df7-bfa7-be70eb68f04e", "Level":"Error"}\r\n\r\n### Search in common and uncommon columns\r\n\r\n```\r\nfind Version == \'v1.0.0\' or EventName == \'Event1\' project Session_Id, EventText, Version, EventName\r\n```\r\n\r\n|source_|Session_Id|EventText|Version|EventName|\r\n|---|---|---|---|---|\r\n|EventsTable1|acbd207d-51aa-4df7-bfa7-be70eb68f04e|Some Text1|v1.0.0\r\n|EventsTable1|acbd207d-51aa-4df7-bfa7-be70eb68f04e|Some Text2|v1.0.0\r\n|EventsTable2|f7d5f95f-f580-4ea6-830b-5776c8d64fdd|Some Other Text1||Event1\r\n\r\nNote: in practice, *EventsTable1* rows will be filtered with ```Version == \'v1.0.0\'``` predicate and *EventsTable2* rows will be filtered with ```EventName == \'Event1\'``` predicate.\r\n\r\n### Use abbreviated notation to search across all tables in the current database\r\n\r\n```\r\nfind Session_Id == \'acbd207d-51aa-4df7-bfa7-be70eb68f04e\'\r\n```\r\n\r\n|source_|Session_Id|Level|EventText|pack_|\r\n|---|---|---|---|---|\r\n|EventsTable1|acbd207d-51aa-4df7-bfa7-be70eb68f04e|Information|Some Text1|{"Version":"v1.0.0"}\r\n|EventsTable1|acbd207d-51aa-4df7-bfa7-be70eb68f04e|Error|Some Text2|{"Version":"v1.0.0"}\r\n|EventsTable2|acbd207d-51aa-4df7-bfa7-be70eb68f04e|Information|Some Other Text2|{"EventName":"Event2"}\r\n|EventsTable2|acbd207d-51aa-4df7-bfa7-be70eb68f04e|Error|Some Other Text3|{"EventName":"Event3"}\r\n\r\n### Return the results from each row as a property bag\r\n\r\n```\r\nfind Session_Id == \'acbd207d-51aa-4df7-bfa7-be70eb68f04e\' project pack(*)\r\n```\r\n\r\n|source_|pack_|\r\n|---|---|\r\n|EventsTable1|{"Session_Id":"acbd207d-51aa-4df7-bfa7-be70eb68f04e", "Level":"Information", "EventText":"Some Text1", "Version":"v1.0.0"}\r\n|EventsTable1|{"Session_Id":"acbd207d-51aa-4df7-bfa7-be70eb68f04e", "Level":"Error", "EventText":"Some Text2", "Version":"v1.0.0"}\r\n|EventsTable2|{"Session_Id":"acbd207d-51aa-4df7-bfa7-be70eb68f04e", "Level":"Information", "EventText":"Some Other Text2", "EventName":"Event2"}\r\n|EventsTable2|{"Session_Id":"acbd207d-51aa-4df7-bfa7-be70eb68f04e", "Level":"Error", "EventText":"Some Other Text3", "EventName":"Event3"}\r\n\r\n## Examples of cases where `find` will act as `union`\r\n\r\n### Using a non-tabular expression as find operand\r\n\r\n```\r\nlet PartialEventsTable1 = view() { EventsTable1 | where Level == \'Error\' };\r\nfind in (PartialEventsTable1, EventsTable2) \r\n     where Session_Id == \'acbd207d-51aa-4df7-bfa7-be70eb68f04e\'\r\n```\r\n\r\n### Referencing a column that appears in multiple tables and has multiple types\r\n\r\nAssume we\'ve created two tables by running: \r\n\r\n```\r\n.create tables \r\n  Table1 (Level:string, Timestamp:datetime, ProcessId:string),\r\n  Table2 (Level:string, Timestamp:datetime, ProcessId:int64)\r\n```\r\n\r\n* The following query will be executed as `union`.\r\n\r\n\r\n\r\n```\r\nfind in (Table1, Table2) where ProcessId == 1001\r\n```\r\n\r\nThe output result schema will be *(Level:string, Timestamp, ProcessId_string, ProcessId_int)*.\r\n\r\n* The following query will also be executed as `union`, but will produce a different result schema.\r\n\r\n\r\n\r\n```\r\nfind in (Table1, Table2) where ProcessId == 1001 project Level, Timestamp, ProcessId:string \r\n```\r\n\r\nThe output result schema will be *(Level:string, Timestamp, ProcessId_string)*',"https://docs.microsoft.com/en-us/azure/kusto/query/findoperator","findoperator.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"floor","An alias for [`bin()`](binfunction.md).","","","https://docs.microsoft.com/en-us/azure/kusto/query/floorfunction","")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.OperatorToken,"fork","Runs multiple consumer operators in parallel.","## Syntax\r\n\r\n*T* `|` `fork` [*name*`=`]`(`*subquery*`)` [*name*`=`]`(`*subquery*`)` ...\r\n\r\n## Arguments\r\n\r\n* *subquery* is a downstream pipeline of query operators\r\n* *name* is a temporary name for the subquery result table\r\n\r\n## Returns\r\n\r\nMultiple result tables, one for each of the subqueries.\r\n\r\n**Supported Operators**\r\n\r\n[`as`](asoperator.md), [`count`](countoperator.md), [`extend`](extendoperator.md), [`parse`](parseoperator.md), [`where`](whereoperator.md), [`take`](takeoperator.md), [`project`](projectoperator.md), [`project-away`](projectawayoperator.md), [`summarize`](summarizeoperator.md), [`top`](topoperator.md), [`top-nested`](topnestedoperator.md), [`sort`](sortoperator.md), [`mv-expand`](mvexpandoperator.md), [`reduce`](reduceoperator.md)\r\n\r\n**Notes**\r\n\r\n* [`materialize`](materializefunction.md) function can be used as a replacement for using [`join`](joinoperator.md) or [`union`](unionoperator.md) on fork legs.\r\nThe input stream will be cached by materialize and then the cached expression can be used in join/union legs.\r\n* A name, given by the `name` argument or by using [`as`](asoperator.md) operator will be used as the to name the result tab in [`Kusto.Explorer`](../tools/kusto-explorer.md) tool.\r\n* Avoid using `fork` with a single subquery.\r\n* Prefer using [batch](batches.md) with [`materialize`](materializefunction.md) of tabular expression statements over `fork` operator.",'```\r\nKustoLogs\r\n| where Timestamp > ago(1h)\r\n| fork\r\n    ( where Level == "Error" | project EventText | limit 100 )\r\n    ( project Timestamp, EventText | top 1000 by Timestamp desc)\r\n    ( summarize min(Timestamp), max(Timestamp) by ActivityID )\r\n \r\n// In the following examples the result tables will be named: Errors, EventsTexts and TimeRangePerActivityID\r\nKustoLogs\r\n| where Timestamp > ago(1h)\r\n| fork\r\n    ( where Level == "Error" | project EventText | limit 100 | as Errors )\r\n    ( project Timestamp, EventText | top 1000 by Timestamp desc | as EventsTexts )\r\n    ( summarize min(Timestamp), max(Timestamp) by ActivityID | as TimeRangePerActivityID )\r\n    \r\n KustoLogs\r\n| where Timestamp > ago(1h)\r\n| fork\r\n    Errors = ( where Level == "Error" | project EventText | limit 100 )\r\n    EventsTexts = ( project Timestamp, EventText | top 1000 by Timestamp desc )\r\n    TimeRangePerActivityID = ( summarize min(Timestamp), max(Timestamp) by ActivityID )\r\n```',"https://docs.microsoft.com/en-us/azure/kusto/query/forkoperator","forkoperator.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"format_bytes","Formats a number as a string representing data size in bytes.","```\r\nformat_bytes(1024) == '1 KB'\"\r\n```\r\n\r\n## Syntax\r\n\r\n`format_bytes(`*value* [`,` *precision* [`,` *units*]]`)`\r\n\r\n## Arguments\r\n\r\n* `value`: a number to be formatted as data size in bytes.\r\n* `precision`: (optional) Number of digits the value will be rounded to. (default value is 0).\r\n* `units`: (optional) Units of the target data size the string formatting will use (`Bytes`, `KB`, `MB`, `GB`, `TB`, `PB`). If parameter is empty - the units will be auto-selected based on input value.\r\n\r\n## Returns\r\n\r\nThe string with the format result.",'```\r\nprint \r\nv1 = format_bytes(564),\r\nv2 = format_bytes(10332, 1),\r\nv3 = format_bytes(20010332),\r\nv4 = format_bytes(20010332, 2),\r\nv5 = format_bytes(20010332, 0, "KB")\r\n```\r\n\r\n|v1|v2|v3|v4|v5|\r\n|---|---|---|---|---|\r\n|564 Bytes|10.1 KB|19 MB|19.08 MB|19541 KB|',"https://docs.microsoft.com/en-us/azure/kusto/query/format-bytesfunction","format-bytesfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"format_datetime","Formats a datetime according to the provided format.","```\r\nformat_datetime(datetime(2015-12-14 02:03:04.12345), 'y-M-d h:m:s.fffffff') == \"15-12-14 2:3:4.1234500\"\r\n```\r\n\r\n## Syntax\r\n\r\n`format_datetime(`*datetime* `,` *format*`)`\r\n\r\n## Arguments\r\n\r\n* `datetime`: value of a type `datetime`.\r\n* `format`: format specifier string, consisting of one or more [format elements](#supported-formats).\r\n\r\n## Returns\r\n\r\nThe string with the format result.\r\n\r\n## Supported formats\r\n\r\n|Format specifier\t|Description\t|Examples\r\n|---|---|---\r\n|`d`\t|The day of the month, from 1 through 31. |\t2009-06-01T13:45:30 -> 1, 2009-06-15T13:45:30 -> 15\r\n|`dd`\t|The day of the month, from 01 through 31.|\t2009-06-01T13:45:30 -> 01, 2009-06-15T13:45:30 -> 15\r\n|`f`\t|The tenths of a second in a date and time value. |2009-06-15T13:45:30.6170000 -> 6, 2009-06-15T13:45:30.05 -> 0\r\n|`ff`\t|The hundredths of a second in a date and time value. |2009-06-15T13:45:30.6170000 -> 61, 2009-06-15T13:45:30.0050000 -> 00\r\n|`fff`\t|The milliseconds in a date and time value. |6/15/2009 13:45:30.617 -> 617, 6/15/2009 13:45:30.0005 -> 000\r\n|`ffff`\t|The ten thousandths of a second in a date and time value. |2009-06-15T13:45:30.6175000 -> 6175, 2009-06-15T13:45:30.0000500 -> 0000\r\n|`fffff`\t|The hundred thousandths of a second in a date and time value. |2009-06-15T13:45:30.6175400 -> 61754, 2009-06-15T13:45:30.000005 -> 00000\r\n|`ffffff`\t|The millionths of a second in a date and time value. |2009-06-15T13:45:30.6175420 -> 617542, 2009-06-15T13:45:30.0000005 -> 000000\r\n|`fffffff`\t|The ten millionths of a second in a date and time value. |2009-06-15T13:45:30.6175425 -> 6175425, 2009-06-15T13:45:30.0001150 -> 0001150\r\n|`F`\t|If non-zero, the tenths of a second in a date and time value. |2009-06-15T13:45:30.6170000 -> 6, 2009-06-15T13:45:30.0500000 -> (no output)\r\n|`FF`\t|If non-zero, the hundredths of a second in a date and time value. |2009-06-15T13:45:30.6170000 -> 61, 2009-06-15T13:45:30.0050000 -> (no output)\r\n|`FFF`\t|If non-zero, the milliseconds in a date and time value. |2009-06-15T13:45:30.6170000 -> 617, 2009-06-15T13:45:30.0005000 -> (no output)\r\n|`FFFF`\t|If non-zero, the ten thousandths of a second in a date and time value. |2009-06-15T13:45:30.5275000 -> 5275, 2009-06-15T13:45:30.0000500 -> (no output)\r\n|`FFFFF`\t|If non-zero, the hundred thousandths of a second in a date and time value. |2009-06-15T13:45:30.6175400 -> 61754, 2009-06-15T13:45:30.0000050 -> (no output)\r\n|`FFFFFF`\t|If non-zero, the millionths of a second in a date and time value. |2009-06-15T13:45:30.6175420 -> 617542, 2009-06-15T13:45:30.0000005 -> (no output)\r\n|`FFFFFFF`\t|If non-zero, the ten millionths of a second in a date and time value. |2009-06-15T13:45:30.6175425 -> 6175425, 2009-06-15T13:45:30.0001150 -> 000115\r\n|`h`\t|The hour, using a 12-hour clock from 1 to 12. |2009-06-15T01:45:30 -> 1, 2009-06-15T13:45:30 -> 1\r\n|`hh`\t|The hour, using a 12-hour clock from 01 to 12. |2009-06-15T01:45:30 -> 01, 2009-06-15T13:45:30 -> 01\r\n|`H`\t|The hour, using a 24-hour clock from 0 to 23. |2009-06-15T01:45:30 -> 1, 2009-06-15T13:45:30 -> 13\r\n|`HH`\t|The hour, using a 24-hour clock from 00 to 23. |2009-06-15T01:45:30 -> 01, 2009-06-15T13:45:30 -> 13\r\n|`m`\t|The minute, from 0 through 59. |2009-06-15T01:09:30 -> 9, 2009-06-15T13:29:30 -> 29\r\n|`mm`\t|The minute, from 00 through 59. |2009-06-15T01:09:30 -> 09, 2009-06-15T01:45:30 -> 45\r\n|`M`\t|The month, from 1 through 12. |2009-06-15T13:45:30 -> 6\r\n|`MM`\t|The month, from 01 through 12.|2009-06-15T13:45:30 -> 06\r\n|`s`\t|The second, from 0 through 59. |2009-06-15T13:45:09 -> 9\r\n|`ss`\t|The second, from 00 through 59. |2009-06-15T13:45:09 -> 09\r\n|`y`\t|The year, from 0 to 99. |0001-01-01T00:00:00 -> 1, 0900-01-01T00:00:00 -> 0, 1900-01-01T00:00:00 -> 0, 2009-06-15T13:45:30 -> 9, 2019-06-15T13:45:30 -> 19\r\n|`yy`\t|The year, from 00 to 99. |\t0001-01-01T00:00:00 -> 01, 0900-01-01T00:00:00 -> 00, 1900-01-01T00:00:00 -> 00, 2019-06-15T13:45:30 -> 19\r\n|`yyyy`\t|The year as a four-digit number. |\t0001-01-01T00:00:00 -> 0001, 0900-01-01T00:00:00 -> 0900, 1900-01-01T00:00:00 -> 1900, 2009-06-15T13:45:30 -> 2009\r\n|`tt`\t|AM / PM hours |2009-06-15T13:45:09 -> PM\r\n\r\n**Supported delimeters**\r\n\r\nFormat specifier can include following delimeters characters:\r\n\r\n|Delimeter|Comment|\r\n|---------|-------|\r\n|`' '`| Space|\r\n|`'/'`||\r\n|`'-'`|Dash|\r\n|`':'`||\r\n|`','`||\r\n|`'.'`||\r\n|`'_'`||\r\n|`'['`||\r\n|`']'`||","```\r\nlet dt = datetime(2017-01-29 09:00:05);\r\nprint \r\nv1=format_datetime(dt,'yy-MM-dd [HH:mm:ss]'), \r\nv2=format_datetime(dt, 'yyyy-M-dd [H:mm:ss]'),\r\nv3=format_datetime(dt, 'yy-MM-dd [hh:mm:ss tt]')\r\n```\r\n\r\n|v1|v2|v3|\r\n|---|---|---|\r\n|17-01-29 [09:00:05]|2017-1-29 [9:00:05]|17-01-29 [09:00:05 AM]|","https://docs.microsoft.com/en-us/azure/kusto/query/format-datetimefunction","format-datetimefunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"format_ipv4","Parses input with a netmask and returns string representing IPv4 address.","```\r\nprint format_ipv4('192.168.1.255', 24) == '192.168.1.0'\r\nprint format_ipv4(3232236031, 24) == '192.168.1.0'\r\n```\r\n\r\n## Syntax\r\n\r\n`format_ipv4(`*Expr* [`,` *PrefixMask*`])`\r\n\r\n## Arguments\r\n\r\n* *`Expr`*: A string or number representation of the IPv4 address.\r\n* *`PrefixMask`*: (Optional) An integer from 0 to 32 representing the number of most-significant bits that are taken into account. If argument isn't specified, all bit-masks are used (32).\r\n\r\n## Returns\r\n\r\nIf conversion is successful, the result will be a string representing IPv4 address.\r\nIf conversion isn't successful, the result will be an empty string.\r\n\r\n## See also\r\n\r\n- [format_ipv4_mask()](format-ipv4-mask-function.md): For IPv4 address formatting including CIDR notation.\r\n- [IPv4 and IPv6 functions](scalarfunctions.md#ipv4ipv6-functions)","```\r\ndatatable(address:string, mask:long)\r\n[\r\n '192.168.1.1', 24,          \r\n '192.168.1.1', 32,          \r\n '192.168.1.1/24', 32,       \r\n '192.168.1.1/24', long(-1), \r\n]\r\n| extend result = format_ipv4(address, mask), \r\n         result_mask = format_ipv4_mask(address, mask)\r\n```\r\n\r\n|address|mask|result|result_mask|\r\n|---|---|---|---|\r\n|192.168.1.1|24|192.168.1.0|192.168.1.0/24|\r\n|192.168.1.1|32|192.168.1.1|192.168.1.1/32|\r\n|192.168.1.1/24|32|192.168.1.0|192.168.1.0/24|\r\n|192.168.1.1/24|-1|||","https://docs.microsoft.com/en-us/azure/kusto/query/format-ipv4-function","format-ipv4-function.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"format_ipv4_mask","Parses input with a netmask and returns string representing IPv4 address as CIDR notation.","```\r\nprint format_ipv4_mask('192.168.1.255', 24) == '192.168.1.0/24'\r\nprint format_ipv4_mask(3232236031, 24) == '192.168.1.0/24'\r\n```\r\n\r\n## Syntax\r\n\r\n`format_ipv4_mask(`*Expr* [`,` *PrefixMask*`])`\r\n\r\n## Arguments\r\n\r\n* *`Expr`*: A string or number representation of the IPv4 address as CIDR notation.\r\n* *`PrefixMask`*: (Optional) An integer from 0 to 32 representing the number of most-significant bits that are taken into account. If argument isn't specified, all bit-masks are used (32).\r\n\r\n## Returns\r\n\r\nIf conversion is successful, the result will be a string representing IPv4 address as CIDR notation.\r\nIf conversion isn't successful, the result will be an empty string.\r\n\r\n## See also\r\n\r\n- [format_ipv4()](format-ipv4-function.md): For IPv4 address formatting without CIDR notation.\r\n- [IPv4 and IPv6 functions](scalarfunctions.md#ipv4ipv6-functions)","```\r\ndatatable(address:string, mask:long)\r\n[\r\n '192.168.1.1', 24,          \r\n '192.168.1.1', 32,          \r\n '192.168.1.1/24', 32,       \r\n '192.168.1.1/24', long(-1), \r\n]\r\n| extend result = format_ipv4(address, mask), \r\n         result_mask = format_ipv4_mask(address, mask)\r\n```\r\n\r\n|address|mask|result|result_mask|\r\n|---|---|---|---|\r\n|192.168.1.1|24|192.168.1.0|192.168.1.0/24|\r\n|192.168.1.1|32|192.168.1.1|192.168.1.1/32|\r\n|192.168.1.1/24|32|192.168.1.0|192.168.1.0/24|\r\n|192.168.1.1/24|-1|||","https://docs.microsoft.com/en-us/azure/kusto/query/format-ipv4-mask-function","format-ipv4-mask-function.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"format_timespan","Formats a timespan according to the provided format.","```\r\nformat_timespan(time(14.02:03:04.12345), 'h:m:s.fffffff') == \"2:3:4.1234500\"\r\n```\r\n\r\n## Syntax\r\n\r\n`format_timespan(`*timespan* `,` *format*`)`\r\n\r\n## Arguments\r\n\r\n* `timespan`: value of a type `timespan`.\r\n* `format`: format specifier string, consisting of one or more [format elements](#supported-formats).\r\n\r\n## Returns\r\n\r\nThe string with the format result.\r\n\r\n## Supported formats\r\n\r\n|Format specifier\t|Description\t|Examples\r\n|---|---|---\r\n|`d`-`dddddddd`\t|The number of whole days in the time interval. Padded with zeros if needed.|\t15.13:45:30: d -> 15, dd -> 15, ddd -> 015\r\n|`f`\t|The tenths of a second in the time interval. |15.13:45:30.6170000 -> 6, 15.13:45:30.05 -> 0\r\n|`ff`\t|The hundredths of a second in the time interval. |15.13:45:30.6170000 -> 61, 15.13:45:30.0050000 -> 00\r\n|`fff`\t|The milliseconds in the time interval. |6/15/2009 13:45:30.617 -> 617, 6/15/2009 13:45:30.0005 -> 000\r\n|`ffff`\t|The ten thousandths of a second in the time interval. |15.13:45:30.6175000 -> 6175, 15.13:45:30.0000500 -> 0000\r\n|`fffff`\t|The hundred thousandths of a second in the time interval. |15.13:45:30.6175400 -> 61754, 15.13:45:30.000005 -> 00000\r\n|`ffffff`\t|The millionths of a second in the time interval. |15.13:45:30.6175420 -> 617542, 15.13:45:30.0000005 -> 000000\r\n|`fffffff`\t|The ten millionths of a second in the time interval. |15.13:45:30.6175425 -> 6175425, 15.13:45:30.0001150 -> 0001150\r\n|`F`\t|If non-zero, the tenths of a second in the time interval. |15.13:45:30.6170000 -> 6, 15.13:45:30.0500000 -> (no output)\r\n|`FF`\t|If non-zero, the hundredths of a second in the time interval. |15.13:45:30.6170000 -> 61, 15.13:45:30.0050000 -> (no output)\r\n|`FFF`\t|If non-zero, the milliseconds in the time interval. |15.13:45:30.6170000 -> 617, 15.13:45:30.0005000 -> (no output)\r\n|`FFFF`\t|If non-zero, the ten thousandths of a second in the time interval. |15.13:45:30.5275000 -> 5275, 15.13:45:30.0000500 -> (no output)\r\n|`FFFFF`\t|If non-zero, the hundred thousandths of a second in the time interval. |15.13:45:30.6175400 -> 61754, 15.13:45:30.0000050 -> (no output)\r\n|`FFFFFF`\t|If non-zero, the millionths of a second in the time interval. |15.13:45:30.6175420 -> 617542, 15.13:45:30.0000005 -> (no output)\r\n|`FFFFFFF`\t|If non-zero, the ten millionths of a second in the time interval. |15.13:45:30.6175425 -> 6175425, 15.13:45:30.0001150 -> 000115\r\n|`h`\t|The number of whole hours in the time interval that are not counted as part of days. Single-digit hours do not have a leading zero. |15.01:45:30 -> 1, 15.13:45:30 -> 1\r\n|`hh`\t|The number of whole hours in the time interval that are not counted as part of days. Single-digit hours have a leading zero. |15.01:45:30 -> 01, 15.13:45:30 -> 01\r\n|`H`\t|The hour, using a 24-hour clock from 0 to 23. |15.01:45:30 -> 1, 15.13:45:30 -> 13\r\n|`HH`\t|The hour, using a 24-hour clock from 00 to 23. |15.01:45:30 -> 01, 15.13:45:30 -> 13\r\n|`m`\t|The number of whole minutes in the time interval that are not included as part of hours or days. Single-digit minutes do not have a leading zero. |15.01:09:30 -> 9, 15.13:29:30 -> 29\r\n|`mm`\t|The number of whole minutes in the time interval that are not included as part of hours or days. Single-digit minutes have a leading zero. |15.01:09:30 -> 09, 15.01:45:30 -> 45\r\n|`s`\t|The number of whole seconds in the time interval that are not included as part of hours, days, or minutes. Single-digit seconds do not have a leading zero. |15.13:45:09 -> 9\r\n|`ss`\t|The number of whole seconds in the time interval that are not included as part of hours, days, or minutes. Single-digit seconds have a leading zero. |15.13:45:09 -> 09\r\n\r\n**Supported delimeters**\r\n\r\nFormat specifier can include following delimeters characters:\r\n\r\n|Delimeter|Comment|\r\n|---------|-------|\r\n|`' '`| Space|\r\n|`'/'`||\r\n|`'-'`|Dash|\r\n|`':'`||\r\n|`','`||\r\n|`'.'`||\r\n|`'_'`||\r\n|`'['`||\r\n|`']'`||","```\r\nlet t = time(29.09:00:05.12345);\r\nprint \r\nv1=format_timespan(t, 'dd.hh:mm:ss:FF'),\r\nv2=format_timespan(t, 'ddd.h:mm:ss [fffffff]')\r\n```\r\n\r\n|v1|v2|\r\n|---|---|\r\n|29.09:00:05:12|029.9:00:05 [1234500]|","https://docs.microsoft.com/en-us/azure/kusto/query/format-timespanfunction","format-timespanfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"gamma","Computes [gamma function](https://en.wikipedia.org/wiki/Gamma_function)","## Syntax\r\n\r\n`gamma(`*x*`)`\r\n\r\n## Arguments\r\n\r\n* *x*: Parameter for the gamma function\r\n\r\n## Returns\r\n\r\n* Gamma function of x.\r\n* For computing log-gamma function, see [loggamma()](loggammafunction.md).","","https://docs.microsoft.com/en-us/azure/kusto/query/gammafunction","")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"geo_distance_2points","Calculates the shortest distance between two geospatial coordinates on Earth.","## Syntax\r\n\r\n`geo_distance_2points(`*p1_longitude*`, `*p1_latitude*`, `*p2_longitude*`, `*p2_latitude*`)`\r\n\r\n## Arguments\r\n\r\n* *p1_longitude*: First geospatial coordinate, longitude value in degrees. Valid value is a real number and in the range [-180, +180].\r\n* *p1_latitude*: First geospatial coordinate, latitude value in degrees. Valid value is a real number and in the range [-90, +90].\r\n* *p2_longitude*: Second geospatial coordinate, longitude value in degrees. Valid value is a real number and in the range [-180, +180].\r\n* *p2_latitude*: Second geospatial coordinate, latitude value in degrees. Valid value is a real number and in the range [-90, +90].\r\n\r\n## Returns\r\n\r\nThe shortest distance, in meters, between two geographic locations on Earth. If the coordinates are invalid, the query will produce a null result.\r\n\r\n> [!NOTE]\r\n> * The geospatial coordinates are interpreted as represented by the [WGS-84](https://earth-info.nga.mil/GandG/update/index.php?action=home) coordinate reference system.\r\n> * The [geodetic datum](https://en.wikipedia.org/wiki/Geodetic_datum) used to measure distance on Earth is a sphere.",'The following example finds the shortest distance between Seattle and Los Angeles.\r\n\r\n![Distance between Seattle and Los Angeles](images/geo-distance-2points-function/distance_2points_seattle_los_angeles.png)\r\n\r\n```\r\nprint distance_in_meters = geo_distance_2points(-122.407628, 47.578557, -118.275287, 34.019056)\r\n```\r\n\r\n| distance_in_meters |\r\n|--------------------|\r\n| 1546754.35197381   |\r\n\r\nHere is an approximation of shortest path from Seattle to London. The line consists of coordinates along the LineString and within 500 meters from it.\r\n\r\n![Seattle to London LineString](images/geo-distance-2points-function/line_seattle_london.png)\r\n\r\n```\r\nrange i from 1 to 1000000 step 1\r\n| project lng = rand() * real(-122), lat = rand() * 90\r\n| where lng between(real(-122) .. 0) and lat between(47 .. 90)\r\n| where geo_distance_point_to_line(lng,lat,dynamic({"type":"LineString","coordinates":[[-122,47],[0,51]]})) < 500\r\n| render scatterchart with (kind=map) // map rendering available in Kusto Explorer desktop\r\n```\r\n\r\nThe following example finds all rows in which the shortest distance between two coordinates is between 1 and 11 meters.\r\n\r\n```\r\nStormEvents\r\n| extend distance_1_to_11m = geo_distance_2points(BeginLon, BeginLat, EndLon, EndLat)\r\n| where distance_1_to_11m between (1 .. 11)\r\n| project distance_1_to_11m\r\n```\r\n\r\n| distance_1_to_11m |\r\n|-------------------|\r\n| 10.5723100154958  |\r\n| 7.92153588248414  |\r\n\r\nThe following example returns a null result because of the invalid coordinate input.\r\n\r\n```\r\nprint distance = geo_distance_2points(300,1,1,1)\r\n```\r\n\r\n| distance |\r\n|----------|\r\n|          |',"https://docs.microsoft.com/en-us/azure/kusto/query/geo-distance-2points-function","geo-distance-2points-function.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"geo_distance_point_to_line","Calculates the shortest distance between a coordinate and a line or multiline on Earth.",'## Syntax\r\n\r\n`geo_distance_point_to_line(`*longitude*`, `*latitude*`, `*lineString*`)`\r\n\r\n## Arguments\r\n\r\n* *longitude*: Geospatial coordinate longitude value in degrees. Valid value is a real number and in the range [-180, +180].\r\n* *latitude*: Geospatial coordinate latitude value in degrees. Valid value is a real number and in the range [-90, +90].\r\n* *lineString*: Line or multiline in the [GeoJSON format](https://tools.ietf.org/html/rfc7946) and of a [dynamic](./scalar-data-types/dynamic.md) data type.\r\n\r\n## Returns\r\n\r\nThe shortest distance, in meters, between a coordinate and a line on Earth. If the coordinate or lineString are invalid, the query will produce a null result.\r\n\r\n> [!NOTE]\r\n> * The geospatial coordinates are interpreted as represented by the [WGS-84](https://earth-info.nga.mil/GandG/update/index.php?action=home) coordinate reference system.\r\n> * The [geodetic datum](https://en.wikipedia.org/wiki/Geodetic_datum) used to measure distance on Earth is a sphere. Line edges are [geodesics](https://en.wikipedia.org/wiki/Geodesic) on the sphere.\r\n> * If input line edges are straight cartesian lines, consider using [geo_line_densify()](geo-line-densify-function.md) in order to convert planar edges to geodesics.\r\n\r\n**LineString definition and constraints**\r\n\r\ndynamic({"type": "LineString","coordinates": [ [lng_1,lat_1], [lng_2,lat_2] ,..., [lng_N,lat_N] ]})\r\n\r\ndynamic({"type": "MultiLineString","coordinates": [ [ line_1, line_2 ,..., line_N ] ]})\r\n\r\n* LineString coordinates array must contain at least two entries.\r\n* Coordinates [longitude,latitude] must be valid where longitude is a real number in the range [-180, +180] and latitude is a real number in the range [-90, +90].\r\n* Edge length must be less than 180 degrees. The shortest edge between the two vertices will be chosen.\r\n\r\n> [!TIP]\r\n> For better performance, use literal lines.','The following example finds the shortest distance between North Las Vegas Airport and a nearby road.\r\n\r\n![Distance between North Las Vegas Airport and road](images/geo-distance-point-to-line-function/distance-point-to-line.png)\r\n\r\n```\r\nprint distance_in_meters = geo_distance_point_to_line(-115.199625, 36.210419, dynamic({ "type":"LineString","coordinates":[[-115.115385,36.229195],[-115.136995,36.200366],[-115.140252,36.192470],[-115.143558,36.188523],[-115.144076,36.181954],[-115.154662,36.174483],[-115.166431,36.176388],[-115.183289,36.175007],[-115.192612,36.176736],[-115.202485,36.173439],[-115.225355,36.174365]]}))\r\n```\r\n\r\n| distance_in_meters |\r\n|--------------------|\r\n| 3797.88887253334   |\r\n\r\nStorm events in south coast US. The events are filtered by a maximum distance of 5 km from the defined shore line.\r\n\r\n![Storm events in the US south coast](images/geo-distance-point-to-line-function/us-south-coast-storm-events.png)\r\n\r\n```\r\nlet southCoast = dynamic({"type":"LineString","coordinates":[[-97.18505859374999,25.997549919572112],[-97.58056640625,26.96124577052697],[-97.119140625,27.955591004642553],[-94.04296874999999,29.726222319395504],[-92.98828125,29.82158272057499],[-89.18701171875,29.11377539511439],[-89.384765625,30.315987718557867],[-87.5830078125,30.221101852485987],[-86.484375,30.4297295750316],[-85.1220703125,29.6880527498568],[-84.00146484374999,30.14512718337613],[-82.6611328125,28.806173508854776],[-82.81494140625,28.033197847676377],[-82.177734375,26.52956523826758],[-80.9912109375,25.20494115356912]]});\r\nStormEvents\r\n| project BeginLon, BeginLat, EventType\r\n| where geo_distance_point_to_line(BeginLon, BeginLat, southCoast) < 5000\r\n| render scatterchart with (kind=map) // map rendering available in Kusto Explorer desktop\r\n```\r\n\r\nNY taxi pickups. Pickups are filtered by maximum distance of 0.1 meters from the defined multiline.\r\n\r\n![NYC taxi pickups on Madison Ave](images/geo-distance-point-to-line-function/madison-ave-road.png)\r\n\r\n```\r\nlet MadisonAve = dynamic({"type":"MultiLineString","coordinates":[[[-73.9879823,40.7408625],[-73.9876492,40.7413345],[-73.9874982,40.7415046],[-73.9870343,40.7421446],[-73.9865812,40.7427655],[-73.9861292,40.7433756],[-73.9856813,40.7439956],[-73.9854932,40.7442606],[-73.9852232,40.7446216],[-73.9847903,40.7452305],[-73.9846232,40.7454536],[-73.9844803,40.7456606],[-73.9843413,40.7458585],[-73.9839533,40.7463955],[-73.9839002,40.7464696],[-73.9837683,40.7466566],[-73.9834342,40.7471015],[-73.9833833,40.7471746],[-73.9829712,40.7477686],[-73.9824752,40.7484255],[-73.9820262,40.7490436],[-73.9815623,40.7496566],[-73.9811212,40.7502796],[-73.9809762,40.7504976],[-73.9806982,40.7509255],[-73.9802752,40.7515216],[-73.9798033,40.7521795],[-73.9795863,40.7524656],[-73.9793082,40.7528316],[-73.9787872,40.7534725],[-73.9783433,40.7540976],[-73.9778912,40.7547256],[-73.9774213,40.7553365],[-73.9769402,40.7559816],[-73.9764622,40.7565766],[-73.9760073,40.7572036],[-73.9755592,40.7578366],[-73.9751013,40.7584665],[-73.9746532,40.7590866],[-73.9741902,40.7597326],[-73.9737632,40.7603566],[-73.9733032,40.7609866],[-73.9728472,40.7616205],[-73.9723422,40.7622826],[-73.9718672,40.7629556],[-73.9714042,40.7635726],[-73.9709362,40.7642185],[-73.9705282,40.7647636],[-73.9704903,40.7648196],[-73.9703342,40.7650355],[-73.9701562,40.7652826],[-73.9700322,40.7654535],[-73.9695742,40.7660886],[-73.9691232,40.7667166],[-73.9686672,40.7673375],[-73.9682142,40.7679605],[-73.9677482,40.7685786],[-73.9672883,40.7692076],[-73.9668412,40.7698296],[-73.9663882,40.7704605],[-73.9659222,40.7710936],[-73.9654262,40.7717756],[-73.9649292,40.7724595],[-73.9644662,40.7730955],[-73.9640012,40.7737285],[-73.9635382,40.7743615],[-73.9630692,40.7749936],[-73.9626122,40.7756275],[-73.9621172,40.7763106],[-73.9616111,40.7769896],[-73.9611552,40.7776245],[-73.9606891,40.7782625],[-73.9602212,40.7788866],[-73.9597532,40.7795236],[-73.9595842,40.7797445],[-73.9592942,40.7801635],[-73.9591122,40.7804105],[-73.9587982,40.7808305],[-73.9582992,40.7815116],[-73.9578452,40.7821455],[-73.9573802,40.7827706],[-73.9569262,40.7833965],[-73.9564802,40.7840315],[-73.9560102,40.7846486],[-73.9555601,40.7852755],[-73.9551221,40.7859005],[-73.9546752,40.7865426],[-73.9542571,40.7871505],[-73.9541771,40.7872335],[-73.9540892,40.7873366],[-73.9536971,40.7879115],[-73.9532792,40.7884706],[-73.9532142,40.7885205],[-73.9531522,40.7885826],[-73.9527382,40.7891785],[-73.9523081,40.7897545],[-73.9518332,40.7904115],[-73.9513721,40.7910435],[-73.9509082,40.7916695],[-73.9504602,40.7922995],[-73.9499882,40.7929195],[-73.9495051,40.7936045],[-73.9490071,40.7942835],[-73.9485542,40.7949065],[-73.9480832,40.7955345],[-73.9476372,40.7961425],[-73.9471772,40.7967915],[-73.9466841,40.7974475],[-73.9453432,40.7992905],[-73.9448332,40.7999835],[-73.9443442,40.8006565],[-73.9438862,40.8012945],[-73.9434262,40.8019196],[-73.9431412,40.8023325],[-73.9429842,40.8025585],[-73.9425691,40.8031855],[-73.9424401,40.8033609],[-73.9422987,40.8035533],[-73.9422013,40.8036857],[-73.9421022,40.8038205],[-73.9420024,40.8039552],[-73.9416372,40.8044485],[-73.9411562,40.8050725],[-73.9406471,40.8057176],[-73.9401481,40.8064135],[-73.9397022,40.8070255],[-73.9394081,40.8074155],[-73.9392351,40.8076495],[-73.9387842,40.8082715],[-73.9384681,40.8087086],[-73.9383211,40.8089025],[-73.9378792,40.8095215],[-73.9374011,40.8101795],[-73.936405,40.8115707],[-73.9362328,40.8118098]],[[-73.9362328,40.8118098],[-73.9362432,40.8118567],[-73.9361239,40.8120222],[-73.9360302,40.8120805]],[[-73.9362328,40.8118098],[-73.9361571,40.8118294],[-73.9360443,40.8119993],[-73.9360302,40.8120805]],[[-73.9360302,40.8120805],[-73.9359423,40.8121378],[-73.9358551,40.8122385],[-73.9352181,40.8130815],[-73.9348702,40.8135515],[-73.9347541,40.8137145],[-73.9346332,40.8138615],[-73.9345542,40.8139595],[-73.9344981,40.8139945],[-73.9344571,40.8140165],[-73.9343962,40.8140445],[-73.9343642,40.8140585],[-73.9343081,40.8140725],[-73.9341971,40.8140895],[-73.9341041,40.8141005],[-73.9340022,40.8140965],[-73.9338442,40.8141005],[-73.9333712,40.8140895],[-73.9325541,40.8140755],[-73.9324561,40.8140705],[-73.9324022,40.8140695]],[[-73.9360302,40.8120805],[-73.93605,40.8121667],[-73.9359632,40.8122805],[-73.9353631,40.8130795],[-73.9351482,40.8133625],[-73.9350072,40.8135415],[-73.9347441,40.8139168],[-73.9346611,40.8140125],[-73.9346101,40.8140515],[-73.9345401,40.8140965],[-73.9344381,40.8141385],[-73.9343451,40.8141555],[-73.9342991,40.8141675],[-73.9341552,40.8141985],[-73.9338601,40.8141885],[-73.9333991,40.8141815],[-73.9323981,40.8141665]]]});\r\nnyc_taxi\r\n| project pickup_longitude, pickup_latitude\r\n| where geo_distance_point_to_line(pickup_longitude, pickup_latitude, MadisonAve) <= 0.1\r\n| take 100\r\n| render scatterchart with (kind=map) // map rendering available in Kusto Explorer desktop\r\n```\r\n\r\nThe following example will return a null result because of the invalid LineString input.\r\n\r\n```\r\nprint distance_in_meters = geo_distance_point_to_line(1,1, dynamic({ "type":"LineString"}))\r\n```\r\n\r\n| distance_in_meters |\r\n|--------------------|\r\n|                    |\r\n\r\nThe following example will return a null result because of the invalid coordinate input.\r\n\r\n```\r\nprint distance_in_meters = geo_distance_point_to_line(300, 3, dynamic({ "type":"LineString","coordinates":[[1,1],[2,2]]}))\r\n```\r\n\r\n| distance_in_meters |\r\n|--------------------|\r\n|                    |',"https://docs.microsoft.com/en-us/azure/kusto/query/geo-distance-point-to-line-function","geo-distance-point-to-line-function.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"geo_geohash_to_central_point","Calculates the geospatial coordinates that represent the center of a geohash rectangular area.","Read more about [`geohash`](https://en.wikipedia.org/wiki/Geohash).  \r\n\r\n## Syntax\r\n\r\n`geo_geohash_to_central_point(`*geohash*`)`\r\n\r\n## Arguments\r\n\r\n*geohash*: Geohash string value as it was calculated by [geo_point_to_geohash()](geo-point-to-geohash-function.md). The geohash string can be 1 to 18 characters.\r\n\r\n## Returns\r\n\r\nThe geospatial coordinate values in [GeoJSON Format](https://tools.ietf.org/html/rfc7946) and of a [dynamic](./scalar-data-types/dynamic.md) data type. If the geohash is invalid, the query will produce a null result.\r\n\r\n> [!NOTE]\r\n> The GeoJSON format specifies longitude first and latitude second.",'```\r\nprint point = geo_geohash_to_central_point("sunny")\r\n| extend coordinates = point.coordinates\r\n| extend longitude = coordinates[0], latitude = coordinates[1]\r\n```\r\n\r\n|point|coordinates|longitude|latitude|\r\n|---|---|---|---|\r\n|{<br>  "type": "Point",<br>  "coordinates": [<br>    42.47314453125,<br>    23.70849609375<br>  ]<br>}|[<br>  42.47314453125,<br>  23.70849609375<br>]|42.47314453125|23.70849609375|\r\n\r\nThe following example returns a null result because of the invalid geohash input.\r\n\r\n```\r\nprint geohash = geo_geohash_to_central_point("a")\r\n```\r\n\r\n|geohash|\r\n|---|\r\n||\r\n\r\n## Example: Creating location deep-links for Bing Maps\r\n\r\nYou can use the geohash value to create a deep-link URL to Bing Maps by pointing to the geohash center point:\r\n\r\n```\r\n// Use string concatenation to create Bing Map deep-link URL from a geo-point\r\nlet point_to_map_url = (_point:dynamic, _title:string) \r\n{\r\n    strcat(\'https://www.bing.com/maps?sp=point.\', _point.coordinates[1] ,\'_\', _point.coordinates[0], \'_\', url_encode(_title)) \r\n};\r\n// Convert geohash to center point, and then use \'point_to_map_url\' to create Bing Map deep-link\r\nlet geohash_to_map_url = (_geohash:string, _title:string)\r\n{\r\n    point_to_map_url(geo_geohash_to_central_point(_geohash), _title)\r\n};\r\nprint geohash = \'sv8wzvy7\'\r\n| extend url = geohash_to_map_url(geohash, "You are here")\r\n```\r\n\r\n|geohash|url|\r\n|---|---|\r\n|sv8wzvy7|[https://www.bing.com/maps?sp=point.32.15620994567871_34.80245590209961_You+are+here](https://www.bing.com/maps?sp=point.32.15620994567871_34.80245590209961_You+are+here)|',"https://docs.microsoft.com/en-us/azure/kusto/query/geo-geohash-to-central-point-function","geo-geohash-to-central-point-function.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"geo_line_densify","Converts planar line or multiline edges to geodesics by adding intermediate points.",'## Syntax\r\n\r\n`geo_line_densify(`*lineString*`, `*tolerance*`)`\r\n\r\n## Arguments\r\n\r\n* *lineString*: Line or multiline in the [GeoJSON format](https://tools.ietf.org/html/rfc7946) and of a [dynamic](./scalar-data-types/dynamic.md) data type.\r\n* *tolerance*: An optional numeric that defines maximum distance in meters between the original planar edge and the converted geodesic edge chain. Supported values are in the range [0.1, 10000]. If unspecified, the default value `10` is used.\r\n\r\n## Returns\r\n\r\nDensified line in the [GeoJSON format](https://tools.ietf.org/html/rfc7946) and of a [dynamic](./scalar-data-types/dynamic.md) data type. If either the line or tolerance is invalid, the query will produce a null result.\r\n\r\n> [!NOTE]\r\n> * The geospatial coordinates are interpreted as represented by the [WGS-84](https://earth-info.nga.mil/GandG/update/index.php?action=home) coordinate reference system.\r\n\r\n**LineString definition**\r\n\r\ndynamic({"type": "LineString","coordinates": [ [lng_1,lat_1], [lng_2,lat_2] ,..., [lng_N,lat_N] ]})\r\n\r\ndynamic({"type": "MultiLineString","coordinates": [ [ line_1, line_2 ,..., line_N ] ]})\r\n\r\n* LineString coordinates array must contain at least two entries.\r\n* The coordinates [longitude,latitude] must be valid. The longitude must be a real number in the range [-180, +180] and the latitude must be a real number in the range [-90, +90].\r\n* The edge length must be less than 180 degrees. The shortest edge between the two vertices will be chosen.\r\n\r\n**Constraints**\r\n\r\n* The maximum number of points in the densified line is limited to 10485760.\r\n* Storing lines in [dynamic](./scalar-data-types/dynamic.md) format has size limits.\r\n\r\n**Motivation**\r\n\r\n* [GeoJSON format](https://tools.ietf.org/html/rfc7946) defines an edge between two points as a straight cartesian line.\r\n* The decision to use geodesic or planar edges might depend on the dataset and is especially relevant in long edges.','The following example densifies a road in Manhattan island. The edge is short and the distance between the planar edge and its geodesic counterpart is less than the distance specified by tolerance. As such, the result remains unchanged.\r\n\r\n```\r\nprint densified_line = tostring(geo_line_densify(dynamic({"type":"LineString","coordinates":[[-73.949247, 40.796860],[-73.973017, 40.764323]]})))\r\n```\r\n\r\n|densified_line|\r\n|---|\r\n|{"type":"LineString","coordinates":[[-73.949247, 40.796860], [-73.973017, 40.764323]]}|\r\n\r\nThe following example densifies an edge of ~130km length\r\n\r\n```\r\nprint densified_line = tostring(geo_line_densify(dynamic({"type":"LineString","coordinates":[[50, 50], [51, 51]]})))\r\n```\r\n\r\n|densified_line|\r\n|---|\r\n|{"type":"LineString","coordinates":[[50,50],[50.125,50.125],[50.25,50.25],[50.375,50.375],[50.5,50.5],[50.625,50.625],[50.75,50.75],[50.875,50.875],[51,51]]}|\r\n\r\nThe following example returns a null result because of the invalid coordinate input.\r\n\r\n```\r\nprint densified_line = geo_line_densify(dynamic({"type":"LineString","coordinates":[[300,1],[1,1]]}))\r\n```\r\n\r\n|densified_line|\r\n|---|\r\n||\r\n\r\nThe following example returns a null result because of the invalid tolerance input.\r\n\r\n```\r\nprint densified_line = geo_line_densify(dynamic({"type":"LineString","coordinates":[[1,1],[2,2]]}), 0)\r\n```\r\n\r\n|densified_line|\r\n|---|\r\n||',"https://docs.microsoft.com/en-us/azure/kusto/query/geo-line-densify-function","geo-line-densify-function.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"geo_point_in_circle","Calculates whether the geospatial coordinates are inside a circle on Earth.","## Syntax\r\n\r\n`geo_point_in_circle(`*p_longitude*`, `*p_latitude*`, `*pc_longitude*`, `*pc_latitude*`, `*c_radius*`)`\r\n\r\n## Arguments\r\n\r\n* *p_longitude*: Geospatial coordinate longitude value in degrees. Valid value is a real number and in the range [-180, +180].\r\n* *p_latitude*: Geospatial coordinate latitude value in degrees. Valid value is a real number and in the range [-90, +90].\r\n* *pc_longitude*: Circle center geospatial coordinate longitude value in degrees. Valid value is a real number and in the range [-180, +180].\r\n* *pc_latitude*: circle center geospatial coordinate latitude value in degrees. Valid value is a real number and in the range [-90, +90].\r\n* *c_radius*: Circle radius in meters. Valid value must be positive.\r\n\r\n## Returns\r\n\r\nIndicates whether the geospatial coordinates are inside a circle. If the coordinates or circle is invalid, the query will produce a null result.\r\n\r\n> [!NOTE]\r\n>* The geospatial coordinates are interpreted as represented by the [WGS-84](https://earth-info.nga.mil/GandG/update/index.php?action=home) coordinate reference system.\r\n>* The [geodetic datum](https://en.wikipedia.org/wiki/Geodetic_datum) used to measure distance on Earth is a sphere.\r\n>* A circle is a spherical cap on Earth. The radius of the cap is measured along the surface of the sphere.","The following query finds all the places in the area defined by the following circle: Radius of 18 km, center at [-122.317404, 47.609119] coordinates.\r\n\r\n![Places near Seattle](images/geo-point-in-circle-function/circle-seattle.png)\r\n\r\n```\r\ndatatable(longitude:real, latitude:real, place:string)\r\n[\r\n    real(-122.317404), 47.609119, 'Seattle',                   // In circle \r\n    real(-123.497688), 47.458098, 'Olympic National Forest',   // In exterior of circle  \r\n    real(-122.201741), 47.677084, 'Kirkland',                  // In circle\r\n    real(-122.443663), 47.247092, 'Tacoma',                    // In exterior of circle\r\n    real(-122.121975), 47.671345, 'Redmond',                   // In circle\r\n]\r\n| where geo_point_in_circle(longitude, latitude, -122.317404, 47.609119, 18000)\r\n| project place\r\n```\r\n\r\n|place|\r\n|---|\r\n|Seattle|\r\n|Kirkland|\r\n|Redmond|\r\n\r\nStorm events in Orlando. The events are filtered by 100 km within Orlando coordinates, and aggregated by event type and hash.\r\n\r\n![Storm events in Orlando](images/geo-point-in-circle-function/orlando-storm-events.png)\r\n\r\n```\r\nStormEvents\r\n| project BeginLon, BeginLat, EventType\r\n| where geo_point_in_circle(BeginLon, BeginLat, real(-81.3891), 28.5346, 1000 * 100)\r\n| summarize count() by EventType, hash = geo_point_to_s2cell(BeginLon, BeginLat)\r\n| project geo_s2cell_to_central_point(hash), EventType, count_\r\n| render piechart with (kind=map) // map rendering available in Kusto Explorer desktop\r\n```\r\n\r\nThe following example shows NY Taxi pickups within 10 meters of a particular location. Relevant pickups are aggregated by hash.\r\n\r\n![NY Taxi nearby Pickups](images/geo-point-in-circle-function/circle-junction.png)\r\n\r\n```\r\nnyc_taxi\r\n| project pickup_longitude, pickup_latitude\r\n| where geo_point_in_circle( pickup_longitude, pickup_latitude, real(-73.9928), 40.7429, 10)\r\n| summarize by hash = geo_point_to_s2cell(pickup_longitude, pickup_latitude, 22)\r\n| project geo_s2cell_to_central_point(hash)\r\n| render scatterchart with (kind = map) // map rendering available in Kusto Explorer desktop\r\n```\r\n\r\nThe following example will return true.\r\n\r\n```\r\nprint in_circle = geo_point_in_circle(-122.143564, 47.535677, -122.100896, 47.527351, 3500)\r\n```\r\n\r\n|in_circle|\r\n|---|\r\n|1|\r\n\r\nThe following example will return false.\r\n\r\n```\r\nprint in_circle = geo_point_in_circle(-122.137575, 47.630683, -122.100896, 47.527351, 3500)\r\n```\r\n\r\n|in_circle|\r\n|---|\r\n|0|\r\n\r\nThe following example will return a null result because of the invalid coordinate input.\r\n\r\n```\r\nprint in_circle = geo_point_in_circle(200, 1, 1, 1, 1)\r\n```\r\n\r\n|in_circle|\r\n|---|\r\n||\r\n\r\nThe following example will return a  null result because of the invalid circle radius input.\r\n\r\n```\r\nprint in_circle = geo_point_in_circle(1, 1, 1, 1, -1)\r\n```\r\n\r\n|in_circle|\r\n|---|\r\n||","https://docs.microsoft.com/en-us/azure/kusto/query/geo-point-in-circle-function","geo-point-in-circle-function.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"geo_point_in_polygon","Calculates whether the geospatial coordinates are inside a polygon or a multipolygon on Earth.",'## Syntax\r\n\r\n`geo_point_in_polygon(`*longitude*`, `*latitude*`, `*polygon*`)`\r\n\r\n## Arguments\r\n\r\n* *longitude*: Geospatial coordinate, longitude value in degrees. Valid value is a real number and in the range [-180, +180].\r\n* *latitude*: Geospatial coordinate, latitude value in degrees. Valid value is a real number and in the range [-90, +90].\r\n* *polygon*: Polygon or multipolygon in the [GeoJSON format](https://tools.ietf.org/html/rfc7946) and of a [dynamic](./scalar-data-types/dynamic.md) data type.\r\n\r\n## Returns\r\n\r\nIndicates whether the geospatial coordinates are inside a polygon. If the coordinates or polygon is invalid, the query will produce a null result. \r\n\r\n> [!NOTE]\r\n> * The geospatial coordinates are interpreted as represented by the [WGS-84](https://earth-info.nga.mil/GandG/update/index.php?action=home) coordinate reference system.\r\n> * The [geodetic datum](https://en.wikipedia.org/wiki/Geodetic_datum) used for measurements on Earth is a sphere. Polygon edges are [geodesics](https://en.wikipedia.org/wiki/Geodesic) on the sphere.\r\n> * If input polygon edges are straight cartesian lines, consider using [geo_polygon_densify()](geo-polygon-densify-function.md) to convert planar edges to geodesics.\r\n\r\n**Polygon definition and constraints**\r\n\r\ndynamic({"type": "Polygon","coordinates": [ LinearRingShell, LinearRingHole_1 ,..., LinearRingHole_N ]})\r\n\r\ndynamic({"type": "MultiPolygon","coordinates": [[ LinearRingShell, LinearRingHole_1 ,..., LinearRingHole_N ] ,..., [LinearRingShell, LinearRingHole_1 ,..., LinearRingHole_M]]})\r\n\r\n* LinearRingShell is required and defined as a `counterclockwise` ordered array of coordinates [[lng_1,lat_1],...,[lng_i,lat_i],...,[lng_j,lat_j],...,[lng_1,lat_1]]. There can be only one shell.\r\n* LinearRingHole is optional and defined as a `clockwise` ordered array of coordinates [[lng_1,lat_1],...,[lng_i,lat_i],...,[lng_j,lat_j],...,[lng_1,lat_1]]. There can be any number of interior rings and holes.\r\n* LinearRing vertices must be distinct with at least three coordinates. The first coordinate must be equal to the last. At least four entries are required.\r\n* Coordinates [longitude,latitude] must be valid. Longitude must be a real number in the range [-180, +180] and latitude must be a real number in the range [-90, +90].\r\n* LinearRingShell encloses at most half of the sphere. LinearRing divides the sphere into two regions. The smaller of the two regions will be chosen.\r\n* LinearRing edge length must be less than 180 degrees. The shortest edge between the two vertices will be chosen.\r\n* LinearRings must not cross and must not share edges. LinearRings may share vertices.\r\n* Polygon doesn\'t necessarily contain its vertices. Point containment in polygon is defined so that if the Earth is subdivided into polygons, every point is contained by exactly one polygon.\r\n\r\n> [!TIP]\r\n> * Using literal polygons may result in better performance.\r\n> * If you want to know if any of the polygons contains a point, try the following steps: Fold the collection of polygons into one multipolygon. Then query this multipolygon. This may improve performance. See the example below.','Manhattan island without Central Park.\r\n\r\n![Manhattan with a hole](images/geo-point-in-polygon-function/polygon-manhattan-with-hole.png)\r\n\r\n```\r\ndatatable(longitude:real, latitude:real, description:string)\r\n[\r\n    real(-73.985654), 40.748487, \'Empire State Building\',           // In Polygon \r\n    real(-73.963249), 40.779525, \'The Metropolitan Museum of Art\',  // In exterior of polygon\r\n    real(-73.874367), 40.777356, \'LaGuardia Airport\',               // In exterior of polygon\r\n]\r\n| where geo_point_in_polygon(longitude, latitude, dynamic({"type":"Polygon","coordinates":[[[-73.92597198486328,40.87821814104651],[-73.94691467285156,40.85069618625578],[-73.94691467285156,40.841865966890786],[-74.01008605957031,40.7519385984599],[-74.01866912841797,40.704586878965245],[-74.01214599609375,40.699901911003046],[-73.99772644042969,40.70875101828792],[-73.97747039794922,40.71083299030839],[-73.97026062011719,40.7290474687069],[-73.97506713867186,40.734510840309376],[-73.970947265625,40.74543623770158],[-73.94210815429688,40.77586181063573],[-73.9434814453125,40.78080140115127],[-73.92974853515625,40.79691751000055],[-73.93077850341797,40.804454347291006],[-73.93489837646484,40.80965166748853],[-73.93524169921875,40.837190668541105],[-73.92288208007812,40.85770758108904],[-73.9101791381836,40.871728144624974],[-73.92597198486328,40.87821814104651]],[[-73.95824432373047,40.80071852197889],[-73.98206233978271,40.76815921628347],[-73.97309303283691,40.76422632379533],[-73.94914627075195,40.796949998204596],[-73.95824432373047,40.80071852197889]]]}))\r\n```\r\n\r\n|longitude|latitude|description|\r\n|---|---|---|\r\n|-73.985654|40.748487|Empire State Building|\r\n\r\nSearch for coordinates in multipolygon.\r\n\r\n![Manhattan with a hole](images/geo-point-in-polygon-function/multipolygon-manhattan.png)\r\n\r\n```\r\nlet multipolygon = dynamic({"type":"MultiPolygon","coordinates":[[[[-73.991460000000131,40.731738000000206],[-73.992854491775518,40.730082566051351],[-73.996772,40.725432000000154],[-73.997634685522883,40.725786309886963],[-74.002855946639244,40.728346630056791],[-74.001413,40.731065000000207],[-73.996796995070824,40.73736378205173],[-73.991724524037934,40.735245208931886],[-73.990703782359589,40.734781896080477],[-73.991460000000131,40.731738000000206]]],[[[-73.958357552055688,40.800369095633819],[-73.98143901556422,40.768762584141953],[-73.981548752788598,40.7685590292784],[-73.981565335901905,40.768307084720796],[-73.981754418060945,40.768399727738668],[-73.982038573548124,40.768387823012056],[-73.982268248204349,40.768298621883247],[-73.982384797518051,40.768097213086911],[-73.982320919746599,40.767894461792181],[-73.982155532845766,40.767756204474757],[-73.98238873834039,40.767411004834273],[-73.993650353659021,40.772145571634361],[-73.99415893763998,40.772493009137818],[-73.993831082030937,40.772931787850908],[-73.993891252437052,40.772955194876722],[-73.993962585514595,40.772944653908901],[-73.99401262480508,40.772882846631894],[-73.994122058082397,40.77292405902601],[-73.994136652588594,40.772901870174394],[-73.994301342391154,40.772970028663913],[-73.994281535134448,40.77299380206933],[-73.994376552751078,40.77303955110149],[-73.994294029824005,40.773156243992048],[-73.995023275860802,40.773481196576356],[-73.99508939189289,40.773388475039134],[-73.995013963716758,40.773358035426909],[-73.995050284699261,40.773297153189958],[-73.996240651898916,40.773789791397689],[-73.996195837470992,40.773852356184044],[-73.996098807369748,40.773951805299085],[-73.996179459973888,40.773986954351571],[-73.996095245226442,40.774086186437756],[-73.995572265161172,40.773870731394297],[-73.994017424135961,40.77321375261053],[-73.993935876811335,40.773179512586211],[-73.993861942928888,40.773269531698837],[-73.993822393527211,40.773381758622882],[-73.993767019318497,40.773483981224835],[-73.993698463744295,40.773562141052594],[-73.993358326468751,40.773926888327956],[-73.992622663865575,40.774974056037109],[-73.992577842766124,40.774956016359418],[-73.992527743951555,40.775002110439829],[-73.992469745815342,40.775024159551755],[-73.992403837191887,40.775018140390664],[-73.99226708903538,40.775116033858794],[-73.99217809026365,40.775279293897171],[-73.992059084937338,40.775497598192516],[-73.992125372394938,40.775509075053385],[-73.992226867797001,40.775482211026116],[-73.992329346608813,40.775468900958522],[-73.992361756801131,40.775501899766638],[-73.992386042960277,40.775557180424634],[-73.992087684712729,40.775983970821372],[-73.990927174149746,40.777566878763238],[-73.99039616003671,40.777585065679204],[-73.989461267506471,40.778875124584417],[-73.989175778438053,40.779287524015778],[-73.988868617400072,40.779692922911607],[-73.988871874499793,40.779713738253008],[-73.989219022880576,40.779697895209402],[-73.98927785904425,40.779723439271038],[-73.989409054180143,40.779737706471963],[-73.989498614927044,40.779725044389757],[-73.989596493388234,40.779698146683387],[-73.989679812902509,40.779677568658038],[-73.989752702937935,40.779671244211556],[-73.989842247806507,40.779680752670664],[-73.990040102120489,40.779707677698219],[-73.990137977524839,40.779699769704784],[-73.99033584033225,40.779661794394983],[-73.990430598697046,40.779664973055503],[-73.990622199396725,40.779676064914298],[-73.990745069505479,40.779671328184051],[-73.990872114282197,40.779646007643876],[-73.990961672224358,40.779639683751753],[-73.991057472829539,40.779652352625774],[-73.991157429497036,40.779669775606465],[-73.991242817404469,40.779671367084504],[-73.991255318289745,40.779650782516491],[-73.991294887120119,40.779630209208889],[-73.991321967649895,40.779631796041372],[-73.991359455569423,40.779585883337383],[-73.991551059227476,40.779574821437407],[-73.99141982585985,40.779755280287233],[-73.988886144117032,40.779878898532999],[-73.988939656706265,40.779956178440393],[-73.988926103530844,40.780059292013632],[-73.988911680264692,40.780096037146606],[-73.988919261468567,40.780226094343945],[-73.988381050202634,40.780981074045783],[-73.988232413846987,40.781233144215555],[-73.988210420831663,40.781225482542055],[-73.988140000000143,40.781409000000224],[-73.988041288067166,40.781585961353777],[-73.98810029382463,40.781602878305286],[-73.988076449145055,40.781650935001608],[-73.988018059972219,40.781634188810422],[-73.987960792842145,40.781770987031535],[-73.985465811970457,40.785360700575431],[-73.986172704965611,40.786068452258647],[-73.986455862401996,40.785919219081421],[-73.987072345615601,40.785189638820121],[-73.98711901394276,40.785210319004058],[-73.986497781023601,40.785951202887254],[-73.986164628806279,40.786121882448327],[-73.986128422486075,40.786239001331111],[-73.986071135219746,40.786240706026611],[-73.986027274789123,40.786228964236727],[-73.986097637849426,40.78605822569795],[-73.985429321269592,40.785413942184597],[-73.985081137732209,40.785921935110366],[-73.985198833254501,40.785966552197777],[-73.985170502389906,40.78601333415817],[-73.985216218673656,40.786030501816427],[-73.98525509797993,40.785976205511588],[-73.98524273937646,40.785972572653328],[-73.98524962933017,40.785963139855845],[-73.985281779186749,40.785978620950075],[-73.985240032884533,40.786035858136792],[-73.985683885242182,40.786222123919686],[-73.985717529004575,40.786175994668795],[-73.985765660297687,40.786196274858618],[-73.985682871922691,40.786309786213067],[-73.985636270930442,40.786290150649279],[-73.985670722564691,40.786242911993817],[-73.98520511880038,40.786047669212785],[-73.985211035607492,40.786039554883686],[-73.985162639946992,40.786020999769754],[-73.985131636312062,40.786060297019972],[-73.985016964065125,40.78601423719563],[-73.984655078830457,40.786534741807841],[-73.985743787901043,40.786570082854738],[-73.98589227228328,40.786426529019593],[-73.985942854994988,40.786452847880334],[-73.985949561556794,40.78648711396653],[-73.985812373526713,40.786616865357047],[-73.985135209703174,40.78658761889551],[-73.984619428584324,40.786586016349787],[-73.981952458164173,40.790393724337193],[-73.972823037363767,40.803428052816756],[-73.971036786332192,40.805918478839672],[-73.966701,40.804169000000186],[-73.959647,40.801156000000113],[-73.958508540159471,40.800682279767472],[-73.95853274080838,40.800491362464697],[-73.958357552055688,40.800369095633819]]],[[[-73.943592454622546,40.782747908206574],[-73.943648235390199,40.782656161333449],[-73.943870759887162,40.781273026571704],[-73.94345932494096,40.780048275653243],[-73.943213862652243,40.779317588660199],[-73.943004239504688,40.779639495474292],[-73.942716005450905,40.779544169476175],[-73.942712374762181,40.779214856940001],[-73.942535563208608,40.779090956062532],[-73.942893408188027,40.778614093246276],[-73.942438481745029,40.777315235766039],[-73.942244919522594,40.777104088947254],[-73.942074188038887,40.776917846977142],[-73.942002667222781,40.776185317382648],[-73.942620205199006,40.775180871576474],[-73.94285645694552,40.774796600349191],[-73.94293043781397,40.774676268036011],[-73.945870899588215,40.771692257932997],[-73.946618690150586,40.77093339256956],[-73.948664164778933,40.768857624399587],[-73.950069793030679,40.767025088383498],[-73.954418260786071,40.762184104951245],[-73.95650786241211,40.760285256574043],[-73.958787773424007,40.758213471309809],[-73.973015157270069,40.764278692864671],[-73.955760332998182,40.787906554459667],[-73.944023,40.782960000000301],[-73.943592454622546,40.782747908206574]]]]});\r\nlet coordinates = \r\n    datatable(longitude:real, latitude:real, description:string)\r\n    [\r\n        real(-73.9741), 40.7914, \'Upper West Side\',    // In MultiPolygon\r\n        real(-73.9950), 40.7340, \'Greenwich Village\',  // In MultiPolygon\r\n        real(-73.8743), 40.7773, \'LaGuardia Airport\',  // In exterior of MultiPolygon\r\n    ];\r\ncoordinates\r\n| where geo_point_in_polygon(longitude, latitude, multipolygon)\r\n```\r\n\r\n|longitude|latitude|description|\r\n|---|---|---|\r\n|-73.9741|40.7914|Upper West Side|\r\n|-73.995|40.734|Greenwich Village|\r\n\r\nStorm events in California. The events are filtered by a California state polygon and aggregated by event type and hash.\r\n\r\n![Storm events in California](images/geo-point-in-polygon-function/california-storm-events.png)\r\n\r\n```\r\nlet california = dynamic({"type":"Polygon","coordinates":[[[-123.233256,42.006186],[-122.378853,42.011663],[-121.037003,41.995232],[-120.001861,41.995232],[-119.996384,40.264519],[-120.001861,38.999346],[-118.71478,38.101128],[-117.498899,37.21934],[-116.540435,36.501861],[-115.85034,35.970598],[-114.634459,35.00118],[-114.634459,34.87521],[-114.470151,34.710902],[-114.333228,34.448009],[-114.136058,34.305608],[-114.256551,34.174162],[-114.415382,34.108438],[-114.535874,33.933176],[-114.497536,33.697668],[-114.524921,33.54979],[-114.727567,33.40739],[-114.661844,33.034958],[-114.524921,33.029481],[-114.470151,32.843265],[-114.524921,32.755634],[-114.72209,32.717295],[-116.04751,32.624187],[-117.126467,32.536556],[-117.24696,32.668003],[-117.252437,32.876127],[-117.329114,33.122589],[-117.471515,33.297851],[-117.7837,33.538836],[-118.183517,33.763391],[-118.260194,33.703145],[-118.413548,33.741483],[-118.391641,33.840068],[-118.566903,34.042715],[-118.802411,33.998899],[-119.218659,34.146777],[-119.278905,34.26727],[-119.558229,34.415147],[-119.875891,34.40967],[-120.138784,34.475393],[-120.472878,34.448009],[-120.64814,34.579455],[-120.609801,34.858779],[-120.670048,34.902595],[-120.631709,35.099764],[-120.894602,35.247642],[-120.905556,35.450289],[-121.004141,35.461243],[-121.168449,35.636505],[-121.283465,35.674843],[-121.332757,35.784382],[-121.716143,36.195153],[-121.896882,36.315645],[-121.935221,36.638785],[-121.858544,36.6114],[-121.787344,36.803093],[-121.929744,36.978355],[-122.105006,36.956447],[-122.335038,37.115279],[-122.417192,37.241248],[-122.400761,37.361741],[-122.515777,37.520572],[-122.515777,37.783465],[-122.329561,37.783465],[-122.406238,38.15042],[-122.488392,38.112082],[-122.504823,37.931343],[-122.701993,37.893004],[-122.937501,38.029928],[-122.97584,38.265436],[-123.129194,38.451652],[-123.331841,38.566668],[-123.44138,38.698114],[-123.737134,38.95553],[-123.687842,39.032208],[-123.824765,39.366301],[-123.764519,39.552517],[-123.85215,39.831841],[-124.109566,40.105688],[-124.361506,40.259042],[-124.410798,40.439781],[-124.158859,40.877937],[-124.109566,41.025814],[-124.158859,41.14083],[-124.065751,41.442061],[-124.147905,41.715908],[-124.257444,41.781632],[-124.213628,42.000709],[-123.233256,42.006186]]]});\r\nStormEvents\r\n| project BeginLon, BeginLat, EventType\r\n| where geo_point_in_polygon(BeginLon, BeginLat, california)\r\n| summarize count() by EventType, hash = geo_point_to_s2cell(BeginLon, BeginLat, 7)\r\n| project geo_s2cell_to_central_point(hash), EventType, count_\r\n| render piechart with (kind=map) // map rendering available in Kusto Explorer desktop\r\n```\r\n\r\nThe following example shows how to classify coordinates to polygons using the [partition](./partitionoperator.md) operator.\r\n\r\n```\r\nlet Polygons = datatable(description:string, polygon:dynamic)\r\n    [  \r\n      "New York city area", dynamic({"type":"Polygon","coordinates":[[[-73.85009765625,40.85744791303121],[-74.16046142578125,40.84290487729676],[-74.190673828125,40.59935608796518],[-73.83087158203125,40.61812224225511],[-73.85009765625,40.85744791303121]]]}),\r\n      "Seattle area",       dynamic({"type":"Polygon","coordinates":[[[-122.200927734375,47.68573021131587],[-122.4591064453125,47.68573021131587],[-122.4755859375,47.468949677672484],[-122.17620849609374,47.47266286861342],[-122.200927734375,47.68573021131587]]]}),\r\n      "Las Vegas",          dynamic({"type":"Polygon","coordinates":[[[-114.9,36.36],[-115.4498291015625,36.33282808737917],[-115.4498291015625,35.84453450421662],[-114.949951171875,35.902399875143615],[-114.9,36.36]]]}),\r\n    ];\r\nlet Locations = datatable(longitude:real, latitude:real)\r\n    [\r\n      real(-73.95),  real(40.75), // Somewhere in New York\r\n      real(-122.3),  real(47.6),  // Somewhere in Seattle\r\n      real(-115.18), real(36.16)  // Somewhere in Las Vegas\r\n    ];\r\nPolygons\r\n| project polygonPartition = tostring(pack("description", description, "polygon", polygon))\r\n| partition hint.materialized=true by polygonPartition\r\n{   \r\n     Locations\r\n     | extend description = todynamic(toscalar(polygonPartition)).description\r\n     | extend polygon = todynamic(toscalar(polygonPartition)).polygon\r\n     | where geo_point_in_polygon(longitude, latitude, polygon)\r\n     | project-away polygon\r\n}\r\n```\r\n\r\n|longitude|latitude|description|\r\n|---|---|---|\r\n|-73.95|40.75|New York city area|\r\n|-122.3|47.6|Seattle area|\r\n|-115.18|36.16|Las Vegas|\r\n\r\nSee also [geo_polygon_to_s2cells()](geo-polygon-to-s2cells-function.md).\r\n\r\nFolding several polygons into one multipolygon and querying it.\r\n\r\n```\r\nlet Polygons = \r\n    datatable(polygon:dynamic)\r\n    [\r\n        dynamic({"type":"Polygon","coordinates":[[[-73.991460000000131,40.731738000000206],[-73.992854491775518,40.730082566051351],[-73.996772,40.725432000000154],[-73.997634685522883,40.725786309886963],[-74.002855946639244,40.728346630056791],[-74.001413,40.731065000000207],[-73.996796995070824,40.73736378205173],[-73.991724524037934,40.735245208931886],[-73.990703782359589,40.734781896080477],[-73.991460000000131,40.731738000000206]]]}),\r\n        dynamic({"type":"Polygon","coordinates":[[[-73.958357552055688,40.800369095633819],[-73.98143901556422,40.768762584141953],[-73.981548752788598,40.7685590292784],[-73.981565335901905,40.768307084720796],[-73.981754418060945,40.768399727738668],[-73.982038573548124,40.768387823012056],[-73.982268248204349,40.768298621883247],[-73.982384797518051,40.768097213086911],[-73.982320919746599,40.767894461792181],[-73.982155532845766,40.767756204474757],[-73.98238873834039,40.767411004834273],[-73.993650353659021,40.772145571634361],[-73.99415893763998,40.772493009137818],[-73.993831082030937,40.772931787850908],[-73.993891252437052,40.772955194876722],[-73.993962585514595,40.772944653908901],[-73.99401262480508,40.772882846631894],[-73.994122058082397,40.77292405902601],[-73.994136652588594,40.772901870174394],[-73.994301342391154,40.772970028663913],[-73.994281535134448,40.77299380206933],[-73.994376552751078,40.77303955110149],[-73.994294029824005,40.773156243992048],[-73.995023275860802,40.773481196576356],[-73.99508939189289,40.773388475039134],[-73.995013963716758,40.773358035426909],[-73.995050284699261,40.773297153189958],[-73.996240651898916,40.773789791397689],[-73.996195837470992,40.773852356184044],[-73.996098807369748,40.773951805299085],[-73.996179459973888,40.773986954351571],[-73.996095245226442,40.774086186437756],[-73.995572265161172,40.773870731394297],[-73.994017424135961,40.77321375261053],[-73.993935876811335,40.773179512586211],[-73.993861942928888,40.773269531698837],[-73.993822393527211,40.773381758622882],[-73.993767019318497,40.773483981224835],[-73.993698463744295,40.773562141052594],[-73.993358326468751,40.773926888327956],[-73.992622663865575,40.774974056037109],[-73.992577842766124,40.774956016359418],[-73.992527743951555,40.775002110439829],[-73.992469745815342,40.775024159551755],[-73.992403837191887,40.775018140390664],[-73.99226708903538,40.775116033858794],[-73.99217809026365,40.775279293897171],[-73.992059084937338,40.775497598192516],[-73.992125372394938,40.775509075053385],[-73.992226867797001,40.775482211026116],[-73.992329346608813,40.775468900958522],[-73.992361756801131,40.775501899766638],[-73.992386042960277,40.775557180424634],[-73.992087684712729,40.775983970821372],[-73.990927174149746,40.777566878763238],[-73.99039616003671,40.777585065679204],[-73.989461267506471,40.778875124584417],[-73.989175778438053,40.779287524015778],[-73.988868617400072,40.779692922911607],[-73.988871874499793,40.779713738253008],[-73.989219022880576,40.779697895209402],[-73.98927785904425,40.779723439271038],[-73.989409054180143,40.779737706471963],[-73.989498614927044,40.779725044389757],[-73.989596493388234,40.779698146683387],[-73.989679812902509,40.779677568658038],[-73.989752702937935,40.779671244211556],[-73.989842247806507,40.779680752670664],[-73.990040102120489,40.779707677698219],[-73.990137977524839,40.779699769704784],[-73.99033584033225,40.779661794394983],[-73.990430598697046,40.779664973055503],[-73.990622199396725,40.779676064914298],[-73.990745069505479,40.779671328184051],[-73.990872114282197,40.779646007643876],[-73.990961672224358,40.779639683751753],[-73.991057472829539,40.779652352625774],[-73.991157429497036,40.779669775606465],[-73.991242817404469,40.779671367084504],[-73.991255318289745,40.779650782516491],[-73.991294887120119,40.779630209208889],[-73.991321967649895,40.779631796041372],[-73.991359455569423,40.779585883337383],[-73.991551059227476,40.779574821437407],[-73.99141982585985,40.779755280287233],[-73.988886144117032,40.779878898532999],[-73.988939656706265,40.779956178440393],[-73.988926103530844,40.780059292013632],[-73.988911680264692,40.780096037146606],[-73.988919261468567,40.780226094343945],[-73.988381050202634,40.780981074045783],[-73.988232413846987,40.781233144215555],[-73.988210420831663,40.781225482542055],[-73.988140000000143,40.781409000000224],[-73.988041288067166,40.781585961353777],[-73.98810029382463,40.781602878305286],[-73.988076449145055,40.781650935001608],[-73.988018059972219,40.781634188810422],[-73.987960792842145,40.781770987031535],[-73.985465811970457,40.785360700575431],[-73.986172704965611,40.786068452258647],[-73.986455862401996,40.785919219081421],[-73.987072345615601,40.785189638820121],[-73.98711901394276,40.785210319004058],[-73.986497781023601,40.785951202887254],[-73.986164628806279,40.786121882448327],[-73.986128422486075,40.786239001331111],[-73.986071135219746,40.786240706026611],[-73.986027274789123,40.786228964236727],[-73.986097637849426,40.78605822569795],[-73.985429321269592,40.785413942184597],[-73.985081137732209,40.785921935110366],[-73.985198833254501,40.785966552197777],[-73.985170502389906,40.78601333415817],[-73.985216218673656,40.786030501816427],[-73.98525509797993,40.785976205511588],[-73.98524273937646,40.785972572653328],[-73.98524962933017,40.785963139855845],[-73.985281779186749,40.785978620950075],[-73.985240032884533,40.786035858136792],[-73.985683885242182,40.786222123919686],[-73.985717529004575,40.786175994668795],[-73.985765660297687,40.786196274858618],[-73.985682871922691,40.786309786213067],[-73.985636270930442,40.786290150649279],[-73.985670722564691,40.786242911993817],[-73.98520511880038,40.786047669212785],[-73.985211035607492,40.786039554883686],[-73.985162639946992,40.786020999769754],[-73.985131636312062,40.786060297019972],[-73.985016964065125,40.78601423719563],[-73.984655078830457,40.786534741807841],[-73.985743787901043,40.786570082854738],[-73.98589227228328,40.786426529019593],[-73.985942854994988,40.786452847880334],[-73.985949561556794,40.78648711396653],[-73.985812373526713,40.786616865357047],[-73.985135209703174,40.78658761889551],[-73.984619428584324,40.786586016349787],[-73.981952458164173,40.790393724337193],[-73.972823037363767,40.803428052816756],[-73.971036786332192,40.805918478839672],[-73.966701,40.804169000000186],[-73.959647,40.801156000000113],[-73.958508540159471,40.800682279767472],[-73.95853274080838,40.800491362464697],[-73.958357552055688,40.800369095633819]]]}),\r\n        dynamic({"type":"Polygon","coordinates":[[[-73.943592454622546,40.782747908206574],[-73.943648235390199,40.782656161333449],[-73.943870759887162,40.781273026571704],[-73.94345932494096,40.780048275653243],[-73.943213862652243,40.779317588660199],[-73.943004239504688,40.779639495474292],[-73.942716005450905,40.779544169476175],[-73.942712374762181,40.779214856940001],[-73.942535563208608,40.779090956062532],[-73.942893408188027,40.778614093246276],[-73.942438481745029,40.777315235766039],[-73.942244919522594,40.777104088947254],[-73.942074188038887,40.776917846977142],[-73.942002667222781,40.776185317382648],[-73.942620205199006,40.775180871576474],[-73.94285645694552,40.774796600349191],[-73.94293043781397,40.774676268036011],[-73.945870899588215,40.771692257932997],[-73.946618690150586,40.77093339256956],[-73.948664164778933,40.768857624399587],[-73.950069793030679,40.767025088383498],[-73.954418260786071,40.762184104951245],[-73.95650786241211,40.760285256574043],[-73.958787773424007,40.758213471309809],[-73.973015157270069,40.764278692864671],[-73.955760332998182,40.787906554459667],[-73.944023,40.782960000000301],[-73.943592454622546,40.782747908206574]]]}),\r\n    ];\r\nlet Coordinates = \r\n    datatable(longitude:real, latitude:real, description:string)\r\n    [\r\n        real(-73.9741), 40.7914, \'Upper West Side\',\r\n        real(-73.9950), 40.7340, \'Greenwich Village\',\r\n        real(-73.8743), 40.7773, \'LaGuardia Airport\',\r\n    ];\r\nlet multipolygon = toscalar(\r\n    Polygons\r\n    | project individual_polygon = pack_array(polygon.coordinates)\r\n    | summarize multipolygon_coordinates = make_list(individual_polygon)\r\n    | project multipolygon = pack("type","MultiPolygon", "coordinates", multipolygon_coordinates));\r\nCoordinates\r\n| where geo_point_in_polygon(longitude, latitude, multipolygon)\r\n```\r\n\r\n|longitude|latitude|description|\r\n|---|---|---|\r\n|-73.9741|40.7914|Upper West Side|\r\n|-73.995|40.734|Greenwich Village|\r\n\r\nThe following example will return a null result because of the invalid coordinate input.\r\n\r\n```\r\nprint in_polygon = geo_point_in_polygon(200,1,dynamic({"type": "Polygon","coordinates": [[[0,0],[10,10],[10,1],[0,0]]]}))\r\n```\r\n\r\n| in_polygon |\r\n|------------|\r\n|            |\r\n\r\nThe following example will return a null result because of the invalid polygon input.\r\n\r\n```\r\nprint in_polygon = geo_point_in_polygon(1,1,dynamic({"type": "Polygon","coordinates": [[[0,0],[10,10],[10,10],[0,0]]]}))\r\n```\r\n\r\n| in_polygon |\r\n|------------|\r\n|            |',"https://docs.microsoft.com/en-us/azure/kusto/query/geo-point-in-polygon-function","geo-point-in-polygon-function.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"geo_point_to_geohash","Calculates the geohash string value for a geographic location.","Read more about [geohash](https://en.wikipedia.org/wiki/Geohash).  \r\n\r\n## Syntax\r\n\r\n`geo_point_to_geohash(`*longitude*`, `*latitude*`, `[*accuracy*]`)`\r\n\r\n## Arguments\r\n\r\n* *longitude*: Longitude value of a geographic location. Longitude x will be considered valid if x is a real number and is in the range [-180, +180]. \r\n* *latitude*: Latitude value of a geographic location. Latitude y will be considered valid if y is a real number and y is in the range [-90, +90]. \r\n* *accuracy*: An optional `int` that defines the requested accuracy. Supported values are in the range [1,18]. If unspecified, the default value `5` is used.\r\n\r\n## Returns\r\n\r\nThe geohash string value of a given geographic location with requested accuracy length. If the coordinate or accuracy is invalid, the query will produce an empty result.\r\n\r\n> [!NOTE]\r\n>\r\n> * Geohash can be a useful geospatial clustering tool.\r\n> * Geohash has 18 accuracy levels with area coverage ranging from 25 Million km² at the highest level 1 to 0.6 μ² at the lowest level 18.\r\n> * Common prefixes of geohash indicate proximity of points to each other. The longer a shared prefix is, the closer the two places are. Accuracy value translates to geohash length.\r\n> * Geohash is a rectangular area on a plane surface.\r\n> * Invoking the [geo_geohash_to_central_point()](geo-geohash-to-central-point-function.md) function on a geohash string that was calculated on longitude x and latitude y won't necessarily return x and y.\r\n> * Due to the geohash definition, it's possible that two geographic locations are very close to each other but have different geohash codes.\r\n\r\n**Geohash rectangular area coverage per accuracy value:**\r\n\r\n| Accuracy | Width     | Height    |\r\n|----------|-----------|-----------|\r\n| 1        | 5000 km   | 5000 km   |\r\n| 2        | 1250 km   | 625 km    |\r\n| 3        | 156.25 km | 156.25 km |\r\n| 4        | 39.06 km  | 19.53 km  |\r\n| 5        | 4.88 km   | 4.88 km   |\r\n| 6        | 1.22 km   | 0.61 km   |\r\n| 7        | 152.59 m  | 152.59 m  |\r\n| 8        | 38.15 m   | 19.07 m   |\r\n| 9        | 4.77 m    | 4.77 m    |\r\n| 10       | 1.19 m    | 0.59 m    |\r\n| 11       | 149.01 mm | 149.01 mm |\r\n| 12       | 37.25 mm  | 18.63 mm  |\r\n| 13       | 4.66 mm   | 4.66 mm   |\r\n| 14       | 1.16 mm   | 0.58 mm   |\r\n| 15       | 145.52 μ  | 145.52 μ  |\r\n| 16       | 36.28 μ   | 18.19 μ   |\r\n| 17       | 4.55 μ    | 4.55 μ    |\r\n| 18       | 1.14 μ    | 0.57 μ    |\r\n\r\nSee also [geo_point_to_s2cell()](geo-point-to-s2cell-function.md).",'US storm events aggregated by geohash.\r\n\r\n![US geohash](images/geo-point-to-geohash-function/geohash.png)\r\n\r\n```\r\nStormEvents\r\n| project BeginLon, BeginLat\r\n| summarize by hash=geo_point_to_geohash(BeginLon, BeginLat, 3)\r\n| project geo_geohash_to_central_point(hash)\r\n| render scatterchart with (kind=map) // map rendering available in Kusto Explorer desktop\r\n```\r\n\r\n```\r\nprint geohash = geo_point_to_geohash(139.806115, 35.554128, 12)  \r\n```\r\n\r\n| geohash      |\r\n|--------------|\r\n| xn76m27ty9g4 |\r\n\r\n```\r\nprint geohash = geo_point_to_geohash(-80.195829, 25.802215, 8)\r\n```\r\n\r\n|geohash|\r\n|---|\r\n|dhwfz15h|\r\n\r\nThe following example finds groups of coordinates. Every pair of coordinates in the group resides in a rectangular area of 4.88 km by 4.88 km.\r\n\r\n```\r\ndatatable(location_id:string, longitude:real, latitude:real)\r\n[\r\n  "A", double(-122.303404), 47.570482,\r\n  "B", double(-122.304745), 47.567052,\r\n  "C", double(-122.278156), 47.566936,\r\n]\r\n| summarize count = count(),                                          // items per group count\r\n            locations = make_list(location_id)                        // items in the group\r\n            by geohash = geo_point_to_geohash(longitude, latitude)    // geohash of the group\r\n```\r\n\r\n| geohash | count | locations  |\r\n|---------|-------|------------|\r\n| c23n8   | 2     | ["A", "B"] |\r\n| c23n9   | 1     | ["C"]      |\r\n\r\nThe following example produces an empty result because of the invalid coordinate input.\r\n\r\n```\r\nprint geohash = geo_point_to_geohash(200,1,8)\r\n```\r\n\r\n| geohash |\r\n|---------|\r\n|         |\r\n\r\nThe following example produces an empty result because of the invalid accuracy input.\r\n\r\n```\r\nprint geohash = geo_point_to_geohash(1,1,int(null))\r\n```\r\n\r\n| geohash |\r\n|---------|\r\n|         |',"https://docs.microsoft.com/en-us/azure/kusto/query/geo-point-to-geohash-function","geo-point-to-geohash-function.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"geo_point_to_s2cell","Calculates the S2 cell token string value for a geographic location.","Read more about [S2 cell hierarchy](https://s2geometry.io/devguide/s2cell_hierarchy).\r\n\r\n## Syntax\r\n\r\n`geo_point_to_s2cell(`*longitude*`, `*latitude*`, `*level*`)`\r\n\r\n## Arguments\r\n\r\n* *longitude*: Longitude value of a geographic location. Longitude *x* will be considered valid if *x* is a real number and *x* is in the range [-180, +180]. \r\n* *latitude*: Latitude value of a geographic location. Latitude y will be considered valid if y is a real number and y in the range [-90, +90]. \r\n* *level*: An optional `int` that defines the requested cell level. Supported values are in the range [0, 30]. If unspecified, the default value `11` is used.\r\n\r\n## Returns\r\n\r\nThe S2 cell token string value of a given geographic location. If the coordinates or levels are invalid, the query will produce an empty result.\r\n\r\n> [!NOTE]\r\n>\r\n> * S2 cell can be a useful geospatial clustering tool.\r\n> * S2 cell has 31 levels of hierarchy with area coverage ranging from 85,011,012.19km² at the highest level 0 to 00.44cm² at the lowest level 30.\r\n> * S2 cell preserves the cell center well during level increase from 0 to 30.\r\n> * S2 cell is a cell on a spherical surface and its edges are geodesics.\r\n> * Invoking the [geo_s2cell_to_central_point()](geo-s2cell-to-central-point-function.md) function on an S2 cell token string that was calculated on longitude x and latitude y won't necessarily return x and y.\r\n> * It's possible that two geographic locations are very close to each other but have different S2 cell tokens.\r\n\r\n**S2 cell approximate area coverage per level value**\r\n\r\nFor every level, the size of the S2 cell is similar but not exactly equal. Nearby cell sizes tend to be more equal.\r\n\r\n|Level|Minimum random cell edge length (UK)|Maximum random cell edge length (US)|\r\n|--|--|--|\r\n|0|7842 km|7842 km|\r\n|1|3921 km|5004 km|\r\n|2|1825 km|2489 km|\r\n|3|840 km|1310 km|\r\n|4|432 km|636 km|\r\n|5|210 km|315 km|\r\n|6|108 km|156 km|\r\n|7|54 km|78 km|\r\n|8|27 km|39 km|\r\n|9|14 km|20 km|\r\n|10|7 km|10 km|\r\n|11|3 km|5 km|\r\n|12|1699 m|2 km|\r\n|13|850 m|1225 m|\r\n|14|425 m|613 m|\r\n|15|212 m|306 m|\r\n|16|106 m|153 m|\r\n|17|53 m|77 m|\r\n|18|27 m|38 m|\r\n|19|13 m|19 m|\r\n|20|7 m|10 m|\r\n|21|3 m|5 m|\r\n|22|166 cm|2 m|\r\n|23|83 cm|120 cm|\r\n|24|41 cm|60 cm|\r\n|25|21 cm|30 cm|\r\n|26|10 cm|15 cm|\r\n|27|5 cm|7 cm|\r\n|28|2 cm|4 cm|\r\n|29|12 mm|18 mm|\r\n|30|6 mm|9 mm|\r\n\r\nThe table source can be found [in this S2 cell statistical resource](https://s2geometry.io/resources/s2cell_statistics).\r\n\r\nSee also [geo_point_to_geohash()](geo-point-to-geohash-function.md).",'US storm events aggregated by s2cell.\r\n\r\n![US s2cell](images/geo-point-to-s2cell-function/s2cell.png)\r\n\r\n```\r\nStormEvents\r\n| project BeginLon, BeginLat\r\n| summarize by hash=geo_point_to_s2cell(BeginLon, BeginLat, 5)\r\n| project geo_s2cell_to_central_point(hash)\r\n| render scatterchart with (kind=map) // map rendering available in Kusto Explorer desktop\r\n```\r\n\r\n```\r\nprint s2cell = geo_point_to_s2cell(-80.195829, 25.802215, 8)\r\n```\r\n\r\n| s2cell |\r\n|--------|\r\n| 88d9b  |\r\n\r\nThe following example finds groups of coordinates. Every pair of coordinates in the group resides in the S2 cell with a maximum area of 1632.45 km².\r\n\r\n```\r\ndatatable(location_id:string, longitude:real, latitude:real)\r\n[\r\n  "A", 10.1234, 53,\r\n  "B", 10.3579, 53,\r\n  "C", 10.6842, 53,\r\n]\r\n| summarize count = count(),                                        // items per group count\r\n            locations = make_list(location_id)                      // items in the group\r\n            by s2cell = geo_point_to_s2cell(longitude, latitude, 8) // s2 cell of the group\r\n```\r\n\r\n| s2cell | count | locations |\r\n|--------|-------|-----------|\r\n| 47b1d  | 2     | ["A","B"] |\r\n| 47ae3  | 1     | ["C"]     |\r\n\r\nThe following example produces an empty result because of the invalid coordinate input.\r\n\r\n```\r\nprint s2cell = geo_point_to_s2cell(300,1,8)\r\n```\r\n\r\n| s2cell |\r\n|--------|\r\n|        |\r\n\r\nThe following example produces an empty result because of the invalid level input.\r\n\r\n```\r\nprint s2cell = geo_point_to_s2cell(1,1,35)\r\n```\r\n\r\n| s2cell |\r\n|--------|\r\n|        |\r\n\r\nThe following example produces an empty result because of the invalid level input.\r\n\r\n```\r\nprint s2cell = geo_point_to_s2cell(1,1,int(null))\r\n```\r\n\r\n| s2cell |\r\n|--------|\r\n|        |',"https://docs.microsoft.com/en-us/azure/kusto/query/geo-point-to-s2cell-function","geo-point-to-s2cell-function.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"geo_polygon_densify","Converts polygon or multipolygon planar edges to geodesics by adding intermediate points.",'## Syntax\r\n\r\n`geo_polygon_densify(`*polygon*`, `*tolerance*`)`\r\n\r\n## Arguments\r\n\r\n* *polygon*: Polygon or multipolygon in the [GeoJSON format](https://tools.ietf.org/html/rfc7946) and of a [dynamic](./scalar-data-types/dynamic.md) data type.\r\n* *tolerance*: An optional numeric that defines maximum distance in meters between the original planar edge and the converted geodesic edge chain. Supported values are in the range [0.1, 10000]. If unspecified, the default value `10` is used.\r\n\r\n## Returns\r\n\r\nDensified polygon in the [GeoJSON format](https://tools.ietf.org/html/rfc7946) and of a [dynamic](./scalar-data-types/dynamic.md) data type. If either the polygon or tolerance is invalid, the query will produce a null result.\r\n\r\n> [!NOTE]\r\n> * The geospatial coordinates are interpreted as represented by the [WGS-84](https://earth-info.nga.mil/GandG/update/index.php?action=home) coordinate reference system.\r\n> * The polygon must be correctly defined, but the function does not check polygon validity.\r\n\r\n**Polygon definition**\r\n\r\ndynamic({"type": "Polygon","coordinates": [ LinearRingShell, LinearRingHole_1 ,..., LinearRingHole_N ]})\r\n\r\ndynamic({"type": "MultiPolygon","coordinates": [[ LinearRingShell, LinearRingHole_1 ,..., LinearRingHole_N ] ,..., [LinearRingShell, LinearRingHole_1 ,..., LinearRingHole_M]]})\r\n\r\n* LinearRingShell is required and defined as a `counterclockwise` ordered array of coordinates [[lng_1,lat_1],...,[lng_i,lat_i],...,[lng_j,lat_j],...,[lng_1,lat_1]]. There can be only one shell.\r\n* LinearRingHole is optional and defined as a `clockwise` ordered array of coordinates [[lng_1,lat_1],...,[lng_i,lat_i],...,[lng_j,lat_j],...,[lng_1,lat_1]]. There can be any number of interior rings and holes.\r\n* LinearRing vertices must be distinct with at least three coordinates. The first coordinate must be equal to the last. At least four entries are required.\r\n* Coordinates [longitude,latitude] must be valid. Longitude must be a real number in the range [-180, +180] and latitude must be a real number in the range [-90, +90].\r\n* LinearRingShell encloses at most half of the sphere. LinearRing divides the sphere into two regions. The smaller of the two regions will be chosen.\r\n* LinearRing edge length must be less than 180 degrees. The shortest edge between the two vertices will be chosen.\r\n\r\n**Constraints**\r\n\r\n* The maximum number of points in the densified polygon is limited to 10485760.\r\n* Storing polygons in [dynamic](./scalar-data-types/dynamic.md) format has size limits.\r\n* Densifying a valid polygon may invalidate it. The algorithm adds points in a non-uniform manner and as such may cause edges to intertwine with each other.\r\n\r\n**Motivation**\r\n\r\n* [GeoJSON format](https://tools.ietf.org/html/rfc7946) defines an edge between two points as a straight cartesian line.\r\n* The decision to use geodesic or planar edges might depend on the dataset and is especially relevant in long edges.','The following example densifies Manhattan Central Park polygon. The edges are short and the distance between planar edges and their geodesic counterparts is less than the distance specified by tolerance. As such, the result remains unchanged.\r\n\r\n```\r\nprint densified_polygon = tostring(geo_polygon_densify(dynamic({"type":"Polygon","coordinates":[[[-73.958244,40.800719],[-73.949146,40.79695],[-73.973093,40.764226],[-73.982062,40.768159],[-73.958244,40.800719]]]})))\r\n```\r\n\r\n|densified_polygon|\r\n|---|\r\n|{"type":"Polygon","coordinates":[[[-73.958244,40.800719],[-73.949146,40.79695],[-73.973093,40.764226],[-73.982062,40.768159],[-73.958244,40.800719]]]}|\r\n\r\nThe following example densifies two edges of the polygon. Densified edges length is ~110 km\r\n\r\n```\r\nprint densified_polygon = tostring(geo_polygon_densify(dynamic({"type":"Polygon","coordinates":[[[10,10],[11,10],[11,11],[10,11],[10,10]]]})))\r\n```\r\n\r\n|densified_polygon|\r\n|---|\r\n|{"type":"Polygon","coordinates":[[[10,10],[10.25,10],[10.5,10],[10.75,10],[11,10],[11,11],[10.75,11],[10.5,11],[10.25,11],[10,11],[10,10]]]}|\r\n\r\nThe following example returns a null result because of the invalid coordinate input.\r\n\r\n```\r\nprint densified_polygon = geo_polygon_densify(dynamic({"type":"Polygon","coordinates":[[[10,900],[11,10],[11,11],[10,11],[10,10]]]}))\r\n```\r\n\r\n|densified_polygon|\r\n|---|\r\n||\r\n\r\nThe following example returns a null result because of the invalid tolerance input.\r\n\r\n```\r\nprint densified_polygon = geo_polygon_densify(dynamic({"type":"Polygon","coordinates":[[[10,10],[11,10],[11,11],[10,11],[10,10]]]}), 0)\r\n```\r\n\r\n|densified_polygon|\r\n|---|\r\n||',"https://docs.microsoft.com/en-us/azure/kusto/query/geo-polygon-densify-function","geo-polygon-densify-function.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"geo_polygon_to_s2cells","Calculates S2 cell tokens that cover a polygon or multipolygon on Earth. This function is a useful geospatial join tool.",'Read more about [S2 cell hierarchy](https://s2geometry.io/devguide/s2cell_hierarchy).\r\n\r\n## Syntax\r\n\r\n`geo_polygon_to_s2cells(`*polygon*`, `*level*`)`\r\n\r\n## Arguments\r\n\r\n* *polygon*: Polygon or multiPolygon in the [GeoJSON format](https://tools.ietf.org/html/rfc7946) and of a [dynamic](./scalar-data-types/dynamic.md) data type. \r\n* *level*: An optional `int` that defines the requested cell level. Supported values are in the range [0, 30]. If unspecified, the default value `11` is used.\r\n\r\n## Returns\r\n\r\nArray of S2 cell token strings that cover a polygon or multipolygon. If either the polygon or level is invalid, or the cell count exceeds the limit, the query will produce a null result.\r\n\r\n> [!NOTE]\r\n>\r\n> * Covering the polygon with S2 cell tokens can be useful in matching coordinates to polygons that might include these coordinates and matching polygons to polygons.\r\n> * The polygon covering tokens are of the same S2 cell level.\r\n> * The maximum count of tokens per polygon is 65536.\r\n> * The [geodetic datum](https://en.wikipedia.org/wiki/Geodetic_datum) used for measurements on Earth is a sphere. Polygon edges are [Geodesics](https://en.wikipedia.org/wiki/Geodesic) on the sphere.\r\n> * If input polygon edges are straight cartesian lines, consider using [geo_polygon_densify()](geo-polygon-densify-function.md) in order to convert planar edges to geodesics.\r\n\r\n**Motivation for covering polygons with S2 cell tokens**\r\n\r\nWithout this function, here is one approach we could take in order to classify coordinates into polygons containing these coordinates.\r\n\r\n```\r\nlet Polygons = \r\n    datatable(description:string, polygon:dynamic)\r\n    [  \r\n      "New York",  dynamic({"type":"Polygon","coordinates":[[[-73.85009765625,40.85744791303121],[-74.16046142578125,40.84290487729676],[-74.190673828125,40.59935608796518],[-73.83087158203125,40.61812224225511],[-73.85009765625,40.85744791303121]]]}),\r\n      "Seattle",   dynamic({"type":"Polygon","coordinates":[[[-122.200927734375,47.68573021131587],[-122.4591064453125,47.68573021131587],[-122.4755859375,47.468949677672484],[-122.17620849609374,47.47266286861342],[-122.200927734375,47.68573021131587]]]}),\r\n      "Las Vegas", dynamic({"type":"Polygon","coordinates":[[[-114.9,36.36],[-115.4498291015625,36.33282808737917],[-115.4498291015625,35.84453450421662],[-114.949951171875,35.902399875143615],[-114.9,36.36]]]}),\r\n    ];\r\nlet Coordinates = \r\n    datatable(longitude:real, latitude:real)\r\n    [\r\n      real(-73.95),  real(40.75), // New York\r\n      real(-122.3),  real(47.6),  // Seattle\r\n      real(-115.18), real(36.16)  // Las Vegas\r\n    ];\r\nPolygons | extend dummy=1\r\n| join kind=inner (Coordinates | extend dummy=1) on dummy\r\n| where geo_point_in_polygon(longitude, latitude, polygon)\r\n| project longitude, latitude, description\r\n```\r\n\r\n|longitude|latitude|description|\r\n|---|---|---|\r\n|-73.95|40.75|New York city|\r\n|-122.3|47.6|Seattle|\r\n|-115.18|36.16|Las Vegas|\r\n\r\nWhile this method works in some cases, it is inefficient. This method does a cross-join, meaning that it tries to match every polygon to every point. This process consumes a large amount of memory and compute resources.\r\nInstead, we would like to match every polygon to a point with a high probability of containment success, and filter out other points.\r\n\r\nThis match can be achieved by the following process:\r\n\r\n1. Converting polygons to S2 cells of level k,\r\n1. Converting points to the same S2 cells level k, \r\n1. Joining on S2 cells,\r\n1. Filtering by [geo_point_in_polygon()](geo-point-in-polygon-function.md).\r\n\r\n**Choosing the S2 cell level**\r\n\r\n* Ideally we would want to cover every polygon with one or just a few unique cells such that no two polygons share the same cell.\r\n* If the polygons are close to each other, choose the [S2 cell level](geo-point-to-s2cell-function.md) such that its cell edge will be smaller (4, 8, 12 times smaller) than the edge of the average polygon.\r\n* If the polygons are far from each other, choose the [S2 cell level](geo-point-to-s2cell-function.md) such that its cell edge will be similar to the edge of the average polygon.\r\n* In practice, covering a polygon with more than 10000 cells might not yield good performance.\r\n* Sample use cases:\r\n   - S2 cell level 5 might prove to be good for covering countries.\r\n   - S2 cell level 16 can cover dense and relatively small Manhattan (New York) neighborhoods.\r\n   - S2 cell level 11 can be used for covering suburbs of Australia.\r\n* Query run time and memory consumption might differ because of different S2 cell level values.\r\n\r\n> [!WARNING]\r\n> Covering a large-area polygon with small-area cells can lead to a huge amount of covering cells. As a result, the query might return null.','The following example classifies coordinates into polygons.\r\n\r\n```\r\nlet Polygons = \r\n    datatable(description:string, polygon:dynamic)\r\n    [\r\n        \'Greenwich Village\', dynamic({"type":"Polygon","coordinates":[[[-73.991460000000131,40.731738000000206],[-73.992854491775518,40.730082566051351],[-73.996772,40.725432000000154],[-73.997634685522883,40.725786309886963],[-74.002855946639244,40.728346630056791],[-74.001413,40.731065000000207],[-73.996796995070824,40.73736378205173],[-73.991724524037934,40.735245208931886],[-73.990703782359589,40.734781896080477],[-73.991460000000131,40.731738000000206]]]}),\r\n        \'Upper West Side\',   dynamic({"type":"Polygon","coordinates":[[[-73.958357552055688,40.800369095633819],[-73.98143901556422,40.768762584141953],[-73.981548752788598,40.7685590292784],[-73.981565335901905,40.768307084720796],[-73.981754418060945,40.768399727738668],[-73.982038573548124,40.768387823012056],[-73.982268248204349,40.768298621883247],[-73.982384797518051,40.768097213086911],[-73.982320919746599,40.767894461792181],[-73.982155532845766,40.767756204474757],[-73.98238873834039,40.767411004834273],[-73.993650353659021,40.772145571634361],[-73.99415893763998,40.772493009137818],[-73.993831082030937,40.772931787850908],[-73.993891252437052,40.772955194876722],[-73.993962585514595,40.772944653908901],[-73.99401262480508,40.772882846631894],[-73.994122058082397,40.77292405902601],[-73.994136652588594,40.772901870174394],[-73.994301342391154,40.772970028663913],[-73.994281535134448,40.77299380206933],[-73.994376552751078,40.77303955110149],[-73.994294029824005,40.773156243992048],[-73.995023275860802,40.773481196576356],[-73.99508939189289,40.773388475039134],[-73.995013963716758,40.773358035426909],[-73.995050284699261,40.773297153189958],[-73.996240651898916,40.773789791397689],[-73.996195837470992,40.773852356184044],[-73.996098807369748,40.773951805299085],[-73.996179459973888,40.773986954351571],[-73.996095245226442,40.774086186437756],[-73.995572265161172,40.773870731394297],[-73.994017424135961,40.77321375261053],[-73.993935876811335,40.773179512586211],[-73.993861942928888,40.773269531698837],[-73.993822393527211,40.773381758622882],[-73.993767019318497,40.773483981224835],[-73.993698463744295,40.773562141052594],[-73.993358326468751,40.773926888327956],[-73.992622663865575,40.774974056037109],[-73.992577842766124,40.774956016359418],[-73.992527743951555,40.775002110439829],[-73.992469745815342,40.775024159551755],[-73.992403837191887,40.775018140390664],[-73.99226708903538,40.775116033858794],[-73.99217809026365,40.775279293897171],[-73.992059084937338,40.775497598192516],[-73.992125372394938,40.775509075053385],[-73.992226867797001,40.775482211026116],[-73.992329346608813,40.775468900958522],[-73.992361756801131,40.775501899766638],[-73.992386042960277,40.775557180424634],[-73.992087684712729,40.775983970821372],[-73.990927174149746,40.777566878763238],[-73.99039616003671,40.777585065679204],[-73.989461267506471,40.778875124584417],[-73.989175778438053,40.779287524015778],[-73.988868617400072,40.779692922911607],[-73.988871874499793,40.779713738253008],[-73.989219022880576,40.779697895209402],[-73.98927785904425,40.779723439271038],[-73.989409054180143,40.779737706471963],[-73.989498614927044,40.779725044389757],[-73.989596493388234,40.779698146683387],[-73.989679812902509,40.779677568658038],[-73.989752702937935,40.779671244211556],[-73.989842247806507,40.779680752670664],[-73.990040102120489,40.779707677698219],[-73.990137977524839,40.779699769704784],[-73.99033584033225,40.779661794394983],[-73.990430598697046,40.779664973055503],[-73.990622199396725,40.779676064914298],[-73.990745069505479,40.779671328184051],[-73.990872114282197,40.779646007643876],[-73.990961672224358,40.779639683751753],[-73.991057472829539,40.779652352625774],[-73.991157429497036,40.779669775606465],[-73.991242817404469,40.779671367084504],[-73.991255318289745,40.779650782516491],[-73.991294887120119,40.779630209208889],[-73.991321967649895,40.779631796041372],[-73.991359455569423,40.779585883337383],[-73.991551059227476,40.779574821437407],[-73.99141982585985,40.779755280287233],[-73.988886144117032,40.779878898532999],[-73.988939656706265,40.779956178440393],[-73.988926103530844,40.780059292013632],[-73.988911680264692,40.780096037146606],[-73.988919261468567,40.780226094343945],[-73.988381050202634,40.780981074045783],[-73.988232413846987,40.781233144215555],[-73.988210420831663,40.781225482542055],[-73.988140000000143,40.781409000000224],[-73.988041288067166,40.781585961353777],[-73.98810029382463,40.781602878305286],[-73.988076449145055,40.781650935001608],[-73.988018059972219,40.781634188810422],[-73.987960792842145,40.781770987031535],[-73.985465811970457,40.785360700575431],[-73.986172704965611,40.786068452258647],[-73.986455862401996,40.785919219081421],[-73.987072345615601,40.785189638820121],[-73.98711901394276,40.785210319004058],[-73.986497781023601,40.785951202887254],[-73.986164628806279,40.786121882448327],[-73.986128422486075,40.786239001331111],[-73.986071135219746,40.786240706026611],[-73.986027274789123,40.786228964236727],[-73.986097637849426,40.78605822569795],[-73.985429321269592,40.785413942184597],[-73.985081137732209,40.785921935110366],[-73.985198833254501,40.785966552197777],[-73.985170502389906,40.78601333415817],[-73.985216218673656,40.786030501816427],[-73.98525509797993,40.785976205511588],[-73.98524273937646,40.785972572653328],[-73.98524962933017,40.785963139855845],[-73.985281779186749,40.785978620950075],[-73.985240032884533,40.786035858136792],[-73.985683885242182,40.786222123919686],[-73.985717529004575,40.786175994668795],[-73.985765660297687,40.786196274858618],[-73.985682871922691,40.786309786213067],[-73.985636270930442,40.786290150649279],[-73.985670722564691,40.786242911993817],[-73.98520511880038,40.786047669212785],[-73.985211035607492,40.786039554883686],[-73.985162639946992,40.786020999769754],[-73.985131636312062,40.786060297019972],[-73.985016964065125,40.78601423719563],[-73.984655078830457,40.786534741807841],[-73.985743787901043,40.786570082854738],[-73.98589227228328,40.786426529019593],[-73.985942854994988,40.786452847880334],[-73.985949561556794,40.78648711396653],[-73.985812373526713,40.786616865357047],[-73.985135209703174,40.78658761889551],[-73.984619428584324,40.786586016349787],[-73.981952458164173,40.790393724337193],[-73.972823037363767,40.803428052816756],[-73.971036786332192,40.805918478839672],[-73.966701,40.804169000000186],[-73.959647,40.801156000000113],[-73.958508540159471,40.800682279767472],[-73.95853274080838,40.800491362464697],[-73.958357552055688,40.800369095633819]]]}),\r\n        \'Upper East Side\',   dynamic({"type":"Polygon","coordinates":[[[-73.943592454622546,40.782747908206574],[-73.943648235390199,40.782656161333449],[-73.943870759887162,40.781273026571704],[-73.94345932494096,40.780048275653243],[-73.943213862652243,40.779317588660199],[-73.943004239504688,40.779639495474292],[-73.942716005450905,40.779544169476175],[-73.942712374762181,40.779214856940001],[-73.942535563208608,40.779090956062532],[-73.942893408188027,40.778614093246276],[-73.942438481745029,40.777315235766039],[-73.942244919522594,40.777104088947254],[-73.942074188038887,40.776917846977142],[-73.942002667222781,40.776185317382648],[-73.942620205199006,40.775180871576474],[-73.94285645694552,40.774796600349191],[-73.94293043781397,40.774676268036011],[-73.945870899588215,40.771692257932997],[-73.946618690150586,40.77093339256956],[-73.948664164778933,40.768857624399587],[-73.950069793030679,40.767025088383498],[-73.954418260786071,40.762184104951245],[-73.95650786241211,40.760285256574043],[-73.958787773424007,40.758213471309809],[-73.973015157270069,40.764278692864671],[-73.955760332998182,40.787906554459667],[-73.944023,40.782960000000301],[-73.943592454622546,40.782747908206574]]]}),\r\n    ];\r\nlet Coordinates = \r\n    datatable(longitude:real, latitude:real)\r\n    [\r\n        real(-73.9741), 40.7914, // Upper West Side\r\n        real(-73.9950), 40.7340, // Greenwich Village\r\n        real(-73.9584), 40.7688, // Upper East Side\r\n    ];\r\nlet Level = 16;\r\nPolygons\r\n| extend covering = geo_polygon_to_s2cells(polygon, Level) // cover every polygon with s2 cell token array\r\n| mv-expand covering to typeof(string)                     // expand cells array such that every row will have one cell mapped to its polygon\r\n| join kind=inner hint.strategy=broadcast                  // assume that Polygons count is small (In some specific case)\r\n(\r\n    Coordinates\r\n    | extend covering = geo_point_to_s2cell(longitude, latitude, Level) // cover point with cell\r\n) on covering // join on the cell, this filters out rows of point and polygons where the point definitely does not belong to the polygon\r\n| where geo_point_in_polygon(longitude, latitude, polygon)\r\n| project longitude, latitude, description\r\n```\r\n\r\n|longitude|latitude|description|\r\n|---|---|---|\r\n|-73.9741|40.7914|Upper West Side|\r\n|-73.995|40.734|Greenwich Village|\r\n|-73.9584|40.7688|Upper East Side|\r\n\r\nCount of cells that will be needed in order to cover some polygon with S2 cells of level 5.\r\n\r\n```\r\nlet polygon = dynamic({"type":"Polygon","coordinates":[[[0,0],[0,50],[100,50],[0,0]]]});\r\nprint s2_cell_token_count = array_length(geo_polygon_to_s2cells(polygon, 5));\r\n```\r\n\r\n|s2_cell_token_count|\r\n|---|\r\n|286|\r\n\r\nCovering a large-area polygon with small-area cells returns null.\r\n\r\n```\r\nlet polygon = dynamic({"type":"Polygon","coordinates":[[[0,0],[0,50],[100,50],[0,0]]]});\r\nprint geo_polygon_to_s2cells(polygon, 30);\r\n```\r\n\r\n|print_0|\r\n|---|\r\n||\r\n\r\nCovering a large-area polygon with small-area cells returns null.\r\n\r\n```\r\nlet polygon = dynamic({"type":"Polygon","coordinates":[[[0,0],[0,50],[100,50],[0,0]]]});\r\nprint isnull(geo_polygon_to_s2cells(polygon, 30));\r\n```\r\n\r\n|print_0|\r\n|---|\r\n|1|',"https://docs.microsoft.com/en-us/azure/kusto/query/geo-polygon-to-s2cells-function","geo-polygon-to-s2cells-function.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"geo_s2cell_to_central_point","Calculates the geospatial coordinates that represent the center of an S2 cell.","Read more about [S2 cell hierarchy](https://s2geometry.io/devguide/s2cell_hierarchy).\r\n\r\n## Syntax\r\n\r\n`geo_s2cell_to_central_point(`*s2cell*`)`\r\n\r\n## Arguments\r\n\r\n*s2cell*: S2 cell token string value as it was calculated by [geo_point_to_s2cell()](geo-point-to-s2cell-function.md). The S2 cell token maximum string length is 16 characters.\r\n\r\n## Returns\r\n\r\nThe geospatial coordinate values in [GeoJSON Format](https://tools.ietf.org/html/rfc7946) and of a [dynamic](./scalar-data-types/dynamic.md) data type. If the S2 cell token is invalid, the query will produce a null result.\r\n\r\n> [!NOTE]\r\n> The GeoJSON format specifies longitude first and latitude second.",'```\r\nprint point = geo_s2cell_to_central_point("1234567")\r\n| extend coordinates = point.coordinates\r\n| extend longitude = coordinates[0], latitude = coordinates[1]\r\n```\r\n\r\n|point|coordinates|longitude|latitude|\r\n|---|---|---|---|\r\n|{<br>  "type": "Point",<br>  "coordinates": [<br>    9.86830731850408,<br>    27.468392925827604<br>  ]<br>}|[<br>  9.86830731850408,<br>  27.468392925827604<br>]|9.86830731850408|27.4683929258276|\r\n\r\nThe following example returns a null result because of the invalid S2 cell token input.\r\n\r\n```\r\nprint point = geo_s2cell_to_central_point("a")\r\n```\r\n\r\n|point|\r\n|---|\r\n||',"https://docs.microsoft.com/en-us/azure/kusto/query/geo-s2cell-to-central-point-function","geo-s2cell-to-central-point-function.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"getmonth","Get the month number (1-12) from a datetime.","Another alias: monthoyear()","```\r\nprint month = getmonth(datetime(2015-10-12))\r\n```","https://docs.microsoft.com/en-us/azure/kusto/query/getmonthfunction","getmonthfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.OperatorToken,"getschema","Produce a table that represents a tabular schema of the input.","```\r\nT | summarize MyCount=count() by Country | getschema \r\n```\r\n\r\n## Syntax\r\n\r\n*T* `| ` `getschema`","```\r\nStormEvents\r\n| top 10 by Timestamp\r\n| getschema\r\n```\r\n\r\n|ColumnName|ColumnOrdinal|DataType|ColumnType|\r\n|---|---|---|---|\r\n|Timestamp|0|System.DateTime|datetime|\r\n|Language|1|System.String|string|\r\n|Page|2|System.String|string|\r\n|Views|3|System.Int64|long\r\n|BytesDelivered|4|System.Int64|long","https://docs.microsoft.com/en-us/azure/kusto/query/getschemaoperator","getschemaoperator.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"gettype","Returns the runtime type of its single argument.","The runtime type may be different than the nominal (static) type for expressions\r\nwhose nominal type is `dynamic`; in such cases `gettype()` can be useful to reveal\r\nthet type of the actual value (how the value is encoded in memory).\r\n\r\n## Syntax\r\n\r\n`gettype(`*Expr*`)`\r\n\r\n## Returns\r\n\r\nA string representing the runtime type of its single argument.","|Expression                          |Returns      |\r\n|------------------------------------|-------------|\r\n|`gettype(\"a\")`                      |`string`     |\r\n|`gettype(111)`                      |`long`       |\r\n|`gettype(1==1)`                     |`bool`       |\r\n|`gettype(now())`                    |`datetime`   |\r\n|`gettype(1s)`                       |`timespan`   |\r\n|`gettype(parse_json('1'))`           |`int`        |\r\n|`gettype(parse_json(' \"abc\" '))`     |`string`     |\r\n|`gettype(parse_json(' {\"abc\":1} '))` |`dictionary` | \r\n|`gettype(parse_json(' [1, 2, 3] '))` |`array`      |\r\n|`gettype(123.45)`                   |`real`       |\r\n|`gettype(guid(12e8b78d-55b4-46ae-b068-26d7a0080254))`|`guid`| \r\n|`gettype(parse_json(''))`            |`null`|","https://docs.microsoft.com/en-us/azure/kusto/query/gettypefunction","gettypefunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"getyear","Returns the year part of the `datetime` argument.","","```\r\nT\r\n| extend year = getyear(datetime(2015-10-12))\r\n// year == 2015\r\n```","https://docs.microsoft.com/en-us/azure/kusto/query/getyearfunction","getyearfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.OperatorToken,"has_any","`has_any` operator filters based on the provided set of values.","```\r\nTable1 | where col has_any ('value1', 'value2')\r\n```\r\n\r\n## Syntax\r\n\r\n*T* `|` `where` *col* `has_any` `(`*list of scalar expressions*`)`   \r\n*T* `|` `where` *col* `has_any` `(`*tabular expression*`)`   \r\n\r\n## Arguments\r\n\r\n* *T* - Tabular input whose records are to be filtered.\r\n* *col* - Column to filter.\r\n* *list of expressions* - Comma separated list of tabular, scalar, or literal expressions  \r\n* *tabular expression* - Tabular expression that has a set of values (if expression has multiple columns, the first column is used)\r\n\r\n## Returns\r\n\r\nRows in *T* for which the predicate is `true`\r\n\r\n**Notes**\r\n\r\n* The expression list can produce up to `10,000` values.    \r\n* For tabular expressions, the first column of the result set is selected.   \r\n\r\n**Examples:**  \r\n\r\n**A simple usage of `has_any` operator:**  \r\n\r\n```\r\nStormEvents \r\n| where State has_any (\"CAROLINA\", \"DAKOTA\", \"NEW\") \r\n| summarize count() by State\r\n```\r\n\r\n|State|count_|\r\n|---|---|\r\n|NEW YORK|1750|\r\n|NORTH CAROLINA|1721|\r\n|SOUTH DAKOTA|1567|\r\n|NEW JERSEY|1044|\r\n|SOUTH CAROLINA|915|\r\n|NORTH DAKOTA|905|\r\n|NEW MEXICO|527|\r\n|NEW HAMPSHIRE|394|\r\n\r\n**Using dynamic array:**\r\n\r\n```\r\nlet states = dynamic(['south', 'north']);\r\nStormEvents \r\n| where State has_any (states)\r\n| summarize count() by State\r\n```\r\n\r\n|State|count_|\r\n|---|---|\r\n|NORTH CAROLINA|1721|\r\n|SOUTH DAKOTA|1567|\r\n|SOUTH CAROLINA|915|\r\n|NORTH DAKOTA|905|\r\n|ATLANTIC SOUTH|193|\r\n|ATLANTIC NORTH|188|","","https://docs.microsoft.com/en-us/azure/kusto/query/has-anyoperator","")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"hash","Returns a hash value for the input value.","## Syntax\r\n\r\n`hash(`*source* [`,` *mod*]`)`\r\n\r\n## Arguments\r\n\r\n* *source*: The value to be hashed.\r\n* *mod*: An optional module value to be applied to the hash result, so that\r\n  the output value is between `0` and *mod* - 1\r\n\r\n## Returns\r\n\r\nThe hash value of the given scalar, modulo the given mod value (if specified).\r\n\r\n> [!WARNING]\r\n> The algorithm used to calculate the hash is xxhash.\r\n> This algorithm might change in the future, and the only guarantee is that\r\n> within a single query all invocations of this method use the same algorithm.\r\n> Consequently, you are advised not to store the results of `hash()` in a\r\n> table. If persisting hash values is required, use\r\n> [hash_sha256()](./sha256hashfunction.md) or [hash_md5()](./md5hashfunction.md) instead. Note that these functions are more complex to calculate than `hash()`).",'```\r\nhash("World")                   // 1846988464401551951\r\nhash("World", 100)              // 51 (1846988464401551951 % 100)\r\nhash(datetime("2015-01-01"))    // 1380966698541616202\r\n```\r\n\r\nThe following example uses the hash function to run a query on 10% of the data,\r\nIt is helpful to use the hash function for sampling the data when assuming the value is uniformly distributed (In this example StartTime value)\r\n\r\n```\r\nStormEvents \r\n| where hash(StartTime, 10) == 0\r\n| summarize StormCount = count(), TypeOfStorms = dcount(EventType) by State \r\n| top 5 by StormCount desc\r\n```',"https://docs.microsoft.com/en-us/azure/kusto/query/hashfunction","hashfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"hash_combine","Combines hash values of two or more hashes.","## Syntax\r\n\r\n`hash_combine(`*h1* `,` *h2* [`,` *h3* ...]`)`\r\n\r\n## Arguments\r\n\r\n* *h1*: Long value representing the first hash value.\r\n* *h2*: Long value representing the second hash value.\r\n* *hN*: Long value representing Nth hash value.\r\n\r\n## Returns\r\n\r\nThe combined hash value of the given scalars.",'```\r\nprint value1 = "Hello", value2 = "World"\r\n| extend h1 = hash(value1), h2=hash(value2)\r\n| extend combined = hash_combine(h1, h2)\r\n```\r\n\r\n|value1|value2|h1|h2|combined|\r\n|---|---|---|---|---|\r\n|Hello|World|753694413698530628|1846988464401551951|-1440138333540407281|',"https://docs.microsoft.com/en-us/azure/kusto/query/hash_combinefunction","hash_combinefunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"hash_many","Returns a combined hash value of multiple values.","## Syntax\r\n\r\n`hash_many(`*s1* `,` *s2* [`,` *s3* ...]`)`\r\n\r\n## Arguments\r\n\r\n* *s1*, *s2*, ..., *sN*: input values that will be hashed together.\r\n\r\n## Returns\r\n\r\nThe combined hash value of the given scalars.",'```\r\nprint value1 = "Hello", value2 = "World"\r\n| extend combined = hash_many(value1, value2)\r\n```\r\n\r\n|value1|value2|combined|\r\n|---|---|---|\r\n|Hello|World|-1440138333540407281|',"https://docs.microsoft.com/en-us/azure/kusto/query/hash_manyfunction","hash_manyfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"hash_md5","Returns an MD5 hash value for the input value.",'## Syntax\r\n\r\n`hash_md5(`*source*`)`\r\n\r\n## Arguments\r\n\r\n* *source*: The value to be hashed.\r\n\r\n## Returns\r\n\r\nThe MD5 hash value of the given scalar, encoded as a hex string (a string\r\nof characters, each two of which represent a single Hex number between 0\r\nand 255).\r\n\r\n> [!WARNING]\r\n> The algorithm used by this function (MD5) is guaranteed\r\n> to not be modified in the future, but is very complex to calculate. Users that\r\n> need a "lightweight" hash function for the duration of a single query are advised\r\n> to use the function [hash()](./hashfunction.md) instead.','```\r\nprint \r\nh1=hash_md5("World"),\r\nh2=hash_md5(datetime(2020-01-01))\r\n```\r\n\r\n|h1|h2|\r\n|---|---|\r\n|f5a7924e621e84c9280a9a27e1bcb7f6|786c530672d1f8db31fee25ea8a9390b|\r\n\r\nThe following example uses the `hash_md5()` function to aggregate StormEvents based on State\'s MD5 hash value. \r\n\r\n```\r\nStormEvents\r\n| summarize StormCount = count() by State, StateHash=hash_md5(State)\r\n| top 5 by StormCount\r\n```\r\n\r\n|State|StateHash|StormCount|\r\n|---|---|---|\r\n|TEXAS|3b00dbe6e07e7485a1c12d36c8e9910a|4701|\r\n|KANSAS|e1338d0ac8be43846cf9ae967bd02e7f|3166|\r\n|IOWA|6d4a7c02942f093576149db764d4e2d2|2337|\r\n|ILLINOIS|8c00d9e0b3fcd55aed5657e42cc40cf1|2022|\r\n|MISSOURI|2d82f0c963c0763012b2539d469e5008|2016|',"https://docs.microsoft.com/en-us/azure/kusto/query/md5hashfunction","md5hashfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"hash_sha256","Returns a sha256 hash value for the input value.",'## Syntax\r\n\r\n`hash_sha256(`*source*`)`\r\n\r\n## Arguments\r\n\r\n* *source*: The value to be hashed.\r\n\r\n## Returns\r\n\r\nThe sha256 hash value of the given scalar, encoded as a hex string (a string\r\nof characters, each two of which represent a single Hex number between 0\r\nand 255).\r\n\r\n> [!WARNING]\r\n> The algorithm used by this function (SHA256) is guaranteed\r\n> to not be modified in the future, but is very complex to calculate. Users that\r\n> need a "lightweight" hash function for the duration of a single query are advised\r\n> to use the function [hash()](./hashfunction.md) instead.','```\r\nprint \r\nh1=hash_sha256("World"),\r\nh2=hash_sha256(datetime(2020-01-01))\r\n```\r\n\r\n|h1|h2|\r\n|---|---|\r\n|78ae647dc5544d227130a0682a51e30bc7777fbb6d8a8f17007463a3ecd1d524|ba666752dc1a20eb750b0eb64e780cc4c968bc9fb8813461c1d7e750f302d71d|\r\n\r\nThe following example uses the `hash_sha256()` function to aggregate StormEvents based on State\'s SHA256 hash value. \r\n\r\n```\r\nStormEvents \r\n| summarize StormCount = count() by State, StateHash=hash_sha256(State)\r\n| top 5 by StormCount desc\r\n```\r\n\r\n|State|StateHash|StormCount|\r\n|---|---|---|\r\n|TEXAS|9087f20f23f91b5a77e8406846117049029e6798ebbd0d38aea68da73a00ca37|4701|\r\n|KANSAS|c80e328393541a3181b258cdb4da4d00587c5045e8cf3bb6c8fdb7016b69cc2e|3166|\r\n|IOWA|f85893dca466f779410f65cd904fdc4622de49e119ad4e7c7e4a291ceed1820b|2337|\r\n|ILLINOIS|ae3eeabfd7eba3d9a4ccbfed6a9b8cff269dc43255906476282e0184cf81b7fd|2022|\r\n|MISSOURI|d15dfc28abc3ee73b7d1f664a35980167ca96f6f90e034db2a6525c0b8ba61b1|2016|',"https://docs.microsoft.com/en-us/azure/kusto/query/sha256hashfunction","sha256hashfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"hll","Calculates the Intermediate results of [`dcount`](dcount-aggfunction.md) across the group, only in context of aggregation inside [summarize](summarizeoperator.md).","Read about the [underlying algorithm (*H*yper*L*og*L*og) and the estimation accuracy](dcount-aggfunction.md#estimation-accuracy).\r\n\r\n## Syntax\r\n\r\n`summarize hll(`*`Expr`* `[,` *`Accuracy`*`])`\r\n\r\n## Arguments\r\n\r\n* *`Expr`*: Expression that will be used for aggregation calculation. \r\n* *`Accuracy`*, if specified, controls the balance between speed and accuracy.\r\n  |Accuracy Value |Accuracy  |Speed  |Error  |\r\n  |---------|---------|---------|---------|\r\n  |`0` | lowest | fastest | 1.6% |\r\n  |`1` | default  | balanced | 0.8% |\r\n  |`2` | high | slow | 0.4%  |\r\n  |`3` | high | slow | 0.28% |\r\n  |`4` | extra high | slowest | 0.2% |\r\n\t\r\n\r\n## Returns\r\n\r\nThe Intermediate results of distinct count of *`Expr`* across the group.\r\n\r\n**Tips**\r\n\r\n1. You may use the aggregation function [`hll_merge`](hll-merge-aggfunction.md) to merge more than one `hll` intermediate results (it works on `hll` output only).\r\n1. You may use the function [`dcount_hll`](dcount-hllfunction.md), which will calculate the `dcount` from `hll` / `hll_merge` aggregation functions.","```\r\nStormEvents\r\n| summarize hll(DamageProperty) by bin(StartTime,10m)\r\n\r\n```\r\n\r\n|StartTime|`hll_DamageProperty`|\r\n|---|---|\r\n|2007-09-18 20:00:00.0000000|[[1024,14],[-5473486921211236216,-6230876016761372746,3953448761157777955,4246796580750024372],[]]|\r\n|2007-09-20 21:50:00.0000000|[[1024,14],[4835649640695509390],[]]|\r\n|2007-09-29 08:10:00.0000000|[[1024,14],[4246796580750024372],[]]|\r\n|2007-12-30 16:00:00.0000000|[[1024,14],[4246796580750024372,-8936707700542868125],[]]|","https://docs.microsoft.com/en-us/azure/kusto/query/hll-aggfunction","hll-aggfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"hll_merge","Merges `hll` results (scalar version of the aggregate version [`hll_merge()`](hll-merge-aggfunction.md)).","Read about the [underlying algorithm (*H*yper*L*og*L*og) and estimation accuracy](dcount-aggfunction.md#estimation-accuracy).\r\n\r\n## Syntax\r\n\r\n`hll_merge(` *Expr1*`,` *Expr2*`, ...)`\r\n\r\n## Arguments\r\n\r\n* Columns that have `hll` values to be merged.\r\n\r\n## Returns\r\n\r\nThe result for merging the columns `*Exrp1*`, `*Expr2*`, ... `*ExprN*` to one `hll` value.","```\r\nrange x from 1 to 10 step 1 \r\n| extend y = x + 10\r\n| summarize hll_x = hll(x), hll_y = hll(y)\r\n| project merged = hll_merge(hll_x, hll_y)\r\n| project dcount_hll(merged)\r\n```\r\n\r\n|`dcount_hll_merged`|\r\n|---|\r\n|20|","https://docs.microsoft.com/en-us/azure/kusto/query/hllmergefunction","hllmergefunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"hourofday","Returns the integer number representing the hour number of the given date","```\r\nhourofday(datetime(2015-12-14 18:54)) == 18\r\n```\r\n\r\n## Syntax\r\n\r\n`hourofday(`*a_date*`)`\r\n\r\n## Arguments\r\n\r\n* `a_date`: A `datetime`.\r\n\r\n## Returns\r\n\r\n`hour number` of the day (0-23).","","https://docs.microsoft.com/en-us/azure/kusto/query/hourofdayfunction","")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"iff","Evaluates the first argument (the predicate), and returns the value of either the second or third arguments, depending on whether the predicate evaluated to `true` (second) or `false` (third).","The second and third arguments must be of the same type.\r\n\r\n## Syntax\r\n\r\n`iff(`*predicate*`,` *ifTrue*`,` *ifFalse*`)`\r\n\r\n## Arguments\r\n\r\n* *predicate*: An expression that evaluates to a `boolean` value.\r\n* *ifTrue*: An expression that gets evaluated and its value returned from the function if *predicate* evaluates to `true`.\r\n* *ifFalse*: An expression that gets evaluated and its value returned from the function if *predicate* evaluates to `false`.\r\n\r\n## Returns\r\n\r\nThis function returns the value of *ifTrue* if *predicate* evaluates to `true`,\r\nor the value of *ifFalse* otherwise.",'```\r\nT \r\n| extend day = iff(floor(Timestamp, 1d)==floor(now(), 1d), "today", "anotherday")\r\n```',"https://docs.microsoft.com/en-us/azure/kusto/query/ifffunction","ifffunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"iif","Evaluates the first argument (the predicate), and returns the value of either the second or third arguments, depending on whether the predicate evaluated to `true` (second) or `false` (third).","The second and third arguments must be of the same type.\r\n\r\n## Syntax\r\n\r\n`iif(`*predicate*`,` *ifTrue*`,` *ifFalse*`)`\r\n\r\n## Arguments\r\n\r\n* *predicate*: An expression that evaluates to a `boolean` value.\r\n* *ifTrue*: An expression that gets evaluated and its value returned from the function if *predicate* evaluates to `true`.\r\n* *ifFalse*: An expression that gets evaluated and its value returned from the function if *predicate* evaluates to `false`.\r\n\r\n## Returns\r\n\r\nThis function returns the value of *ifTrue* if *predicate* evaluates to `true`,\r\nor the value of *ifFalse* otherwise.",'```\r\nT \r\n| extend day = iif(floor(Timestamp, 1d)==floor(now(), 1d), "today", "anotherday")\r\n```\r\n\r\nAn alias for [`iff()`](ifffunction.md).',"https://docs.microsoft.com/en-us/azure/kusto/query/iiffunction","iiffunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.OperatorToken,"in","Filters a record set based on the provided set of values.","```\r\nTable1 | where col in ('value1', 'value2')\r\n```\r\n\r\n> [!NOTE]\r\n> * Adding '~' to the operator makes values' search case-insensitive: `x in~ (expression)` or `x !in~ (expression)`.\r\n> * In tabular expressions, the first column of the result set is selected.\r\n> * The expression list can produce up to `1,000,000` values.\r\n> * Nested arrays are flattened into a single list of values. For example, `x in (dynamic([1,[2,3]]))` becomes `x in (1,2,3)`.\r\n\r\n## Syntax\r\n\r\n### Case-sensitive syntax\r\n\r\n*T* `|` `where` *col* `in` `(`*list of scalar expressions*`)`   \r\n*T* `|` `where` *col* `in` `(`*tabular expression*`)`   \r\n\r\n*T* `|` `where` *col* `!in` `(`*list of scalar expressions*`)`  \r\n*T* `|` `where` *col* `!in` `(`*tabular expression*`)`   \r\n\r\n### Case insensitive syntax\r\n\r\n*T* `|` `where` *col* `in~` `(`*list of scalar expressions*`)`   \r\n*T* `|` `where` *col* `in~` `(`*tabular expression*`)`   \r\n\r\n*T* `|` `where` *col* `!in~` `(`*list of scalar expressions*`)`  \r\n*T* `|` `where` *col* `!in~` `(`*tabular expression*`)`   \r\n\r\n## Arguments\r\n\r\n* *T* - The tabular input whose records are to be filtered.\r\n* *col* - The column to filter.\r\n* *list of expressions* - A comma-separated list of tabular, scalar, or literal expressions.\r\n* *tabular expression* - A tabular expression that has a set of values. If the expression has multiple columns, the first column is used.\r\n\r\n## Returns\r\n\r\nRows in *T* for which the predicate is `true`.",'### Use \'in\' operator\r\n\r\n```\r\nStormEvents \r\n| where State in ("FLORIDA", "GEORGIA", "NEW YORK") \r\n| count\r\n```\r\n\r\n|Count|\r\n|---|\r\n|4775|  \r\n\r\n### Use \'in~\' operator  \r\n\r\n```\r\nStormEvents \r\n| where State in~ ("Florida", "Georgia", "New York") \r\n| count\r\n```\r\n\r\n|Count|\r\n|---|\r\n|4775|  \r\n\r\n### Use \'!in\' operator\r\n\r\n```\r\nStormEvents \r\n| where State !in ("FLORIDA", "GEORGIA", "NEW YORK") \r\n| count\r\n```\r\n\r\n|Count|\r\n|---|\r\n|54291|  \r\n\r\n### Use dynamic array\r\n\r\n```\r\nlet states = dynamic([\'FLORIDA\', \'ATLANTIC SOUTH\', \'GEORGIA\']);\r\nStormEvents \r\n| where State in (states)\r\n| count\r\n```\r\n\r\n|Count|\r\n|---|\r\n|3218|\r\n\r\n### Subquery\r\n\r\n```\r\n// Using subquery\r\nlet Top_5_States = \r\nStormEvents\r\n| summarize count() by State\r\n| top 5 by count_; \r\nStormEvents \r\n| where State in (Top_5_States) \r\n| count\r\n```\r\n\r\nThe same query can be written as:\r\n\r\n```\r\n// Inline subquery \r\nStormEvents \r\n| where State in (\r\n    ( StormEvents\r\n    | summarize count() by State\r\n    | top 5 by count_ )\r\n) \r\n| count\r\n```\r\n\r\n|Count|\r\n|---|\r\n|14242|  \r\n\r\n### Top with other example\r\n\r\n```\r\nlet Lightning_By_State = materialize(StormEvents | summarize lightning_events = countif(EventType == \'Lightning\') by State);\r\nlet Top_5_States = Lightning_By_State | top 5 by lightning_events | project State; \r\nLightning_By_State\r\n| extend State = iif(State in (Top_5_States), State, "Other")\r\n| summarize sum(lightning_events) by State \r\n```\r\n\r\n| State     | sum_lightning_events |\r\n|-----------|----------------------|\r\n| ALABAMA   | 29                   |\r\n| WISCONSIN | 31                   |\r\n| TEXAS     | 55                   |\r\n| FLORIDA   | 85                   |\r\n| GEORGIA   | 106                  |\r\n| Other     | 415                  |\r\n\r\n### Use a static list returned by a function\r\n\r\n```\r\nStormEvents | where State in (InterestingStates()) | count\r\n\r\n```\r\n\r\n|Count|\r\n|---|\r\n|4775|  \r\n\r\nThe function definition.\r\n\r\n```\r\n.show function InterestingStates\r\n```\r\n\r\n|Name|Parameters|Body|Folder|DocString|\r\n|---|---|---|---|---|\r\n|InterestingStates|()|{ dynamic(["WASHINGTON", "FLORIDA", "GEORGIA", "NEW YORK"]) }',"https://docs.microsoft.com/en-us/azure/kusto/query/inoperator","inoperator.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"indexof","Reports the zero-based index of the first occurrence of a specified string within the input string.","If lookup or input string isn't of *string* type, the function forcibly casts the value to *string*.\r\n\r\nFor more information, see [`indexof_regex()`](indexofregexfunction.md).\r\n\r\n## Syntax\r\n\r\n`indexof(`*source*`,`*lookup*`[,`*start_index*`[,`*length*`[,`*occurrence*`]]])`\r\n\r\n## Arguments\r\n\r\n* *source*: Input string.  \r\n* *lookup*: String to look up.\r\n* *start_index*: Search start position. Optional.\r\n* *length*: Number of character positions to examine. A value of -1 means unlimited length. Optional.\r\n* *occurrence*: The number of the occurrence. Default 1. Optional.\r\n\r\n## Returns\r\n\r\nZero-based index position of *lookup*.\r\n\r\nReturns -1 if the string isn't found in the input.\r\n\r\nIf irrelevant (less than 0) *start_index*, *occurrence*, or (less than -1) *length* parameter - returns *null*.",'```\r\nprint\r\n idx1 = indexof("abcdefg","cde")    // lookup found in input string\r\n , idx2 = indexof("abcdefg","cde",1,4) // lookup found in researched range \r\n , idx3 = indexof("abcdefg","cde",1,2) // search starts from index 1, but stops after 2 chars, so full lookup can\'t be found\r\n , idx4 = indexof("abcdefg","cde",3,4) // search starts after occurrence of lookup\r\n , idx5 = indexof("abcdefg","cde",-1)  // invalid input\r\n , idx6 = indexof(1234567,5,1,4)       // two first parameters were forcibly casted to strings "12345" and "5"\r\n , idx7 = indexof("abcdefg","cde",2,-1)  // lookup found in input string\r\n , idx8 = indexof("abcdefgabcdefg", "cde", 1, 10, 2)   // lookup found in input range\r\n , idx9 = indexof("abcdefgabcdefg", "cde", 1, -1, 3)   // the third occurrence of lookup is not in researched range\r\n```\r\n\r\n|idx1|idx2|idx3|idx4|idx5|idx6|idx7|idx8|idx9|\r\n|----|----|----|----|----|----|----|----|----|\r\n|2   |2   |-1  |-1  |    |4   |2   |9   |-1  |',"https://docs.microsoft.com/en-us/azure/kusto/query/indexoffunction","indexoffunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"indexof_regex","Function reports the zero-based index of the first occurrence of a specified string within the input string. Plain string matches don't overlap.","See [`indexof()`](indexoffunction.md).\r\n\r\n## Syntax\r\n\r\n`indexof_regex(`*source*`,`*lookup*`[,`*start_index*`[,`*length*`[,`*occurrence*`]]])`\r\n\r\n## Arguments\r\n\r\n|Arguments     | Description                                     |Required or Optional|\r\n|--------------|-------------------------------------------------|--------------------|\r\n|source        | Input string                                    |Required            |\r\n|lookup        | String to seek                                  |Required            |\r\n|start_index   | Search start position                           |Optional            |\r\n|length        | Number of character positions to examine. -1 defines an unlimited length |Optional            |\r\n|occurrence    | Find the index of the N-th appearance of the pattern. \r\n                 Default is 1, the index of the first occurrence |Optional            |\r\n\r\n## Returns\r\n\r\nZero-based index position of *lookup*.\r\n\r\n* Returns -1 if the string isn't found in the input.\r\n* Returns *null* if:\r\n     * start_index is less than 0.\r\n     * occurrence is less than 0.\r\n     * length parameter is less than -1.",'```\r\nprint\r\n idx1 = indexof_regex("abcabc", "a.c") // lookup found in input string\r\n , idx2 = indexof_regex("abcabcdefg", "a.c", 0, 9, 2)  // lookup found in input string\r\n , idx3 = indexof_regex("abcabc", "a.c", 1, -1, 2)  // there is no second occurrence in the search range\r\n , idx4 = indexof_regex("ababaa", "a.a", 0, -1, 2)  // Plain string matches do not overlap so full lookup can\'t be found\r\n , idx5 = indexof_regex("abcabc", "a|ab", -1)  // invalid input\r\n```\r\n\r\n|idx1|idx2|idx3|idx4|idx5|\r\n|----|----|----|----|----|\r\n|0   |3   |-1  |-1  |    |',"https://docs.microsoft.com/en-us/azure/kusto/query/indexofregexfunction","indexofregexfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"ingestion_time","Returns the approximate time at which the current record was ingested.","This function must be used in the context of a table of ingested data for which the [IngestionTime policy](../management/ingestiontimepolicy.md) was enabled when the data was ingested. Otherwise, this function produces null values.\r\n\r\n> [!NOTE]\r\n> The value returned by this function is only approximate, as the ingestion process may take several minutes to complete and multiple ingestion activities may take place concurrently. To process all records of a table with exactly-once guarantees, use [database cursors](../management/databasecursor.md).\r\n\r\n## Syntax\r\n\r\n`ingestion_time()`\r\n\r\n## Returns\r\n\r\nA `datetime` value specifying the approximate time of ingestion into a table.","```\r\nT\r\n| extend ingestionTime = ingestion_time() | top 10 by ingestionTime\r\n```","https://docs.microsoft.com/en-us/azure/kusto/query/ingestiontimefunction","ingestiontimefunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.OperatorToken,"invoke","Invokes lambda that receives the source of `invoke` as tabular parameter argument.","```\r\nT | invoke foo(param1, param2)\r\n```\r\n\r\n> [!NOTE]\r\n> See [let statements](./letstatement.md) for more details on how to declare lambda expressions that can accept tabular arguments.\r\n\r\n## Syntax\r\n\r\n`T | invoke` *function*`(`[*param1*`,` *param2*]`)`\r\n\r\n## Arguments\r\n\r\n* *T*: The tabular source.\r\n* *function*: The name of the lambda expression or function name to be evaluated.\r\n* *param1*, *param2* ... : additional lambda arguments.\r\n\r\n## Returns\r\n\r\nReturns the result of the evaluated expression.","The following example shows how to use `invoke` operator to call lambda expression:\r\n\r\n```\r\n// clipped_average(): calculates percentiles limits, and then makes another \r\n//                    pass over the data to calculate average with values inside the percentiles\r\nlet clipped_average = (T:(x: long), lowPercentile:double, upPercentile:double)\r\n{\r\n   let high = toscalar(T | summarize percentiles(x, upPercentile));\r\n   let low = toscalar(T | summarize percentiles(x, lowPercentile));\r\n   T \r\n   | where x > low and x < high\r\n   | summarize avg(x) \r\n};\r\nrange x from 1 to 100 step 1\r\n| invoke clipped_average(5, 99)\r\n```\r\n\r\n|avg_x|\r\n|---|\r\n|52|","https://docs.microsoft.com/en-us/azure/kusto/query/invokeoperator","invokeoperator.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"ipv4_compare","Compares two IPv4 strings. The two IPv4 strings are parsed and compared while accounting for the combined IP-prefix mask calculated from argument prefixes, and the optional `PrefixMask` argument.","```\r\nipv4_compare(\"127.0.0.1\", \"127.0.0.1\") == 0\r\nipv4_compare('192.168.1.1', '192.168.1.255') < 0\r\nipv4_compare('192.168.1.1/24', '192.168.1.255/24') == 0\r\nipv4_compare('192.168.1.1', '192.168.1.255', 24) == 0\r\n```\r\n\r\n## Syntax\r\n\r\n`ipv4_compare(`*Expr1*`, `*Expr2*`[ ,`*PrefixMask*`])`\r\n\r\n## Arguments\r\n\r\n* *Expr1*, *Expr2*: A string expression representing an IPv4 address. IPv4 strings can be masked using [IP-prefix notation](#ip-prefix-notation).\r\n* *PrefixMask*: An integer from 0 to 32 representing the number of most-significant bits that are taken into account.\r\n\r\n## IP-prefix notation\r\n\r\nIP addresses can be defined with `IP-prefix notation` using a slash (`/`) character.\r\nThe IP address to the LEFT of the slash (`/`) is the base IP address. The number (1 to 32) to the RIGHT of the slash (`/`) is the number of contiguous 1 bit in the netmask. \r\n\r\nFor example, 192.168.2.0/24 will have an associated net/subnetmask containing 24 contiguous bits or 255.255.255.0 in dotted decimal format.\r\n\r\n## Returns\r\n\r\n* `0`: If the long representation of the first IPv4 string argument is equal to the second IPv4 string argument\r\n* `1`: If the long representation of the first IPv4 string argument is greater than the second IPv4 string argument\r\n* `-1`: If the long representation of the first IPv4 string argument is less than the second IPv4 string argument\r\n* `null`: If conversion for one of the two IPv4 strings wasn't successful.\r\n\r\n## Examples: IPv4 comparison equality cases\r\n\r\n### Compare IPs using the IP-prefix notation specified inside the IPv4 strings\r\n\r\n```\r\ndatatable(ip1_string:string, ip2_string:string)\r\n[\r\n '192.168.1.0',    '192.168.1.0',       // Equal IPs\r\n '192.168.1.1/24', '192.168.1.255',     // 24 bit IP-prefix is used for comparison\r\n '192.168.1.1',    '192.168.1.255/24',  // 24 bit IP-prefix is used for comparison\r\n '192.168.1.1/30', '192.168.1.255/24',  // 24 bit IP-prefix is used for comparison\r\n]\r\n| extend result = ipv4_compare(ip1_string, ip2_string)\r\n```\r\n\r\n|ip1_string|ip2_string|result|\r\n|---|---|---|\r\n|192.168.1.0|192.168.1.0|0|\r\n|192.168.1.1/24|192.168.1.255|0|\r\n|192.168.1.1|192.168.1.255/24|0|\r\n|192.168.1.1/30|192.168.1.255/24|0|\r\n\r\n### Compare IPs using IP-prefix notation specified inside the IPv4 strings and as additional argument of the `ipv4_compare()` function\r\n\r\n```\r\ndatatable(ip1_string:string, ip2_string:string, prefix:long)\r\n[\r\n '192.168.1.1',    '192.168.1.0',   31, // 31 bit IP-prefix is used for comparison\r\n '192.168.1.1/24', '192.168.1.255', 31, // 24 bit IP-prefix is used for comparison\r\n '192.168.1.1',    '192.168.1.255', 24, // 24 bit IP-prefix is used for comparison\r\n]\r\n| extend result = ipv4_compare(ip1_string, ip2_string, prefix)\r\n```\r\n\r\n|ip1_string|ip2_string|prefix|result|\r\n|---|---|---|---|\r\n|192.168.1.1|192.168.1.0|31|0|\r\n|192.168.1.1/24|192.168.1.255|31|0|\r\n|192.168.1.1|192.168.1.255|24|0|","","https://docs.microsoft.com/en-us/azure/kusto/query/ipv4-comparefunction","")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"ipv4_is_match","Matches two IPv4 strings. The two IPv4 strings are parsed and compared while accounting for the combined IP-prefix mask calculated from argument prefixes, and the optional `PrefixMask` argument.","```\r\nipv4_is_match(\"127.0.0.1\", \"127.0.0.1\") == true\r\nipv4_is_match('192.168.1.1', '192.168.1.255') == false\r\nipv4_is_match('192.168.1.1/24', '192.168.1.255/24') == true\r\nipv4_is_match('192.168.1.1', '192.168.1.255', 24) == true\r\n```\r\n\r\n## Syntax\r\n\r\n`ipv4_is_match(`*Expr1*`, `*Expr2*`[ ,`*PrefixMask*`])`\r\n\r\n## Arguments\r\n\r\n* *Expr1*, *Expr2*: A string expression representing an IPv4 address. IPv4 strings can be masked using [IP-prefix notation](#ip-prefix-notation).\r\n* *PrefixMask*: An integer from 0 to 32 representing the number of most-significant bits that are taken into account.\r\n\r\n## IP-prefix notation\r\n\r\nIP addresses can be defined with `IP-prefix notation` using a slash (`/`) character. The IP address to the LEFT of the slash (`/`) is the base IP address. The number (1 to 32) to the RIGHT of the slash (`/`) is the number of contiguous 1 bit in the netmask. \r\n\r\nFor example, 192.168.2.0/24 will have an associated net/subnetmask containing 24 contiguous bits or 255.255.255.0 in dotted decimal format.\r\n\r\n## Returns\r\n\r\n* `true`: If the long representation of the first IPv4 string argument is equal to the second IPv4 string argument.\r\n*  `false`: Otherwise.\r\n* `null`: If conversion for one of the two IPv4 strings wasn't successful.","### IPv4 comparison equality - IP-prefix notation specified inside the IPv4 strings\r\n\r\n```\r\ndatatable(ip1_string:string, ip2_string:string)\r\n[\r\n '192.168.1.0',    '192.168.1.0',       // Equal IPs\r\n '192.168.1.1/24', '192.168.1.255',     // 24 bit IP-prefix is used for comparison\r\n '192.168.1.1',    '192.168.1.255/24',  // 24 bit IP-prefix is used for comparison\r\n '192.168.1.1/30', '192.168.1.255/24',  // 24 bit IP-prefix is used for comparison\r\n]\r\n| extend result = ipv4_is_match(ip1_string, ip2_string)\r\n```\r\n\r\n|ip1_string|ip2_string|result|\r\n|---|---|---|\r\n|192.168.1.0|192.168.1.0|1|\r\n|192.168.1.1/24|192.168.1.255|1|\r\n|192.168.1.1|192.168.1.255/24|1|\r\n|192.168.1.1/30|192.168.1.255/24|1|\r\n\r\n### IPv4 comparison equality - IP-prefix notation specified inside the IPv4 strings and an additional argument of the `ipv4_is_match()` function\r\n\r\n```\r\ndatatable(ip1_string:string, ip2_string:string, prefix:long)\r\n[\r\n '192.168.1.1',    '192.168.1.0',   31, // 31 bit IP-prefix is used for comparison\r\n '192.168.1.1/24', '192.168.1.255', 31, // 24 bit IP-prefix is used for comparison\r\n '192.168.1.1',    '192.168.1.255', 24, // 24 bit IP-prefix is used for comparison\r\n]\r\n| extend result = ipv4_is_match(ip1_string, ip2_string, prefix)\r\n```\r\n\r\n|ip1_string|ip2_string|prefix|result|\r\n|---|---|---|---|\r\n|192.168.1.1|192.168.1.0|31|1|\r\n|192.168.1.1/24|192.168.1.255|31|1|\r\n|192.168.1.1|192.168.1.255|24|1|","https://docs.microsoft.com/en-us/azure/kusto/query/ipv4-is-matchfunction","ipv4-is-matchfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"ipv6_compare","Compares two IPv6 or IPv4 network address strings. The two IPv6 strings are parsed and compared while accounting for the combined IP-prefix mask calculated from argument prefixes, and the optional `PrefixMask` argument.","```\r\nipv6_compare('::ffff:7f00:1', '127.0.0.1') == 0\r\nipv6_compare('fe80::85d:e82c:9446:7994', 'fe80::85d:e82c:9446:7995')  < 0\r\nipv6_compare('192.168.1.1/24', '192.168.1.255/24') == 0\r\nipv6_compare('fe80::85d:e82c:9446:7994/127', 'fe80::85d:e82c:9446:7995/127') == 0\r\nipv6_compare('fe80::85d:e82c:9446:7994', 'fe80::85d:e82c:9446:7995', 127) == 0\r\n```\r\n\r\n> [!Note]\r\n> The function can accept and compare arguments representing both IPv6 and IPv4 network addresses. However, if the caller knows that arguments are in IPv4 format, use [ipv4_is_compare()](./ipv4-comparefunction.md) function. This function will result in better runtime performance.\r\n\r\n## Syntax\r\n\r\n`ipv6_compare(`*Expr1*`, `*Expr2*`[ ,`*PrefixMask*`])`\r\n\r\n## Arguments\r\n\r\n* *Expr1*, *Expr2*: A string expression representing an IPv6 or IPv4 address. IPv6 and IPv4 strings can be masked using IP-prefix notation (see note).\r\n* *PrefixMask*: An integer from 0 to 128 representing the number of most significant bits that are taken into account.\r\n\r\n## IP-prefix notation\r\n\r\nIt's common practice to define IP addresses with `IP-prefix notation` using a slash (`/`) character.\r\nThe IP address to the LEFT of the slash (`/`) is the base IP address, and the number (1 to 127) to the RIGHT of the slash (`/`) is the number of contiguous 1 bits in the netmask. \r\n\r\nFor example, fe80::85d:e82c:9446:7994/120 will have an associated net/subnetmask containing 120 contiguous bits.\r\n\r\n## Returns\r\n\r\n* `0`: If the long representation of the first IPv6 string argument is equal to the second IPv6 string argument.\r\n* `1`: If the long representation of the first IPv6 string argument is greater than the second IPv6 string argument.\r\n* `-1`: If the long representation of the first IPv6 string argument is less than the second IPv6 string argument.\r\n* `null`: If conversion for one of the two IPv6 strings wasn't successful.\r\n\r\n## Examples: IPv6/IPv4 comparison equality cases\r\n\r\n### Compare IPs using the IP-prefix notation specified inside the IPv6/IPv4 strings\r\n\r\n```\r\ndatatable(ip1_string:string, ip2_string:string)\r\n[\r\n // IPv4 are compared as IPv6 addresses\r\n '192.168.1.1',    '192.168.1.1',       // Equal IPs\r\n '192.168.1.1/24', '192.168.1.255',     // 24 bit IP4-prefix is used for comparison\r\n '192.168.1.1',    '192.168.1.255/24',  // 24 bit IP4-prefix is used for comparison\r\n '192.168.1.1/30', '192.168.1.255/24',  // 24 bit IP4-prefix is used for comparison\r\n  // IPv6 cases\r\n 'fe80::85d:e82c:9446:7994', 'fe80::85d:e82c:9446:7994',         // Equal IPs\r\n 'fe80::85d:e82c:9446:7994/120', 'fe80::85d:e82c:9446:7998',     // 120 bit IP6-prefix is used for comparison\r\n 'fe80::85d:e82c:9446:7994', 'fe80::85d:e82c:9446:7998/120',     // 120 bit IP6-prefix is used for comparison\r\n 'fe80::85d:e82c:9446:7994/120', 'fe80::85d:e82c:9446:7998/120', // 120 bit IP6-prefix is used for comparison\r\n // Mixed case of IPv4 and IPv6\r\n '192.168.1.1',      '::ffff:c0a8:0101', // Equal IPs\r\n '192.168.1.1/24',   '::ffff:c0a8:01ff', // 24 bit IP-prefix is used for comparison\r\n '::ffff:c0a8:0101', '192.168.1.255/24', // 24 bit IP-prefix is used for comparison\r\n '::192.168.1.1/30', '192.168.1.255/24', // 24 bit IP-prefix is used for comparison\r\n]\r\n| extend result = ipv6_compare(ip1_string, ip2_string)\r\n```\r\n\r\n|ip1_string|ip2_string|result|\r\n|---|---|---|\r\n|192.168.1.1|192.168.1.1|0|\r\n|192.168.1.1/24|192.168.1.255|0|\r\n|192.168.1.1|192.168.1.255/24|0|\r\n|192.168.1.1/30|192.168.1.255/24|0|\r\n|fe80::85d:e82c:9446:7994|fe80::85d:e82c:9446:7994|0|\r\n|fe80::85d:e82c:9446:7994/120|fe80::85d:e82c:9446:7998|0|\r\n|fe80::85d:e82c:9446:7994|fe80::85d:e82c:9446:7998/120|0|\r\n|fe80::85d:e82c:9446:7994/120|fe80::85d:e82c:9446:7998/120|0|\r\n|192.168.1.1|::ffff:c0a8:0101|0|\r\n|192.168.1.1/24|::ffff:c0a8:01ff|0|\r\n|::ffff:c0a8:0101|192.168.1.255/24|0|\r\n|::192.168.1.1/30|192.168.1.255/24|0|\r\n\r\n### Compare IPs using IP-prefix notation specified inside the IPv6/IPv4 strings and as additional argument of the `ipv6_compare()` function\r\n\r\n```\r\ndatatable(ip1_string:string, ip2_string:string, prefix:long)\r\n[\r\n // IPv4 are compared as IPv6 addresses \r\n '192.168.1.1',    '192.168.1.0',   31, // 31 bit IP4-prefix is used for comparison\r\n '192.168.1.1/24', '192.168.1.255', 31, // 24 bit IP4-prefix is used for comparison\r\n '192.168.1.1',    '192.168.1.255', 24, // 24 bit IP4-prefix is used for comparison\r\n   // IPv6 cases\r\n 'fe80::85d:e82c:9446:7994', 'fe80::85d:e82c:9446:7995',     127, // 127 bit IP6-prefix is used for comparison\r\n 'fe80::85d:e82c:9446:7994/127', 'fe80::85d:e82c:9446:7998', 120, // 120 bit IP6-prefix is used for comparison\r\n 'fe80::85d:e82c:9446:7994/120', 'fe80::85d:e82c:9446:7998', 127, // 120 bit IP6-prefix is used for comparison\r\n // Mixed case of IPv4 and IPv6\r\n '192.168.1.1/24',   '::ffff:c0a8:01ff', 127, // 127 bit IP6-prefix is used for comparison\r\n '::ffff:c0a8:0101', '192.168.1.255',    120, // 120 bit IP6-prefix is used for comparison\r\n '::192.168.1.1/30', '192.168.1.255/24', 127, // 120 bit IP6-prefix is used for comparison\r\n]\r\n| extend result = ipv6_compare(ip1_string, ip2_string, prefix)\r\n```\r\n\r\n|ip1_string|ip2_string|prefix|result|\r\n|---|---|---|---|\r\n|192.168.1.1|192.168.1.0|31|0|\r\n|192.168.1.1/24|192.168.1.255|31|0|\r\n|192.168.1.1|192.168.1.255|24|0|\r\n|fe80::85d:e82c:9446:7994|fe80::85d:e82c:9446:7995|127|0|\r\n|fe80::85d:e82c:9446:7994/127|fe80::85d:e82c:9446:7998|120|0|\r\n|fe80::85d:e82c:9446:7994/120|fe80::85d:e82c:9446:7998|127|0|\r\n|192.168.1.1/24|::ffff:c0a8:01ff|127|0|\r\n|::ffff:c0a8:0101|192.168.1.255|120|0|\r\n|::192.168.1.1/30|192.168.1.255/24|127|0|","","https://docs.microsoft.com/en-us/azure/kusto/query/ipv6-comparefunction","")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"ipv6_is_match","Matches two IPv6 or IPv4 network address strings. The two IPv6/IPv4 strings are parsed and compared while accounting for the combined IP-prefix mask calculated from argument prefixes, and the optional `PrefixMask` argument.","```\r\nipv6_is_match('::ffff:7f00:1', '127.0.0.1') == true\r\nipv6_is_match('fe80::85d:e82c:9446:7994', 'fe80::85d:e82c:9446:7995') == false\r\nipv6_is_match('192.168.1.1/24', '192.168.1.255/24') == true\r\nipv6_is_match('fe80::85d:e82c:9446:7994/127', 'fe80::85d:e82c:9446:7995/127') == true\r\nipv6_is_match('fe80::85d:e82c:9446:7994', 'fe80::85d:e82c:9446:7995', 127) == true\r\n```\r\n\r\n> [!NOTE]\r\n> The function can accept and compare arguments representing both IPv6 and IPv4 network addresses. If the caller knows that arguments are in IPv4 format, use the [ipv4_is_match()](./ipv4-is-matchfunction.md) function. This function will result in better runtime performance.\r\n\r\n## Syntax\r\n\r\n`ipv6_is_match(`*Expr1*`, `*Expr2*`[ ,`*PrefixMask*`])`\r\n\r\n## Arguments\r\n\r\n* *Expr1*, *Expr2*: A string expression representing an IPv6 or IPv4 address. IPv6 and IPv4 strings can be masked using [IP-prefix notation](#ip-prefix-notation).\r\n* *PrefixMask*: An integer from 0 to 128 representing the number of most-significant bits that are taken into account.\r\n\r\n## IP-prefix notation\r\n\r\nIP addresses can be defined with `IP-prefix notation` using a slash (`/`) character.\r\nThe IP address to the LEFT of the slash (`/`) is the base IP address. The number (1 to 127) to the RIGHT of the slash (`/`) is the number of contiguous 1 bit in the netmask. \r\n\r\nFor example, fe80::85d:e82c:9446:7994/120 will have an associated net/subnetmask containing 120 contiguous bits.\r\n\r\n## Returns\r\n\r\n* `true`: If the long representation of the first IPv6/IPv4 string argument is equal to the second IPv6/IPv4 string argument.\r\n* `false`: Otherwise.\r\n* `null`: If conversion for one of the two IPv6/IPv4 strings wasn't successful.","### IPv6/IPv4 comparison equality case - IP-prefix notation specified inside the IPv6/IPv4 strings\r\n\r\n```\r\ndatatable(ip1_string:string, ip2_string:string)\r\n[\r\n // IPv4 are compared as IPv6 addresses\r\n '192.168.1.1',    '192.168.1.1',       // Equal IPs\r\n '192.168.1.1/24', '192.168.1.255',     // 24 bit IP4-prefix is used for comparison\r\n '192.168.1.1',    '192.168.1.255/24',  // 24 bit IP4-prefix is used for comparison\r\n '192.168.1.1/30', '192.168.1.255/24',  // 24 bit IP4-prefix is used for comparison\r\n  // IPv6 cases\r\n 'fe80::85d:e82c:9446:7994', 'fe80::85d:e82c:9446:7994',         // Equal IPs\r\n 'fe80::85d:e82c:9446:7994/120', 'fe80::85d:e82c:9446:7998',     // 120 bit IP6-prefix is used for comparison\r\n 'fe80::85d:e82c:9446:7994', 'fe80::85d:e82c:9446:7998/120',     // 120 bit IP6-prefix is used for comparison\r\n 'fe80::85d:e82c:9446:7994/120', 'fe80::85d:e82c:9446:7998/120', // 120 bit IP6-prefix is used for comparison\r\n // Mixed case of IPv4 and IPv6\r\n '192.168.1.1',      '::ffff:c0a8:0101', // Equal IPs\r\n '192.168.1.1/24',   '::ffff:c0a8:01ff', // 24 bit IP-prefix is used for comparison\r\n '::ffff:c0a8:0101', '192.168.1.255/24', // 24 bit IP-prefix is used for comparison\r\n '::192.168.1.1/30', '192.168.1.255/24', // 24 bit IP-prefix is used for comparison\r\n]\r\n| extend result = ipv6_is_match(ip1_string, ip2_string)\r\n```\r\n\r\n|ip1_string|ip2_string|result|\r\n|---|---|---|\r\n|192.168.1.1|192.168.1.1|1|\r\n|192.168.1.1/24|192.168.1.255|1|\r\n|192.168.1.1|192.168.1.255/24|1|\r\n|192.168.1.1/30|192.168.1.255/24|1|\r\n|fe80::85d:e82c:9446:7994|fe80::85d:e82c:9446:7994|1|\r\n|fe80::85d:e82c:9446:7994/120|fe80::85d:e82c:9446:7998|1|\r\n|fe80::85d:e82c:9446:7994|fe80::85d:e82c:9446:7998/120|1|\r\n|fe80::85d:e82c:9446:7994/120|fe80::85d:e82c:9446:7998/120|1|\r\n|192.168.1.1|::ffff:c0a8:0101|1|\r\n|192.168.1.1/24|::ffff:c0a8:01ff|1|\r\n|::ffff:c0a8:0101|192.168.1.255/24|1|\r\n|::192.168.1.1/30|192.168.1.255/24|1|\r\n\r\n### IPv6/IPv4 comparison equality case- IP-prefix notation specified inside the IPv6/IPv4 strings and as additional argument of the `ipv6_is_match()` function\r\n\r\n```\r\ndatatable(ip1_string:string, ip2_string:string, prefix:long)\r\n[\r\n // IPv4 are compared as IPv6 addresses \r\n '192.168.1.1',    '192.168.1.0',   31, // 31 bit IP4-prefix is used for comparison\r\n '192.168.1.1/24', '192.168.1.255', 31, // 24 bit IP4-prefix is used for comparison\r\n '192.168.1.1',    '192.168.1.255', 24, // 24 bit IP4-prefix is used for comparison\r\n   // IPv6 cases\r\n 'fe80::85d:e82c:9446:7994', 'fe80::85d:e82c:9446:7995',     127, // 127 bit IP6-prefix is used for comparison\r\n 'fe80::85d:e82c:9446:7994/127', 'fe80::85d:e82c:9446:7998', 120, // 120 bit IP6-prefix is used for comparison\r\n 'fe80::85d:e82c:9446:7994/120', 'fe80::85d:e82c:9446:7998', 127, // 120 bit IP6-prefix is used for comparison\r\n // Mixed case of IPv4 and IPv6\r\n '192.168.1.1/24',   '::ffff:c0a8:01ff', 127, // 127 bit IP6-prefix is used for comparison\r\n '::ffff:c0a8:0101', '192.168.1.255',    120, // 120 bit IP6-prefix is used for comparison\r\n '::192.168.1.1/30', '192.168.1.255/24', 127, // 120 bit IP6-prefix is used for comparison\r\n]\r\n| extend result = ipv6_is_match(ip1_string, ip2_string, prefix)\r\n```\r\n\r\n|ip1_string|ip2_string|prefix|result|\r\n|---|---|---|---|\r\n|192.168.1.1|192.168.1.0|31|1|\r\n|192.168.1.1/24|192.168.1.255|31|1|\r\n|192.168.1.1|192.168.1.255|24|1|\r\n|fe80::85d:e82c:9446:7994|fe80::85d:e82c:9446:7995|127|1|\r\n|fe80::85d:e82c:9446:7994/127|fe80::85d:e82c:9446:7998|120|1|\r\n|fe80::85d:e82c:9446:7994/120|fe80::85d:e82c:9446:7998|127|1|\r\n|192.168.1.1/24|::ffff:c0a8:01ff|127|1|\r\n|::ffff:c0a8:0101|192.168.1.255|120|1|\r\n|::192.168.1.1/30|192.168.1.255/24|127|1|","https://docs.microsoft.com/en-us/azure/kusto/query/ipv6-is-matchfunction","ipv6-is-matchfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"isempty","Returns `true` if the argument is an empty string or is null.",'```\r\nisempty("") == true\r\n```\r\n\r\n## Syntax\r\n\r\n`isempty(`[*value*]`)`\r\n\r\n## Returns\r\n\r\nIndicates whether the argument is an empty string or isnull.\r\n\r\n|x|isempty(x)\r\n|---|---\r\n| "" | true\r\n|"x" | false\r\n|parsejson("")|true\r\n|parsejson("[]")|false\r\n|parsejson("{}")|false',"```\r\nT\r\n| where isempty(fieldName)\r\n| count\r\n```","https://docs.microsoft.com/en-us/azure/kusto/query/isemptyfunction","isemptyfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"isfinite","Returns whether input is a finite value (is neither infinite nor NaN).","## Syntax\r\n\r\n`isfinite(`*x*`)`\r\n\r\n## Arguments\r\n\r\n* *x*: A real number.\r\n\r\n## Returns\r\n\r\nA non-zero value (true) if x is finite; and zero (false) otherwise.\r\n\r\n## See also\r\n\r\n* For checking if value is null, see [isnull()](isnullfunction.md).\r\n* For checking if value is infinite, see [isinf()](isinffunction.md).\r\n* For checking if value is NaN (Not-a-Number), see [isnan()](isnanfunction.md).","```\r\nrange x from -1 to 1 step 1\r\n| extend y = 0.0\r\n| extend div = 1.0*x/y\r\n| extend isfinite=isfinite(div)\r\n```\r\n\r\n|x|y|div|isfinite|\r\n|---|---|---|---|\r\n|-1|0|-∞|0|\r\n|0|0|NaN|0|\r\n|1|0|∞|0|","https://docs.microsoft.com/en-us/azure/kusto/query/isfinitefunction","isfinitefunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"isinf","Returns whether input is an infinite (positive or negative) value.","## Syntax\r\n\r\n`isinf(`*x*`)`\r\n\r\n## Arguments\r\n\r\n* *x*: A real number.\r\n\r\n## Returns\r\n\r\nA non-zero value (true) if x is a positive or negative infinite; and zero (false) otherwise.\r\n\r\n## See also\r\n\r\n* For checking if value is null, see [isnull()](isnullfunction.md).\r\n* For checking if value is finite, see [isfinite()](isfinitefunction.md).\r\n* For checking if value is NaN (Not-a-Number), see [isnan()](isnanfunction.md).","```\r\nrange x from -1 to 1 step 1\r\n| extend y = 0.0\r\n| extend div = 1.0*x/y\r\n| extend isinf=isinf(div)\r\n```\r\n\r\n|x|y|div|isinf|\r\n|---|---|---|---|\r\n|-1|0|-∞|1|\r\n|0|0|NaN|0|\r\n|1|0|∞|1|","https://docs.microsoft.com/en-us/azure/kusto/query/isinffunction","isinffunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"isnan","Returns whether input is Not-a-Number (NaN) value.","## Syntax\r\n\r\n`isnan(`*x*`)`\r\n\r\n## Arguments\r\n\r\n* *x*: A real number.\r\n\r\n## Returns\r\n\r\nA non-zero value (true) if x is NaN; and zero (false) otherwise.\r\n\r\n## See also\r\n\r\n* For checking if value is null, see [isnull()](isnullfunction.md).\r\n* For checking if value is finite, see [isfinite()](isfinitefunction.md).\r\n* For checking if value is infinite, see [isinf()](isinffunction.md).","```\r\nrange x from -1 to 1 step 1\r\n| extend y = (-1*x) \r\n| extend div = 1.0*x/y\r\n| extend isnan=isnan(div)\r\n```\r\n\r\n|x|y|div|isnan|\r\n|---|---|---|---|\r\n|-1|1|-1|0|\r\n|0|0|NaN|1|\r\n|1|-1|-1|0|","https://docs.microsoft.com/en-us/azure/kusto/query/isnanfunction","isnanfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"isnotempty","Returns `true` if the argument isn't an empty string, and it isn't null.",'```\r\nisnotempty("") == false\r\n```\r\n\r\n## Syntax\r\n\r\n`isnotempty(`[*value*]`)`\r\n\r\n`notempty(`[*value*]`)` -- alias of `isnotempty`',"```\r\nT\r\n| where isnotempty(fieldName)\r\n| count\r\n```","https://docs.microsoft.com/en-us/azure/kusto/query/isnotemptyfunction","isnotemptyfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"isnotnull","Returns `true` if the argument is not null.","## Syntax\r\n\r\n`isnotnull(`[*value*]`)`\r\n\r\n`notnull(`[*value*]`)` - alias for `isnotnull`","```\r\nT | where isnotnull(PossiblyNull) | count\r\n```\r\n\r\nNotice that there are other ways of achieving this effect:\r\n\r\n```\r\nT | summarize count(PossiblyNull)\r\n```","https://docs.microsoft.com/en-us/azure/kusto/query/isnotnullfunction","isnotnullfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"isnull","Evaluates its sole argument and returns a `bool` value indicating if the argument evaluates to a null value.",'```\r\nisnull(parse_json("")) == true\r\n```\r\n\r\n## Syntax\r\n\r\n`isnull(`*Expr*`)`\r\n\r\n## Returns\r\n\r\nTrue or false, depending on whether or not the value is null.\r\n\r\n**Notes**\r\n\r\n* `string` values cannot be null. Use [isempty](./isemptyfunction.md)\r\n  to determine if a value of type `string` is empty or not.\r\n\r\n|x                |`isnull(x)`|\r\n|-----------------|-----------|\r\n|`""`             |`false`    |\r\n|`"x"`            |`false`    |\r\n|`parse_json("")`  |`true`     |\r\n|`parse_json("[]")`|`false`    |\r\n|`parse_json("{}")`|`false`    |',"```\r\nT | where isnull(PossiblyNull) | count\r\n```","https://docs.microsoft.com/en-us/azure/kusto/query/isnullfunction","isnullfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.OperatorToken,"join","Merge the rows of two tables to form a new table by matching values of the specified columns from each table.","```\r\nTable1 | join (Table2) on CommonColumn, $left.Col1 == $right.Col2\r\n```\r\n\r\n## Syntax\r\n\r\n*LeftTable* `|` `join` [*JoinParameters*] `(` *RightTable* `)` `on` *Attributes*\r\n\r\n## Arguments\r\n\r\n* *LeftTable*: The **left** table or tabular expression, sometimes called **outer** table, whose rows are to be merged. Denoted as `$left`.\r\n* *RightTable*: The **right** table or tabular expression, sometimes called **inner** table, whose rows are to be merged. Denoted as `$right`.\r\n* *Attributes*: One or more comma-separated **rules** that describe how rows from\r\n  *LeftTable* are matched to rows from *RightTable*. Multiple rules are evaluated using the `and` logical operator.\r\n  A **rule** can be one of:\r\n  |Rule kind        |Syntax          |Predicate    |\r\n  |-----------------|--------------|-------------------------|\r\n  |Equality by name |*ColumnName*    |`where` *LeftTable*.*ColumnName* `==` *RightTable*.*ColumnName*|\r\n  |Equality by value|`$left.`*LeftColumn* `==` `$right.`*RightColumn*|`where` `$left.`*LeftColumn* `==` `$right.`*RightColumn*       |\r\n    > [!NOTE]\r\n    > For 'equality by value', the column names *must* be qualified with the applicable owner table denoted by `$left` and `$right` notations.\r\n* *JoinParameters*: Zero or more space-separated parameters in the form of\r\n  *Name* `=` *Value* that control the behavior of the row-match operation and execution plan. The following parameters are supported:\r\n\r\n    |Parameters name           |Values                                        |Description                                  |\r\n    |---------------|----------------------------------------------|---------------------------------------------|\r\n    |`kind`         |Join flavors|See [Join Flavors](#join-flavors)|                                             |\r\n    |`hint.remote`  |`auto`, `left`, `local`, `right`              |See [Cross-Cluster Join](joincrosscluster.md)|\r\n    |`hint.strategy`|Execution hints                               |See [Join hints](#join-hints)                |\r\n\r\n\r\n> [!WARNING]\r\n> If `kind` isn't specified, the default join flavor is `innerunique`. This is different than some other analytics products that have `inner` as the default flavor.  See [join-flavors](#join-flavors) to understand the differences and make sure  the query yields the intended results.\r\n\r\n## Returns\r\n\r\n**The output schema depends on the join flavor:**\r\n\r\n| Join flavor | Output schema |\r\n|---|---|\r\n|`kind=leftanti`, `kind=leftsemi`| The result table contains columns from the left side only.|\r\n| `kind=rightanti`, `kind=rightsemi` | The result table contains columns from the right side only.|\r\n|  `kind=innerunique`, `kind=inner`, `kind=leftouter`, `kind=rightouter`, `kind=fullouter` |  A column for every column in each of the two tables, including the matching keys. The columns of the right side will be automatically renamed if there are name clashes. |\r\n\r\n**Output records depend on the join flavor:**\r\n\r\n> [!NOTE]\r\n   > If there are several rows with the same values for those fields, you'll get rows for all the combinations.\r\n   > A match is a row selected from one table that has the same value for all the `on` fields as a row in the other table.\r\n\r\n| Join flavor | Output records |\r\n|---|---|\r\n|`kind=leftanti`, `kind=leftantisemi`| Returns all the records from the left side that don't have matches from the right|\r\n| `kind=rightanti`, `kind=rightantisemi`| Returns all the records from the right side that don't have matches from the left.|\r\n| `kind` unspecified, `kind=innerunique`| Only one row from the left side is matched for each value of the `on` key. The output contains a row for each match of this row with rows from the right.|\r\n| `kind=leftsemi`| Returns all the records from the left side that have matches from the right. |\r\n| `kind=rightsemi`| Returns all the records from the right side that have matches from the left. |\r\n|`kind=inner`| Contains a row in the output for every combination of matching rows from left and right. |\r\n| `kind=leftouter` (or `kind=rightouter` or `kind=fullouter`)| Contains a row for every row on the left and right, even if it has no match. The unmatched output cells contain nulls. |\r\n\r\n> [!TIP]\r\n> For best performance, if one table is always smaller than the other, use it as the left (piped) side of the join.","Get extended activities from a `login` that some entries mark as the start and end of an activity.\r\n\r\n```\r\nlet Events = MyLogTable | where type==\"Event\" ;\r\nEvents\r\n| where Name == \"Start\"\r\n| project Name, City, ActivityId, StartTime=timestamp\r\n| join (Events\r\n    | where Name == \"Stop\"\r\n        | project StopTime=timestamp, ActivityId)\r\n    on ActivityId\r\n| project City, ActivityId, StartTime, StopTime, Duration = StopTime - StartTime\r\n```\r\n\r\n```\r\nlet Events = MyLogTable | where type==\"Event\" ;\r\nEvents\r\n| where Name == \"Start\"\r\n| project Name, City, ActivityIdLeft = ActivityId, StartTime=timestamp\r\n| join (Events\r\n        | where Name == \"Stop\"\r\n        | project StopTime=timestamp, ActivityIdRight = ActivityId)\r\n    on $left.ActivityIdLeft == $right.ActivityIdRight\r\n| project City, ActivityId, StartTime, StopTime, Duration = StopTime - StartTime\r\n```\r\n\r\n## Join flavors\r\n\r\nThe exact flavor of the join operator is specified with the *kind* keyword. The following flavors of the join operator are supported:\r\n\r\n|Join kind/flavor|Description|\r\n|--|--|\r\n|[`innerunique`](#default-join-flavor) (or empty as default)|Inner join with left side deduplication|\r\n|[`inner`](#inner-join-flavor)|Standard inner join|\r\n|[`leftouter`](#left-outer-join-flavor)|Left outer join|\r\n|[`rightouter`](#right-outer-join-flavor)|Right outer join|\r\n|[`fullouter`](#full-outer-join-flavor)|Full outer join|\r\n|[`leftanti`](#left-anti-join-flavor), [`anti`](#left-anti-join-flavor), or [`leftantisemi`](#left-anti-join-flavor)|Left anti join|\r\n|[`rightanti`](#right-anti-join-flavor) or [`rightantisemi`](#right-anti-join-flavor)|Right anti join|\r\n|[`leftsemi`](#left-semi-join-flavor)|Left semi join|\r\n|[`rightsemi`](#right-semi-join-flavor)|Right semi join|\r\n\r\n### Default join flavor\r\n\r\nThe default join flavor is an inner join with left side deduplication. Default join implementation is useful in typical log/trace analysis scenarios where you want to correlate two events, each matching some filtering criterion, under the same correlation ID. You want to get back all appearances of the phenomenon, and ignore multiple appearances of the contributing trace records.\r\n\r\n``` \r\nX | join Y on Key\r\n \r\nX | join kind=innerunique Y on Key\r\n```\r\n\r\nThe following two sample tables are used to explain the operation of the join.\r\n\r\n**Table X**\r\n\r\n|Key |Value1\r\n|---|---\r\n|a |1\r\n|b |2\r\n|b |3\r\n|c |4\r\n\r\n**Table Y**\r\n\r\n|Key |Value2\r\n|---|---\r\n|b |10\r\n|c |20\r\n|c |30\r\n|d |40\r\n\r\nThe default join does an inner join after deduplicating the left side on the join key (deduplication keeps the first record).\r\n\r\nGiven this statement: `X | join Y on Key`\r\n\r\nthe effective left side of the join, table X after deduplication, would be:\r\n\r\n|Key |Value1\r\n|---|---\r\n|a |1\r\n|b |2\r\n|c |4\r\n\r\nand the result of the join would be:\r\n\r\n```\r\nlet X = datatable(Key:string, Value1:long)\r\n[\r\n    'a',1,\r\n    'b',2,\r\n    'b',3,\r\n    'c',4\r\n];\r\nlet Y = datatable(Key:string, Value2:long)\r\n[\r\n    'b',10,\r\n    'c',20,\r\n    'c',30,\r\n    'd',40\r\n];\r\nX | join Y on Key\r\n```\r\n\r\n|Key|Value1|Key1|Value2|\r\n|---|---|---|---|\r\n|b|2|b|10|\r\n|c|4|c|20|\r\n|c|4|c|30|\r\n\r\n> [!NOTE]\r\n> The keys 'a' and 'd' don't appear in the output, since there were no matching keys on both left and right sides.\r\n\r\n### Inner-join flavor\r\n\r\nThe inner-join function is like the standard inner-join from the SQL world. An output record is produced whenever a record on the left side has the same join key as the record on the right side.\r\n\r\n```\r\nlet X = datatable(Key:string, Value1:long)\r\n[\r\n    'a',1,\r\n    'b',2,\r\n    'b',3,\r\n    'c',4\r\n];\r\nlet Y = datatable(Key:string, Value2:long)\r\n[\r\n    'b',10,\r\n    'c',20,\r\n    'c',30,\r\n    'd',40\r\n];\r\nX | join kind=inner Y on Key\r\n```\r\n\r\n|Key|Value1|Key1|Value2|\r\n|---|---|---|---|\r\n|b|3|b|10|\r\n|b|2|b|10|\r\n|c|4|c|20|\r\n|c|4|c|30|\r\n\r\n> [!NOTE]\r\n> * (b,10) from the right side, was joined twice: with both (b,2) and (b,3) on the left.\r\n> * (c,4) on the left side, was joined twice: with both (c,20) and (c,30) on the right.\r\n\r\n### Innerunique-join flavor\r\n\r\nUse **innerunique-join flavor** to deduplicate keys from the left side. The result will be a row in the output from every combination of deduplicated left keys and right keys.\r\n\r\n> [!NOTE]\r\n> **innerunique flavor** may yield two possible outputs and both are correct.\r\n    In the first output, the join operator randomly selected the first key that appears in t1, with the value \"val1.1\" and matched it with t2 keys.\r\n    In the second output, the join operator randomly selected the second key that appears in t1, with the value \"val1.2\" and matched it with t2 keys.\r\n\r\n```\r\nlet t1 = datatable(key:long, value:string)  \r\n[\r\n1, \"val1.1\",  \r\n1, \"val1.2\"  \r\n];\r\nlet t2 = datatable(key:long, value:string)  \r\n[  \r\n1, \"val1.3\",\r\n1, \"val1.4\"  \r\n];\r\nt1\r\n| join kind = innerunique\r\n    t2\r\non key\r\n```\r\n\r\n|key|value|key1|value1|\r\n|---|---|---|---|\r\n|1|val1.1|1|val1.3|\r\n|1|val1.1|1|val1.4|\r\n\r\n```\r\nlet t1 = datatable(key:long, value:string)  \r\n[\r\n1, \"val1.1\",  \r\n1, \"val1.2\"  \r\n];\r\nlet t2 = datatable(key:long, value:string)  \r\n[  \r\n1, \"val1.3\", \r\n1, \"val1.4\"  \r\n];\r\nt1\r\n| join kind = innerunique\r\n    t2\r\non key\r\n```\r\n\r\n|key|value|key1|value1|\r\n|---|---|---|---|\r\n|1|val1.2|1|val1.3|\r\n|1|val1.2|1|val1.4|\r\n\r\n* Kusto is optimized to push filters that come after the `join`, towards the appropriate join side, left or right, when possible.\r\n\r\n* Sometimes, the flavor used is **innerunique** and the filter is propagated to the left side of the join. The flavor will be automatically propagated and the keys that apply to that filter will always appear in the output.\r\n    \r\n* Use the example above and add a filter `where value == \"val1.2\" `. It will always give the second result and will never give the first result for the datasets:\r\n\r\n\r\n\r\n```\r\nlet t1 = datatable(key:long, value:string)  \r\n[\r\n1, \"val1.1\",  \r\n1, \"val1.2\"  \r\n];\r\nlet t2 = datatable(key:long, value:string)  \r\n[  \r\n1, \"val1.3\", \r\n1, \"val1.4\"  \r\n];\r\nt1\r\n| join kind = innerunique\r\n    t2\r\non key\r\n| where value == \"val1.2\"\r\n```\r\n\r\n|key|value|key1|value1|\r\n|---|---|---|---|\r\n|1|val1.2|1|val1.3|\r\n|1|val1.2|1|val1.4|\r\n\r\n### Left outer-join flavor\r\n\r\nThe result of a left outer-join for tables X and Y always contains all records of the left table (X), even if the join condition doesn't find any matching record in the right table (Y).\r\n\r\n```\r\nlet X = datatable(Key:string, Value1:long)\r\n[\r\n    'a',1,\r\n    'b',2,\r\n    'b',3,\r\n    'c',4\r\n];\r\nlet Y = datatable(Key:string, Value2:long)\r\n[\r\n    'b',10,\r\n    'c',20,\r\n    'c',30,\r\n    'd',40\r\n];\r\nX | join kind=leftouter Y on Key\r\n```\r\n\r\n|Key|Value1|Key1|Value2|\r\n|---|---|---|---|\r\n|b|3|b|10|\r\n|b|2|b|10|\r\n|c|4|c|20|\r\n|c|4|c|30|\r\n|a|1|||\r\n\r\n### Right outer-join flavor\r\n\r\nThe right outer-join flavor resembles the left outer-join, but the treatment of the tables is reversed.\r\n\r\n```\r\nlet X = datatable(Key:string, Value1:long)\r\n[\r\n    'a',1,\r\n    'b',2,\r\n    'b',3,\r\n    'c',4\r\n];\r\nlet Y = datatable(Key:string, Value2:long)\r\n[\r\n    'b',10,\r\n    'c',20,\r\n    'c',30,\r\n    'd',40\r\n];\r\nX | join kind=rightouter Y on Key\r\n```\r\n\r\n|Key|Value1|Key1|Value2|\r\n|---|---|---|---|\r\n|b|3|b|10|\r\n|b|2|b|10|\r\n|c|4|c|20|\r\n|c|4|c|30|\r\n|||d|40|\r\n\r\n### Full outer-join flavor\r\n\r\nA full outer-join combines the effect of applying both left and right outer-joins. Whenever records in the joined tables don't match, the result set will have `null` values for every column of the table that lacks a matching row. For those records that do match, a single row will be produced in the result set, containing fields populated from both tables.\r\n\r\n```\r\nlet X = datatable(Key:string, Value1:long)\r\n[\r\n    'a',1,\r\n    'b',2,\r\n    'b',3,\r\n    'c',4\r\n];\r\nlet Y = datatable(Key:string, Value2:long)\r\n[\r\n    'b',10,\r\n    'c',20,\r\n    'c',30,\r\n    'd',40\r\n];\r\nX | join kind=fullouter Y on Key\r\n```\r\n\r\n|Key|Value1|Key1|Value2|\r\n|---|---|---|---|\r\n|b|3|b|10|\r\n|b|2|b|10|\r\n|c|4|c|20|\r\n|c|4|c|30|\r\n|||d|40|\r\n|a|1|||\r\n\r\n### Left anti-join flavor\r\n\r\nLeft anti-join returns all records from the left side that don't match any record from the right side.\r\n\r\n```\r\nlet X = datatable(Key:string, Value1:long)\r\n[\r\n    'a',1,\r\n    'b',2,\r\n    'b',3,\r\n    'c',4\r\n];\r\nlet Y = datatable(Key:string, Value2:long)\r\n[\r\n    'b',10,\r\n    'c',20,\r\n    'c',30,\r\n    'd',40\r\n];\r\nX | join kind=leftanti Y on Key\r\n```\r\n\r\n|Key|Value1|\r\n|---|---|\r\n|a|1|\r\n\r\n> [!NOTE]\r\n> Anti-join models the \"NOT IN\" query.\r\n\r\n### Right anti-join flavor\r\n\r\nRight anti-join returns all records from the right side that don't match any record from the left side.\r\n\r\n```\r\nlet X = datatable(Key:string, Value1:long)\r\n[\r\n    'a',1,\r\n    'b',2,\r\n    'b',3,\r\n    'c',4\r\n];\r\nlet Y = datatable(Key:string, Value2:long)\r\n[\r\n    'b',10,\r\n    'c',20,\r\n    'c',30,\r\n    'd',40\r\n];\r\nX | join kind=rightanti Y on Key\r\n```\r\n\r\n|Key|Value2|\r\n|---|---|\r\n|d|40|\r\n\r\n> [!NOTE]\r\n> Anti-join models the \"NOT IN\" query.\r\n\r\n### Left semi-join flavor\r\n\r\nLeft semi-join returns all records from the left side that match a record from the right side. Only columns from the left side are returned.\r\n\r\n```\r\nlet X = datatable(Key:string, Value1:long)\r\n[\r\n    'a',1,\r\n    'b',2,\r\n    'b',3,\r\n    'c',4\r\n];\r\nlet Y = datatable(Key:string, Value2:long)\r\n[\r\n    'b',10,\r\n    'c',20,\r\n    'c',30,\r\n    'd',40\r\n];\r\nX | join kind=leftsemi Y on Key\r\n```\r\n\r\n|Key|Value1|\r\n|---|---|\r\n|b|3|\r\n|b|2|\r\n|c|4|\r\n\r\n### Right semi-join flavor\r\n\r\nRight semi-join returns all records from the right side that match a record from the left side. Only columns from the right side are returned.\r\n\r\n```\r\nlet X = datatable(Key:string, Value1:long)\r\n[\r\n    'a',1,\r\n    'b',2,\r\n    'b',3,\r\n    'c',4\r\n];\r\nlet Y = datatable(Key:string, Value2:long)\r\n[\r\n    'b',10,\r\n    'c',20,\r\n    'c',30,\r\n    'd',40\r\n];\r\nX | join kind=rightsemi Y on Key\r\n```\r\n\r\n|Key|Value2|\r\n|---|---|\r\n|b|10|\r\n|c|20|\r\n|c|30|\r\n\r\n### Cross-join\r\n\r\nKusto doesn't natively provide a cross-join flavor. You can't mark the operator with the `kind=cross`.\r\nTo simulate, use a dummy key.\r\n\r\n`X | extend dummy=1 | join kind=inner (Y | extend dummy=1) on dummy`\r\n\r\n## Join hints\r\n\r\nThe `join` operator supports a number of hints that control the way a query runs.\r\nThese hints don't change the semantic of `join`, but may affect its performance.\r\n\r\nJoin hints are explained in the following articles:\r\n\r\n* `hint.shufflekey=<key>` and `hint.strategy=shuffle` - [shuffle query](shufflequery.md)\r\n* `hint.strategy=broadcast` - [broadcast join](broadcastjoin.md)\r\n* `hint.remote=<strategy>` - [cross-cluster join](joincrosscluster.md)","https://docs.microsoft.com/en-us/azure/kusto/query/joinoperator","joinoperator.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.OperatorToken,"limit","Return up to the specified number of rows.","```\r\nT | limit 5\r\n```\r\n\r\n**Alias**\r\n\r\n[take operator](takeoperator.md)","","https://docs.microsoft.com/en-us/azure/kusto/query/limitoperator","")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"log","`log()` returns the natural logarithm function.","## Syntax\r\n\r\n`log(`*x*`)`\r\n\r\n## Arguments\r\n\r\n* *x*: A real number > 0.\r\n\r\n## Returns\r\n\r\n* The natural logarithm is the base-e logarithm: the inverse of the natural exponential function (exp).\r\n* `null` if the argument is negative or null or can't be converted to a `real` value. \r\n\r\n## See also\r\n\r\n* For common (base-10) logarithms, see [log10()](log10-function.md).\r\n* For base-2 logarithms, see [log2()](log2-function.md)","","https://docs.microsoft.com/en-us/azure/kusto/query/log-function","")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"log10","`log10()` returns the common (base-10) logarithm function.","## Syntax\r\n\r\n`log10(`*x*`)`\r\n\r\n## Arguments\r\n\r\n* *x*: A real number > 0.\r\n\r\n## Returns\r\n\r\n* The common logarithm is the base-10 logarithm: the inverse of the exponential function (exp) with base 10.\r\n* `null` if the argument is negative or null or can't be converted to a `real` value. \r\n\r\n## See also\r\n\r\n* For natural (base-e) logarithms, see [log()](log-function.md).\r\n* For base-2 logarithms, see [log2()](log2-function.md)","","https://docs.microsoft.com/en-us/azure/kusto/query/log10-function","")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"log2","`log2()` returns the base-2 logarithm function.","## Syntax\r\n\r\n`log2(`*x*`)`\r\n\r\n## Arguments\r\n\r\n* *x*: A real number > 0.\r\n\r\n## Returns\r\n\r\n* The logarithm is the base-2 logarithm: the inverse of the exponential function (exp) with base 2.\r\n* `null` if the argument is negative or null or can't be converted to a `real` value. \r\n\r\n## See also\r\n\r\n* For natural (base-e) logarithms, see [log()](log-function.md).\r\n* For common (base-10) logarithms, see [log10()](log10-function.md).","","https://docs.microsoft.com/en-us/azure/kusto/query/log2-function","")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"loggamma","Computes log of absolute value of the [gamma function](https://en.wikipedia.org/wiki/Gamma_function)","## Syntax\r\n\r\n`loggamma(`*x*`)`\r\n\r\n## Arguments\r\n\r\n* *x*: Parameter for the gamma function\r\n\r\n## Returns\r\n\r\n* Returns the natural logarithm of the absolute value of the gamma function of x.\r\n* For computing gamma function, see [gamma()](gammafunction.md).","","https://docs.microsoft.com/en-us/azure/kusto/query/loggammafunction","")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.OperatorToken,"lookup","The `lookup` operator extends the columns of a fact table with values\r\nlooked-up in a dimension table.","```\r\nFactTable | lookup kind=leftouter (DimensionTable) on CommonColumn, $left.Col1 == $right.Col2\r\n```\r\n\r\nHere, the result is a table that extends the `FactTable` (`$left`) with data from `DimensionTable` (referenced by `$right`)\r\n by performing a lookup of each pair (`CommonColumn`,`Col`) from the former table\r\nwith each pair (`CommonColumn1`,`Col2`) in the latter table. \r\nFor the differences between fact and dimension tables, see [fact and dimension tables](../concepts/fact-and-dimension-tables.md). \r\n\r\nThe `lookup` operator performs an operation similar to the [join operator](joinoperator.md)\r\nwith the following differences:\r\n\r\n* The result does not repeat columns from the `$right` table that are the basis\r\n  for the join operation.\r\n* Only two kinds of lookup are supported, `leftouter` and `inner`,\r\n  with `leftouter` being the default.\r\n* In terms of performance, the system by default assumes that the `$left` table\r\n  is the larger (facts) table, and the `$right` table is the smaller (dimensions)\r\n  table. This is exactly opposite to the assumption used by the `join` operator.\r\n* The `lookup` operator automatically broadcasts the `$right` table to the `$left`\r\n  table (essentially, behaves as if `hint.broadcast` was specified). Note that\r\n  this limits the size of the `$right` table.\r\n\r\n## Syntax\r\n\r\n*LeftTable* `|` `lookup` [`kind` `=` (`leftouter`|`inner`)] `(` *RightTable* `)` `on` *Attributes*\r\n\r\n## Arguments\r\n\r\n* *LeftTable*: The table or tabular expression that is the basis for the lookup.\r\n  Denoted as `$left`.\r\n* *RightTable*: The table or tabular expression that is used to \"populate\"\r\n  new columns in the fact table. Denoted as `$right`.\r\n* *Attributes*: A comma-delimited list of one or more rules that describe how rows from\r\n  *LeftTable* are matched to rows from *RightTable*. Multiple rules are evaluated using the `and` logical operator.\r\n  A rule can be one of:\r\n  |Rule kind        |Syntax                                          |Predicate                                                      |\r\n  |-----------------|------------------------------------------------|---------------------------------------------------------------|\r\n  |Equality by name |*ColumnName*                                    |`where` *LeftTable*.*ColumnName* `==` *RightTable*.*ColumnName*|\r\n  |Equality by value|`$left.`*LeftColumn* `==` `$right.`*RightColumn*|`where` `$left.`*LeftColumn* `==` `$right.`*RightColumn        |\r\n  > [!Note] \r\n  > In case of 'equality by value', the column names *must* be qualified with the applicable owner table denoted by `$left` and `$right` notations.\r\n* `kind`: An optional instruction on how to treat rows in *LeftTable* that\r\n  have no match in *RightTable*. By default, `leftouter` is used, which means\r\n  all those rows will appear in the output with null values used for the\r\n  missing values of *RightTable* columns added by the operator. If `inner`\r\n  is used, such rows are omitted from the output. (Other kinds\r\n  of join are not supported by the `looku`p operator.)\r\n  \r\n\r\n## Returns\r\n\r\nA table with:\r\n\r\n* A column for every column in each of the two tables, including the matching keys.\r\n  The columns of the right side will be automatically renamed if there are name conflicts.\r\n* A row for every match between the input tables. A match is a row selected from one table that has the same value for all the `on` fields as a row in the other table. \r\n* The Attributes (lookup keys) will appear only once in the output table.\r\n * `kind` unspecified, `kind=leftouter`\r\n     In addition to the inner matches, there's a row for every row on the left (and/or right), even if it has no match. In that case, the unmatched output cells contain nulls.\r\n * `kind=inner`\r\n     There's a row in the output for every combination of matching rows from left and right.",'```\r\nlet FactTable=datatable(Row:string,Personal:string,Family:string) [\r\n  "1", "Bill",   "Gates",\r\n  "2", "Bill",   "Clinton",\r\n  "3", "Bill",   "Clinton",\r\n  "4", "Steve",  "Ballmer",\r\n  "5", "Tim",    "Cook"\r\n];\r\nlet DimTable=datatable(Personal:string,Family:string,Alias:string) [\r\n  "Bill",  "Gates",   "billg",\r\n  "Bill",  "Clinton", "billc",\r\n  "Steve", "Ballmer", "steveb",\r\n  "Tim",   "Cook",    "timc"\r\n];\r\nFactTable\r\n| lookup kind=leftouter DimTable on Personal, Family\r\n```\r\n\r\nRow     | Personal  | Family   | Alias\r\n--------|-----------|----------|--------\r\n1       | Bill      | Gates    | billg\r\n2       | Bill      | Clinton  | billc\r\n3       | Bill      | Clinton  | billc\r\n4       | Steve     | Ballmer  | steveb\r\n5       | Tim       | Cook     | timc',"https://docs.microsoft.com/en-us/azure/kusto/query/lookupoperator","lookupoperator.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"make_bag","Returns a `dynamic` (JSON) property-bag (dictionary) of all the values of *`Expr`* in the group.","* Can be used only in context of aggregation inside [summarize](summarizeoperator.md)\r\n\r\n## Syntax\r\n\r\n`summarize` `make_bag(`*`Expr`* [`,` *MaxSize*]`)`\r\n\r\n## Arguments\r\n\r\n* *Expr*: Expression of type `dynamic` that is used for aggregation calculations.\r\n* *MaxSize* is an optional integer limit on the maximum number of elements returned. The default is *1048576*. MaxSize value can't exceed *1048576*.\r\n\r\n**Note**\r\n\r\nA legacy and obsolete variant of function `make_dictionary()`, has a default limit of *MaxSize* = 128.\r\n\r\n## Returns\r\n\r\nReturns a `dynamic` (JSON) property-bag (dictionary) of all the values of *`Expr`* in the group, which are property-bags.\r\nNon-dictionary values will be skipped.\r\nIf a key appears in more than one row, an arbitrary value, out of the possible values for this key, will be selected.\r\n\r\n## See also\r\n\r\nUse the [bag_unpack()](bag-unpackplugin.md) plugin for expanding dynamic JSON objects into columns that use property bag keys.",'```\r\nlet T = datatable(prop:string, value:string)\r\n[\r\n    "prop01", "val_a",\r\n    "prop02", "val_b",\r\n    "prop03", "val_c",\r\n];\r\nT\r\n| extend p = pack(prop, value)\r\n| summarize dict=make_bag(p)\r\n\r\n```\r\n\r\n|dict|\r\n|----|\r\n|{ "prop01": "val_a", "prop02": "val_b", "prop03": "val_c" } |\r\n\r\nUse the [bag_unpack()](bag-unpackplugin.md) plugin for transforming the bag keys in the make_bag() output into columns. \r\n\r\n```\r\nlet T = datatable(prop:string, value:string)\r\n[\r\n    "prop01", "val_a",\r\n    "prop02", "val_b",\r\n    "prop03", "val_c",\r\n];\r\nT\r\n| extend p = pack(prop, value)\r\n| summarize bag=make_bag(p)\r\n| evaluate bag_unpack(bag) \r\n\r\n```\r\n\r\n|prop01|prop02|prop03|\r\n|---|---|---|\r\n|val_a|val_b|val_c|',"https://docs.microsoft.com/en-us/azure/kusto/query/make-bag-aggfunction","make-bag-aggfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"make_bag_if","Returns a `dynamic` (JSON) property-bag (dictionary) of all the values of *'Expr'* in the group, for which *Predicate* evaluates to `true`.","> [!NOTE]\r\n> Can only be used in context of aggregation inside [summarize](summarizeoperator.md).\r\n\r\n## Syntax\r\n\r\n`summarize` `make_bag_if(`*Expr*, *Predicate* [`,` *MaxSize*]`)`\r\n\r\n## Arguments\r\n\r\n* *Expr*: Expression of type `dynamic` that will be used for aggregation calculation.\r\n* *Predicate*: Predicate that has to evaluate to `true`, in order for *'Expr'* to be added to the result.\r\n* *MaxSize*: An optional integer limit on the maximum number of elements returned (default is *1048576*). MaxSize value can't exceed 1048576.\r\n\r\n## Returns\r\n\r\nReturns a `dynamic` (JSON) property-bag (dictionary) of all the values of *'Expr'* in the group that are property-bags (dictionaries), for which *Predicate* evaluates to `true`.\r\nNon-dictionary values will be skipped.\r\nIf a key appears in more than one row, an arbitrary value, out of the possible values for this key, will be selected.\r\n\r\n> [!NOTE]\r\n> The [`make_bag`](./make-bag-aggfunction.md) function, is similar to make_bag_if() without predicate expression.",'```\r\nlet T = datatable(prop:string, value:string, predicate:bool)\r\n[\r\n    "prop01", "val_a", true,\r\n    "prop02", "val_b", false,\r\n    "prop03", "val_c", true\r\n];\r\nT\r\n| extend p = pack(prop, value)\r\n| summarize dict=make_bag_if(p, predicate)\r\n\r\n```\r\n\r\n|dict|\r\n|----|\r\n|{ "prop01": "val_a", "prop03": "val_c" } |\r\n\r\nUse [bag_unpack()](bag-unpackplugin.md) plugin for transforming the bag keys in the make_bag_if() output into columns. \r\n\r\n```\r\nlet T = datatable(prop:string, value:string, predicate:bool)\r\n[\r\n    "prop01", "val_a", true,\r\n    "prop02", "val_b", false,\r\n    "prop03", "val_c", true\r\n];\r\nT\r\n| extend p = pack(prop, value)\r\n| summarize bag=make_bag_if(p, predicate)\r\n| evaluate bag_unpack(bag)\r\n\r\n```\r\n\r\n|prop01|prop03|\r\n|---|---|\r\n|val_a|val_c|',"https://docs.microsoft.com/en-us/azure/kusto/query/make-bag-if-aggfunction","make-bag-if-aggfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"make_datetime","Creates a [datetime](./scalar-data-types/datetime.md) scalar value from the specified date and time.","```\r\nmake_datetime(2017,10,01,12,10) == datetime(2017-10-01 12:10)\r\n```\r\n\r\n## Syntax\r\n\r\n`make_datetime(`*year*,*month*,*day*`)`\r\n\r\n`make_datetime(`*year*,*month*,*day*,*hour*,*minute*`)`\r\n\r\n`make_datetime(`*year*,*month*,*day*,*hour*,*minute*,*second*`)`\r\n\r\n## Arguments\r\n\r\n* *year*: year (an integer value, from 0 to 9999)\r\n* *month*: month (an integer value, from 1 to 12)\r\n* *day*: day (an integer value, from 1 to 28-31)\r\n* *hour*: hour (an integer value, from 0 to 23)\r\n* *minute*: minute (an integer value, from 0 to 59)\r\n* *second*: second (a real value, from 0 to 59.9999999)\r\n\r\n## Returns\r\n\r\nIf creation is successful, result will be a [datetime](./scalar-data-types/datetime.md) value, otherwise, result will be null.","```\r\nprint year_month_day = make_datetime(2017,10,01)\r\n```\r\n\r\n|year_month_day|\r\n|---|\r\n|2017-10-01 00:00:00.0000000|\r\n\r\n```\r\nprint year_month_day_hour_minute = make_datetime(2017,10,01,12,10)\r\n```\r\n\r\n|year_month_day_hour_minute|\r\n|---|\r\n|2017-10-01 12:10:00.0000000|\r\n\r\n```\r\nprint year_month_day_hour_minute_second = make_datetime(2017,10,01,12,11,0.1234567)\r\n```\r\n\r\n|year_month_day_hour_minute_second|\r\n|---|\r\n|2017-10-01 12:11:00.1234567|","https://docs.microsoft.com/en-us/azure/kusto/query/make-datetimefunction","make-datetimefunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"make_list","Returns a `dynamic` (JSON) array of all the values of *Expr* in the group.","* Can be used only in context of aggregation inside [summarize](summarizeoperator.md)\r\n\r\n## Syntax\r\n\r\n`summarize` `make_list(`*Expr* [`,` *MaxSize*]`)`\r\n\r\n## Arguments\r\n\r\n* *Expr*: Expression that will be used for aggregation calculation.\r\n* *MaxSize* is an optional integer limit on the maximum number of elements returned (default is *1048576*). MaxSize value cannot exceed 1048576.\r\n\r\n> [!NOTE]\r\n> A legacy and obsolete variant of this function: `makelist()` has a default limit of *MaxSize* = 128.\r\n\r\n## Returns\r\n\r\nReturns a `dynamic` (JSON) array of all the values of *Expr* in the group.\r\nIf the input to the `summarize` operator is not sorted, the order of elements in the resulting array is undefined.\r\nIf the input to the `summarize` operator is sorted, the order of elements in the resulting array tracks that of the input.\r\n\r\n> [!TIP]\r\n> Use the [`mv-apply`](./mv-applyoperator.md) operator to create an ordered list by some key. See examples [here](./mv-applyoperator.md#using-the-mv-apply-operator-to-sort-the-output-of-make_list-aggregate-by-some-key).",'### One column\r\n\r\nThe simplest example is to make a list out of a single column:\r\n\r\n```\r\nlet shapes = datatable (name: string, sideCount: int)\r\n[\r\n    "triangle", 3,\r\n    "square", 4,\r\n    "rectangle", 4,\r\n    "pentagon", 5,\r\n    "hexagon", 6,\r\n    "heptagon", 7,\r\n    "octogon", 8,\r\n    "nonagon", 9,\r\n    "decagon", 10\r\n];\r\nshapes\r\n| summarize mylist = make_list(name)\r\n```\r\n\r\n|mylist|\r\n|---|\r\n|["triangle","square","rectangle","pentagon","hexagon","heptagon","octogon","nonagon","decagon"]|\r\n\r\n### Using the \'by\' clause\r\n\r\nIn the following query, you group using the `by` clause:\r\n\r\n```\r\nlet shapes = datatable (name: string, sideCount: int)\r\n[\r\n    "triangle", 3,\r\n    "square", 4,\r\n    "rectangle", 4,\r\n    "pentagon", 5,\r\n    "hexagon", 6,\r\n    "heptagon", 7,\r\n    "octogon", 8,\r\n    "nonagon", 9,\r\n    "decagon", 10\r\n];\r\nshapes\r\n| summarize mylist = make_list(name) by isEvenSideCount = sideCount % 2 == 0\r\n```\r\n\r\n|mylist|isEvenSideCount|\r\n|---|---|\r\n|false|["triangle","pentagon","heptagon","nonagon"]|\r\n|true|["square","rectangle","hexagon","octogon","decagon"]|\r\n\r\n### Packing a dynamic object\r\n\r\nYou can [pack](./packfunction.md) a dynamic object in a column before making a list out of it, as seen in the following query:\r\n\r\n```\r\nlet shapes = datatable (name: string, sideCount: int)\r\n[\r\n    "triangle", 3,\r\n    "square", 4,\r\n    "rectangle", 4,\r\n    "pentagon", 5,\r\n    "hexagon", 6,\r\n    "heptagon", 7,\r\n    "octogon", 8,\r\n    "nonagon", 9,\r\n    "decagon", 10\r\n];\r\nshapes\r\n| extend d = pack("name", name, "sideCount", sideCount)\r\n| summarize mylist = make_list(d) by isEvenSideCount = sideCount % 2 == 0\r\n```\r\n\r\n|mylist|isEvenSideCount|\r\n|---|---|\r\n|false|[{"name":"triangle","sideCount":3},{"name":"pentagon","sideCount":5},{"name":"heptagon","sideCount":7},{"name":"nonagon","sideCount":9}]|\r\n|true|[{"name":"square","sideCount":4},{"name":"rectangle","sideCount":4},{"name":"hexagon","sideCount":6},{"name":"octogon","sideCount":8},{"name":"decagon","sideCount":10}]|\r\n\r\n## See also\r\n\r\n[`make_list_if`](./makelistif-aggfunction.md) operator is similar to `make_list`, except it also accepts a predicate.',"https://docs.microsoft.com/en-us/azure/kusto/query/makelist-aggfunction","makelist-aggfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"make_list_if","Returns a `dynamic` (JSON) array of all the values of *Expr* in the group, for which *Predicate* evaluates to `true`.","* Can be used only in context of aggregation inside [summarize](summarizeoperator.md)\r\n\r\n## Syntax\r\n\r\n`summarize` `make_list_if(`*Expr*, *Predicate* [`,` *MaxSize*]`)`\r\n\r\n## Arguments\r\n\r\n* *Expr*: Expression that will be used for aggregation calculation.\r\n* *Predicate*: Predicate that has to evaluate to `true`, in order for *Expr* to be added to the result.\r\n* *MaxSize* is an optional integer limit on the maximum number of elements returned (default is *1048576*). MaxSize value cannot exceed 1048576.\r\n\r\n## Returns\r\n\r\nReturns a `dynamic` (JSON) array of all the values of *Expr* in the group, for which *Predicate* evaluates to `true`.\r\nIf the input to the `summarize` operator is not sorted, the order of elements in the resulting array is undefined.\r\nIf the input to the `summarize` operator is sorted, the order of elements in the resulting array tracks that of the input.",'```\r\nlet T = datatable(name:string, day_of_birth:long)\r\n[\r\n   "John", 9,\r\n   "Paul", 18,\r\n   "George", 25,\r\n   "Ringo", 7\r\n];\r\nT\r\n| summarize make_list_if(name, strlen(name) > 4)\r\n```\r\n\r\n|list_name|\r\n|----|\r\n|["George", "Ringo"]|\r\n\r\n## See also\r\n\r\n[`make_list`](./makelist-aggfunction.md) function, which does the same, without predicate expression.',"https://docs.microsoft.com/en-us/azure/kusto/query/makelistif-aggfunction","makelistif-aggfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"make_list_with_nulls","Returns a `dynamic` (JSON) array of all the values of *Expr* in the group, including null values.","* Can be used only in context of aggregation inside [summarize](summarizeoperator.md)\r\n\r\n## Syntax\r\n\r\n`summarize` `make_list_with_nulls(` *Expr* `)`\r\n\r\n## Arguments\r\n\r\n* *Expr*: Expression that will be used for aggregation calculation.\r\n\r\n## Returns\r\n\r\nReturns a `dynamic` (JSON) array of all the values of *Expr* in the group, including null values.\r\nIf the input to the `summarize` operator is not sorted, the order of elements in the resulting array is undefined.\r\nIf the input to the `summarize` operator is sorted, the order of elements in the resulting array tracks that of the input.\r\n\r\n> [!TIP]\r\n> Use the [`mv-apply`](./mv-applyoperator.md) operator to create an ordered list by some key. See examples [here](./mv-applyoperator.md#using-the-mv-apply-operator-to-sort-the-output-of-make_list-aggregate-by-some-key).","","https://docs.microsoft.com/en-us/azure/kusto/query/make-list-with-nulls-aggfunction","")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"make_set","Returns a `dynamic` (JSON) array of the set of distinct values that *Expr* takes in the group.","* Can be used only in context of aggregation inside [summarize](summarizeoperator.md)\r\n\r\n## Syntax\r\n\r\n`summarize` `make_set(`*Expr* [`,` *MaxSize*]`)`\r\n\r\n## Arguments\r\n\r\n* *Expr*: Expression for aggregation calculation.\r\n* *MaxSize* is an optional integer limit on the maximum number of elements returned (default is *1048576*). MaxSize value cannot exceed 1048576.\r\n\r\n> [!NOTE]\r\n> A legacy and obsolete variant of this function: `makeset()` has a default limit of *MaxSize* = 128.\r\n\r\n## Returns\r\n\r\nReturns a `dynamic` (JSON) array of the set of distinct values that *Expr* takes in the group.\r\nThe array's sort order is undefined.\r\n\r\n> [!TIP]\r\n> To only count distinct values, use [dcount()](dcount-aggfunction.md)","```\r\nPageViewLog \r\n| summarize countries=make_set(country) by continent\r\n```\r\n\r\n![Table showing Kusto Query summarize countries by continent in Azure Data Explorer](images/makeset-aggfunction/makeset.png)\r\n\r\n## See also\r\n\r\n* Use [`mv-expand`](./mvexpandoperator.md) operator for the opposite function.\r\n* [`make_set_if`](./makesetif-aggfunction.md) operator is similar to `make_set`, except it also accepts a predicate.","https://docs.microsoft.com/en-us/azure/kusto/query/makeset-aggfunction","makeset-aggfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"make_set_if","Returns a `dynamic` (JSON) array of the set of distinct values that *Expr* takes in the group, for which *Predicate* evaluates to `true`.","* Can be used only in context of aggregation inside [summarize](summarizeoperator.md)\r\n\r\n## Syntax\r\n\r\n`summarize` `make_set_if(`*Expr*, *Predicate* [`,` *MaxSize*]`)`\r\n\r\n## Arguments\r\n\r\n* *Expr*: Expression that will be used for aggregation calculation.\r\n* *Predicate*: Predicate that has to evaluate to `true` for *Expr* to be added to the result.\r\n* *MaxSize* is an optional integer limit on the maximum number of elements returned (default is *1048576*). MaxSize value cannot exceed 1048576.\r\n\r\n## Returns\r\n\r\nReturns a `dynamic` (JSON) array of the set of distinct values that *Expr* takes in the group, for which *Predicate* evaluates to `true`.\r\nThe array's sort order is undefined.\r\n\r\n> [!TIP]\r\n> To only count the distinct values, use [dcountif()](dcountif-aggfunction.md)\r\n\r\n## See also\r\n\r\n[`make_set`](./makeset-aggfunction.md) function, which does the same, without predicate expression.",'```\r\nlet T = datatable(name:string, day_of_birth:long)\r\n[\r\n   "John", 9,\r\n   "Paul", 18,\r\n   "George", 25,\r\n   "Ringo", 7\r\n];\r\nT\r\n| summarize make_set_if(name, strlen(name) > 4)\r\n```\r\n\r\n|set_name|\r\n|----|\r\n|["George", "Ringo"]|',"https://docs.microsoft.com/en-us/azure/kusto/query/makesetif-aggfunction","makesetif-aggfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"make_string","Returns the string generated by the Unicode characters.","## Syntax\r\n\r\n`make_string (`*Arg1*[, *ArgN*]... `)`\r\n\r\n## Arguments\r\n\r\n* *Arg1* ... *ArgN*: Expressions that are integers (int or long) or a dynamic value holding an array of integral numbers.\r\n* This function receives up to 64 arguments.\r\n\r\n## Returns\r\n\r\nReturns the string made of the Unicode characters whose codepoint value is provided by the arguments to this function. The input must consist of valid Unicode codepoints.\r\nIf any argument isn't mapped to a Unicode character, the function returns `null`.","```\r\nprint str = make_string(75, 117, 115, 116, 111)\r\n```\r\n\r\n|str|\r\n|---|\r\n|Kusto|\r\n\r\n```\r\nprint str = make_string(dynamic([75, 117, 115, 116, 111]))\r\n```\r\n\r\n|str|\r\n|---|\r\n|Kusto|\r\n\r\n```\r\nprint str = make_string(dynamic([75, 117, 115]), 116, 111)\r\n```\r\n\r\n|str|\r\n|---|\r\n|Kusto|\r\n\r\n```\r\nprint str = make_string(75, 10, 117, 10, 115, 10, 116, 10, 111)\r\n```\r\n\r\n|str|\r\n|---|\r\n|K<br>u<br>s<br>t<br>o|","https://docs.microsoft.com/en-us/azure/kusto/query/makestringfunction","makestringfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"make_timespan","Creates a [timespan](./scalar-data-types/timespan.md) scalar value from the specified time period.","```\r\nmake_timespan(1,12,30,55.123) == time(1.12:30:55.123)\r\n```\r\n\r\n## Syntax\r\n\r\n`make_timespan(`*hour*,*minute*`)`\r\n\r\n`make_timespan(`*hour*,*minute*,*second*`)`\r\n\r\n`make_timespan(`*day*,*hour*,*minute*,*second*`)`\r\n\r\n## Arguments\r\n\r\n* *day*: day (a positive integer value)\r\n* *hour*: hour (an integer value, from 0 to 23)\r\n* *minute*: minute (an integer value, from 0 to 59)\r\n* *second*: second (a real value, from 0 to 59.9999999)\r\n\r\n## Returns\r\n\r\nIf creation is successful, result will be a [timespan](./scalar-data-types/timespan.md) value, otherwise, result will be null.","```\r\nprint ['timespan'] = make_timespan(1,12,30,55.123)\r\n\r\n```\r\n\r\n|timespan|\r\n|---|\r\n|1.12:30:55.1230000|","https://docs.microsoft.com/en-us/azure/kusto/query/make-timespanfunction","make-timespanfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.OperatorToken,"make-series","Create series of specified aggregated values along a specified axis.","```\r\nT | make-series sum(amount) default=0, avg(price) default=0 on timestamp from datetime(2016-01-01) to datetime(2016-01-10) step 1d by fruit, supplier\r\n```\r\n\r\n## Syntax\r\n\r\n*T* `| make-series` [*MakeSeriesParamters*]\r\n      [*Column* `=`] *Aggregation* [`default` `=` *DefaultValue*] [`,` ...]\r\n    `on` *AxisColumn* [`from` *start*] [`to` *end*] `step` *step* \r\n    [`by`\r\n      [*Column* `=`] *GroupExpression* [`,` ...]]\r\n\r\n## Arguments\r\n\r\n* *Column:* Optional name for a result column. Defaults to a name derived from the expression.\r\n* *DefaultValue:* Default value that will be used instead of absent values. If there is no row with specific values of *AxisColumn* and *GroupExpression*, then in the results the corresponding element of the array will be assigned a *DefaultValue*. If *DefaultValue* is omitted, then 0 is assumed. \r\n* *Aggregation:* A call to an [aggregation function](make-seriesoperator.md#list-of-aggregation-functions) such as `count()` or `avg()`, with column names as arguments. See the [list of aggregation functions](make-seriesoperator.md#list-of-aggregation-functions). Only aggregation functions that return numeric results can be used with the `make-series` operator.\r\n* *AxisColumn:* A column on which the series will be ordered. It could be considered as timeline, but besides `datetime` any numeric types are accepted.\r\n* *start*: (optional) The low bound value of the *AxisColumn* for each of the series to be built. *start*, *end*, and *step* are used to build an array of *AxisColumn* values within a given range and using specified *step*. All *Aggregation* values are ordered respectively to this array. This *AxisColumn* array is also the last output column in the output that has the same name as *AxisColumn*. If a *start* value is not specified, the start is the first bin (step) which has data in each series.\r\n* *end*: (optional) The high bound (non-inclusive) value of the *AxisColumn*. The last index of the time series is smaller than this value (and will be *start* plus integer multiple of *step* that is smaller than *end*). If *end* value is not provided, it will be the upper bound of the last bin (step) which has data per each series.\r\n* *step*: The difference between two consecutive elements of the *AxisColumn* array (that is, the bin size).\r\n* *GroupExpression:* An expression over the columns that provides a set of distinct values. Typically it's a column name that already provides a restricted set of values. \r\n* *MakeSeriesParameters*: Zero or more (space-separated) parameters in the form of *Name* `=` *Value* \r\n\tthat control the behavior. The following parameters are supported: \r\n  \r\n  |Name           |Values                                        |Description                                                                                        |\r\n  |---------------|-------------------------------------|------------------------------------------------------------------------------|\r\n  |`kind`          |`nonempty`\t\t\t\t\t\t\t\t |Produces default result when the input of make-series operator is empty|                                \r\n\r\n## Returns\r\n\r\nThe input rows are arranged into groups having the same values of the `by` expressions and the `bin_at(`*AxisColumn*`, `*step*`, `*start*`)` expression. Then the specified aggregation functions are computed over each group, producing a row for each group. The result contains the `by` columns, *AxisColumn* column and also at least one column for each computed aggregate. (Aggregation that multiple columns or non-numeric results are not supported.)\r\n\r\nThis intermediate result has as many rows as there are distinct combinations of `by` and `bin_at(`*AxisColumn*`, `*step*`, `*start*`)` values.\r\n\r\nFinally the rows from the intermediate result arranged into groups having the same values of the `by` expressions and all aggregated values are arranged into arrays (values of `dynamic` type). For each aggregation, there is one column containing its array with the same name. The last column in the output of the range function with all *AxisColumn* values. Its value is repeated for all rows. \r\n\r\nDue to the fill missing bins by default value, the resulting pivot table has the same number of bins (that is, aggregated values) for all series  \r\n\r\n**Note**\r\n\r\nAlthough you can provide arbitrary expressions for both the aggregation and grouping expressions, it's more efficient to use simple column names.\r\n\r\n**Alternate Syntax**\r\n\r\n*T* `| make-series`\r\n      [*Column* `=`] *Aggregation* [`default` `=` *DefaultValue*] [`,` ...]\r\n    `on` *AxisColumn* `in` `range(`*start*`,` *stop*`,` *step*`)`\r\n    [`by`\r\n      [*Column* `=`] *GroupExpression* [`,` ...]]\r\n\r\nThe generated series from the alternate syntax differs from the main syntax in two aspects:\r\n\r\n* The *stop* value is inclusive.\r\n* Binning the index axis is generated with bin() and not bin_at(), which means that *start* may not be included in the generated series.\r\n\r\nIt is recommended to use the main syntax of make-series and not the alternate syntax.\r\n\r\n**Distribution and Shuffle**\r\n\r\n`make-series` supports `summarize` [shufflekey hints](shufflequery.md) using the syntax hint.shufflekey.\r\n\r\n## List of aggregation functions\r\n\r\n|Function|Description|\r\n|--------|-----------|\r\n|[any()](any-aggfunction.md)|Returns a random non-empty value for the group|\r\n|[avg()](avg-aggfunction.md)|Returns an average value across the group|\r\n|[avgif()](avgif-aggfunction.md)|Returns an average with the predicate of the group|\r\n|[count()](count-aggfunction.md)|Returns a count of the group|\r\n|[countif()](countif-aggfunction.md)|Returns a count with the predicate of the group|\r\n|[dcount()](dcount-aggfunction.md)|Returns an  approximate distinct count of the group elements|\r\n|[dcountif()](dcountif-aggfunction.md)|Returns an approximate distinct count with the predicate of the group|\r\n|[max()](max-aggfunction.md)|Returns the maximum value across the group|\r\n|[maxif()](maxif-aggfunction.md)|Returns the maximum value with the predicate of the group|\r\n|[min()](min-aggfunction.md)|Returns the minimum value across the group|\r\n|[minif()](minif-aggfunction.md)|Returns the minimum value with the predicate of the group|\r\n|[stdev()](stdev-aggfunction.md)|Returns the standard deviation across the group|\r\n|[sum()](sum-aggfunction.md)|Returns the sum of the elements within the group|\r\n|[sumif()](sumif-aggfunction.md)|Returns the sum of the elements with the predicate of the group|\r\n|[variance()](variance-aggfunction.md)|Returns the variance across the group|\r\n\r\n## List of series analysis functions\r\n\r\n|Function|Description|\r\n|--------|-----------|\r\n|[series_fir()](series-firfunction.md)|Applies [Finite Impulse Response](https://en.wikipedia.org/wiki/Finite_impulse_response) filter|\r\n|[series_iir()](series-iirfunction.md)|Applies [Infinite Impulse Response](https://en.wikipedia.org/wiki/Infinite_impulse_response) filter|\r\n|[series_fit_line()](series-fit-linefunction.md)|Finds a straight line that is the best approximation of the input|\r\n|[series_fit_line_dynamic()](series-fit-line-dynamicfunction.md)|Finds a line that is the best approximation of the input, returning dynamic object|\r\n|[series_fit_2lines()](series-fit-2linesfunction.md)|Finds two lines that are the best approximation of the input|\r\n|[series_fit_2lines_dynamic()](series-fit-2lines-dynamicfunction.md)|Finds two lines that are the best approximation of the input, returning dynamic object|\r\n|[series_outliers()](series-outliersfunction.md)|Scores anomaly points in a series|\r\n|[series_periods_detect()](series-periods-detectfunction.md)|Finds the most significant periods that exist in a time series|\r\n|[series_periods_validate()](series-periods-validatefunction.md)|Checks whether a time series contains periodic patterns of given lengths|\r\n|[series_stats_dynamic()](series-stats-dynamicfunction.md)|Return multiple columns with the common statistics (min/max/variance/stdev/average)|\r\n|[series_stats()](series-statsfunction.md)|Generates a dynamic value with the common statistics (min/max/variance/stdev/average)|\r\n\r\n## List of series interpolation functions\r\n\r\n|Function|Description|\r\n|--------|-----------|\r\n|[series_fill_backward()](series-fill-backwardfunction.md)|Performs backward fill interpolation of missing values in a series|\r\n|[series_fill_const()](series-fill-constfunction.md)|Replaces missing values in a series with a specified constant value|\r\n|[series_fill_forward()](series-fill-forwardfunction.md)|Performs forward fill interpolation of missing values in a series|\r\n|[series_fill_linear()](series-fill-linearfunction.md)|Performs linear interpolation of missing values in a series|\r\n\r\n* Note: Interpolation functions by default assume `null` as a missing value. Therefore specify `default=`*double*(`null`) in `make-series` if you intend to use interpolation functions for the series.",'A table that shows arrays of the numbers and average prices of each fruit from each supplier ordered by the timestamp with specified range. There\'s a row in the output for each distinct combination of fruit and supplier. The output columns show the fruit, supplier, and arrays of: count, average, and the whole timeline (from 2016-01-01 until 2016-01-10). All arrays are sorted by the respective timestamp and all gaps are filled with default values (0 in this example). All other input columns are ignored.\r\n\r\n```\r\nT | make-series PriceAvg=avg(Price) default=0\r\non Purchase from datetime(2016-09-10) to datetime(2016-09-13) step 1d by Supplier, Fruit\r\n```\r\n\r\n![Makeseries](images/make-seriesoperator/makeseries.png)\r\n\r\n```\r\nlet data=datatable(timestamp:datetime, metric: real)\r\n[\r\n  datetime(2016-12-31T06:00), 50,\r\n  datetime(2017-01-01), 4,\r\n  datetime(2017-01-02), 3,\r\n  datetime(2017-01-03), 4,\r\n  datetime(2017-01-03T03:00), 6,\r\n  datetime(2017-01-05), 8,\r\n  datetime(2017-01-05T13:40), 13,\r\n  datetime(2017-01-06), 4,\r\n  datetime(2017-01-07), 3,\r\n  datetime(2017-01-08), 8,\r\n  datetime(2017-01-08T21:00), 8,\r\n  datetime(2017-01-09), 2,\r\n  datetime(2017-01-09T12:00), 11,\r\n  datetime(2017-01-10T05:00), 5,\r\n];\r\nlet interval = 1d;\r\nlet stime = datetime(2017-01-01);\r\nlet etime = datetime(2017-01-10);\r\ndata\r\n| make-series avg(metric) on timestamp from stime to etime step interval \r\n```\r\n\r\n|avg_metric|timestamp|\r\n|---|---|\r\n|[ 4.0, 3.0, 5.0, 0.0, 10.5, 4.0, 3.0, 8.0, 6.5 ]|[ "2017-01-01T00:00:00.0000000Z", "2017-01-02T00:00:00.0000000Z", "2017-01-03T00:00:00.0000000Z", "2017-01-04T00:00:00.0000000Z", "2017-01-05T00:00:00.0000000Z", "2017-01-06T00:00:00.0000000Z", "2017-01-07T00:00:00.0000000Z", "2017-01-08T00:00:00.0000000Z", "2017-01-09T00:00:00.0000000Z" ]|  \r\n\r\nWhen the input to `make-series` is empty, the default behavior of `make-series` produces an empty result as well.\r\n\r\n```\r\nlet data=datatable(timestamp:datetime, metric: real)\r\n[\r\n  datetime(2016-12-31T06:00), 50,\r\n  datetime(2017-01-01), 4,\r\n  datetime(2017-01-02), 3,\r\n  datetime(2017-01-03), 4,\r\n  datetime(2017-01-03T03:00), 6,\r\n  datetime(2017-01-05), 8,\r\n  datetime(2017-01-05T13:40), 13,\r\n  datetime(2017-01-06), 4,\r\n  datetime(2017-01-07), 3,\r\n  datetime(2017-01-08), 8,\r\n  datetime(2017-01-08T21:00), 8,\r\n  datetime(2017-01-09), 2,\r\n  datetime(2017-01-09T12:00), 11,\r\n  datetime(2017-01-10T05:00), 5,\r\n];\r\nlet interval = 1d;\r\nlet stime = datetime(2017-01-01);\r\nlet etime = datetime(2017-01-10);\r\ndata\r\n| limit 0\r\n| make-series avg(metric) default=1.0 on timestamp from stime to etime step interval \r\n| count \r\n```\r\n\r\n|Count|\r\n|---|\r\n|0|\r\n\r\nUsing `kind=nonempty` in `make-series` will produce a non-empty result of the default values:\r\n\r\n```\r\nlet data=datatable(timestamp:datetime, metric: real)\r\n[\r\n  datetime(2016-12-31T06:00), 50,\r\n  datetime(2017-01-01), 4,\r\n  datetime(2017-01-02), 3,\r\n  datetime(2017-01-03), 4,\r\n  datetime(2017-01-03T03:00), 6,\r\n  datetime(2017-01-05), 8,\r\n  datetime(2017-01-05T13:40), 13,\r\n  datetime(2017-01-06), 4,\r\n  datetime(2017-01-07), 3,\r\n  datetime(2017-01-08), 8,\r\n  datetime(2017-01-08T21:00), 8,\r\n  datetime(2017-01-09), 2,\r\n  datetime(2017-01-09T12:00), 11,\r\n  datetime(2017-01-10T05:00), 5,\r\n];\r\nlet interval = 1d;\r\nlet stime = datetime(2017-01-01);\r\nlet etime = datetime(2017-01-10);\r\ndata\r\n| limit 0\r\n| make-series kind=nonempty avg(metric) default=1.0 on timestamp from stime to etime step interval \r\n```\r\n\r\n|avg_metric|timestamp|\r\n|---|---|\r\n|[<br>  1.0,<br>  1.0,<br>  1.0,<br>  1.0,<br>  1.0,<br>  1.0,<br>  1.0,<br>  1.0,<br>  1.0<br>]|[<br>  "2017-01-01T00:00:00.0000000Z",<br>  "2017-01-02T00:00:00.0000000Z",<br>  "2017-01-03T00:00:00.0000000Z",<br>  "2017-01-04T00:00:00.0000000Z",<br>  "2017-01-05T00:00:00.0000000Z",<br>  "2017-01-06T00:00:00.0000000Z",<br>  "2017-01-07T00:00:00.0000000Z",<br>  "2017-01-08T00:00:00.0000000Z",<br>  "2017-01-09T00:00:00.0000000Z"<br>]|',"https://docs.microsoft.com/en-us/azure/kusto/query/make-seriesoperator","make-seriesoperator.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"materialize","Allows caching a subquery result during the time of query execution in a way that other subqueries can reference the partial result.",'## Syntax\r\n\r\n`materialize(`*expression*`)`\r\n\r\n## Arguments\r\n\r\n* *expression*: Tabular expression to be evaluated and cached during query execution.\r\n\r\n> [!NOTE]\r\n> Materialize has a cache size limit of **5 GB**. This limit is per cluster node and is mutual for all queries running concurrently. If a query uses `materialize()` and the cache can\'t hold any more data, the query will abort with an error.\r\n\r\n>[!TIP]\r\n>\r\n>* Push all possible operators that reduce the materialized data set and keep the semantics of the query. For example, use filters, or project only required columns.\r\n>* Use materialize with join or union when their operands have mutual subqueries that can be executed once. For example, join/union fork legs. See [example of using join operator](#examples-of-query-performance-improvement).\r\n>* Materialize can only be used in let statements if you give the cached result a name. See [example of using let statements](#examples-of-using-materialize)).\r\n\r\n## Examples of query performance improvement\r\n\r\nThe following example shows how `materialize()` can be used to improve performance of the query.\r\nThe expression `_detailed_data` is defined using `materialize()` function and therefore is calculated only once.\r\n\r\n```\r\nlet _detailed_data = materialize(StormEvents | summarize Events=count() by State, EventType);\r\n_detailed_data\r\n| summarize TotalStateEvents=sum(Events) by State\r\n| join (_detailed_data) on State\r\n| extend EventPercentage = Events*100.0 / TotalStateEvents\r\n| project State, EventType, EventPercentage, Events\r\n| top 10 by EventPercentage\r\n```\r\n\r\n|State|EventType|EventPercentage|Events|\r\n|---|---|---|---|\r\n|HAWAII WATERS|Waterspout|100|2|\r\n|LAKE ONTARIO|Marine Thunderstorm Wind|100|8|\r\n|GULF OF ALASKA|Waterspout|100|4|\r\n|ATLANTIC NORTH|Marine Thunderstorm Wind|95.2127659574468|179|\r\n|LAKE ERIE|Marine Thunderstorm Wind|92.5925925925926|25|\r\n|E PACIFIC|Waterspout|90|9|\r\n|LAKE MICHIGAN|Marine Thunderstorm Wind|85.1648351648352|155|\r\n|LAKE HURON|Marine Thunderstorm Wind|79.3650793650794|50|\r\n|GULF OF MEXICO|Marine Thunderstorm Wind|71.7504332755633|414|\r\n|HAWAII|High Surf|70.0218818380744|320|\r\n\r\nThe following example generates a set of random numbers and calculates: \r\n\r\n* how many distinct values in the set (`Dcount`)\r\n* the top three values in the set \r\n* the sum of all these values in the set \r\n \r\n\r\nThis operation can be done using [batches](batches.md) and materialize:\r\n\r\n```\r\nlet randomSet = \r\n    materialize(\r\n        range x from 1 to 3000000 step 1\r\n        | project value = rand(10000000));\r\nrandomSet | summarize Dcount=dcount(value);\r\nrandomSet | top 3 by value;\r\nrandomSet | summarize Sum=sum(value)\r\n```\r\n\r\nResult set 1:  \r\n\r\n|Dcount|\r\n|---|\r\n|2578351|\r\n\r\nResult set 2: \r\n\r\n|value|\r\n|---|\r\n|9999998|\r\n|9999998|\r\n|9999997|\r\n\r\nResult set 3: \r\n\r\n|Sum|\r\n|---|\r\n|15002960543563|\r\n\r\n## Examples of using materialize()\r\n\r\n> [!TIP]\r\n> Materialize your column at ingestion time if most of your queries extract fields from dynamic objects across millions of rows.\r\n\r\nTo use the `let` statement with a value that you use more than once, use the [materialize() function](./materializefunction.md). Try to push all possible operators that will reduce the materialized data set and still keep the semantics of the query. For example, use filters, or project only required columns.\r\n\r\n```\r\n    let materializedData = materialize(Table\r\n    | where Timestamp > ago(1d));\r\n    union (materializedData\r\n    | where Text !has "somestring"\r\n    | summarize dcount(Resource1)), (materializedData\r\n    | where Text !has "somestring"\r\n    | summarize dcount(Resource2))\r\n```\r\n\r\nThe filter on `Text` is mutual and can be pushed to the materialize expression.\r\nThe query only needs columns `Timestamp`, `Text`, `Resource1`, and `Resource2`. Project these columns inside the materialized expression.\r\n\r\n```\r\n    let materializedData = materialize(Table\r\n    | where Timestamp > ago(1d)\r\n    | where Text !has "somestring"\r\n    | project Timestamp, Resource1, Resource2, Text);\r\n    union (materializedData\r\n    | summarize dcount(Resource1)), (materializedData\r\n    | summarize dcount(Resource2))\r\n```\r\n\r\nIf the filters aren\'t identical, as in the following query:  \r\n\r\n```\r\n    let materializedData = materialize(Table\r\n    | where Timestamp > ago(1d));\r\n    union (materializedData\r\n    | where Text has "String1"\r\n    | summarize dcount(Resource1)), (materializedData\r\n    | where Text has "String2"\r\n    | summarize dcount(Resource2))\r\n ```\r\n\r\nWhen the combined filter reduces the materialized result drastically, combine both filters on the materialized result by a logical `or` expression as in the query below. However, keep the filters in each union leg to preserve the semantics of the query.\r\n\r\n```\r\n    let materializedData = materialize(Table\r\n    | where Timestamp > ago(1d)\r\n    | where Text has "String1" or Text has "String2"\r\n    | project Timestamp, Resource1, Resource2, Text);\r\n    union (materializedData\r\n    | where Text has "String1"\r\n    | summarize dcount(Resource1)), (materializedData\r\n    | where Text has "String2"\r\n    | summarize dcount(Resource2))\r\n```',"","https://docs.microsoft.com/en-us/azure/kusto/query/materializefunction","")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"materialized_view","References the materialized part of a [materialized view](../management/materialized-views/materialized-view-overview.md).","The `materialized_view()` function supports a way of querying the *materialized* part only of the view, while specifying the max latency the user is willing to tolerate. This option isn't guaranteed to return the most up-to-date records, but should always be more performant than querying the entire view. This function is useful for scenarios in which you're willing to sacrifice some freshness for performance, for example in telemetry dashboards.\r\n\r\n\x3c!--- csl ---\x3e\r\n\r\n```\r\nmaterialized_view('ViewName')\r\n```\r\n\r\n## Syntax\r\n\r\n`materialized_view(`*ViewName*`,` [*max_age*]`)`\r\n\r\n## Arguments\r\n\r\n* *ViewName*: The name of the `materialized view`.\r\n* *max_age*: Optional. If not provided, only the *materialized* part of the view is returned. If provided, function will return the \r\n_materialized_ part of the view if last materialization time is greater than [@now -  max_age]. Otherwise, the entire view is returned (identical \r\nto querying *ViewName* directly.",'Query the *materialized* part of the view only, independent on when it was last materialized.\r\n\r\n```\r\nmaterialized_view("ViewName")\r\n```\r\n\r\nQuery the *materialized* part only if it was materialized in the last 10 minutes. If the materialized part is older than 10 minutes, return the full view. This option is expected to be less performant than querying the materialized part.\r\n\r\n```\r\nmaterialized_view("ViewName", 10m)\r\n```\r\n\r\n## Notes\r\n\r\n* Once a view is created, it can be queried just as any other table in the database, including participate in cross-cluster / cross-database queries.\r\n* Materialized views aren\'t included in wildcard unions or searches.\r\n* Syntax for querying the view is the view name (like a table reference).\r\n* Querying the materialized view will always return the most up-to-date results, based on all records ingested to the source table. The query combines the materialized part of the view with all unmaterialized records in the source table. For more information, see [behind the scenes](../management/materialized-views/materialized-view-overview.md#how-materialized-views-work) for details.',"https://docs.microsoft.com/en-us/azure/kusto/query/materialized-view-function","materialized-view-function.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"max","Returns the maximum value across the group.","* Can be used only in context of aggregation inside [summarize](summarizeoperator.md)\r\n\r\n## Syntax\r\n\r\n`summarize` `max(`*Expr*`)`\r\n\r\n## Arguments\r\n\r\n* *Expr*: Expression that will be used for aggregation calculation. \r\n\r\n## Returns\r\n\r\nThe maximum value of *Expr* across the group.\r\n\r\n> [!TIP]\r\n> This gives you the min or max on its own - for example, the highest or lowest price.\r\n> But if you want other columns in the row - for example, the name of the supplier with the lowest\r\n> price - use [arg_max](arg-max-aggfunction.md) or [arg_min](arg-min-aggfunction.md).","","https://docs.microsoft.com/en-us/azure/kusto/query/max-aggfunction","")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"max_of","Returns the maximum value of several evaluated numeric expressions.","```\r\nmax_of(10, 1, -3, 17) == 17\r\n```\r\n\r\n## Syntax\r\n\r\n`max_of` `(`*expr_1*`,` *expr_2* ...`)`\r\n\r\n## Arguments\r\n\r\n* *expr_i*: A scalar expression, to be evaluated.\r\n\r\n- All arguments must be of the same type.\r\n- Maximum of 64 arguments is supported.\r\n\r\n## Returns\r\n\r\nThe maximum value of all argument expressions.","```\r\nprint result = max_of(10, 1, -3, 17) \r\n```\r\n\r\n|result|\r\n|---|\r\n|17|","https://docs.microsoft.com/en-us/azure/kusto/query/max-offunction","max-offunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"maxif","Returns the maximum value across the group for which *Predicate* evaluates to `true`.","* Can be used only in context of aggregation inside [summarize](summarizeoperator.md)\r\n\r\nSee also - [max()](max-aggfunction.md) function, which returns the maximum value across the group without predicate expression.\r\n\r\n## Syntax\r\n\r\n`summarize` `maxif(`*Expr*`,`*Predicate*`)`\r\n\r\n## Arguments\r\n\r\n* *Expr*: Expression that will be used for aggregation calculation. \r\n* *Predicate*: predicate that if true, the *Expr* calculated value will be checked for maximum.\r\n\r\n## Returns\r\n\r\nThe maximum value of *Expr* across the group for which *Predicate* evaluates to `true`.","```\r\nrange x from 1 to 100 step 1\r\n| summarize maxif(x, x < 50)\r\n```\r\n\r\n|maxif_x|\r\n|---|\r\n|49|","https://docs.microsoft.com/en-us/azure/kusto/query/maxif-aggfunction","maxif-aggfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"min","Returns the minimum value across the group.","* Can be used only in context of aggregation inside [summarize](summarizeoperator.md)\r\n\r\n## Syntax\r\n\r\n`summarize` `min(`*Expr*`)`\r\n\r\n## Arguments\r\n\r\n* *Expr*: Expression that will be used for aggregation calculation. \r\n\r\n## Returns\r\n\r\nThe minimum value of *Expr* across the group.\r\n\r\n> [!TIP]\r\n> This gives you the min or max on its own - for example, the highest or lowest price. \r\n> But if you want other columns in the row - for example, the name of the supplier with the lowest \r\n> price - use [arg_max](arg-max-aggfunction.md) or [arg_min](arg-min-aggfunction.md).","","https://docs.microsoft.com/en-us/azure/kusto/query/min-aggfunction","")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"min_of","Returns the minimum value of several evaluated numeric expressions.","```\r\nmin_of(10, 1, -3, 17) == -3\r\n```\r\n\r\n## Syntax\r\n\r\n`min_of` `(`*expr_1*`,` *expr_2* ...`)`\r\n\r\n## Arguments\r\n\r\n* *expr_i*: A scalar expression, to be evaluated.\r\n\r\n- All arguments must be of the same type.\r\n- Maximum of 64 arguments is supported.\r\n\r\n## Returns\r\n\r\nThe minimum value of all argument expressions.","```\r\nprint result=min_of(10, 1, -3, 17) \r\n```\r\n\r\n|result|\r\n|---|\r\n|-3|","https://docs.microsoft.com/en-us/azure/kusto/query/min-offunction","min-offunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"minif","Returns the minimum value across the group for which *Predicate* evaluates to `true`.","* Can be used only in context of aggregation inside [summarize](summarizeoperator.md)\r\n\r\nSee also - [min()](min-aggfunction.md) function, which returns the minimum value across the group without predicate expression.\r\n\r\n## Syntax\r\n\r\n`summarize` `minif(`*Expr*`,`*Predicate*`)`\r\n\r\n## Arguments\r\n\r\n* *Expr*: Expression that will be used for aggregation calculation.\r\n* *Predicate*: predicate that if true, the *Expr* calculated value will be checked for minimum.\r\n\r\n## Returns\r\n\r\nThe minimum value of *Expr* across the group for which *Predicate* evaluates to `true`.","```\r\nrange x from 1 to 100 step 1\r\n| summarize minif(x, x > 50)\r\n```\r\n\r\n|minif_x|\r\n|---|\r\n|51|","https://docs.microsoft.com/en-us/azure/kusto/query/minif-aggfunction","minif-aggfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"monthofyear","Returns the integer number represents the month number of the given year.",'Another alias: getmonth()\r\n\r\n```\r\nmonthofyear(datetime("2015-12-14"))\r\n```\r\n\r\n## Syntax\r\n\r\n`monthofyear(`*a_date*`)`\r\n\r\n## Arguments\r\n\r\n* `a_date`: A `datetime`.\r\n\r\n## Returns\r\n\r\n`month number` of the given year.',"","https://docs.microsoft.com/en-us/azure/kusto/query/monthofyearfunction","")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.OperatorToken,"mv-apply","Applies a subquery to each record, and returns the union of the results of\r\nall subqueries.","For example, assume a table `T` has a column `Metric` of type `dynamic`\r\nwhose values are arrays of `real` numbers. The following query will locate the\r\ntwo biggest values in each `Metric` value, and return the records corresponding\r\nto these values.\r\n\r\n```\r\nT | mv-apply Metric to typeof(real) on \r\n(\r\n   top 2 by Metric desc\r\n)\r\n```\r\n\r\nThe `mv-apply` operator has the following\r\nprocessing steps:\r\n\r\n1. Uses the [`mv-expand`](./mvexpandoperator.md) operator to expand each record\r\n   in the input into subtables.\r\n1. Applies the subquery for each of the subtables.\r\n1. Adds zero or more columns to the resulting subtable. These columns contain the values of the source columns that aren't expanded, and are repeated where needed.\r\n1. Returns the union of the results.\r\n\r\nThe `mv-apply` operator gets the following inputs:\r\n\r\n1. One or more expressions that evaluate into dynamic arrays to expand.\r\n   The number of records in each expanded subtable is the maximum length of\r\n   each of those dynamic arrays. Null values are added where multiple expressions are specified and the corresponding arrays have different lengths.\r\n1. Optionally, the names to assign the values of the expressions after expansion.\r\n   These names become the columns names in the subtables.\r\n   If not specified, the original name of the column is used when the expression is a column reference. A random name is used otherwise. \r\n   > [!NOTE]\r\n   > It is recommended to use the default column names.\r\n1. The data types of the elements of those dynamic arrays, after expansion.\r\n   These become the column types of the columns in the subtables.\r\n   If not specified, `dynamic` is used.\r\n1. Optionally, the name of a column to add to the subtables that specifies the\r\n   0-based index of the element in the array that resulted in the subtable record.\r\n1. Optionally, the maximum number of array elements to expand.\r\n\r\nThe `mv-apply` operator can be thought of as a generalization of the\r\n[`mv-expand`](./mvexpandoperator.md) operator (in fact, the latter can be implemented\r\nby the former, if the subquery includes only projections.)\r\n\r\n## Syntax\r\n\r\n*T* `|` `mv-apply` [*ItemIndex*] *ColumnsToExpand* [*RowLimit*] `on` `(` *SubQuery* `)`\r\n\r\nWhere *ItemIndex* has the syntax:\r\n\r\n`with_itemindex` `=` *IndexColumnName*\r\n\r\n*ColumnsToExpand* is a comma-separated list of one or more elements of the form:\r\n\r\n[*Name* `=`] *ArrayExpression* [`to` `typeof` `(`*Typename*`)`]\r\n\r\n*RowLimit* is simply:\r\n\r\n`limit` *RowLimit*\r\n\r\nand *SubQuery* has the same syntax of any query statement.\r\n\r\n## Arguments\r\n\r\n* *ItemIndex*: If used, indicates the name of a column of type `long` that is appended to the input as part of the array-expansion phase and indicates the 0-based array index of the\r\n  expanded value.\r\n* *Name*: If used, the name to assign the array-expanded values of each\r\n  array-expanded expression.\r\n  If not specified, the name of the column will be used if available.\r\n  A random name is generated if *ArrayExpression* is not a simple column name.\r\n* *ArrayExpression*: An expression of type `dynamic` whose values will be array-expanded.\r\n  If the expression is the name of a column in the input, the input column is\r\n  removed from the input and a new column of the same name (or *ColumnName* if\r\n  specified) appears in the output.\r\n* *Typename*: If used, the name of the type that the individual elements of the\r\n  `dynamic` array *ArrayExpression* take. Elements that do not conform to this\r\n  type will be replaced by a null value.\r\n  (If unspecified, `dynamic` is used by default.)\r\n* *RowLimit*: If used, a limit on the number of records to generate from each\r\n  record of the input.\r\n  (If unspecified, 2147483647 is used.)\r\n* *SubQuery*: A tabular query expression with an implicit tabular source that gets\r\n  applied to each array-expanded subtable.\r\n\r\n**Notes**\r\n\r\n* Unlike the [`mv-expand`](./mvexpandoperator.md) operator, the `mv-apply` operator\r\n  supports array expansion only. There's no support for expanding property bags.",'## Getting the largest element from the array\r\n\r\n```\r\nlet _data =\r\nrange x from 1 to 8 step 1\r\n| summarize l=make_list(x) by xMod2 = x % 2;\r\n_data\r\n| mv-apply element=l to typeof(long) on \r\n(\r\n   top 1 by element\r\n)\r\n```\r\n\r\n|`xMod2`|l           |element|\r\n|-----|------------|-------|\r\n|1    |[1, 3, 5, 7]|7      |\r\n|0    |[2, 4, 6, 8]|8      |\r\n\r\n## Calculating the sum of the largest two elements in an array\r\n\r\n```\r\nlet _data =\r\nrange x from 1 to 8 step 1\r\n| summarize l=make_list(x) by xMod2 = x % 2;\r\n_data\r\n| mv-apply l to typeof(long) on\r\n(\r\n   top 2 by l\r\n   | summarize SumOfTop2=sum(l)\r\n)\r\n```\r\n\r\n|`xMod2`|l        |SumOfTop2|\r\n|-----|---------|---------|\r\n|1    |[1,3,5,7]|12       |\r\n|0    |[2,4,6,8]|14       |\r\n\r\n## Using `with_itemindex` for working with a subset of the array\r\n\r\n```\r\nlet _data =\r\nrange x from 1 to 10 step 1\r\n| summarize l=make_list(x) by xMod2 = x % 2;\r\n_data\r\n| mv-apply with_itemindex=index element=l to typeof(long) on \r\n(\r\n   // here you have \'index\' column\r\n   where index >= 3\r\n)\r\n| project index, element\r\n```\r\n\r\n|index|element|\r\n|---|---|\r\n|3|7|\r\n|4|9|\r\n|3|8|\r\n|4|10|\r\n\r\n## Using the `mv-apply` operator to sort the output of `make_list` aggregate by some key\r\n\r\n```\r\ndatatable(command:string, command_time:datetime, user_id:string)\r\n[\r\n\t\'chmod\',\t\tdatetime(2019-07-15),\t"user1",\r\n\t\'ls\',\t\t\tdatetime(2019-07-02),\t"user1",\r\n\t\'dir\',\t\t\tdatetime(2019-07-22),\t"user1",\r\n\t\'mkdir\',\t\tdatetime(2019-07-14),\t"user1",\r\n\t\'rm\',\t\t\tdatetime(2019-07-27),\t"user1",\r\n\t\'pwd\',\t\t\tdatetime(2019-07-25),\t"user1",\r\n\t\'rm\',\t\t\tdatetime(2019-07-23),\t"user2",\r\n\t\'pwd\',\t\t\tdatetime(2019-07-25),\t"user2",\r\n]\r\n| summarize commands_details = make_list(pack(\'command\', command, \'command_time\', command_time)) by user_id\r\n| mv-apply command_details = commands_details on\r\n(\r\n    order by todatetime(command_details[\'command_time\']) asc\r\n    | summarize make_list(tostring(command_details[\'command\']))\r\n)\r\n| project-away commands_details\r\n```\r\n\r\n|`user_id`|`list_command_details_command`|\r\n|---|---|\r\n|user1|[<br>  "ls",<br>  "mkdir",<br>  "chmod",<br>  "dir",<br>  "pwd",<br>  "rm"<br>]|\r\n|user2|[<br>  "rm",<br>  "pwd"<br>]|\r\n\r\n## See also\r\n\r\n* [mv-expand](./mvexpandoperator.md) operator.',"https://docs.microsoft.com/en-us/azure/kusto/query/mv-applyoperator","mv-applyoperator.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.OperatorToken,"mv-expand","Expands multi-value array or property bag.","`mv-expand` is applied on a [dynamic](./scalar-data-types/dynamic.md)-typed array or property bag column so that each value in the collection gets a separate row. All the other columns in an expanded row are duplicated. \r\n\r\n## Syntax\r\n\r\n*T* `| mv-expand ` [`bagexpansion=`(`bag` | `array`)] [`with_itemindex=`*IndexColumnName*] *ColumnName* [`,` *ColumnName* ...] [`limit` *Rowlimit*]\r\n\r\n*T* `| mv-expand ` [`bagexpansion=`(`bag` | `array`)] [*Name* `=`] *ArrayExpression* [`to typeof(`*Typename*`)`] [, [*Name* `=`] *ArrayExpression* [`to typeof(`*Typename*`)`] ...] [`limit` *Rowlimit*]\r\n\r\n## Arguments\r\n\r\n* *ColumnName:* In the result, arrays in the named column are expanded to multiple rows. \r\n* *ArrayExpression:* An expression yielding an array. If this form is used, a new column is added and the existing one is preserved.\r\n* *Name:* A name for the new column.\r\n* *Typename:* Indicates the underlying type of the array's elements, which becomes the type of the column produced by the `mv-apply` operator. The operation of applying type is cast-only and doesn't include parsing or type-conversion. Array elements that do not conform with the declared type will become `null` values.\r\n* *RowLimit:* The maximum number of rows generated from each original row. The default is 2147483647. \r\n  > [!Note]\r\n  > The legacy and obsolete form of the operator `mvexpand` has a default row limit of 128.\r\n* *IndexColumnName:* If `with_itemindex` is specified, the output will include an additional column (named *IndexColumnName*), which contains the index (starting at 0) of the item in the original expanded collection. \r\n\r\n## Returns\r\n\r\nMultiple rows for each of the values in any array that are in the named column or in the array expression.\r\nIf several columns or expressions are specified, they're expanded in parallel. For each input row, there will be as many output rows as there are elements in the longest expanded expression (shorter lists are padded with nulls). If the value in a row is an empty array, the row expands to nothing (won't show in the result set). However, if the value in a row isn't an array, the row is kept as is in the result set. \r\n\r\nThe expanded column always has dynamic type. Use a cast such as `todatetime()` or `tolong()` if you want to compute or aggregate values.\r\n\r\nTwo modes of property-bag expansions are supported:\r\n\r\n* `bagexpansion=bag`: Property bags are expanded into single-entry property bags. This mode is the default expansion.\r\n* `bagexpansion=array`: Property bags are expanded into two-element `[`*key*`,`*value*`]` array structures,\r\n  allowing uniform access to keys and values (also, for example, running a distinct-count aggregation\r\n  over property names).",'### Single Column\r\n\r\nA simple expansion of a single column:\r\n\r\n```\r\ndatatable (a:int, b:dynamic)[1,dynamic({"prop1":"a", "prop2":"b"})]\r\n| mv-expand b \r\n```\r\n\r\n|a|b|\r\n|---|---|\r\n|1|{"prop1":"a"}|\r\n|1|{"prop2":"b"}|\r\n\r\n### Zipped two columns\r\n\r\nExpanding two columns will first \'zip\' the applicable columns and then expand them:\r\n\r\n```\r\ndatatable (a:int, b:dynamic, c:dynamic)[1,dynamic({"prop1":"a", "prop2":"b"}), dynamic([5, 4, 3])]\r\n| mv-expand b, c\r\n```\r\n\r\n|a|b|c|\r\n|---|---|---|\r\n|1|{"prop1":"a"}|5|\r\n|1|{"prop2":"b"}|4|\r\n|1||3|\r\n\r\n### Cartesian product of two columns\r\n\r\nIf you want to get a Cartesian product of expanding two columns, expand one after the other:\r\n\r\n```\r\ndatatable (a:int, b:dynamic, c:dynamic)\r\n  [\r\n  1,\r\n  dynamic({"prop1":"a", "prop2":"b"}),\r\n  dynamic([5, 6])\r\n  ]\r\n| mv-expand b\r\n| mv-expand c\r\n```\r\n\r\n|a|b|c|\r\n|---|---|---|\r\n|1|{  "prop1": "a"}|5|\r\n|1|{  "prop1": "a"}|6|\r\n|1|{  "prop2": "b"}|5|\r\n|1|{  "prop2": "b"}|6|\r\n\r\n### Convert output\r\n\r\nIf you want to force the output of an mv-expand to a certain type (default is dynamic), use `to typeof`:\r\n\r\n```\r\ndatatable (a:string, b:dynamic, c:dynamic)["Constant", dynamic([1,2,3,4]), dynamic([6,7,8,9])]\r\n| mv-expand b, c to typeof(int)\r\n| getschema \r\n```\r\n\r\nColumnName|ColumnOrdinal|DateType|ColumnType\r\n-|-|-|-\r\na|0|System.String|string\r\nb|1|System.Object|dynamic\r\nc|2|System.Int32|int\r\n\r\nNotice column `b` is coming out as `dynamic` while `c` is coming out as `int`.\r\n\r\n### Using with_itemindex\r\n\r\nExpansion of an array with `with_itemindex`:\r\n\r\n```\r\nrange x from 1 to 4 step 1\r\n| summarize x = make_list(x)\r\n| mv-expand with_itemindex=Index x\r\n```\r\n\r\n|x|Index|\r\n|---|---|\r\n|1|0|\r\n|2|1|\r\n|3|2|\r\n|4|3|\r\n\r\n## See also\r\n\r\n* See [Chart count of live activities over time](./samples.md#chart-concurrent-sessions-over-time) for more examples.\r\n* [mv-apply](./mv-applyoperator.md) operator.\r\n* [summarize make_list()](makelist-aggfunction.md), which is the opposite function of mv-expand.\r\n* [bag_unpack()](bag-unpackplugin.md) plugin for expanding dynamic JSON objects into columns using property bag keys.',"https://docs.microsoft.com/en-us/azure/kusto/query/mvexpandoperator","mvexpandoperator.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"new_guid","Returns a random GUID (Globally Unique Identifier).","```\r\nnew_guid()\r\n```\r\n\r\n## Syntax\r\n\r\n* `new_guid()` - generates a new value of type `guid`.","","https://docs.microsoft.com/en-us/azure/kusto/query/newguidfunction","")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"next","Returns the value of a column in a row that it at some offset following the\r\ncurrent row in a [serialized row set](./windowsfunctions.md#serialized-row-set).","## Syntax\r\n\r\n`next(column)`\r\n\r\n`next(column, offset)`\r\n\r\n`next(column, offset, default_value)`\r\n\r\n## Arguments\r\n\r\n* `column`: the column to get the values from.\r\n* `offset`: the offset to go ahead in rows. When no offset is specified a default offset 1 is used.\r\n* `default_value`: the default value to be used when there is no next rows to take the value from. When no default value is specified, null is used.","```\r\nTable | serialize | extend nextA = next(A,1)\r\n| extend diff = A - nextA\r\n| where diff > 1\r\n\r\nTable | serialize nextA = next(A,1,10)\r\n| extend diff = A - nextA\r\n| where diff <= 10\r\n```","https://docs.microsoft.com/en-us/azure/kusto/query/nextfunction","nextfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"not","Reverses the value of its `bool` argument.","```\r\nnot(false) == true\r\n```\r\n\r\n## Syntax\r\n\r\n`not(`*expr*`)`\r\n\r\n## Arguments\r\n\r\n* *expr*: A `bool` expression to be reversed.\r\n\r\n## Returns\r\n\r\nReturns the reversed logical value of its `bool` argument.","","https://docs.microsoft.com/en-us/azure/kusto/query/notfunction","")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.OperatorToken,"not-between","Matches the input that is outside the inclusive range.","```\r\nTable1 | where Num1 !between (1 .. 10)\r\nTable1 | where Time !between (datetime(2017-01-01) .. datetime(2017-01-01))\r\n```\r\n\r\n`!between` can operate on any numeric, datetime, or timespan expression.\r\n\r\n## Syntax\r\n\r\n*T* `|` `where` *expr* `!between` `(`*leftRange*` .. `*rightRange*`)`   \r\n\r\nIf *expr* expression is datetime - another syntactic sugar syntax is provided:\r\n\r\n*T* `|` `where` *expr* `!between` `(`*leftRangeDateTime*` .. `*rightRangeTimespan*`)`   \r\n\r\n## Arguments\r\n\r\n* *T* - The tabular input whose records are to be matched.\r\n* *expr* - the expression to filter.\r\n* *leftRange* - expression of the left range (inclusive).\r\n* *rightRange* - expression of the right range (inclusive).\r\n\r\n## Returns\r\n\r\nRows in *T* for which the predicate of (*expr* < *leftRange* or *expr* > *rightRange*) evaluates to `true`.","**Filtering numeric values using '!between' operator**  \r\n\r\n```\r\nrange x from 1 to 10 step 1\r\n| where x !between (5 .. 9)\r\n```\r\n\r\n|x|\r\n|---|\r\n|1|\r\n|2|\r\n|3|\r\n|4|\r\n|10|\r\n\r\n**Filtering datetime using 'between' operator**  \r\n\r\n```\r\nStormEvents\r\n| where StartTime !between (datetime(2007-07-27) .. datetime(2007-07-30))\r\n| count \r\n```\r\n\r\n|Count|\r\n|---|\r\n|58590|\r\n\r\n```\r\nStormEvents\r\n| where StartTime !between (datetime(2007-07-27) .. 3d)\r\n| count \r\n```\r\n\r\n|Count|\r\n|---|\r\n|58590|","https://docs.microsoft.com/en-us/azure/kusto/query/notbetweenoperator","notbetweenoperator.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"now","Returns the current UTC clock time, optionally offset by a given timespan.\r\nThis function can be used multiple times in a statement and the clock time being referenced will be the same for all instances.","```\r\nnow()\r\nnow(-2d)\r\n```\r\n\r\n## Syntax\r\n\r\n`now(`[*offset*]`)`\r\n\r\n## Arguments\r\n\r\n* *offset*: A `timespan`, added to the current UTC clock time. Default: 0.\r\n\r\n## Returns\r\n\r\nThe current UTC clock time as a `datetime`.\r\n\r\n`now()` + *offset*","Determines the interval since the event identified by the predicate:\r\n\r\n```\r\nT | where ... | extend Elapsed=now() - Timestamp\r\n```","https://docs.microsoft.com/en-us/azure/kusto/query/nowfunction","nowfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.OperatorToken,"order","Sort the rows of the input table into order by one or more columns.","```\r\nT | order by country asc, price desc\r\n```\r\n\r\n> [!NOTE]\r\n> The order operator is an alias to the sort operator. For more information, see [sort operator](sortoperator.md)\r\n\r\n## Syntax\r\n\r\n*T* `| order by` *column* [`asc` | `desc`] [`nulls first` | `nulls last`] [`,` ...]\r\n\r\n## Arguments\r\n\r\n* *T*: The table input to sort.\r\n* *column*: Column of *T* by which to sort. The type of the values must be numeric, date, time or string.\r\n* `asc` Sort by into ascending order, low to high. The default is `desc`, descending high to low.\r\n* `nulls first` (the default for `asc` order) will place the null values at the beginning and `nulls last` (the default for `desc` order) will place the null values at the end.","","https://docs.microsoft.com/en-us/azure/kusto/query/orderoperator","")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"pack","Creates a `dynamic` object (property bag) from a list of names and values.","Alias to `pack_dictionary()` function.\r\n\r\n## Syntax\r\n\r\n`pack(`*key1*`,` *value1*`,` *key2*`,` *value2*`,... )`\r\n\r\n## Arguments\r\n\r\n* An alternating list of keys and values (the total length of the list must be even)\r\n* All keys must be non-empty constant strings",'The following example returns `{"Level":"Information","ProcessID":1234,"Data":{"url":"www.bing.com"}}`:\r\n\r\n```\r\npack("Level", "Information", "ProcessID", 1234, "Data", pack("url", "www.bing.com"))\r\n```\r\n\r\nLets take 2 tables, SmsMessages and MmsMessages:\r\n\r\nTable SmsMessages \r\n\r\n|SourceNumber |TargetNumber| CharsCount\r\n|---|---|---\r\n|555-555-1234 |555-555-1212 | 46 \r\n|555-555-1234 |555-555-1213 | 50 \r\n|555-555-1212 |555-555-1234 | 32 \r\n\r\nTable MmsMessages \r\n\r\n|SourceNumber |TargetNumber| AttachmentSize | AttachmentType | AttachmentName\r\n|---|---|---|---|---\r\n|555-555-1212 |555-555-1213 | 200 | jpeg | Pic1\r\n|555-555-1234 |555-555-1212 | 250 | jpeg | Pic2\r\n|555-555-1234 |555-555-1213 | 300 | png | Pic3\r\n\r\nThe following query:\r\n\r\n```\r\nSmsMessages \r\n| extend Packed=pack("CharsCount", CharsCount) \r\n| union withsource=TableName kind=inner \r\n( MmsMessages \r\n  | extend Packed=pack("AttachmentSize", AttachmentSize, "AttachmentType", AttachmentType, "AttachmentName", AttachmentName))\r\n| where SourceNumber == "555-555-1234"\r\n``` \r\n\r\nReturns:\r\n\r\n|TableName |SourceNumber |TargetNumber | Packed\r\n|---|---|---|---\r\n|SmsMessages|555-555-1234 |555-555-1212 | {"CharsCount": 46}\r\n|SmsMessages|555-555-1234 |555-555-1213 | {"CharsCount": 50}\r\n|MmsMessages|555-555-1234 |555-555-1212 | {"AttachmentSize": 250, "AttachmentType": "jpeg", "AttachmentName": "Pic2"}\r\n|MmsMessages|555-555-1234 |555-555-1213 | {"AttachmentSize": 300, "AttachmentType": "png", "AttachmentName": "Pic3"}',"https://docs.microsoft.com/en-us/azure/kusto/query/packfunction","packfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"pack_all","Creates a `dynamic` object (property bag) from all the columns of the tabular expression.","> [!NOTE]\r\n> The representation of the returned object isn't guaranteed to be byte-level-compatible between runs. For example, properties that appear in the bag may appear in a different order.\r\n\r\n## Syntax\r\n\r\n`pack_all()`",'Given a table SmsMessages \r\n\r\n|SourceNumber |TargetNumber| CharsCount\r\n|---|---|---\r\n|555-555-1234 |555-555-1212 | 46 \r\n|555-555-1234 |555-555-1213 | 50 \r\n|555-555-1212 |555-555-1234 | 32 \r\n\r\nThe following query:\r\n\r\n```\r\ndatatable(SourceNumber:string,TargetNumber:string,CharsCount:long)\r\n[\r\n\'555-555-1234\',\'555-555-1212\',46,\r\n\'555-555-1234\',\'555-555-1213\',50,\r\n\'555-555-1212\',\'555-555-1234\',32\r\n]\r\n| extend Packed=pack_all()\r\n```\r\n\r\nReturns:\r\n\r\n|TableName |SourceNumber |TargetNumber | Packed\r\n|---|---|---|---\r\n|SmsMessages|555-555-1234 |555-555-1212 | {"SourceNumber":"555-555-1234", "TargetNumber":"555-555-1212", "CharsCount": 46}\r\n|SmsMessages|555-555-1234 |555-555-1213 | {"SourceNumber":"555-555-1234", "TargetNumber":"555-555-1213", "CharsCount": 50}\r\n|SmsMessages|555-555-1212 |555-555-1234 | {"SourceNumber":"555-555-1212", "TargetNumber":"555-555-1234", "CharsCount": 32}',"https://docs.microsoft.com/en-us/azure/kusto/query/packallfunction","packallfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"pack_array","Packs all input values into a dynamic array.","## Syntax\r\n\r\n`pack_array(`*Expr1*`[`,` *Expr2*]`)`\r\n\r\n## Arguments\r\n\r\n* *Expr1...N*: Input expressions to be packed into a dynamic array.\r\n\r\n## Returns\r\n\r\nDynamic array which includes the values of Expr1, Expr2, ... , ExprN.",'```\r\nrange x from 1 to 3 step 1\r\n| extend y = x * 2\r\n| extend z = y * 2\r\n| project pack_array(x,y,z)\r\n```\r\n\r\n|Column1|\r\n|---|\r\n|[1,2,4]|\r\n|[2,4,8]|\r\n|[3,6,12]|\r\n\r\n```\r\nrange x from 1 to 3 step 1\r\n| extend y = tostring(x * 2)\r\n| extend z = (x * 2) * 1s\r\n| project pack_array(x,y,z)\r\n```\r\n\r\n|Column1|\r\n|---|\r\n|[1,"2","00:00:02"]|\r\n|[2,"4","00:00:04"]|\r\n|[3,"6","00:00:06"]|',"https://docs.microsoft.com/en-us/azure/kusto/query/packarrayfunction","packarrayfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"pack_dictionary","An alias for [`pack()`](packfunction.md).","","","https://docs.microsoft.com/en-us/azure/kusto/query/packdictionaryfunction","")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.OperatorToken,"parse","Evaluates a string expression and parses its value into one or more calculated columns. The calculated columns will have nulls, for unsuccessfully parsed strings.\r\nFor more information, see the [parse-where operator](parsewhereoperator.md).",'```\r\nT | parse Text with "ActivityName=" name ", ActivityType=" type\r\n```\r\n\r\n## Syntax\r\n\r\n*T* `| parse` [`kind=regex` [`flags=regex_flags`] |`simple`|`relaxed`] *Expression* `with` `*` (*StringConstant* *ColumnName* [`:` *ColumnType*]) `*`...\r\n\r\n## Arguments\r\n\r\n* *T*: The input table.\r\n* kind:\r\n\t* simple (the default): StringConstant is a regular string value and the match is strict. All string delimiters should appear in the parsed string, and all extended columns must match the required types.\r\n\t\t\r\n\t* regex: StringConstant may be a regular expression and the match is strict. All string delimiters, which can be a regex for this mode, should appear in the parsed string, and all extended columns must match the required types.\r\n\t\r\n\t* flags: Flags to be used in regex mode like `U` (Ungreedy), `m` (multi-line mode), `s` (match new line `\\n`), `i` (case-insensitive) in [RE2 flags](re2.md).\r\n\t\t\r\n\t* relaxed: StringConstant is a regular string value and the match is relaxed. All string delimiters should appear in the parsed string, but extended columns may partially match the required types. Extended columns that didn\'t match the required types will get the value null.\r\n* *Expression*: An expression that evaluates to a string.\r\n* *ColumnName:* The name of a column to assign a value to, extracted from the string expression. \r\n  \r\n* *ColumnType:* Optional. The scalar value that indicates the type to convert the value to. The default is the `string` type.\r\n\r\n## Returns\r\n\r\nThe input table, extended according to the list of columns that are\r\nprovided to the operator.\r\n\r\n**Tips**\r\n\r\n* Use [`project`](projectoperator.md) if you also want to drop or rename some columns.\r\n* Use * in the pattern, to skip junk values. \r\n    > [!NOTE] \r\n    > The `*` can\'t be used after a `string` type column.\r\n* The parse pattern may start with *ColumnName* and not only with *StringConstant*.\r\n* If the parsed *Expression* isn\'t of type `string`, it will be converted to type `string`.\r\n* If regex mode is used, there\'s an option to add regex flags to control the entire regex that is used in the parse.\r\n* In regex mode, parse will translate the pattern to a regex. Use [RE2 syntax](re2.md) to do the matching, and use numbered captured groups that are handled internally.\r\n    For example:\r\n \r\n\r\n```\r\n\tparse kind=regex Col with * <regex1> var1:string <regex2> var2:long\r\n\t```\r\n\tIn the parse statement, the regex that will be internally generated by the parse is `.*?<regex1>(.*?)<regex2>(\\-\\d+)`.\r\n\t\t\r\n\t* `*` was translated to `.*?`.\r\n\t\t\r\n\t* `string` was translated to `.*?`.\r\n\t\t\r\n\t* `long` was translated to `\\-\\d+`.\r\n## Examples\r\nThe `parse` operator provides a streamlined way to `extend` a table by using multiple `extract` applications on the same `string` expression. This result is useful, when the table has a `string` column that contains several values that you want to break into individual columns. For example, a column that was produced by a developer trace ("`printf`"/"`Console.WriteLine`") statement.\r\nIn the example below, assume that the column `EventText` of table `Traces` contains\r\nstrings of the form `Event: NotifySliceRelease (resourceName={0}, totalSlices= {1}, sliceNumber={2}, lockTime={3}, releaseTime={4}, previousLockTime={5})`.\r\nThe operation will extend the table with six columns: `resourceName`, `totalSlices`, `sliceNumber`, `lockTime `, `releaseTime`, `previousLockTime`, `Month`, and `Day`. \r\n\r\n```\r\n\r\nlet Traces = datatable(EventText:string)\r\n[\r\n"Event: NotifySliceRelease (resourceName=PipelineScheduler, totalSlices=27, sliceNumber=23, lockTime=02/17/2016 08:40:01, releaseTime=02/17/2016 08:40:01, previousLockTime=02/17/2016 08:39:01)",\r\n"Event: NotifySliceRelease (resourceName=PipelineScheduler, totalSlices=27, sliceNumber=15, lockTime=02/17/2016 08:40:00, releaseTime=02/17/2016 08:40:00, previousLockTime=02/17/2016 08:39:00)",\r\n"Event: NotifySliceRelease (resourceName=PipelineScheduler, totalSlices=27, sliceNumber=20, lockTime=02/17/2016 08:40:01, releaseTime=02/17/2016 08:40:01, previousLockTime=02/17/2016 08:39:01)",\r\n"Event: NotifySliceRelease (resourceName=PipelineScheduler, totalSlices=27, sliceNumber=22, lockTime=02/17/2016 08:41:01, releaseTime=02/17/2016 08:41:00, previousLockTime=02/17/2016 08:40:01)",\r\n"Event: NotifySliceRelease (resourceName=PipelineScheduler, totalSlices=27, sliceNumber=16, lockTime=02/17/2016 08:41:00, releaseTime=02/17/2016 08:41:00, previousLockTime=02/17/2016 08:40:00)"\r\n];\r\nTraces  \r\n| parse EventText with * "resourceName=" resourceName ", totalSlices=" totalSlices:long * "sliceNumber=" sliceNumber:long * "lockTime=" lockTime ", releaseTime=" releaseTime:date "," * "previousLockTime=" previousLockTime:date ")" *  \r\n| project resourceName ,totalSlices , sliceNumber , lockTime , releaseTime , previousLockTime\r\n\r\n```\r\n|resourceName|totalSlices|sliceNumber|lockTime|releaseTime|previousLockTime|\r\n|---|---|---|---|---|---|\r\n|PipelineScheduler|27|15|02/17/2016 08:40:00|2016-02-17 08:40:00.0000000|2016-02-17 08:39:00.0000000|\r\n|PipelineScheduler|27|23|02/17/2016 08:40:01|2016-02-17 08:40:01.0000000|2016-02-17 08:39:01.0000000|\r\n|PipelineScheduler|27|20|02/17/2016 08:40:01|2016-02-17 08:40:01.0000000|2016-02-17 08:39:01.0000000|\r\n|PipelineScheduler|27|16|02/17/2016 08:41:00|2016-02-17 08:41:00.0000000|2016-02-17 08:40:00.0000000|\r\n|PipelineScheduler|27|22|02/17/2016 08:41:01|2016-02-17 08:41:00.0000000|2016-02-17 08:40:01.0000000|\r\n**For regex mode**\r\n\r\n```\r\n\r\nlet Traces = datatable(EventText:string)\r\n[\r\n"Event: NotifySliceRelease (resourceName=PipelineScheduler, totalSlices=27, sliceNumber=23, lockTime=02/17/2016 08:40:01, releaseTime=02/17/2016 08:40:01, previousLockTime=02/17/2016 08:39:01)",\r\n"Event: NotifySliceRelease (resourceName=PipelineScheduler, totalSlices=27, sliceNumber=15, lockTime=02/17/2016 08:40:00, releaseTime=02/17/2016 08:40:00, previousLockTime=02/17/2016 08:39:00)",\r\n"Event: NotifySliceRelease (resourceName=PipelineScheduler, totalSlices=27, sliceNumber=20, lockTime=02/17/2016 08:40:01, releaseTime=02/17/2016 08:40:01, previousLockTime=02/17/2016 08:39:01)",\r\n"Event: NotifySliceRelease (resourceName=PipelineScheduler, totalSlices=27, sliceNumber=22, lockTime=02/17/2016 08:41:01, releaseTime=02/17/2016 08:41:00, previousLockTime=02/17/2016 08:40:01)",\r\n"Event: NotifySliceRelease (resourceName=PipelineScheduler, totalSlices=27, sliceNumber=16, lockTime=02/17/2016 08:41:00, releaseTime=02/17/2016 08:41:00, previousLockTime=02/17/2016 08:40:00)"\r\n];\r\nTraces  \r\n| parse kind = regex EventText with "(.*?)[a-zA-Z]*=" resourceName @", totalSlices=\\s*\\d+\\s*.*?sliceNumber=" sliceNumber:long  ".*?(previous)?lockTime=" lockTime ".*?releaseTime=" releaseTime ".*?previousLockTime=" previousLockTime:date "\\\\)"  \r\n| project resourceName , sliceNumber , lockTime , releaseTime , previousLockTime\r\n\r\n```\r\n|resourceName|sliceNumber|lockTime|releaseTime|previousLockTime|\r\n|---|---|---|---|---|\r\n|PipelineScheduler|15|02/17/2016 08:40:00, |02/17/2016 08:40:00, |2016-02-17 08:39:00.0000000|\r\n|PipelineScheduler|23|02/17/2016 08:40:01, |02/17/2016 08:40:01, |2016-02-17 08:39:01.0000000|\r\n|PipelineScheduler|20|02/17/2016 08:40:01, |02/17/2016 08:40:01, |2016-02-17 08:39:01.0000000|\r\n|PipelineScheduler|16|02/17/2016 08:41:00, |02/17/2016 08:41:00, |2016-02-17 08:40:00.0000000|\r\n|PipelineScheduler|22|02/17/2016 08:41:01, |02/17/2016 08:41:00, |2016-02-17 08:40:01.0000000|\r\n**For regex mode using regex flags**\r\nIf you\'re interested in getting the resourceName only, use this query:\r\n\r\n```\r\n\r\nlet Traces = datatable(EventText:string)\r\n[\r\n"Event: NotifySliceRelease (resourceName=PipelineScheduler, totalSlices=27, sliceNumber=23, lockTime=02/17/2016 08:40:01, releaseTime=02/17/2016 08:40:01, previousLockTime=02/17/2016 08:39:01)",\r\n"Event: NotifySliceRelease (resourceName=PipelineScheduler, totalSlices=27, sliceNumber=15, lockTime=02/17/2016 08:40:00, releaseTime=02/17/2016 08:40:00, previousLockTime=02/17/2016 08:39:00)",\r\n"Event: NotifySliceRelease (resourceName=PipelineScheduler, totalSlices=27, sliceNumber=20, lockTime=02/17/2016 08:40:01, releaseTime=02/17/2016 08:40:01, previousLockTime=02/17/2016 08:39:01)",\r\n"Event: NotifySliceRelease (resourceName=PipelineScheduler, totalSlices=27, sliceNumber=22, lockTime=02/17/2016 08:41:01, releaseTime=02/17/2016 08:41:00, previousLockTime=02/17/2016 08:40:01)",\r\n"Event: NotifySliceRelease (resourceName=PipelineScheduler, totalSlices=27, sliceNumber=16, lockTime=02/17/2016 08:41:00, releaseTime=02/17/2016 08:41:00, previousLockTime=02/17/2016 08:40:00)"\r\n];\r\nTraces\r\n| parse kind = regex  EventText with * "resourceName=" resourceName \',\' *\r\n| project resourceName\r\n\r\n```\r\n|resourceName|\r\n|---|\r\n|PipelineScheduler, totalSlices=27, sliceNumber=23, lockTime=02/17/2016 08:40:01, releaseTime=02/17/2016 08:40:01|\r\n|PipelineScheduler, totalSlices=27, sliceNumber=15, lockTime=02/17/2016 08:40:00, releaseTime=02/17/2016 08:40:00|\r\n|PipelineScheduler, totalSlices=27, sliceNumber=20, lockTime=02/17/2016 08:40:01, releaseTime=02/17/2016 08:40:01|\r\n|PipelineScheduler, totalSlices=27, sliceNumber=22, lockTime=02/17/2016 08:41:01, releaseTime=02/17/2016 08:41:00|\r\n|PipelineScheduler, totalSlices=27, sliceNumber=16, lockTime=02/17/2016 08:41:00, releaseTime=02/17/2016 08:41:00|\r\nYou won\'t get the expected results, since the default mode is greedy.\r\nIf you have a few records where the *resourceName*  sometimes appears as lower-case and sometimes as upper-case, you may get nulls for some values.\r\nTo get the wanted result, run the query with the non-greedy `U`, and disable case-sensitive `i` regex flags.\r\n\r\n```\r\n\r\nlet Traces = datatable(EventText:string)\r\n[\r\n"Event: NotifySliceRelease (resourceName=PipelineScheduler, totalSlices=27, sliceNumber=23, lockTime=02/17/2016 08:40:01, releaseTime=02/17/2016 08:40:01, previousLockTime=02/17/2016 08:39:01)",\r\n"Event: NotifySliceRelease (resourceName=PipelineScheduler, totalSlices=27, sliceNumber=15, lockTime=02/17/2016 08:40:00, releaseTime=02/17/2016 08:40:00, previousLockTime=02/17/2016 08:39:00)",\r\n"Event: NotifySliceRelease (resourceName=PipelineScheduler, totalSlices=27, sliceNumber=20, lockTime=02/17/2016 08:40:01, releaseTime=02/17/2016 08:40:01, previousLockTime=02/17/2016 08:39:01)",\r\n"Event: NotifySliceRelease (resourceName=PipelineScheduler, totalSlices=27, sliceNumber=22, lockTime=02/17/2016 08:41:01, releaseTime=02/17/2016 08:41:00, previousLockTime=02/17/2016 08:40:01)",\r\n"Event: NotifySliceRelease (resourceName=PipelineScheduler, totalSlices=27, sliceNumber=16, lockTime=02/17/2016 08:41:00, releaseTime=02/17/2016 08:41:00, previousLockTime=02/17/2016 08:40:00)"\r\n];\r\nTraces\r\n| parse kind = regex flags = Ui EventText with * "RESOURCENAME=" resourceName \',\' *\r\n| project resourceName\r\n\r\n```\r\n|resourceName|\r\n|---|\r\n|PipelineScheduler|\r\n|PipelineScheduler|\r\n|PipelineScheduler|\r\n|PipelineScheduler|\r\n|PipelineScheduler|\r\nIf the parsed string has newlines, use the flag `s`, to parse the text.\r\n\r\n```\r\n\r\nlet Traces = datatable(EventText:string)\r\n[\r\n"Event: NotifySliceRelease (resourceName=PipelineScheduler\\ntotalSlices=27\\nsliceNumber=23\\nlockTime=02/17/2016 08:40:01\\nreleaseTime=02/17/2016 08:40:01\\npreviousLockTime=02/17/2016 08:39:01)",\r\n"Event: NotifySliceRelease (resourceName=PipelineScheduler\\ntotalSlices=27\\nsliceNumber=15\\nlockTime=02/17/2016 08:40:00\\nreleaseTime=02/17/2016 08:40:00\\npreviousLockTime=02/17/2016 08:39:00)",\r\n"Event: NotifySliceRelease (resourceName=PipelineScheduler\\ntotalSlices=27\\nsliceNumber=20\\nlockTime=02/17/2016 08:40:01\\nreleaseTime=02/17/2016 08:40:01\\npreviousLockTime=02/17/2016 08:39:01)",\r\n"Event: NotifySliceRelease (resourceName=PipelineScheduler\\ntotalSlices=27\\nsliceNumber=22\\nlockTime=02/17/2016 08:41:01\\nreleaseTime=02/17/2016 08:41:00\\npreviousLockTime=02/17/2016 08:40:01)",\r\n"Event: NotifySliceRelease (resourceName=PipelineScheduler\\ntotalSlices=27\\nsliceNumber=16\\nlockTime=02/17/2016 08:41:00\\nreleaseTime=02/17/2016 08:41:00\\npreviousLockTime=02/17/2016 08:40:00)"\r\n];\r\nTraces\r\n| parse kind=regex flags=s EventText with * "resourceName=" resourceName:string "(.*?)totalSlices=" totalSlices:long "(.*?)lockTime=" lockTime:datetime "(.*?)releaseTime=" releaseTime:datetime "(.*?)previousLockTime=" previousLockTime:datetime "\\\\)" \r\n| project-away EventText\r\n\r\n```\r\n|resourceName|totalSlices|lockTime|releaseTime|previousLockTime|\r\n|---|---|---|---|---|\r\n|PipelineScheduler<br>|27|2016-02-17 08:40:00.0000000|2016-02-17 08:40:00.0000000|2016-02-17 08:39:00.0000000|\r\n|PipelineScheduler<br>|27|2016-02-17 08:40:01.0000000|2016-02-17 08:40:01.0000000|2016-02-17 08:39:01.0000000|\r\n|PipelineScheduler<br>|27|2016-02-17 08:40:01.0000000|2016-02-17 08:40:01.0000000|2016-02-17 08:39:01.0000000|\r\n|PipelineScheduler<br>|27|2016-02-17 08:41:00.0000000|2016-02-17 08:41:00.0000000|2016-02-17 08:40:00.0000000|\r\n|PipelineScheduler<br>|27|2016-02-17 08:41:01.0000000|2016-02-17 08:41:00.0000000|2016-02-17 08:40:01.0000000|\r\n**Relaxed mode**\r\nIn this example for relaxed mode, *totalSlices* extended column must be of type `long`. However, in the parsed string, it has the value *nonValidLongValue*.\r\nIn *releaseTime* extended column, the value *nonValidDateTime* can\'t be parsed as *datetime*.\r\nThese two extended columns will get the value null while the other ones, such as *sliceNumber*, still get the correct values.\r\nIf you use option *kind = simple* for the same query below, you\'ll get null for all extended columns. This option is strict on extended columns, and is the difference between relaxed and simple mode.\r\n > [!NOTE] \r\n > In relaxed mode, extended columns can be partially matched.\r\n\r\n```\r\n\r\nlet Traces = datatable(EventText:string)\r\n[\r\n"Event: NotifySliceRelease (resourceName=PipelineScheduler, totalSlices=27, sliceNumber=23, lockTime=02/17/2016 08:40:01, releaseTime=nonValidDateTime 08:40:01, previousLockTime=02/17/2016 08:39:01)",\r\n"Event: NotifySliceRelease (resourceName=PipelineScheduler, totalSlices=27, sliceNumber=15, lockTime=02/17/2016 08:40:00, releaseTime=nonValidDateTime, previousLockTime=02/17/2016 08:39:00)",\r\n"Event: NotifySliceRelease (resourceName=PipelineScheduler, totalSlices=nonValidLongValue, sliceNumber=20, lockTime=02/17/2016 08:40:01, releaseTime=nonValidDateTime 08:40:01, previousLockTime=02/17/2016 08:39:01)",\r\n"Event: NotifySliceRelease (resourceName=PipelineScheduler, totalSlices=27, sliceNumber=22, lockTime=02/17/2016 08:41:01, releaseTime=02/17/2016 08:41:00, previousLockTime=02/17/2016 08:40:01)",\r\n"Event: NotifySliceRelease (resourceName=PipelineScheduler, totalSlices=nonValidLongValue, sliceNumber=16, lockTime=02/17/2016 08:41:00, releaseTime=02/17/2016 08:41:00, previousLockTime=02/17/2016 08:40:00)"\r\n];\r\nTraces\r\n| parse kind=relaxed EventText with * "resourceName=" resourceName ", totalSlices=" totalSlices:long * "sliceNumber=" sliceNumber:long * "lockTime=" lockTime ", releaseTime=" releaseTime:date "," * "previousLockTime=" previousLockTime:date ")" *\r\n| project-away EventText\r\n\r\n```\r\n|resourceName|totalSlices|sliceNumber|lockTime|releaseTime|previousLockTime|\r\n|---|---|---|---|---|---|\r\n|PipelineScheduler|27|15|02/17/2016 08:40:00||2016-02-17 08:39:00.0000000|\r\n|PipelineScheduler|27|23|02/17/2016 08:40:01||2016-02-17 08:39:01.0000000|\r\n|PipelineScheduler||20|02/17/2016 08:40:01||2016-02-17 08:39:01.0000000|\r\n|PipelineScheduler||16|02/17/2016 08:41:00|2016-02-17 08:41:00.0000000|2016-02-17 08:40:00.0000000|\r\n|PipelineScheduler|27|22|02/17/2016 08:41:01|2016-02-17 08:41:00.0000000|2016-02-17 08:40:01.0000000|',"","https://docs.microsoft.com/en-us/azure/kusto/query/parseoperator","")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"parse_csv","Splits a given string representing a single record of comma-separated values and returns a string array with these values.",'```\r\nparse_csv("aaa,bbb,ccc") == ["aaa","bbb","ccc"]\r\n```\r\n\r\n## Syntax\r\n\r\n`parse_csv(`*source*`)`\r\n\r\n## Arguments\r\n\r\n* *source*: The source string representing a single record of comma-separated values.\r\n\r\n## Returns\r\n\r\nA string array that contains the split values.\r\n\r\n**Notes**\r\n\r\nEmbedded line feeds, commas, and quotes may be escaped using the double quotation mark (\'"\'). \r\nThis function doesn\'t support multiple records per row (only the first record is taken).','```\r\nprint result=parse_csv(\'aa,"b,b,b",cc,"Escaping quotes: ""Title""","line1\\nline2"\')\r\n```\r\n\r\n|result|\r\n|---|\r\n|[<br>  "aa",<br>  "b,b,b",<br>  "cc",<br>  "Escaping quotes: \\"Title\\"",<br>  "line1\\nline2"<br>]|\r\n\r\nCSV payload with multiple records:\r\n\r\n```\r\nprint result_multi_record=parse_csv(\'record1,a,b,c\\nrecord2,x,y,z\')\r\n```\r\n\r\n|result_multi_record|\r\n|---|\r\n|[<br>  "record1",<br>  "a",<br>  "b",<br>  "c"<br>]|',"https://docs.microsoft.com/en-us/azure/kusto/query/parsecsvfunction","parsecsvfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"parse_ipv4","Converts IPv4 string to long (signed 64-bit) number representation.","```\r\nparse_ipv4(\"127.0.0.1\") == 2130706433\r\nparse_ipv4('192.1.168.1') < parse_ipv4('192.1.168.2') == true\r\n```\r\n\r\n## Syntax\r\n\r\n`parse_ipv4(`*`Expr`*`)`\r\n\r\n## Arguments\r\n\r\n* *`Expr`*: String expression representing IPv4 that will be converted to long. String may include net-mask using [IP-prefix notation](#ip-prefix-notation).\r\n\r\n## IP-prefix notation\r\n\r\nIP addresses can be defined with `IP-prefix notation` using a slash (`/`) character.\r\nThe IP address to the LEFT of the slash (`/`) is the base IP address. The number (1 to 32) to the RIGHT of the slash (/) is the number of contiguous 1 bit in the netmask.","192.168.2.0/24 will have an associated net/subnetmask containing 24 contiguous bits or 255.255.255.0 in dotted decimal format.\r\n\r\n## Returns\r\n\r\nIf conversion is successful, the result will be a long number.\r\nIf conversion isn't successful, the result will be `null`.\r\n\r\n## Example\r\n\r\n```\r\ndatatable(ip_string:string)\r\n[\r\n '192.168.1.1',\r\n '192.168.1.1/24',\r\n '255.255.255.255/31'\r\n]\r\n| extend ip_long = parse_ipv4(ip_string)\r\n```\r\n\r\n|ip_string|ip_long|\r\n|---|---|\r\n|192.168.1.1|3232235777|\r\n|192.168.1.1/24|3232235776|\r\n|255.255.255.255/31|4294967294|","https://docs.microsoft.com/en-us/azure/kusto/query/parse-ipv4function","parse-ipv4function.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"parse_ipv4_mask","Converts the input string of IPv4 and netmask to long number representation (signed 64-bit).","```\r\nparse_ipv4_mask(\"127.0.0.1\", 24) == 2130706432\r\nparse_ipv4_mask('192.1.168.2', 31) == parse_ipv4_mask('192.1.168.3', 31)\r\n```\r\n\r\n## Syntax\r\n\r\n`parse_ipv4_mask(`*`Expr`*`, `*`PrefixMask`*`)`\r\n\r\n## Arguments\r\n\r\n* *`Expr`*: A string representation of the IPv4 address that will be converted to long. \r\n* *`PrefixMask`*: An integer from 0 to 32 representing the number of most-significant bits that are taken into account.\r\n\r\n## Returns\r\n\r\nIf conversion is successful, the result will be a long number.\r\nIf conversion isn't successful, the result will be `null`.","","https://docs.microsoft.com/en-us/azure/kusto/query/parse-ipv4-maskfunction","")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"parse_ipv6","Converts IPv6 or IPv4 string to a canonical IPv6 string representation.","```\r\nparse_ipv6(\"127.0.0.1\") == '0000:0000:0000:0000:0000:ffff:7f00:0001'\r\nparse_ipv6(\":fe80::85d:e82c:9446:7994\") == 'fe80:0000:0000:0000:085d:e82c:9446:7994'\r\n```\r\n\r\n## Syntax\r\n\r\n`parse_ipv6(`*`Expr`*`)`\r\n\r\n## Arguments\r\n\r\n* *`Expr`*: String expression representing IPv6/IPv4 network address that will be converted to canonical IPv6 representation. String may include net-mask using [IP-prefix notation](#ip-prefix-notation).\r\n\r\n## IP-prefix notation\r\n\r\nIP addresses can be defined with `IP-prefix notation` using a slash (`/`) character.\r\nThe IP address to the LEFT of the slash (`/`) is the base IP address. The number (1 to 127) to the RIGHT of the slash (`/`) is the number of contiguous 1 bits in the netmask.\r\n\r\n## Returns\r\n\r\nIf conversion is successful, the result will be a string representing a canonical IPv6 network address.\r\nIf conversion isn't successful, the result will be `null`.","```\r\ndatatable(ip_string:string, netmask:long)\r\n[\r\n '192.168.255.255',     32,  // 32-bit netmask is used\r\n '192.168.255.255/24',  30,  // 24-bit netmask is used, as IPv4 address doesn't use upper 8 bits\r\n '255.255.255.255',     24,  // 24-bit netmask is used\r\n]\r\n| extend ip_long = parse_ipv4_mask(ip_string, netmask)\r\n```\r\n\r\n|ip_string|netmask|ip_long|\r\n|---|---|---|\r\n|192.168.255.255|32|3232301055|\r\n|192.168.255.255/24|30|3232300800|\r\n|255.255.255.255|24|4294967040|","https://docs.microsoft.com/en-us/azure/kusto/query/parse-ipv6function","parse-ipv6function.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"parse_ipv6_mask","Converts IPv6/IPv4 string and netmask to a canonical IPv6 string representation.","```\r\nparse_ipv6_mask(\"127.0.0.1\", 24) == '0000:0000:0000:0000:0000:ffff:7f00:0000'\r\nparse_ipv6_mask(\":fe80::85d:e82c:9446:7994\", 120) == 'fe80:0000:0000:0000:085d:e82c:9446:7900'\r\n```\r\n\r\n## Syntax\r\n\r\n`parse_ipv6_mask(`*`Expr`*`, `*`PrefixMask`*`)`\r\n\r\n## Arguments\r\n\r\n* *`Expr`*: String expression representing IPv6/IPv4 network address that will be converted to canonical IPv6 representation. String may include net-mask using [IP-prefix notation](#ip-prefix-notation).\r\n* *`PrefixMask`*: An integer from 0 to 128 representing the number of most-significant bits that are taken into account.\r\n\r\n## IP-prefix notation\r\n\r\nIP addresses can be defined with `IP-prefix notation` using a slash (`/`) character.\r\nThe IP address to the LEFT of the slash (`/`) is the base IP address. The number (1 to 127) to the RIGHT of the slash (`/`) is the number of contiguous 1 bit in the netmask.\r\n\r\n## Returns\r\n\r\nIf conversion is successful, the result will be a string representing a canonical IPv6 network address.\r\nIf conversion isn't successful, the result will be `null`.","```\r\ndatatable(ip_string:string, netmask:long)\r\n[\r\n // IPv4 addresses\r\n '192.168.255.255',     120,  // 120-bit netmask is used\r\n '192.168.255.255/24',  124,  // 120-bit netmask is used, as IPv4 address doesn't use upper 8 bits\r\n '255.255.255.255', 128,  // 128-bit netmask is used\r\n // IPv6 addresses\r\n 'fe80::85d:e82c:9446:7994', 128,     // 128-bit netmask is used\r\n 'fe80::85d:e82c:9446:7994/120', 124, // 120-bit netmask is used\r\n // IPv6 with IPv4 notation\r\n '::192.168.255.255',    128,  // 128-bit netmask is used\r\n '::192.168.255.255/24', 128,  // 120-bit netmask is used, as IPv4 address doesn't use upper 8 bits\r\n]\r\n| extend ip6_canonical = parse_ipv6_mask(ip_string, netmask)\r\n```\r\n\r\n|ip_string|netmask|ip6_canonical|\r\n|---|---|---|\r\n|192.168.255.255|120|0000:0000:0000:0000:0000:ffff:c0a8:ff00|\r\n|192.168.255.255/24|124|0000:0000:0000:0000:0000:ffff:c0a8:ff00|\r\n|255.255.255.255|128|0000:0000:0000:0000:0000:ffff:ffff:ffff|\r\n|fe80::85d:e82c:9446:7994|128|fe80:0000:0000:0000:085d:e82c:9446:7994|\r\n|fe80::85d:e82c:9446:7994/120|124|fe80:0000:0000:0000:085d:e82c:9446:7900|\r\n|::192.168.255.255|128|0000:0000:0000:0000:0000:ffff:c0a8:ffff|\r\n|::192.168.255.255/24|128|0000:0000:0000:0000:0000:ffff:c0a8:ff00|","https://docs.microsoft.com/en-us/azure/kusto/query/parse-ipv6-maskfunction","parse-ipv6-maskfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"parse_json","Interprets a `string` as a JSON value and returns the value as `dynamic`.","This function is better than [extractjson() function](./extractjsonfunction.md)\r\nwhen you need to extract more than one element of a JSON compound object.\r\n\r\n## Syntax\r\n\r\n`parse_json(`*json*`)`\r\n\r\nAliases:\r\n\r\n- [todynamic()](./todynamicfunction.md)\r\n- [toobject()](./todynamicfunction.md)\r\n\r\n## Arguments\r\n\r\n* *json*: An expression of type `string`. It represents a [JSON-formatted value](https://json.org/), or an expression of type [dynamic](./scalar-data-types/dynamic.md), representing the actual `dynamic` value.\r\n\r\n## Returns\r\n\r\nAn object of type `dynamic` that is determined by the value of *json*:\r\n\r\n* If *json* is of type `dynamic`, its value is used as-is.\r\n* If *json* is of type `string`, and is a [properly formatted JSON string](https://json.org/), then the string is parsed, and the value produced is returned.\r\n* If *json* is of type `string`, but it isn't a [properly formatted JSON string](https://json.org/), then the returned value is an object of type `dynamic` that holds the original `string` value.",'In the following example, when `context_custom_metrics` is a `string`\r\nthat looks like this:\r\n\r\n```json\r\n{"duration":{"value":118.0,"count":5.0,"min":100.0,"max":150.0,"stdDev":0.0,"sampledValue":118.0,"sum":118.0}}\r\n```\r\n\r\nthen the following CSL Fragment retrieves the value of the `duration` slot\r\nin the object, and from that it retrieves two slots, `duration.value` and\r\n `duration.min` (`118.0` and `110.0`, respectively).\r\n\r\n```\r\nT\r\n| extend d=parse_json(context_custom_metrics) \r\n| extend duration_value=d.duration.value, duration_min=d["duration"]["min"]\r\n```\r\n\r\n**Notes**\r\n\r\nIt\'s common to have a JSON string describing a property bag in which\r\none of the "slots" is another JSON string. \r\n\r\nFor example:\r\n\r\n```\r\nlet d=\'{"a":123, "b":"{\\\\"c\\\\":456}"}\';\r\nprint d\r\n```\r\n\r\nIn such cases, it isn\'t only necessary to invoke `parse_json` twice, but also\r\nto make sure that in the second call, `tostring` is used. Otherwise, the\r\nsecond call to `parse_json` will just pass on the input to the output as-is,\r\nbecause its declared type is `dynamic`.\r\n\r\n```\r\nlet d=\'{"a":123, "b":"{\\\\"c\\\\":456}"}\';\r\nprint d_b_c=parse_json(tostring(parse_json(d).b)).c\r\n```',"https://docs.microsoft.com/en-us/azure/kusto/query/parsejsonfunction","parsejsonfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"parse_path","Parses a file path `string` and returns a [`dynamic`](./scalar-data-types/dynamic.md) object that contains the following parts of the path:",'* Scheme\r\n* RootPath\r\n* DirectoryPath\r\n* DirectoryName\r\n* FileName\r\n* Extension\r\n* AlternateDataStreamName\r\n\r\nIn addition to the simple paths with both types of slashes, the function supports paths with:\r\n\r\n* Schemas. For example, "file://..."\r\n* Shared paths. For example, "\\\\shareddrive\\users..."\r\n* Long paths. For example, "\\\\?\\C:...""\r\n* Alternate data streams. For example, "file1.exe:file2.exe"\r\n\r\n## Syntax\r\n\r\n`parse_path(`*path*`)`\r\n\r\n## Arguments\r\n\r\n* *path*: A string that represents a file path.\r\n\r\n## Returns\r\n\r\nAn object of type `dynamic` that included the path components as listed above.','```\r\ndatatable(p:string) \r\n[\r\n    @"C:\\temp\\file.txt",\r\n    @"temp\\file.txt",\r\n    "file://C:/temp/file.txt:some.exe",\r\n    @"\\\\shared\\users\\temp\\file.txt.gz",\r\n    "/usr/lib/temp/file.txt"\r\n]\r\n| extend path_parts = parse_path(p)\r\n\r\n```\r\n\r\n|p|path_parts\r\n|---|---\r\n|C:\\temp\\file.txt|{"Scheme":"","RootPath":"C:","DirectoryPath":"C:\\\\temp","DirectoryName":"temp","Filename":"file.txt","Extension":"txt","AlternateDataStreamName":""}\r\n|temp\\file.txt|{"Scheme":"","RootPath":"","DirectoryPath":"temp","DirectoryName":"temp","Filename":"file.txt","Extension":"txt","AlternateDataStreamName":""}\r\n|file://C:/temp/file.txt:some.exe|{"Scheme":"file","RootPath":"C:","DirectoryPath":"C:/temp","DirectoryName":"temp","Filename":"file.txt","Extension":"txt","AlternateDataStreamName":"some.exe"}\r\n|\\\\shared\\users\\temp\\file.txt.gz|{"Scheme":"","RootPath":"","DirectoryPath":"\\\\\\\\shared\\\\users\\\\temp","DirectoryName":"temp","Filename":"file.txt.gz","Extension":"gz","AlternateDataStreamName":""}\r\n|/usr/lib/temp/file.txt|{"Scheme":"","RootPath":"","DirectoryPath":"/usr/lib/temp","DirectoryName":"temp","Filename":"file.txt","Extension":"txt","AlternateDataStreamName":""}',"https://docs.microsoft.com/en-us/azure/kusto/query/parsepathfunction","parsepathfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"parse_url","Parses an absolute URL `string` and returns a `dynamic` object contains URL parts.","## Syntax\r\n\r\n`parse_url(`*url*`)`\r\n\r\n## Arguments\r\n\r\n* *url*: A string represents a URL or the query part of the URL.\r\n\r\n## Returns\r\n\r\nAn object of type [dynamic](./scalar-data-types/dynamic.md) that included the URL components: Scheme, Host, Port, Path, Username, Password, Query Parameters, Fragment.",'```\r\nT | extend Result = parse_url("scheme://username:password@host:1234/this/is/a/path?k1=v1&k2=v2#fragment")\r\n```\r\n\r\nwill result\r\n\r\n```\r\n {\r\n \t"Scheme":"scheme",\r\n \t"Host":"host",\r\n \t"Port":"1234",\r\n \t"Path":"this/is/a/path",\r\n \t"Username":"username",\r\n \t"Password":"password",\r\n \t"Query Parameters":"{"k1":"v1", "k2":"v2"}",\r\n \t"Fragment":"fragment"\r\n }\r\n```',"https://docs.microsoft.com/en-us/azure/kusto/query/parseurlfunction","parseurlfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"parse_urlquery","Returns a `dynamic` object contains the Query parameters.","## Syntax\r\n\r\n`parse_urlquery(`*query*`)`\r\n\r\n## Arguments\r\n\r\n* *query*: A string represents a url query.\r\n\r\n## Returns\r\n\r\nAn object of type [dynamic](./scalar-data-types/dynamic.md) that includes the query parameters.",'```\r\nparse_urlquery("k1=v1&k2=v2&k3=v3")\r\n```\r\n\r\nwill result:\r\n\r\n```\r\n {\r\n \t"Query Parameters":"{"k1":"v1", "k2":"v2", "k3":"v3"}",\r\n }\r\n```\r\n\r\n**Notes**\r\n\r\n* Input format should follow URL query standards (key=value& ...)',"https://docs.microsoft.com/en-us/azure/kusto/query/parseurlqueryfunction","parseurlqueryfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"parse_user_agent","Interprets a user-agent string, which identifies the user's browser and provides certain system details to servers hosting the websites the user visits. The result is returned as [`dynamic`](./scalar-data-types/dynamic.md).",'## Syntax\r\n\r\n`parse_user_agent(`*user-agent-string*, *look-for*`)`\r\n\r\n## Arguments\r\n\r\n* *user-agent-string*: An expression of type `string`, representing a user-agent string.\r\n* *look-for*: An expression of type `string` or `dynamic`, representing what the function should be looking for in the user-agent string (parsing target). \r\nThe possible options: "browser", "os", "device". If only a single parsing target is required it can be passed a `string` parameter.\r\nIf two or three are required they can be passed as a `dynamic array`.\r\n\r\n## Returns\r\n\r\nAn object of type `dynamic` that contains the information about the requested parsing targets.\r\n\r\nBrowser: Family, MajorVersion, MinorVersion, Patch                 \r\n\r\nOperatingSystem: Family, MajorVersion, MinorVersion, Patch, PatchMinor             \r\n\r\nDevice: Family, Brand, Model\r\n\r\n> [!WARNING]\r\n> The function implementation is built on regex checks of the input string against a huge number of predefined patterns. Therefore the expected time and CPU consumption is high.\r\nWhen the function is used in a query, make sure it runs in a distributed manner on multiple machines.\r\nIf queries with this function are frequently used, you may want to pre-create the results via [update policy](../management/updatepolicy.md), but you need to take into account that using this function inside the update policy will increase the ingestion latency.','```\r\nprint useragent = "Mozilla/5.0 (Windows; U; en-US) AppleWebKit/531.9 (KHTML, like Gecko) AdobeAIR/2.5.1"\r\n| extend x = parse_user_agent(useragent, "browser") \r\n```\r\n\r\nExpected result is a dynamic object:\r\n\r\n{\r\n  "Browser": {\r\n    "Family": "AdobeAIR",\r\n    "MajorVersion": "2",\r\n    "MinorVersion": "5",\r\n    "Patch": "1"\r\n  }\r\n}\r\n\r\n```\r\nprint useragent = "Mozilla/5.0 (SymbianOS/9.2; U; Series60/3.1 NokiaN81-3/10.0.032 Profile/MIDP-2.0 Configuration/CLDC-1.1 ) AppleWebKit/413 (KHTML, like Gecko) Safari/4"\r\n| extend x = parse_user_agent(useragent, dynamic(["browser","os","device"])) \r\n```\r\n\r\nExpected result is a dynamic object:\r\n\r\n{\r\n  "Browser": {\r\n    "Family": "Nokia OSS Browser",\r\n    "MajorVersion": "3",\r\n    "MinorVersion": "1",\r\n    "Patch": ""\r\n  },\r\n  "OperatingSystem": {\r\n    "Family": "Symbian OS",\r\n    "MajorVersion": "9",\r\n    "MinorVersion": "2",\r\n    "Patch": "",\r\n    "PatchMinor": ""\r\n  },\r\n  "Device": {\r\n    "Family": "Nokia N81",\r\n    "Brand": "Nokia",\r\n    "Model": "N81-3"\r\n  }\r\n}',"https://docs.microsoft.com/en-us/azure/kusto/query/parse-useragentfunction","parse-useragentfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"parse_version","Converts the input string representation of version to a comparable decimal number.","```\r\nparse_version(\"0.0.0.1\")\r\n```\r\n\r\n## Syntax\r\n\r\n`parse_version` `(` *Expr* `)`\r\n\r\n## Arguments\r\n\r\n* *`Expr`*: A scalar expression of type `string` that specifies the version to be parsed.\r\n\r\n> [!NOTE]\r\n> * Input string must contain from one to four version parts, represented as numbers and separated with dots ('.').\r\n> * Each part of version may contain up to eight digits, with the max value at 99999999.\r\n> * If the number of parts is less than four, all the missing parts are considered as trailing (`1.0` == `1.0.0.0`).\r\n\r\n## Returns\r\n\r\nIf conversion is successful, the result will be a decimal.\r\nIf conversion is unsuccessful, the result will be `null`.",'```\r\nlet dt = datatable(v:string)\r\n["0.0.0.5","0.0.7.0","0.0.3","0.2","0.1.2.0","1.2.3.4","1","99999999.0.0.0"];\r\ndt | project v1=v, _key=1 \r\n| join kind=inner (dt | project v2=v, _key = 1) on _key | where v1 != v2\r\n| summarize v1 = max(v1),v2 = min(v2) by (hash(v1) + hash(v2)) // removing duplications\r\n| project v1, v2, higher_version = iif(parse_version(v1) > parse_version(v2), v1, v2)\r\n\r\n```\r\n\r\n|v1|v2|higher_version|\r\n|---|---|---|\r\n|99999999.0.0.0|0.0.0.5|99999999.0.0.0|\r\n|1|0.0.0.5|1|\r\n|1.2.3.4|0.0.0.5|1.2.3.4|\r\n|0.1.2.0|0.0.0.5|0.1.2.0|\r\n|0.2|0.0.0.5|0.2|\r\n|0.0.3|0.0.0.5|0.0.3|\r\n|0.0.7.0|0.0.0.5|0.0.7.0|\r\n|99999999.0.0.0|0.0.7.0|99999999.0.0.0|\r\n|1|0.0.7.0|1|\r\n|1.2.3.4|0.0.7.0|1.2.3.4|\r\n|0.1.2.0|0.0.7.0|0.1.2.0|\r\n|0.2|0.0.7.0|0.2|\r\n|0.0.7.0|0.0.3|0.0.7.0|\r\n|99999999.0.0.0|0.0.3|99999999.0.0.0|\r\n|1|0.0.3|1|\r\n|1.2.3.4|0.0.3|1.2.3.4|\r\n|0.1.2.0|0.0.3|0.1.2.0|\r\n|0.2|0.0.3|0.2|\r\n|99999999.0.0.0|0.2|99999999.0.0.0|\r\n|1|0.2|1|\r\n|1.2.3.4|0.2|1.2.3.4|\r\n|0.2|0.1.2.0|0.2|\r\n|99999999.0.0.0|0.1.2.0|99999999.0.0.0|\r\n|1|0.1.2.0|1|\r\n|1.2.3.4|0.1.2.0|1.2.3.4|\r\n|99999999.0.0.0|1.2.3.4|99999999.0.0.0|\r\n|1.2.3.4|1|1.2.3.4|\r\n|99999999.0.0.0|1|99999999.0.0.0|',"https://docs.microsoft.com/en-us/azure/kusto/query/parse-versionfunction","parse-versionfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"parse_xml","Interprets a `string` as a XML value, converts the value to a JSON and returns the value as `dynamic`.",'## Syntax\r\n\r\n`parse_xml(`*xml*`)`\r\n\r\n## Arguments\r\n\r\n* *xml*: An expression of type `string`, representing a XML-formatted value.\r\n\r\n## Returns\r\n\r\nAn object of type [dynamic](./scalar-data-types/dynamic.md) that is determined by the value of *xml*, or null, if the XML format is invalid.\r\n\r\nThe conversion is done as following:\r\n\r\nXML                                |JSON                                            |Access\r\n-----------------------------------|------------------------------------------------|--------------         \r\n`<e/>`                             | { "e": null }                                  | o.e\r\n`<e>text</e>`\t                   | { "e": "text" }\t                            | o.e\r\n`<e name="value" />`               | { "e":{"@name": "value"} }\t                    | o.e["@name"]\r\n`<e name="value">text</e>`         | { "e": { "@name": "value", "#text": "text" } } | o.e["@name"] o.e["#text"]\r\n`<e> <a>text</a> <b>text</b> </e>` | { "e": { "a": "text", "b": "text" } }\t        | o.e.a o.e.b\r\n`<e> <a>text</a> <a>text</a> </e>` | { "e": { "a": ["text", "text"] } }\t            | o.e.a[0] o.e.a[1]\r\n`<e> text <a>text</a> </e>`        | { "e": { "#text": "text", "a": "text" } }\t    | 1`o.e["#text"] o.e.a\r\n\r\n**Notes**\r\n\r\n* Maximal input `string` length for `parse_xml` is 1MB (1,048,576 bytes). Longer strings interpretation will result in a null object\r\n* Only element nodes, attributes and text nodes will be translated. Everything else will be skipped','In the following example, when `context_custom_metrics` is a `string`\r\nthat looks like this: \r\n\r\n```xml\r\n<?xml version="1.0" encoding="UTF-8"?>\r\n<duration>\r\n    <value>118.0</value>\r\n    <count>5.0</count>\r\n    <min>100.0</min>\r\n    <max>150.0</max>\r\n    <stdDev>0.0</stdDev>\r\n    <sampledValue>118.0</sampledValue>\r\n    <sum>118.0</sum>\r\n</duration>\r\n```\r\n\r\nthen the following CSL Fragment translates the XML to the following JSON:\r\n\r\n```json\r\n{\r\n    "duration": {\r\n        "value": 118.0,\r\n        "count": 5.0,\r\n        "min": 100.0,\r\n        "max": 150.0,\r\n        "stdDev": 0.0,\r\n        "sampledValue": 118.0,\r\n        "sum": 118.0\r\n    }\r\n}\r\n```\r\n\r\nand retrieves the value of the `duration` slot\r\nin the object, and from that it retrieves two slots, `duration.value` and\r\n `duration.min` (`118.0` and `110.0`, respectively).\r\n\r\n```\r\nT\r\n| extend d=parse_xml(context_custom_metrics) \r\n| extend duration_value=d.duration.value, duration_min=d["duration"]["min"]\r\n```',"https://docs.microsoft.com/en-us/azure/kusto/query/parse-xmlfunction","parse-xmlfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.OperatorToken,"parse-where","Evaluates a string expression, and parses its value into one or more calculated columns. The result is only the successfully parsed strings.",'See [parse operator](parseoperator.md), which produces nulls for unsuccessfully parsed strings.\r\n\r\n```\r\nT | parse-where Text with "ActivityName=" name ", ActivityType=" type\r\n```\r\n\r\n## Syntax\r\n\r\n*T* `| parse-where` [`kind=regex` [`flags=regex_flags`] |`simple`] *Expression* `with` `*` (*StringConstant* *ColumnName* [`:` *ColumnType*]) `*`...\r\n\r\n## Arguments\r\n\r\n* *T*: The input table.\r\n* *kind*: \r\n\t* *simple* (default): StringConstant is a regular string value, and the match is strict. All string delimiters should appear in the parsed string, and all extended columns must match the required types.\r\n\t\t\r\n\t* *regex*: StringConstant may be a regular expression, and the match is strict. All string delimiters should appear in the parsed string, and all extended columns must match the required types. String delimiters can be a regex for this mode.\r\n\t\r\n\t* *flags*: Flags to be used in regex mode:  `U` (Ungreedy), `m` (multi-line mode), `s` (match new line `\\n`), `i` (case-insensitive), More flags can be found in [RE2 flags](re2.md).\r\n\t\t\r\n* *Expression*: An expression that evaluates to a string.\r\n* *ColumnName:* The name of a column that is assigned to a value that was taken out of the string expression. \r\n  \r\n* *ColumnType:* should be an optional scalar type that indicates the type to convert the value to. The default is string type.\r\n\r\n## Returns\r\n\r\nThe input table, which is extended according to the list of columns that are provided to the operator.\r\n\r\n> [!Note] \r\n> Only successfully parsed strings will be in the output. Strings that don\'t match the pattern will be filtered out.\r\n\r\n**Tips**\r\n\r\n* `parse-where` parses the strings in the same way as [parse](parseoperator.md), and filters out strings that were not parsed successfully.\r\n* Use [project](projectoperator.md) if you also want to drop or rename some columns.\r\n* Use * in the pattern to skip junk values. This value can\'t be used after string column.\r\n* The parse pattern may start with *ColumnName*, in addition to *StringConstant*. \r\n* If the parsed *Expression* isn\'t of type string, it will be converted to type string.\r\n* If regex mode is used, you can add regex flags to control the whole regex used in parse.\r\n* In regex mode, parse will translate the pattern to a regex and use [RE2 syntax](re2.md) in order to do the matching using numbered captured groups that are handled internally.\r\n  \r\n  For example, this parse statement:\r\n  \r\n \r\n\r\n```\r\n\tparse-where kind=regex Col with * <regex1> var1:string <regex2> var2:long\r\n\t```\r\n\tThe regex that will be generated by the parse internally is `.*?<regex1>(.*?)<regex2>(\\-\\d+)`.\r\n\t\t\r\n\t- `*` was translated to `.*?`.\r\n\t\t\r\n\t- `string` was translated to `.*?`.\r\n\t\t\r\n\t- `long` was translated to `\\-\\d+`.\r\n## Examples\r\nThe `parse-where` operator provides a streamlined way to `extend` a table by using multiple `extract` applications on the same `string` expression. This is most useful when the table has a `string` column that contains several values that you want to break into individual columns. For example, you can break up a column that was produced by a developer trace ("`printf`"/"`Console.WriteLine`") statement.\r\n### Using `parse`\r\nIn the example below, the column `EventText` of table `Traces` contains strings of the form `Event: NotifySliceRelease (resourceName={0}, totalSlices= {1}, sliceNumber={2}, lockTime={3}, releaseTime={4}, previousLockTime={5})`. The operation below will extend the table with six columns: `resourceName` , `totalSlices`, `sliceNumber`, `lockTime `, `releaseTime`, `previouLockTime`, `Month`, and `Day`. \r\nA few of the strings don\'t have a full match.\r\nUsing `parse`, the calculated columns will have nulls.\r\n\r\n```\r\n\r\nlet Traces = datatable(EventText:string)\r\n[\r\n"Event: NotifySliceRelease (resourceName=PipelineScheduler, totalSlices=27, sliceNumber=invalid_number, lockTime=02/17/2016 08:40:01, releaseTime=02/17/2016 08:40:01, previousLockTime=02/17/2016 08:39:01)",\r\n"Event: NotifySliceRelease (resourceName=PipelineScheduler, totalSlices=27, sliceNumber=15, lockTime=02/17/2016 08:40:00, releaseTime=invalid_datetime, previousLockTime=02/17/2016 08:39:00)",\r\n"Event: NotifySliceRelease (resourceName=PipelineScheduler, totalSlices=27, sliceNumber=20, lockTime=02/17/2016 08:40:01, releaseTime=02/17/2016 08:40:01, previousLockTime=02/17/2016 08:39:01)",\r\n"Event: NotifySliceRelease (resourceName=PipelineScheduler, totalSlices=27, sliceNumber=22, lockTime=02/17/2016 08:41:01, releaseTime=02/17/2016 08:41:00, previousLockTime=02/17/2016 08:40:01)",\r\n"Event: NotifySliceRelease (resourceName=PipelineScheduler, totalSlices=invalid_number, sliceNumber=16, lockTime=02/17/2016 08:41:00, releaseTime=02/17/2016 08:41:00, previousLockTime=02/17/2016 08:40:00)"\r\n];\r\nTraces  \r\n| parse EventText with * "resourceName=" resourceName ", totalSlices=" totalSlices:long * "sliceNumber=" sliceNumber:long * "lockTime=" lockTime ", releaseTime=" releaseTime:date "," * "previousLockTime=" previouLockTime:date ")" *  \r\n| project resourceName ,totalSlices , sliceNumber , lockTime , releaseTime , previousLockTime\r\n\r\n```\r\n|resourceName|totalSlices|sliceNumber|lockTime|releaseTime|previousLockTime|\r\n|---|---|---|---|---|---|\r\n|||||||\r\n|||||||\r\n|||||||\r\n|PipelineScheduler|27|20|02/17/2016 08:40:01|2016-02-17 08:40:01.0000000|2016-02-17 08:39:01.0000000|\r\n|PipelineScheduler|27|22|02/17/2016 08:41:01|2016-02-17 08:41:00.0000000|2016-02-17 08:40:01.0000000|\r\n### Using `parse-where` \r\nUsing \'parse-where\' will filter-out unsuccessfully parsed strings from the result.\r\n\r\n```\r\n\r\nlet Traces = datatable(EventText:string)\r\n[\r\n"Event: NotifySliceRelease (resourceName=PipelineScheduler, totalSlices=27, sliceNumber=invalid_number, lockTime=02/17/2016 08:40:01, releaseTime=02/17/2016 08:40:01, previousLockTime=02/17/2016 08:39:01)",\r\n"Event: NotifySliceRelease (resourceName=PipelineScheduler, totalSlices=27, sliceNumber=15, lockTime=02/17/2016 08:40:00, releaseTime=invalid_datetime, previousLockTime=02/17/2016 08:39:00)",\r\n"Event: NotifySliceRelease (resourceName=PipelineScheduler, totalSlices=27, sliceNumber=20, lockTime=02/17/2016 08:40:01, releaseTime=02/17/2016 08:40:01, previousLockTime=02/17/2016 08:39:01)",\r\n"Event: NotifySliceRelease (resourceName=PipelineScheduler, totalSlices=27, sliceNumber=22, lockTime=02/17/2016 08:41:01, releaseTime=02/17/2016 08:41:00, previousLockTime=02/17/2016 08:40:01)",\r\n"Event: NotifySliceRelease (resourceName=PipelineScheduler, totalSlices=invalid_number, sliceNumber=16, lockTime=02/17/2016 08:41:00, releaseTime=02/17/2016 08:41:00, previousLockTime=02/17/2016 08:40:00)"\r\n];\r\nTraces  \r\n| parse-where EventText with * "resourceName=" resourceName ", totalSlices=" totalSlices:long * "sliceNumber=" sliceNumber:long * "lockTime=" lockTime ", releaseTime=" releaseTime:date "," * "previousLockTime=" previousLockTime:date ")" *  \r\n| project resourceName ,totalSlices , sliceNumber , lockTime , releaseTime , previousLockTime\r\n\r\n```\r\n|resourceName|totalSlices|sliceNumber|lockTime|releaseTime|previousLockTime|\r\n|---|---|---|---|---|---|\r\n|PipelineScheduler|27|20|02/17/2016 08:40:01|2016-02-17 08:40:01.0000000|2016-02-17 08:39:01.0000000|\r\n|PipelineScheduler|27|22|02/17/2016 08:41:01|2016-02-17 08:41:00.0000000|2016-02-17 08:40:01.0000000|\r\n\r\n### Regex mode using regex flags\r\nTo get the resourceName and totalSlices, use the following query:\r\n\r\n```\r\n\r\nlet Traces = datatable(EventText:string)\r\n[\r\n"Event: NotifySliceRelease (resourceName=PipelineScheduler, totalSlices=non_valid_integer, sliceNumber=11, lockTime=02/17/2016 08:40:01, releaseTime=02/17/2016 08:40:01, previousLockTime=02/17/2016 08:39:01)",\r\n"Event: NotifySliceRelease (resourceName=PipelineScheduler, totalSlices=27, sliceNumber=15, lockTime=02/17/2016 08:40:00, releaseTime=02/17/2016 08:40:00, previousLockTime=02/17/2016 08:39:00)",\r\n"Event: NotifySliceRelease (resourceName=PipelineScheduler, totalSlices=non_valid_integer, sliceNumber=44, lockTime=02/17/2016 08:40:01, releaseTime=02/17/2016 08:40:01, previousLockTime=02/17/2016 08:39:01)",\r\n"Event: NotifySliceRelease (resourceName=PipelineScheduler, totalSlices=27, sliceNumber=22, lockTime=02/17/2016 08:41:01, releaseTime=02/17/2016 08:41:00, previousLockTime=02/17/2016 08:40:01)",\r\n"Event: NotifySliceRelease (resourceName=PipelineScheduler, totalSlices=27, sliceNumber=16, lockTime=02/17/2016 08:41:00, releaseTime=02/17/2016 08:41:00, previousLockTime=02/17/2016 08:40:00)"\r\n];\r\nTraces\r\n| parse-where kind = regex EventText with * "RESOURCENAME=" resourceName "," * "totalSlices=" totalSlices:long "," *\r\n| project resourceName, totalSlices\r\n\r\n```\r\n### `parse-where` with case-insensitive regex flag\r\nIn the above query, the default mode was case-sensitive, so the strings were parsed successfully. No result was obtained.\r\nTo get the required result, run `parse-where` with a case-insensitive (`i`) regex flag.\r\nOnly three strings will be parsed successfully, so the result is three records (some totalSlices hold invalid integers).\r\n\r\n```\r\n\r\nlet Traces = datatable(EventText:string)\r\n[\r\n"Event: NotifySliceRelease (resourceName=PipelineScheduler, totalSlices=non_valid_integer, sliceNumber=11, lockTime=02/17/2016 08:40:01, releaseTime=02/17/2016 08:40:01, previousLockTime=02/17/2016 08:39:01)",\r\n"Event: NotifySliceRelease (resourceName=PipelineScheduler, totalSlices=27, sliceNumber=15, lockTime=02/17/2016 08:40:00, releaseTime=02/17/2016 08:40:00, previousLockTime=02/17/2016 08:39:00)",\r\n"Event: NotifySliceRelease (resourceName=PipelineScheduler, totalSlices=non_valid_integer, sliceNumber=44, lockTime=02/17/2016 08:40:01, releaseTime=02/17/2016 08:40:01, previousLockTime=02/17/2016 08:39:01)",\r\n"Event: NotifySliceRelease (resourceName=PipelineScheduler, totalSlices=27, sliceNumber=22, lockTime=02/17/2016 08:41:01, releaseTime=02/17/2016 08:41:00, previousLockTime=02/17/2016 08:40:01)",\r\n"Event: NotifySliceRelease (resourceName=PipelineScheduler, totalSlices=27, sliceNumber=16, lockTime=02/17/2016 08:41:00, releaseTime=02/17/2016 08:41:00, previousLockTime=02/17/2016 08:40:00)"\r\n];\r\nTraces\r\n| parse-where kind = regex flags=i EventText with * "RESOURCENAME=" resourceName "," * "totalSlices=" totalSlices:long "," *\r\n| project resourceName, totalSlices\r\n\r\n```\r\n|resourceName|totalSlices|\r\n|---|---|\r\n|PipelineScheduler|27|\r\n|PipelineScheduler|27|\r\n|PipelineScheduler|27|',"","https://docs.microsoft.com/en-us/azure/kusto/query/parsewhereoperator","")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.OperatorToken,"partition","The partition operator partitions its input table into multiple sub-tables\r\naccording to the values of the specified column, executes a sub-query over each\r\nsub-table, and produces a single output table that is the union of the results\r\nof all sub-queries.",'```\r\nT | partition by Col1 ( top 10 by MaxValue )\r\nT | partition by Col1 { U | where Col2=toscalar(Col1) }\r\n```\r\n\r\n## Syntax\r\n\r\n*T* `|` `partition` [*PartitionParameters*] `by` *Column* `(` *ContextualSubquery* `)`\r\n\r\n*T* `|` `partition` [*PartitionParameters*] `by` *Column* `{` *Subquery* `}`\r\n\r\n## Arguments\r\n\r\n* *T*: The tabular source whose data is to be processed by the operator.\r\n* *Column*: The name of a column in *T* whose values determine how the input table\r\n  is to be partitioned. See **Notes** below.\r\n* *ContextualSubquery*: A tabular expression, which source is the source of the `partition` operator, scoped for a single *key* value.\r\n* *Subquery*: A tabular expression without source. The *key* value can be obtained via `toscalar()` call.\r\n* *PartitionParameters*: Zero or more (space-separated) parameters in the form of:\r\n  *Name* `=` *Value* that control the behavior\r\n  of the operator. The following parameters are supported:\r\n  |Name               |Values         |Description|\r\n  |-------------------|---------------|-----------|\r\n  |`hint.materialized`|`true`,`false` |If set to `true` will materialize the source of the `partition` operator (default: `false`)|\r\n  |`hint.concurrency`|*Number*|Hints the system how many concurrent subqueries of the `partition` operator should be executed in parallel. *Default*: Amount of CPU cores on the single node of the cluster (2 to 16).|\r\n  |`hint.spread`|*Number*|Hints the system how many nodes should be used by the concurrent`partition` subqueries execution. *Default*: 1.|\r\n\r\n## Returns\r\n\r\nThe operator returns a union of the results of applying the subquery to each\r\npartition of the input data.\r\n\r\n**Notes**\r\n\r\n* The partition operator is currently limited by the number of partitions.\r\n  Up to 64 distinct partitions may be created.\r\n  The operator will yield an error if the partition column (*Column*) has more\r\n  than 64 distinct values.\r\n* The subquery references the input partition implicitly (there\'s no "name" for\r\n  the partition in the subquery). To reference the input partition multiple times\r\n  within the subquery, use the [as operator](asoperator.md), as in\r\n  **Example: partition-reference** below.\r\n\r\n**Example: top-nested case**\r\n\r\nAt some cases - it is more performant and easier to write query using `partition` operator rather using [`top-nested` operator](topnestedoperator.md)\r\nThe next example runs a sub-query calculating `summarize` and `top` for-each of States starting with `W`: (WYOMING, WASHINGTON, WEST VIRGINIA, WISCONSIN)\r\n\r\n```\r\nStormEvents\r\n| where State startswith \'W\'\r\n| partition by State \r\n(\r\n    summarize Events=count(), Injuries=sum(InjuriesDirect) by EventType, State\r\n    | top 3 by Events \r\n) \r\n```\r\n\r\n|EventType|State|Events|Injuries|\r\n|---|---|---|---|\r\n|Hail|WYOMING|108|0|\r\n|High Wind|WYOMING|81|5|\r\n|Winter Storm|WYOMING|72|0|\r\n|Heavy Snow|WASHINGTON|82|0|\r\n|High Wind|WASHINGTON|58|13|\r\n|Wildfire|WASHINGTON|29|0|\r\n|Thunderstorm Wind|WEST VIRGINIA|180|1|\r\n|Hail|WEST VIRGINIA|103|0|\r\n|Winter Weather|WEST VIRGINIA|88|0|\r\n|Thunderstorm Wind|WISCONSIN|416|1|\r\n|Winter Storm|WISCONSIN|310|0|\r\n|Hail|WISCONSIN|303|1|\r\n\r\n**Example: query non-overlapping data partitions**\r\n\r\nSometimes it is useful (perf-wise) to run a complex subquery over non-overlapping\r\ndata partitions in a map/reduce style. The example below shows how to create a\r\nmanual distribution of aggregation over 10 partitions.\r\n\r\n```\r\nStormEvents\r\n| extend p = hash(EventId, 10)\r\n| partition by p\r\n(\r\n    summarize Count=count() by Source \r\n)\r\n| summarize Count=sum(Count) by Source\r\n| top 5 by Count\r\n```\r\n\r\n|Source|Count|\r\n|---|---|\r\n|Trained Spotter|12770|\r\n|Law Enforcement|8570|\r\n|Public|6157|\r\n|Emergency Manager|4900|\r\n|COOP Observer|3039|\r\n\r\n**Example: query-time partitioning**\r\n\r\nThe following example shows how query can be partitioned into N=10 partitions,\r\nwhere each partition calculates its own Count, and all later summarized into TotalCount.\r\n\r\n```\r\nlet N = 10;                 // Number of query-partitions\r\nrange p from 0 to N-1 step 1  // \r\n| partition by p            // Run the sub-query partitioned \r\n{\r\n    StormEvents \r\n    | where hash(EventId, N) == toscalar(p) // Use toscalar() to fetch partition key value\r\n    | summarize Count = count()\r\n}\r\n| summarize TotalCount=sum(Count) \r\n```\r\n\r\n|TotalCount|\r\n|---|\r\n|59066|\r\n\r\n**Example: partition-reference**\r\n\r\nThe following example shows how one can use the [as operator](asoperator.md) to\r\ngive a "name" to each data partition and then reuse that name within the subquery:\r\n\r\n```\r\nT\r\n| partition by Dim\r\n(\r\n    as Partition\r\n    | extend MetricPct = Metric * 100.0 / toscalar(Partition | summarize sum(Metric))\r\n)\r\n```\r\n\r\n**Example: complex subquery hidden by a function call**\r\n\r\nThe same technique can be applied with much more complex subqueries. To simplify\r\nthe syntax, one can wrap the subquery in a function call:\r\n\r\n```\r\nlet partition_function = (T:(Source:string)) \r\n{\r\n    T\r\n    | summarize Count=count() by Source\r\n};\r\nStormEvents\r\n| extend p = hash(EventId, 10)\r\n| partition by p\r\n(\r\n    invoke partition_function()\r\n)\r\n| summarize Count=sum(Count) by Source\r\n| top 5 by Count\r\n```\r\n\r\n|Source|Count|\r\n|---|---|\r\n|Trained Spotter|12770|\r\n|Law Enforcement|8570|\r\n|Public|6157|\r\n|Emergency Manager|4900|\r\n|COOP Observer|3039|',"","https://docs.microsoft.com/en-us/azure/kusto/query/partitionoperator","")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"percentile","Returns an estimate for the specified [nearest-rank percentile](#nearest-rank-percentile) of the population defined by `*Expr*`.\r\nThe accuracy depends on the density of population in the region of the percentile. This function can be used only in context of aggregation inside [summarize](summarizeoperator.md)",'* `percentiles()` is like `percentile()`, but calculates a number of percentile values, which is faster than calculating each percentile individually.\r\n* `percentilesw()` is like `percentilew()`, but calculates a number of weighted percentile values, which is faster than calculating each percentile individually.\r\n* `percentilew()` and `percentilesw()` let you calculate weighted percentiles. Weighted percentiles calculate the given percentiles in a "weighted" way, by treating each value as if it was repeated `weight` times, in the input.\r\n\r\n## Syntax\r\n\r\nsummarize `percentile(`*Expr*`,` *Percentile*`)`\r\n\r\nsummarize `percentiles(`*Expr*`,` *Percentile1* [`,` *Percentile2*]`)`\r\n\r\nsummarize `percentiles_array(`*Expr*`,` *Percentile1* [`,` *Percentile2*]`)`\r\n\r\nsummarize `percentiles_array(`*Expr*`,` *Dynamic array*`)`\r\n\r\nsummarize `percentilew(`*Expr*`,` *WeightExpr*`,` *Percentile*`)`\r\n\r\nsummarize `percentilesw(`*Expr*`,` *WeightExpr*`,` *Percentile1* [`,` *Percentile2*]`)`\r\n\r\nsummarize `percentilesw_array(`*Expr*`,` *WeightExpr*`,` *Percentile1* [`,` *Percentile2*]`)`\r\n\r\nsummarize `percentilesw_array(`*Expr*`,` *WeightExpr*`,` *Dynamic array*`)`\r\n\r\n## Arguments\r\n\r\n* `*Expr*`: Expression that will be used for aggregation calculation.\r\n* `*WeightExpr*`: Expression that will be used as the weight of values for aggregation calculation.\r\n* `*Percentile*`: A double constant that specifies the percentile.\r\n* `*Dynamic array*`: list of percentiles in a dynamic array of integer or floating point numbers.\r\n\r\n## Returns\r\n\r\nReturns an estimate for `*Expr*` of the specified percentiles in the group.',"The value of `Duration` that is larger than 95% of the sample set and smaller than 5% of the sample set.\r\n\r\n```\r\nCallDetailRecords | summarize percentile(Duration, 95) by continent\r\n```\r\n\r\nSimultaneously calculate 5, 50 (median) and 95.\r\n\r\n```\r\nCallDetailRecords \r\n| summarize percentiles(Duration, 5, 50, 95) by continent\r\n```\r\n\r\n![Percentiles](images/percentiles-aggfunction/percentiles.png)\r\nThe results show that in Europe, 5% of calls are shorter than 11.55s, 50% of calls are shorter than 3 minutes, 18.46 seconds, and 95% of calls are shorter than 40 minutes 48 seconds.\r\n\r\n```\r\nCallDetailRecords \r\n| summarize percentiles(Duration, 5, 50, 95), avg(Duration)\r\n```\r\n\r\n## Weighted percentiles\r\n\r\nAssume you repetitively measure the time (Duration) it takes an action to complete. Instead of recording every value of the measurement, you record each value of Duration, rounded to 100 msec, and how many times the rounded value appeared (BucketSize).\r\n\r\nUse `summarize percentilesw(Duration, BucketSize, ...)` to calculate the given\r\npercentiles in a \"weighted\" way. Treat each value of Duration as if it was repeated\r\nBucketSize times in the input, without actually needing to materialize those records.\r\n\r\n## Example\r\n\r\nA customer has a set of latency values in milliseconds:\r\n`{ 1, 1, 2, 2, 2, 5, 7, 7, 12, 12, 15, 15, 15, 18, 21, 22, 26, 35 }`.\r\n\r\nTo reduce bandwidth and storage, do pre-aggregation to the\r\nfollowing buckets: `{ 10, 20, 30, 40, 50, 100 }`. Count the number of events in each bucket to produce the following  table:\r\n\r\n![Percentilesw table](images/percentiles-aggfunction/percentilesw-table.png)\r\nThe table displays:\r\n\r\n* Eight events in the 10-ms bucket (corresponding to subset `{ 1, 1, 2, 2, 2, 5, 7, 7 }`)\r\n * Six events in the 20-ms bucket (corresponding to subset `{ 12, 12, 15, 15, 15, 18 }`)\r\n * Three events in the 30-ms bucket (corresponding to subset `{ 21, 22, 26 }`)\r\n * One event  in the 40-ms bucket (corresponding to subset `{ 35 }`)\r\n\r\n\r\nAt this point, the original data is no longer available. Only the number of events in each bucket. To compute percentiles from this data, use the `percentilesw()` function.\r\nFor example, for the 50, 75, and 99.9 percentiles, use the following query.\r\n\r\n```\r\ndatatable (ReqCount:long, LatencyBucket:long) \r\n[ \r\n    8, 10, \r\n    6, 20, \r\n    3, 30, \r\n    1, 40 \r\n]\r\n| summarize percentilesw(LatencyBucket, ReqCount, 50, 75, 99.9) \r\n```\r\n\r\nThe result for the above query is:\r\n\r\n![Percentilesw result](images/percentiles-aggfunction/percentilesw-result.png)\r\n\r\nThe above query corresponds to the function\r\n`percentiles(LatencyBucket, 50, 75, 99.9)`, if the data was expanded to the following form:\r\n\r\n![Percentilesw raw table](images/percentiles-aggfunction/percentilesw-rawtable.png)\r\n\r\n## Getting multiple percentiles in an array\r\n\r\nMultiple percentiles can be obtained as an array in a single dynamic column, instead of in multiple columns.\r\n\r\n```\r\nCallDetailRecords \r\n| summarize percentiles_array(Duration, 5, 25, 50, 75, 95), avg(Duration)\r\n```\r\n\r\n![Percentiles array result](images/percentiles-aggfunction/percentiles-array-result.png)\r\nSimilarly, weighted percentiles can be returned as a dynamic array using `percentilesw_array`.\r\n\r\nPercentiles for `percentiles_array` and `percentilesw_array` can be specified in a dynamic array of integer or floating-point numbers. The array must be constant but doesn't have to be literal.\r\n\r\n```\r\nCallDetailRecords \r\n| summarize percentiles_array(Duration, dynamic([5, 25, 50, 75, 95])), avg(Duration)\r\n```\r\n\r\n```\r\nCallDetailRecords \r\n| summarize percentiles_array(Duration, range(0, 100, 5)), avg(Duration)\r\n```\r\n\r\n## Nearest-rank percentile\r\n\r\n*P*-th percentile (0 < *P* <= 100) of a list of ordered values, sorted from least to greatest, is the smallest value in the list. The *P* percent of the data is less or equal to *P*-th percentile value ([from Wikipedia article on percentiles](https://en.wikipedia.org/wiki/Percentile#The_Nearest_Rank_method)).\r\n\r\nDefine *0*-th percentiles to be the smallest member of the population.\r\n\r\n>[!NOTE]\r\n> Given the approximating nature of the calculation, the actual returned value may not be a member of the population.\r\n> Nearest-rank definition means that *P*=50 does not conform to the [interpolative definition of the median](https://en.wikipedia.org/wiki/Median). When evaluating the significance of this discrepancy for the specific application, the size of the population and an [estimation error](#estimation-error-in-percentiles) should be taken into account.\r\n\r\n## Estimation error in percentiles\r\n\r\nThe percentiles aggregate provides an approximate value using [T-Digest](https://github.com/tdunning/t-digest/blob/master/docs/t-digest-paper/histo.pdf).\r\n\r\n>[!NOTE]\r\n> * The bounds on the estimation error vary with the value of the requested percentile. The best accuracy is at both ends of the [0..100] scale. Percentiles 0 and 100 are the exact minimum and maximum values of the distribution. The accuracy gradually decreases towards the middle of the scale. It's worst at the median and is capped at 1%.\r\n> * Error bounds are observed on the rank, not on the value. Suppose percentile(X, 50) returned a value of Xm. The estimate guarantees that at least 49% and at most 51% of the values of X are less or equal to Xm. There is no theoretical limit on the difference between Xm and the actual median value of X.\r\n> * The estimation may sometimes result in a precise value but there are no reliable conditions to define when it will be the case.","https://docs.microsoft.com/en-us/azure/kusto/query/percentiles-aggfunction","percentiles-aggfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"percentile_tdigest","Calculates the percentile result from the `tdigest` results (which was generated by [tdigest()](tdigest-aggfunction.md) or [tdigest_merge()](tdigest-merge-aggfunction.md))","## Syntax\r\n\r\n`percentile_tdigest(`*`Expr`*`,` *Percentile1* [`,` *typeLiteral*]`)`\r\n\r\n`percentiles_array_tdigest(`*`Expr`*`,` *Percentile1* [`,` *Percentile2*] ...[`,` *PercentileN*]`)`\r\n\r\n`percentiles_array_tdigest(`*`Expr`*`,` *Dynamic array*`)`\r\n\r\n## Arguments\r\n\r\n* *Expr*: Expression that was generated by [`tdigest`](tdigest-aggfunction.md) or [tdigest_merge()](tdigest-merge-aggfunction.md).\r\n* *Percentile* is a double constant that specifies the percentile.\r\n* *typeLiteral*: An optional type literal (for example, `typeof(long)`). If provided, the result set will be of this type. \r\n* *Dynamic array*: list of percentiles in a dynamic array of integer or floating point numbers.\r\n\r\n## Returns\r\n\r\nThe percentiles/percentilesw value of each value in *`Expr`*.\r\n\r\n**Tips**\r\n\r\n* The function must receive at least one percent (and maybe more, see the syntax above: *Percentile1* [`,` *Percentile2*] ...[`,` *PercentileN*]) and the result will be\r\n  a dynamic array that includes the results. (such like [`percentiles()`](percentiles-aggfunction.md))\r\n  \r\n* If only one percent was provided, and the type was provided also, then the result will be a column of the same type provided with the results of that percent. In this case, all `tdigest` functions must be of that type.\r\n* If *`Expr`* includes `tdigest` functions of different types, don't provide the type. The result will be of type dynamic. See below examples.",'```\r\nStormEvents\r\n| summarize tdigestRes = tdigest(DamageProperty) by State\r\n| project percentile_tdigest(tdigestRes, 100, typeof(int))\r\n```\r\n\r\n|percentile_tdigest_tdigestRes|\r\n|---|\r\n|0|\r\n|62000000|\r\n|110000000|\r\n|1200000|\r\n|250000|\r\n\r\n```\r\nStormEvents\r\n| summarize tdigestRes = tdigest(DamageProperty) by State\r\n| project percentiles_array_tdigest(tdigestRes, range(0, 100, 50), typeof(int))\r\n```\r\n\r\n|percentile_tdigest_tdigestRes|\r\n|---|\r\n|[0,0,0]|\r\n|[0,0,62000000]|\r\n|[0,0,110000000]|\r\n|[0,0,1200000]|\r\n|[0,0,250000]|\r\n\r\n```\r\nStormEvents\r\n| summarize tdigestRes = tdigest(DamageProperty) by State\r\n| union (StormEvents | summarize tdigestRes = tdigest(EndTime) by State)\r\n| project percentile_tdigest(tdigestRes, 100)\r\n```\r\n\r\n|percentile_tdigest_tdigestRes|\r\n|---|\r\n|[0]|\r\n|[62000000]|\r\n|["2007-12-20T11:30:00.0000000Z"]|\r\n|["2007-12-31T23:59:00.0000000Z"]|',"https://docs.microsoft.com/en-us/azure/kusto/query/percentile-tdigestfunction","percentile-tdigestfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"percentrank_tdigest","Calculates the approximate rank of the value in a set, where rank is expressed as a percentage of the set's size.\r\nThis function can be viewed as the inverse of the percentile.","## Syntax\r\n\r\n`percentrank_tdigest(`*TDigest*`,` *Expr*`)`\r\n\r\n## Arguments\r\n\r\n* *TDigest*: Expression that was generated by [tdigest()](tdigest-aggfunction.md) or [tdigest_merge()](tdigest-merge-aggfunction.md).\r\n* *Expr*: Expression representing a value to be used for percentage ranking calculation.\r\n\r\n## Returns\r\n\r\nThe percentage rank of value in a dataset.\r\n\r\n**Tips**\r\n\r\n1) The type of second parameter and the type of the elements in the `tdigest` should be the same.\r\n2) First parameter should be TDigest that was generated by [tdigest()](tdigest-aggfunction.md) or [tdigest_merge()](tdigest-merge-aggfunction.md)","Getting the percentrank_tdigest() of the damage property that valued 4490$ is ~85%:\r\n\r\n```\r\nStormEvents\r\n| summarize tdigestRes = tdigest(DamageProperty)\r\n| project percentrank_tdigest(tdigestRes, 4490)\r\n\r\n```\r\n\r\n|Column1|\r\n|---|\r\n|85.0015237192293|\r\n\r\nUsing percentile 85 over the damage property should give 4490$:\r\n\r\n```\r\nStormEvents\r\n| summarize tdigestRes = tdigest(DamageProperty)\r\n| project percentile_tdigest(tdigestRes, 85, typeof(long))\r\n\r\n```\r\n\r\n|percentile_tdigest_tdigestRes|\r\n|---|\r\n|4490|","https://docs.microsoft.com/en-us/azure/kusto/query/percentrank-tdigestfunction","percentrank-tdigestfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"pi","Returns the constant value of Pi.","## Syntax\r\n\r\n`pi()`\r\n\r\n## Returns\r\n\r\n* The double value of Pi (3.1415926...)","","https://docs.microsoft.com/en-us/azure/kusto/query/pifunction","")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"pow","Returns a result of raising to power","## Syntax\r\n\r\n`pow(`*base*`,` *exponent* `)`\r\n\r\n## Arguments\r\n\r\n* *base*: Base value.\r\n* *exponent*: Exponent value.\r\n\r\n## Returns\r\n\r\nReturns base raised to the power exponent: base ^ exponent.","","https://docs.microsoft.com/en-us/azure/kusto/query/powfunction","")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"prev","Returns the value of a specific column in a specified row.\r\nThe specified row is at a specified offset from the current row in a [serialized row set](./windowsfunctions.md#serialized-row-set).","## Syntax\r\n\r\nThere are several possibilities.\r\n\r\n* `prev(column)`\r\n* `prev(column, offset)`\r\n* `prev(column, offset, default_value)`\r\n\r\n## Arguments\r\n\r\n* `column`: The column to get the values from.\r\n* `offset`: The offset to go back in rows. When no offset is specified, a default offset 1 is used.\r\n* `default_value`: The default value to be used when there are no previous rows to take the value from. When no default value is specified, null is used.","```\r\nTable | serialize | extend prevA = prev(A,1)\r\n| extend diff = A - prevA\r\n| where diff > 1\r\n\r\nTable | serialize prevA = prev(A,1,10)\r\n| extend diff = A - prevA\r\n| where diff <= 10\r\n```","https://docs.microsoft.com/en-us/azure/kusto/query/prevfunction","prevfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.OperatorToken,"print","Outputs single-row with one or more scalar expressions.",'```\r\nprint x=1, s=strcat("Hello", ", ", "World!")\r\n```\r\n\r\n## Syntax\r\n\r\n`print` [*ColumnName* `=`] *ScalarExpression* [\',\' ...]\r\n\r\n## Arguments\r\n\r\n* *ColumnName*: An option name to assign to the output\'s singular column.\r\n* *ScalarExpression*: A scalar expression to evaluate.\r\n\r\n## Returns\r\n\r\nA single-column, single-row, table whose single cell has the value of the evaluated *ScalarExpression*.','The `print` operator is useful as a quick way to evaluate one or more\r\nscalar expressions and make a single-row table out of the resulting values.\r\nFor example:\r\n\r\n```\r\nprint 0 + 1 + 2 + 3 + 4 + 5, x = "Wow!"\r\n```\r\n\r\n```\r\nprint banner=strcat("Hello", ", ", "World!")\r\n```',"https://docs.microsoft.com/en-us/azure/kusto/query/printoperator","printoperator.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.OperatorToken,"project","Select the columns to include, rename or drop, and insert new computed columns.","The order of the columns in the result is specified by the order of the arguments. Only the columns specified in the arguments are included in the result. Any other columns in the input are dropped.  (See also `extend`.)\r\n\r\n```\r\nT | project cost=price*quantity, price\r\n```\r\n\r\n## Syntax\r\n\r\n*T* `| project` *ColumnName* [`=` *Expression*] [`,` ...]\r\n\r\nor\r\n\r\n*T* `| project` [*ColumnName* | `(`*ColumnName*[`,`]`)` `=`] *Expression* [`,` ...]\r\n\r\n## Arguments\r\n\r\n* *T*: The input table.\r\n* *ColumnName:* Optional name of a column to appear in the output. If there is no *Expression*, then *ColumnName* is mandatory and a column of that name must appear in the input. If omitted, the name will be automatically generated. If *Expression* returns more than one column, a list of column names can be specified in parentheses. In this case *Expression*'s output columns will be given the specified names, dropping all rest of the output columns, if there are any. If list of the column names is not specified, all *Expression*'s output columns with generated names will be added to the output.\r\n* *Expression:* Optional scalar expression referencing the input columns. If *ColumnName* is not omitted then *Expression* is mandatory.\r\n    It is legal to return a new calculated column with the same name as an existing column in the input.\r\n\r\n## Returns\r\n\r\nA table that has the columns named as arguments, and as many rows as the input table.",'The following example shows several kinds of manipulations that can be done\r\nusing the `project` operator. The input table `T` has three columns of type `int`: `A`, `B`, and `C`. \r\n\r\n```\r\nT\r\n| project\r\n    X=C,                       // Rename column C to X\r\n    A=2*B,                     // Calculate a new column A from the old B\r\n    C=strcat("-",tostring(C)), // Calculate a new column C from the old C\r\n    B=2*B                      // Calculate a new column B from the old B\r\n```\r\n\r\n[series_stats](series-statsfunction.md) is an example of a function that returns multiple columns.',"https://docs.microsoft.com/en-us/azure/kusto/query/projectoperator","projectoperator.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.OperatorToken,"project-away","Select what columns in the input to exclude from the output","```\r\nT | project-away price, quantity, zz*\r\n```\r\n\r\nThe order of the columns in the result is determined by their original order in the table. Only the columns that were specified as arguments are dropped. The other columns are included in the result.  (See also `project`.)\r\n\r\n## Syntax\r\n\r\n*T* `| project-away` *ColumnNameOrPattern* [`,` ...]\r\n\r\n## Arguments\r\n\r\n* *T*: The input table\r\n* *ColumnNameOrPattern:* The name of the column or column wildcard-pattern to be removed from the output.\r\n\r\n## Returns\r\n\r\nA table with columns that were not named as arguments. Contains same number of rows as the input table.\r\n\r\n**Tips**\r\n\r\n* Use [`project-rename`](projectrenameoperator.md) if your intention is to rename columns.\r\n* Use [`project-reorder`](projectreorderoperator.md) if your intention is to reorder columns.\r\n* You can `project-away` any columns that are present in the original table or that were computed as part of the query.","The input table `T` has three columns of type `long`: `A`, `B`, and `C`.\r\n\r\n```\r\ndatatable(A:long, B:long, C:long) [1, 2, 3]\r\n| project-away C    // Removes column C from the output\r\n```\r\n\r\n|A|B|\r\n|---|---|\r\n|1|2|\r\n\r\nRemoving columns starting with 'a'.\r\n\r\n```\r\nprint  a2='a2', b = 'b', a3='a3', a1='a1'\r\n|  project-away a* \r\n```\r\n\r\n|b|\r\n|---|\r\n|b|","https://docs.microsoft.com/en-us/azure/kusto/query/projectawayoperator","projectawayoperator.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.OperatorToken,"project-rename","Renames columns in the result output.","```\r\nT | project-rename new_column_name = column_name\r\n```\r\n\r\n## Syntax\r\n\r\n*T* `| project-rename` *NewColumnName* = *ExistingColumnName* [`,` ...]\r\n\r\n## Arguments\r\n\r\n* *T*: The input table.\r\n* *NewColumnName:* The new name of a column. \r\n* *ExistingColumnName:* The existing name of a column. \r\n\r\n## Returns\r\n\r\nA table that has the columns in the same order as in an existing table, with columns renamed.","```\r\nprint a='a', b='b', c='c'\r\n|  project-rename new_b=b, new_a=a\r\n```\r\n\r\n|new_a|new_b|c|\r\n|---|---|---|\r\n|a|b|c|","https://docs.microsoft.com/en-us/azure/kusto/query/projectrenameoperator","projectrenameoperator.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.OperatorToken,"project-reorder","Reorders columns in the result output.","```\r\nT | project-reorder Col2, Col1, Col* asc\r\n```\r\n\r\n## Syntax\r\n\r\n*T* `| project-reorder` *ColumnNameOrPattern* [`asc`|`desc`] [`,` ...]\r\n\r\n## Arguments\r\n\r\n* *T*: The input table.\r\n* *ColumnNameOrPattern:* The name of the column or column wildcard pattern added to the output.\r\n* For wildcard patterns: specifying `asc` or `desc` orders columns using their names in ascending or descending order. If `asc` or `desc` aren't specified, the order is determined by the matching columns as they appear in the source table.\r\n\r\n> [!NOTE]\r\n> * In ambiguous *ColumnNameOrPattern* matching, the column appears in the first position matching the pattern.\r\n> * Specifying columns for the `project-reorder` is optional. Columns that aren't specified explicitly appear as the last columns of the output table.\r\n> * Use [`project-away`](projectawayoperator.md) to remove columns.\r\n> * Use [`project-rename`](projectrenameoperator.md) to rename columns.\r\n\r\n## Returns\r\n\r\nA table that contains columns in the order specified by the operator arguments. `project-reorder` doesn't rename or remove columns from the table, therefore, all columns that existed in the source table, appear in the result table.","Reorder a table with three columns (a, b, c) so the second column (b) will appear first.\r\n\r\n```\r\nprint a='a', b='b', c='c'\r\n|  project-reorder b\r\n```\r\n\r\n|b|a|c|\r\n|---|---|---|\r\n|b|a|c|\r\n\r\nReorder columns of a table so that columns starting with `a` will appear before other columns.\r\n\r\n```\r\nprint b = 'b', a2='a2', a3='a3', a1='a1'\r\n|  project-reorder a* asc\r\n```\r\n\r\n|a1|a2|a3|b|\r\n|---|---|---|---|\r\n|a1|a2|a3|b|","https://docs.microsoft.com/en-us/azure/kusto/query/projectreorderoperator","projectreorderoperator.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"radians","Converts angle value in degrees into value in radians, using formula `radians = (PI / 180 ) * angle_in_degrees`","## Syntax\r\n\r\n`radians(`*a*`)`\r\n\r\n## Arguments\r\n\r\n* *a*: Angle in degrees (a real number).\r\n\r\n## Returns\r\n\r\n* The corresponding angle in radians for an angle specified in degrees.","```\r\nprint radians0 = radians(90), radians1 = radians(180), radians2 = radians(360) \r\n\r\n```\r\n\r\n|radians0|radians1|radians2|\r\n|---|---|---|\r\n|1.5707963267949|3.14159265358979|6.28318530717959|","https://docs.microsoft.com/en-us/azure/kusto/query/radiansfunction","radiansfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"rand","Returns a random number.","```\r\nrand()\r\nrand(1000)\r\n```\r\n\r\n## Syntax\r\n\r\n* `rand()` - returns a value of type `real`\r\n  with a uniform distribution in the range [0.0, 1.0).\r\n* `rand(` *N* `)` - returns a value of type `real`\r\n  chosen with a uniform distribution from the set {0.0, 1.0, ..., *N* - 1}.","","https://docs.microsoft.com/en-us/azure/kusto/query/randfunction","")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"range","Generates a dynamic array holding a series of equally-spaced values.","## Syntax\r\n\r\n`range(`*start*`,` *stop*[`,` *step*]`)` \r\n\r\n## Arguments\r\n\r\n* *start*: The value of the first element in the resulting array. \r\n* *stop*: The value of the last element in the resulting array,\r\nor the least value that is greater than the last element in the resulting\r\narray and within an integer multiple of *step* from *start*.\r\n* *step*: The difference between two consecutive elements of\r\nthe array. \r\nThe default value for *step* is `1` for numeric and `1h` for `timespan` or `datetime`",'The following example returns `[1, 4, 7]`:\r\n\r\n```\r\nT | extend r = range(1, 8, 3)\r\n```\r\n\r\nThe following example returns an array holding all days\r\nin the year 2015:\r\n\r\n```\r\nT | extend r = range(datetime(2015-01-01), datetime(2015-12-31), 1d)\r\n```\r\n\r\nThe following example returns `[1,2,3]`:\r\n\r\n```\r\nrange(1, 3)\r\n```\r\n\r\nThe following example returns `["01:00:00","02:00:00","03:00:00","04:00:00","05:00:00"]`:\r\n\r\n```\r\nrange(1h, 5h)\r\n```',"https://docs.microsoft.com/en-us/azure/kusto/query/rangefunction","rangefunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.OperatorToken,"range","Generates a single-column table of values.","Notice that it doesn't have a pipeline input. \r\n\r\n## Syntax\r\n\r\n`range` *columnName* `from` *start* `to` *stop* `step` *step*\r\n\r\n## Arguments\r\n\r\n* *columnName*: The name of the single column in the output table.\r\n* *start*: The smallest value in the output.\r\n* *stop*: The highest value being generated in the output (or a bound\r\non the highest value, if *step* steps over this value).\r\n* *step*: The difference between two consecutive values. \r\n\r\nThe arguments must be numeric, date or timespan values. They can't reference the columns of any table. (If you want to compute the range based on an input table, use the range function, maybe with the mv-expand operator.) \r\n\r\n## Returns\r\n\r\nA table with a single column called *columnName*,\r\nwhose values are *start*, *start* `+` *step*, ... up to and until *stop*.","A table of midnight at the past seven days. The bin (floor) function reduces each time to the start of the day.\r\n\r\n```\r\nrange LastWeek from ago(7d) to now() step 1d\r\n```\r\n\r\n|LastWeek|\r\n|---|\r\n|2015-12-05 09:10:04.627|\r\n|2015-12-06 09:10:04.627|\r\n|...|\r\n|2015-12-12 09:10:04.627|\r\n\r\nA table with a single column called `Steps`\r\nwhose type is `long` and whose values are `1`, `4`, and `7`.\r\n\r\n```\r\nrange Steps from 1 to 8 step 3\r\n```\r\n\r\nThe next example shows how the `range` operator can be used to create\r\na small, ad-hoc, dimension table which is then used to introduce zeros where the source data has no values.\r\n\r\n```\r\nrange TIMESTAMP from ago(4h) to now() step 1m\r\n| join kind=fullouter\r\n  (Traces\r\n      | where TIMESTAMP > ago(4h)\r\n      | summarize Count=count() by bin(TIMESTAMP, 1m)\r\n  ) on TIMESTAMP\r\n| project Count=iff(isnull(Count), 0, Count), TIMESTAMP\r\n| render timechart  \r\n```","https://docs.microsoft.com/en-us/azure/kusto/query/rangeoperator","rangeoperator.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.OperatorToken,"reduce","Groups a set of strings together based on values similarity.",'```\r\nT | reduce by LogMessage with threshold=0.1\r\n```\r\n\r\nFor each such group, it outputs a **pattern** that best describes the group (possibly using the\r\nasterix (`*`) character to represent wildcards), a **count** of the number of values in the group,\r\nand a **representative** of the group (one of the original values in the group).\r\n\r\n## Syntax\r\n\r\n*T* `|` `reduce` [`kind` `=` *ReduceKind*] `by` *Expr* [`with` [`threshold` `=` *Threshold*] [`,` `characters` `=` *Characters*] ]\r\n\r\n## Arguments\r\n\r\n* *Expr*: An expression that evaluates to a `string` value.\r\n* *Threshold*: A `real` literal in the range (0..1). Default is 0.1. For large inputs, threshold should be small. \r\n* *Characters*: A `string` literal containing a list of characters to add to the list of characters\r\n  that don\'t break a term. (For example, if you want `aaa=bbbb` and `aaa:bbb` to each be a whole term,\r\n  rather than break on `=` and `:`, use `":="` as the string literal.)\r\n* *ReduceKind*: Specifies the reduce flavor. The only valid value for the time being is `source`.\r\n\r\n## Returns\r\n\r\nThis operator returns a table with three columns (`Pattern`, `Count`, and `Representative`),\r\nand as many rows as there are groups. `Pattern` is the pattern value for the group, with `*`\r\nbeing used as a wildcard (representing arbitrary insertion strings), `Count` counts how\r\nmany rows in the input to the operator are represented by this pattern, and `Representative`\r\nis one value from the input that falls into this group.\r\n\r\nIf `[kind=source]` is specified, the operator will append the `Pattern` column to the existing table structure.\r\nNote that the syntax an schema of this flavor might be subjected to future changes.\r\n\r\nFor example, the result of `reduce by city` might include: \r\n\r\n|Pattern     |Count |Representative|\r\n|------------|------|--------------|\r\n| San *      | 5182 |San Bernard   |\r\n| Saint *    | 2846 |Saint Lucy    |\r\n| Moscow     | 3726 |Moscow        |\r\n| \\* -on- \\* | 2730 |One -on- One  |\r\n| Paris      | 2716 |Paris         |\r\n\r\nAnother example with customized tokenization:\r\n\r\n```\r\nrange x from 1 to 1000 step 1\r\n| project MyText = strcat("MachineLearningX", tostring(toint(rand(10))))\r\n| reduce by MyText  with threshold=0.001 , characters = "X" \r\n```\r\n\r\n|Pattern         |Count|Representative   |\r\n|----------------|-----|-----------------|\r\n|MachineLearning*|1000 |MachineLearningX4|','The following example shows how one might apply the `reduce` operator to a "sanitized"\r\ninput, in which GUIDs in the column being reduced are replaced prior to reducing\r\n\r\n```\r\n// Start with a few records from the Trace table.\r\nTrace | take 10000\r\n// We will reduce the Text column which includes random GUIDs.\r\n// As random GUIDs interfere with the reduce operation, replace them all\r\n// by the string "GUID".\r\n| extend Text=replace(@"[[:xdigit:]]{8}-[[:xdigit:]]{4}-[[:xdigit:]]{4}-[[:xdigit:]]{4}-[[:xdigit:]]{12}", @"GUID", Text)\r\n// Now perform the reduce. In case there are other "quasi-random" identifiers with embedded \'-\'\r\n// or \'_\' characters in them, treat these as non-term-breakers.\r\n| reduce by Text with characters="-_"\r\n```\r\n\r\n## See also\r\n\r\n[autocluster](./autoclusterplugin.md)\r\n\r\n**Notes**\r\n\r\nThe implementation of `reduce` operator is largely based on the paper [A Data Clustering Algorithm for Mining Patterns From Event Logs](https://ristov.github.io/publications/slct-ipom03-web.pdf), by Risto Vaarandi.',"https://docs.microsoft.com/en-us/azure/kusto/query/reduceoperator","reduceoperator.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.OperatorToken,"render","Instructs the user agent to render the results of the query in a particular way.",'```\r\nrange x from 0.0 to 2*pi() step 0.01 | extend y=sin(x) | render linechart\r\n```\r\n\r\n> [!NOTE]\r\n> * The render operator should be the last operator in the query, and used only with queries that produce a single tabular data stream result.\r\n> * The render operator does not modify data. It injects an annotation ("Visualization") into the result\'s extended properties. The annotation contains the information provided by the operator in the query.\r\n> * The interpretation of the visualization information is done by the user agent. Different agents (such as Kusto.Explorer,Kusto.WebExplorer) might support different visualizations.\r\n\r\n## Syntax\r\n\r\n*T* `|` `render` *Visualization* [`with` `(` *PropertyName* `=` *PropertyValue* [`,` ...] `)`]\r\n\r\nWhere:\r\n\r\n* *Visualization* indicates the kind of visualization to use. The supported values are:\r\n\r\n\r\n|*Visualization*     |Description|\r\n|--------------------|-|\r\n| `anomalychart`     | Similar to timechart, but [highlights anomalies](./samples.md#get-more-out-of-your-data-in-kusto-with-machine-learning) using [series_decompose_anomalies](./series-decompose-anomaliesfunction.md) function. |\r\n| `areachart`        | Area graph. First column is the x-axis and should be a numeric column. Other numeric columns are y-axes. |\r\n| `barchart`         | First column is the x-axis and can be text, datetime or numeric. Other columns are numeric, displayed as horizontal strips.|\r\n| `card`             | First result record is treated as set of scalar values and shows as a card. |\r\n| `columnchart`      | Like `barchart` with vertical strips instead of horizontal strips.|\r\n| `ladderchart`      | Last two columns are the x-axis, other columns are y-axis.|\r\n| `linechart`        | Line graph. First column is x-axis, and should be a numeric column. Other numeric columns are y-axes. |\r\n| `piechart`         | First column is color-axis, second column is numeric. |\r\n| `pivotchart`       | Displays a pivot table and chart. User can interactively select data, columns, rows and various chart types. |\r\n| `scatterchart`     | Points graph. First column is x-axis and should be a numeric column. Other numeric columns are y-axes. |\r\n| `stackedareachart` | Stacked area graph. First column is x-axis, and should be a numeric column. Other numeric columns are y-axes. |\r\n| `table`            | Default - results are shown as a table.|\r\n| `timechart`        | Line graph. First column is x-axis, and should be datetime. Other (numeric) columns are y-axes. There is one string column whose values are used to "group" the numeric columns and create different lines in the chart (further string columns are ignored). |\r\n| `timepivot`        | Interactive navigation over the events time-line (pivoting on time axis)|\r\n\r\n* *PropertyName*/*PropertyValue* indicate additional information to use when rendering.\r\n  All properties are optional. The supported properties are:\r\n\r\n\r\n|*PropertyName*|*PropertyValue*                                                                   |\r\n|--------------|----------------------------------------------------------------------------------|\r\n|`accumulate`  |Whether the value of each measure gets added to all its predecessors. (`true` or `false`)|\r\n|`kind`        |Further elaboration of the visualization kind. See below.                         |\r\n|`legend`      |Whether to display a legend or not (`visible` or `hidden`).                       |\r\n|`series`      |Comma-delimited list of columns whose combined per-record values define the series that record belongs to.|\r\n|`ymin`        |The minimum value to be displayed on Y-axis.                                      |\r\n|`ymax`        |The maximum value to be displayed on Y-axis.                                      |\r\n|`title`       |The title of the visualization (of type `string`).                                |\r\n|`xaxis`       |How to scale the x-axis (`linear` or `log`).                                      |\r\n|`xcolumn`     |Which column in the result is used for the x-axis.                                |\r\n|`xtitle`      |The title of the x-axis (of type `string`).                                       |\r\n|`yaxis`       |How to scale the y-axis (`linear` or `log`).                                      |\r\n|`ycolumns`    |Comma-delimited list of columns that consist of the values provided per value of the x column.|\r\n|`ysplit`      |How to split multiple the visualization. See below.                               |\r\n|`ytitle`      |The title of the y-axis (of type `string`).                                       |\r\n|`anomalycolumns`|Property relevant only for `anomalychart`. Comma-delimited list of columns which will be considered as anomaly series and displayed as points on the chart|\r\n\r\nSome visualizations can be further elaborated by providing the `kind` property.\r\nThese are:\r\n\r\n|*Visualization*|`kind`             |Description                        |\r\n|---------------|-------------------|-----------------------------------|\r\n|`areachart`    |`default`          |Each "area" stands on its own.     |\r\n|               |`unstacked`        |Same as `default`.                 |\r\n|               |`stacked`          |Stack "areas" to the right.        |\r\n|               |`stacked100`       |Stack "areas" to the right and stretch each one to the same width as the others.|\r\n|`barchart`     |`default`          |Each "bar" stands on its own.      |\r\n|               |`unstacked`        |Same as `default`.                 |\r\n|               |`stacked`          |Stack "bars".                      |\r\n|               |`stacked100`       |Stack "bard" and stretch each one to the same width as the others.|\r\n|`columnchart`  |`default`          |Each "column" stands on its own.   |\r\n|               |`unstacked`        |Same as `default`.                 |\r\n|               |`stacked`          |Stack "columns" one atop the other.|\r\n|               |`stacked100`       |Stack "columns" and stretch each one to the same height as the others.|\r\n|`scatterchart` |`map`              |Expected columns are [Longitude, Latitude] or GeoJSON point. Series column is optional.|\r\n|`piechart`     |`map`              |Expected columns are [Longitude, Latitude] or GeoJSON point, color-axis and numeric. Supported in Kusto Explorer desktop.|\r\n\r\nSome visualizations support splitting into multiple y-axis values:\r\n\r\n|`ysplit`  |Description                                                       |\r\n|----------|------------------------------------------------------------------|\r\n|`none`    |A single y-axis is displayed for all series data. (Default)       |\r\n|`axes`    |A single chart is displayed with multiple y-axes (one per series).|\r\n|`panels`  |One chart is rendered for each `ycolumn` value (up to some limit).|\r\n\r\n> [!NOTE]\r\n> The data model of the render operator looks at the tabular data as if it has\r\nthree kinds of columns:\r\n>\r\n> * The x axis column (indicated by the `xcolumn` property).\r\n> * The series columns (any number of columns indicated by the `series` property.)\r\n  For each record, the combined values of these columns defines a single series,\r\n  and the chart has as many series as there are distinct combined values.\r\n> * The y axis columns (any number of columns indicated by the `ycolumns`\r\n  property).\r\n  For each record, the series has as many measurements ("points" in the chart)\r\n  as there are y-axis columns.\r\n\r\n> [!TIP]\r\n> \r\n> * Use `where`, `summarize` and `top` to limit the volume that you display.\r\n> * Sort the data to define the order of the x-axis.\r\n> * User agents are free to "guess" the value of properties that are not specified\r\n  by the query. In particular, having "uninteresting" columns in the schema of\r\n  the result might translate into them guessing wrong. Try projecting-away such\r\n  columns when that happens.','```\r\nrange x from -2 to 2 step 0.1\r\n| extend sin = sin(x), cos = cos(x)\r\n| extend x_sign = iif(x > 0, "x_pos", "x_neg")\r\n| extend sum_sign = iif(sin + cos > 0, "sum_pos", "sum_neg")\r\n| render linechart with  (ycolumns = sin, cos, series = x_sign, sum_sign)\r\n```\r\n\r\n[Rendering examples in the tutorial](./tutorial.md#render-display-a-chart-or-table).\r\n\r\n[Anomaly detection](./samples.md#get-more-out-of-your-data-in-kusto-with-machine-learning)',"https://docs.microsoft.com/en-us/azure/kusto/query/renderoperator","renderoperator.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"repeat","Generates a dynamic array holding a series of equal values.","## Syntax\r\n\r\n`repeat(`*value*`,` *count*`)` \r\n\r\n## Arguments\r\n\r\n* *value*: The value of the element in the resulting array. The type of *value* can be boolean, integer, long, real, datetime, or timespan.   \r\n* *count*: The count of the elements in the resulting array. The *count* must be an integer number.\r\nIf *count* is equal to zero, a empty array is returned.\r\nIf *count* is less than zero, a null value is returned.","The following example returns `[1, 1, 1]`:\r\n\r\n```\r\nT | extend r = repeat(1, 3)\r\n```","https://docs.microsoft.com/en-us/azure/kusto/query/repeatfunction","repeatfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"replace","Replace all regex matches with another string.","## Syntax\r\n\r\n`replace(`*regex*`,` *rewrite*`,` *text*`)`\r\n\r\n## Arguments\r\n\r\n* *regex*: The [regular expression](https://github.com/google/re2/wiki/Syntax) to search *text*. It can contain capture groups in '('parentheses')'. \r\n* *rewrite*: The replacement regex for any match made by *matchingRegex*. Use `\\0` to refer to the whole match, `\\1` for the first capture group, `\\2` and so on for subsequent capture groups.\r\n* *text*: A string.\r\n\r\n## Returns\r\n\r\n*text* after replacing all matches of *regex* with evaluations of *rewrite*. Matches do not overlap.","This statement:\r\n\r\n```\r\nrange x from 1 to 5 step 1\r\n| extend str=strcat('Number is ', tostring(x))\r\n| extend replaced=replace(@'is (\\d+)', @'was: \\1', str)\r\n```\r\n\r\nHas the following results:\r\n\r\n| x    | str | replaced|\r\n|---|---|---|\r\n| 1    | Number is 1.000000  | Number was: 1.000000|\r\n| 2    | Number is 2.000000  | Number was: 2.000000|\r\n| 3    | Number is 3.000000  | Number was: 3.000000|\r\n| 4    | Number is 4.000000  | Number was: 4.000000|\r\n| 5    | Number is 5.000000  | Number was: 5.000000|","https://docs.microsoft.com/en-us/azure/kusto/query/replacefunction","replacefunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"reverse","Function reverses the order of the input string.\r\nIf the input value isn't of type `string`, then the function forcibly casts the value to type `string`.","## Syntax\r\n\r\n`reverse(`*source*`)`\r\n\r\n## Arguments\r\n\r\n* *source*: input value.  \r\n\r\n## Returns\r\n\r\nThe reverse order of a string value.","```\r\nprint str = \"ABCDEFGHIJKLMNOPQRSTUVWXYZ\"\r\n| extend rstr = reverse(str)\r\n```\r\n\r\n|str|rstr|\r\n|---|---|\r\n|ABCDEFGHIJKLMNOPQRSTUVWXYZ|ZYXWVUTSRQPONMLKJIHGFEDCBA|\r\n\r\n```\r\nprint ['int'] = 12345, ['double'] = 123.45, \r\n['datetime'] = datetime(2017-10-15 12:00), ['timespan'] = 3h\r\n| project rint = reverse(['int']), rdouble = reverse(['double']), \r\nrdatetime = reverse(['datetime']), rtimespan = reverse(['timespan'])\r\n```\r\n\r\n|rint|rdouble|rdatetime|rtimespan|\r\n|---|---|---|---|\r\n|54321|54.321|Z0000000.00:00:21T51-01-7102|00:00:30|","https://docs.microsoft.com/en-us/azure/kusto/query/reversefunction","reversefunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"round","Returns the rounded source to the specified precision.","## Syntax\r\n\r\n`round(`*source* [`,` *Precision*]`)`\r\n\r\n## Arguments\r\n\r\n* *source*: The source scalar the round is calculated on.\r\n* *Precision*: Number of digits the source will be rounded to.(default value is 0)\r\n\r\n## Returns\r\n\r\nThe rounded source to the specified precision.\r\n\r\nRound is different than [`bin()`](binfunction.md)/[`floor()`](floorfunction.md) in\r\nthat the first rounds a number to a specific number of digits while the last rounds value to an integer multiple \r\nof a given bin size (round(2.15, 1) returns 2.2 while bin(2.15, 1) returns 2).","```\r\nround(2.15, 1)                   // 2.2\r\nround(2.15) (which is the same as round(2.15, 0))                   // 2\r\nround(-50.55, -2)                   // -100\r\nround(21.5, -1)                   // 20\r\n```","https://docs.microsoft.com/en-us/azure/kusto/query/roundfunction","roundfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"row_cumsum","Calculates the cumulative sum of a column in a [serialized row set](./windowsfunctions.md#serialized-row-set).","## Syntax\r\n\r\n`row_cumsum` `(` *Term* [`,` *Restart*] `)`\r\n\r\n* *Term* is an expression indicating the value to be summed.\r\n  The expression must be a scalar of one of the following types:\r\n  `decimal`, `int`, `long`, or `real`. Null *Term* values do not affect the\r\n  sum.\r\n* *Restart* is an optional argument of type `bool` that indicates when the\r\n  accumulation operation should be restarted (set back to 0). It can be\r\n  used to indicate partitions of the data; see the second example below.\r\n\r\n## Returns\r\n\r\nThe function returns the cumulative sum of its argument.",'The following example shows how to calculate the cumulative sum of the first\r\nfew even integers.\r\n\r\n```\r\ndatatable (a:long) [\r\n    1, 2, 3, 4, 5, 6, 7, 8, 9, 10\r\n]\r\n| where a%2==0\r\n| serialize cs=row_cumsum(a)\r\n```\r\n\r\na    | cs\r\n-----|-----\r\n2    | 2\r\n4    | 6\r\n6    | 12\r\n8    | 20\r\n10   | 30\r\n\r\nThis example shows how to calculate the cumulative sum (here, of `salary`)\r\nwhen the data is partitioned (here, by `name`):\r\n\r\n```\r\ndatatable (name:string, month:int, salary:long)\r\n[\r\n    "Alice", 1, 1000,\r\n    "Bob",   1, 1000,\r\n    "Alice", 2, 2000,\r\n    "Bob",   2, 1950,\r\n    "Alice", 3, 1400,\r\n    "Bob",   3, 1450,\r\n]\r\n| order by name asc, month asc\r\n| extend total=row_cumsum(salary, name != prev(name))\r\n```\r\n\r\nname   | month  | salary  | total\r\n-------|--------|---------|------\r\nAlice  | 1      | 1000    | 1000\r\nAlice  | 2      | 2000    | 3000\r\nAlice  | 3      | 1400    | 4400\r\nBob    | 1      | 1000    | 1000\r\nBob    | 2      | 1950    | 2950\r\nBob    | 3      | 1450    | 4400',"https://docs.microsoft.com/en-us/azure/kusto/query/rowcumsumfunction","rowcumsumfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"row_number","Returns the current row's index in a [serialized row set](./windowsfunctions.md#serialized-row-set).\r\nThe row index starts by default at `1` for the first row, and is incremented by `1` for each additional row.\r\nOptionally, the row index can start at a different value than `1`.\r\nAdditionally, the row index may be reset according to some provided predicate.","## Syntax\r\n\r\n`row_number` `(` [*StartingIndex* [`,` *Restart*]] `)`\r\n\r\n* *StartingIndex* is a constant expression of type `long` indicating the value\r\n  of the row index to start at (or to restart to). The default value is `1`.\r\n* *Restart* is an optional argument of type `bool` that indicates when the\r\n  numbering is to be restarted to the *StartingIndex* value. If not provided,\r\n  the default value of `false` is used.\r\n\r\n## Returns\r\n\r\nThe function returns the row index of the current row as a value of type `long`.",'The following example returns a table with two columns, the first column (`a`)\r\nwith numbers from `10` down to `1`, and the second column (`rn`) with numbers\r\nfrom `1` up to `10`:\r\n\r\n```\r\nrange a from 1 to 10 step 1\r\n| sort by a desc\r\n| extend rn=row_number()\r\n```\r\n\r\nThe following example is similar to the above, only the second column (`rn`)\r\nstarts at `7`:\r\n\r\n```\r\nrange a from 1 to 10 step 1\r\n| sort by a desc\r\n| extend rn=row_number(7)\r\n```\r\n\r\nThe last example shows how one can partition the data and number the rows\r\nper each partition. Here, we partition the data by `Airport`:\r\n\r\n```\r\ndatatable (Airport:string, Airline:string, Departures:long)\r\n[\r\n  "TLV", "LH", 1,\r\n  "TLV", "LY", 100,\r\n  "SEA", "LH", 1,\r\n  "SEA", "BA", 2,\r\n  "SEA", "LY", 0\r\n]\r\n| sort by Airport asc, Departures desc\r\n| extend Rank=row_number(1, prev(Airport) != Airport)\r\n```\r\n\r\nRunning this query produces the following result:\r\n\r\nAirport  | Airline  | Departures  | Rank\r\n---------|----------|-------------|------\r\nSEA      | BA       | 2           | 1\r\nSEA      | LH       | 1           | 2\r\nSEA      | LY       | 0           | 3\r\nTLV      | LY       | 100         | 1\r\nTLV      | LH       | 1           | 2',"https://docs.microsoft.com/en-us/azure/kusto/query/rownumberfunction","rownumberfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"row_window_session","`row_window_session()` calculates session start values of a column in a [serialized row set](./windowsfunctions.md#serialized-row-set).","## Syntax\r\n\r\n`row_window_session` `(` *`Expr`* `,` *`MaxDistanceFromFirst`* `,` *`MaxDistanceBetweenNeighbors`* [`,` *`Restart`*] `)`\r\n\r\n* *`Expr`* is an expression whose values are grouped together in sessions.\r\n  Null values produce null values, and the next value starts a new session.\r\n  *`Expr`* must be a scalar expression of type `datetime`.\r\n* *`MaxDistanceFromFirst`* establishes one criterion for starting a new session:\r\n  The maximum distance between the current value of *`Expr`* and the value of\r\n  *`Expr`* at the beginning of the session.\r\n  It is a scalar constant of type `timespan`.\r\n* *`MaxDistanceBetweenNeighbors`* establishes a second criterion for starting a new session:\r\n  The maximum distance from one value of *`Expr`* to the next.\r\n  It is a scalar constant of type `timespan`.\r\n* *Restart* is an optional scalar expression of type `boolean`. If specified,\r\n  every value that evaluates to `true` will immediately restart the session.\r\n\r\n## Returns\r\n\r\nThe function returns the values at the beginning of each session.\r\n\r\n**Notes**\r\n\r\nThe function has the following conceptual calculation model:\r\n\r\n1. Go over the input sequence of values *`Expr`* in order.\r\n1. For every value, determine if it establishes a new session.\r\n1. If it establishes a new session, emit the value of *`Expr`*. Otherwise, emit the previous value of *`Expr`*.\r\n\r\nThe condition that determines if the value represents a new session is\r\na logical OR one of the following conditions:\r\n\r\n* If there was no previous session value, or the previous session value was null.\r\n* If the value of *`Expr`* equals or exceeds the previous session value plus\r\n  *`MaxDistanceFromFirst`*.\r\n* If the value of *`Expr`* equals or exceeds the previous value of *`Expr`*\r\n  plus *`MaxDistanceBetweenNeighbors`*.","The following example shows how to calculate the session start values for a table\r\nwith two columns: an `ID` column that identifies a sequence, and a `Timestamp`\r\ncolumn that gives the time at which each record occurred. In this example,\r\na session can't exceed 1 hour, and it continues as long as records are less than\r\n5 minutes apart.\r\n\r\n```\r\ndatatable (ID:string, Timestamp:datetime) [\r\n    // ...\r\n]\r\n| sort by ID asc, Timestamp asc\r\n| extend SessionStarted = row_window_session(Timestamp, 1h, 5m, ID != prev(ID))\r\n```","https://docs.microsoft.com/en-us/azure/kusto/query/row-window-session-function","row-window-session-function.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.OperatorToken,"sample","Returns up to the specified number of random rows from the input table.","```\r\nT | sample 5\r\n```\r\n\r\n> [!NOTE]\r\n> * `sample` is geared for speed rather than even distribution of values. Specifically, it means that it will not produce 'fair' results if used after operators that union 2 data sets of different sizes (such as a `union` or `join` operators). It's recommended to use `sample` right after the table reference and filters.\r\n> * `sample` is a non-deterministic operator, and will return different result set each time it is evaluated during the query. For example, the following query yields two different rows (even if one would expect to return the same row twice).\r\n\r\n## Syntax\r\n\r\n*T* `| sample` *NumberOfRows*\r\n\r\n## Arguments\r\n\r\n* *NumberOfRows*: The number of rows of *T* to return. You can specify any numeric expression.","```\r\nlet _data = range x from 1 to 100 step 1;\r\nlet _sample = _data | sample 1;\r\nunion (_sample), (_sample)\r\n```\r\n\r\n| x   |\r\n| --- |\r\n| 83  |\r\n| 3   |\r\n\r\nTo ensure that in example above `_sample` is calculated once, one can use [materialize()](./materializefunction.md) function:\r\n\r\n```\r\nlet _data = range x from 1 to 100 step 1;\r\nlet _sample = materialize(_data | sample 1);\r\nunion (_sample), (_sample)\r\n```\r\n\r\n| x   |\r\n| --- |\r\n| 34  |\r\n| 34  |\r\n\r\nTo sample a certain percentage of your data (rather than a specified number of rows), you can use\r\n\r\n```\r\nStormEvents | where rand() < 0.1\r\n```\r\n\r\nTo sample keys rather than rows (for example - sample 10 Ids and get all rows for these Ids) you can use [`sample-distinct`](./sampledistinctoperator.md) in combination with the `in` operator.\r\n\r\n```\r\nlet sampleEpisodes = StormEvents | sample-distinct 10 of EpisodeId;\r\nStormEvents\r\n| where EpisodeId in (sampleEpisodes)\r\n```","https://docs.microsoft.com/en-us/azure/kusto/query/sampleoperator","sampleoperator.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.OperatorToken,"sample-distinct","Returns a single column that contains up to the specified number of distinct values of the requested column.","the default (and currently only) flavor of the operator tries to return an answer as quickly as possible (rather than trying to make a fair sample)\r\n\r\n```\r\nT | sample-distinct 5 of DeviceId\r\n```\r\n\r\n## Syntax\r\n\r\n*T* `| sample-distinct` *NumberOfValues* `of` *ColumnName*\r\n\r\n## Arguments\r\n\r\n* *NumberOfValues*: The number distinct values of *T* to return. You can specify any numeric expression.\r\n\r\n**Tips**\r\n\r\nCan be handy to sample a population by putting `sample-distinct` in a let statement and later filter using the `in` operator (see example) \r\n\r\nIf you want the top values rather than just a sample, you can use the [top-hitters](tophittersoperator.md) operator \r\n\r\nif you want to sample data rows (rather than values of a specific column), refer to the [sample operator](sampleoperator.md)","Get 10 distinct values from a population\r\n\r\n```\r\nStormEvents | sample-distinct 10 of EpisodeId\r\n\r\n```\r\n\r\nSample a population and do further computation knowing the summarize won't exceed query limits. \r\n\r\n```\r\nlet sampleEpisodes = StormEvents | sample-distinct 10 of EpisodeId;\r\nStormEvents \r\n| where EpisodeId in (sampleEpisodes) \r\n| summarize totalInjuries=sum(InjuriesDirect) by EpisodeId\r\n```","https://docs.microsoft.com/en-us/azure/kusto/query/sampledistinctoperator","sampledistinctoperator.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.OperatorToken,"search","The search operator provides a multi-table/multi-column search experience.",'## Syntax\r\n\r\n* [*TabularSource* `|`] `search` [`kind=`*CaseSensitivity*] [`in` `(`*TableSources*`)`] *SearchPredicate*\r\n\r\n## Arguments\r\n\r\n* *TabularSource*: An optional tabular expression that acts as a data source to be searched over,\r\n  such as a table name, a [union operator](unionoperator.md), the results\r\n  of a tabular query, etc. Cannot appear together with the optional phrase that includes *TableSources*.\r\n* *CaseSensitivity*: An optional flag that controls the behavior of all `string` scalar operators\r\n  with respect to case sensitivity. Valid values are the two synonyms `default` and `case_insensitive`\r\n  (which is the default for operators such as `has`, namely being case-insensitive) and `case_sensitive`\r\n  (which forces all such operators into case-sensitive matching mode).\r\n* *TableSources*: An optional comma-separated list of "wildcarded" table names to take part in the search.\r\n  The list has the same syntax as the list of the [union operator](unionoperator.md).\r\n  Cannot appear together with the optional *TabularSource*.\r\n* *SearchPredicate*: A mandatory predicate that defines what to search for (in other words,\r\n  a Boolean expression that is evaluated for every record in the input and that, if it returns\r\n  `true`, the record is outputted.)\r\n  The syntax for *SearchPredicate* extends and modifies the normal Kusto syntax for Boolean expressions:\r\n  **String matching extensions**: String literals that appear as terms in the *SearchPredicate* indicate a term\r\n    match between all columns and the literal using `has`, `hasprefix`, `hassuffix`, and the inverted (`!`)\r\n    or case-sensitive (`sc`) versions of these operators. The decision whether to apply `has`, `hasprefix`,\r\n    or `hassuffix` depends on whether the literal starts or ends (or both) by an asterisk (`*`). Asterisks\r\n    inside the literal are not allowed.\r\n    |Literal   |Operator   |\r\n    |----------|-----------|\r\n    |`billg`   |`has`      |\r\n    |`*billg`  |`hassuffix`|\r\n    |`billg*`  |`hasprefix`|\r\n    |`*billg*` |`contains` |\r\n    |`bi*lg`   |`matches regex`|\r\n  **Column restriction**: By default, string matching extensions attempt to match against all columns\r\n    of the data set. It is possible to restrict this matching to a particular column by using\r\n    the following syntax: *ColumnName*`:`*StringLiteral*.\r\n  **String equality**: Exact matches of a column against a string value (instead of a term-match)\r\n    can be done using the syntax *ColumnName*`==`*StringLiteral*.\r\n  **Other Boolean expressions**: All regular Kusto Boolean expressions are supported by the syntax.\r\n    For example, `"error" and x==123` means: search for records that have the term `error` in any\r\n    of their columns, and have the value `123` in the `x` column."\r\n  **Regex match**: Regular expression matching is indicated using *Column* `matches regex` *StringLiteral*\r\n    syntax, where *StringLiteral* is the regex pattern.\r\n\r\nNote that if both *TabularSource* and *TableSources* are omitted, the search is carried over all unrestricted tables\r\nand views of the database in scope.\r\n\r\n## Summary of string matching extensions\r\n\r\n|# |Syntax                                 |Meaning (equivalent `where`)           |Comments|\r\n  |--|---------------------------------------|---------------------------------------|--------|\r\n  | 1|`search "err"`                         |`where * has "err"`                    ||\r\n  | 2|`search in (T1,T2,A*) and "err"`       |<code>union T1,T2,A* &#124; where * has "err"<code>   ||\r\n  | 3|`search col:"err"`                     |`where col has "err"`                  ||\r\n  | 4|`search col=="err"`                    |`where col=="err"`                     ||\r\n  | 5|`search "err*"`                        |`where * hasprefix "err"`              ||\r\n  | 6|`search "*err"`                        |`where * hassuffix "err"`              ||\r\n  | 7|`search "*err*"`                       |`where * contains "err"`               ||\r\n  | 8|`search "Lab*PC"`                      |`where * matches regex @"\\bLab.*PC\\b"`||\r\n  | 9|`search *`                             |`where 0==0`                           ||\r\n  |10|`search col matches regex "..."`       |`where col matches regex "..."`        ||\r\n  |11|`search kind=case_sensitive`           |                                       |All string comparisons are case-sensitive|\r\n  |12|`search "abc" and ("def" or "hij")`    |`where * has "abc" and (* has "def" or * has hij")`||\r\n  |13|`search "err" or (A>a and A<b)`        |`where * has "err" or (A>a and A<b)`   ||\r\n\r\n## Remarks\r\n\r\n**Unlike** the [find operator](findoperator.md), the `search` operator does not support the following:\r\n\r\n1. `withsource=`: The output will always include a column called `$table` of type `string` whose value\r\n   is the table name from which each record was retrieved (or some system-generated name if the source\r\n   is not a table but a composite expression).\r\n2. `project=`, `project-smart`: The output schema is equivalent to `project-smart` output schema.','```\r\n// 1. Simple term search over all unrestricted tables and views of the database in scope\r\nsearch "billg"\r\n\r\n// 2. Like (1), but looking only for records that match both terms\r\nsearch "billg" and ("steveb" or "satyan")\r\n\r\n// 3. Like (1), but looking only in the TraceEvent table\r\nsearch in (TraceEvent) and "billg"\r\n\r\n// 4. Like (2), but performing a case-sensitive match of all terms\r\nsearch "BillB" and ("SteveB" or "SatyaN")\r\n\r\n// 5. Like (1), but restricting the match to some columns\r\nsearch CEO:"billg" or CSA:"billg"\r\n\r\n// 6. Like (1), but only for some specific time limit\r\nsearch "billg" and Timestamp >= datetime(1981-01-01)\r\n\r\n// 7. Searches over all the higher-ups\r\nsearch in (C*, TF) "billg" or "davec" or "steveb"\r\n\r\n// 8. A different way to say (7). Prefer to use (7) when possible\r\nunion C*, TF | search "billg" or "davec" or "steveb"\r\n```\r\n\r\n## Performance Tips\r\n\r\n|# |Tip                                                                                  |Prefer                                        |Over                                                                    |\r\n  |--|-------------------------------------------------------------------------------------|----------------------------------------------|------------------------------------------------------------------------|\r\n  | 1| Prefer to use a single `search` operator over several consecutive `search` operators|`search "billg" and ("steveb" or "satyan")`   |<code>search "billg" &#124; search "steveb" or "satyan"<code>           ||\r\n  | 2| Prefer to filter inside the `search` operator                                       |`search "billg" and "steveb"`                 |<code>search * &#124; where * has "billg" and * has "steveb"<code>      ||',"https://docs.microsoft.com/en-us/azure/kusto/query/searchoperator","searchoperator.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.OperatorToken,"serialize","Marks that the order of the input row set is safe to use for window functions.","The operator has a declarative meaning. It marks the input row set as serialized (ordered), so that [window functions](./windowsfunctions.md) can be applied to it.\r\n\r\n```\r\nT | serialize rn=row_number()\r\n```\r\n\r\n## Syntax\r\n\r\n`serialize` [*Name1* `=` *Expr1* [`,` *Name2* `=` *Expr2*]...]\r\n\r\n* The *Name*/*Expr* pairs are similar to those pairs in the [extend operator](./extendoperator.md).",'```\r\nTraces\r\n| where ActivityId == "479671d99b7b"\r\n| serialize\r\n\r\nTraces\r\n| where ActivityId == "479671d99b7b"\r\n| serialize rn = row_number()\r\n```\r\n\r\nThe output row set of the following operators is marked as serialized.\r\n\r\n[range](./rangeoperator.md), [sort](./sortoperator.md), [order](./orderoperator.md), [top](./topoperator.md), [top-hitters](./tophittersoperator.md), [getschema](./getschemaoperator.md).\r\n\r\nThe output row set of the following operators is marked as non-serialized.\r\n\r\n[sample](./sampleoperator.md), [sample-distinct](./sampledistinctoperator.md), [distinct](./distinctoperator.md), [join](./joinoperator.md), \r\n[top-nested](./topnestedoperator.md), [count](./countoperator.md), [summarize](./summarizeoperator.md), [facet](./facetoperator.md), [mv-expand](./mvexpandoperator.md), \r\n[evaluate](./evaluateoperator.md), [reduce by](./reduceoperator.md), [make-series](./make-seriesoperator.md)\r\n\r\nAll other operators preserve the serialization property. \r\nIf the input row set is serialized, then the output row set is also serialized.',"https://docs.microsoft.com/en-us/azure/kusto/query/serializeoperator","serializeoperator.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"series_add","Calculates the element-wise addition of two numeric series inputs.","## Syntax\r\n\r\n`series_add(`*series1*`,` *series2*`)`\r\n\r\n## Arguments\r\n\r\n* *series1, series2*: Input numeric arrays to be element-wise added into a dynamic array result. All arguments must be dynamic arrays. \r\n\r\n## Returns\r\n\r\nDynamic array of calculated element-wise add operation between the two inputs. Any non-numeric element or non-existing element (arrays of different sizes) yields a `null` element value.","```\r\nrange x from 1 to 3 step 1\r\n| extend y = x * 2\r\n| extend z = y * 2\r\n| project s1 = pack_array(x,y,z), s2 = pack_array(z, y, x)\r\n| extend s1_add_s2 = series_add(s1, s2)\r\n```\r\n\r\n|s1|s2|s1_add_s2|\r\n|---|---|---|\r\n|[1,2,4]|[4,2,1]|[5,4,5]|\r\n|[2,4,8]|[8,4,2]|[10,8,10]|\r\n|[3,6,12]|[12,6,3]|[15,12,15]|","https://docs.microsoft.com/en-us/azure/kusto/query/series-addfunction","series-addfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"series_decompose","Applies a decomposition transformation on a series.",'Takes an expression containing a series (dynamic numerical array) as input and decomposes it to seasonal, trend, and residual components.\r\n\r\n## Syntax\r\n\r\n`series_decompose(`*Series* `[,` *Seasonality*`,` *Trend*`,` *Test_points*`,` *Seasonality_threshold*`])`\r\n\r\n## Arguments\r\n\r\n* *Series*: Dynamic array cell, which is an array of numeric values, typically the resulting output of [make-series](make-seriesoperator.md) or [make_list](makelist-aggfunction.md) operators\r\n* *Seasonality*: An integer controlling the seasonal analysis, containing either\r\n    * -1: autodetect seasonality using [series_periods_detect](series-periods-detectfunction.md) (default).\r\n    * period: positive integer specifying the expected period in number of bins. For example, if the series is in 1-h bins, a weekly period is 168 bins.\r\n    * 0: no seasonality (skip extracting this component).    \r\n* *Trend*: A string controlling the trend analysis, containing one of the following values:\r\n    * "avg": define trend component as average(x) (default)\r\n    * "linefit": extract trend component using linear regression.\r\n    * "none": no trend, skip extracting this component.    \r\n* *Test_points*: 0 (default) or positive integer, specifying the number of points at the end of the series to exclude from the learning (regression) process. This parameter should be set for forecasting purposes.\r\n* *Seasonality_threshold*: The threshold for seasonality score when *Seasonality* is set to autodetect, the default score threshold is `0.6`. For more information, see [series_periods_detect](series-periods-detectfunction.md).\r\n\r\n**Return**\r\n\r\nThe function returns the following respective series:\r\n\r\n* `baseline`: the predicted value of the series (sum of seasonal and trend components, see below).\r\n* `seasonal`: the series of the seasonal component:\r\n    * if the period isn\'t detected or is explicitly set to 0: constant 0.\r\n    * if detected or set to positive integer: median of the series points in the same phase\r\n* `trend`: the series of the trend component.\r\n* `residual`: the series of the residual component (that is, x - baseline).\r\n  \r\n\r\n**Notes**\r\n\r\n* Component execution order:\r\n    1. Extract the seasonal series\r\n    2. Subtract it from x, generating the deseasonal series\r\n    3. Extract the trend component from the deseasonal series\r\n    4. Create the baseline = seasonal + trend\r\n    5. Create the residual = x - baseline\r\n    \r\n* Either seasonality and, or trend should be enabled. Otherwise, the function is redundant, and just returns baseline = 0 and residual = x.\r\n\r\n**More about series decomposition**\r\n\r\nThis method is usually applied to time series of metrics expected to manifest periodic and/or trend behavior. You can use the method to  forecast future metric values and/or detect anomalous values. The implicit assumption of this regression process is that apart from seasonal and trend behavior, the time series is stochastic and randomly distributed. Forecast future metric values from the seasonal and trend components while ignoring the residual part. Detect anomalous values based on outlier detection only on the residual part only. Further details can be found in the [Time Series Decomposition chapter](https://otexts.com/fpp2/decomposition.html).',"**Weekly seasonality**\r\n\r\nIn the following example, we generate a series with weekly seasonality and without trend, we then add some outliers to it. `series_decompose` finds and automatically detects the seasonality, and generates a baseline that is almost identical to the seasonal component. The outliers we added can be clearly seen in the residuals component.\r\n\r\n```\r\nlet ts=range t from 1 to 24*7*5 step 1 \r\n| extend Timestamp = datetime(2018-03-01 05:00) + 1h * t \r\n| extend y = 2*rand() + iff((t/24)%7>=5, 10.0, 15.0) - (((t%24)/10)*((t%24)/10)) // generate a series with weekly seasonality\r\n| extend y=iff(t==150 or t==200 or t==780, y-8.0, y) // add some dip outliers\r\n| extend y=iff(t==300 or t==400 or t==600, y+8.0, y) // add some spike outliers\r\n| summarize Timestamp=make_list(Timestamp, 10000),y=make_list(y, 10000);\r\nts \r\n| extend series_decompose(y)\r\n| render timechart  \r\n```\r\n\r\n![Series decompose 1](images/samples/series-decompose1.png)\r\n**Weekly seasonality with trend**\r\n\r\nIn this example, we add a trend to the series from the previous example. First, we run `series_decompose` with the default parameters. The trend `avg` default value only takes the average and doesn't compute the trend. The generated baseline doesn't contain the trend. When observing the trend in the residuals, it becomes apparent that this example is less accurate than the previous example.\r\n\r\n```\r\nlet ts=range t from 1 to 24*7*5 step 1 \r\n| extend Timestamp = datetime(2018-03-01 05:00) + 1h * t \r\n| extend y = 2*rand() + iff((t/24)%7>=5, 5.0, 15.0) - (((t%24)/10)*((t%24)/10)) + t/72.0 // generate a series with weekly seasonality and ongoing trend\r\n| extend y=iff(t==150 or t==200 or t==780, y-8.0, y) // add some dip outliers\r\n| extend y=iff(t==300 or t==400 or t==600, y+8.0, y) // add some spike outliers\r\n| summarize Timestamp=make_list(Timestamp, 10000),y=make_list(y, 10000);\r\nts \r\n| extend series_decompose(y)\r\n| render timechart  \r\n```\r\n\r\n![Series decompose 2](images/samples/series-decompose2.png)\r\nNext, we rerun the same example. Since we're expecting a trend in the series, we specify `linefit` in the trend parameter. We can see that the positive trend is detected and the baseline is much closer to the input series. The residuals are close to zero, and only the outliers stand out. We can see all the components on the series in the chart.\r\n\r\n```\r\nlet ts=range t from 1 to 24*7*5 step 1 \r\n| extend Timestamp = datetime(2018-03-01 05:00) + 1h * t \r\n| extend y = 2*rand() + iff((t/24)%7>=5, 5.0, 15.0) - (((t%24)/10)*((t%24)/10)) + t/72.0 // generate a series with weekly seasonality and ongoing trend\r\n| extend y=iff(t==150 or t==200 or t==780, y-8.0, y) // add some dip outliers\r\n| extend y=iff(t==300 or t==400 or t==600, y+8.0, y) // add some spike outliers\r\n| summarize Timestamp=make_list(Timestamp, 10000),y=make_list(y, 10000);\r\nts \r\n| extend series_decompose(y, -1, 'linefit')\r\n| render timechart  \r\n```\r\n\r\n![Series decompose 3](images/samples/series-decompose3.png)","https://docs.microsoft.com/en-us/azure/kusto/query/series-decomposefunction","series-decomposefunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"series_decompose_anomalies","Anomaly Detection is based on series decomposition.\r\nFor more information, see [series_decompose()](series-decomposefunction.md).",'The function takes an expression containing a series (dynamic numerical array) as input, and extracts anomalous points with scores.\r\n\r\n## Syntax\r\n\r\n`series_decompose_anomalies (`*Series* `[, ` *Threshold*`,` *Seasonality*`,` *Trend*`, ` *Test_points*`, ` *AD_method*`,` *Seasonality_threshold* `])`\r\n\r\n## Arguments\r\n\r\n* *Series*: Dynamic array cell that is an array of numeric values, typically the resulting output of [make-series](make-seriesoperator.md) or [make_list](makelist-aggfunction.md) operators\r\n* *Threshold*: Anomaly threshold, default 1.5 (k value) for detecting mild or stronger anomalies\r\n* *Seasonality*: An integer controlling the seasonal analysis, containing either\r\n    * -1: Autodetect seasonality (using [series_periods_detect](series-periods-detectfunction.md)) [default]\r\n    * 0: No seasonality (that is, skip extracting this component)\r\n    * period: Positive integer, specifying the expected period in number of bins unit. For example, if the series is in one hour bins, a weekly period is 168 bins\r\n* *Trend*: A string controlling the trend analysis, containing either\r\n    * "avg": Define trend component as average of the series [default]\r\n    * "none": No trend, skip extracting this component\r\n    * "linefit": Extract trend component using linear regression\r\n* *Test_points*: 0 [default] or a positive integer, that specifies the number of points at the end of the series to exclude from the learning (regression) process. This parameter should be set for forecasting purposes\r\n* *AD_method*: A string controlling the anomaly detection method on the residual time series, containing one of:\r\n    * “ctukey”: [Tukey’s fence test](https://en.wikipedia.org/wiki/Outlier#Tukey\'s_fences) with custom 10th-90th percentile range [default]\r\n    * “tukey”: [Tukey’s fence test](https://en.wikipedia.org/wiki/Outlier#Tukey\'s_fences) with standard 25th-75th percentile range\r\nFor more information on residual time series, see [series_outliers](series-outliersfunction.md)\r\n* *Seasonality_threshold*: The threshold for seasonality score when *Seasonality* is set to autodetect. The default score threshold is `0.6`. For more information, see [series_periods_detect](series-periods-detectfunction.md)\r\n\r\n## Returns\r\n\r\nThe function returns the following respective series:\r\n\r\n* `ad_flag`: A ternary series containing (+1, -1, 0) marking up/down/no anomaly respectively\r\n* `ad_score`: Anomaly score\r\n* `baseline`: The predicted value of the series, according to the decomposition\r\n\r\n## The algorithm\r\n\r\nThis function follows these steps:\r\n\r\n1. Calls [series_decompose()](series-decomposefunction.md) with the respective parameters, to create the baseline and residuals series.\r\n1. Calculates ad_score series by applying [series_outliers()](series-outliersfunction.md) with the chosen anomaly detection method on the residuals series.\r\n1. Calculates the ad_flag series by applying the threshold on the ad_score to mark up/down/no anomaly respectively.',"### Detect anomalies in weekly seasonality\r\n\r\nIn the following example, generate a series with weekly seasonality, and then add some outliers to it. `series_decompose_anomalies` autodetects the seasonality and generates a baseline that captures the repetitive pattern. The outliers you added can be clearly spotted in the ad_score component.\r\n\r\n```\r\nlet ts=range t from 1 to 24*7*5 step 1 \r\n| extend Timestamp = datetime(2018-03-01 05:00) + 1h * t \r\n| extend y = 2*rand() + iff((t/24)%7>=5, 10.0, 15.0) - (((t%24)/10)*((t%24)/10)) // generate a series with weekly seasonality\r\n| extend y=iff(t==150 or t==200 or t==780, y-8.0, y) // add some dip outliers\r\n| extend y=iff(t==300 or t==400 or t==600, y+8.0, y) // add some spike outliers\r\n| summarize Timestamp=make_list(Timestamp, 10000),y=make_list(y, 10000);\r\nts \r\n| extend series_decompose_anomalies(y)\r\n| render timechart  \r\n```\r\n\r\n![Weekly seasonality showing baseline and outliers](images/series-decompose-anomaliesfunction/weekly-seasonality-outliers.png)\r\n\r\n### Detect anomalies in weekly seasonality with trend\r\n\r\nIn this example, add a trend to the series from the previous example. First, run `series_decompose_anomalies` with the default parameters in which the trend `avg` default value only takes the average and doesn't compute the trend. The generated baseline doesn't contain the trend and is less exact, compared to the previous example. Consequently, some of the outliers you inserted in the data aren't detected because of the higher variance.\r\n\r\n```\r\nlet ts=range t from 1 to 24*7*5 step 1 \r\n| extend Timestamp = datetime(2018-03-01 05:00) + 1h * t \r\n| extend y = 2*rand() + iff((t/24)%7>=5, 5.0, 15.0) - (((t%24)/10)*((t%24)/10)) + t/72.0 // generate a series with weekly seasonality and ongoing trend\r\n| extend y=iff(t==150 or t==200 or t==780, y-8.0, y) // add some dip outliers\r\n| extend y=iff(t==300 or t==400 or t==600, y+8.0, y) // add some spike outliers\r\n| summarize Timestamp=make_list(Timestamp, 10000),y=make_list(y, 10000);\r\nts \r\n| extend series_decompose_anomalies(y)\r\n| extend series_decompose_anomalies_y_ad_flag = \r\nseries_multiply(10, series_decompose_anomalies_y_ad_flag) // multiply by 10 for visualization purposes\r\n| render timechart\r\n```\r\n\r\n![Weekly seasonality outliers with trend](images/series-decompose-anomaliesfunction/weekly-seasonality-outliers-with-trend.png)\r\nNext, run the same example, but since you're expecting a trend in the series, specify `linefit` in the trend parameter. You can see that the baseline is much closer to the input series. All the inserted outliers are detected, and also some false positives. See the next example on tweaking the threshold.\r\n\r\n```\r\nlet ts=range t from 1 to 24*7*5 step 1 \r\n| extend Timestamp = datetime(2018-03-01 05:00) + 1h * t \r\n| extend y = 2*rand() + iff((t/24)%7>=5, 5.0, 15.0) - (((t%24)/10)*((t%24)/10)) + t/72.0 // generate a series with weekly seasonality and ongoing trend\r\n| extend y=iff(t==150 or t==200 or t==780, y-8.0, y) // add some dip outliers\r\n| extend y=iff(t==300 or t==400 or t==600, y+8.0, y) // add some spike outliers\r\n| summarize Timestamp=make_list(Timestamp, 10000),y=make_list(y, 10000);\r\nts \r\n| extend series_decompose_anomalies(y, 1.5, -1, 'linefit')\r\n| extend series_decompose_anomalies_y_ad_flag = \r\nseries_multiply(10, series_decompose_anomalies_y_ad_flag) // multiply by 10 for visualization purposes\r\n| render timechart  \r\n```\r\n\r\n![Weekly seasonality anomalies with linefit trend](images/series-decompose-anomaliesfunction/weekly-seasonality-linefit-trend.png)\r\n\r\n### Tweak the anomaly detection threshold\r\n\r\nA few noisy points were detected as anomalies in the previous example. Now increase the anomaly detection threshold from a default of 1.5 to 2.5. Use this interpercentile range, so that only stronger anomalies are detected. Now, only the outliers you inserted in the data, will be detected.\r\n\r\n```\r\nlet ts=range t from 1 to 24*7*5 step 1 \r\n| extend Timestamp = datetime(2018-03-01 05:00) + 1h * t \r\n| extend y = 2*rand() + iff((t/24)%7>=5, 5.0, 15.0) - (((t%24)/10)*((t%24)/10)) + t/72.0 // generate a series with weekly seasonality and onlgoing trend\r\n| extend y=iff(t==150 or t==200 or t==780, y-8.0, y) // add some dip outliers\r\n| extend y=iff(t==300 or t==400 or t==600, y+8.0, y) // add some spike outliers\r\n| summarize Timestamp=make_list(Timestamp, 10000),y=make_list(y, 10000);\r\nts \r\n| extend series_decompose_anomalies(y, 2.5, -1, 'linefit')\r\n| extend series_decompose_anomalies_y_ad_flag = \r\nseries_multiply(10, series_decompose_anomalies_y_ad_flag) // multiply by 10 for visualization purposes\r\n| render timechart  \r\n```\r\n\r\n![Weekly series anomalies with higher anomaly threshold](images/series-decompose-anomaliesfunction/weekly-seasonality-higher-threshold.png)","https://docs.microsoft.com/en-us/azure/kusto/query/series-decompose-anomaliesfunction","series-decompose-anomaliesfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"series_decompose_forecast","Forecast based on series decomposition.","Takes an expression containing a series (dynamic numerical array) as input, and predicts the values of the last trailing points. For more information, see [series_decompose](series-decomposefunction.md).\r\n\r\n## Syntax\r\n\r\n`series_decompose_forecast(`*Series* `,` *Points* `[,` *Seasonality*`,` *Trend*`,` *Seasonality_threshold*`])`\r\n\r\n## Arguments\r\n\r\n* *Series*: Dynamic array cell of numeric values. Typically, the resulting output of [make-series](make-seriesoperator.md) or [make_list](makelist-aggfunction.md) operators.\r\n* *Points*: Integer specifying the number of points at the end of the series to predict (forecast). These points are excluded from the learning (regression) process.\r\n* *Seasonality*: An integer controlling the seasonal analysis, containing one of:\r\n    * -1: Autodetect seasonality using [series_periods_detect](series-periods-detectfunction.md) (default).\r\n    * period: Positive integer, specifying the expected period in number of bins. For example, if the series is in 1h bins, a weekly period is 168 bins.\r\n    * 0: No seasonality (skip extracting this component).\r\n* *Trend*: A string controlling the trend analysis, containing one of:\r\n    * `linefit`: Extract trend component using linear regression (default).\r\n    * `avg`: Define trend component as average(x).\r\n    * `none`: No trend, skip extracting this component.\r\n* *Seasonality_threshold*: The threshold for seasonality score when *Seasonality* is set to autodetect. The default score threshold is `0.6`. For more information, see [series_periods_detect](series-periods-detectfunction.md).\r\n\r\n**Return**\r\n\r\nA dynamic array with the forecasted series.\r\n\r\n> [!NOTE]\r\n> * The dynamic array of the original input series should include a number of *points* slots to be forecasted. The forecast is typically done by using [make-series](make-seriesoperator.md) and specifying the end time in the range that includes the timeframe to forecast.\r\n> * Either seasonality or trend should be enabled, otherwise the function is redundant, and just returns a series filled with zeroes.","In the following example, we generate a series of four weeks in an hourly grain, with weekly seasonality and a small upward trend. We then use `make-series` and add another empty week to the series. `series_decompose_forecast` is called with a week (24*7 points), and it automatically detects the seasonality and trend, and generates a forecast of the entire five-week period.\r\n\r\n```\r\nlet ts=range t from 1 to 24*7*4 step 1 // generate 4 weeks of hourly data\r\n| extend Timestamp = datetime(2018-03-01 05:00) + 1h * t \r\n| extend y = 2*rand() + iff((t/24)%7>=5, 5.0, 15.0) - (((t%24)/10)*((t%24)/10)) + t/72.0 // generate a series with weekly seasonality and ongoing trend\r\n| extend y=iff(t==150 or t==200 or t==780, y-8.0, y) // add some dip outliers\r\n| extend y=iff(t==300 or t==400 or t==600, y+8.0, y) // add some spike outliers\r\n| make-series y=max(y) on Timestamp in range(datetime(2018-03-01 05:00), datetime(2018-03-01 05:00)+24*7*5h, 1h); // create a time series of 5 weeks (last week is empty)\r\nts \r\n| extend y_forcasted = series_decompose_forecast(y, 24*7)  // forecast a week forward\r\n| render timechart \r\n```\r\n\r\n![Series decompose forecast](images/series-decompose-forecastfunction/series-decompose-forecast.png)","https://docs.microsoft.com/en-us/azure/kusto/query/series-decompose-forecastfunction","series-decompose-forecastfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"series_divide","Calculates the element-wise division of two numeric series inputs.","## Syntax\r\n\r\n`series_divide(`*series1*`,` *series2*`)`\r\n\r\n## Arguments\r\n\r\n* *series1, series2*: Input numeric arrays, the first to be element-wise divided by the second into a dynamic array result. All arguments must be dynamic arrays. \r\n\r\n## Returns\r\n\r\nDynamic array of calculated element-wise divide operation between the two inputs. Any non-numeric element or non-existing element (arrays of different sizes) yields a `null` element value.\r\n\r\nNote: the result series is of double type, even if the inputs are integers. Division by zero follows the double division by zero (e.g. 2/0 yields double(+inf)).","```\r\nrange x from 1 to 3 step 1\r\n| extend y = x * 2\r\n| extend z = y * 2\r\n| project s1 = pack_array(x,y,z), s2 = pack_array(z, y, x)\r\n| extend s1_divide_s2 = series_divide(s1, s2)\r\n```\r\n\r\n|s1\t        |s2|\t    s1_divide_s2|\r\n|---|---|---|\r\n|[1,2,4]\t|[4,2,1]|\t[0.25,1.0,4.0]|\r\n|[2,4,8]\t|[8,4,2]|\t[0.25,1.0,4.0]|\r\n|[3,6,12]\t|[12,6,3]|\t[0.25,1.0,4.0]|","https://docs.microsoft.com/en-us/azure/kusto/query/series-dividefunction","series-dividefunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"series_equals","Calculates the element-wise equals (`==`) logic operation of two numeric series inputs.","## Syntax\r\n\r\n`series_equals (`*Series1*`,` *Series2*`)`\r\n\r\n## Arguments\r\n\r\n* *Series1, Series2*: Input numeric arrays to be element-wise compared. All arguments must be dynamic arrays. \r\n\r\n## Returns\r\n\r\nDynamic array of booleans containing the calculated element-wise equal logic operation between the two inputs. Any non-numeric element or non-existing element (arrays of different sizes) yields a `null` element value.","```\r\nprint s1 = dynamic([1,2,4]), s2 = dynamic([4,2,1])\r\n| extend s1_equals_s2 = series_equals(s1, s2)\r\n```\r\n\r\n|s1|s2|s1_equals_s2|\r\n|---|---|---|\r\n|[1,2,4]|[4,2,1]|[false,true,false]|\r\n\r\n## See also\r\n\r\nFor entire series statistics comparisons, see:\r\n\r\n* [series_stats()](series-statsfunction.md)\r\n* [series_stats_dynamic()](series-stats-dynamicfunction.md)","https://docs.microsoft.com/en-us/azure/kusto/query/series-equalsfunction","series-equalsfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"series_fft","Applies the Fast Fourier Transform (FFT) on a series.","The series_fft() function takes a series of complex numbers in the time/spatial domain and transforms it to the frequency domain using the [Fast Fourier Transform](https://en.wikipedia.org/wiki/Fast_Fourier_transform). The transformed complex series represents the magnitude and phase of the frequencies appearing in the original series. Use the complementary function [series_ifft](series-ifft-function.md) to transform from the frequency domain back to the time/spatial domain.\r\n\r\n## Syntax\r\n\r\n`series_fft(`*x_real* [`,` *x_imaginary*]`)`\r\n\r\n## Arguments\r\n\r\n* *x_real*: Dynamic array of numeric values representing the real component of the series to transform.\r\n* *x_imaginary*: A similar dynamic array representing the imaginary component of the series. This parameter is optional and should be specified only if the input series contains complex numbers.\r\n\r\n## Returns\r\n\r\nThe function returns the complex inverse fft in two series. The first series for the real component and the second one for the imaginary component.","* Generate a complex series, where the real and imaginary components are pure sine waves in different frequencies. Use FFT to transform it to the frequency domain:\r\n\r\n    \r\n    ```\r\n    let sinewave=(x:double, period:double, gain:double=1.0, phase:double=0.0)\r\n    {\r\n        gain*sin(2*pi()/period*(x+phase))\r\n    }\r\n    ;\r\n    let n=128;      //  signal length\r\n    range x from 0 to n-1 step 1 | extend yr=sinewave(x, 8), yi=sinewave(x, 32)\r\n    | summarize x=make_list(x), y_real=make_list(yr), y_imag=make_list(yi)\r\n    | extend (fft_y_real, fft_y_imag) = series_fft(y_real, y_imag)\r\n    | render linechart with(ysplit=panels)\r\n    ```\r\n    \r\n    This query returns *fft_y_real* and *fft_y_imag*:  \r\n    \r\n    ![Series fft](images/series-fft-function/series-fft.png)    \r\n* Transform a series to the frequency domain, and then apply the inverse transform to get back the original series:\r\n\r\n    \r\n    ```\r\n    let sinewave=(x:double, period:double, gain:double=1.0, phase:double=0.0)\r\n    {\r\n        gain*sin(2*pi()/period*(x+phase))\r\n    }\r\n    ;\r\n    let n=128;      //  signal length\r\n    range x from 0 to n-1 step 1 | extend yr=sinewave(x, 8), yi=sinewave(x, 32)\r\n    | summarize x=make_list(x), y_real=make_list(yr), y_imag=make_list(yi)\r\n    | extend (fft_y_real, fft_y_imag) = series_fft(y_real, y_imag)\r\n    | extend (y_real2, y_image2) = series_ifft(fft_y_real, fft_y_imag)\r\n    | project-away fft_y_real, fft_y_imag   //  too many series for linechart with panels\r\n    | render linechart with(ysplit=panels)\r\n    ```\r\n    \r\n    This query returns *y_real2* and *y_imag2, which are the same as *y_real* and *y_imag*:  \r\n    \r\n    ![Series ifft](images/series-fft-function/series-ifft.png)","https://docs.microsoft.com/en-us/azure/kusto/query/series-fft-function","series-fft-function.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"series_fill_backward","Performs a backward fill interpolation of missing values in a series.","An expression containing dynamic numerical array is the input. The function replaces all instances of missing_value_placeholder with the nearest value from its right side (other than missing_value_placeholder), and returns the resulting array. The rightmost instances of missing_value_placeholder are preserved.\r\n\r\n## Syntax\r\n\r\n`series_fill_backward(`*x*`[, `*missing_value_placeholder*`])`\r\n\r\n* Will return series *x* with all instances of *missing_value_placeholder* filled backwards.\r\n\r\n## Arguments\r\n\r\n* *x*: dynamic array scalar expression, which is an array of numeric values.\r\n* *missing_value_placeholder*: this optional parameter specifies a placeholder for missing values. The default value is `double`(*null*).\r\n\r\n**Notes**\r\n\r\n* Specify *null* as the default value to apply any interpolation functions after [make-series](make-seriesoperator.md): \r\n\r\n\r\n```\r\nmake-series num=count() default=long(null) on TimeStamp from ago(1d) to ago(1h) step 1h by Os, Browser\r\n```\r\n\r\n* The *missing_value_placeholder* can be of any type that will be converted to actual element types. Both `double`(*null*), `long`(*null*) and `int`(*null*) have the same meaning.\r\n* If *missing_value_placeholder* is `double`(*null*), (or omitted, which have the same meaning) then a result may contain *null* values. To fill these *null* values, use other interpolation functions. Currently only [series_outliers()](series-outliersfunction.md) support *null* values in input arrays.\r\n* The function preserves original type of array elements.","```\r\nlet data = datatable(arr: dynamic)\r\n[\r\n    dynamic([111,null,36,41,null,null,16,61,33,null,null])   \r\n];\r\ndata \r\n| project arr, \r\n          fill_forward = series_fill_backward(arr)\r\n\r\n```\r\n\r\n|`arr`|`fill_forward`|\r\n|---|---|\r\n|[111,null,36,41,null,null,16,61,33,null,null]|[111,36,36,41,16, 16,16,61,33,null,null]|\r\n\r\nUse [series_fill_forward](series-fill-forwardfunction.md) or [series-fill-const](series-fill-constfunction.md) to complete interpolation of the above array.","https://docs.microsoft.com/en-us/azure/kusto/query/series-fill-backwardfunction","series-fill-backwardfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"series_fill_const","Replaces missing values in a series with a specified constant value.","Takes an expression containing dynamic numerical array as input, replaces all instances of missing_value_placeholder with the specified constant_value and returns the resulting array.\r\n\r\n## Syntax\r\n\r\n`series_fill_const(`*x*`, `*constant_value*`[,` *missing_value_placeholder*`])`\r\n\r\n* Will return series *x* with all instances of *missing_value_placeholder* replaced with *constant_value*.\r\n\r\n## Arguments\r\n\r\n* *x*: dynamic array scalar expression that is an array of numeric values.\r\n* *constant_value*: the value replacing missing values. \r\n* *missing_value_placeholder*: optional parameter that specifies a placeholder for a missing value to be replaced. Default value is `double`(*null*).\r\n\r\n**Notes**\r\n\r\n* If you create the series using the [make-series](make-seriesoperator.md) operator, it fills in the missing values using default 0. Alternatively, you can specify a constant value to fill in by specifying `default = ` *DefaultValue* in the make-series statement.\r\n\r\n\r\n```\r\nmake-series num=count() default=-1 on TimeStamp from ago(1d) to ago(1h) step 1h by Os, Browser\r\n```\r\n\r\n* To apply any interpolation functions after [make-series](make-seriesoperator.md), specify *null* as a default value: \r\n\r\n\r\n```\r\nmake-series num=count() default=long(null) on TimeStamp from ago(1d) to ago(1h) step 1h by Os, Browser\r\n```\r\n\r\n* The *missing_value_placeholder* can be of any type, which will be converted to actual element types. As such, either `double`(*null*), `long`(*null*) or `int`(*null*) have the same meaning.\r\n* The function preserves original type of the array elements.","```\r\nlet data = datatable(`arr`: dynamic)\r\n[\r\n    dynamic([111,null,36,41,23,null,16,61,33,null,null])   \r\n];\r\ndata \r\n| project arr, \r\n          fill_const1 = series_fill_const(arr, 0.0),\r\n          fill_const2 = series_fill_const(arr, -1)  \r\n```\r\n\r\n|`arr`|`fill_const1`|`fill_const2`|\r\n|---|---|---|\r\n|[111,null,36,41,23,null,16,61,33,null,null]|[111,0.0,36,41,23,0.0,16,61,33,0.0,0.0]|[111,-1,36,41,23,-1,16,61,33,-1,-1]|","https://docs.microsoft.com/en-us/azure/kusto/query/series-fill-constfunction","series-fill-constfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"series_fill_forward","Performs a forward fill interpolation of missing values in a series.","An expression containing dynamic numerical array is the input. The function replaces all instances of missing_value_placeholder with the nearest value from its left side other than missing_value_placeholder, and returns the resulting array. The leftmost instances of missing_value_placeholder are preserved.\r\n\r\n## Syntax\r\n\r\n`series_fill_forward(`*x*`[, `*missing_value_placeholder*`])`\r\n\r\n* Will return series *x* with all instances of *missing_value_placeholder* filled forwards.\r\n\r\n## Arguments\r\n\r\n* *x*: dynamic array scalar expression, which is an array of numeric values. \r\n* *missing_value_placeholder*: optional parameter, which specifies a placeholder for a missing value to be replaced. Default value is `double`(*null*).\r\n\r\n**Notes**\r\n\r\n* Specify *null* as the default value to apply interpolation functions after [make-series](make-seriesoperator.md): \r\n\r\n\r\n```\r\nmake-series num=count() default=long(null) on TimeStamp from ago(1d) to ago(1h) step 1h by Os, Browser\r\n```\r\n\r\n* The *missing_value_placeholder* can be of any type that will be converted to actual element types. Both `double`(*null*) `long`(*null*) and `int`(*null*) have the same meaning.\r\n* If missing_value_placeholder is (null) (or omitted - which have the same meaning), then a result may contain *null* values. To fill these *null* values, use other interpolation functions. Currently only [series_outliers()](series-outliersfunction.md) support *null* values in input arrays.\r\n* The functions preserve the original type of array elements.","```\r\nlet data = datatable(arr: dynamic)\r\n[\r\n    dynamic([null,null,36,41,null,null,16,61,33,null,null])   \r\n];\r\ndata \r\n| project arr, \r\n          fill_forward = series_fill_forward(arr)  \r\n\r\n```\r\n\r\n|`arr`|`fill_forward`|\r\n|---|---|\r\n|[null,null,36,41,null,null,16,61,33,null,null]|[null,null,36,41,41,41,16,61,33,33,33]|\r\n\r\nUse [series_fill_backward](series-fill-backwardfunction.md) or [series-fill-const](series-fill-constfunction.md) to complete interpolation of the above array.","https://docs.microsoft.com/en-us/azure/kusto/query/series-fill-forwardfunction","series-fill-forwardfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"series_fill_linear","Linearly interpolates missing values in a series.",'Takes an expression containing dynamic numerical array as input, does linear interpolation for all instances of missing_value_placeholder, and returns the resulting array. If the beginning and end of the array contain missing_value_placeholder, then it will be replaced with the nearest value other than missing_value_placeholder. This feature can be turned off. If the whole array consists of the missing_value_placeholder, the array will be filled with constant_value, or 0 if not specified.  \r\n\r\n## Syntax\r\n\r\n`series_fill_linear(`*x*`[,` *missing_value_placeholder*` [,`*fill_edges*` [,`*constant_value*`]]]))`\r\n\r\n* Will return series linear interpolation of *x* using specified parameters.\r\n \r\n\r\n## Arguments\r\n\r\n* *x*: dynamic array scalar expression, which is an array of numeric values.\r\n* *missing_value_placeholder*: optional parameter, which specifies a placeholder for the "missing values" to be replaced. Default value is `double`(*null*).\r\n* *fill_edges*: Boolean value, which indicates whether *missing_value_placeholder* at the start and end of the array should be replaced with nearest value. *True* by default. If set to *false*, then *missing_value_placeholder* at the start and end of the array will be preserved.\r\n* *constant_value*: optional parameter relevant only for arrays entirely consists of *null* values. This parameter specifies a constant value to fill the series with. Default value is *0*. Setting this parameter it to `double`(*null*) will effectively leave *null* values where they are.\r\n\r\n## Notes\r\n\r\n* To apply any interpolation functions after [make-series](make-seriesoperator.md), specify *null* as the default value: \r\n    \r\n    ```\r\n    make-series num=count() default=long(null) on TimeStamp from ago(1d) to ago(1h) step 1h by Os, Browser\r\n    ```\r\n* The *missing_value_placeholder* can be of any type that will be converted to actual element types. As such, either `double`(*null*), `long`(*null*) or `int`(*null*) have the same meaning.\r\n* If *missing_value_placeholder* is `double`(*null*) (or omitted, which have the same meaning) then a result may contain *null* values. Use other interpolation functions to fill these *null* values. Currently only [series_outliers()](series-outliersfunction.md) support *null* values in input arrays.\r\n* The function preserves original type of array elements. If x contains only int or long elements, then the linear interpolation will return rounded interpolated values rather than exact ones.',"```\r\nlet data = datatable(arr: dynamic)\r\n[\r\n    dynamic([null, 111.0, null, 36.0, 41.0, null, null, 16.0, 61.0, 33.0, null, null]), // Array of double    \r\n    dynamic([null, 111,   null, 36,   41,   null, null, 16,   61,   33,   null, null]), // Similar array of int\r\n    dynamic([null, null, null, null])                                                   // Array with missing values only\r\n];\r\ndata\r\n| project arr, \r\n          without_args = series_fill_linear(arr),\r\n          with_edges = series_fill_linear(arr, double(null), true),\r\n          wo_edges = series_fill_linear(arr, double(null), false),\r\n          with_const = series_fill_linear(arr, double(null), true, 3.14159)  \r\n\r\n```\r\n\r\n|`arr`|`without_args`|`with_edges`|`wo_edges`|`with_const`|\r\n|---|---|---|---|---|\r\n|[null,111.0,null,36.0,41.0,null,null,16.0,61.0,33.0,null,null]|[111.0,111.0,73.5,36.0,41.0,32.667,24.333,16.0,61.0,33.0,33.0,33.0]|[111.0,111.0,73.5,36.0,41.0,32.667,24.333,16.0,61.0,33.0,33.0,33.0]|[null,111.0,73.5,36.0,41.0,32.667,24.333,16.0,61.0,33.0,null,null]|[111.0,111.0,73.5,36.0,41.0,32.667,24.333,16.0,61.0,33.0,33.0,33.0]|\r\n|[null,111,null,36,41,null,null,16,61,33,null,null]|[111,111,73,36,41,32,24,16,61,33,33,33]|[111,111,73,36,41,32,24,16,61,33,33,33]|[null,111,73,36,41,32,24,16,61,33,null,null]|[111,111,74,38,  41,32,24,16,61,33,33,33]|\r\n|[null,null,null,null]|[0.0,0.0,0.0,0.0]|[0.0,0.0,0.0,0.0]|[0.0,0.0,0.0,0.0]|[3.14159,3.14159,3.14159,3.14159]|","https://docs.microsoft.com/en-us/azure/kusto/query/series-fill-linearfunction","series-fill-linearfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"series_fir","Applies a Finite Impulse Response (FIR) filter on a series.","The function takes an expression containing a dynamic numerical array as input and applies a [Finite Impulse Response](https://en.wikipedia.org/wiki/Finite_impulse_response) filter. By specifying the `filter` coefficients, it can be used for calculating a moving average, smoothing, change-detection, and many more use cases. The function takes the column containing the dynamic array and a static dynamic array of the filter's coefficients as input, and applies the filter on the column. It outputs a new dynamic array column, containing the filtered output.  \r\n\r\n## Syntax\r\n\r\n`series_fir(`*x*`,` *filter* [`,` *normalize*[`,` *center*]]`)`\r\n\r\n## Arguments\r\n\r\n* *x*: Dynamic array cell of numeric values. Typically the resulting output of [make-series](make-seriesoperator.md) or [make_list](makelist-aggfunction.md) operators.\r\n* *filter*: A constant expression containing the coefficients of the filter (stored as a dynamic array of numeric values).\r\n* *normalize*: Optional Boolean value indicating whether the filter should be normalized. That is, divided by the sum of the coefficients. If filter contains negative values, then *normalize* must be specified as `false`, otherwise result will be `null`. If not specified, then a default value of *normalize* is assumed, depending on the presence of negative values in the *filter*. If *filter* contains at least one negative value, then *normalize* is assumed to be `false`.  \r\nNormalization is a convenient way to make sure that the sum of the coefficients is 1. Then the filter doesn't amplify or attenuate the series. For example, the moving average of four bins could be specified by *filter*=[1,1,1,1] and *normalized*=true, which is easier than typing [0.25,0.25.0.25,0.25].\r\n* *center*: An optional Boolean value that indicates whether the filter is applied symmetrically on a time window before and after the current point, or on a time window from the current point backwards. By default, center is false, which fits the scenario of streaming data, where we can only apply the filter on the current and older points. However, for ad-hoc processing you can set it to `true`, keeping it synchronized with the time series. See examples below. This parameter controls the filter’s [group delay](https://en.wikipedia.org/wiki/Group_delay_and_phase_delay).","* Calculate a moving average of five points by setting *filter*=[1,1,1,1,1] and *normalize*=`true` (default). Note the effect of *center*=`false` (default) vs. `true`:\r\n\r\n\r\n\r\n```\r\nrange t from bin(now(), 1h)-23h to bin(now(), 1h) step 1h\r\n| summarize t=make_list(t)\r\n| project id='TS', val=dynamic([0,0,0,0,0,0,0,0,0,10,20,40,100,40,20,10,0,0,0,0,0,0,0,0]), t\r\n| extend 5h_MovingAvg=series_fir(val, dynamic([1,1,1,1,1])),\r\n         5h_MovingAvg_centered=series_fir(val, dynamic([1,1,1,1,1]), true, true)\r\n| render timechart\r\n```\r\n\r\nThis query returns:  \r\n*5h_MovingAvg*: Five points moving average filter. The spike is smoothed and its peak shifted by (5-1)/2 = 2h.  \r\n*5h_MovingAvg_centered*: Same, but by setting `center=true`, the peak stays in its original location.\r\n\r\n![Series fir](images/series-firfunction/series-fir.png)\r\n\r\n* To calculate the difference between a point and its preceding one, set *filter*=[1,-1].\r\n\r\n\r\n\r\n```\r\nrange t from bin(now(), 1h)-11h to bin(now(), 1h) step 1h\r\n| summarize t=make_list(t)\r\n| project id='TS',t,value=dynamic([0,0,0,0,2,2,2,2,3,3,3,3])\r\n| extend diff=series_fir(value, dynamic([1,-1]), false, false)\r\n| render timechart\r\n```\r\n\r\n![Series fir 2](images/series-firfunction/series-fir2.png)","https://docs.microsoft.com/en-us/azure/kusto/query/series-firfunction","series-firfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"series_fit_2lines","Applies two segments linear regression on a series, returning multiple columns.","Takes an expression containing dynamic numerical array as input and applies [two segments linear regression](https://en.wikipedia.org/wiki/Segmented_regression) in order to identify and quantify a trend change in a series. The function iterates on the series indexes. In each iteration, the function splits the series to two parts, fits a separate line (using [series_fit_line()](series-fit-linefunction.md)) to each part, and calculates the total r-square. The best split is the one that maximized r-square; the function returns its parameters:\r\n\r\n|Parameter  |Description  |\r\n|---------|---------|\r\n|`rsquare`     | [R-square](https://en.wikipedia.org/wiki/Coefficient_of_determination) is standard measure of the fit quality. It's a number in the range [0-1], where 1 - is the best possible fit, and 0 means the data is unordered and do not fit any line.        |\r\n|`split_idx`     |   The index of breaking point to two segments (zero-based).      |\r\n|`variance`     | Variance of the input data.        |\r\n|`rvariance`     | Residual variance, which is the variance between the input data values the approximated ones (by the two line segments).        |\r\n|`line_fit`     | Numerical array holding a series of values of the best fitted line. The series length is equal to the length of the input array. It's mainly used for charting.        |\r\n|`right_rsquare`     | R-square of the line on the right side of the split, see [series_fit_line()](series-fit-linefunction.md).        |\r\n|`right_slope`     | Slope of the right approximated line (of the form y=ax+b).         |\r\n|`right_interception`     |  Interception of the approximated left line (b from y=ax+b).       |\r\n|`right_variance`    | Variance of the input data on the right side of the split.        |\r\n|`right_rvariance`     | Residual variance of the input data on the right side of the split.        |\r\n|`left_rsquare`     | R-square of the line on the left side of the split, see [series_fit_line()](series-fit-linefunction.md).        |\r\n|`left_slope`    | Slope of the left approximated line (of the form y=ax+b).        |\r\n|`left_interception`     |   Interception of the approximated left line (of the form y=ax+b).      |\r\n|`left_variance`     | Variance of the input data on the left side of the split.        |\r\n|`left_rvariance`     | Residual variance of the input data on the left side of the split.        |\r\n\r\n> [!Note]\r\n> This function returns multiple columns an so cannot be used as an argument for another function.\r\n\r\n## Syntax\r\n\r\nproject `series_fit_2lines(`*x*`)`\r\n\r\n* Will return all mentioned above columns with the following names: series_fit_2lines_x_rsquare, series_fit_2lines_x_split_idx etc.\r\n\r\nproject (rs, si, v)=`series_fit_2lines(`*x*`)`\r\n\r\n* Will return the following columns: rs (r-square), si (split index), v (variance) and the rest will look like series_fit_2lines_x_rvariance, series_fit_2lines_x_line_fit and etc.\r\n\r\nextend (rs, si, v)=`series_fit_2lines(`*x*`)`\r\n\r\n* Will return only: rs (r-square), si (split index) and v (variance).\r\n  \r\n\r\n## Arguments\r\n\r\n* *x*: Dynamic array of numeric values.  \r\n\r\n> [!TIP]\r\n> The most convenient way of using this function is applying it to the results of [make-series](make-seriesoperator.md) operator.","```\r\nprint id=' ', x=range(bin(now(), 1h)-11h, bin(now(), 1h), 1h), y=dynamic([1,2.2, 2.5, 4.7, 5.0, 12, 10.3, 10.3, 9, 8.3, 6.2])\r\n| extend (Slope,Interception,RSquare,Variance,RVariance,LineFit)=series_fit_line(y), (RSquare2, SplitIdx, Variance2,RVariance2,LineFit2)=series_fit_2lines(y)\r\n| project id, x, y, LineFit, LineFit2\r\n| render timechart\r\n```\r\n\r\n![Series fit 2 lines](images/series-fit-2lines/series-fit-2lines.png)","https://docs.microsoft.com/en-us/azure/kusto/query/series-fit-2linesfunction","series-fit-2linesfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"series_fit_2lines_dynamic","Applies two segments linear regression on a series, returning a dynamic object.","Takes an expression containing dynamic numerical array as input and applies [two segments linear regression](https://en.wikipedia.org/wiki/Segmented_regression) in order to identify and quantify trend changes in a series. The function iterates on the series indexes. In each iteration, it splits the series to two parts, and fits a separate line using [series_fit_line()](series-fit-linefunction.md) or [series_fit_line_dynamic()](series-fit-line-dynamicfunction.md). The function fits the lines to each of the two parts, and calculates the total R-squared value. The best split is the one that maximizes R-squared. The function returns its parameters in dynamic value with the following content:\r\n\r\n* `rsquare`: [R-squared](https://en.wikipedia.org/wiki/Coefficient_of_determination) is a standard measure of the fit quality. It's a number in the range of [0-1], where 1 is the best possible fit, and 0 means the data is unordered and do not fit any line.\r\n* `split_idx`: the index of breaking point to two segments (zero-based).\r\n* `variance`: variance of the input data.\r\n* `rvariance`: residual variance that is the variance between the input data values the approximated ones (by the two line segments).\r\n* `line_fit`: numerical array holding a series of values of the best fitted line. The series length is equal to the length of the input array. It is used for charting.\r\n* `right.rsquare`: r-square of the line on the right side of the split, see [series_fit_line()](series-fit-linefunction.md) or [series_fit_line_dynamic()](series-fit-line-dynamicfunction.md).\r\n* `right.slope`: slope of the right approximated line (of the form y=ax+b).\r\n* `right.interception`: interception of the approximated left line (b from y=ax+b).\r\n* `right.variance`: variance of the input data on the right side of the split.\r\n* `right.rvariance`: residual variance of the input data on the right side of the split.\r\n* `left.rsquare`: r-square of the line on the left side of the split, see [series_fit_line()].(series-fit-linefunction.md) or [series_fit_line_dynamic()](series-fit-line-dynamicfunction.md).\r\n* `left.slope`: slope of the left approximated line (of the form y=ax+b).\r\n* `left.interception`: interception of the approximated left line (of the form y=ax+b).\r\n* `left.variance`: variance of the input data on the left side of the split.\r\n* `left.rvariance`: residual variance of the input data on the left side of the split.\r\n\r\nThis operator is similar to [series_fit_2lines](series-fit-2linesfunction.md). Unlike `series-fit-2lines`, it returns a dynamic bag.\r\n\r\n## Syntax\r\n\r\n`series_fit_2lines_dynamic(`*x*`)`\r\n\r\n## Arguments\r\n\r\n* *x*: Dynamic array of numeric values.  \r\n\r\n> [!TIP]\r\n> The most convenient way of using this function is applying it to the results of the [make-series](make-seriesoperator.md) operator.","```\r\nprint id=' ', x=range(bin(now(), 1h)-11h, bin(now(), 1h), 1h), y=dynamic([1,2.2, 2.5, 4.7, 5.0, 12, 10.3, 10.3, 9, 8.3, 6.2])\r\n| extend LineFit=series_fit_line_dynamic(y).line_fit, LineFit2=series_fit_2lines_dynamic(y).line_fit\r\n| project id, x, y, LineFit, LineFit2\r\n| render timechart\r\n```\r\n\r\n![Series fit 2 lines](images/series-fit-2lines/series-fit-2lines.png)","https://docs.microsoft.com/en-us/azure/kusto/query/series-fit-2lines-dynamicfunction","series-fit-2lines-dynamicfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"series_fit_line","Applies linear regression on a series, returning multiple columns.",'Takes an expression containing dynamic numerical array as input and does [linear regression](https://en.wikipedia.org/wiki/Line_fitting) to find the line that best fits it. This function should be used on time series arrays, fitting the output of make-series operator. The function generates the following columns:\r\n\r\n* `rsquare`: [r-square](https://en.wikipedia.org/wiki/Coefficient_of_determination) is a standard measure of the fit quality. The value\'s a number in the range [0-1], where 1 - is the best possible fit, and 0 means the data is unordered and doesn\'t fit any line. \r\n* `slope`: Slope of the approximated line ("a" from y=ax+b).\r\n* `variance`: Variance of the input data.\r\n* `rvariance`: Residual variance that is the variance between the input data values the approximated ones.\r\n* `interception`: Interception of the approximated line ("b" from y=ax+b).\r\n* `line_fit`: Numerical array holding a series of values of the best fitted line. The series length is equal to the length of the input array. The value\'s used for charting.\r\n\r\n## Syntax\r\n\r\n`series_fit_line(`*x*`)`\r\n\r\n## Arguments\r\n\r\n* *x*: Dynamic array of numeric values.\r\n\r\n> [!TIP]\r\n> The most convenient way of using this function is to apply it to the results of [make-series](make-seriesoperator.md) operator.',"```\r\nprint id=' ', x=range(bin(now(), 1h)-11h, bin(now(), 1h), 1h), y=dynamic([2,5,6,8,11,15,17,18,25,26,30,30])\r\n| extend (RSquare,Slope,Variance,RVariance,Interception,LineFit)=series_fit_line(y)\r\n| render timechart\r\n```\r\n\r\n![Series fit line](images/series-fit-line/series-fit-line.png)\r\n| RSquare | Slope | Variance | RVariance | Interception | LineFit                                                                                     |\r\n|---------|-------|----------|-----------|--------------|---------------------------------------------------------------------------------------------|\r\n| 0.982   | 2.730 | 98.628   | 1.686     | -1.666       | 1.064, 3.7945, 6.526, 9.256, 11.987, 14.718, 17.449, 20.180, 22.910, 25.641, 28.371, 31.102 |","https://docs.microsoft.com/en-us/azure/kusto/query/series-fit-linefunction","series-fit-linefunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"series_fit_line_dynamic","Applies linear regression on a series, returning dynamic object.","Takes an expression containing dynamic numerical array as input, and does [linear regression](https://en.wikipedia.org/wiki/Line_fitting) to find the line that best fits it. This function should be used on time series arrays, fitting the output of make-series operator. It generates a dynamic value with the following content:\r\n\r\n* `rsquare`: [r-square](https://en.wikipedia.org/wiki/Coefficient_of_determination) is a standard measure of the fit quality. It's a number in the range [0-1], where 1 is the best possible fit, and 0 means the data is unordered and doesn't fit any line\r\n* `slope`: Slope of the approximated line (the *a*-value from *y=ax+b*)\r\n* `variance`: Variance of the input data\r\n* `rvariance`: Residual variance that is the variance between the input data values and the approximated ones.\r\n* `interception`: Interception of the approximated line (the *b*-value from *y=ax+b*)\r\n* `line_fit`: Numerical array containing a series of values of the best fit line. The series length is equal to the length of the input array. It's used mainly for charting.\r\n\r\nThis operator is similar to [series_fit_line](series-fit-linefunction.md), but unlike `series-fit-line` it returns a dynamic bag.\r\n\r\n## Syntax\r\n\r\n`series_fit_line_dynamic(`*x*`)`\r\n\r\n## Arguments\r\n\r\n* *x*: Dynamic array of numeric values.\r\n\r\n> [!TIP]\r\n> The most convenient way of using this function is by applying it to the results of [make-series](make-seriesoperator.md) operator.","```\r\nprint id=' ', x=range(bin(now(), 1h)-11h, bin(now(), 1h), 1h), y=dynamic([2,5,6,8,11,15,17,18,25,26,30,30])\r\n| extend fit=series_fit_line_dynamic(y)\r\n| extend RSquare=fit.rsquare, Slope=fit.slope, Variance=fit.variance,RVariance=fit.rvariance,Interception=fit.interception,LineFit=fit.line_fit\r\n| render timechart\r\n```\r\n\r\n![Series fit line](images/series-fit-line/series-fit-line.png)\r\n| RSquare | Slope | Variance | RVariance | Interception | LineFit                                                                                     |\r\n|---------|-------|----------|-----------|--------------|---------------------------------------------------------------------------------------------|\r\n| 0.982   | 2.730 | 98.628   | 1.686     | -1.666       | 1.064, 3.7945, 6.526, 9.256, 11.987, 14.718, 17.449, 20.180, 22.910, 25.641, 28.371, 31.102 |","https://docs.microsoft.com/en-us/azure/kusto/query/series-fit-line-dynamicfunction","series-fit-line-dynamicfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"series_greater","Calculates the element-wise greater (`>`) logic operation of two numeric series inputs.","## Syntax\r\n\r\n`series_greater (`*Series1*`,` *Series2*`)`\r\n\r\n## Arguments\r\n\r\n* *Series1, Series2*: Input numeric arrays to be element-wise compared. All arguments must be dynamic arrays. \r\n\r\n## Returns\r\n\r\nDynamic array of booleans containing the calculated element-wise greater logic operation between the two inputs. Any non-numeric element or non-existing element (arrays of different sizes) yields a `null` element value.","```\r\nprint s1 = dynamic([1,2,4]), s2 = dynamic([4,2,1])\r\n| extend s1_greater_s2 = series_greater(s1, s2)\r\n```\r\n\r\n|s1|s2|s1_greater_s2|\r\n|---|---|---|\r\n|[1,2,4]|[4,2,1]|[false,false,true]|\r\n\r\n## See also\r\n\r\nFor entire series statistics comparisons, see:\r\n\r\n* [series_stats()](series-statsfunction.md)\r\n* [series_stats_dynamic()](series-stats-dynamicfunction.md)","https://docs.microsoft.com/en-us/azure/kusto/query/series-greaterfunction","series-greaterfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"series_greater_equals","Calculates the element-wise greater or equals (`>=`) logic operation of two numeric series inputs.","## Syntax\r\n\r\n`series_greater_equals (`*Series1*`,` *Series2*`)`\r\n\r\n## Arguments\r\n\r\n* *Series1, Series2*: Input numeric arrays to be element-wise compared. All arguments must be dynamic arrays. \r\n\r\n## Returns\r\n\r\nDynamic array of booleans containing the calculated element-wise greater or equal logic operation between the two inputs. Any non-numeric element or non-existing element (arrays of different sizes) yields a `null` element value.","```\r\nprint s1 = dynamic([1,2,4]), s2 = dynamic([4,2,1])\r\n| extend s1_greater_equals_s2 = series_greater_equals(s1, s2)\r\n```\r\n\r\n|s1|s2|s1_greater_equals_s2|\r\n|---|---|---|\r\n|[1,2,4]|[4,2,1]|[false,true,true]|\r\n\r\n## See also\r\n\r\nFor entire series statistics comparisons, see:\r\n\r\n* [series_stats()](series-statsfunction.md)\r\n* [series_stats_dynamic()](series-stats-dynamicfunction.md)","https://docs.microsoft.com/en-us/azure/kusto/query/series-greater-equalsfunction","series-greater-equalsfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"series_ifft","Applies the Inverse Fast Fourier Transform (IFFT) on a series.","The series_ifft() function takes a series of complex numbers in the frequency domain and transforms it back to the time/spatial domain using the [Fast Fourier Transform](https://en.wikipedia.org/wiki/Fast_Fourier_transform). This function is the complementary function of [series_fft](series-fft-function.md). Commonly the original series is transformed to the frequency domain for spectral processing and then back to the time/spatial domain.\r\n\r\n## Syntax\r\n\r\n`series_ifft(`*fft_real* [`,` *fft_imaginary*]`)`\r\n\r\n## Arguments\r\n\r\n* *fft_real*: Dynamic array of numeric values representing the real component of the series to transform.\r\n* *fft_imaginary*: A similar dynamic array representing the imaginary component of the series. This parameter is optional and should be specified only if the input series contains complex numbers.\r\n\r\n## Returns\r\n\r\nThe function returns the complex inverse fft in two series. The first series for the real component and the second one for the imaginary component.","See [series_fft](series-fft-function.md#example)","https://docs.microsoft.com/en-us/azure/kusto/query/series-ifft-function","series-ifft-function.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"series_iir","Applies an Infinite Impulse Response filter on a series.","The function takes an expression containing dynamic numerical array as input, and applies an [Infinite Impulse Response](https://en.wikipedia.org/wiki/Infinite_impulse_response) filter. By specifying the filter coefficients, the function can be used:\r\n\r\n* to calculate the cumulative sum of the series\r\n* to apply smoothing operations\r\n* to apply various [high-pass](https://en.wikipedia.org/wiki/High-pass_filter), [band-pass](https://en.wikipedia.org/wiki/Band-pass_filter), and [low-pass](https://en.wikipedia.org/wiki/Low-pass_filter) filters\r\n\r\nThe function takes as input the column containing the dynamic array and two static dynamic arrays of the filter's *a* and *b* coefficients, and applies the filter on the column. It outputs a new dynamic array column, containing the filtered output.  \r\n\r\n## Syntax\r\n\r\n`series_iir(`*x*`,` *b* `,` *a*`)`\r\n\r\n## Arguments\r\n\r\n* *x*: Dynamic array cell that is an array of numeric values, typically the resulting output of [make-series](make-seriesoperator.md) or [make_list](makelist-aggfunction.md) operators.\r\n* *b*: A constant expression containing the numerator coefficients of the filter (stored as a dynamic array of numeric values).\r\n* *a*: A constant expression, like *b*. Containing the denominator coefficients of the filter.\r\n\r\n> [!IMPORTANT]\r\n> The first element of `a` (that is, `a[0]`) mustn't be zero, to avoid division by 0. See the [formula below](#the-filters-recursive-formula).\r\n\r\n## The filter's recursive formula\r\n\r\n* Consider an input array X, and coefficients arrays a and b of lengths n_a and n_b respectively. The transfer function of the filter that will generate the output array Y, is defined by:\r\n\r\n<div align=\"center\">\r\nY<sub>i</sub> = a<sub>0</sub><sup>-1</sup>(b<sub>0</sub>X<sub>i</sub>\r\n + b<sub>1</sub>X<sub>i-1</sub> + ... + b<sub>n<sub>b</sub>-1</sub>X<sub>i-n<sub>b</sub>-1</sub>\r\n - a<sub>1</sub>Y<sub>i-1</sub>-a<sub>2</sub>Y<sub>i-2</sub> - ... - a<sub>n<sub>a</sub>-1</sub>Y<sub>i-n<sub>a</sub>-1</sub>)\r\n</div>","Calculate a cumulative sum. \r\nUse the iir filter with coefficients *a*=[1,-1] and *b*=[1]:  \r\n\r\n```\r\nlet x = range(1.0, 10, 1);\r\nprint x=x, y = series_iir(x, dynamic([1]), dynamic([1,-1]))\r\n| mv-expand x, y\r\n```\r\n\r\n| x | y |\r\n|:--|:--|\r\n|1.0|1.0|\r\n|2.0|3.0|\r\n|3.0|6.0|\r\n|4.0|10.0|\r\n\r\nHere's how to wrap it in a function:\r\n\r\n```\r\nlet vector_sum=(x:dynamic)\r\n{\r\n  let y=array_length(x) - 1;\r\n  toreal(series_iir(x, dynamic([1]), dynamic([1, -1]))[y])\r\n};\r\nprint d=dynamic([0, 1, 2, 3, 4])\r\n| extend dd=vector_sum(d)\r\n```\r\n\r\n|d            |dd  |\r\n|-------------|----|\r\n|`[0,1,2,3,4]`|`10`|","https://docs.microsoft.com/en-us/azure/kusto/query/series-iirfunction","series-iirfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"series_less","Calculates the element-wise less (`<`) logic operation of two numeric series inputs.","## Syntax\r\n\r\n`series_less (`*Series1*`,` *Series2*`)`\r\n\r\n## Arguments\r\n\r\n* *Series1, Series2*: Input numeric arrays to be element-wise compared. All arguments must be dynamic arrays. \r\n\r\n## Returns\r\n\r\nDynamic array of booleans containing the calculated element-wise less logic operation between the two inputs. Any non-numeric element or non-existing element (arrays of different sizes) yields a `null` element value.","```\r\nprint s1 = dynamic([1,2,4]), s2 = dynamic([4,2,1])\r\n| extend s1_less_s2 = series_less(s1, s2)\r\n```\r\n\r\n|s1|s2|s1_less_s2|\r\n|---|---|---|\r\n|[1,2,4]|[4,2,1]|[true,false,false]|\r\n\r\n## See also\r\n\r\nFor entire series statistics comparisons, see:\r\n\r\n* [series_stats()](series-statsfunction.md)\r\n* [series_stats_dynamic()](series-stats-dynamicfunction.md)","https://docs.microsoft.com/en-us/azure/kusto/query/series-lessfunction","series-lessfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"series_less_equals","Calculates the element-wise less or equal (`<=`) logic operation of two numeric series inputs.","## Syntax\r\n\r\n`series_less_equals (`*Series1*`,` *Series2*`)`\r\n\r\n## Arguments\r\n\r\n* *Series1, Series2*: Input numeric arrays to be element-wise compared. All arguments must be dynamic arrays. \r\n\r\n## Returns\r\n\r\nDynamic array of booleans containing the calculated element-wise less or equal logic operation between the two inputs. Any non-numeric element or non-existing element (arrays of different sizes) yields a `null` element value.","```\r\nprint s1 = dynamic([1,2,4]), s2 = dynamic([4,2,1])\r\n| extend s1_less_equals_s2 = series_less_equals(s1, s2)\r\n```\r\n\r\n|s1|s2|s1_less_equals_s2|\r\n|---|---|---|\r\n|[1,2,4]|[4,2,1]|[true,true,false]|\r\n\r\n## See also\r\n\r\nFor entire series statistics comparisons, see:\r\n\r\n* [series_stats()](series-statsfunction.md)\r\n* [series_stats_dynamic()](series-stats-dynamicfunction.md)","https://docs.microsoft.com/en-us/azure/kusto/query/series-less-equalsfunction","series-less-equalsfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"series_multiply","Calculates the element-wise multiplication of two numeric series inputs.","## Syntax\r\n\r\n`series_multiply(`*series1*`,` *series2*`)`\r\n\r\n## Arguments\r\n\r\n* *series1, series2*: Input numeric arrays, to be element-wise multiplied into a dynamic array result. All arguments must be dynamic arrays. \r\n\r\n## Returns\r\n\r\nDynamic array of calculated element-wise multiplication operation between the two inputs. Any non-numeric element or non-existing element (arrays of different sizes) yields a `null` element value.","```\r\nrange x from 1 to 3 step 1\r\n| extend y = x * 2\r\n| extend z = y * 2\r\n| project s1 = pack_array(x,y,z), s2 = pack_array(z, y, x)\r\n| extend s1_multiply_s2 = series_multiply(s1, s2)\r\n```\r\n\r\n|s1\t        |s2|\t    s1_multiply_s2|\r\n|---|---|---|\r\n|[1,2,4]\t|[4,2,1]|\t[4,4,4]|\r\n|[2,4,8]\t|[8,4,2]|\t[16,16,16]|\r\n|[3,6,12]\t|[12,6,3]|\t[36,36,36]|","https://docs.microsoft.com/en-us/azure/kusto/query/series-multiplyfunction","series-multiplyfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"series_not_equals","Calculates the element-wise not equals (`!=`) logic operation of two numeric series inputs.","## Syntax\r\n\r\n`series_not_equals (`*Series1*`,` *Series2*`)`\r\n\r\n## Arguments\r\n\r\n* *Series1, Series2*: Input numeric arrays to be element-wise compared. All arguments must be dynamic arrays. \r\n\r\n## Returns\r\n\r\nDynamic array of booleans containing the calculated element-wise not equal logic operation between the two inputs. Any non-numeric element or non-existing element (arrays of different sizes) yields a `null` element value.","```\r\nprint s1 = dynamic([1,2,4]), s2 = dynamic([4,2,1])\r\n| extend s1_not_equals_s2 = series_not_equals(s1, s2)\r\n```\r\n\r\n|s1|s2|s1_not_equals_s2|\r\n|---|---|---|\r\n|[1,2,4]|[4,2,1]|[true,false,true]|\r\n\r\n## See also\r\n\r\nFor entire series statistics comparisons, see:\r\n\r\n* [series_stats()](series-statsfunction.md)\r\n* [series_stats_dynamic()](series-stats-dynamicfunction.md)","https://docs.microsoft.com/en-us/azure/kusto/query/series-not-equalsfunction","series-not-equalsfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"series_outliers","Scores anomaly points in a series.",'The function takes an expression with a dynamic numerical array as input, and generates a dynamic numeric array of the same length. Each value of the array indicates a score of a possible anomaly, using ["Tukey\'s test"](https://en.wikipedia.org/wiki/Outlier#Tukey\'s_fences). A value greater than 1.5 in the same element of the input indicates a rise or decline anomaly. A value less than -1.5, indicates a decline anomaly.\r\n\r\n## Syntax\r\n\r\n`series_outliers(`*x*`, `*kind*`, `*ignore_val*`, `*min_percentile*`, `*max_percentile*`)`\r\n\r\n## Arguments\r\n\r\n* *x*: Dynamic array cell that is an array of numeric values\r\n* *kind*: Algorithm of outlier detection. Currently supports `"tukey"` (traditional "Tukey") and  `"ctukey"` (custom "Tukey"). Default is `"ctukey"`\r\n* *ignore_val*: Numeric value indicating missing values in the series. Default is double(null). The score of nulls and ignore values is set to `0`\r\n* *min_percentile*: For calculating the normal inter-quantile range. Default is 10, custom values supported are in range `[2.0, 98.0]` (`ctukey` only)\r\n* *max_percentile*: same, default is 90, custom values supported are in range `[2.0, 98.0]` (ctukey only)\r\n\r\nThe following table describes differences between `"tukey"` and `"ctukey"`:\r\n\r\n| Algorithm | Default quantile range | Supports custom quantile range |\r\n|-----------|----------------------- |--------------------------------|\r\n| `"tukey"` | 25% / 75%              | No                             |\r\n| `"ctukey"`| 10% / 90%              | Yes                            |\r\n\r\n> [!TIP]\r\n> The best way to use this function is to apply it to the results of the [make-series](make-seriesoperator.md) operator.',"A time series with some noise creates outliers. If you would like to replace those outliers (noise) with the average value, use series_outliers() to detect the outliers, and then replace them.\r\n\r\n```\r\nrange x from 1 to 100 step 1 \r\n| extend y=iff(x==20 or x==80, 10*rand()+10+(50-x)/2, 10*rand()+10) // generate a sample series with outliers at x=20 and x=80\r\n| summarize x=make_list(x),series=make_list(y)\r\n| extend series_stats(series), outliers=series_outliers(series)\r\n| mv-expand x to typeof(long), series to typeof(double), outliers to typeof(double)\r\n| project x, series , outliers_removed=iff(outliers > 1.5 or outliers < -1.5, series_stats_series_avg , series ) // replace outliers with the average\r\n| render linechart\r\n``` \r\n\r\n![Series outliers](images/series-outliersfunction/series-outliers.png)","https://docs.microsoft.com/en-us/azure/kusto/query/series-outliersfunction","series-outliersfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"series_pearson_correlation","Calculates the pearson correlation coefficient of two numeric series inputs.","See: [Pearson correlation coefficient](https://en.wikipedia.org/wiki/Pearson_correlation_coefficient).\r\n\r\n## Syntax\r\n\r\n`series_pearson_correlation(`*Series1*`,` *Series2*`)`\r\n\r\n## Arguments\r\n\r\n* *Series1, Series2*: Input numeric arrays for calculating the correlation coefficient. All arguments must be dynamic arrays of the same length. \r\n\r\n## Returns\r\n\r\nThe calculated Pearson correlation coefficient between the two inputs. Any non-numeric element or non-existing element (arrays of different sizes) yields a `null` result.","```\r\nrange s1 from 1 to 5 step 1 | extend s2 = 2*s1 // Perfect correlation\r\n| summarize s1 = make_list(s1), s2 = make_list(s2)\r\n| extend correlation_coefficient = series_pearson_correlation(s1,s2)\r\n```\r\n\r\n|s1|s2|correlation_coefficient|\r\n|---|---|---|\r\n|[1,2,3,4,5]|[2,4,6,8,10]|1|","https://docs.microsoft.com/en-us/azure/kusto/query/series-pearson-correlationfunction","series-pearson-correlationfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"series_periods_detect","Finds the most significant periods that exist in a time series.","Often, a metric measuring an application’s traffic, is characterized by two significant periods: a weekly and a daily. \r\nThe function `series_periods_detect()` detects these two dominant periods in a time series.  \r\nThe function takes as input:\r\n\r\n* A column containing a dynamic array of time series. Typically, the column is the resulting output of [make-series](make-seriesoperator.md) operator.\r\n* Two `real` numbers defining the minimal and maximal period size, the number of bins to search for. For example, for a 1h bin, the size of a daily period would be 24. \r\n* A `long` number defining the total number of periods for the function to search. \r\n\r\nThe function outputs two columns:\r\n\r\n* *periods*: A dynamic array containing the periods that have been found, in units of the bin size, ordered by their scores.\r\n* *scores*: A dynamic array containing values between 0 and 1. Each array measures the significance of a period in its respective position in the *periods* array.\r\n \r\n\r\n## Syntax\r\n\r\n`series_periods_detect(`*x*`,` *min_period*`,` *max_period*`,` *num_periods*`)`\r\n\r\n## Arguments\r\n\r\n* *x*: Dynamic array scalar expression that is an array of numeric values, typically the resulting output of [make-series](make-seriesoperator.md) or [make_list](makelist-aggfunction.md) operators.\r\n* *min_period*: A `real` number specifying the minimal period to search for.\r\n* *max_period*: A `real` number specifying the maximal period to search for.\r\n* *num_periods*: A `long` number specifying the maximum required number of periods. This number will be the length of the output dynamic arrays.\r\n\r\n> [!IMPORTANT]\r\n> * The algorithm can detect periods containing at least 4 points and at most half of the series length. \r\n>\r\n> * Set the *min_period* a little below, and *max_period* a little above, the periods you expect to find in the time series. For example, if you have an hourly aggregated signal, and you look for both daily and weekly periods (24 and 168 hours respectively), you can set *min_period*=0.8\\*24, *max_period*=1.2\\*168, and leave 20% margins around these periods.\r\n>\r\n> * The input time series must be regular. That is, aggregated in constant bins, which is always the case if it has been created using [make-series](make-seriesoperator.md). Otherwise, the output is meaningless.","The following query embeds a snapshot of a month of an application’s traffic, aggregated twice a day. The bin size is 12 hours.\r\n\r\n```\r\nprint y=dynamic([80,139,87,110,68,54,50,51,53,133,86,141,97,156,94,149,95,140,77,61,50,54,47,133,72,152,94,148,105,162,101,160,87,63,53,55,54,151,103,189,108,183,113,175,113,178,90,71,62,62,65,165,109,181,115,182,121,178,114,170])\r\n| project x=range(1, array_length(y), 1), y  \r\n| render linechart \r\n```\r\n\r\n![Series periods](images/series-periods/series-periods.png)\r\nRunning `series_periods_detect()` on this series, results in the weekly period, 14 points long.\r\n\r\n```\r\nprint y=dynamic([80,139,87,110,68,54,50,51,53,133,86,141,97,156,94,149,95,140,77,61,50,54,47,133,72,152,94,148,105,162,101,160,87,63,53,55,54,151,103,189,108,183,113,175,113,178,90,71,62,62,65,165,109,181,115,182,121,178,114,170])\r\n| project x=range(1, array_length(y), 1), y  \r\n| project series_periods_detect(y, 0.0, 50.0, 2)\r\n```\r\n\r\n| series\\_periods\\_detect\\_y\\_periods  | series\\_periods\\_detect\\_y\\_periods\\_scores |\r\n|-------------|-------------------|\r\n| [14.0, 0.0] | [0.84, 0.0]  |\r\n\r\n> [!NOTE] \r\n> The daily period that can be also seen in the chart wasn't found becasue the sampling is too coarse (12h bin size), so a daily period of 2 bins is below the minimum period size of 4 points, required by the algorithm.","https://docs.microsoft.com/en-us/azure/kusto/query/series-periods-detectfunction","series-periods-detectfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"series_periods_validate","Checks whether a time series contains periodic patterns of given lengths.","Often a metric measuring the traffic of an application is characterized by a weekly or daily period. This period can be confirmed by running `series_periods_validate()` that checks for a weekly and daily period.\r\n\r\nThe function takes as input a column that contains a dynamic array of time series (typically the resulting output of [make-series](make-seriesoperator.md) operator), and one or more `real` numbers that define the lengths of the periods to validate.\r\n\r\nThe function outputs two columns:\r\n\r\n* *periods*: A dynamic array that contains the periods to validate (supplied in the input).\r\n* *scores*: A dynamic array that contains a score between 0 and 1. The score shows the significance of a period in its respective position in the *periods* array.\r\n\r\n## Syntax\r\n\r\n`series_periods_validate(`*x*`,` *period1* [ `,` *period2* `,` . . . ] `)`\r\n\r\n## Arguments\r\n\r\n* *x*: Dynamic array scalar expression that is an array of numeric values, typically the resulting output of [make-series](make-seriesoperator.md) or [make_list](makelist-aggfunction.md) operators.\r\n* *period1*, *period2*, and so on: `real` numbers specifying the periods to validate, in units of the bin size. For example, if the series is in 1h bins, a weekly period is 168 bins.\r\n\r\n> [!IMPORTANT]\r\n> * The minimal value for each of the *period* arguments is **4** and the maximal is half of the length of the input series. For a *period* argument outside these bounds, the output score will be **0**.\r\n>\r\n> * The input time series must be regular, that is, aggregated in constant bins, and is always the case if it has been created using [make-series](make-seriesoperator.md). Otherwise, the output is meaningless.\r\n> \r\n> * The function accepts up to 16 periods to validate.","The following query embeds a snapshot of a month of an application’s traffic, aggregated twice a day (the bin size is 12 hours).\r\n\r\n```\r\nprint y=dynamic([80,139,87,110,68,54,50,51,53,133,86,141,97,156,94,149,95,140,77,61,50,54,47,133,72,152,94,148,105,162,101,160,87,63,53,55,54,151,103,189,108,183,113,175,113,178,90,71,62,62,65,165,109,181,115,182,121,178,114,170])\r\n| project x=range(1, array_length(y), 1), y  \r\n| render linechart \r\n```\r\n\r\n![Series periods](images/series-periods/series-periods.png)\r\nIf you run `series_periods_validate()` on this series to validate a weekly period (14 points long) it results in a high score, and with a **0** score when you validate a five-day period (10 points long).\r\n\r\n```\r\nprint y=dynamic([80,139,87,110,68,54,50,51,53,133,86,141,97,156,94,149,95,140,77,61,50,54,47,133,72,152,94,148,105,162,101,160,87,63,53,55,54,151,103,189,108,183,113,175,113,178,90,71,62,62,65,165,109,181,115,182,121,178,114,170])\r\n| project x=range(1, array_length(y), 1), y  \r\n| project series_periods_validate(y, 14.0, 10.0)\r\n```\r\n\r\n| series\\_periods\\_validate\\_y\\_periods  | series\\_periods\\_validate\\_y\\_scores |\r\n|-------------|-------------------|\r\n| [14.0, 10.0] | [0.84,0.0]  |","https://docs.microsoft.com/en-us/azure/kusto/query/series-periods-validatefunction","series-periods-validatefunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"series_seasonal","Calculates the seasonal component of a series, according to the detected or given seasonal period.","## Syntax\r\n\r\n`series_seasonal(`*series* `[,` *period*`])`\r\n\r\n## Arguments\r\n\r\n* *series*: Input numeric dynamic array\r\n* *period* (optional): Integer number of bins in each seasonal period, possible values:\r\n    *  -1 (default): Autodetects the period by using [series_periods_detect()](series-periods-detectfunction.md) with a threshold of *0.7*. Returns zeroes if seasonality isn't detected\r\n    * Positive integer: Used as the period for the seasonal component\r\n    * Any other value: Ignores seasonality and returns a series of zeroes\r\n\r\n## Returns\r\n\r\nDynamic array of the same length as the *series* input that contains the calculated seasonal component of the series. The seasonal component is calculated as the *median* of all the values that correspond to the location of the bin, across the periods.","### Auto detect the period\r\n\r\nIn the following example, the series' period is automatically detected. The first series' period is detected to be six bins and the second five bins. The third series' period is too short to be detected and returns a series of zeroes. \r\nSee the next example on [how to force the period](#force-a-period).\r\n\r\n```\r\nprint s=dynamic([2,5,3,4,3,2,1,2,3,4,3,2,1,2,3,4,3,2,1,2,3,4,3,2,1])\r\n| union (print s=dynamic([8,12,14,12,10,10,12,14,12,10,10,12,14,12,10,10,12,14,12,10]))\r\n| union (print s=dynamic([1,3,5,2,4,6,1,3,5,2,4,6]))\r\n| extend s_seasonal = series_seasonal(s)\r\n```\r\n\r\n|s|s_seasonal|\r\n|---|---|\r\n|[2,5,3,4,3,2,1,2,3,4,3,2,1,2,3,4,3,2,1,2,3,4,3,2,1]|[1.0,2.0,3.0,4.0,3.0,2.0,1.0,2.0,3.0,4.0,3.0,2.0,1.0,2.0,3.0,4.0,3.0,2.0,1.0,2.0,3.0,4.0,3.0,2.0,1.0]|\r\n|[8,12,14,12,10,10,12,14,12,10,10,12,14,12,10,10,12,14,12,10]|[10.0,12.0,14.0,12.0,10.0,10.0,12.0,14.0,12.0,10.0,10.0,12.0,14.0,12.0,10.0,10.0,12.0,14.0,12.0,10.0]|\r\n|[1,3,5,2,4,6,1,3,5,2,4,6]|[0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0]|\r\n\r\n### Force a period\r\n\r\nIn this example, the series' period is too short to be detected by [series_periods_detect()](series-periods-detectfunction.md), so we explicitly force the period to get the seasonal pattern.\r\n\r\n```\r\nprint s=dynamic([1,3,5,1,3,5,2,4,6]) \r\n| union (print s=dynamic([1,3,5,2,4,6,1,3,5,2,4,6]))\r\n| extend s_seasonal = series_seasonal(s,3)\r\n```\r\n\r\n|s|s_seasonal|\r\n|---|---|\r\n|[1,3,5,1,3,5,2,4,6]|[1.0,3.0,5.0,1.0,3.0,5.0,1.0,3.0,5.0]|\r\n|[1,3,5,2,4,6,1,3,5,2,4,6]|[1.5,3.5,5.5,1.5,3.5,5.5,1.5,3.5,5.5,1.5,3.5,5.5]|\r\n\r\n## Next steps\r\n\r\n* [series_periods_detect()](series-periods-detectfunction.md)\r\n* [series_periods_validate()](series-periods-validatefunction.md)","https://docs.microsoft.com/en-us/azure/kusto/query/series-seasonalfunction","series-seasonalfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"series_stats","`series_stats()` returns statistics for a series in multiple columns.","The `series_stats()` function takes a column containing dynamic numerical array as input and calculates the following columns:\r\n\r\n* `min`: minimum value in the input array\r\n* `min_idx`: first position of the minimum value in the input array\r\n* `max`: maximum value in the input array\r\n* `max_idx`: first position of the maximum value in the input array\r\n* `avg`: average value of the input array\r\n* `variance`: sample variance of input array\r\n* `stdev`: sample standard deviation of the input array\r\n\r\n> [!NOTE] \r\n> This function returns multiple columns so it can't be used as an argument for another function.\r\n\r\n## Syntax\r\n\r\nproject `series_stats(`*x* `[,`*ignore_nonfinite*`])` or extend `series_stats(`*x*`)` \r\nReturns all above-mentioned columns with the following names: series_stats_x_min, series_stats_x_min_idx and etc.\r\n\r\nproject (m, mi)=`series_stats(`*x*`)` or extend (m, mi)=`series_stats(`*x*`)`\r\nReturns the following columns: m (min) and mi (min_idx).\r\n\r\n## Arguments\r\n\r\n* *x*: Dynamic array cell, which is an array of numeric values. \r\n* *ignore_nonfinite*: Boolean (optional, default: `false`) flag that specifies whether to calculate the statistics while ignoring non-finite values (*null*, *NaN*, *inf*, etc.). If set to `false`, the returned values would be `null` if non-finite values are present in the array.","```\r\nprint x=dynamic([23,46,23,87,4,8,3,75,2,56,13,75,32,16,29]) \r\n| project series_stats(x)\r\n\r\n```\r\n\r\n|series_stats_x_min|series_stats_x_min_idx|series_stats_x_max|series_stats_x_max_idx|series_stats_x_avg|series_stats_x_stdev|series_stats_x_variance|\r\n|---|---|---|---|---|---|---|\r\n|2|8|87|3|32.8|28.5036338535483|812.457142857143|","https://docs.microsoft.com/en-us/azure/kusto/query/series-statsfunction","series-statsfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"series_stats_dynamic","Returns statistics for a series in a dynamic object.","The `series_stats_dynamic()` function takes a column containing dynamic numerical array as input and generates a dynamic value with the following content:\r\n\r\n* `min`: minimum value in the input array\r\n* `min_idx`: first position of the minimum value in the input array\r\n* `max`: maximum value in the input array\r\n* `max_idx`: first position of the maximum value in the input array\r\n* `avg`: average value of the input array\r\n* `variance`: sample variance of input array\r\n* `stdev`: sample standard deviation of the input array\r\n\r\n## Syntax\r\n\r\n`series_stats_dynamic(`*x* `[,`*ignore_nonfinite*`])`\r\n\r\n## Arguments\r\n\r\n* *x*: Dynamic array cell which is an array of numeric values. \r\n* *ignore_nonfinite*: Boolean (optional, default: `false`) flag that specifies whether to calculate the statistics while ignoring non-finite values (*null*, *NaN*, *inf*, etc.). If set to `false` the returned result is `null` if non-finite values are present in the array.",'```\r\nprint x=dynamic([23,46,23,87,4,8,3,75,2,56,13,75,32,16,29]) \r\n| project stats=series_stats_dynamic(x)\r\n```\r\n\r\n|stats\r\n|---|\r\n|{"min": 2.0, "min_idx": 8, "max": 87.0, "max_idx": 3, "avg": 32.8, "stdev": 28.503633853548269, "variance": 812.45714285714291 }',"https://docs.microsoft.com/en-us/azure/kusto/query/series-stats-dynamicfunction","series-stats-dynamicfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"series_subtract","Calculates the element-wise subtraction of two numeric series inputs.","## Syntax\r\n\r\n`series_subtract(`*series1*`,` *series2*`)`\r\n\r\n## Arguments\r\n\r\n* *series1, series2*: Input numeric arrays, the second to be element-wise subtracted from the first into a dynamic array result. All arguments must be dynamic arrays. \r\n\r\n## Returns\r\n\r\nDynamic array of calculated element-wise subtract operation between the two inputs. Any non-numeric element or non-existing element (arrays of different sizes) yields a `null` element value.","```\r\nrange x from 1 to 3 step 1\r\n| extend y = x * 2\r\n| extend z = y * 2\r\n| project s1 = pack_array(x,y,z), s2 = pack_array(z, y, x)\r\n| extend s1_subtract_s2 = series_subtract(s1, s2)\r\n```\r\n\r\n|s1|s2|s1_subtract_s2|\r\n|---|---|---|\r\n|[1,2,4]|[4,2,1]|[-3,0,3]|\r\n|[2,4,8]|[8,4,2]|[-6,0,6]|\r\n|[3,6,12]|[12,6,3]|[-9,0,9]|","https://docs.microsoft.com/en-us/azure/kusto/query/series-subtractfunction","series-subtractfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"set_difference","Returns a `dynamic` (JSON) array of the set of all distinct values that are in the first array but aren't in other arrays - (((arr1 \\ arr2) \\ arr3) \\ ...).","## Syntax\r\n\r\n`set_difference(`*arr1*`, `*arr2*`[`,` *arr3*, ...])`\r\n\r\n## Arguments\r\n\r\n* *arr1...arrN*: Input arrays to create a difference set (at least two arrays). All arguments must be dynamic arrays (see [pack_array](packarrayfunction.md)). \r\n\r\n## Returns\r\n\r\nReturns a dynamic array of the set of all distinct values that are in arr1 but aren't in other arrays. See [`set_union()`](setunionfunction.md) and [`set_intersect()`](setintersectfunction.md).","```\r\nrange x from 1 to 3 step 1\r\n| extend y = x * 2\r\n| extend z = y * 2\r\n| extend w = z * 2\r\n| extend a1 = pack_array(x,y,x,z), a2 = pack_array(x, y), a3 = pack_array(x,y,w)\r\n| project set_difference(a1, a2, a3)\r\n```\r\n\r\n|Column1|\r\n|---|\r\n|[4]|\r\n|[8]|\r\n|[12]|\r\n\r\n```\r\nprint arr = set_difference(dynamic([1,2,3]), dynamic([1,2,3]))\r\n```\r\n\r\n|arr|\r\n|---|\r\n|[]|","https://docs.microsoft.com/en-us/azure/kusto/query/setdifferencefunction","setdifferencefunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"set_has_element","Determines whether the specified set contains the specified element.","## Syntax\r\n\r\n`set_has_element(`*array*,*value*`)`\r\n\r\n## Arguments\r\n\r\n* *array*: Input array to search.\r\n* *value*: Value to search for. The value should be of type `long`, `integer`, `double`, `datetime`, `timespan`, `decimal`, `string`, or `guid`.\r\n\r\n## Returns\r\n\r\nTrue or false depending on if the value exists in the array.",'```\r\nprint arr=dynamic(["this", "is", "an", "example"]) \r\n| project Result=set_has_element(arr, "example")\r\n```\r\n\r\n|Result|\r\n|---|\r\n|1|\r\n\r\n## See also\r\n\r\nUse [`array_index_of(arr, value)`](arrayindexoffunction.md) to find the position at which the value exists in the array. Both functions are equally performant.',"https://docs.microsoft.com/en-us/azure/kusto/query/sethaselementfunction","sethaselementfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"set_intersect","Returns a `dynamic` array of the set of all distinct values that are in all arrays - (arr1 ∩ arr2 ∩ ...).","## Syntax\r\n\r\n`set_intersect(`*arr1*`, `*arr2*`[`,` *arr3*, ...])`\r\n\r\n## Arguments\r\n\r\n* *arr1...arrN*: Input arrays to create an intersect set (at least two arrays). All arguments must be dynamic arrays. For more information, see [pack_array](packarrayfunction.md). \r\n\r\n## Returns\r\n\r\nReturns a dynamic array of the set of all distinct values that are in all arrays. See [`set_union()`](setunionfunction.md) and [`set_difference()`](setdifferencefunction.md).","```\r\nrange x from 1 to 3 step 1\r\n| extend y = x * 2\r\n| extend z = y * 2\r\n| extend w = z * 2\r\n| extend a1 = pack_array(x,y,x,z), a2 = pack_array(x, y), a3 = pack_array(w,x)\r\n| project set_intersect(a1, a2, a3)\r\n```\r\n\r\n|Column1|\r\n|---|\r\n|[1]|\r\n|[2]|\r\n|[3]|\r\n\r\n```\r\nprint arr = set_intersect(dynamic([1, 2, 3]), dynamic([4,5]))\r\n```\r\n\r\n|arr|\r\n|---|\r\n|[]|","https://docs.microsoft.com/en-us/azure/kusto/query/setintersectfunction","setintersectfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"set_union","Returns a `dynamic` array of the set of all distinct values that are in any of arrays - (arr1 ∪ arr2 ∪ ...).","## Syntax\r\n\r\n`set_union(`*arr1*`, `*arr2*`[`,` *arr3*, ...]``)`\r\n\r\n## Arguments\r\n\r\n* *arr1...arrN*: Input arrays to create a union set (at least two arrays). All arguments must be dynamic arrays (see [pack_array](packarrayfunction.md)). \r\n\r\n## Returns\r\n\r\nReturns a dynamic array of the set of all distinct values that are in any of arrays. See [`set_intersect()`](setintersectfunction.md)  and [`set_difference()`](setdifferencefunction.md).","```\r\nrange x from 1 to 3 step 1\r\n| extend y = x * 2\r\n| extend z = y * 2\r\n| extend w = z * 2\r\n| extend a1 = pack_array(x,y,x,z), a2 = pack_array(x, y), a3 = pack_array(w)\r\n| project set_union(a1, a2, a3)\r\n```\r\n\r\n|Column1|\r\n|---|\r\n|[1,2,4,8]|\r\n|[2,4,8,16]|\r\n|[3,6,12,24]|","https://docs.microsoft.com/en-us/azure/kusto/query/setunionfunction","setunionfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"sign","Sign of a numeric expression","## Syntax\r\n\r\n`sign(`*x*`)`\r\n\r\n## Arguments\r\n\r\n* *x*: A real number.\r\n\r\n## Returns\r\n\r\n* The positive (+1), zero (0), or negative (-1) sign of the specified expression.","```\r\nprint s1 = sign(-42), s2 = sign(0), s3 = sign(11.2)\r\n\r\n```\r\n\r\n|s1|s2|s3|\r\n|---|---|---|\r\n|-1|0|1|","https://docs.microsoft.com/en-us/azure/kusto/query/signfunction","signfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"sin","Returns the sine function.","## Syntax\r\n\r\n`sin(`*x*`)`\r\n\r\n## Arguments\r\n\r\n* *x*: A real number.\r\n\r\n## Returns\r\n\r\n* The result of `sin(x)`","","https://docs.microsoft.com/en-us/azure/kusto/query/sinfunction","")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.OperatorToken,"sort","Sort the rows of the input table into order by one or more columns.","```\r\nT | sort by strlen(country) asc, price desc\r\n```\r\n\r\n**Alias**\r\n\r\n`order`\r\n\r\n## Syntax\r\n\r\n*T* `| sort by` *expression* [`asc` | `desc`] [`nulls first` | `nulls last`] [`,` ...]\r\n\r\n## Arguments\r\n\r\n* *T*: The table input to sort.\r\n* *expression*: A scalar expression by which to sort. The type of the values must be numeric, date, time or string.\r\n* `asc` Sort by into ascending order, low to high. The default is `desc`, descending high to low.\r\n* `nulls first` (the default for `asc` order) will place the null values at the beginning and `nulls last` (the default for `desc` order) will place the null values at the end.",'```\r\nTraces\r\n| where ActivityId == "479671d99b7b"\r\n| sort by Timestamp asc nulls first\r\n```\r\n\r\nAll rows in table Traces that have a specific `ActivityId`, sorted by their timestamp. If `Timestamp` column contains null values, those will appear at the first lines of the result.\r\n\r\nIn order to exclude null values from the result add a filter before the call to sort:\r\n\r\n```\r\nTraces\r\n| where ActivityId == "479671d99b7b" and isnotnull(Timestamp)\r\n| sort by Timestamp asc\r\n```',"https://docs.microsoft.com/en-us/azure/kusto/query/sortoperator","sortoperator.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"split","Splits a given string according to a given delimiter and returns a string array with the contained substrings.",'Optionally, a specific substring can be returned if exists.\r\n\r\n```\r\nsplit("aaa_bbb_ccc", "_") == ["aaa","bbb","ccc"]\r\n```\r\n\r\n## Syntax\r\n\r\n`split(`*source*`,` *delimiter* [`,` *requestedIndex*]`)`\r\n\r\n## Arguments\r\n\r\n* *source*: The source string that will be split according to the given delimiter.\r\n* *delimiter*: The delimiter that will be used in order to split the source string.\r\n* *requestedIndex*: An optional zero-based index `int`. If provided, the returned string array will contain the requested substring if exists. \r\n\r\n## Returns\r\n\r\nA string array that contains the substrings of the given source string that are delimited by the given delimiter.','```\r\nprint\r\n    split("aa_bb", "_"),           // ["aa","bb"]\r\n    split("aaa_bbb_ccc", "_", 1),  // ["bbb"]\r\n    split("", "_"),                // [""]\r\n    split("a__b", "_"),            // ["a","","b"]\r\n    split("aabbcc", "bb")          // ["aa","cc"]\r\n```',"https://docs.microsoft.com/en-us/azure/kusto/query/splitfunction","splitfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"sqrt","Returns the square root function.","## Syntax\r\n\r\n`sqrt(`*x*`)`\r\n\r\n## Arguments\r\n\r\n* *x*: A real number >= 0.\r\n\r\n## Returns\r\n\r\n* A positive number such that `sqrt(x) * sqrt(x) == x`\r\n* `null` if the argument is negative or cannot be converted to a `real` value.","","https://docs.microsoft.com/en-us/azure/kusto/query/sqrtfunction","")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"startofday","Returns the start of the day containing the date, shifted by an offset, if provided.","## Syntax\r\n\r\n`startofday(`*date* [`,`*offset*]`)`\r\n\r\n## Arguments\r\n\r\n* `date`: The input date.\r\n* `offset`: An optional number of offset days from the input date (integer, default - 0). \r\n\r\n## Returns\r\n\r\nA datetime representing the start of the day for the given *date* value, with the offset, if specified.","```\r\n  range offset from -1 to 1 step 1\r\n | project dayStart = startofday(datetime(2017-01-01 10:10:17), offset) \r\n```\r\n\r\n|dayStart|\r\n|---|\r\n|2016-12-31 00:00:00.0000000|\r\n|2017-01-01 00:00:00.0000000|\r\n|2017-01-02 00:00:00.0000000|","https://docs.microsoft.com/en-us/azure/kusto/query/startofdayfunction","startofdayfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"startofmonth","Returns the start of the month containing the date, shifted by an offset, if provided.","## Syntax\r\n\r\n`startofmonth(`*date* [`,`*offset*]`)`\r\n\r\n## Arguments\r\n\r\n* `date`: The input date.\r\n* `offset`: An optional number of offset months from the input date (integer, default - 0).\r\n\r\n## Returns\r\n\r\nA datetime representing the start of the month for the given *date* value, with the offset, if specified.","```\r\n  range offset from -1 to 1 step 1\r\n | project monthStart = startofmonth(datetime(2017-01-01 10:10:17), offset) \r\n```\r\n\r\n|monthStart|\r\n|---|\r\n|2016-12-01 00:00:00.0000000|\r\n|2017-01-01 00:00:00.0000000|\r\n|2017-02-01 00:00:00.0000000|","https://docs.microsoft.com/en-us/azure/kusto/query/startofmonthfunction","startofmonthfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"startofweek","Returns the start of the week containing the date, shifted by an offset, if provided.","Start of the week is considered to be a Sunday.\r\n\r\n## Syntax\r\n\r\n`startofweek(`*date* [`,`*offset*]`)`\r\n\r\n## Arguments\r\n\r\n* `date`: The input date.\r\n* `offset`: An optional number of offset weeks from the input date (integer, default - 0).\r\n\r\n## Returns\r\n\r\nA datetime representing the start of the week for the given *date* value, with the offset, if specified.","```\r\n  range offset from -1 to 1 step 1\r\n | project weekStart = startofweek(datetime(2017-01-01 10:10:17), offset) \r\n```\r\n\r\n|weekStart|\r\n|---|\r\n|2016-12-25 00:00:00.0000000|\r\n|2017-01-01 00:00:00.0000000|\r\n|2017-01-08 00:00:00.0000000|","https://docs.microsoft.com/en-us/azure/kusto/query/startofweekfunction","startofweekfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"startofyear","Returns the start of the year containing the date, shifted by an offset, if provided.","## Syntax\r\n\r\n`startofyear(`*date* [`,`*offset*]`)`\r\n\r\n## Arguments\r\n\r\n* `date`: The input date.\r\n* `offset`: An optional number of offset years from the input date (integer, default - 0). \r\n\r\n## Returns\r\n\r\nA datetime representing the start of the year for the given *date* value, with the offset, if specified.","```\r\n  range offset from -1 to 1 step 1\r\n | project yearStart = startofyear(datetime(2017-01-01 10:10:17), offset) \r\n```\r\n\r\n|yearStart|\r\n|---|\r\n|2016-01-01 00:00:00.0000000|\r\n|2017-01-01 00:00:00.0000000|\r\n|2018-01-01 00:00:00.0000000|","https://docs.microsoft.com/en-us/azure/kusto/query/startofyearfunction","startofyearfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"stdev","Calculates the standard deviation of *Expr* across the group, considering the group as a [sample](https://en.wikipedia.org/wiki/Sample_%28statistics%29).","* Used formula:\r\n\r\n![Stdev sample](images/stdev-aggfunction/stdev-sample.png)\r\n\r\n* Can be used only in context of aggregation inside [summarize](summarizeoperator.md)\r\n\r\n## Syntax\r\n\r\nsummarize `stdev(`*Expr*`)`\r\n\r\n## Arguments\r\n\r\n* *Expr*: Expression that will be used for aggregation calculation. \r\n\r\n## Returns\r\n\r\nThe standard deviation value of *Expr* across the group.","```\r\nrange x from 1 to 5 step 1\r\n| summarize make_list(x), stdev(x)\r\n\r\n```\r\n\r\n|list_x|stdev_x|\r\n|---|---|\r\n|[ 1, 2, 3, 4, 5]|1.58113883008419|","https://docs.microsoft.com/en-us/azure/kusto/query/stdev-aggfunction","stdev-aggfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"stdevif","Calculates the [stdev](stdev-aggfunction.md) of *Expr* across the group for which *Predicate* evaluates to `true`.","* Can be used only in context of aggregation inside [summarize](summarizeoperator.md)\r\n\r\n## Syntax\r\n\r\nsummarize `stdevif(`*Expr*`, `*Predicate*`)`\r\n\r\n## Arguments\r\n\r\n* *Expr*: Expression that will be used for aggregation calculation. \r\n* *Predicate*:  predicate that if true, the *Expr* calculated value will be added to the standard deviation.\r\n\r\n## Returns\r\n\r\nThe standard deviation value of *Expr* across the group where *Predicate* evaluates to `true`.","```\r\nrange x from 1 to 100 step 1\r\n| summarize stdevif(x, x%2 == 0)\r\n\r\n```\r\n\r\n|stdevif_x|\r\n|---|\r\n|29.1547594742265|","https://docs.microsoft.com/en-us/azure/kusto/query/stdevif-aggfunction","stdevif-aggfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"stdevp","Calculates the standard deviation of *Expr* across the group, considering the group as a [population](https://en.wikipedia.org/wiki/Statistical_population).","* Used formula:\r\n\r\n![Stdev population](images/stdevp-aggfunction/stdev-population.png)\r\n\r\n* Can be used only in context of aggregation inside [summarize](summarizeoperator.md)\r\n\r\n## Syntax\r\n\r\nsummarize `stdevp(`*Expr*`)`\r\n\r\n## Arguments\r\n\r\n* *Expr*: Expression that will be used for aggregation calculation. \r\n\r\n## Returns\r\n\r\nThe standard deviation value of *Expr* across the group.","```\r\nrange x from 1 to 5 step 1\r\n| summarize make_list(x), stdevp(x)\r\n\r\n```\r\n\r\n|list_x|stdevp_x|\r\n|---|---|\r\n|[ 1, 2, 3, 4, 5]|1.4142135623731|","https://docs.microsoft.com/en-us/azure/kusto/query/stdevp-aggfunction","stdevp-aggfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"strcat","Concatenates between 1 and 64 arguments.","* If the arguments aren't of string type, they'll be forcibly converted to string.\r\n\r\n## Syntax\r\n\r\n`strcat(`*argument1*, *argument2*[, *argumentN*]`)`\r\n\r\n## Arguments\r\n\r\n* *argument1* ... *argumentN*: Expressions to be concatenated.\r\n\r\n## Returns\r\n\r\nArguments, concatenated to a single string.",'```\r\nprint str = strcat("hello", " ", "world")\r\n```\r\n\r\n|str|\r\n|---|\r\n|hello world|',"https://docs.microsoft.com/en-us/azure/kusto/query/strcatfunction","strcatfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"strcat_array","Creates a concatenated string of array values using specified delimiter.","## Syntax\r\n\r\n`strcat_array(`*array*, *delimiter*`)`\r\n\r\n## Arguments\r\n\r\n* *array*: A `dynamic` value representing an array of values to be concatenated.\r\n* *delimeter*: A `string` value that will be used to concatenate the values in *array*\r\n\r\n## Returns\r\n\r\nArray values, concatenated to a single string.",'```\r\nprint str = strcat_array(dynamic([1, 2, 3]), "->")\r\n```\r\n\r\n|str|\r\n|---|\r\n|1->2->3|',"https://docs.microsoft.com/en-us/azure/kusto/query/strcat-arrayfunction","strcat-arrayfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"strcat_delim","Concatenates between 2 and 64 arguments, with delimiter, provided as first argument.","* If arguments aren't of string type, they'll be forcibly converted to string.\r\n\r\n## Syntax\r\n\r\n`strcat_delim(`*delimiter*, *argument1*, *argument2*[ , *argumentN*]`)`\r\n\r\n## Arguments\r\n\r\n* *delimiter*: string expression, which will be used as separator.\r\n* *argument1* ... *argumentN*: Expressions to be concatenated.\r\n\r\n## Returns\r\n\r\nArguments, concatenated to a single string with *delimiter*.","```\r\nprint st = strcat_delim('-', 1, '2', 'A', 1s)\r\n\r\n```\r\n\r\n|st|\r\n|---|\r\n|1-2-A-00:00:01|","https://docs.microsoft.com/en-us/azure/kusto/query/strcat-delimfunction","strcat-delimfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"strcmp","Compares two strings.","The function starts comparing the first character of each string. If they are equal to each other, it continues with the following pairs until the characters differ or until the end of shorter string is reached.\r\n\r\n## Syntax\r\n\r\n`strcmp(`*string1*`,` *string2*`)` \r\n\r\n## Arguments\r\n\r\n* *string1*: first input string for comparison. \r\n* *string2*: second input string for comparison.\r\n\r\n## Returns\r\n\r\nReturns an integral value indicating the relationship between the strings:\r\n\r\n* *<0* - the first character that does not match has a lower value in string1 than in string2\r\n* *0* - the contents of both strings are equal\r\n* *>0* - the first character that does not match has a greater value in string1 than in string2",'```\r\ndatatable(string1:string, string2:string)\r\n["ABC","ABC",\r\n"abc","ABC",\r\n"ABC","abc",\r\n"abcde","abc"]\r\n| extend result = strcmp(string1,string2)\r\n```\r\n\r\n|string1|string2|result|\r\n|---|---|---|\r\n|ABC|ABC|0|\r\n|abc|ABC|1|\r\n|ABC|abc|-1|\r\n|abcde|abc|1|',"https://docs.microsoft.com/en-us/azure/kusto/query/strcmpfunction","strcmpfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"string_size","Returns the size, in bytes, of the input string.","## Syntax\r\n\r\n`string_size(`*source*`)`\r\n\r\n## Arguments\r\n\r\n* *source*: The source string that will be measured for string size.\r\n\r\n## Returns\r\n\r\nReturns the length, in bytes, of the input string.",'```\r\nprint size = string_size("hello")\r\n```\r\n\r\n|size|\r\n|---|\r\n|5|\r\n\r\n```\r\nprint size = string_size("⒦⒰⒮⒯⒪")\r\n```\r\n\r\n|size|\r\n|---|\r\n|15|',"https://docs.microsoft.com/en-us/azure/kusto/query/stringsizefunction","stringsizefunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"strlen","Returns the length, in characters, of the input string.","## Syntax\r\n\r\n`strlen(`*source*`)`\r\n\r\n## Arguments\r\n\r\n* *source*: The source string that will be measured for string length.\r\n\r\n## Returns\r\n\r\nReturns the length, in characters, of the input string.\r\n\r\n**Notes**\r\n\r\nEach Unicode character in the string is equal to `1`, including surrogates.\r\n(e.g: Chinese characters will be counted once despite the fact that it requires more than one value in UTF-8 encoding).",'```\r\nprint length = strlen("hello")\r\n```\r\n\r\n|length|\r\n|---|\r\n|5|\r\n\r\n```\r\nprint length = strlen("⒦⒰⒮⒯⒪")\r\n```\r\n\r\n|length|\r\n|---|\r\n|5|',"https://docs.microsoft.com/en-us/azure/kusto/query/strlenfunction","strlenfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"strrep","Repeats given [string](./scalar-data-types/string.md) provided amount of times.","* In case if first or third argument is not of a string type, it will be forcibly converted to string.\r\n\r\n## Syntax\r\n\r\n`strrep(`*value*,*multiplier*,[*delimiter*]`)`\r\n\r\n## Arguments\r\n\r\n* *value*: input expression\r\n* *multiplier*: positive integer value (from 1 to 1024)\r\n* *delimiter*: an optional string expression (default: empty string)\r\n\r\n## Returns\r\n\r\nValue repeated for a specified number of times, concatenated with *delimiter*.\r\n\r\nIn case if *multiplier* is more than maximal allowed value (1024), input string will be repeated 1024 times.","```\r\nprint from_str = strrep('ABC', 2), from_int = strrep(123,3,'.'), from_time = strrep(3s,2,' ')\r\n```\r\n\r\n|from_str|from_int|from_time|\r\n|---|---|---|\r\n|ABCABC|123.123.123|00:00:03 00:00:03|","https://docs.microsoft.com/en-us/azure/kusto/query/strrepfunction","strrepfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"substring","Extracts a substring from a source string starting from some index to the end of the string.",'Optionally, the length of the requested substring can be specified.\r\n\r\n```\r\nsubstring("abcdefg", 1, 2) == "bc"\r\n```\r\n\r\n## Syntax\r\n\r\n`substring(`*source*`,` *startingIndex* [`,` *length*]`)`\r\n\r\n## Arguments\r\n\r\n* *source*: The source string that the substring will be taken from.\r\n* *startingIndex*: The zero-based starting character position of the requested substring.\r\n* *length*: An optional parameter that can be used to specify the requested number of characters in the substring. \r\n\r\n**Notes**\r\n\r\n*startingIndex* can be a negative number, in which case the substring will be retrieved from the end of the source string.\r\n\r\n## Returns\r\n\r\nA substring from the given string. The substring starts at startingIndex (zero-based) character position and continues to the end of the string or length characters if specified.','```\r\nsubstring("123456", 1)        // 23456\r\nsubstring("123456", 2, 2)     // 34\r\nsubstring("ABCD", 0, 2)       // AB\r\nsubstring("123456", -2, 2)    // 56\r\n```',"https://docs.microsoft.com/en-us/azure/kusto/query/substringfunction","substringfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"sum","Calculates the sum of *Expr* across the group.","* Can be used only in context of aggregation inside [summarize](summarizeoperator.md)\r\n\r\n## Syntax\r\n\r\nsummarize `sum(`*Expr*`)`\r\n\r\n## Arguments\r\n\r\n* *Expr*: Expression that will be used for aggregation calculation. \r\n\r\n## Returns\r\n\r\nThe sum value of *Expr* across the group.","","https://docs.microsoft.com/en-us/azure/kusto/query/sum-aggfunction","")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"sumif","Returns a sum of *Expr* for which *Predicate* evaluates to `true`.","* Can be used only in context of aggregation inside [summarize](summarizeoperator.md)\r\n\r\nYou can also use the [sum()](sum-aggfunction.md) function, which sums rows without predicate expression.\r\n\r\n## Syntax\r\n\r\nsummarize `sumif(`*Expr*`,`*Predicate*`)`\r\n\r\n## Arguments\r\n\r\n* *Expr*: expression for aggregation calculation. \r\n* *Predicate*: predicate that, if true, the *Expr*'s calculated value will be added to the sum. \r\n\r\n## Returns\r\n\r\nThe sum value of *Expr* for which *Predicate* evaluates to `true`.",'```\r\nlet T = datatable(name:string, day_of_birth:long)\r\n[\r\n   "John", 9,\r\n   "Paul", 18,\r\n   "George", 25,\r\n   "Ringo", 7\r\n];\r\nT\r\n| summarize sumif(day_of_birth, strlen(name) > 4)\r\n```\r\n\r\n|sumif_day_of_birth|\r\n|----|\r\n|32|',"https://docs.microsoft.com/en-us/azure/kusto/query/sumif-aggfunction","sumif-aggfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.OperatorToken,"summarize","Produces a table that aggregates the content of the input table.","```\r\nSales | summarize NumTransactions=count(), Total=sum(UnitPrice * NumUnits) by Fruit, StartOfMonth=startofmonth(SellDateTime)\r\n```\r\n\r\nReturns a table with how many sell transactions and the total amount per fruit and sell month.\r\nThe output columns show the count of transactions, transaction worth, fruit, and the datetime of the beginning of the month\r\nin which the transaction was recorded.\r\n\r\n```\r\nT | summarize count() by price_range=bin(price, 10.0)\r\n```\r\n\r\nA table that shows how many items have prices in each interval  [0,10.0], [10.0,20.0], and so on. This example has a column for the count and one for the price range. All other input columns are ignored.\r\n\r\n## Syntax\r\n\r\n*T* `| summarize`\r\n      [[*Column* `=`] *Aggregation* [`,` ...]]\r\n    [`by`\r\n      [*Column* `=`] *GroupExpression* [`,` ...]]\r\n\r\n## Arguments\r\n\r\n* *Column:* Optional name for a result column. Defaults to a name derived from the expression.\r\n* *Aggregation:* A call to an [aggregation function](summarizeoperator.md#list-of-aggregation-functions) such as `count()` or `avg()`, with column names as arguments. See the [list of aggregation functions](summarizeoperator.md#list-of-aggregation-functions).\r\n* *GroupExpression:* A scalar expression that can reference the input data.\r\n  The output will have as many records as there are distinct values of all the\r\n  group expressions.\r\n\r\n> [!NOTE]\r\n> When the input table is empty, the output depends on whether *GroupExpression*\r\n> is used:\r\n>\r\n> * If *GroupExpression* is not provided, the output will be a single (empty) row.\r\n> * If *GroupExpression* is provided, the output will have no rows.\r\n\r\n## Returns\r\n\r\nThe input rows are arranged into groups having the same values of the `by` expressions. Then the specified aggregation functions are computed over each group, producing a row for each group. The result contains the `by` columns and also at least one column for each computed aggregate. (Some aggregation functions return multiple columns.)\r\n\r\nThe result has as many rows as there are distinct combinations of `by` values\r\n(which may be zero). If there are no group keys provided, the result has a single\r\nrecord.\r\n\r\nTo summarize over ranges of numeric values, use `bin()` to reduce ranges to discrete values.\r\n\r\n> [!NOTE]\r\n> * Although you can provide arbitrary expressions for both the aggregation and grouping expressions, it's more efficient to use simple column names, or apply `bin()` to a numeric column.\r\n> * The automatic hourly bins for datetime columns is no longer supported. Use explicit binning instead. For example, `summarize by bin(timestamp, 1h)`.\r\n\r\n## List of aggregation functions\r\n\r\n|Function|Description|\r\n|--------|-----------|\r\n|[any()](any-aggfunction.md)|Returns a random non-empty value for the group|\r\n|[anyif()](anyif-aggfunction.md)|Returns a random non-empty value for the group (with predicate)|\r\n|[arg_max()](arg-max-aggfunction.md)|Returns one or more expressions when the argument is maximized|\r\n|[arg_min()](arg-min-aggfunction.md)|Returns one or more expressions when the argument is minimized|\r\n|[avg()](avg-aggfunction.md)|Returns an average value across the group|\r\n|[avgif()](avgif-aggfunction.md)|Returns an average value across the group (with predicate)|\r\n|[binary_all_and](binary-all-and-aggfunction.md)|Returns aggregated value using the binary `AND` of the group|\r\n|[binary_all_or](binary-all-or-aggfunction.md)|Returns aggregated value using the binary `OR` of the group|\r\n|[binary_all_xor](binary-all-xor-aggfunction.md)|Returns aggregated value using the binary `XOR` of the group|\r\n|[buildschema()](buildschema-aggfunction.md)|Returns the minimal schema that admits all values of the `dynamic` input|\r\n|[count()](count-aggfunction.md)|Returns a count of the group|\r\n|[countif()](countif-aggfunction.md)|Returns a count with the predicate of the group|\r\n|[dcount()](dcount-aggfunction.md)|Returns an approximate distinct count of the group elements|\r\n|[dcountif()](dcountif-aggfunction.md)|Returns an approximate distinct count of the group elements (with predicate)|\r\n|[make_bag()](make-bag-aggfunction.md)|Returns a property bag of dynamic values within the group|\r\n|[make_bag_if()](make-bag-if-aggfunction.md)|Returns a property bag of dynamic values within the group (with predicate)|\r\n|[make_list()](makelist-aggfunction.md)|Returns a list of all the values within the group|\r\n|[make_list_if()](makelistif-aggfunction.md)|Returns a list of all the values within the group (with predicate)|\r\n|[make_list_with_nulls()](make-list-with-nulls-aggfunction.md)|Returns a list of all the values within the group, including null values|\r\n|[make_set()](makeset-aggfunction.md)|Returns a set of distinct values within the group|\r\n|[make_set_if()](makesetif-aggfunction.md)|Returns a set of distinct values within the group (with predicate)|\r\n|[max()](max-aggfunction.md)|Returns the maximum value across the group|\r\n|[maxif()](maxif-aggfunction.md)|Returns the maximum value across the group (with predicate)|\r\n|[min()](min-aggfunction.md)|Returns the minimum value across the group|\r\n|[minif()](minif-aggfunction.md)|Returns the minimum value across the group (with predicate)|\r\n|[percentiles()](percentiles-aggfunction.md)|Returns the percentile approximate of the group|\r\n|[percentiles_array()](percentiles-aggfunction.md)|Returns the percentiles approximates of the group|\r\n|[percentilesw()](percentiles-aggfunction.md)|Returns the weighted percentile approximate of the group|\r\n|[percentilesw_array()](percentiles-aggfunction.md)|Returns the weighted percentiles approximates of the group|\r\n|[stdev()](stdev-aggfunction.md)|Returns the standard deviation across the group|\r\n|[stdevif()](stdevif-aggfunction.md)|Returns the standard deviation across the group (with predicate)|\r\n|[sum()](sum-aggfunction.md)|Returns the sum of the elements within the group|\r\n|[sumif()](sumif-aggfunction.md)|Returns the sum of the elements within the group (with predicate)|\r\n|[variance()](variance-aggfunction.md)|Returns the variance across the group|\r\n|[varianceif()](varianceif-aggfunction.md)|Returns the variance across the group (with predicate)|\r\n\r\n## Aggregates default values\r\n\r\nThe following table summarizes the default values of aggregations:\r\n\r\nOperator       |Default value                         \r\n---------------|------------------------------------\r\n `count()`, `countif()`, `dcount()`, `dcountif()`         |   0                            \r\n `make_bag()`, `make_bag_if()`, `make_list()`, `make_list_if()`, `make_set()`, `make_set_if()` |    empty dynamic array              ([])          \r\n All others          |   null                           \r\n\r\nWhen using these aggregates over entities which includes null values, the null values will be ignored and won't participate in the calculation (see examples below).","![Summarize price by fruit and supplier](images/summarizeoperator/summarize-price-by-supplier.png)\r\n\r\n## Example\r\n\r\nDetermine what unique combinations of\r\n`ActivityType` and `CompletionStatus` there are in a table. There are no aggregation functions, just group-by keys. The output will just show the columns for those results:\r\n\r\n```\r\nActivities | summarize by ActivityType, completionStatus\r\n```\r\n\r\n|`ActivityType`|`completionStatus`\r\n|---|---\r\n|`dancing`|`started`\r\n|`singing`|`started`\r\n|`dancing`|`abandoned`\r\n|`singing`|`completed`\r\n\r\n## Example\r\n\r\nFinds the minimum and maximum timestamp of all records in the Activities table. There is no group-by clause, so there is just one row in the output:\r\n\r\n```\r\nActivities | summarize Min = min(Timestamp), Max = max(Timestamp)\r\n```\r\n\r\n|`Min`|`Max`\r\n|---|---\r\n|`1975-06-09 09:21:45` | `2015-12-24 23:45:00`\r\n\r\n## Example\r\n\r\nCreate a row for each continent, showing a count of the cities in which activities occur. Because there are few values for \"continent\", no grouping function is needed in the 'by' clause:\r\n\r\n```\r\nActivities | summarize cities=dcount(city) by continent\r\n```\r\n\r\n|`cities`|`continent`\r\n|---:|---\r\n|`4290`|`Asia`|\r\n|`3267`|`Europe`|\r\n|`2673`|`North America`|\r\n\r\n## Example\r\n\r\nThe following example calculates a histogram for each activity\r\ntype. Because `Duration` has many values, use `bin` to group its values into 10-minute intervals:\r\n\r\n```\r\nActivities | summarize count() by ActivityType, length=bin(Duration, 10m)\r\n```\r\n\r\n|`count_`|`ActivityType`|`length`\r\n|---:|---|---\r\n|`354`| `dancing` | `0:00:00.000`\r\n|`23`|`singing` | `0:00:00.000`\r\n|`2717`|`dancing`|`0:10:00.000`\r\n|`341`|`singing`|`0:10:00.000`\r\n|`725`|`dancing`|`0:20:00.000`\r\n|`2876`|`singing`|`0:20:00.000`\r\n|...\r\n\r\n**Example for the aggregates default values**\r\n\r\nWhen the input of `summarize` operator has at least one empty group-by key, it's result is empty, too.\r\n\r\nWhen the input of `summarize` operator doesn't have an empty group-by key, the result is the default values of the aggregates used in the `summarize`:\r\n\r\n```\r\ndatatable(x:long)[]\r\n| summarize any(x), arg_max(x, x), arg_min(x, x), avg(x), buildschema(todynamic(tostring(x))), max(x), min(x), percentile(x, 55), hll(x) ,stdev(x), sum(x), sumif(x, x > 0), tdigest(x), variance(x)\r\n```\r\n\r\n|any_x|max_x|max_x_x|min_x|min_x_x|avg_x|schema_x|max_x1|min_x1|percentile_x_55|hll_x|stdev_x|sum_x|sumif_x|tdigest_x|variance_x|\r\n|---|---|---|---|---|---|---|---|---|---|---|---|---|---|---|---|\r\n|||||||||||||||||\r\n\r\n```\r\ndatatable(x:long)[]\r\n| summarize  count(x), countif(x > 0) , dcount(x), dcountif(x, x > 0)\r\n```\r\n\r\n|count_x|countif_|dcount_x|dcountif_x|\r\n|---|---|---|---|\r\n|0|0|0|0|\r\n\r\n```\r\ndatatable(x:long)[]\r\n| summarize  make_set(x), make_list(x)\r\n```\r\n\r\n|set_x|list_x|\r\n|---|---|\r\n|[]|[]|\r\n\r\nThe aggregate avg sums all the non-nulls and counts only those which participated in the calculation (will not take nulls into account).\r\n\r\n```\r\nrange x from 1 to 2 step 1\r\n| extend y = iff(x == 1, real(null), real(5))\r\n| summarize sum(y), avg(y)\r\n```\r\n\r\n|sum_y|avg_y|\r\n|---|---|\r\n|5|5|\r\n\r\nThe regular count will count nulls: \r\n\r\n```\r\nrange x from 1 to 2 step 1\r\n| extend y = iff(x == 1, real(null), real(5))\r\n| summarize count(y)\r\n```\r\n\r\n|count_y|\r\n|---|\r\n|2|\r\n\r\n```\r\nrange x from 1 to 2 step 1\r\n| extend y = iff(x == 1, real(null), real(5))\r\n| summarize make_set(y), make_set(y)\r\n```\r\n\r\n|set_y|set_y1|\r\n|---|---|\r\n|[5.0]|[5.0]|","https://docs.microsoft.com/en-us/azure/kusto/query/summarizeoperator","summarizeoperator.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"table","The table() function references a table by providing its name as an expression\r\nof type `string`.",'```\r\ntable(\'StormEvent\')\r\n```\r\n\r\n## Syntax\r\n\r\n`table` `(` *TableName* [`,` *DataScope*] `)`\r\n\r\n## Arguments\r\n\r\n* *TableName*: An expression of type `string` that provides the name of the table\r\n  being referenced. The value of this expression must be constant at the point\r\n  of call to the function (i.e. it cannot vary by the data context).\r\n* *DataScope*: An optional parameter of type `string` that can be used to restrict\r\n  the table reference to data according to how this data falls under the table\'s\r\n  effective [cache policy](../management/cachepolicy.md). If used, the actual argument\r\n  must be a constant `string` expression having one of the following possible values:\r\n    - `"hotcache"`: Only data that is categorized as hot cache will be referenced.\r\n    - `"all"`: All the data in the table will be referenced.\r\n    - `"default"`: This is the same as `"all"`, except if the cluster has been\r\n      set to use `"hotcache"` as the default by the cluster admin.',"### Use table() to access table of the current database\r\n\r\n```\r\ntable('StormEvent') | count\r\n```\r\n\r\n|Count|\r\n|---|\r\n|59066|\r\n\r\n### Use table() inside let statements\r\n\r\nThe same query as above can be rewritten to use inline function (let statement) that \r\nreceives a parameter `tableName` - which is passed into the table() function.\r\n\r\n```\r\nlet foo = (tableName:string)\r\n{\r\n    table(tableName) | count\r\n};\r\nfoo('help')\r\n```\r\n\r\n|Count|\r\n|---|\r\n|59066|\r\n\r\n### Use table() inside Functions\r\n\r\nThe same query as above can be rewritten to be used in a function that \r\nreceives a parameter `tableName` - which is passed into the table() function.\r\n\r\n```\r\n.create function foo(tableName:string)\r\n{\r\n    table(tableName) | count\r\n};\r\n```\r\n\r\n**Note:** such functions can be used only locally and not in the cross-cluster query.\r\n\r\n### Use table() with non-constant parameter\r\n\r\nA parameter, which is not scalar constant string can't be passed as parameter to `table()` function.\r\n\r\nBelow, given an example of workaround for such case.\r\n\r\n```\r\nlet T1 = print x=1;\r\nlet T2 = print x=2;\r\nlet _choose = (_selector:string)\r\n{\r\n    union\r\n    (T1 | where _selector == 'T1'),\r\n    (T2 | where _selector == 'T2')\r\n};\r\n_choose('T2')\r\n\r\n```\r\n\r\n|x|\r\n|---|\r\n|2|","https://docs.microsoft.com/en-us/azure/kusto/query/tablefunction","tablefunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.OperatorToken,"take","Return up to the specified number of rows.","```\r\nT | take 5\r\n```\r\n\r\nThere is no guarantee which records are returned, unless\r\nthe source data is sorted.\r\n\r\n> [!NOTE]\r\n> `take` is a simple, quick, and efficient way to view a small sample of records when browsing data interactively, but be aware that it doesn't guarantee any consistency in its results when executing multiple times, even if the data set hasn't changed.\r\n> Even if the number of rows returned by the query isn't explicitly limited by the query (no `take` operator is used), Kusto limits that number by default. For more details, see [Kusto query limits](../concepts/querylimits.md).\r\n\r\n## Syntax\r\n\r\n`take` *NumberOfRows*\r\n`limit` *NumberOfRows*\r\n\r\n(`take` and `limit` are synonyms.)\r\n\r\n## Does Kusto support paging of query results?\r\n\r\nKusto doesn't provide a built-in paging mechanism.\r\n\r\nKusto is a complex service that continuously optimizes the data it stores to provide excellent query performance over huge data sets. While paging is a useful mechanism for stateless clients with limited\r\nresources, it shifts the burden to the backend service which\r\nhas to track client state information. Subsequently, the performance\r\nand scalability of the backend service is severely limited.\r\n\r\nFor paging support implement one of the following features:\r\n\r\n* Exporting the result of a query to an external storage and paging through the\r\n   generated data.\r\n* Writing a middle-tier application that provides a stateful paging API by caching\r\n   the results of a Kusto query.\r\n\r\n## See also\r\n\r\n* [sort operator](sortoperator.md)\r\n* [top operator](topoperator.md)\r\n* [top-nested operator](topnestedoperator.md)","","https://docs.microsoft.com/en-us/azure/kusto/query/takeoperator","")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"tan","Returns the tangent function.","## Syntax\r\n\r\n`tan(`*x*`)`\r\n\r\n## Arguments\r\n\r\n* *x*: A real number.\r\n\r\n## Returns\r\n\r\n* The result of `tan(x)`","","https://docs.microsoft.com/en-us/azure/kusto/query/tanfunction","")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"tdigest","Calculates the intermediate results of [`percentiles()`](percentiles-aggfunction.md) across the group.","> [!NOTE]\r\n> Can only be used in context of aggregation, inside [summarize](summarizeoperator.md).\r\n\r\nFor more information, see the [underlying algorithm (T-Digest) and the estimated error](percentiles-aggfunction.md#estimation-error-in-percentiles).\r\n\r\n## Syntax\r\n\r\n`summarize` `tdigest`(*`Expr`* [`,` *`WeightExpr`*])\r\n\r\n## Arguments\r\n\r\n* *Expr*: Expression that is used for aggregation calculation.\r\n* *WeightExpr*: Expression that is used as the weight of values for the aggregation calculation.\r\n\t\r\n\r\n## Returns\r\n\r\nThe Intermediate results of weighted percentiles of `*Expr*` across the group.\r\n\r\n**Tips**\r\n\r\n* Use the aggregation function [tdigest_merge()](tdigest-merge-aggfunction.md) to merge the output of `tdigest` again across another group.\r\n* Use the function [percentile_tdigest()](percentile-tdigestfunction.md) to calculate the percentile/percentilew of the `tdigest` results.","```\r\nStormEvents\r\n| summarize tdigest(DamageProperty) by State\r\n```\r\n\r\n|State|tdigest_DamageProperty|\r\n|---|---|\r\n|ATLANTIC SOUTH|[[5],[0],[193]]|\r\n|FLORIDA|[[5],[250,10,600000,5000,375000,15000000,20000,6000000,0,110000,150000,500,12000,30000,15000,46000000,7000000,6200000,200000,40000,8000,52000000,62000000,1200000,130000,1500000,4000000,7000,250000,875000,3000,100000,10600000,300000,1000000,25000,75000,2000,60000,10000,170000,350000,50000,1000,16000,80000,2500,400000],[9,1,1,22,1,1,9,1,842,1,3,7,2,4,7,1,1,1,2,5,3,3,1,1,1,1,2,2,1,1,9,7,1,1,2,5,2,9,2,27,1,1,7,27,1,1,1,1]]|\r\n|GEORGIA|[[5],[468,209,300000,3000,250000,775000,14000,500000,0,75000,4500000,500,6928,22767,9714,800000,700000,600000,150000,25000,5000,1600000,1250000,2700000,1500000,2250000,400000,4000,175000,325000,2500,73750,750000,1400000,350000,28000000,39000,1500,35000,6455,140000,225000,30000,1000,110000000,21700000,2000,275000,200000,100000,1000000,2600000,370000,2100000,355000,117500,50000,20100,10000],[11,11,4,53,21,1,6,10,1317,8,1,56,8,6,7,1,1,1,14,29,69,1,2,1,1,1,3,14,5,1,3,4,4,1,4,1,5,14,3,5,2,1,9,96,1,1,72,1,10,17,3,1,1,1,1,2,21,4,31]]|\r\n|MISSISSIPPI|[[5],[267,55,90000,3000,75000,300000,11167,160000,0,32000,40000,1000,7000,13000,8000,400000,200000,180000,50000,15000,5000,700000,500000,120000,650000,1000000,150000,4000,60000,100000,2500,30000,250000,600000,110000,12000,20000,1500,17000,6000,45000,70000,15250,1219,10000,25000,2000,80000,65000,35000,450000,1200000,130000,750000],[3,2,6,21,1,4,6,1,741,4,13,44,8,2,8,1,5,1,23,21,32,1,3,1,1,1,5,18,17,4,1,14,2,4,4,16,13,10,4,9,2,10,4,8,31,17,51,13,1,1,1,2,1,1]]|\r\n|AMERICAN SAMOA|[[5],[0,250000],[15,1]]|","https://docs.microsoft.com/en-us/azure/kusto/query/tdigest-aggfunction","tdigest-aggfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"tdigest_merge","Merges `tdigest` results (scalar version of the aggregate version [`tdigest_merge()`](tdigest-merge-aggfunction.md)).","Read more about the underlying algorithm (T-Digest) and the estimated error [here](percentiles-aggfunction.md#estimation-error-in-percentiles).\r\n\r\n## Syntax\r\n\r\n`merge_tdigests(` *Expr1*`,` *Expr2*`, ...)`\r\n\r\n`tdigest_merge(` *Expr1*`,` *Expr2*`, ...)` - An alias.\r\n\r\n## Arguments\r\n\r\n* Columns that have the `tdigest` values to be merged.\r\n\r\n## Returns\r\n\r\nThe result for merging the columns `*Expr1*`, `*Expr2*`, ... `*ExprN*` to one `tdigest`.","```\r\nrange x from 1 to 10 step 1 \r\n| extend y = x + 10\r\n| summarize tdigestX = tdigest(x), tdigestY = tdigest(y)\r\n| project merged = tdigest_merge(tdigestX, tdigestY)\r\n| project percentile_tdigest(merged, 100, typeof(long))\r\n```\r\n\r\n|percentile_tdigest_merged|\r\n|---|\r\n|20|","https://docs.microsoft.com/en-us/azure/kusto/query/tdigest-mergefunction","tdigest-mergefunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"to_utf8","Returns a dynamic array of the unicode characters of an input string (the inverse operation of make_string).","## Syntax\r\n\r\n`to_utf8(`*source*`)`\r\n\r\n## Arguments\r\n\r\n* *source*: The source string to convert.\r\n\r\n## Returns\r\n\r\nReturns a dynamic array of the unicode characters that make up the string provided to this function.\r\nSee [`make_string()`](makestringfunction.md))",'```\r\nprint arr = to_utf8("⒦⒰⒮⒯⒪")\r\n```\r\n\r\n|arr|\r\n|---|\r\n|[9382, 9392, 9390, 9391, 9386]|\r\n\r\n```\r\nprint arr = to_utf8("קוסטו - Kusto")\r\n```\r\n\r\n|arr|\r\n|---|\r\n|[1511, 1493, 1505, 1496, 1493, 32, 45, 32, 75, 117, 115, 116, 111]|\r\n\r\n```\r\nprint str = make_string(to_utf8("Kusto"))\r\n```\r\n\r\n|str|\r\n|---|\r\n|Kusto|',"https://docs.microsoft.com/en-us/azure/kusto/query/toutf8function","toutf8function.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"tobool","Converts input to boolean (signed 8-bit) representation.",'```\r\ntobool("true") == true\r\ntobool("false") == false\r\ntobool(1) == true\r\ntobool(123) == true\r\n```\r\n\r\n## Syntax\r\n\r\n`tobool(`*Expr*`)`\r\n`toboolean(`*Expr*`)` (alias)\r\n\r\n## Arguments\r\n\r\n* *Expr*: Expression that will be converted to boolean. \r\n\r\n## Returns\r\n\r\nIf conversion is successful, result will be a boolean.\r\nIf conversion isn\'t successful, result will be `null`.',"","https://docs.microsoft.com/en-us/azure/kusto/query/toboolfunction","")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"todatetime","Converts input to [datetime](./scalar-data-types/datetime.md) scalar.",'```\r\ntodatetime("2015-12-24") == datetime(2015-12-24)\r\n```\r\n\r\n## Syntax\r\n\r\n`todatetime(`*Expr*`)`\r\n\r\n## Arguments\r\n\r\n* *Expr*: Expression that will be converted to [datetime](./scalar-data-types/datetime.md).\r\n\r\n## Returns\r\n\r\nIf the conversion is successful, the result will be a [datetime](./scalar-data-types/datetime.md) value.\r\nElse, the result will be null.\r\n\r\n> [!NOTE]\r\n> Prefer using [datetime()](./scalar-data-types/datetime.md) when possible.',"","https://docs.microsoft.com/en-us/azure/kusto/query/todatetimefunction","")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"todecimal","Converts input to decimal number representation.",'```\r\ntodecimal("123.45678") == decimal(123.45678)\r\n```\r\n\r\n## Syntax\r\n\r\n`todecimal(`*Expr*`)`\r\n\r\n## Arguments\r\n\r\n* *Expr*: Expression that will be converted to decimal. \r\n\r\n## Returns\r\n\r\nIf conversion is successful, result will be a decimal number.\r\nIf conversion is not successful, result will be `null`.\r\n\r\n*Note*: Prefer using [real()](./scalar-data-types/real.md) when possible.',"","https://docs.microsoft.com/en-us/azure/kusto/query/todecimalfunction","")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"todouble","Converts the input to a value of type `real`. (`todouble()` and `toreal()` are synonyms.)",'```\r\ntoreal("123.4") == 123.4\r\n```\r\n\r\n> [!NOTE]\r\n> Prefer using [double() or real()](./scalar-data-types/real.md) when possible.\r\n\r\n## Syntax\r\n\r\n`toreal(`*Expr*`)`\r\n`todouble(`*Expr*`)`\r\n\r\n## Arguments\r\n\r\n* *Expr*: An expression whose value will be converted to a value of type `real`.\r\n\r\n## Returns\r\n\r\nIf conversion is successful, the result is a value of type `real`.\r\nIf conversion is not successful, the result is the value `real(null)`.',"","https://docs.microsoft.com/en-us/azure/kusto/query/todoublefunction","")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"todynamic","Interprets a `string` as a [JSON value](https://json.org/) and returns the value as [`dynamic`](./scalar-data-types/dynamic.md).","It is superior to using [extractjson() function](./extractjsonfunction.md)\r\nwhen you need to extract more than one element of a JSON compound object.\r\n\r\nAliases to [parse_json()](./parsejsonfunction.md) function.\r\n\r\n> [!NOTE]\r\n> Prefer using [dynamic()](./scalar-data-types/dynamic.md) when possible.\r\n\r\n## Syntax\r\n\r\n`todynamic(`*json*`)`\r\n`toobject(`*json*`)`\r\n\r\n## Arguments\r\n\r\n* *json*: A JSON document.\r\n\r\n## Returns\r\n\r\nAn object of type `dynamic` specified by *json*.","","https://docs.microsoft.com/en-us/azure/kusto/query/todynamicfunction","")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"toguid","Converts input to [`guid`](./scalar-data-types/guid.md) representation.",'```\r\ntoguid("70fc66f7-8279-44fc-9092-d364d70fce44") == guid("70fc66f7-8279-44fc-9092-d364d70fce44")\r\n```\r\n\r\n> [!NOTE]\r\n> Prefer using [guid()](./scalar-data-types/guid.md) when possible.\r\n\r\n## Syntax\r\n\r\n`toguid(`*Expr*`)`\r\n\r\n## Arguments\r\n\r\n* *Expr*: Expression that will be converted to [`guid`](./scalar-data-types/guid.md) scalar. \r\n\r\n## Returns\r\n\r\nIf conversion is successful, result will be a [`guid`](./scalar-data-types/guid.md) scalar.\r\nIf conversion is not successful, result will be `null`.',"","https://docs.microsoft.com/en-us/azure/kusto/query/toguidfunction","")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"tohex","Converts input to a hexadecimal string.","```\r\ntohex(256) == '100'\r\ntohex(-256) == 'ffffffffffffff00' // 64-bit 2's complement of -256\r\ntohex(toint(-256), 8) == 'ffffff00' // 32-bit 2's complement of -256\r\ntohex(256, 8) == '00000100'\r\ntohex(256, 2) == '100' // Exceeds min length of 2, so min length is ignored.\r\n```\r\n\r\n## Syntax\r\n\r\n`tohex(`*Expr*`, [`,` *MinLength*]`)`\r\n\r\n## Arguments\r\n\r\n* *Expr*: int or long value that will be converted to a hex string.  Other types are not supported.\r\n* *MinLength*: numeric value representing the number of leading characters to include in the output.  Values between 1 and 16 are supported, values greater than 16 will be truncated to 16.  If the string is longer than minLength without leading characters, then minLength is effectively ignored.  Negative numbers may only be represented at minimum by their underlying data size, so for an int (32-bit) the minLength will be at minimum 8, for a long (64-bit) it will be at minimum 16.\r\n\r\n## Returns\r\n\r\nIf conversion is successful, result will be a string value.\r\nIf conversion is not successful, result will be null.","","https://docs.microsoft.com/en-us/azure/kusto/query/tohexfunction","")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"toint","Converts input to integer (signed 32-bit) number representation.",'```\r\ntoint("123") == int(123)\r\n```\r\n\r\n## Syntax\r\n\r\n`toint(`*Expr*`)`\r\n\r\n## Arguments\r\n\r\n* *Expr*: Expression that will be converted to integer. \r\n\r\n## Returns\r\n\r\nIf the conversion is successful, the result will be an integer.\r\nIf the conversion isn\'t successful, the result will be `null`.\r\n\r\n*Note*: Prefer using [int()](./scalar-data-types/int.md) when possible.',"","https://docs.microsoft.com/en-us/azure/kusto/query/tointfunction","")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"tolong","Converts input to long (signed 64-bit) number representation.",'```\r\ntolong("123") == 123\r\n```\r\n\r\n> [!NOTE]\r\n> Prefer using [long()](./scalar-data-types/long.md) when possible.\r\n\r\n## Syntax\r\n\r\n`tolong(`*Expr*`)`\r\n\r\n## Arguments\r\n\r\n* *Expr*: Expression that will be converted to long. \r\n\r\n## Returns\r\n\r\nIf conversion is successful, result will be a long number.\r\nIf conversion is not successful, result will be `null`.',"","https://docs.microsoft.com/en-us/azure/kusto/query/tolongfunction","")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"tolower","Converts input string to lower case.",'```\r\ntolower("Hello") == "hello"\r\n```',"","https://docs.microsoft.com/en-us/azure/kusto/query/tolowerfunction","")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.OperatorToken,"top","Returns the first *N* records sorted by the specified columns.",'```\r\nT | top 5 by Name desc nulls last\r\n```\r\n\r\n## Syntax\r\n\r\n*T* `| top` *NumberOfRows* `by` *Expression* [`asc` | `desc`] [`nulls first` | `nulls last`]\r\n\r\n## Arguments\r\n\r\n* *NumberOfRows*: The number of rows of *T* to return. You can specify any numeric expression.\r\n* *Expression*: A scalar expression by which to sort. The type of the values must be numeric, date, time or string.\r\n* `asc` or `desc` (the default) may appear to control whether selection is actually from the "bottom" or "top" of the range.\r\n* `nulls first` (the default for `asc` order) or `nulls last` (the default for `desc` order) may appear to control whether null values will be at the beginning or the end of the range.\r\n\r\n> [!TIP]\r\n> `top 5 by name` is equivalent to the expression `sort by name | take 5` both from semantic and performance perspectives.\r\n\r\n## See also \r\n\r\n* Use [top-nested](topnestedoperator.md) operator to produce hierarchical (nested) top results.',"","https://docs.microsoft.com/en-us/azure/kusto/query/topoperator","")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.OperatorToken,"top-hitters","Returns an approximation of the first *N* results (assuming skewed distribution of the input).","```\r\nT | top-hitters 25 of Page by Views \r\n```\r\n\r\n> [!NOTE]\r\n> `top-hitters` is an approximation algorithm and should be used when running with large data. \r\n> The approximation of the the top-hitters is based on the [Count-Min-Sketch](https://en.wikipedia.org/wiki/Count%E2%80%93min_sketch) algorithm.  \r\n\r\n## Syntax\r\n\r\n*T* `| top-hitters` *NumberOfRows* `of` *sort_key* `[` `by` *expression* `]`\r\n\r\n## Arguments\r\n\r\n* *NumberOfRows*: The number of rows of *T* to return. You can specify any numeric expression.\r\n* *sort_key*: The name of the column by which to sort the rows.\r\n* *expression*: (optional) An expression which will be used for the top-hitters estimation. \r\n    * *expression*: top-hitters will return *NumberOfRows* rows which have an approximated maximum of sum(*expression*). Expression can be a column, or any other expression that evaluates to a number. \r\n    *  If *expression* is not mentioned, top-hitters algorithm will count the occurrences of the *sort-key*.","### Get most frequent items \r\n\r\nThe next example shows how to find top-5 languages with most pages in Wikipedia (accessed after during April 2016). \r\n\r\n```\r\nPageViews\r\n| where Timestamp > datetime(2016-04-01) and Timestamp < datetime(2016-05-01) \r\n| top-hitters 5 of Language \r\n```\r\n\r\n|Language|approximate_count_Language|\r\n|---|---|\r\n|en|1539954127|\r\n|zh|339827659|\r\n|de|262197491|\r\n|ru|227003107|\r\n|fr|207943448|\r\n\r\n### Get top hitters based on column value\r\n\r\nThe next example shows how to find most viewed English pages of Wikipedia of the year 2016. \r\nThe query uses 'Views' (integer number) to calculate page popularity (number of views). \r\n\r\n```\r\nPageViews\r\n| where Timestamp > datetime(2016-01-01)\r\n| where Language == \"en\"\r\n| where Page !has 'Special'\r\n| top-hitters 10 of Page by Views\r\n```\r\n\r\n|Page|approximate_sum_Views|\r\n|---|---|\r\n|Main_Page|1325856754|\r\n|Web_scraping|43979153|\r\n|Java_(programming_language)|16489491|\r\n|United_States|13928841|\r\n|Wikipedia|13584915|\r\n|Donald_Trump|12376448|\r\n|YouTube|11917252|\r\n|The_Revenant_(2015_film)|10714263|\r\n|Star_Wars:_The_Force_Awakens|9770653|\r\n|Portal:Current_events|9578000|","https://docs.microsoft.com/en-us/azure/kusto/query/tophittersoperator","tophittersoperator.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.OperatorToken,"top-nested","Produces a hierarchical aggregation and top values selection, where each level is a refinement of the previous one.",'```\r\nT | top-nested 3 of Location with others="Others" by sum(MachinesNumber), top-nested 4 of bin(Timestamp,5m) by sum(MachinesNumber)\r\n```\r\n\r\nThe `top-nested` operator accepts tabular data as input, and one or more aggregation clauses.\r\nThe first aggregation clause (left-most) subdivides the input records into partitions, according\r\nto the unique values of some expression over those records. The clause then keeps a certain number of records\r\nthat maximize or minimize this expression over the records. The next aggregation clause then\r\napplies a similar function, in a nested fashion. Each following clause is applied to the partition produced\r\nby the previous clause. This process continues for all aggregation clauses.\r\n\r\nFor example, the `top-nested` operator can be used to answer the following question: "For a table containing sales\r\nfigures, such as country, salesperson, and amount sold: what are the top five countries by sales? What are the top three salespeople in each of these countries?"\r\n\r\n## Syntax\r\n\r\n*T* `|` `top-nested` *TopNestedClause2* [`,` *TopNestedClause2*...]\r\n\r\nWhere *TopNestedClause* has the following syntax:\r\n\r\n[*N*] `of` [*`ExprName`* `=`] *`Expr`* [`with` `others` `=` *`ConstExpr`*] `by` [*`AggName`* `=`] *`Aggregation`* [`asc` | `desc`]\r\n\r\n## Arguments\r\n\r\nFor each *TopNestedClause*:\r\n\r\n* *`N`*: A literal of type `long` indicating how many top values to return\r\n  for this hierarchy level.\r\n  If omitted, all distinct values will be returned.\r\n* *`ExprName`*: If specified, sets the name of the output column corresponding\r\n  to the values of *`Expr`*.\r\n* *`Expr`*: An expression over the input record indicating which value to return\r\n  for this hierarchy level.\r\n  Typically it\'s a column reference for the tabular input (*T*), or some\r\n  calculation (such as `bin()`) over such a column.\r\n* *`ConstExpr`*: If specified, for each hierarchy level, 1 record will be added\r\n  with the value that is the aggregation over all records that didn\'t\r\n  "make it to the top".\r\n* *`AggName`*: If specified, this identifier sets the column name\r\n  in the output for the value of *Aggregation*.\r\n* *`Aggregation`*: A numeric expression indicating the aggregation to apply\r\n  to all records sharing the same value of *`Expr`*. The value of this aggregation\r\n  determines which of the resulting records are "top".\r\n  \r\n  The following aggregation functions are supported:\r\n   * [sum()](sum-aggfunction.md),\r\n   * [count()](count-aggfunction.md),\r\n   * [max()](max-aggfunction.md),\r\n   * [min()](min-aggfunction.md),\r\n   * [dcount()](dcountif-aggfunction.md),\r\n   * [avg()](avg-aggfunction.md),\r\n   * [percentile()](percentiles-aggfunction.md), and\r\n   * [percentilew()](percentiles-aggfunction.md). Any algebraic combination of the aggregations is also supported.\r\n* `asc` or `desc` (the default) may appear to control whether selection is actually from the "bottom" or "top" of the range of aggregated values.\r\n\r\n## Returns\r\n\r\nThis operator returns a table that has two columns for each aggregation clause:\r\n\r\n* One column holds the distinct values of the clause\'s *`Expr`* calculation (having the\r\n  column name *ExprName* if specified)\r\n* One column holds the result of the *Aggregation*\r\n  calculation (having the column name *AggregationName* if specified)\r\n\r\n## Notes\r\n\r\nInput columns that aren\'t specified as *`Expr`* values aren\'t outputted.\r\nTo get all values at a certain level, add an aggregation count that:\r\n\r\n* Omits the value of *N*\r\n* Uses the column name as the value of *`Expr`*\r\n* Uses `Ignore=max(1)` as the aggregation, and then ignore (or project-away)\r\n   the column `Ignore`.\r\n\r\nThe number of records may grow exponentially with the number of aggregation clauses\r\n((N1+1) \\* (N2+1) \\* ...). Record growth is even faster if no *N* limit is specified. Take into account that this operator may consume a considerable amount of resources.\r\n\r\nIf the distribution of the aggregation is considerably non-uniform,\r\nlimit the number of distinct values to return (by using *N*) and use the\r\n`with others=` *ConstExpr* option to get an indication for the "weight" of all other\r\ncases.',"```\r\nStormEvents\r\n| top-nested 2 of State by sum(BeginLat),\r\n  top-nested 3 of Source by sum(BeginLat),\r\n  top-nested 1 of EndLocation by sum(BeginLat)\r\n```\r\n\r\n|State|aggregated_State|Source|aggregated_Source|EndLocation|aggregated_EndLocation|\r\n|---|---|---|---|---|---|\r\n|KANSAS|87771.2355000001|Law Enforcement|18744.823|FT SCOTT|264.858|\r\n|KANSAS|87771.2355000001|Public|22855.6206|BUCKLIN|488.2457|\r\n|KANSAS|87771.2355000001|Trained Spotter|21279.7083|SHARON SPGS|388.7404|\r\n|TEXAS|123400.5101|Public|13650.9079|AMARILLO|246.2598|\r\n|TEXAS|123400.5101|Law Enforcement|37228.5966|PERRYTON|289.3178|\r\n|TEXAS|123400.5101|Trained Spotter|13997.7124|CLAUDE|421.44|\r\n\r\nUse the option 'with others':\r\n\r\n```\r\nStormEvents\r\n| top-nested 2 of State with others = \"All Other States\" by sum(BeginLat),\r\n  top-nested 3 of Source by sum(BeginLat),\r\n  top-nested 1 of EndLocation with others = \"All Other End Locations\" by  sum(BeginLat)\r\n\r\n\r\n```\r\n\r\n|State|aggregated_State|Source|aggregated_Source|EndLocation|aggregated_EndLocation|\r\n|---|---|---|---|---|---|\r\n|KANSAS|87771.2355000001|Law Enforcement|18744.823|FT SCOTT|264.858|\r\n|KANSAS|87771.2355000001|Public|22855.6206|BUCKLIN|488.2457|\r\n|KANSAS|87771.2355000001|Trained Spotter|21279.7083|SHARON SPGS|388.7404|\r\n|TEXAS|123400.5101|Public|13650.9079|AMARILLO|246.2598|\r\n|TEXAS|123400.5101|Law Enforcement|37228.5966|PERRYTON|289.3178|\r\n|TEXAS|123400.5101|Trained Spotter|13997.7124|CLAUDE|421.44|\r\n|KANSAS|87771.2355000001|Law Enforcement|18744.823|All Other End Locations|18479.965|\r\n|KANSAS|87771.2355000001|Public|22855.6206|All Other End Locations|22367.3749|\r\n|KANSAS|87771.2355000001|Trained Spotter|21279.7083|All Other End Locations|20890.9679|\r\n|TEXAS|123400.5101|Public|13650.9079|All Other End Locations|13404.6481|\r\n|TEXAS|123400.5101|Law Enforcement|37228.5966|All Other End Locations|36939.2788|\r\n|TEXAS|123400.5101|Trained Spotter|13997.7124|All Other End Locations|13576.2724|\r\n|KANSAS|87771.2355000001|||All Other End Locations|24891.0836|\r\n|TEXAS|123400.5101|||All Other End Locations|58523.2932000001|\r\n|All Other States|1149279.5923|||All Other End Locations|1149279.5923|\r\n\r\nThe following query shows the same results for the first level used in the example above.\r\n\r\n```\r\n StormEvents\r\n | where State !in ('TEXAS', 'KANSAS')\r\n | summarize sum(BeginLat)\r\n```\r\n\r\n|sum_BeginLat|\r\n|---|\r\n|1149279.5923|\r\n\r\nRequest another column (EventType) to the top-nested result.\r\n\r\n```\r\nStormEvents\r\n| top-nested 2 of State by sum(BeginLat),    top-nested 2 of Source by sum(BeginLat),    top-nested 1 of EndLocation by sum(BeginLat), top-nested of EventType  by tmp = max(1)\r\n| project-away tmp\r\n```\r\n\r\n|State|aggregated_State|Source|aggregated_Source|EndLocation|aggregated_EndLocation|EventType|\r\n|---|---|---|---|---|---|---|\r\n|KANSAS|87771.2355000001|Trained Spotter|21279.7083|SHARON SPGS|388.7404|Thunderstorm Wind|\r\n|KANSAS|87771.2355000001|Trained Spotter|21279.7083|SHARON SPGS|388.7404|Hail|\r\n|KANSAS|87771.2355000001|Trained Spotter|21279.7083|SHARON SPGS|388.7404|Tornado|\r\n|KANSAS|87771.2355000001|Public|22855.6206|BUCKLIN|488.2457|Hail|\r\n|KANSAS|87771.2355000001|Public|22855.6206|BUCKLIN|488.2457|Thunderstorm Wind|\r\n|KANSAS|87771.2355000001|Public|22855.6206|BUCKLIN|488.2457|Flood|\r\n|TEXAS|123400.5101|Trained Spotter|13997.7124|CLAUDE|421.44|Hail|\r\n|TEXAS|123400.5101|Law Enforcement|37228.5966|PERRYTON|289.3178|Hail|\r\n|TEXAS|123400.5101|Law Enforcement|37228.5966|PERRYTON|289.3178|Flood|\r\n|TEXAS|123400.5101|Law Enforcement|37228.5966|PERRYTON|289.3178|Flash Flood|\r\n\r\nGive an index sort order for each value in this level (per group) to sort the result by the last nested level (in this example by EndLocation):\r\n\r\n```\r\nStormEvents\r\n| top-nested 2 of State  by sum(BeginLat),    top-nested 2 of Source by sum(BeginLat),    top-nested 4 of EndLocation by  sum(BeginLat)\r\n| order by State , Source, aggregated_EndLocation\r\n| summarize EndLocations = make_list(EndLocation, 10000) , endLocationSums = make_list(aggregated_EndLocation, 10000) by State, Source\r\n| extend indicies = range(0, array_length(EndLocations) - 1, 1)\r\n| mv-expand EndLocations, endLocationSums, indicies\r\n```\r\n\r\n|State|Source|EndLocations|endLocationSums|indices|\r\n|---|---|---|---|---|\r\n|TEXAS|Trained Spotter|CLAUDE|421.44|0|\r\n|TEXAS|Trained Spotter|AMARILLO|316.8892|1|\r\n|TEXAS|Trained Spotter|DALHART|252.6186|2|\r\n|TEXAS|Trained Spotter|PERRYTON|216.7826|3|\r\n|TEXAS|Law Enforcement|PERRYTON|289.3178|0|\r\n|TEXAS|Law Enforcement|LEAKEY|267.9825|1|\r\n|TEXAS|Law Enforcement|BRACKETTVILLE|264.3483|2|\r\n|TEXAS|Law Enforcement|GILMER|261.9068|3|\r\n|KANSAS|Trained Spotter|SHARON SPGS|388.7404|0|\r\n|KANSAS|Trained Spotter|ATWOOD|358.6136|1|\r\n|KANSAS|Trained Spotter|LENORA|317.0718|2|\r\n|KANSAS|Trained Spotter|SCOTT CITY|307.84|3|\r\n|KANSAS|Public|BUCKLIN|488.2457|0|\r\n|KANSAS|Public|ASHLAND|446.4218|1|\r\n|KANSAS|Public|PROTECTION|446.11|2|\r\n|KANSAS|Public|MEADE STATE PARK|371.1|3|","https://docs.microsoft.com/en-us/azure/kusto/query/topnestedoperator","topnestedoperator.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"toscalar","Returns a scalar constant value of the evaluated expression.","This function is useful for queries that require staged calculations. For example, \r\ncalculate a total count of events, and then use the result to filter groups\r\nthat exceed a certain percent of all events.\r\n\r\n## Syntax\r\n\r\n`toscalar(`*Expression*`)`\r\n\r\n## Arguments\r\n\r\n* *Expression*: Expression that will be evaluated for scalar conversion.\r\n\r\n## Returns\r\n\r\nA scalar constant value of the evaluated expression.\r\nIf the result is a tabular, then the first column and first row will be taken for conversion.\r\n\r\n> [!TIP]\r\n> You can use a [let statement](letstatement.md) for readability of the query when using `toscalar()`.\r\n\r\n**Notes**\r\n\r\n`toscalar()` can be calculated a constant number of times during the query execution.\r\nThe `toscalar()` function can't be applied on row-level (for-each-row scenario).","Evaluate `Start`, `End`, and `Step` as scalar constants, and use the result for `range` evaluation.\r\n\r\n```\r\nlet Start = toscalar(print x=1);\r\nlet End = toscalar(range x from 1 to 9 step 1 | count);\r\nlet Step = toscalar(2);\r\nrange z from Start to End step Step | extend start=Start, end=End, step=Step\r\n```\r\n\r\n|z|start|end|step|\r\n|---|---|---|---|\r\n|1|1|9|2|\r\n|3|1|9|2|\r\n|5|1|9|2|\r\n|7|1|9|2|\r\n|9|1|9|2|","https://docs.microsoft.com/en-us/azure/kusto/query/toscalarfunction","toscalarfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"tostring","Converts input to a string representation.",'```\r\ntostring(123) == "123"\r\n```\r\n\r\n## Syntax\r\n\r\n`tostring(`*`Expr`*`)`\r\n\r\n## Arguments\r\n\r\n* *`Expr`*: Expression that will be converted to string. \r\n\r\n## Returns\r\n\r\nIf the *`Expr`* value is non-null, the result will be a string representation of *`Expr`*.\r\nIf the *`Expr`* value is null, the result will be an empty string.',"","https://docs.microsoft.com/en-us/azure/kusto/query/tostringfunction","")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"totimespan","Converts input to [timespan](./scalar-data-types/timespan.md) scalar.",'```\r\ntotimespan("0.00:01:00") == time(1min)\r\n```\r\n\r\n## Syntax\r\n\r\n`totimespan(Expr)`\r\n\r\n## Arguments\r\n\r\n* *`Expr`*: Expression that will be converted to [timespan](./scalar-data-types/timespan.md).\r\n\r\n## Returns\r\n\r\nIf conversion is successful, result will be a [timespan](./scalar-data-types/timespan.md) value.\r\nElse, result will be null.',"","https://docs.microsoft.com/en-us/azure/kusto/query/totimespanfunction","")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"toupper","Converts a string to upper case.",'```\r\ntoupper("hello") == "HELLO"\r\n```',"","https://docs.microsoft.com/en-us/azure/kusto/query/toupperfunction","")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"translate","Replaces a set of characters ('searchList') with another set of characters ('replacementList') in a given a string.\r\nThe function searches for characters in the 'searchList' and replaces them with the corresponding characters in 'replacementList'","## Syntax\r\n\r\n`translate(`*searchList*`,` *replacementList*`,` *text*`)`\r\n\r\n## Arguments\r\n\r\n* *searchList*: The list of characters that should be replaced\r\n* *replacementList*: The list of characters that should replace the characters in 'searchList'\r\n* *text*: A string to search\r\n\r\n## Returns\r\n\r\n*text* after replacing all ocurrences of characters in 'replacementList' with the corresponding characters in 'searchList'",'|Input                                 |Output   |\r\n|--------------------------------------|---------|\r\n|`translate("abc", "x", "abc")`        |`"xxx"`  |\r\n|`translate("abc", "", "ab")`          |`""`     |\r\n|`translate("krasp", "otsku", "spark")`|`"kusto"`|',"https://docs.microsoft.com/en-us/azure/kusto/query/translatefunction","translatefunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"treepath","Enumerates all the path expressions that identify leaves in a dynamic object.","`treepath(`*dynamic object*`)`\r\n\r\n## Returns\r\n\r\nAn array of path expressions.",'|Expression|Evaluates to|\r\n|---|---|\r\n|`treepath(parse_json(\'{"a":"b", "c":123}\'))` | `["[\'a\']","[\'c\']"]`|\r\n|`treepath(parse_json(\'{"prop1":[1,2,3,4], "prop2":"value2"}\'))`|`["[\'prop1\']","[\'prop1\'][0]","[\'prop2\']"]`|\r\n|`treepath(parse_json(\'{"listProperty":[100,200,300,"abcde",{"x":"y"}]}\'))`|`["[\'listProperty\']","[\'listProperty\'][0]","[\'listProperty\'][0][\'x\']"]`|',"https://docs.microsoft.com/en-us/azure/kusto/query/treepathfunction","treepathfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"trim","Removes all leading and trailing matches of the specified regular expression.","## Syntax\r\n\r\n`trim(`*regex*`,` *text*`)`\r\n\r\n## Arguments\r\n\r\n* *regex*: String or [regular expression](re2.md) to be trimmed from the beginning and/or the end of *text*.  \r\n* *text*: A string.\r\n\r\n## Returns\r\n\r\n*text* after trimming matches of *regex* found in the beginning and/or the end of *text*.",'Statement bellow trims *substring*  from the start and the end of the *string_to_trim*:\r\n\r\n```\r\nlet string_to_trim = @"--https://bing.com--";\r\nlet substring = "--";\r\nprint string_to_trim = string_to_trim, trimmed_string = trim(substring,string_to_trim)\r\n```\r\n\r\n|string_to_trim|trimmed_string|\r\n|---|---|\r\n|--https://bing.com--|https://bing.com|\r\n\r\nNext statement trims all non-word characters from start and end of the string:\r\n\r\n```\r\nrange x from 1 to 5 step 1\r\n| project str = strcat("-  ","Te st",x,@"// $")\r\n| extend trimmed_str = trim(@"[^\\w]+",str)\r\n```\r\n\r\n|str|trimmed_str|\r\n|---|---|\r\n|-  Te st1// $|Te st1|\r\n|-  Te st2// $|Te st2|\r\n|-  Te st3// $|Te st3|\r\n|-  Te st4// $|Te st4|\r\n|-  Te st5// $|Te st5|',"https://docs.microsoft.com/en-us/azure/kusto/query/trimfunction","trimfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"trim_end","Removes trailing match of the specified regular expression.","## Syntax\r\n\r\n`trim_end(`*regex*`,` *text*`)`\r\n\r\n## Arguments\r\n\r\n* *regex*: String or [regular expression](re2.md) to be trimmed from the end of *text*.  \r\n* *text*: A string.\r\n\r\n## Returns\r\n\r\n*text* after trimming matches of *regex* found in the end of *text*.",'Statement bellow trims *substring*  from the end of *string_to_trim*:\r\n\r\n```\r\nlet string_to_trim = @"bing.com";\r\nlet substring = ".com";\r\nprint string_to_trim = string_to_trim,trimmed_string = trim_end(substring,string_to_trim)\r\n```\r\n\r\n|string_to_trim|trimmed_string|\r\n|--------------|--------------|\r\n|bing.com      |bing          |\r\n\r\nNext statement trims all non-word characters from the end of the string:\r\n\r\n```\r\nprint str = strcat("-  ","Te st",x,@"// $")\r\n| extend trimmed_str = trim_end(@"[^\\w]+",str)\r\n```\r\n\r\n|str          |trimmed_str|\r\n|-------------|-----------|\r\n|-  Te st1// $|-  Te st1  |\r\n|-  Te st2// $|-  Te st2  |\r\n|-  Te st3// $|-  Te st3  |\r\n|-  Te st4// $|-  Te st4  |\r\n|-  Te st5// $|-  Te st5  |',"https://docs.microsoft.com/en-us/azure/kusto/query/trimendfunction","trimendfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"trim_start","Removes leading match of the specified regular expression.","## Syntax\r\n\r\n`trim_start(`*regex*`,` *text*`)`\r\n\r\n## Arguments\r\n\r\n* *regex*: String or [regular expression](re2.md) to be trimmed from the beginning of *text*.  \r\n* *text*: A string.\r\n\r\n## Returns\r\n\r\n*text* after trimming match of *regex* found in the beginning of *text*.",'Statement bellow trims *substring*  from the start of *string_to_trim*:\r\n\r\n```\r\nlet string_to_trim = @"https://bing.com";\r\nlet substring = "https://";\r\nprint string_to_trim = string_to_trim,trimmed_string = trim_start(substring,string_to_trim)\r\n```\r\n\r\n|string_to_trim|trimmed_string|\r\n|---|---|\r\n|https://bing.com|bing.com|\r\n\r\nNext statement trims all non-word characters from the beginning of the string:\r\n\r\n```\r\nrange x from 1 to 5 step 1\r\n| project str = strcat("-  ","Te st",x,@"// $")\r\n| extend trimmed_str = trim_start(@"[^\\w]+",str)\r\n```\r\n\r\n|str|trimmed_str|\r\n|---|---|\r\n|-  Te st1// $|Te st1// $|\r\n|-  Te st2// $|Te st2// $|\r\n|-  Te st3// $|Te st3// $|\r\n|-  Te st4// $|Te st4// $|\r\n|-  Te st5// $|Te st5// $|',"https://docs.microsoft.com/en-us/azure/kusto/query/trimstartfunction","trimstartfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.OperatorToken,"union","Takes two or more tables and returns the rows of all of them.",'```\r\nTable1 | union Table2, Table3\r\n```\r\n\r\n## Syntax\r\n\r\n*T* `| union` [*UnionParameters*] [`kind=` `inner`|`outer`] [`withsource=`*ColumnName*] [`isfuzzy=` `true`|`false`] *Table* [`,` *Table*]...  \r\n\r\nAlternative form with no piped input:\r\n\r\n`union` [*UnionParameters*] [`kind=` `inner`|`outer`] [`withsource=`*ColumnName*] [`isfuzzy=` `true`|`false`] *Table* [`,` *Table*]...  \r\n\r\n## Arguments\r\n\r\n* `Table`:\r\n    *  The name of a table, such as `Events`; or\r\n    *  A query expression that must be enclosed with parenthesis, such as `(Events | where id==42)` or `(cluster("https://help.kusto.windows.net:443").database("Samples").table("*"))`; or\r\n    *  A set of tables specified with a wildcard. For example, `E*` would form the union of all the tables in the database whose names begin `E`.\r\n* `kind`: \r\n    * `inner` - The result has the subset of columns that are common to all of the input tables.\r\n    * `outer` - (default). The result has all the columns that occur in any of the inputs. Cells that weren\'t defined by an input row are set to `null`.\r\n* `withsource`=*ColumnName*: If specified, the output will include a column\r\ncalled *ColumnName* whose value indicates which source table has contributed each row.\r\nIf the query effectively (after wildcard matching) references tables from more than one database (default database always counts) the value of this column will have a table name qualified with the database.\r\nSimilarly __cluster and database__ qualifications will be present in the value if more than one cluster is referenced. \r\n* `isfuzzy=` `true` | `false`: If `isfuzzy` is set to `true` - allows fuzzy resolution of union legs. `Fuzzy` applies to the set of `union` sources. It means that while analyzing the query and preparing for execution, the set of union sources is reduced to the set of table references that exist and are accessible at the time. If at least one such table was found, any resolution failure will yield a warning in the query status results (one for each missing reference), but will not prevent the query execution; if no resolutions were successful - the query will return an error.\r\nThe default is `isfuzzy=` `false`.\r\n* *UnionParameters*: Zero or more (space-separated) parameters in the form of\r\n  *Name* `=` *Value* that control the behavior\r\n  of the row-match operation and execution plan. The following parameters are supported: \r\n  |Name           |Values                                        |Description                                  |\r\n  |---------------|----------------------------------------------|---------------------------------------------|\r\n  |`hint.concurrency`|*Number*|Hints the system how many concurrent subqueries of the `union` operator should be executed in parallel. *Default*: Amount of CPU cores on the single node of the cluster (2 to 16).|\r\n  |`hint.spread`|*Number*|Hints the system how many nodes should be used by the concurrent `union` subqueries execution. *Default*: 1.|\r\n\r\n\r\n## Returns\r\n\r\nA table with as many rows as there are in all the input tables.\r\n\r\n**Notes**\r\n\r\n1. `union` scope can include [let statements](./letstatement.md) if those are \r\nattributed with [view keyword](./letstatement.md)\r\n2. `union` scope will not include [functions](../management/functions.md). To include a function in the union scope, define a [let statement](./letstatement.md) with [view keyword](./letstatement.md)\r\n3. If the `union` input is [tables](../management/tables.md) (as oppose to [tabular expressions](./tabularexpressionstatements.md)), and the `union` is followed by a [where operator](./whereoperator.md), for better performance, consider replacing both with [find](./findoperator.md). Note the different [output schema](./findoperator.md#output-schema) produced by the `find` operator. \r\n4. `isfuzzy=true` only applies to the `union` sources resolution phase. Once the set of source tables is determined, possible additional query failures will not be suppressed.\r\n5. When using `outer union`, the result has all the columns that occur in any of the inputs, one column for each name and type occurrences. This means that if a column appears in multiple tables and has multiple types, it will have a corresponding column for each type in the `union`\'s result. This column name will be suffixed with a \'_\' followed by the origin column [type](./scalar-data-types/index.md).',"```\r\nunion K* | where * has \"Kusto\"\r\n```\r\n\r\nRows from all tables in the database whose name starts with `K`, and in which any column includes the word `Kusto`.\r\n\r\n## Example\r\n\r\n```\r\nunion withsource=SourceTable kind=outer Query, Command\r\n| where Timestamp > ago(1d)\r\n| summarize dcount(UserId)\r\n```\r\n\r\nThe number of distinct users that have produced\r\neither a `Query` event or a `Command` event over the past day. In the result, the 'SourceTable' column will indicate either \"Query\" or \"Command\".\r\n\r\n```\r\nQuery\r\n| where Timestamp > ago(1d)\r\n| union withsource=SourceTable kind=outer \r\n   (Command | where Timestamp > ago(1d))\r\n| summarize dcount(UserId)\r\n```\r\n\r\nThis more efficient version produces the same result. It filters each table before creating the union.\r\n\r\n**Example: Using `isfuzzy=true`**\r\n\r\n```\r\n// Using union isfuzzy=true to access non-existing view:                                     \r\nlet View_1 = view () { print x=1 };\r\nlet View_2 = view () { print x=1 };\r\nlet OtherView_1 = view () { print x=1 };\r\nunion isfuzzy=true\r\n(View_1 | where x > 0), \r\n(View_2 | where x > 0),\r\n(View_3 | where x > 0)\r\n| count \r\n```\r\n\r\n|Count|\r\n|---|\r\n|2|\r\n\r\nObserving Query Status - the following warning returned:\r\n`Failed to resolve entity 'View_3'`\r\n\r\n```\r\n// Using union isfuzzy=true and wildcard access:\r\nlet View_1 = view () { print x=1 };\r\nlet View_2 = view () { print x=1 };\r\nlet OtherView_1 = view () { print x=1 };\r\nunion isfuzzy=true View*, SomeView*, OtherView*\r\n| count \r\n```\r\n\r\n|Count|\r\n|---|\r\n|3|\r\n\r\nObserving Query Status - the following warning returned:\r\n`Failed to resolve entity 'SomeView*'`\r\n\r\n**Example: source columns types mismatch**\r\n\r\n```\r\nlet View_1 = view () { print x=1 };\r\nlet View_2 = view () { print x=toint(2) };\r\nunion withsource=TableName View_1, View_2\r\n```\r\n\r\n|TableName|x_long|x_int|\r\n|---------|------|-----|\r\n|View_1   |1     |     |\r\n|View_2   |      |2    |\r\n\r\n```\r\nlet View_1 = view () { print x=1 };\r\nlet View_2 = view () { print x=toint(2) };\r\nlet View_3 = view () { print x_long=3 };\r\nunion withsource=TableName View_1, View_2, View_3 \r\n```\r\n\r\n|TableName|x_long1|x_int |x_long|\r\n|---------|-------|------|------|\r\n|View_1   |1      |      |      |\r\n|View_2   |       |2     |      |\r\n|View_3   |       |      |3     |\r\n\r\nColumn `x` from `View_1` received the suffix `_long`, and as a column named `x_long` already exists in the result schema, the column names were de-duplicated, producing a new column- `x_long1`","https://docs.microsoft.com/en-us/azure/kusto/query/unionoperator","unionoperator.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"unixtime_microseconds_todatetime","Converts unix-epoch microseconds to UTC datetime.","## Syntax\r\n\r\n`unixtime_microseconds_todatetime(*microseconds*)`\r\n\r\n## Arguments\r\n\r\n* *microseconds*: A real number represents epoch timestamp in microseconds. `Datetime` that occurs before the epoch time (1970-01-01 00:00:00) has a negative timestamp value.\r\n\r\n## Returns\r\n\r\nIf the conversion is successful, the result will be a [datetime](./scalar-data-types/datetime.md) value. If conversion is not successful, result will be null.\r\n\r\n## See also\r\n\r\n* Convert unix-epoch seconds to UTC datetime using [unixtime_seconds_todatetime()](unixtime-seconds-todatetimefunction.md).\r\n* Convert unix-epoch milliseconds to UTC datetime using [unixtime_milliseconds_todatetime()](unixtime-milliseconds-todatetimefunction.md).\r\n* Convert unix-epoch nanoseconds to UTC datetime using [unixtime_nanoseconds_todatetime()](unixtime-nanoseconds-todatetimefunction.md).","```\r\nprint date_time = unixtime_microseconds_todatetime(1546300800000000)\r\n```\r\n\r\n|date_time|\r\n|---|\r\n|2019-01-01 00:00:00.0000000|","https://docs.microsoft.com/en-us/azure/kusto/query/unixtime-microseconds-todatetimefunction","unixtime-microseconds-todatetimefunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"unixtime_milliseconds_todatetime","Converts unix-epoch milliseconds to UTC datetime.","## Syntax\r\n\r\n`unixtime_milliseconds_todatetime(*milliseconds*)`\r\n\r\n## Arguments\r\n\r\n* *milliseconds*: A real number represents epoch timestamp in milliseconds. `Datetime` that occurs before the epoch time (1970-01-01 00:00:00) has a negative timestamp value.\r\n\r\n## Returns\r\n\r\nIf the conversion is successful, the result will be a [datetime](./scalar-data-types/datetime.md) value. If conversion is not successful, result will be null.\r\n\r\n## See also\r\n\r\n* Convert unix-epoch seconds to UTC datetime using [unixtime_seconds_todatetime()](unixtime-seconds-todatetimefunction.md).\r\n* Convert unix-epoch microseconds to UTC datetime using [unixtime_microseconds_todatetime()](unixtime-microseconds-todatetimefunction.md).\r\n* Convert unix-epoch nanoseconds to UTC datetime using [unixtime_nanoseconds_todatetime()](unixtime-nanoseconds-todatetimefunction.md).","```\r\nprint date_time = unixtime_milliseconds_todatetime(1546300800000)\r\n```\r\n\r\n|date_time|\r\n|---|\r\n|2019-01-01 00:00:00.0000000|","https://docs.microsoft.com/en-us/azure/kusto/query/unixtime-milliseconds-todatetimefunction","unixtime-milliseconds-todatetimefunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"unixtime_nanoseconds_todatetime","Converts unix-epoch nanoseconds to UTC datetime.","## Syntax\r\n\r\n`unixtime_nanoseconds_todatetime(*nanoseconds*)`\r\n\r\n## Arguments\r\n\r\n* *nanoseconds*: A real number represents epoch timestamp in nanoseconds. `Datetime` that occurs before the epoch time (1970-01-01 00:00:00) has a negative timestamp value.\r\n\r\n## Returns\r\n\r\nIf the conversion is successful, the result will be a [datetime](./scalar-data-types/datetime.md) value. If conversion is not successful, result will be null.\r\n\r\n## See also\r\n\r\n* Convert unix-epoch seconds to UTC datetime using [unixtime_seconds_todatetime()](unixtime-seconds-todatetimefunction.md).\r\n* Convert unix-epoch milliseconds to UTC datetime using [unixtime_milliseconds_todatetime()](unixtime-milliseconds-todatetimefunction.md).\r\n* Convert unix-epoch microseconds to UTC datetime using [unixtime_microseconds_todatetime()](unixtime-microseconds-todatetimefunction.md).","```\r\nprint date_time = unixtime_nanoseconds_todatetime(1546300800000000000)\r\n```\r\n\r\n|date_time|\r\n|---|\r\n|2019-01-01 00:00:00.0000000|","https://docs.microsoft.com/en-us/azure/kusto/query/unixtime-nanoseconds-todatetimefunction","unixtime-nanoseconds-todatetimefunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"unixtime_seconds_todatetime","Converts unix-epoch seconds to UTC datetime.","## Syntax\r\n\r\n`unixtime_seconds_todatetime(*seconds*)`\r\n\r\n## Arguments\r\n\r\n* *seconds*: A real number represents epoch timestamp in seconds. `Datetime` that occurs before the epoch time (1970-01-01 00:00:00) has a negative timestamp value.\r\n\r\n## Returns\r\n\r\nIf the conversion is successful, the result will be a [datetime](./scalar-data-types/datetime.md) value. If conversion is not successful, result will be null.\r\n\r\n## See also\r\n\r\n* Convert unix-epoch milliseconds to UTC datetime using [unixtime_milliseconds_todatetime()](unixtime-milliseconds-todatetimefunction.md).\r\n* Convert unix-epoch microseconds to UTC datetime using [unixtime_microseconds_todatetime()](unixtime-microseconds-todatetimefunction.md).\r\n* Convert unix-epoch nanoseconds to UTC datetime using [unixtime_nanoseconds_todatetime()](unixtime-nanoseconds-todatetimefunction.md).","```\r\nprint date_time = unixtime_seconds_todatetime(1546300800)\r\n```\r\n\r\n|date_time|\r\n|---|\r\n|2019-01-01 00:00:00.0000000|","https://docs.microsoft.com/en-us/azure/kusto/query/unixtime-seconds-todatetimefunction","unixtime-seconds-todatetimefunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"url_decode","The function converts encoded URL into a to regular URL representation.","Detailed information about URL decoding and encoding can be found [here](https://en.wikipedia.org/wiki/Percent-encoding).\r\n\r\n## Syntax\r\n\r\n`url_decode(`*encoded url*`)`\r\n\r\n## Arguments\r\n\r\n* *encoded url*: encoded URL (string).  \r\n\r\n## Returns\r\n\r\nURL (string) in a regular representation.","```\r\nlet url = @'https%3a%2f%2fwww.bing.com%2f';\r\nprint original = url, decoded = url_decode(url)\r\n```\r\n\r\n|original|decoded|\r\n|---|---|\r\n|https%3a%2f%2fwww.bing.com%2f|https://www.bing.com/|","https://docs.microsoft.com/en-us/azure/kusto/query/urldecodefunction","urldecodefunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"url_encode","The function converts characters of the input URL into a format that can be transmitted over the Internet.","Detailed information about URL encoding and decoding can be found [here](https://en.wikipedia.org/wiki/Percent-encoding).\r\nDiffers from [url_encode_component](./urlencodecomponentfunction.md) by encoding spaces as '+' and not as '20%' (see application/x-www-form-urlencoded [here](https://en.wikipedia.org/wiki/Percent-encoding)).\r\n\r\n## Syntax\r\n\r\n`url_encode(`*url*`)`\r\n\r\n## Arguments\r\n\r\n* *url*: input URL (string).  \r\n\r\n## Returns\r\n\r\nURL (string) converted into a format that can be transmitted over the Internet.","```\r\nlet url = @'https://www.bing.com/hello word';\r\nprint original = url, encoded = url_encode(url)\r\n```\r\n\r\n|original|encoded|\r\n|---|---|\r\n|https://www.bing.com/hello word/|https%3a%2f%2fwww.bing.com%2fhello+word|","https://docs.microsoft.com/en-us/azure/kusto/query/urlencodefunction","urlencodefunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"url_encode_component","The function converts characters of the input URL into a format that can be transmitted over the Internet.","Detailed information about URL encoding and decoding can be found [here](https://en.wikipedia.org/wiki/Percent-encoding).\r\nDiffers from [url_encode](./urlencodefunction.md) by encoding spaces as '20%' and not as '+'.\r\n\r\n## Syntax\r\n\r\n`url_encode_component(`*url*`)`\r\n\r\n## Arguments\r\n\r\n* *url*: input URL (string).  \r\n\r\n## Returns\r\n\r\nURL (string) converted into a format that can be transmitted over the Internet.","```\r\nlet url = @'https://www.bing.com/hello word/';\r\nprint original = url, encoded = url_encode_component(url)\r\n```\r\n\r\n|original|encoded|\r\n|---|---|\r\n|https://www.bing.com/hello word/|https%3a%2f%2fwww.bing.com%2fhello%20word|","https://docs.microsoft.com/en-us/azure/kusto/query/urlencodecomponentfunction","urlencodecomponentfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"variance","Calculates the variance of *Expr* across the group, considering the group as a [sample](https://en.wikipedia.org/wiki/Sample_%28statistics%29).","* Used formula:\r\n\r\n![Variance sample](images/variance-aggfunction/variance-sample.png)\r\n\r\n* Can be used only in context of aggregation inside [summarize](summarizeoperator.md)\r\n\r\n## Syntax\r\n\r\nsummarize `variance(`*Expr*`)`\r\n\r\n## Arguments\r\n\r\n* *Expr*: Expression that will be used for aggregation calculation. \r\n\r\n## Returns\r\n\r\nThe variance value of *Expr* across the group.","```\r\nrange x from 1 to 5 step 1\r\n| summarize make_list(x), variance(x) \r\n```\r\n\r\n|list_x|variance_x|\r\n|---|---|\r\n|[ 1, 2, 3, 4, 5]|2.5|","https://docs.microsoft.com/en-us/azure/kusto/query/variance-aggfunction","variance-aggfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"varianceif","Calculates the [variance](variance-aggfunction.md) of *Expr* across the group for which *Predicate* evaluates to `true`.","* Can be used only in context of aggregation inside [summarize](summarizeoperator.md)\r\n\r\n## Syntax\r\n\r\nsummarize `varianceif(`*Expr*`, `*Predicate*`)`\r\n\r\n## Arguments\r\n\r\n* *Expr*: Expression that will be used for aggregation calculation. \r\n* *Predicate*:  predicate that if true, the *Expr* calculated value will be added to the variance.\r\n\r\n## Returns\r\n\r\nThe variance value of *Expr* across the group where *Predicate* evaluates to `true`.","```\r\nrange x from 1 to 100 step 1\r\n| summarize varianceif(x, x%2 == 0)\r\n\r\n```\r\n\r\n|varianceif_x|\r\n|---|\r\n|850|","https://docs.microsoft.com/en-us/azure/kusto/query/varianceif-aggfunction","varianceif-aggfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"variancep","Calculates the variance of *Expr* across the group, considering the group as a [population](https://en.wikipedia.org/wiki/Statistical_population).","* Used formula:\r\n\r\n![Variance population](images/variancep-aggfunction/variance-population.png)\r\n\r\n* Can be used only in context of aggregation inside [summarize](summarizeoperator.md)\r\n\r\n## Syntax\r\n\r\nsummarize `variancep(`*Expr*`)`\r\n\r\n## Arguments\r\n\r\n* *Expr*: Expression that will be used for aggregation calculation. \r\n\r\n## Returns\r\n\r\nThe variance value of *Expr* across the group.","```\r\nrange x from 1 to 5 step 1\r\n| summarize make_list(x), variancep(x) \r\n```\r\n\r\n|list_x|variance_x|\r\n|---|---|\r\n|[ 1, 2, 3, 4, 5]|2|","https://docs.microsoft.com/en-us/azure/kusto/query/variancep-aggfunction","variancep-aggfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"week_of_year","Returns an integer which represents the week number. The week number is calculated from the first week of a year, which is the one that includes the first Thursday, according to [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601#Week_dates).",'```\r\nweek_of_year(datetime("2015-12-14"))\r\n```\r\n\r\n## Syntax\r\n\r\n`week_of_year(`*a_date*`)`\r\n\r\n## Arguments\r\n\r\n* `a_date`: A `datetime`.\r\n\r\n## Returns\r\n\r\n`week number` - The week number that contains the given date.',"|Input                                    |Output|\r\n|-----------------------------------------|------|\r\n|`week_of_year(datetime(2020-12-31))`     |`53`  |\r\n|`week_of_year(datetime(2020-06-15))`     |`25`  |\r\n|`week_of_year(datetime(1970-01-01))`     |`1`   |\r\n|`week_of_year(datetime(2000-01-01))`     |`52`  |\r\n\r\n> [!NOTE]\r\n> `weekofyear()` is an obsolete variant of this function. `weekofyear()` was not ISO 8601 compliant; the first week of a year was defined as the week with the year's first Wednesday in it.\r\nThe current version of this function, `week_of_year()`, is ISO 8601 compliant; the first week of a year is defined as the week with the year's first Thursday in it.","https://docs.microsoft.com/en-us/azure/kusto/query/weekofyearfunction","weekofyearfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"welch_test","Computes the p_value of the [Welch-test function](https://en.wikipedia.org/wiki/Welch%27s_t-test)",'```\r\n// s1, s2 values are from https://en.wikipedia.org/wiki/Welch%27s_t-test\r\nprint\r\n    s1 = dynamic([27.5, 21.0, 19.0, 23.6, 17.0, 17.9, 16.9, 20.1, 21.9, 22.6, 23.1, 19.6, 19.0, 21.7, 21.4]),\r\n    s2 = dynamic([27.1, 22.0, 20.8, 23.4, 23.4, 23.5, 25.8, 22.0, 24.8, 20.2, 21.9, 22.1, 22.9, 20.5, 24.4])\r\n| mv-expand s1 to typeof(double), s2 to typeof(double)\r\n| summarize m1=avg(s1), v1=variance(s1), c1=count(), m2=avg(s2), v2=variance(s2), c2=count()\r\n| extend pValue=welch_test(m1,v1,c1,m2,v2,c2)\r\n// pValue = 0.021\r\n```\r\n\r\n## Syntax\r\n\r\n`welch_test(`*mean1*`, `*variance1*`, `*count1*`, `*mean2*`, `*variance2*`, `*count2*`)`\r\n\r\n## Arguments\r\n\r\n* *mean1*: Expression that represents the mean (average) value of the first series\r\n* *variance1*:  Expression that represents the variance value of the first series\r\n* *count1*:  Expression that represents the count of values in the first series\r\n* *mean2*: Expression that represents the mean (average) value of the second series\r\n* *variance2*:  Expression that represents the variance value of the second series\r\n* *count2*:  Expression that represents the count of values in the second series\r\n\r\n## Returns\r\n\r\nFrom [Wikipedia](https://en.wikipedia.org/wiki/Welch%27s_t-test):\r\n\r\nIn statistics, Welch\'s t-test is a two-sample location test that\'s used to test the hypothesis that two populations have equal means. \r\nWelch\'s t-test is an adaptation of Student\'s t-test, and is more reliable when the two samples have unequal variances and unequal sample sizes. These tests are often referred to as "unpaired" or "independent samples" t-tests. \r\nThe tests are typically applied when the statistical units underlying the two samples being compared are non-overlapping. \r\nWelch\'s t-test is less popular than Student\'s t-test, and may be less familiar to readers. The test is also called "Welch\'s unequal variances t-test", or "unequal variances t-test".',"","https://docs.microsoft.com/en-us/azure/kusto/query/welch-testfunction","")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.OperatorToken,"where","Filters a table to the subset of rows that satisfy a predicate.","```\r\nT | where fruit==\"apple\"\r\n```\r\n\r\n**Alias** `filter`\r\n\r\n## Syntax\r\n\r\n*T* `| where` *Predicate*\r\n\r\n## Arguments\r\n\r\n* *T*: The tabular input whose records are to be filtered.\r\n* *Predicate*: A `boolean` [expression](./scalar-data-types/bool.md) over the columns of *T*. It's evaluated for each row in *T*.\r\n\r\n## Returns\r\n\r\nRows in *T* for which *Predicate* is `true`.\r\n\r\n**Notes**\r\nNull values: all filtering functions return false when compared with null values. \r\nYou can use special null-aware functions to write queries that handle null values.\r\n\r\n[isnull()](./isnullfunction.md),\r\n[isnotnull()](./isnotnullfunction.md),\r\n[isempty()](./isemptyfunction.md),\r\n[isnotempty()](./isnotemptyfunction.md). \r\n\r\n**Tips**\r\n\r\nTo get the fastest performance:\r\n\r\n* **Use simple comparisons** between column names and constants. ('Constant' means constant over the table - so `now()` and `ago()` are OK, and so are scalar values assigned using a [`let` statement](./letstatement.md).)\r\n    For example, prefer `where Timestamp >= ago(1d)` to `where floor(Timestamp, 1d) == ago(1d)`.\r\n* **Simplest terms first**: If you have multiple clauses conjoined with `and`, put first the clauses that involve just one column. So `Timestamp > ago(1d) and OpId == EventId` is better than the other way around.\r\n\r\nFor more information, see the summary of [available String operators](./datatypes-string-operators.md) and the summary of [available Numerical operators](./numoperators.md).",'```\r\nTraces\r\n| where Timestamp > ago(1h)\r\n    and Source == "MyCluster"\r\n    and ActivityId == SubActivityId \r\n```\r\n\r\nThis example retrieves records that are no older than 1 hour,\r\ncome from a source called `MyCluster`, and have two columns of the same value. \r\n\r\nNotice that we put the comparison between two columns last, as it can\'t use the index and forces a scan.\r\n\r\n## Example\r\n\r\n```\r\nTraces | where * has "Kusto"\r\n```\r\n\r\nAll the rows in which the word "Kusto" appears in any column.',"https://docs.microsoft.com/en-us/azure/kusto/query/whereoperator","whereoperator.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"zip","The `zip` function accepts any number of `dynamic` arrays, and returns an\r\narray whose elements are each an array holding the elements of the input\r\narrays of the same index.","## Syntax\r\n\r\n`zip(`*array1*`,` *array2*`, ... )`\r\n\r\n## Arguments\r\n\r\nBetween 2 and 16 dynamic arrays.",'The following example returns `[[1,2],[3,4],[5,6]]`:\r\n\r\n```\r\nprint zip(dynamic([1,3,5]), dynamic([2,4,6]))\r\n```\r\n\r\nThe following example returns `[["A",{}], [1,"B"], [1.5, null]]`:\r\n\r\n```\r\nprint zip(dynamic(["A", 1, 1.5]), dynamic([{}, "B"]))\r\n```\r\n\r\nThe following example returns `[[1,"one"],[2,"two"],[3,"three"]]`:\r\n\r\n```\r\ndatatable(a:int, b:string) [1,"one",2,"two",3,"three"]\r\n| summarize a = make_list(a), b = make_list(b)\r\n| project zip(a, b)\r\n```',"https://docs.microsoft.com/en-us/azure/kusto/query/zipfunction","zipfunction.md")))}}}),Bridge.ns("Kusto.Data.IntelliSense.CslDocumentation",e.$),Bridge.apply(e.$.Kusto.Data.IntelliSense.CslDocumentation,{f1:function(e){return e.value}}),Bridge.define("Kusto.Data.IntelliSense.CslQueryIntelliSenseRulesProvider.ResolveResult",{$kind:"nested enum",statics:{fields:{None:0,AppendEntities:1,ReplaceEntities:2}}}),Bridge.define("Kusto.Data.IntelliSense.CslTopicDocumentation",{props:{TokenKind:0,Name:null,ShortDescription:null,LongDescription:null,Examples:null,Url:null,MarkdownSource:null},ctors:{ctor:function(e,t,n,s,i,r,a){void 0===r&&(r=null),void 0===a&&(a=null),this.$initialize(),this.TokenKind=e,this.Name=t,this.ShortDescription=n,this.LongDescription=s,this.Examples=i,this.Url=r,this.MarkdownSource=a}},methods:{GetMarkDownText:function(){var e,t,n=new System.Text.StringBuilder;n.appendFormat(System.String.format("## [{0}]({1})",this.Name,this.Url)),n.appendLine(),n.appendLine(),e=Bridge.getEnumerator(System.Array.init([this.ShortDescription,this.LongDescription,this.Examples],System.String));try{for(;e.moveNext();)t=e.Current,System.String.isNullOrEmpty(t)||(n.appendLine(t),n.appendLine())}finally{Bridge.is(e,System.IDisposable)&&e.System$IDisposable$Dispose()}return n.toString()},equals:function(e){if(null==e)return!1;var t=Bridge.as(e,Kusto.Data.IntelliSense.CslTopicDocumentation);return null!=t&&(this.TokenKind===t.TokenKind&&Bridge.referenceEquals(this.Name,t.Name)&&Bridge.referenceEquals(this.ShortDescription,t.ShortDescription)&&Bridge.referenceEquals(this.Examples,t.Examples))},getHashCode:function(){var e,t,n,s;return Bridge.getHashCode(this.TokenKind)^Bridge.getHashCode(this.Name)^(null!=(e=null!=(t=this.ShortDescription)?Bridge.getHashCode(t):null)?e:0)^(null!=(n=null!=(s=this.Examples)?Bridge.getHashCode(s):null)?n:0)}}}),Bridge.define("Kusto.Data.IntelliSense.DMRuleKind",{$kind:"enum",statics:{fields:{None:0,Start:0,YieldAdminCommandsOptions:0,YieldShowCommandOptions:1,YieldShowClustersKeywordOptions:2,YieldShowClustersSettingsKeywordOptions:3,YieldShowClustersSettingsVersionKeywordOptions:4,YieldShowClustersSettingsWithEncryptedSecretsKeywordOptions:5,YieldShowPrincipalRolesCommandOptions:6,YieldAlterCommandOptions:7,YieldAlterMergeCommandOptions:8,YieldAlterClustersSettingsKeywordOptions:9,YieldCreateCommandOptions:10,YieldDropCommandOptions:11,YieldAddCommandOptions:12,YieldAddOrAlterCommandOptions:13,YieldAddDataObtainerKeyworkOptions:14,YieldAddDataObtainerInitializeKeyworkOptions:15,YieldAddDataObtainerInitializeWithKeyworkOptions:16,YieldGetCommandOptions:17,YieldGetIngestionQueuesCommandOptions:18,YieldGetIngestionQueuesTypeCommandOptions:19,YieldFlushCommandOptions:20,YieldInitializeCommandOptions:21,YieldInitializeClusterConfigCommandOptions:22,YieldInitializeClusterConfigEncryptionCommandOptions:23,YieldResetCommandOptions:24,YieldSetCommandOptions:25,YieldAlterClustersSettingsFromKeywordOptions:26,YieldAlterObtainerQueuesOptions:27,YieldAddOrAlterEventHubIngestionSourceSettingsOptions:28,YieldPurgeShowCommandOptions:29,YieldPurgeShowCommandFromKeywordOptions:30,YieldPurgeShowCommandToKeywordOptions:31,YieldPurgeTableCommandOptions:32,YieldPurgeTableInDatabaseCommandOptions:33,YieldPurgeRetryCommandOptions:34,YieldPurgeRetryCommandFromKeywordOptions:35,YieldPurgeRetryCommandToKeywordOptions:36,YieldPurgeCancelCommandOptions:37,RefreshPolicyCacheCommandOptions:38},ctors:{init:function(){this.None=Kusto.Data.IntelliSense.RuleKind.None,this.Start=Kusto.Data.IntelliSense.RuleKind.Last}}}}),Bridge.define("Kusto.Data.IntelliSense.EntityDataType",{$kind:"enum",statics:{fields:{Empty:0,Object:1,DBNull:2,Boolean:3,Char:4,SByte:5,Byte:6,Int16:7,UInt16:8,Int32:9,UInt32:10,Int64:11,UInt64:12,Single:13,Double:14,Decimal:15,DateTime:16,String:18,Dynamic:19,TimeSpan:20}}}),Bridge.define("Kusto.Data.IntelliSense.EntityDataTypeConverter",{statics:{methods:{FromType:function(e){var t={v:Kusto.Data.IntelliSense.EntityDataType.String};return System.Enum.tryParse(Kusto.Data.IntelliSense.EntityDataType,e,t)||Bridge.referenceEquals(e,"Guid")&&(t.v=Kusto.Data.IntelliSense.EntityDataType.String),t.v}}}}),Bridge.define("Kusto.Data.IntelliSense.ExpressionEntity",{fields:{Operator:null,Name:null,Arguments:null,IsGenerated:!1},ctors:{init:function(){this.IsGenerated=!1}},methods:{FirstArgument:function(){return Kusto.Cloud.Platform.Utils.ExtendedEnumerable.SafeFastAny$2(System.String,this.Arguments)?System.Linq.Enumerable.from(this.Arguments,System.String).first():""}}}),Bridge.define("Kusto.Data.IntelliSense.ExpressionEntityParser",{statics:{methods:{ParseEntities:function(e){return Kusto.Data.IntelliSense.ExpressionEntityParser.ParseEntitiesList(Kusto.Data.IntelliSense.ExpressionEntity,e,Kusto.Data.IntelliSense.ExpressionEntityParser.ParseEntityExpression)},ParseEntities$1:function(e,t){return Kusto.Data.IntelliSense.ExpressionEntityParser.ParseEntitiesList(Kusto.Data.IntelliSense.ExpressionEntity,e,Kusto.Data.IntelliSense.ExpressionEntityParser.ParseEntityExpression,t)},ParseEntitiesList:function(e,t,n,s){var i,r,a,o,l;if(void 0===s&&(s=null),i=new(System.Collections.Generic.List$1(e).ctor),System.String.isNullOrWhiteSpace(t))return i;var u=0,d=System.String.toCharArray(t,0,t.length),m=0,c={v:0},p=-1;for(r=0;r<d.length;r=r+1|0)if(a=d[System.Array.index(r,d)],0===u){if(m=r,61===a)u=2,p=r+1|0;else if(System.Char.isDigit(a)||System.Char.isLetter(a)||42===a)c.v=0,u=1,p=r;else if(91===a)r=Kusto.Data.IntelliSense.ExpressionEntityParser.IndexOfClosingBracket(d,93,r+1|0),c.v=i.Count,Kusto.Data.IntelliSense.ExpressionEntityParser.AddEntity(e,t,i,m,r,n),c.v=i.Count-c.v|0;else if(40===a)r=Kusto.Data.IntelliSense.ExpressionEntityParser.IndexOfClosingBracket(d,41,r+1|0),c.v=i.Count,Kusto.Data.IntelliSense.ExpressionEntityParser.AddEntity(e,t,i,m,r,n),c.v=i.Count-c.v|0;else if(41===a){Kusto.Data.IntelliSense.ExpressionEntityParser.AddEntity(e,t,i,m,r,n);break}r===(d.length-1|0)&&(r=r-1|0,0===u&&(u=1))}else if(1===u){if(c.v=0,61===a)Kusto.Data.IntelliSense.ExpressionEntityParser.AddEntity(e,t,i,m,r-1|0,n),u=2;else if(44===a)Kusto.Data.IntelliSense.ExpressionEntityParser.AddEntity(e,t,i,m,r-1|0,n),u=0;else if(40===a){if(o=Kusto.Data.IntelliSense.ExpressionEntityParser.IndexOfClosingBracket(d,41,r+1|0),Kusto.Data.IntelliSense.ExpressionEntityParser.GenerateMultipleColumnOutput(e,t,r,p,o,c,i,n,s)){r=o+1|0,u=0;continue}r=o}r===(d.length-1|0)&&Kusto.Data.IntelliSense.ExpressionEntityParser.AddEntity(e,t,i,m,r,n)}else if(2===u)if(44===a)c.v=0,u=0;else if(40===a)l=Kusto.Data.IntelliSense.ExpressionEntityParser.IndexOfClosingBracket(d,41,r+1|0),Kusto.Data.IntelliSense.ExpressionEntityParser.GenerateMultipleColumnOutput(e,t,r,p,l,c,i,n,s),r=l;else if(41===a)break;return i},GenerateMultipleColumnOutput:function(e,t,n,s,i,r,a,o,l){var u,d=!1;return Bridge.staticEquals(l,null)||-1===s||(u=new(System.Collections.Generic.List$1(e).ctor),Kusto.Data.IntelliSense.ExpressionEntityParser.AddEntity(e,t,u,n,i,o),d=l(t.substr(s,n-s|0).trim(),u,r.v,a),r.v=0,s=-1),d},AddEntity:function(e,t,n,s,i,r){var a,o,l=1+(i-s|0)|0;l<=0||(a=(s+l|0)>=t.length?t.substr(s):t.substr(s,l),o=r(a=Kusto.Data.IntelliSense.ExpressionEntityParser.UnescapeEntityName(a)),n.AddRange(o))},UnescapeEntityName:function(e){return e=e.trim(),e=Kusto.Cloud.Platform.Utils.ExtendedString.TrimBalancedSquareBrackets(e),Kusto.Cloud.Platform.Utils.ExtendedString.TrimBalancedSingleAndDoubleQuotes(e)},NormalizeEntityName:function(e){var t,n;if(System.String.isNullOrEmpty(e))return"";if(!System.Linq.Enumerable.from(e,System.Char).contains(46)&&!System.Linq.Enumerable.from(e,System.Char).contains(91))return e;var s=new System.Text.StringBuilder,i=System.String.toCharArray(e,0,e.length),r=0;for(t=0;t<i.length;t=t+1|0)switch(n=i[System.Array.index(t,i)],r){case 0:46===n?(s.append("_"),r=1):91===n?(s.append("_"),r=2):s.append(String.fromCharCode(n));break;case 1:91!==n&&s.append(String.fromCharCode(n)),r=2;break;case 2:if(39===n||34===n){var a=t+1|0,o=Kusto.Data.IntelliSense.ExpressionEntityParser.ConsumeTill(i,a,n),l=e.substr(a,o-a|0);l=System.String.replaceAll(l,String.fromCharCode(32),String.fromCharCode(95)),s.append(l),t=o}else 93===n?r=0:s.append(String.fromCharCode(n))}return s.toString()},ConsumeTill:function(e,t,n){for(var s=t;s<e.length;s=s+1|0)if(e[System.Array.index(s,e)]===n)return s;return e.length},ParseEntityExpression:function(t){var n,s,i,r,a,o,l=System.String.indexOf(t,String.fromCharCode(61)),u=System.String.indexOf(t,String.fromCharCode(40));if(l>0&&(u<0||l<u))return s=Kusto.Data.IntelliSense.ExpressionEntityParser.NormalizeEntityName(t.substr(0,l).trim()),System.Array.init([(n=new Kusto.Data.IntelliSense.ExpressionEntity,n.Name=s,n)],Kusto.Data.IntelliSense.ExpressionEntity);if(u<0)return(i=System.String.indexOf(t,String.fromCharCode(41)))>=0&&(t=t.substr(0,i)),r=Kusto.Data.IntelliSense.ExpressionEntityParser.NormalizeEntityName(t.trim()),System.Array.init([(n=new Kusto.Data.IntelliSense.ExpressionEntity,n.Name=r,n)],Kusto.Data.IntelliSense.ExpressionEntity);if(0===u)return a=Kusto.Cloud.Platform.Utils.ExtendedString.TrimBalancedRoundBrackets(t),o=Kusto.Data.IntelliSense.ExpressionEntityParser.ParseEntitiesList(System.String,a,e.$.Kusto.Data.IntelliSense.ExpressionEntityParser.f1),System.Linq.Enumerable.from(o,System.String).select(e.$.Kusto.Data.IntelliSense.ExpressionEntityParser.f2);var d=t.substr(0,u).trim(),m=Kusto.Cloud.Platform.Utils.ExtendedString.TrimBalancedRoundBrackets(t.substr(u)),c=Kusto.Data.IntelliSense.ExpressionEntityParser.ParseEntitiesList(System.String,m,e.$.Kusto.Data.IntelliSense.ExpressionEntityParser.f1),p=((n=new Kusto.Data.IntelliSense.ExpressionEntity).Operator=d,n);return System.Linq.Enumerable.from(c,System.String).any()&&(p.Name=Kusto.Cloud.Platform.Utils.ExtendedString.TrimBalancedRoundBrackets(c.getItem(0)),p.Arguments=System.Linq.Enumerable.from(c,System.String).skip(1).ToArray(System.String)),System.Array.init([p],Kusto.Data.IntelliSense.ExpressionEntity)},IndexOfClosingBracket:function(e,t,n){for(var s,i=n;i<e.length;i=i+1|0)if(40===(s=e[System.Array.index(i,e)]))i=Kusto.Data.IntelliSense.ExpressionEntityParser.IndexOfClosingBracket(e,41,i+1|0);else if(91===s)i=Kusto.Data.IntelliSense.ExpressionEntityParser.IndexOfClosingBracket(e,93,i+1|0);else if(s===t)return i;return e.length}}}}),Bridge.ns("Kusto.Data.IntelliSense.ExpressionEntityParser",e.$),Bridge.apply(e.$.Kusto.Data.IntelliSense.ExpressionEntityParser,{f1:function(e){return System.Array.init([e.trim()],System.String)},f2:function(e){var t;return(t=new Kusto.Data.IntelliSense.ExpressionEntity).Name=Kusto.Data.IntelliSense.ExpressionEntityParser.NormalizeEntityName(e),t}}),Bridge.define("Kusto.Data.IntelliSense.IKustoIntelliSenseSchemaResolver",{$kind:"interface"}),Bridge.define("Kusto.Data.IntelliSense.IntelliSenseCommandTip",{fields:{m_signature:null},props:{Name:null,Signature:{get:function(){if(System.String.isNullOrEmpty(this.m_signature))if(null!=this.NameSuffix)this.m_signature=(this.Name||"")+(this.NameSuffix||"");else if(null!=this.Parameters&&System.Linq.Enumerable.from(this.Parameters,Kusto.Data.IntelliSense.IntelliSenseCommandTipParameter).any()){var t=Bridge.toArray(System.Linq.Enumerable.from(this.Parameters,Kusto.Data.IntelliSense.IntelliSenseCommandTipParameter).select(e.$.Kusto.Data.IntelliSense.IntelliSenseCommandTip.f1)).join(", ");this.m_signature=System.String.format("<b>{0}(</b>{1}<b>)</b>",this.Name,t)}else this.m_signature=(this.Name||"")+"()";return this.m_signature}},Summary:null,Usage:null,NameSuffix:null,Parameters:null},methods:{GetSignatureWithBoldParameter:function(t){var n,s,i,r,a,o;return null!=this.Parameters&&System.Linq.Enumerable.from(this.Parameters,Kusto.Data.IntelliSense.IntelliSenseCommandTipParameter).any()?System.Linq.Enumerable.from(this.Parameters,Kusto.Data.IntelliSense.IntelliSenseCommandTipParameter).count()>t?(r=System.Array.init([System.String.format("<b>{0}</b>",[(s=Kusto.Data.IntelliSense.IntelliSenseCommandTipParameter,n=System.Linq.Enumerable.from(this.Parameters,s).ToArray(s))[System.Array.index(t,n)].PlainSignature])],System.String),a=Bridge.toArray(System.Linq.Enumerable.from(this.Parameters,Kusto.Data.IntelliSense.IntelliSenseCommandTipParameter).take(t).select(e.$.Kusto.Data.IntelliSense.IntelliSenseCommandTip.f2).concat(r).concat(System.Linq.Enumerable.from(this.Parameters,Kusto.Data.IntelliSense.IntelliSenseCommandTipParameter).skip(t+1|0).select(e.$.Kusto.Data.IntelliSense.IntelliSenseCommandTip.f2))).join(", "),i=System.String.format('<font color="blue"><b>{0}</font>(</b>{1}<b>)</b>',this.Name,a)):(o=Bridge.toArray(System.Linq.Enumerable.from(this.Parameters,Kusto.Data.IntelliSense.IntelliSenseCommandTipParameter).select(e.$.Kusto.Data.IntelliSense.IntelliSenseCommandTip.f2)).join(", "),i=System.String.format('<font color="blue"><b>{0}</font>(</b>{1}<b>)</b>',this.Name,o)):i=null!=this.NameSuffix?(this.Name||"")+(this.NameSuffix||""):(this.Name||"")+"()",i},Clone:function(){var t,n=null!=this.Parameters&&System.Linq.Enumerable.from(this.Parameters,Kusto.Data.IntelliSense.IntelliSenseCommandTipParameter).any()?System.Linq.Enumerable.from(this.Parameters,Kusto.Data.IntelliSense.IntelliSenseCommandTipParameter).select(e.$.Kusto.Data.IntelliSense.IntelliSenseCommandTip.f3).ToArray(Kusto.Data.IntelliSense.IntelliSenseCommandTipParameter):null;return(t=new Kusto.Data.IntelliSense.IntelliSenseCommandTip).Name=this.Name,t.NameSuffix=this.NameSuffix,t.Parameters=n,t.Summary=this.Summary,t.Usage=this.Usage,t}}}),Bridge.ns("Kusto.Data.IntelliSense.IntelliSenseCommandTip",e.$),Bridge.apply(e.$.Kusto.Data.IntelliSense.IntelliSenseCommandTip,{f1:function(e){return e.Singature},f2:function(e){return e.PlainSignature},f3:function(e){return e.Clone()}}),Bridge.define("Kusto.Data.IntelliSense.IntelliSenseCommandTipParameter",{props:{Name:null,Description:null,DataType:null,Optional:!1,IsArgsArray:!1,Singature:{get:function(){return this.IsArgsArray?"...":System.String.format("<b>{0}{1}</b> <i>{2}</i>",this.Optional?"[?] ":"",this.DataType,this.Name)}},PlainSignature:{get:function(){return this.IsArgsArray?"...":System.String.format('{0}<font color="blue">{1}</font> <i>{2}</i>',this.Optional?"[?] ":"",this.DataType,this.Name)}}},methods:{Clone:function(){var e;return(e=new Kusto.Data.IntelliSense.IntelliSenseCommandTipParameter).DataType=this.DataType,e.Description=this.Description,e.IsArgsArray=this.IsArgsArray,e.Name=this.Name,e.Optional=this.Optional,e}}}),Bridge.define("Kusto.Data.IntelliSense.IntelliSenseRulesProviderBase.PrivateTracer",{$kind:"nested class",statics:{fields:{Tracer:null},ctors:{init:function(){this.Tracer=new Kusto.Data.IntelliSense.IntelliSenseRulesProviderBase.PrivateTracer}}},methods:{TraceVerbose:function(e,t){void 0===t&&(t=[])}}}),Bridge.define("Kusto.Data.IntelliSense.KustoCommandContext",{inherits:function(){return[System.IEquatable$1(Kusto.Data.IntelliSense.KustoCommandContext)]},statics:{fields:{Empty:null},ctors:{init:function(){this.Empty=new Kusto.Data.IntelliSense.KustoCommandContext("")}}},props:{Context:null,Operation:0},alias:["equalsT","System$IEquatable$1$Kusto$Data$IntelliSense$KustoCommandContext$equalsT"],ctors:{ctor:function(e,t){void 0===t&&(t=0),this.$initialize(),this.Context=e,this.Operation=t}},methods:{equalsT:function(e){return null!=e&&System.String.equals(e.Context,this.Context)&&e.Operation===this.Operation},getHashCode:function(){return Bridge.getHashCode(this.Context)^Bridge.getHashCode(this.Operation)},Flatten:function(){return System.Linq.Enumerable.from(System.String.split(this.Context,System.Array.init([44],System.Char).map((function(e){return String.fromCharCode(e)})),null,1),System.String).select(Bridge.fn.bind(this,e.$.Kusto.Data.IntelliSense.KustoCommandContext.f1)).ToArray(Kusto.Data.IntelliSense.KustoCommandContext)},IsEmpty:function(){return System.String.isNullOrEmpty(this.Context)}}}),Bridge.ns("Kusto.Data.IntelliSense.KustoCommandContext",e.$),Bridge.apply(e.$.Kusto.Data.IntelliSense.KustoCommandContext,{f1:function(e){return new Kusto.Data.IntelliSense.KustoCommandContext(e.trim(),this.Operation)}}),Bridge.define("Kusto.Data.IntelliSense.KustoIntelliSenseAccountEntity",{props:{Name:null}}),Bridge.define("Kusto.Data.IntelliSense.KustoIntelliSenseClusterEntity",{props:{ConnectionString:null,Alias:null,Databases:null,Plugins:null},methods:{Clone:function(){var t,n,s;return(t=new Kusto.Data.IntelliSense.KustoIntelliSenseClusterEntity).ConnectionString=this.ConnectionString,t.Alias=this.Alias,t.Databases=null!=(n=this.Databases)?System.Linq.Enumerable.from(n,Kusto.Data.IntelliSense.KustoIntelliSenseDatabaseEntity).select(e.$.Kusto.Data.IntelliSense.KustoIntelliSenseClusterEntity.f1).ToArray(Kusto.Data.IntelliSense.KustoIntelliSenseDatabaseEntity):null,t.Plugins=null!=(s=this.Plugins)?System.Linq.Enumerable.from(s,Kusto.Data.IntelliSense.KustoIntelliSensePluginEntity).select(e.$.Kusto.Data.IntelliSense.KustoIntelliSenseClusterEntity.f2).ToArray(Kusto.Data.IntelliSense.KustoIntelliSensePluginEntity):null,t}}}),Bridge.ns("Kusto.Data.IntelliSense.KustoIntelliSenseClusterEntity",e.$),Bridge.apply(e.$.Kusto.Data.IntelliSense.KustoIntelliSenseClusterEntity,{f1:function(e){return e.Clone()},f2:function(e){return e.Clone()}}),Bridge.define("Kusto.Data.IntelliSense.KustoIntelliSenseColumnEntity",{props:{Name:null,TypeCode:0},methods:{Clone:function(){var e;return(e=new Kusto.Data.IntelliSense.KustoIntelliSenseColumnEntity).Name=this.Name,e.TypeCode=this.TypeCode,e}}}),Bridge.define("Kusto.Data.IntelliSense.KustoIntelliSenseDatabaseEntity",{props:{Name:null,Alias:null,Tables:null,Functions:null,IsInitialized:!1},methods:{Clone:function(){var t,n,s;return(t=new Kusto.Data.IntelliSense.KustoIntelliSenseDatabaseEntity).Name=this.Name,t.Alias=this.Alias,t.Tables=null!=(n=this.Tables)?System.Linq.Enumerable.from(n,Kusto.Data.IntelliSense.KustoIntelliSenseTableEntity).select(e.$.Kusto.Data.IntelliSense.KustoIntelliSenseDatabaseEntity.f1).ToArray(Kusto.Data.IntelliSense.KustoIntelliSenseTableEntity):null,t.Functions=null!=(s=this.Functions)?System.Linq.Enumerable.from(s,Kusto.Data.IntelliSense.KustoIntelliSenseFunctionEntity).select(e.$.Kusto.Data.IntelliSense.KustoIntelliSenseDatabaseEntity.f2).ToArray(Kusto.Data.IntelliSense.KustoIntelliSenseFunctionEntity):null,t.IsInitialized=this.IsInitialized,t}}}),Bridge.ns("Kusto.Data.IntelliSense.KustoIntelliSenseDatabaseEntity",e.$),Bridge.apply(e.$.Kusto.Data.IntelliSense.KustoIntelliSenseDatabaseEntity,{f1:function(e){return e.Clone()},f2:function(e){return e.Clone()}}),Bridge.define("Kusto.Data.IntelliSense.KustoIntelliSenseFunctionEntity",{props:{Name:null,CallName:null,Expression:null},methods:{Clone:function(){var e;return(e=new Kusto.Data.IntelliSense.KustoIntelliSenseFunctionEntity).Name=this.Name,e.CallName=this.CallName,e.Expression=this.Expression,e}}}),Bridge.define("Kusto.Data.IntelliSense.KustoIntelliSensePluginEntity",{props:{Name:null},methods:{Clone:function(){var e;return(e=new Kusto.Data.IntelliSense.KustoIntelliSensePluginEntity).Name=this.Name,e}}}),Bridge.define("Kusto.Data.IntelliSense.KustoIntelliSenseQuerySchema",{props:{Cluster:null,Database:null},ctors:{ctor:function(e,t){this.$initialize(),this.Cluster=e,this.Database=t}},methods:{Clone:function(){return new Kusto.Data.IntelliSense.KustoIntelliSenseQuerySchema(null!=this.Cluster?this.Cluster.Clone():null,null!=this.Database?this.Database.Clone():null)}}}),Bridge.define("Kusto.Data.IntelliSense.KustoIntelliSenseServiceEntity",{props:{Name:null}}),Bridge.define("Kusto.Data.IntelliSense.KustoIntelliSenseTableEntity",{props:{Name:null,IsInvisible:!1,Columns:null},methods:{Clone:function(){var t,n;return(t=new Kusto.Data.IntelliSense.KustoIntelliSenseTableEntity).Name=this.Name,t.Columns=null!=(n=this.Columns)?System.Linq.Enumerable.from(n,Kusto.Data.IntelliSense.KustoIntelliSenseColumnEntity).select(e.$.Kusto.Data.IntelliSense.KustoIntelliSenseTableEntity.f1).ToArray(Kusto.Data.IntelliSense.KustoIntelliSenseColumnEntity):null,t.IsInvisible=this.IsInvisible,t}}}),Bridge.ns("Kusto.Data.IntelliSense.KustoIntelliSenseTableEntity",e.$),Bridge.apply(e.$.Kusto.Data.IntelliSense.KustoIntelliSenseTableEntity,{f1:function(e){return e.Clone()}}),Bridge.define("Kusto.Data.IntelliSense.OptionKind",{$kind:"enum",statics:{fields:{None:0,Operator:1,Command:2,Service:3,Policy:4,Database:5,Table:6,DataType:7,Literal:8,Parameter:9,IngestionMapping:10,ExpressionFunction:11,Option:12,OptionKind:13,OptionRender:14,Column:15,ColumnString:16,ColumnNumeric:17,ColumnDateTime:18,ColumnTimespan:19,FunctionLocal:20,FunctionServerSide:21,FunctionAggregation:22,FunctionFilter:23,FunctionScalar:24,ClientDirective:25,MaterializedView:26}}}),Bridge.define("Kusto.Data.IntelliSense.ParseMode",{$kind:"enum",statics:{fields:{CommandTokensOnly:0,TokenizeAllText:1}}}),Bridge.define("Kusto.Data.IntelliSense.RuleKind",{$kind:"enum",statics:{fields:{None:0,YieldColumnNamesForFilter:1,YieldColumnNamesForProject:2,YieldColumnNamesForProjectAway:3,YieldColumnNamesForProjectRename:4,YieldColumnNamesForJoin:5,YieldKindFlavorsForJoin:6,YieldKindFlavorsForReduceBy:7,YieldColumnNamesForOrdering:8,YieldColumnNamesForTwoParamFunctions:9,YieldColumnNamesForThreeParamFunctions:10,YieldColumnNamesForManyParamFunctions:11,YieldColumnNamesAndFunctionsForExtend:12,YieldColumnNamesForMakeSeries:13,YieldTableNames:14,YieldTableNamesForFindIn:15,YieldRenderOptions:16,YieldRenderKindKeywordOption:17,YieldRenderKindOptions:18,YieldOperatorsAfterPipe:19,YieldStringComparisonOptions:20,YieldNumericComparisonOptions:21,YieldDateTimeOperatorsOptions:22,YieldSummarizeOperatorOptions:23,YieldAscendingDescendingOptions:24,YieldNumericScalarOptions:25,YieldByKeywordOptions:26,YieldWithKeywordOptions:27,YieldStarOption:28,YieldParseTypesKeywordOptions:29,YieldColumnNamesForParse:30,YieldColumnNamesForDiffPatternsPluginSplitParameter:31,YieldParseKeywordKindsOptions:32,YieldRangeFromOptions:33,YieldRangeFromToOptions:34,YieldRangeFromToStepOptions:35,YieldQueryParameters:36,YieldEvaluateOperatorOptions:37,YieldPostJoinOptions:38,YieldPostFindInOptions:39,YieldPostFindOptions:40,YieldTopNestedOfKeywordOption:41,YieldTopNestedOthersOption:42,YieldTopNestedKeywordOption:43,YieldTopHittersKeywordOption:44,YieldTimespanOptions:45,YieldDatabaseNamesOptions:46,YieldClusterNamesOptions:47,YieldDatabaseFunctionOption:48,YieldNullsFirstNullsLastOptions:49,YieldTableNamesForRemoteQueryOptions:50,YieldColumnNamesForRender:51,YieldColumnNamesForFilterInFind:52,YieldColumnNamesForProjectInFind:53,YieldEndOrContinueFindInOptions:54,YieldPostFindInListOptions:55,YieldFindProjectSmartOptions:56,YieldMakeSeriesOperatorOptions:57,YieldMakeSeriesOperatorForDefaultOrOn:58,YieldMakeSeriesOperatorForOn:59,YieldMakeSeriesOperatorForRange:60,YieldMakeSeriesOperatorForBy:61,YieldPostSearchOptions:62,YieldPostSearchKindOptions:63,YieldSearchKindOptions:64,YieldInsideSearchOptions:65,YieldClientDirectivesOptions:66,YieldClientDirective_ConnectOptions:67,Last:68}}}),Bridge.define("Kusto.Data.Net.Common.ExtendedKustoDataStreamFormat",{statics:{methods:{FastToString:function(e){switch(e){case Kusto.Data.Net.Common.KustoDataStreamFormat.KustoJsonDataStream:return"KustoJsonDataStream";case Kusto.Data.Net.Common.KustoDataStreamFormat.KustoDataStream:return"KustoDataStream"}return System.String.format("[unknown: {0}]",[Bridge.box(e,System.Int32)])},FastIsDefined$1:function(e){var t={v:new Kusto.Data.Net.Common.KustoDataStreamFormat};return Kusto.Data.Net.Common.ExtendedKustoDataStreamFormat.FastTryParse(e,t,!1,!0)},FastIsDefined:function(e){switch(e){case Kusto.Data.Net.Common.KustoDataStreamFormat.KustoJsonDataStream:case Kusto.Data.Net.Common.KustoDataStreamFormat.KustoDataStream:return!0;default:return!1}},FastHasFlag$1:function(e,t){return(e&t)===t},FastHasFlag:function(e,t){return(e&t)===t},FastParse:function(e,t){void 0===t&&(t=!1);var n={v:new Kusto.Data.Net.Common.KustoDataStreamFormat};if(Kusto.Data.Net.Common.ExtendedKustoDataStreamFormat.FastTryParse(e,n,t))return n.v;throw new System.Exception("Invalid enum value: "+(e||""))},FastTryParse:function(e,t,n,s){switch(void 0===n&&(n=!1),void 0===s&&(s=!1),e){case"0":case"KustoJsonDataStream":return t.v=Kusto.Data.Net.Common.KustoDataStreamFormat.KustoJsonDataStream,!0;case"1":case"KustoDataStream":return t.v=Kusto.Data.Net.Common.KustoDataStreamFormat.KustoDataStream,!0}if(n&&!System.String.isNullOrEmpty(e))switch(e.toLowerCase()){case"kustojsondatastream":return t.v=Kusto.Data.Net.Common.KustoDataStreamFormat.KustoJsonDataStream,!0;case"kustodatastream":return t.v=Kusto.Data.Net.Common.KustoDataStreamFormat.KustoDataStream,!0}if(!s){var i={v:0};if(System.Int32.tryParse(e,i))return t.v=i.v,!0}return t.v=0,!1},FastGetDescription:function(e){switch(e){case Kusto.Data.Net.Common.KustoDataStreamFormat.KustoJsonDataStream:return"JSON representation of the Kusto Data Stream (stable).";case Kusto.Data.Net.Common.KustoDataStreamFormat.KustoDataStream:return"Binary data stream emitted by the Kusto engine. For internal use only (may change with no notice).";default:return null}}}}}),Bridge.define("Kusto.Data.Net.Common.ExtendedRemoteServiceType",{statics:{methods:{FastToString:function(e){switch(e){case Kusto.Data.Net.Common.RemoteServiceType.Admin:return"Admin";case Kusto.Data.Net.Common.RemoteServiceType.Query:return"Query";case Kusto.Data.Net.Common.RemoteServiceType.UIRedirect:return"UIRedirect";case Kusto.Data.Net.Common.RemoteServiceType.DataManagement:return"DataManagement";case Kusto.Data.Net.Common.RemoteServiceType.ClusterManagement:return"ClusterManagement";case Kusto.Data.Net.Common.RemoteServiceType.Bridge:return"Bridge";case Kusto.Data.Net.Common.RemoteServiceType.Ping:return"Ping";case Kusto.Data.Net.Common.RemoteServiceType.CustomType:return"CustomType";case Kusto.Data.Net.Common.RemoteServiceType.StreamIngest:return"StreamIngest";case Kusto.Data.Net.Common.RemoteServiceType.PassiveLogin:return"PassiveLogin";case Kusto.Data.Net.Common.RemoteServiceType.ArmR