import { SelectableValue } from '@grafana/data';

export const daysOfWeek: Array<SelectableValue<string>> = [
  { value: 'monday', label: 'Monday' },
  { value: 'tuesday', label: 'Tuesday' },
  { value: 'wednesday', label: 'Wednesday' },
  { value: 'thursday', label: 'Thursday' },
  { value: 'friday', label: 'Friday' },
  { value: 'saturday', label: 'Saturday' },
  { value: 'sunday', label: 'Sunday' },
];

export interface ReportsState {
  reports: Report[];
  report: Report;
  hasFetchedList: boolean;
  hasFetchedSingle: boolean;
  searchQuery: string;
  reportCount: number;
  isLoading: boolean;
}

export interface Report {
  id: number;
  name: string;
  schedule: SchedulingOptions;
  dashboardId: number;
  dashboardName: string;
  recipients: string;
  message: string;
  replyTo: string;
  options: ReportOptions;
}

export interface ReportDTO {
  id?: number;
  name: string;
  dashboardId: number;
  recipients: string;
  replyTo: string;
  message: string;
  schedule: SchedulingOptions;
  options: ReportOptions;
}

export enum SchedulingFrequency {
  Weekly = 'weekly',
  Daily = 'daily',
  Hourly = 'hourly',
  Never = 'never',
}

export interface SchedulingOptions {
  frequency: SchedulingFrequency;
  day: string;
  hour?: number;
  minute: number;
  timeZone: string;
}

export interface ReportOptions {
  landscape: boolean;
}

export const reportLayouts: SelectableValue[] = [
  { value: 'portrait', label: 'Portrait' },
  { value: 'landscape', label: 'Landscape' },
];
