import tinycolor from 'tinycolor2';

function hoverColor(color, theme) {
  return theme.isDark ? tinycolor(color).brighten(2).toString() : tinycolor(color).darken(2).toString();
}
function mediaUp(breakpoint) {
  return `only screen and (min-width: ${breakpoint})`;
}
function getMouseFocusStyles(theme) {
  return {
    outline: "none",
    boxShadow: `none`
  };
}
function getFocusStyles(theme) {
  return {
    outline: "2px dotted transparent",
    outlineOffset: "2px",
    boxShadow: `0 0 0 2px ${theme.colors.background.canvas}, 0 0 0px 4px ${theme.colors.primary.main}`,
    transitionTimingFunction: `cubic-bezier(0.19, 1, 0.22, 1)`,
    transitionDuration: "0.2s",
    transitionProperty: "outline, outline-offset, box-shadow"
  };
}
const getTooltipContainerStyles = (theme) => ({
  overflow: "hidden",
  background: theme.colors.background.elevated,
  boxShadow: theme.shadows.z2,
  maxWidth: "800px",
  padding: theme.spacing(1),
  borderRadius: theme.shape.radius.default,
  zIndex: theme.zIndex.tooltip
});
const getInternalRadius = (theme, offset, additionalOptions = {}) => {
  const { parentBorderWidth = 1, parentBorderRadius } = additionalOptions;
  const parentBorderRadiusPx = parentBorderRadius !== void 0 ? `${parentBorderRadius}px` : theme.shape.radius.default;
  return `calc(max(0px, ${parentBorderRadiusPx} - ${offset}px - ${parentBorderWidth}px))`;
};

export { getFocusStyles, getInternalRadius, getMouseFocusStyles, getTooltipContainerStyles, hoverColor, mediaUp };
//# sourceMappingURL=mixins.mjs.map
