import { jsx } from 'react/jsx-runtime';
import { cx, css } from '@emotion/css';
import { formattedValueToString } from '@grafana/data';
import { TableCellDisplayMode } from '@grafana/schema';
import { useStyles2 } from '../../../../themes/ThemeContext.mjs';
import 'micro-memoize';
import '@emotion/react';
import 'tinycolor2';
import '../../../../utils/skeleton.mjs';
import { clearLinkButtonStyles } from '../../../Button/Button.mjs';
import '../../../Button/ButtonGroup.mjs';
import { DataLinksContextMenu } from '../../../DataLinks/DataLinksContextMenu.mjs';
import { getCellLinks } from '../utils.mjs';

function AutoCell({ value, field, justifyContent, rowIdx, cellOptions }) {
  var _a;
  const styles = useStyles2(getStyles, justifyContent);
  const displayValue = field.display(value);
  const formattedValue = formattedValueToString(displayValue);
  const hasLinks = Boolean((_a = getCellLinks(field, rowIdx)) == null ? void 0 : _a.length);
  const clearButtonStyle = useStyles2(clearLinkButtonStyles);
  return /* @__PURE__ */ jsx("div", { className: styles.cell, children: hasLinks ? /* @__PURE__ */ jsx(DataLinksContextMenu, { links: () => getCellLinks(field, rowIdx) || [], children: (api) => {
    if (api.openMenu) {
      return /* @__PURE__ */ jsx(
        "button",
        {
          className: cx(clearButtonStyle, getLinkStyle(styles, cellOptions, api.targetClassName)),
          onClick: api.openMenu,
          children: formattedValue
        }
      );
    } else {
      return /* @__PURE__ */ jsx("div", { className: getLinkStyle(styles, cellOptions, api.targetClassName), children: formattedValue });
    }
  } }) : formattedValue });
}
const getLinkStyle = (styles, cellOptions, targetClassName) => {
  if (cellOptions.type === TableCellDisplayMode.Auto) {
    return cx(styles.linkCell, targetClassName);
  }
  return cx(styles.cellLinkForColoredCell, targetClassName);
};
const getStyles = (theme, justifyContent) => ({
  cell: css({
    display: "flex",
    justifyContent,
    a: {
      color: "inherit"
    }
  }),
  cellLinkForColoredCell: css({
    cursor: "pointer",
    overflow: "hidden",
    textOverflow: "ellipsis",
    userSelect: "text",
    whiteSpace: "nowrap",
    fontWeight: theme.typography.fontWeightMedium,
    textDecoration: "underline"
  }),
  linkCell: css({
    cursor: "pointer",
    overflow: "hidden",
    textOverflow: "ellipsis",
    userSelect: "text",
    whiteSpace: "nowrap",
    color: theme.colors.text.link,
    fontWeight: theme.typography.fontWeightMedium,
    paddingRight: theme.spacing(1.5),
    a: {
      color: theme.colors.text.link
    },
    "&:hover": {
      textDecoration: "underline",
      color: theme.colors.text.link
    }
  })
});

export { AutoCell as default };
//# sourceMappingURL=AutoCell.mjs.map
