function isEqualityOrMultiOperator(value) {
  const operators = /* @__PURE__ */ new Set(["equals", "not-equals", "one-of", "not-one-of"]);
  return operators.has(value);
}
const scopeFilterOperatorMap = {
  "=": "equals",
  "!=": "not-equals",
  "=~": "regex-match",
  "!~": "regex-not-match",
  "=|": "one-of",
  "!=|": "not-one-of"
};
const reverseScopeFilterOperatorMap = Object.fromEntries(
  Object.entries(scopeFilterOperatorMap).map(([symbol, operator]) => [operator, symbol])
  // eslint-disable-next-line @typescript-eslint/consistent-type-assertions
);

export { isEqualityOrMultiOperator, reverseScopeFilterOperatorMap, scopeFilterOperatorMap };
//# sourceMappingURL=scopes.mjs.map
