import { jsx } from 'react/jsx-runtime';
import hoistNonReactStatics from 'hoist-non-react-statics';
import memoize from 'micro-memoize';
import { useContext } from 'react';
import { ThemeContext } from '@grafana/data';

const memoizedStyleCreators = /* @__PURE__ */ new WeakMap();
const withTheme2 = (Component) => {
  const WithTheme = (props) => {
    const ContextComponent = ThemeContext;
    return (
      // @ts-ignore
      /* @__PURE__ */ jsx(ContextComponent.Consumer, { children: (theme) => /* @__PURE__ */ jsx(Component, { ...props, theme }) })
    );
  };
  WithTheme.displayName = `WithTheme(${Component.displayName})`;
  hoistNonReactStatics(WithTheme, Component);
  return WithTheme;
};
function useTheme2() {
  return useContext(ThemeContext);
}
function useStyles2(getStyles, ...additionalArguments) {
  const theme = useTheme2();
  if (!theme.colors.background.elevated) {
    theme.colors.background.elevated = theme.colors.mode === "light" ? theme.colors.background.primary : theme.colors.background.secondary;
  }
  let memoizedStyleCreator = memoizedStyleCreators.get(getStyles);
  if (!memoizedStyleCreator) {
    memoizedStyleCreator = memoize(getStyles, { maxSize: 10 });
    memoizedStyleCreators.set(getStyles, memoizedStyleCreator);
  }
  return memoizedStyleCreator(theme, ...additionalArguments);
}

export { memoizedStyleCreators, useStyles2, useTheme2, withTheme2 };
//# sourceMappingURL=ThemeContext.mjs.map
