import { jsxs, Fragment, jsx } from 'react/jsx-runtime';
import { css, cx } from '@emotion/css';
import '@grafana/data';
import { useStyles2 } from '../../themes/ThemeContext.mjs';
import 'micro-memoize';
import '@emotion/react';
import 'tinycolor2';
import '../../utils/skeleton.mjs';
import { t } from '../../utils/i18n.mjs';
import { SeriesIcon } from '../VizLegend/SeriesIcon.mjs';

const getSeriesTableRowStyles = (theme) => {
  return {
    icon: css({
      marginRight: theme.spacing(1),
      verticalAlign: "middle"
    }),
    seriesTable: css({
      display: "table"
    }),
    seriesTableRow: css({
      display: "table-row",
      fontSize: theme.typography.bodySmall.fontSize
    }),
    seriesTableCell: css({
      display: "table-cell"
    }),
    label: css({
      wordBreak: "break-all"
    }),
    value: css({
      paddingLeft: theme.spacing(2),
      textAlign: "right"
    }),
    activeSeries: css({
      fontWeight: theme.typography.fontWeightBold,
      color: theme.colors.text.maxContrast
    }),
    timestamp: css({
      fontWeight: theme.typography.fontWeightBold,
      fontSize: theme.typography.bodySmall.fontSize
    })
  };
};
const SeriesTableRow = ({ color, label, value, isActive }) => {
  const styles = useStyles2(getSeriesTableRowStyles);
  return /* @__PURE__ */ jsxs("div", { "data-testid": "SeriesTableRow", className: cx(styles.seriesTableRow, isActive && styles.activeSeries), children: [
    color && /* @__PURE__ */ jsx("div", { className: styles.seriesTableCell, children: /* @__PURE__ */ jsx(SeriesIcon, { color, className: styles.icon }) }),
    label && /* @__PURE__ */ jsx("div", { className: cx(styles.seriesTableCell, styles.label), children: label }),
    value && /* @__PURE__ */ jsx("div", { className: cx(styles.seriesTableCell, styles.value), children: value })
  ] });
};
const SeriesTable = ({ timestamp, series }) => {
  const styles = useStyles2(getSeriesTableRowStyles);
  return /* @__PURE__ */ jsxs(Fragment, { children: [
    timestamp && /* @__PURE__ */ jsx("div", { className: styles.timestamp, "aria-label": t("grafana-ui.viz-tooltip.timestamp", "Timestamp"), children: timestamp }),
    series.map((s, i) => {
      return /* @__PURE__ */ jsx(
        SeriesTableRow,
        {
          isActive: s.isActive,
          label: s.label,
          color: s.color,
          value: s.value
        },
        `${s.label}-${i}`
      );
    })
  ] });
};

export { SeriesTable, SeriesTableRow };
//# sourceMappingURL=SeriesTable.mjs.map
