import 'react/jsx-runtime';
import 'react';
import '@grafana/e2e-selectors';
import '@emotion/css';
import '@tanstack/react-virtual';
import 'downshift';
import '@grafana/data';
import 'hoist-non-react-statics';
import 'micro-memoize';
import '@emotion/react';
import 'tinycolor2';
import '../../utils/skeleton.mjs';
import '../../utils/i18n.mjs';
import '../Icon/Icon.mjs';
import '../Input/AutoSizeInput.mjs';
import '../Input/Input.mjs';
import '../Portal/Portal.mjs';
import '../Forms/Checkbox.mjs';
import '../ScrollContainer/ScrollContainer.mjs';
import '../Layout/Box/Box.mjs';
import '../Layout/Stack/Stack.mjs';
import '../Text/Text.mjs';
import '../Combobox/filter.mjs';
import '@floating-ui/react';
import '../../utils/dom.mjs';
import '../../utils/colors.mjs';
import 'slate';
import 'lodash';
import '../../utils/logger.mjs';

function isWeekStart(value) {
  return ["saturday", "sunday", "monday"].includes(value);
}
function getWeekStart(override) {
  var _a, _b;
  if (override && isWeekStart(override)) {
    return override;
  }
  const preference = (_b = (_a = window == null ? void 0 : window.grafanaBootData) == null ? void 0 : _a.user) == null ? void 0 : _b.weekStart;
  if (preference && isWeekStart(preference)) {
    return preference;
  }
  return "monday";
}

export { getWeekStart, isWeekStart };
//# sourceMappingURL=WeekStartPicker.mjs.map
