import { jsx } from 'react/jsx-runtime';
import { css } from '@emotion/css';
import { memo } from 'react';
import '@grafana/data';
import { useStyles2 } from '../../../themes/ThemeContext.mjs';
import 'micro-memoize';
import '@emotion/react';
import 'tinycolor2';
import '../../../utils/skeleton.mjs';
import { TimePickerButtonLabel } from '../TimeRangePicker.mjs';
import { isValidTimeRange } from '../utils.mjs';

memo(function TimePickerLabel({
  hideText,
  value,
  timeZone = "browser",
  placeholder = "No time range selected",
  className
}) {
  const styles = useStyles2(getLabelStyles);
  if (hideText) {
    return null;
  }
  return /* @__PURE__ */ jsx("span", { className, children: isValidTimeRange(value) ? /* @__PURE__ */ jsx(TimePickerButtonLabel, { value, timeZone }) : /* @__PURE__ */ jsx("span", { className: styles.placeholder, children: placeholder }) });
});
const getLabelStyles = (theme) => {
  return {
    placeholder: css({
      color: theme.colors.text.disabled,
      opacity: 1
    })
  };
};
//# sourceMappingURL=TimeRangeLabel.mjs.map
