import { jsxs, jsx } from 'react/jsx-runtime';
import { css } from '@emotion/css';
import { useStyles2 } from '@grafana/ui';

const CHEAT_SHEET_ITEMS = [
  {
    title: "Request Rate",
    expression: "rate(http_request_total[5m])",
    label: "Given an HTTP request counter, this query calculates the per-second average request rate over the last 5 minutes."
  },
  {
    title: "95th Percentile of Request Latencies",
    expression: "histogram_quantile(0.95, sum(rate(prometheus_http_request_duration_seconds_bucket[5m])) by (le))",
    label: "Calculates the 95th percentile of HTTP request rate over 5 minute windows."
  },
  {
    title: "Alerts Firing",
    expression: 'sort_desc(sum(sum_over_time(ALERTS{alertstate="firing"}[24h])) by (alertname))',
    label: "Sums up the alerts that have been firing over the last 24 hours."
  },
  {
    title: "Step",
    label: "Defines the graph resolution using a duration format (15s, 1m, 3h, ...). Small steps create high-resolution graphs but can be slow over larger time ranges. Using a longer step lowers the resolution and smooths the graph by producing fewer datapoints. If no step is given the resolution is calculated automatically."
  }
];
const PromCheatSheet = (props) => {
  const styles = useStyles2(getStyles);
  return /* @__PURE__ */ jsxs("div", { children: [
    /* @__PURE__ */ jsx("h2", { children: "PromQL Cheat Sheet" }),
    CHEAT_SHEET_ITEMS.map((item, index) => /* @__PURE__ */ jsxs("div", { className: styles.cheatSheetItem, children: [
      /* @__PURE__ */ jsx("div", { className: styles.cheatSheetItemTitle, children: item.title }),
      item.expression ? /* @__PURE__ */ jsx(
        "button",
        {
          type: "button",
          className: styles.cheatSheetExample,
          onClick: (e) => props.onClickExample({ refId: "A", expr: item.expression }),
          children: /* @__PURE__ */ jsx("code", { children: item.expression })
        }
      ) : null,
      item.label
    ] }, index))
  ] });
};
const getStyles = (theme) => ({
  cheatSheetItem: css({
    margin: theme.spacing(3, 0)
  }),
  cheatSheetItemTitle: css({
    fontSize: theme.typography.h3.fontSize
  }),
  cheatSheetExample: css({
    margin: theme.spacing(0.5, 0),
    // element is interactive, clear button styles
    textAlign: "left",
    border: "none",
    background: "transparent",
    display: "block"
  })
});

export { PromCheatSheet };
//# sourceMappingURL=PromCheatSheet.mjs.map
