import { jsx } from 'react/jsx-runtime';
import { Icon } from '../../Icon/Icon.mjs';

function RowExpander({ row, tableStyles }) {
  return /* @__PURE__ */ jsx("div", { className: tableStyles.expanderCell, ...row.getToggleRowExpandedProps(), children: /* @__PURE__ */ jsx(
    Icon,
    {
      "aria-label": row.isExpanded ? "Collapse row" : "Expand row",
      name: row.isExpanded ? "angle-down" : "angle-right",
      size: "lg"
    }
  ) });
}

export { RowExpander };
//# sourceMappingURL=RowExpander.mjs.map
