import { jsxs, jsx } from 'react/jsx-runtime';
import { cx, css } from '@emotion/css';
import { useRef, useState, useMemo, useCallback } from 'react';
import '@grafana/data';
import { useStyles2 } from '../../../../themes/ThemeContext.mjs';
import 'micro-memoize';
import '@emotion/react';
import 'tinycolor2';
import '../../../../utils/skeleton.mjs';
import { Icon } from '../../../Icon/Icon.mjs';
import { Popover } from '../../../Tooltip/Popover.mjs';
import { REGEX_OPERATOR } from './FilterList.mjs';
import { FilterPopup } from './FilterPopup.mjs';

const Filter = ({ name, rows, filter, setFilter, field, crossFilterOrder, crossFilterRows }) => {
  var _a, _b, _c;
  const filterValue = (_a = filter[name]) == null ? void 0 : _a.filtered;
  const filterIndex = crossFilterOrder.indexOf(name);
  let filteredRows;
  if (filterIndex > 0) {
    const previousFilterName = crossFilterOrder[filterIndex - 1];
    filteredRows = crossFilterRows[previousFilterName];
  } else if (filterIndex === -1 && crossFilterOrder.length > 0) {
    const previousFilterName = crossFilterOrder[crossFilterOrder.length - 1];
    filteredRows = crossFilterRows[previousFilterName];
  } else {
    filteredRows = rows;
  }
  const ref = useRef(null);
  const [isPopoverVisible, setPopoverVisible] = useState(false);
  const styles = useStyles2(getStyles);
  const filterEnabled = useMemo(() => Boolean(filterValue), [filterValue]);
  const onShowPopover = useCallback(() => setPopoverVisible(true), [setPopoverVisible]);
  const onClosePopover = useCallback(() => setPopoverVisible(false), [setPopoverVisible]);
  const [searchFilter, setSearchFilter] = useState(((_b = filter[name]) == null ? void 0 : _b.searchFilter) || "");
  const [operator, setOperator] = useState(((_c = filter[name]) == null ? void 0 : _c.operator) || REGEX_OPERATOR);
  return /* @__PURE__ */ jsxs(
    "button",
    {
      className: cx(styles.headerFilter, filterEnabled ? styles.filterIconEnabled : styles.filterIconDisabled),
      ref,
      type: "button",
      onClick: onShowPopover,
      children: [
        /* @__PURE__ */ jsx(Icon, { name: "filter" }),
        isPopoverVisible && ref.current && /* @__PURE__ */ jsx(
          Popover,
          {
            content: /* @__PURE__ */ jsx(
              FilterPopup,
              {
                name,
                rows: filteredRows,
                filterValue,
                setFilter,
                field,
                onClose: onClosePopover,
                searchFilter,
                setSearchFilter,
                operator,
                setOperator
              }
            ),
            placement: "bottom-start",
            referenceElement: ref.current,
            show: true
          }
        )
      ]
    }
  );
};
const getStyles = (theme) => ({
  headerFilter: css({
    background: "transparent",
    border: "none",
    label: "headerFilter",
    padding: 0
  }),
  filterIconEnabled: css({
    label: "filterIconEnabled",
    color: theme.colors.primary.text
  }),
  filterIconDisabled: css({
    label: "filterIconDisabled",
    color: theme.colors.text.disabled
  })
});

export { Filter };
//# sourceMappingURL=Filter.mjs.map
