import { Registry } from '../utils/Registry.mjs';
import { createTheme } from './createTheme.mjs';
import * as index from './themeDefinitions/index.mjs';

var _a;
function getThemeById(id) {
  var _a2;
  const theme = (_a2 = themeRegistry.getIfExists(id)) != null ? _a2 : themeRegistry.get("dark");
  return theme.build();
}
function getBuiltInThemes(allowedExtras) {
  const themes = themeRegistry.list().filter((item) => {
    if (item.isExtra) {
      return allowedExtras.includes(item.id);
    }
    return true;
  });
  const sortedThemes = themes.sort((a, b) => {
    if (a.isExtra && !b.isExtra) {
      return 1;
    } else if (!a.isExtra && b.isExtra) {
      return -1;
    } else {
      return a.name.localeCompare(b.name);
    }
  });
  return sortedThemes;
}
const themeRegistry = new Registry(() => {
  return [
    { id: "system", name: "System preference", build: getSystemPreferenceTheme },
    { id: "dark", name: "Dark", build: () => createTheme({ colors: { mode: "dark" } }) },
    { id: "light", name: "Light", build: () => createTheme({ colors: { mode: "light" } }) }
  ];
});
for (const [id, theme] of Object.entries(index)) {
  themeRegistry.register({
    id,
    name: (_a = theme.name) != null ? _a : "",
    build: () => createTheme(theme),
    isExtra: true
  });
}
function getSystemPreferenceTheme() {
  const mediaResult = window.matchMedia("(prefers-color-scheme: dark)");
  const id = mediaResult.matches ? "dark" : "light";
  return getThemeById(id);
}

export { getBuiltInThemes, getThemeById };
//# sourceMappingURL=registry.mjs.map
