import { jsx, jsxs, Fragment } from 'react/jsx-runtime';
import { useCallback } from 'react';
import { DataHoverEvent, DataHoverClearEvent } from '@grafana/data';
import { LegendDisplayMode } from '@grafana/schema';
import '../PanelChrome/LoadingIndicator.mjs';
import '@emotion/css';
import 'react-use';
import '@grafana/e2e-selectors';
import 'hoist-non-react-statics';
import 'micro-memoize';
import '@emotion/react';
import 'tinycolor2';
import '../../utils/skeleton.mjs';
import '../../utils/dom.mjs';
import '../../utils/colors.mjs';
import 'slate';
import 'lodash';
import '../../utils/logger.mjs';
import '../ElementSelectionContext/ElementSelectionContext.mjs';
import '../Icon/Icon.mjs';
import '../Text/Text.mjs';
import '../Tooltip/Tooltip.mjs';
import '../../utils/i18n.mjs';
import '../Dropdown/Dropdown.mjs';
import '../ToolbarButton/ToolbarButton.mjs';
import '../ToolbarButton/ToolbarButtonRow.mjs';
import '../PanelChrome/TitleItem.mjs';
import { usePanelContext } from '../PanelChrome/PanelContext.mjs';
import { SeriesVisibilityChangeMode } from '../PanelChrome/types.mjs';
import { VizLegendList } from './VizLegendList.mjs';
import { VizLegendTable } from './VizLegendTable.mjs';
import { SeriesVisibilityChangeBehavior } from './types.mjs';
import { mapMouseEventToMode } from './utils.mjs';

function VizLegend({
  items,
  thresholdItems,
  mappingItems,
  displayMode,
  sortBy: sortKey,
  seriesVisibilityChangeBehavior = SeriesVisibilityChangeBehavior.Isolate,
  sortDesc,
  onLabelClick,
  onToggleSort,
  placement,
  className,
  itemRenderer,
  readonly,
  isSortable
}) {
  const { eventBus, onToggleSeriesVisibility, onToggleLegendSort } = usePanelContext();
  const onMouseOver = useCallback(
    (item, event) => {
      eventBus == null ? void 0 : eventBus.publish({
        type: DataHoverEvent.type,
        payload: {
          raw: event,
          x: 0,
          y: 0,
          dataId: item.label
        }
      });
    },
    [eventBus]
  );
  const onMouseOut = useCallback(
    (item, event) => {
      eventBus == null ? void 0 : eventBus.publish({
        type: DataHoverClearEvent.type,
        payload: {
          raw: event,
          x: 0,
          y: 0,
          dataId: item.label
        }
      });
    },
    [eventBus]
  );
  const onLegendLabelClick = useCallback(
    (item, event) => {
      var _a;
      if (onLabelClick) {
        onLabelClick(item, event);
      }
      if (onToggleSeriesVisibility) {
        onToggleSeriesVisibility(
          (_a = item.fieldName) != null ? _a : item.label,
          seriesVisibilityChangeBehavior === SeriesVisibilityChangeBehavior.Hide ? SeriesVisibilityChangeMode.AppendToSelection : mapMouseEventToMode(event)
        );
      }
    },
    [onToggleSeriesVisibility, onLabelClick, seriesVisibilityChangeBehavior]
  );
  const makeVizLegendList = useCallback(
    (items2) => {
      return /* @__PURE__ */ jsx(
        VizLegendList,
        {
          className,
          placement,
          onLabelMouseOver: onMouseOver,
          onLabelMouseOut: onMouseOut,
          onLabelClick: onLegendLabelClick,
          itemRenderer,
          readonly,
          items: items2
        }
      );
    },
    [className, placement, onMouseOver, onMouseOut, onLegendLabelClick, itemRenderer, readonly]
  );
  switch (displayMode) {
    case LegendDisplayMode.Table:
      return /* @__PURE__ */ jsx(
        VizLegendTable,
        {
          className,
          items,
          placement,
          sortBy: sortKey,
          sortDesc,
          onLabelClick: onLegendLabelClick,
          onToggleSort: onToggleSort || onToggleLegendSort,
          onLabelMouseOver: onMouseOver,
          onLabelMouseOut: onMouseOut,
          itemRenderer,
          readonly,
          isSortable
        }
      );
    case LegendDisplayMode.List:
      const isThresholdsEnabled = thresholdItems && thresholdItems.length > 1;
      const isValueMappingEnabled = mappingItems && mappingItems.length > 0;
      return /* @__PURE__ */ jsxs(Fragment, { children: [
        !isThresholdsEnabled && (!isValueMappingEnabled || items.length > 1) && makeVizLegendList(items),
        isThresholdsEnabled && makeVizLegendList(thresholdItems),
        isValueMappingEnabled && makeVizLegendList(mappingItems)
      ] });
    default:
      return null;
  }
}
VizLegend.displayName = "VizLegend";

export { VizLegend };
//# sourceMappingURL=VizLegend.mjs.map
