import { jsx, jsxs } from 'react/jsx-runtime';
import { cx, css } from '@emotion/css';
import { useMemo, useState, useCallback } from 'react';
import 'classnames';
import '../../Icon/Icon.mjs';
import '../../Tooltip/Tooltip.mjs';
import '../../Forms/Legacy/Input/Input.mjs';
import 'react-select';
import '../../Forms/Legacy/Select/Select.mjs';
import '../../Forms/Legacy/Switch/Switch.mjs';
import 'lodash';
import { Trans, t } from '../../../utils/i18n.mjs';
import { Button } from '../../Button/Button.mjs';
import { IconButton } from '../../IconButton/IconButton.mjs';
import '@grafana/data';
import { useTheme2, useStyles2 } from '../../../themes/ThemeContext.mjs';
import 'micro-memoize';
import '@emotion/react';
import 'tinycolor2';
import '../../../utils/skeleton.mjs';
import '../../Button/ButtonGroup.mjs';
import '@floating-ui/react';
import '../../Portal/Portal.mjs';
import '../../Toggletip/Toggletip.mjs';
import 'react-custom-scrollbars-2';
import '../../Tabs/Tab.mjs';
import '../../Tabs/TabsBar.mjs';
import '../../Layout/Box/Box.mjs';
import '../../ScrollContainer/ScrollContainer.mjs';
import '../../Cascader/Cascader.mjs';
import '../../Alert/Alert.mjs';
import 'rc-cascader';
import '../../Cascader/styles.mjs';
import 'react-inlinesvg';
import '../../../utils/keyframes.mjs';
import '../../ColorPicker/ColorPicker.mjs';
import '../../ColorPicker/ColorPickerInput.mjs';
import '../../ColorPicker/SeriesColorPickerPopover.mjs';
import { Stack } from '../../Layout/Stack/Stack.mjs';
import '../../Text/Text.mjs';
import '../../StatsPicker/StatsPicker.mjs';
import '../../RefreshPicker/RefreshPicker.mjs';
import '../../DateTimePickers/TimeRangePicker.mjs';
import '../../DateTimePickers/TimeRangeContext.mjs';
import '../../DateTimePickers/TimeRangePicker/TimeRangeLabel.mjs';
import 'rc-picker';
import 'rc-picker/lib/generate/moment';
import 'rc-picker/lib/locale/en_US';
import 'rc-picker/assets/index.css';
import 'react-select/async';
import 'react-select/async-creatable';
import 'react-select/creatable';
import '../../Select/IndicatorsContainer.mjs';
import '../../Select/InputControl.mjs';
import '../../Select/getSelectStyles.mjs';
import '../../Input/Input.mjs';
import '../../Select/SelectMenu.mjs';
import 'react-transition-group';
import '../../Select/ValueContainer.mjs';
import '@grafana/e2e-selectors';
import '@tanstack/react-virtual';
import 'downshift';
import '../../Input/AutoSizeInput.mjs';
import '../../Forms/Checkbox.mjs';
import '../../Combobox/filter.mjs';
import '../../../utils/dom.mjs';
import '../../../utils/colors.mjs';
import 'slate';
import '../../../utils/logger.mjs';
import '../../DateTimePickers/DatePicker/DatePicker.mjs';
import '../../DateTimePickers/DateTimePicker/DateTimePicker.mjs';
import '../../List/AbstractList.mjs';
import 'react-table';
import '../../InteractiveTable/Expander/index.mjs';
import '../../Forms/Field.mjs';
import '../../AutoSaveField/EllipsisAnimated.mjs';
import '../../Tags/Tag.mjs';
import '../../Tags/TagList.mjs';
import '../../Modal/Modal.mjs';
import 'react-hook-form';
import '../../QueryField/QueryField.mjs';
import '../../Monaco/CodeEditor.mjs';
import 'react-use';
import '../../ErrorBoundary/ErrorWithStack.mjs';
import '../../Modal/ModalsContext.mjs';
import '../../PageLayout/PageToolbar.mjs';
import 'rxjs';
import 'rxjs/operators';
import './Table.mjs';
import '@react-aria/dialog';
import '@react-aria/focus';
import '@react-aria/overlays';
import 'rc-drawer';
import 'rc-drawer/assets/index.css';
import '../../TableInputCSV/TableInputCSV.mjs';
import '../../Tabs/VerticalTab.mjs';
import '../../BigValue/BigValue.mjs';
import '../../Sparkline/Sparkline.mjs';
import '../../Gauge/Gauge.mjs';
import '../../BarGauge/BarGauge.mjs';
import '../../VizTooltip/VizTooltip.mjs';
import '../../VizTooltip/VizTooltipContainer.mjs';
import '../../VizLegend/SeriesIcon.mjs';
import '../../VizRepeater/VizRepeater.mjs';
import '../../PanelChrome/LoadingIndicator.mjs';
import '../../ElementSelectionContext/ElementSelectionContext.mjs';
import '../../Dropdown/Dropdown.mjs';
import '../../ToolbarButton/ToolbarButton.mjs';
import '../../ToolbarButton/ToolbarButtonRow.mjs';
import '../../PanelChrome/TitleItem.mjs';
import '../../PanelChrome/PanelContext.mjs';
import '../../VizLayout/VizLayout.mjs';
import '../../VizLegend/VizLegend.mjs';
import '../../VizLegend/VizLegendListItem.mjs';
import { ClickOutsideWrapper } from '../../ClickOutsideWrapper/ClickOutsideWrapper.mjs';
import '@grafana/schema';
import '../../ContextMenu/ContextMenu.mjs';
import '../../Menu/Menu.mjs';
import '../../Menu/MenuGroup.mjs';
import '../../Menu/MenuItem.mjs';
import '../../DataLinks/DataLinkEditor.mjs';
import '@hello-pangea/dnd';
import '../../Badge/Badge.mjs';
import '../../DataLinks/DataLinkInput.mjs';
import '../../InfoBox/InfoBox.mjs';
import '../../InfoBox/FeatureInfoBox.mjs';
import '../../JSONFormatter/JSONFormatter.mjs';
import '../../ErrorBoundary/ErrorBoundary.mjs';
import '../../Forms/InlineField.mjs';
import '../../Forms/RadioButtonGroup/RadioButton.mjs';
import '../../Switch/Switch.mjs';
import '../../TextArea/TextArea.mjs';
import 'react-use/lib/useClickAway';
import 'rc-slider';
import 'rc-slider/assets/index.css';
import 'rc-tooltip';
import '../../MatchersUI/fieldMatchersUI.mjs';
import '../../Link/Link.mjs';
import '../../Link/TextLink.mjs';
import '../../Layout/Grid/Grid.mjs';
import { Label } from '../../Forms/Label.mjs';
import '../../Combobox/ValuePill.mjs';
import '../../FilterInput/FilterInput.mjs';
import 'uuid';
import 'react-dropzone';
import '../../DateTimePickers/TimeRangePicker/TimePickerContent.mjs';
import '../../DateTimePickers/RelativeTimeRangePicker/RelativeTimeRangePicker.mjs';
import '../../Card/Card.mjs';
import '../../FormattedValueDisplay/FormattedValueDisplay.mjs';
import '../../Dropdown/ButtonSelect.mjs';
import '../../PluginSignatureBadge/PluginSignatureBadge.mjs';
import '../../uPlot/config.mjs';
import 'uplot';
import '../../uPlot/utils.mjs';
import 'uplot/dist/uPlot.min.css';
import '../../uPlot/PlotLegend.mjs';
import 'react-dom';
import '../../BrowserLabel/Label.mjs';
import '../../../graveyard/Graph/Graph.mjs';
import '../../../graveyard/GraphNG/GraphNG.mjs';
import '../../../graveyard/TimeSeries/TimeSeries.mjs';
import '../../../graveyard/GraphNG/hooks.mjs';
import { calculateUniqueFieldValues, valuesToOptions, getFilteredOptions } from '../utils.mjs';
import { FilterList } from './FilterList.mjs';

const FilterPopup = ({
  column: { preFilteredRows, filterValue, setFilter },
  onClose,
  field,
  searchFilter,
  setSearchFilter,
  operator,
  setOperator
}) => {
  const theme = useTheme2();
  const uniqueValues = useMemo(() => calculateUniqueFieldValues(preFilteredRows, field), [preFilteredRows, field]);
  const options = useMemo(() => valuesToOptions(uniqueValues), [uniqueValues]);
  const filteredOptions = useMemo(() => getFilteredOptions(options, filterValue), [options, filterValue]);
  const [values, setValues] = useState(filteredOptions);
  const [matchCase, setMatchCase] = useState(false);
  const onCancel = useCallback((event) => onClose(), [onClose]);
  const onFilter = useCallback(
    (event) => {
      const filtered = values.length ? values : void 0;
      setFilter(filtered);
      onClose();
    },
    [setFilter, values, onClose]
  );
  const onClearFilter = useCallback(
    (event) => {
      setFilter(void 0);
      onClose();
    },
    [setFilter, onClose]
  );
  const clearFilterVisible = useMemo(() => filterValue !== void 0, [filterValue]);
  const styles = useStyles2(getStyles);
  return /* @__PURE__ */ jsx(ClickOutsideWrapper, { onClick: onCancel, useCapture: true, children: /* @__PURE__ */ jsx("div", { className: cx(styles.filterContainer), onClick: stopPropagation, children: /* @__PURE__ */ jsxs(Stack, { direction: "column", gap: 3, children: [
    /* @__PURE__ */ jsxs(Stack, { direction: "column", gap: 0.5, children: [
      /* @__PURE__ */ jsxs(Stack, { justifyContent: "space-between", alignItems: "center", children: [
        /* @__PURE__ */ jsx(Label, { className: styles.label, children: /* @__PURE__ */ jsx(Trans, { i18nKey: "grafana-ui.table.filter-popup-heading", children: "Filter by values:" }) }),
        /* @__PURE__ */ jsx(
          IconButton,
          {
            name: "text-fields",
            tooltip: t("grafana-ui.table.filter-popup-match-case", "Match case"),
            style: { color: matchCase ? theme.colors.text.link : theme.colors.text.disabled },
            onClick: () => {
              setMatchCase((s) => !s);
            }
          }
        )
      ] }),
      /* @__PURE__ */ jsx("div", { className: cx(styles.listDivider) }),
      /* @__PURE__ */ jsx(
        FilterList,
        {
          onChange: setValues,
          values,
          options,
          caseSensitive: matchCase,
          showOperators: true,
          searchFilter,
          setSearchFilter,
          operator,
          setOperator
        }
      )
    ] }),
    /* @__PURE__ */ jsxs(Stack, { gap: 3, children: [
      /* @__PURE__ */ jsxs(Stack, { children: [
        /* @__PURE__ */ jsx(Button, { size: "sm", onClick: onFilter, children: /* @__PURE__ */ jsx(Trans, { i18nKey: "grafana-ui.table.filter-popup-apply", children: "Ok" }) }),
        /* @__PURE__ */ jsx(Button, { size: "sm", variant: "secondary", onClick: onCancel, children: /* @__PURE__ */ jsx(Trans, { i18nKey: "grafana-ui.table.filter-popup-cancel", children: "Cancel" }) })
      ] }),
      clearFilterVisible && /* @__PURE__ */ jsx(Stack, { children: /* @__PURE__ */ jsx(Button, { fill: "text", size: "sm", onClick: onClearFilter, children: /* @__PURE__ */ jsx(Trans, { i18nKey: "grafana-ui.table.filter-popup-clear", children: "Clear filter" }) }) })
    ] })
  ] }) }) });
};
const getStyles = (theme) => ({
  filterContainer: css({
    label: "filterContainer",
    width: "100%",
    minWidth: "250px",
    height: "100%",
    maxHeight: "400px",
    backgroundColor: theme.colors.background.primary,
    border: `1px solid ${theme.colors.border.weak}`,
    padding: theme.spacing(2),
    boxShadow: theme.shadows.z3,
    borderRadius: theme.shape.radius.default
  }),
  listDivider: css({
    label: "listDivider",
    width: "100%",
    borderTop: `1px solid ${theme.colors.border.medium}`,
    padding: theme.spacing(0.5, 2)
  }),
  label: css({
    marginBottom: 0
  })
});
const stopPropagation = (event) => {
  event.stopPropagation();
};

export { FilterPopup };
//# sourceMappingURL=FilterPopup.mjs.map
