import { jsxs, jsx } from 'react/jsx-runtime';
import { Icon } from '../Icon/Icon.mjs';

const PercentChange = ({ percentChange, styles }) => {
  let percentChangeIcon = void 0;
  if (percentChange > 0) {
    percentChangeIcon = "arrow-up";
  } else if (percentChange < 0) {
    percentChangeIcon = "arrow-down";
  }
  return /* @__PURE__ */ jsxs("div", { style: styles.containerStyles, children: [
    percentChangeIcon && /* @__PURE__ */ jsx(Icon, { name: percentChangeIcon, height: styles.iconSize, width: styles.iconSize, viewBox: "6 6 12 12" }),
    percentChangeString(percentChange)
  ] });
};
const percentChangeString = (percentChange) => {
  return (percentChange / 100).toLocaleString(void 0, { style: "percent", maximumSignificantDigits: 3 });
};

export { PercentChange, percentChangeString };
//# sourceMappingURL=PercentChange.mjs.map
