import { escapeLabelValueInRegexSelector, escapeLabelValueInExactSelector } from '../../language_utils.mjs';
import { utf8Support, isValidLegacyName } from '../../utf8_support.mjs';
import { METRIC_LABEL } from './types.mjs';

function buildSelector(labels) {
  let singleMetric = "";
  const selectedLabels = [];
  for (const label of labels) {
    if ((label.name === METRIC_LABEL || label.selected) && label.values && label.values.length > 0) {
      const selectedValues = label.values.filter((value) => value.selected).map((value) => value.name);
      if (selectedValues.length > 1) {
        selectedLabels.push(
          `${utf8Support(label.name)}=~"${selectedValues.map(escapeLabelValueInRegexSelector).join("|")}"`
        );
      } else if (selectedValues.length === 1) {
        if (label.name === METRIC_LABEL) {
          singleMetric = selectedValues[0];
        } else {
          selectedLabels.push(`${utf8Support(label.name)}="${escapeLabelValueInExactSelector(selectedValues[0])}"`);
        }
      }
    }
  }
  const selectorParts = [];
  const isLegacyName = singleMetric === "" || isValidLegacyName(singleMetric);
  if (isLegacyName) {
    selectorParts.push(singleMetric, "{");
  } else {
    selectorParts.push("{", `"${singleMetric}"`);
    if (selectedLabels.length > 0) {
      selectorParts.push(",");
    }
  }
  selectorParts.push(selectedLabels.join(","), "}");
  return selectorParts.join("");
}
function facetLabels(labels, possibleLabels, lastFacetted) {
  return labels.map((label) => {
    var _a;
    const possibleValues = possibleLabels[label.name];
    if (possibleValues) {
      let existingValues;
      if (label.name === lastFacetted && label.values) {
        existingValues = label.values;
      } else {
        const selectedValues = new Set(
          ((_a = label.values) == null ? void 0 : _a.filter((value) => value.selected).map((value) => value.name)) || []
        );
        existingValues = possibleValues.map((value) => ({ name: value, selected: selectedValues.has(value) }));
      }
      return {
        ...label,
        loading: false,
        values: existingValues,
        hidden: !possibleValues,
        facets: existingValues.length
      };
    }
    return { ...label, loading: false, hidden: !possibleValues, values: void 0, facets: 0 };
  });
}

export { buildSelector, facetLabels };
//# sourceMappingURL=selectorBuilder.mjs.map
