import { jsx } from 'react/jsx-runtime';
import { useCallback, useEffect } from 'react';
import { usePrevious } from 'react-use';
import { useTimeRangeContext } from '../TimeRangeContext.mjs';
import { TimeSyncButton } from '../TimeSyncButton.mjs';

function useTimeSync(options) {
  const { value, onChangeProp, isSyncedProp, initialIsSynced, timeSyncButtonProp } = options;
  const timeRangeContext = useTimeRangeContext(initialIsSynced && value ? value : undefined);
  const timeRangeContextSynced = timeRangeContext == null ? undefined : timeRangeContext.synced;
  const timeRangeContextSyncedValue = timeRangeContext == null ? undefined : timeRangeContext.syncedValue;
  const timeRangeContextSyncFunc = timeRangeContext == null ? undefined : timeRangeContext.sync;
  const usingTimeRangeContext = Boolean(options.isSyncedProp === undefined && timeRangeContext);
  const onChangeWithSync = useCallback(
    (timeRange) => {
      onChangeProp(timeRange);
      if (usingTimeRangeContext && timeRangeContextSynced) {
        timeRangeContextSyncFunc == null ? undefined : timeRangeContextSyncFunc(timeRange);
      }
    },
    [onChangeProp, usingTimeRangeContext, timeRangeContextSyncFunc, timeRangeContextSynced]
  );
  const prevValue = usePrevious(value);
  const prevSyncedValue = usePrevious(timeRangeContext == null ? undefined : timeRangeContext.syncedValue);
  useEffect(() => {
    if (usingTimeRangeContext && timeRangeContextSynced) {
      if (value !== prevValue && value !== timeRangeContextSyncedValue) {
        timeRangeContextSyncFunc == null ? undefined : timeRangeContextSyncFunc(value);
      } else if (timeRangeContextSyncedValue && timeRangeContextSyncedValue !== prevSyncedValue && timeRangeContextSyncedValue !== value) {
        onChangeProp(timeRangeContextSyncedValue);
      }
    }
  }, [
    usingTimeRangeContext,
    timeRangeContextSynced,
    timeRangeContextSyncedValue,
    timeRangeContextSyncFunc,
    prevSyncedValue,
    value,
    prevValue,
    onChangeProp
  ]);
  const isSynced = usingTimeRangeContext ? timeRangeContext == null ? undefined : timeRangeContext.synced : isSyncedProp;
  const button = usingTimeRangeContext ? (timeRangeContext == null ? undefined : timeRangeContext.syncPossible) && /* @__PURE__ */ jsx(
    TimeSyncButton,
    {
      isSynced: timeRangeContext == null ? undefined : timeRangeContext.synced,
      onClick: () => (timeRangeContext == null ? undefined : timeRangeContext.synced) ? timeRangeContext.unSync() : timeRangeContext.sync(value)
    }
  ) : timeSyncButtonProp;
  return {
    onChangeWithSync,
    isSynced,
    timeSyncButton: button
  };
}

export { useTimeSync };
//# sourceMappingURL=useTimeSync.mjs.map
