import { useMemo } from 'react';
import { isPluginExtensionLink, isPluginExtensionComponent } from './utils.mjs';

let singleton;
function setPluginExtensionsHook(hook) {
  if (singleton && process.env.NODE_ENV !== "test") {
    throw new Error("setPluginExtensionsHook() function should only be called once, when Grafana is starting.");
  }
  singleton = hook;
}
function usePluginExtensions(options) {
  if (!singleton) {
    throw new Error("usePluginExtensions(options) can only be used after the Grafana instance has started.");
  }
  return singleton(options);
}
function usePluginLinkExtensions(options) {
  const { extensions, isLoading } = usePluginExtensions(options);
  return useMemo(() => {
    return {
      extensions: extensions.filter(isPluginExtensionLink),
      isLoading
    };
  }, [extensions, isLoading]);
}
function usePluginComponentExtensions(options) {
  const { extensions, isLoading } = usePluginExtensions(options);
  return useMemo(
    () => ({
      extensions: extensions.filter(isPluginExtensionComponent),
      isLoading
    }),
    [extensions, isLoading]
  );
}

export { setPluginExtensionsHook, usePluginComponentExtensions, usePluginExtensions, usePluginLinkExtensions };
//# sourceMappingURL=usePluginExtensions.mjs.map
