import { createContext, useContext, useCallback } from 'react';

const ElementSelectionContext = createContext(undefined);
function useElementSelection(id) {
  if (!id) {
    return {};
  }
  const context = useContext(ElementSelectionContext);
  if (!context) {
    return {};
  }
  const isSelected = context.selected.some((item) => item.id === id);
  const onSelect = useCallback(
    (evt) => {
      if (!context.enabled) {
        return;
      }
      evt.stopPropagation();
      context.onSelect({ id }, evt.shiftKey);
    },
    [context, id]
  );
  return { isSelected, onSelect, isSelectable: context.enabled };
}

export { ElementSelectionContext, useElementSelection };
//# sourceMappingURL=ElementSelectionContext.mjs.map
