import { jsxs, Fragment, jsx } from 'react/jsx-runtime';
import { createSlice } from '@reduxjs/toolkit';
import { useReducer, useEffect } from 'react';
import { promQueryModeller } from '../PromQueryModeller.mjs';
import { buildVisualQueryFromString } from '../parsing.mjs';
import { PromQueryBuilder } from './PromQueryBuilder.mjs';
import { QueryPreview } from './QueryPreview.mjs';
import { getSettings } from './metrics-modal/state/state.mjs';

function PromQueryBuilderContainer(props) {
  const { query, onChange, onRunQuery, datasource, data, showExplain } = props;
  const [state, dispatch] = useReducer(stateSlice.reducer, { expr: query.expr });
  useEffect(() => {
    var _a, _b, _c, _d;
    dispatch(exprChanged(query.expr));
    dispatch(
      setMetricsModalSettings({
        useBackend: (_a = query.useBackend) != null ? _a : false,
        disableTextWrap: (_b = query.disableTextWrap) != null ? _b : false,
        fullMetaSearch: (_c = query.fullMetaSearch) != null ? _c : false,
        includeNullMetadata: (_d = query.includeNullMetadata) != null ? _d : true
      })
    );
  }, [query]);
  useEffect(() => {
    datasource.languageProvider.start(data == null ? undefined : data.timeRange);
  }, [data == null ? undefined : data.timeRange, datasource.languageProvider]);
  const onVisQueryChange = (visQuery) => {
    const expr = promQueryModeller.renderQuery(visQuery);
    dispatch(visualQueryChange({ visQuery, expr }));
    const metricsModalSettings = getSettings(visQuery);
    onChange({ ...props.query, expr, ...metricsModalSettings });
  };
  if (!state.visQuery) {
    return null;
  }
  return /* @__PURE__ */ jsxs(Fragment, { children: [
    /* @__PURE__ */ jsx(
      PromQueryBuilder,
      {
        query: state.visQuery,
        datasource,
        onChange: onVisQueryChange,
        onRunQuery,
        data,
        showExplain
      }
    ),
    /* @__PURE__ */ jsx(QueryPreview, { query: query.expr })
  ] });
}
const initialState = {
  expr: ""
};
const stateSlice = createSlice({
  name: "prom-builder-container",
  initialState,
  reducers: {
    visualQueryChange: (state, action) => {
      state.expr = action.payload.expr;
      state.visQuery = action.payload.visQuery;
    },
    exprChanged: (state, action) => {
      var _a;
      if (!state.visQuery || state.expr !== action.payload) {
        state.expr = action.payload;
        const parseResult = buildVisualQueryFromString((_a = action.payload) != null ? _a : "");
        state.visQuery = parseResult.query;
      }
    },
    setMetricsModalSettings: (state, action) => {
      if (state.visQuery) {
        state.visQuery.useBackend = action.payload.useBackend;
        state.visQuery.disableTextWrap = action.payload.disableTextWrap;
        state.visQuery.fullMetaSearch = action.payload.fullMetaSearch;
        state.visQuery.includeNullMetadata = action.payload.includeNullMetadata;
      }
    }
  }
});
const { visualQueryChange, exprChanged, setMetricsModalSettings } = stateSlice.actions;

export { PromQueryBuilderContainer };
//# sourceMappingURL=PromQueryBuilderContainer.mjs.map
