import { map } from 'rxjs/operators';
import { getFieldMatcher, getFrameMatchers } from '../matchers.mjs';
import { DataTransformerID } from './ids.mjs';
import { noopTransformer } from './noop.mjs';

const filterFieldsTransformer = {
  id: DataTransformerID.filterFields,
  name: "Filter Fields",
  description: "select a subset of fields",
  defaultOptions: {},
  /**
   * Return a modified copy of the series. If the transform is not or should not
   * be applied, just return the input series
   */
  operator: (options, ctx) => (source) => {
    var _a, _b, _c, _d, _e, _f, _g, _h, _i, _j;
    if (!options.include && !options.exclude) {
      return source.pipe(noopTransformer.operator({}, ctx));
    }
    if (typeof ((_a = options.include) == null ? undefined : _a.options) === "string") {
      options.include.options = (_b = options.include) == null ? undefined : _b.options;
    } else if (typeof ((_d = (_c = options.include) == null ? undefined : _c.options) == null ? undefined : _d.pattern) === "string") {
      options.include.options.pattern = (_e = options.include) == null ? undefined : _e.options.pattern;
    }
    if (typeof ((_f = options.exclude) == null ? undefined : _f.options) === "string") {
      options.exclude.options = (_g = options.exclude) == null ? undefined : _g.options;
    } else if (typeof ((_i = (_h = options.exclude) == null ? undefined : _h.options) == null ? undefined : _i.pattern) === "string") {
      options.exclude.options.pattern = (_j = options.exclude) == null ? undefined : _j.options.pattern;
    }
    return source.pipe(
      map((data) => {
        const include = options.include ? getFieldMatcher(options.include) : null;
        const exclude = options.exclude ? getFieldMatcher(options.exclude) : null;
        const processed = [];
        for (const series of data) {
          const fields = [];
          for (let i = 0; i < series.fields.length; i++) {
            const field = series.fields[i];
            if (exclude) {
              if (exclude(field, series, data)) {
                continue;
              }
              if (!include) {
                fields.push(field);
              }
            }
            if (include && include(field, series, data)) {
              fields.push(field);
            }
          }
          if (!fields.length) {
            continue;
          }
          const copy = {
            ...series,
            // all the other properties
            fields
            // but a different set of fields
          };
          processed.push(copy);
        }
        return processed;
      })
    );
  }
};
const filterFramesTransformer = {
  id: DataTransformerID.filterFrames,
  name: "Filter Frames",
  description: "select a subset of frames",
  defaultOptions: {},
  /**
   * Return a modified copy of the series. If the transform is not or should not
   * be applied, just return the input series
   */
  operator: (options, ctx) => (source) => {
    if (!options.include && !options.exclude) {
      return source.pipe(noopTransformer.operator({}, ctx));
    }
    return source.pipe(
      map((data) => {
        const include = options.include ? getFrameMatchers(options.include) : null;
        const exclude = options.exclude ? getFrameMatchers(options.exclude) : null;
        const processed = [];
        for (const series of data) {
          if (exclude) {
            if (exclude(series)) {
              continue;
            }
            if (!include) {
              processed.push(series);
            }
          }
          if (include && include(series)) {
            processed.push(series);
          }
        }
        return processed;
      })
    );
  }
};

export { filterFieldsTransformer, filterFramesTransformer };
//# sourceMappingURL=filter.mjs.map
