import { jsx, jsxs } from 'react/jsx-runtime';
import { css } from '@emotion/css';
import { capitalize } from 'lodash';
import { formattedValueToString } from '@grafana/data';
import { useStyles2 } from '../../themes/ThemeContext.mjs';
import { InlineList } from '../List/InlineList.mjs';

const VizLegendStatsList = ({ stats }) => {
  const styles = useStyles2(getStyles);
  if (stats.length === 0) {
    return null;
  }
  return /* @__PURE__ */ jsx(
    InlineList,
    {
      className: styles.list,
      items: stats,
      renderItem: (stat) => /* @__PURE__ */ jsxs("div", { className: styles.item, title: stat.description, children: [
        stat.title && `${capitalize(stat.title)}:`,
        " ",
        formattedValueToString(stat)
      ] })
    }
  );
};
const getStyles = () => ({
  list: css({
    flexGrow: 1,
    textAlign: "right"
  }),
  item: css({
    marginLeft: "8px"
  })
});
VizLegendStatsList.displayName = "VizLegendStatsList";

export { VizLegendStatsList };
//# sourceMappingURL=VizLegendStatsList.mjs.map
