import { jsxs, jsx } from 'react/jsx-runtime';
import { css } from '@emotion/css';
import { uniqueId } from 'lodash';
import '@grafana/data';
import { useStyles2 } from '../../themes/ThemeContext.mjs';
import 'micro-memoize';
import '@emotion/react';
import 'tinycolor2';
import '../../utils/skeleton.mjs';

const MenuGroup = ({ label, ariaLabel, children }) => {
  const styles = useStyles2(getStyles);
  const labelID = `group-label-${uniqueId()}`;
  return /* @__PURE__ */ jsxs("div", { role: "group", "aria-labelledby": !ariaLabel && label ? labelID : undefined, "aria-label": ariaLabel, children: [
    label && /* @__PURE__ */ jsx("label", { id: labelID, className: styles.groupLabel, "aria-hidden": true, children: label }),
    children
  ] });
};
MenuGroup.displayName = "MenuGroup";
const getStyles = (theme) => {
  return {
    groupLabel: css({
      color: theme.colors.text.secondary,
      fontSize: theme.typography.size.sm,
      padding: theme.spacing(0.5, 1)
    })
  };
};

export { MenuGroup };
//# sourceMappingURL=MenuGroup.mjs.map
