import { jsx, jsxs } from 'react/jsx-runtime';
import { components } from 'react-select';
import { Icon } from '../../../Icon/Icon.mjs';

const SelectOption = (props) => {
  const { children, isSelected, data } = props;
  return /* @__PURE__ */ jsx(components.Option, { ...props, children: /* @__PURE__ */ jsxs("div", { className: "gf-form-select-box__desc-option", children: [
    data.imgUrl && /* @__PURE__ */ jsx("img", { className: "gf-form-select-box__desc-option__img", src: data.imgUrl, alt: "" }),
    /* @__PURE__ */ jsxs("div", { className: "gf-form-select-box__desc-option__body", children: [
      /* @__PURE__ */ jsx("div", { children }),
      data.description && /* @__PURE__ */ jsx("div", { className: "gf-form-select-box__desc-option__desc", children: data.description })
    ] }),
    isSelected && /* @__PURE__ */ jsx(Icon, { name: "check", "aria-hidden": "true" })
  ] }) });
};

export { SelectOption, SelectOption as default };
//# sourceMappingURL=SelectOption.mjs.map
