import { useRef, useState, useLayoutEffect } from 'react';
import '../../utils/dom.mjs';
import '../../utils/colors.mjs';
import 'slate';
import { measureText } from '../../utils/measureText.mjs';
import 'lodash';
import '../../utils/logger.mjs';

function useMultiInputAutoSize(inputValue) {
  const inputRef = useRef(null);
  const initialInputWidth = useRef(0);
  const [inputWidth, setInputWidth] = useState("");
  useLayoutEffect(() => {
    if (inputRef.current && inputValue == null && initialInputWidth.current === 0) {
      initialInputWidth.current = inputRef == null ? undefined : inputRef.current.getBoundingClientRect().width;
    }
    if (!inputRef.current || inputValue == null) {
      setInputWidth("");
      return;
    }
    const fontSize = window.getComputedStyle(inputRef.current).fontSize;
    const textWidth = measureText(inputRef.current.value || "", parseInt(fontSize, 10)).width;
    if (textWidth < initialInputWidth.current) {
      setInputWidth("");
    } else {
      setInputWidth(`${textWidth + 5}px`);
    }
  }, [inputValue]);
  return { inputRef, inputWidth };
}

export { useMultiInputAutoSize };
//# sourceMappingURL=useMultiInputAutoSize.mjs.map
