import { jsx } from 'react/jsx-runtime';
import '@grafana/data';
import { withTheme2 } from '../../themes/ThemeContext.mjs';
import 'micro-memoize';
import '@emotion/react';
import 'tinycolor2';
import '../../utils/skeleton.mjs';
import { t } from '../../utils/i18n.mjs';
import { InlineField } from '../Forms/InlineField.mjs';
import { InlineSwitch } from '../Switch/Switch.mjs';
import { ColorPickerPopover } from './ColorPickerPopover.mjs';

const SeriesColorPickerPopover = (props) => {
  const { yaxis, onToggleAxis, color, ...colorPickerProps } = props;
  const yAxisLabel = t("grafana-ui.series-color-picker-popover.y-axis-usage", "Use right y-axis");
  const customPickers = onToggleAxis ? {
    yaxis: {
      name: "Y-Axis",
      tabComponent() {
        return /* @__PURE__ */ jsx(InlineField, { labelWidth: 20, label: yAxisLabel, children: /* @__PURE__ */ jsx(InlineSwitch, { value: yaxis === 2, label: yAxisLabel, onChange: onToggleAxis }) });
      }
    }
  } : undefined;
  return /* @__PURE__ */ jsx(ColorPickerPopover, { ...colorPickerProps, color: color || "#000000", customPickers });
};
const SeriesColorPickerPopoverWithTheme = withTheme2(SeriesColorPickerPopover);

export { SeriesColorPickerPopover, SeriesColorPickerPopoverWithTheme };
//# sourceMappingURL=SeriesColorPickerPopover.mjs.map
